/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="StructureMap", profile="http://hl7.org/fhir/Profile/StructureMap")
public class StructureMap
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Absolute URL used to reference this StructureMap", formalDefinition="An absolute URL that is used to identify this structure map when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this structure map is (or will be) published.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other identifiers for the StructureMap", formalDefinition="Formal identifier that is used to identify this StructureMap when it is represented in other formats, or referenced in a specification, model, design or an instance  (should be globally unique OID, UUID, or URI), (if it's not possible to use the literal URI).")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id for this version of the StructureMap", formalDefinition="The identifier that is used to identify this version of the StructureMap when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the StructureMap author manually.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this StructureMap", formalDefinition="A free text natural language name identifying the StructureMap.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the StructureMap.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This StructureMap was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the structure map.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<StructureMapContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date for this version of the StructureMap", formalDefinition="The date this version of the structure map was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the structure map changes.")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the StructureMap", formalDefinition="A free text natural language description of the StructureMap and its use.")
    protected StringType description;
    @Child(name="useContext", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of structure maps.")
    protected List<CodeableConcept> useContext;
    @Child(name="requirements", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Scope and Usage this structure map is for", formalDefinition="Explains why this structure map is needed and why it's been designed as it has.")
    protected StringType requirements;
    @Child(name="copyright", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the structure map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings.")
    protected StringType copyright;
    @Child(name="structure", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Structure Definition used by this map", formalDefinition="A structure definition used by this map. The structure definition may describe instances that are converted, or the instances that are produced.")
    protected List<StructureMapStructureComponent> structure;
    @Child(name="import", type={UriType.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other maps used by this map (canonical URLs)", formalDefinition="Other maps used by this map (canonical URLs).")
    protected List<UriType> import_;
    @Child(name="group", type={}, order=15, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Named sections for reader convenience", formalDefinition="Named sections for reader convenience.")
    protected List<StructureMapGroupComponent> group;
    private static final long serialVersionUID = 710892955L;
    @SearchParamDefinition(name="status", path="StructureMap.status", description="The current status of the profile", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="StructureMap.description", description="Text search in the description of the profile", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="name", path="StructureMap.name", description="Name of the profile", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="StructureMap.useContext", description="A use context assigned to the structure", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="experimental", path="StructureMap.experimental", description="Whether the map is defined purely for experimental reasons", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="date", path="StructureMap.date", description="The profile publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="StructureMap.identifier", description="The identifier of the profile", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="url", path="StructureMap.url", description="The url that identifies the structure map", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="publisher", path="StructureMap.publisher", description="Name of the publisher of the profile", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="version", path="StructureMap.version", description="The version identifier of the profile", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public StructureMap() {
    }

    public StructureMap(UriType url, StringType name, Enumeration<Enumerations.ConformanceResourceStatus> status) {
        this.url = url;
        this.name = name;
        this.status = status;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public StructureMap setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public StructureMap setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public StructureMap addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public StructureMap setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public StructureMap setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public StructureMap setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public StructureMap setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public StructureMap setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public StructureMap setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public StructureMap setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public StructureMap setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public StructureMap setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public StructureMap setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<StructureMapContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<StructureMapContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (StructureMapContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StructureMapContactComponent addContact() {
        StructureMapContactComponent t = new StructureMapContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<StructureMapContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public StructureMap addContact(StructureMapContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<StructureMapContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public StructureMap setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public StructureMap setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public StructureMap setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public StructureMap setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public StructureMap addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public StructureMap setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public StructureMap setRequirements(String value) {
        if (Utilities.noString((String)value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public StructureMap setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public StructureMap setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<StructureMapStructureComponent> getStructure() {
        if (this.structure == null) {
            this.structure = new ArrayList<StructureMapStructureComponent>();
        }
        return this.structure;
    }

    public boolean hasStructure() {
        if (this.structure == null) {
            return false;
        }
        for (StructureMapStructureComponent item : this.structure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StructureMapStructureComponent addStructure() {
        StructureMapStructureComponent t = new StructureMapStructureComponent();
        if (this.structure == null) {
            this.structure = new ArrayList<StructureMapStructureComponent>();
        }
        this.structure.add(t);
        return t;
    }

    public StructureMap addStructure(StructureMapStructureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.structure == null) {
            this.structure = new ArrayList<StructureMapStructureComponent>();
        }
        this.structure.add(t);
        return this;
    }

    public List<UriType> getImport() {
        if (this.import_ == null) {
            this.import_ = new ArrayList<UriType>();
        }
        return this.import_;
    }

    public boolean hasImport() {
        if (this.import_ == null) {
            return false;
        }
        for (UriType item : this.import_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addImportElement() {
        UriType t = new UriType();
        if (this.import_ == null) {
            this.import_ = new ArrayList<UriType>();
        }
        this.import_.add(t);
        return t;
    }

    public StructureMap addImport(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.import_ == null) {
            this.import_ = new ArrayList<UriType>();
        }
        this.import_.add(t);
        return this;
    }

    public boolean hasImport(String value) {
        if (this.import_ == null) {
            return false;
        }
        for (UriType v : this.import_) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StructureMapGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<StructureMapGroupComponent>();
        }
        return this.group;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (StructureMapGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StructureMapGroupComponent addGroup() {
        StructureMapGroupComponent t = new StructureMapGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<StructureMapGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public StructureMap addGroup(StructureMapGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<StructureMapGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this structure map when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this structure map is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Formal identifier that is used to identify this StructureMap when it is represented in other formats, or referenced in a specification, model, design or an instance  (should be globally unique OID, UUID, or URI), (if it's not possible to use the literal URI).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the StructureMap when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the StructureMap author manually.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name identifying the StructureMap.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, "code", "The status of the StructureMap.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_EXPERIMENTAL, "boolean", "This StructureMap was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the structure map.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date this version of the structure map was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the structure map changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A free text natural language description of the StructureMap and its use.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of structure maps.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("requirements", "string", "Explains why this structure map is needed and why it's been designed as it has.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the structure map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property("structure", "", "A structure definition used by this map. The structure definition may describe instances that are converted, or the instances that are produced.", 0, Integer.MAX_VALUE, this.structure));
        childrenList.add(new Property("import", "uri", "Other maps used by this map (canonical URLs).", 0, Integer.MAX_VALUE, this.import_));
        childrenList.add(new Property("group", "", "Named sections for reader convenience.", 0, Integer.MAX_VALUE, this.group));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -1619874672: {
                Base[] baseArray;
                if (this.requirements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.requirements;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.copyright;
                }
                return baseArray;
            }
            case 144518515: {
                return this.structure == null ? new Base[]{} : this.structure.toArray(new Base[this.structure.size()]);
            }
            case -1184795739: {
                return this.import_ == null ? new Base[]{} : this.import_.toArray(new Base[this.import_.size()]);
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((StructureMapContactComponent)value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case -1619874672: {
                this.requirements = this.castToString(value);
                break;
            }
            case 1522889671: {
                this.copyright = this.castToString(value);
                break;
            }
            case 144518515: {
                this.getStructure().add((StructureMapStructureComponent)value);
                break;
            }
            case -1184795739: {
                this.getImport().add(this.castToUri(value));
                break;
            }
            case 98629247: {
                this.getGroup().add((StructureMapGroupComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((StructureMapContactComponent)value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals("structure")) {
            this.getStructure().add((StructureMapStructureComponent)value);
        } else if (name.equals("import")) {
            this.getImport().add(this.castToUri(value));
        } else if (name.equals("group")) {
            this.getGroup().add((StructureMapGroupComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -1619874672: {
                throw new FHIRException("Cannot make property requirements as it is not a complex type");
            }
            case 1522889671: {
                throw new FHIRException("Cannot make property copyright as it is not a complex type");
            }
            case 144518515: {
                return this.addStructure();
            }
            case -1184795739: {
                throw new FHIRException("Cannot make property import as it is not a complex type");
            }
            case 98629247: {
                return this.addGroup();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.status");
        }
        if (name.equals(SP_EXPERIMENTAL)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.experimental");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.date");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.requirements");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.copyright");
        }
        if (name.equals("structure")) {
            return this.addStructure();
        }
        if (name.equals("import")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.import");
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "StructureMap";
    }

    @Override
    public StructureMap copy() {
        StructureMap dst = new StructureMap();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<StructureMapContactComponent>();
            for (StructureMapContactComponent structureMapContactComponent : this.contact) {
                dst.contact.add(structureMapContactComponent.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        StringType stringType3 = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.structure != null) {
            dst.structure = new ArrayList<StructureMapStructureComponent>();
            for (StructureMapStructureComponent structureMapStructureComponent : this.structure) {
                dst.structure.add(structureMapStructureComponent.copy());
            }
        }
        if (this.import_ != null) {
            dst.import_ = new ArrayList<UriType>();
            for (UriType uriType2 : this.import_) {
                dst.import_.add(uriType2.copy());
            }
        }
        if (this.group != null) {
            dst.group = new ArrayList<StructureMapGroupComponent>();
            for (StructureMapGroupComponent structureMapGroupComponent : this.group) {
                dst.group.add(structureMapGroupComponent.copy());
            }
        }
        return dst;
    }

    protected StructureMap typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof StructureMap)) {
            return false;
        }
        StructureMap o = (StructureMap)other;
        return StructureMap.compareDeep(this.url, o.url, true) && StructureMap.compareDeep(this.identifier, o.identifier, true) && StructureMap.compareDeep(this.version, o.version, true) && StructureMap.compareDeep(this.name, o.name, true) && StructureMap.compareDeep(this.status, o.status, true) && StructureMap.compareDeep(this.experimental, o.experimental, true) && StructureMap.compareDeep(this.publisher, o.publisher, true) && StructureMap.compareDeep(this.contact, o.contact, true) && StructureMap.compareDeep(this.date, o.date, true) && StructureMap.compareDeep(this.description, o.description, true) && StructureMap.compareDeep(this.useContext, o.useContext, true) && StructureMap.compareDeep(this.requirements, o.requirements, true) && StructureMap.compareDeep(this.copyright, o.copyright, true) && StructureMap.compareDeep(this.structure, o.structure, true) && StructureMap.compareDeep(this.import_, o.import_, true) && StructureMap.compareDeep(this.group, o.group, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof StructureMap)) {
            return false;
        }
        StructureMap o = (StructureMap)other;
        return StructureMap.compareValues(this.url, o.url, true) && StructureMap.compareValues(this.version, o.version, true) && StructureMap.compareValues(this.name, o.name, true) && StructureMap.compareValues(this.status, o.status, true) && StructureMap.compareValues(this.experimental, o.experimental, true) && StructureMap.compareValues(this.publisher, o.publisher, true) && StructureMap.compareValues(this.date, o.date, true) && StructureMap.compareValues(this.description, o.description, true) && StructureMap.compareValues(this.requirements, o.requirements, true) && StructureMap.compareValues(this.copyright, o.copyright, true) && StructureMap.compareValues(this.import_, o.import_, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.structure != null && !this.structure.isEmpty() || this.import_ != null && !this.import_.isEmpty() || this.group != null && !this.group.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.StructureMap;
    }

    @Block
    public static class StructureMapGroupRuleDependentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of a rule or group to apply", formalDefinition="Name of a rule or group to apply.")
        protected IdType name;
        @Child(name="variable", type={StringType.class}, order=2, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Names of variables to pass to the rule or group", formalDefinition="Names of variables to pass to the rule or group.")
        protected List<StringType> variable;
        private static final long serialVersionUID = 1021661591L;

        public StructureMapGroupRuleDependentComponent() {
        }

        public StructureMapGroupRuleDependentComponent(IdType name) {
            this.name = name;
        }

        public IdType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleDependentComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new IdType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureMapGroupRuleDependentComponent setNameElement(IdType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : this.name.getValue();
        }

        public StructureMapGroupRuleDependentComponent setName(String value) {
            if (this.name == null) {
                this.name = new IdType();
            }
            this.name.setValue(value);
            return this;
        }

        public List<StringType> getVariable() {
            if (this.variable == null) {
                this.variable = new ArrayList<StringType>();
            }
            return this.variable;
        }

        public boolean hasVariable() {
            if (this.variable == null) {
                return false;
            }
            for (StringType item : this.variable) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addVariableElement() {
            StringType t = new StringType();
            if (this.variable == null) {
                this.variable = new ArrayList<StringType>();
            }
            this.variable.add(t);
            return t;
        }

        public StructureMapGroupRuleDependentComponent addVariable(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.variable == null) {
                this.variable = new ArrayList<StringType>();
            }
            this.variable.add(t);
            return this;
        }

        public boolean hasVariable(String value) {
            if (this.variable == null) {
                return false;
            }
            for (StringType v : this.variable) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(StructureMap.SP_NAME, "id", "Name of a rule or group to apply.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("variable", "string", "Names of variables to pass to the rule or group.", 0, Integer.MAX_VALUE, this.variable));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1249586564: {
                    return this.variable == null ? new Base[]{} : this.variable.toArray(new Base[this.variable.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToId(value);
                    break;
                }
                case -1249586564: {
                    this.getVariable().add(this.castToString(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                this.name = this.castToId(value);
            } else if (name.equals("variable")) {
                this.getVariable().add(this.castToString(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1249586564: {
                    throw new FHIRException("Cannot make property variable as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
            }
            if (name.equals("variable")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.variable");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleDependentComponent copy() {
            StructureMapGroupRuleDependentComponent dst = new StructureMapGroupRuleDependentComponent();
            this.copyValues(dst);
            IdType idType = dst.name = this.name == null ? null : this.name.copy();
            if (this.variable != null) {
                dst.variable = new ArrayList<StringType>();
                for (StringType i : this.variable) {
                    dst.variable.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleDependentComponent)) {
                return false;
            }
            StructureMapGroupRuleDependentComponent o = (StructureMapGroupRuleDependentComponent)other;
            return StructureMapGroupRuleDependentComponent.compareDeep(this.name, o.name, true) && StructureMapGroupRuleDependentComponent.compareDeep(this.variable, o.variable, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleDependentComponent)) {
                return false;
            }
            StructureMapGroupRuleDependentComponent o = (StructureMapGroupRuleDependentComponent)other;
            return StructureMapGroupRuleDependentComponent.compareValues(this.name, o.name, true) && StructureMapGroupRuleDependentComponent.compareValues(this.variable, o.variable, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.variable != null && !this.variable.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule.dependent";
        }
    }

    @Block
    public static class StructureMapGroupRuleTargetParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={IdType.class, StringType.class, BooleanType.class, IntegerType.class, DecimalType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Parameter value - variable or literal", formalDefinition="Parameter value - variable or literal.")
        protected Type value;
        private static final long serialVersionUID = -732981989L;

        public StructureMapGroupRuleTargetParameterComponent() {
        }

        public StructureMapGroupRuleTargetParameterComponent(Type value) {
            this.value = value;
        }

        public Type getValue() {
            return this.value;
        }

        public IdType getValueIdType() throws FHIRException {
            if (!(this.value instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IdType)this.value;
        }

        public boolean hasValueIdType() {
            return this.value instanceof IdType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this.value instanceof IntegerType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this.value instanceof DecimalType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public StructureMapGroupRuleTargetParameterComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("value[x]", "id|string|boolean|integer|decimal", "Parameter value - variable or literal.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleTargetParameterComponent copy() {
            StructureMapGroupRuleTargetParameterComponent dst = new StructureMapGroupRuleTargetParameterComponent();
            this.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleTargetParameterComponent)) {
                return false;
            }
            StructureMapGroupRuleTargetParameterComponent o = (StructureMapGroupRuleTargetParameterComponent)other;
            return StructureMapGroupRuleTargetParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleTargetParameterComponent)) {
                return false;
            }
            StructureMapGroupRuleTargetParameterComponent o = (StructureMapGroupRuleTargetParameterComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.value == null || this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule.target.parameter";
        }
    }

    @Block
    public static class StructureMapGroupRuleTargetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="context", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type or variable this rule applies to", formalDefinition="Type or variable this rule applies to.")
        protected IdType context;
        @Child(name="contextType", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="type | variable", formalDefinition="How to interpret the context.")
        protected Enumeration<StructureMapContextType> contextType;
        @Child(name="element", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Field to create in the context", formalDefinition="Field to create in the context.")
        protected StringType element;
        @Child(name="variable", type={IdType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Named context for field, if desired, and a field is specified", formalDefinition="Named context for field, if desired, and a field is specified.")
        protected IdType variable;
        @Child(name="listMode", type={CodeType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="first | share | last", formalDefinition="If field is a list, how to manage the list.")
        protected List<Enumeration<StructureMapListMode>> listMode;
        @Child(name="listRuleId", type={IdType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Internal rule reference for shared list items", formalDefinition="Internal rule reference for shared list items.")
        protected IdType listRuleId;
        @Child(name="transform", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="create | copy +", formalDefinition="How the data is copied / created.")
        protected Enumeration<StructureMapTransform> transform;
        @Child(name="parameter", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Parameters to the transform", formalDefinition="Parameters to the transform.")
        protected List<StructureMapGroupRuleTargetParameterComponent> parameter;
        private static final long serialVersionUID = 775400884L;

        public StructureMapGroupRuleTargetComponent() {
        }

        public StructureMapGroupRuleTargetComponent(IdType context, Enumeration<StructureMapContextType> contextType) {
            this.context = context;
            this.contextType = contextType;
        }

        public IdType getContextElement() {
            if (this.context == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.context");
                }
                if (Configuration.doAutoCreate()) {
                    this.context = new IdType();
                }
            }
            return this.context;
        }

        public boolean hasContextElement() {
            return this.context != null && !this.context.isEmpty();
        }

        public boolean hasContext() {
            return this.context != null && !this.context.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setContextElement(IdType value) {
            this.context = value;
            return this;
        }

        public String getContext() {
            return this.context == null ? null : this.context.getValue();
        }

        public StructureMapGroupRuleTargetComponent setContext(String value) {
            if (this.context == null) {
                this.context = new IdType();
            }
            this.context.setValue(value);
            return this;
        }

        public Enumeration<StructureMapContextType> getContextTypeElement() {
            if (this.contextType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.contextType");
                }
                if (Configuration.doAutoCreate()) {
                    this.contextType = new Enumeration<StructureMapContextType>(new StructureMapContextTypeEnumFactory());
                }
            }
            return this.contextType;
        }

        public boolean hasContextTypeElement() {
            return this.contextType != null && !this.contextType.isEmpty();
        }

        public boolean hasContextType() {
            return this.contextType != null && !this.contextType.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setContextTypeElement(Enumeration<StructureMapContextType> value) {
            this.contextType = value;
            return this;
        }

        public StructureMapContextType getContextType() {
            return this.contextType == null ? null : (StructureMapContextType)((Object)this.contextType.getValue());
        }

        public StructureMapGroupRuleTargetComponent setContextType(StructureMapContextType value) {
            if (this.contextType == null) {
                this.contextType = new Enumeration<StructureMapContextType>(new StructureMapContextTypeEnumFactory());
            }
            this.contextType.setValue((Object)value);
            return this;
        }

        public StringType getElementElement() {
            if (this.element == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.element");
                }
                if (Configuration.doAutoCreate()) {
                    this.element = new StringType();
                }
            }
            return this.element;
        }

        public boolean hasElementElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public boolean hasElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setElementElement(StringType value) {
            this.element = value;
            return this;
        }

        public String getElement() {
            return this.element == null ? null : (String)this.element.getValue();
        }

        public StructureMapGroupRuleTargetComponent setElement(String value) {
            if (Utilities.noString((String)value)) {
                this.element = null;
            } else {
                if (this.element == null) {
                    this.element = new StringType();
                }
                this.element.setValue(value);
            }
            return this;
        }

        public IdType getVariableElement() {
            if (this.variable == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.variable");
                }
                if (Configuration.doAutoCreate()) {
                    this.variable = new IdType();
                }
            }
            return this.variable;
        }

        public boolean hasVariableElement() {
            return this.variable != null && !this.variable.isEmpty();
        }

        public boolean hasVariable() {
            return this.variable != null && !this.variable.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setVariableElement(IdType value) {
            this.variable = value;
            return this;
        }

        public String getVariable() {
            return this.variable == null ? null : this.variable.getValue();
        }

        public StructureMapGroupRuleTargetComponent setVariable(String value) {
            if (Utilities.noString((String)value)) {
                this.variable = null;
            } else {
                if (this.variable == null) {
                    this.variable = new IdType();
                }
                this.variable.setValue(value);
            }
            return this;
        }

        public List<Enumeration<StructureMapListMode>> getListMode() {
            if (this.listMode == null) {
                this.listMode = new ArrayList<Enumeration<StructureMapListMode>>();
            }
            return this.listMode;
        }

        public boolean hasListMode() {
            if (this.listMode == null) {
                return false;
            }
            for (Enumeration<StructureMapListMode> item : this.listMode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleTargetComponent setListMode(List<Enumeration<StructureMapListMode>> listMode) {
            this.listMode = listMode;
            return this;
        }

        public Enumeration<StructureMapListMode> addListModeElement() {
            Enumeration<StructureMapListMode> t = new Enumeration<StructureMapListMode>(new StructureMapListModeEnumFactory());
            if (this.listMode == null) {
                this.listMode = new ArrayList<Enumeration<StructureMapListMode>>();
            }
            this.listMode.add(t);
            return t;
        }

        public StructureMapGroupRuleTargetComponent addListMode(StructureMapListMode value) {
            Enumeration<StructureMapListMode> t = new Enumeration<StructureMapListMode>(new StructureMapListModeEnumFactory());
            t.setValue((Object)value);
            if (this.listMode == null) {
                this.listMode = new ArrayList<Enumeration<StructureMapListMode>>();
            }
            this.listMode.add(t);
            return this;
        }

        public boolean hasListMode(StructureMapListMode value) {
            if (this.listMode == null) {
                return false;
            }
            for (Enumeration<StructureMapListMode> v : this.listMode) {
                if (!((StructureMapListMode)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public IdType getListRuleIdElement() {
            if (this.listRuleId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.listRuleId");
                }
                if (Configuration.doAutoCreate()) {
                    this.listRuleId = new IdType();
                }
            }
            return this.listRuleId;
        }

        public boolean hasListRuleIdElement() {
            return this.listRuleId != null && !this.listRuleId.isEmpty();
        }

        public boolean hasListRuleId() {
            return this.listRuleId != null && !this.listRuleId.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setListRuleIdElement(IdType value) {
            this.listRuleId = value;
            return this;
        }

        public String getListRuleId() {
            return this.listRuleId == null ? null : this.listRuleId.getValue();
        }

        public StructureMapGroupRuleTargetComponent setListRuleId(String value) {
            if (Utilities.noString((String)value)) {
                this.listRuleId = null;
            } else {
                if (this.listRuleId == null) {
                    this.listRuleId = new IdType();
                }
                this.listRuleId.setValue(value);
            }
            return this;
        }

        public Enumeration<StructureMapTransform> getTransformElement() {
            if (this.transform == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.transform");
                }
                if (Configuration.doAutoCreate()) {
                    this.transform = new Enumeration<StructureMapTransform>(new StructureMapTransformEnumFactory());
                }
            }
            return this.transform;
        }

        public boolean hasTransformElement() {
            return this.transform != null && !this.transform.isEmpty();
        }

        public boolean hasTransform() {
            return this.transform != null && !this.transform.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setTransformElement(Enumeration<StructureMapTransform> value) {
            this.transform = value;
            return this;
        }

        public StructureMapTransform getTransform() {
            return this.transform == null ? null : (StructureMapTransform)((Object)this.transform.getValue());
        }

        public StructureMapGroupRuleTargetComponent setTransform(StructureMapTransform value) {
            if (value == null) {
                this.transform = null;
            } else {
                if (this.transform == null) {
                    this.transform = new Enumeration<StructureMapTransform>(new StructureMapTransformEnumFactory());
                }
                this.transform.setValue((Object)value);
            }
            return this;
        }

        public List<StructureMapGroupRuleTargetParameterComponent> getParameter() {
            if (this.parameter == null) {
                this.parameter = new ArrayList<StructureMapGroupRuleTargetParameterComponent>();
            }
            return this.parameter;
        }

        public boolean hasParameter() {
            if (this.parameter == null) {
                return false;
            }
            for (StructureMapGroupRuleTargetParameterComponent item : this.parameter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleTargetParameterComponent addParameter() {
            StructureMapGroupRuleTargetParameterComponent t = new StructureMapGroupRuleTargetParameterComponent();
            if (this.parameter == null) {
                this.parameter = new ArrayList<StructureMapGroupRuleTargetParameterComponent>();
            }
            this.parameter.add(t);
            return t;
        }

        public StructureMapGroupRuleTargetComponent addParameter(StructureMapGroupRuleTargetParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameter == null) {
                this.parameter = new ArrayList<StructureMapGroupRuleTargetParameterComponent>();
            }
            this.parameter.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(StructureMap.SP_CONTEXT, "id", "Type or variable this rule applies to.", 0, Integer.MAX_VALUE, this.context));
            childrenList.add(new Property("contextType", "code", "How to interpret the context.", 0, Integer.MAX_VALUE, this.contextType));
            childrenList.add(new Property("element", "string", "Field to create in the context.", 0, Integer.MAX_VALUE, this.element));
            childrenList.add(new Property("variable", "id", "Named context for field, if desired, and a field is specified.", 0, Integer.MAX_VALUE, this.variable));
            childrenList.add(new Property("listMode", "code", "If field is a list, how to manage the list.", 0, Integer.MAX_VALUE, this.listMode));
            childrenList.add(new Property("listRuleId", "id", "Internal rule reference for shared list items.", 0, Integer.MAX_VALUE, this.listRuleId));
            childrenList.add(new Property("transform", "code", "How the data is copied / created.", 0, Integer.MAX_VALUE, this.transform));
            childrenList.add(new Property("parameter", "", "Parameters to the transform.", 0, Integer.MAX_VALUE, this.parameter));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    Base[] baseArray;
                    if (this.context == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.context;
                    }
                    return baseArray;
                }
                case -102839927: {
                    Base[] baseArray;
                    if (this.contextType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.contextType;
                    }
                    return baseArray;
                }
                case -1662836996: {
                    Base[] baseArray;
                    if (this.element == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.element;
                    }
                    return baseArray;
                }
                case -1249586564: {
                    Base[] baseArray;
                    if (this.variable == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.variable;
                    }
                    return baseArray;
                }
                case 1345445729: {
                    return this.listMode == null ? new Base[]{} : this.listMode.toArray(new Base[this.listMode.size()]);
                }
                case 337117045: {
                    Base[] baseArray;
                    if (this.listRuleId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.listRuleId;
                    }
                    return baseArray;
                }
                case 1052666732: {
                    Base[] baseArray;
                    if (this.transform == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.transform;
                    }
                    return baseArray;
                }
                case 1954460585: {
                    return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    this.context = this.castToId(value);
                    break;
                }
                case -102839927: {
                    this.contextType = new StructureMapContextTypeEnumFactory().fromType(value);
                    break;
                }
                case -1662836996: {
                    this.element = this.castToString(value);
                    break;
                }
                case -1249586564: {
                    this.variable = this.castToId(value);
                    break;
                }
                case 1345445729: {
                    this.getListMode().add(new StructureMapListModeEnumFactory().fromType(value));
                    break;
                }
                case 337117045: {
                    this.listRuleId = this.castToId(value);
                    break;
                }
                case 1052666732: {
                    this.transform = new StructureMapTransformEnumFactory().fromType(value);
                    break;
                }
                case 1954460585: {
                    this.getParameter().add((StructureMapGroupRuleTargetParameterComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_CONTEXT)) {
                this.context = this.castToId(value);
            } else if (name.equals("contextType")) {
                this.contextType = new StructureMapContextTypeEnumFactory().fromType(value);
            } else if (name.equals("element")) {
                this.element = this.castToString(value);
            } else if (name.equals("variable")) {
                this.variable = this.castToId(value);
            } else if (name.equals("listMode")) {
                this.getListMode().add(new StructureMapListModeEnumFactory().fromType(value));
            } else if (name.equals("listRuleId")) {
                this.listRuleId = this.castToId(value);
            } else if (name.equals("transform")) {
                this.transform = new StructureMapTransformEnumFactory().fromType(value);
            } else if (name.equals("parameter")) {
                this.getParameter().add((StructureMapGroupRuleTargetParameterComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    throw new FHIRException("Cannot make property context as it is not a complex type");
                }
                case -102839927: {
                    throw new FHIRException("Cannot make property contextType as it is not a complex type");
                }
                case -1662836996: {
                    throw new FHIRException("Cannot make property element as it is not a complex type");
                }
                case -1249586564: {
                    throw new FHIRException("Cannot make property variable as it is not a complex type");
                }
                case 1345445729: {
                    throw new FHIRException("Cannot make property listMode as it is not a complex type");
                }
                case 337117045: {
                    throw new FHIRException("Cannot make property listRuleId as it is not a complex type");
                }
                case 1052666732: {
                    throw new FHIRException("Cannot make property transform as it is not a complex type");
                }
                case 1954460585: {
                    return this.addParameter();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_CONTEXT)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.context");
            }
            if (name.equals("contextType")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.contextType");
            }
            if (name.equals("element")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.element");
            }
            if (name.equals("variable")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.variable");
            }
            if (name.equals("listMode")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.listMode");
            }
            if (name.equals("listRuleId")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.listRuleId");
            }
            if (name.equals("transform")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.transform");
            }
            if (name.equals("parameter")) {
                return this.addParameter();
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleTargetComponent copy() {
            StructureMapGroupRuleTargetComponent dst = new StructureMapGroupRuleTargetComponent();
            this.copyValues(dst);
            dst.context = this.context == null ? null : this.context.copy();
            dst.contextType = this.contextType == null ? null : this.contextType.copy();
            dst.element = this.element == null ? null : this.element.copy();
            IdType idType = dst.variable = this.variable == null ? null : this.variable.copy();
            if (this.listMode != null) {
                dst.listMode = new ArrayList<Enumeration<StructureMapListMode>>();
                for (Enumeration<StructureMapListMode> enumeration : this.listMode) {
                    dst.listMode.add((Enumeration<StructureMapListMode>)enumeration.copy());
                }
            }
            dst.listRuleId = this.listRuleId == null ? null : this.listRuleId.copy();
            Enumeration<StructureMapTransform> enumeration = dst.transform = this.transform == null ? null : this.transform.copy();
            if (this.parameter != null) {
                dst.parameter = new ArrayList<StructureMapGroupRuleTargetParameterComponent>();
                for (StructureMapGroupRuleTargetParameterComponent structureMapGroupRuleTargetParameterComponent : this.parameter) {
                    dst.parameter.add(structureMapGroupRuleTargetParameterComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleTargetComponent)) {
                return false;
            }
            StructureMapGroupRuleTargetComponent o = (StructureMapGroupRuleTargetComponent)other;
            return StructureMapGroupRuleTargetComponent.compareDeep(this.context, o.context, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.contextType, o.contextType, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.element, o.element, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.variable, o.variable, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.listMode, o.listMode, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.listRuleId, o.listRuleId, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.transform, o.transform, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.parameter, o.parameter, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleTargetComponent)) {
                return false;
            }
            StructureMapGroupRuleTargetComponent o = (StructureMapGroupRuleTargetComponent)other;
            return StructureMapGroupRuleTargetComponent.compareValues(this.context, o.context, true) && StructureMapGroupRuleTargetComponent.compareValues(this.contextType, o.contextType, true) && StructureMapGroupRuleTargetComponent.compareValues(this.element, o.element, true) && StructureMapGroupRuleTargetComponent.compareValues(this.variable, o.variable, true) && StructureMapGroupRuleTargetComponent.compareValues(this.listMode, o.listMode, true) && StructureMapGroupRuleTargetComponent.compareValues(this.listRuleId, o.listRuleId, true) && StructureMapGroupRuleTargetComponent.compareValues(this.transform, o.transform, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.context != null && !this.context.isEmpty() || this.contextType != null && !this.contextType.isEmpty() || this.element != null && !this.element.isEmpty() || this.variable != null && !this.variable.isEmpty() || this.listMode != null && !this.listMode.isEmpty() || this.listRuleId != null && !this.listRuleId.isEmpty() || this.transform != null && !this.transform.isEmpty() || this.parameter != null && !this.parameter.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule.target";
        }
    }

    @Block
    public static class StructureMapGroupRuleSourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="required", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether this rule applies if the source isn't found", formalDefinition="Whether this rule applies if the source isn't found.")
        protected BooleanType required;
        @Child(name="context", type={IdType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type or variable this rule applies to", formalDefinition="Type or variable this rule applies to.")
        protected IdType context;
        @Child(name="contextType", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="type | variable", formalDefinition="How to interpret the context.")
        protected Enumeration<StructureMapContextType> contextType;
        @Child(name="element", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optional field for this source", formalDefinition="Optional field for this source.")
        protected StringType element;
        @Child(name="listMode", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="first | share | last", formalDefinition="How to handle the list mode for this element.")
        protected Enumeration<StructureMapListMode> listMode;
        @Child(name="variable", type={IdType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Named context for field, if a field is specified", formalDefinition="Named context for field, if a field is specified.")
        protected IdType variable;
        @Child(name="condition", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="FluentPath expression  - must be true or the rule does not apply", formalDefinition="FluentPath expression  - must be true or the rule does not apply.")
        protected StringType condition;
        @Child(name="check", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="FluentPath expression  - must be true or the mapping engine throws an error instead of completing", formalDefinition="FluentPath expression  - must be true or the mapping engine throws an error instead of completing.")
        protected StringType check;
        private static final long serialVersionUID = -1039728628L;

        public StructureMapGroupRuleSourceComponent() {
        }

        public StructureMapGroupRuleSourceComponent(BooleanType required, IdType context, Enumeration<StructureMapContextType> contextType) {
            this.required = required;
            this.context = context;
            this.contextType = contextType;
        }

        public BooleanType getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new BooleanType();
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setRequiredElement(BooleanType value) {
            this.required = value;
            return this;
        }

        public boolean getRequired() {
            return this.required == null || this.required.isEmpty() ? false : (Boolean)this.required.getValue();
        }

        public StructureMapGroupRuleSourceComponent setRequired(boolean value) {
            if (this.required == null) {
                this.required = new BooleanType();
            }
            this.required.setValue((Object)value);
            return this;
        }

        public IdType getContextElement() {
            if (this.context == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.context");
                }
                if (Configuration.doAutoCreate()) {
                    this.context = new IdType();
                }
            }
            return this.context;
        }

        public boolean hasContextElement() {
            return this.context != null && !this.context.isEmpty();
        }

        public boolean hasContext() {
            return this.context != null && !this.context.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setContextElement(IdType value) {
            this.context = value;
            return this;
        }

        public String getContext() {
            return this.context == null ? null : this.context.getValue();
        }

        public StructureMapGroupRuleSourceComponent setContext(String value) {
            if (this.context == null) {
                this.context = new IdType();
            }
            this.context.setValue(value);
            return this;
        }

        public Enumeration<StructureMapContextType> getContextTypeElement() {
            if (this.contextType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.contextType");
                }
                if (Configuration.doAutoCreate()) {
                    this.contextType = new Enumeration<StructureMapContextType>(new StructureMapContextTypeEnumFactory());
                }
            }
            return this.contextType;
        }

        public boolean hasContextTypeElement() {
            return this.contextType != null && !this.contextType.isEmpty();
        }

        public boolean hasContextType() {
            return this.contextType != null && !this.contextType.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setContextTypeElement(Enumeration<StructureMapContextType> value) {
            this.contextType = value;
            return this;
        }

        public StructureMapContextType getContextType() {
            return this.contextType == null ? null : (StructureMapContextType)((Object)this.contextType.getValue());
        }

        public StructureMapGroupRuleSourceComponent setContextType(StructureMapContextType value) {
            if (this.contextType == null) {
                this.contextType = new Enumeration<StructureMapContextType>(new StructureMapContextTypeEnumFactory());
            }
            this.contextType.setValue((Object)value);
            return this;
        }

        public StringType getElementElement() {
            if (this.element == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.element");
                }
                if (Configuration.doAutoCreate()) {
                    this.element = new StringType();
                }
            }
            return this.element;
        }

        public boolean hasElementElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public boolean hasElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setElementElement(StringType value) {
            this.element = value;
            return this;
        }

        public String getElement() {
            return this.element == null ? null : (String)this.element.getValue();
        }

        public StructureMapGroupRuleSourceComponent setElement(String value) {
            if (Utilities.noString((String)value)) {
                this.element = null;
            } else {
                if (this.element == null) {
                    this.element = new StringType();
                }
                this.element.setValue(value);
            }
            return this;
        }

        public Enumeration<StructureMapListMode> getListModeElement() {
            if (this.listMode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.listMode");
                }
                if (Configuration.doAutoCreate()) {
                    this.listMode = new Enumeration<StructureMapListMode>(new StructureMapListModeEnumFactory());
                }
            }
            return this.listMode;
        }

        public boolean hasListModeElement() {
            return this.listMode != null && !this.listMode.isEmpty();
        }

        public boolean hasListMode() {
            return this.listMode != null && !this.listMode.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setListModeElement(Enumeration<StructureMapListMode> value) {
            this.listMode = value;
            return this;
        }

        public StructureMapListMode getListMode() {
            return this.listMode == null ? null : (StructureMapListMode)((Object)this.listMode.getValue());
        }

        public StructureMapGroupRuleSourceComponent setListMode(StructureMapListMode value) {
            if (value == null) {
                this.listMode = null;
            } else {
                if (this.listMode == null) {
                    this.listMode = new Enumeration<StructureMapListMode>(new StructureMapListModeEnumFactory());
                }
                this.listMode.setValue((Object)value);
            }
            return this;
        }

        public IdType getVariableElement() {
            if (this.variable == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.variable");
                }
                if (Configuration.doAutoCreate()) {
                    this.variable = new IdType();
                }
            }
            return this.variable;
        }

        public boolean hasVariableElement() {
            return this.variable != null && !this.variable.isEmpty();
        }

        public boolean hasVariable() {
            return this.variable != null && !this.variable.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setVariableElement(IdType value) {
            this.variable = value;
            return this;
        }

        public String getVariable() {
            return this.variable == null ? null : this.variable.getValue();
        }

        public StructureMapGroupRuleSourceComponent setVariable(String value) {
            if (Utilities.noString((String)value)) {
                this.variable = null;
            } else {
                if (this.variable == null) {
                    this.variable = new IdType();
                }
                this.variable.setValue(value);
            }
            return this;
        }

        public StringType getConditionElement() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new StringType();
                }
            }
            return this.condition;
        }

        public boolean hasConditionElement() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setConditionElement(StringType value) {
            this.condition = value;
            return this;
        }

        public String getCondition() {
            return this.condition == null ? null : (String)this.condition.getValue();
        }

        public StructureMapGroupRuleSourceComponent setCondition(String value) {
            if (Utilities.noString((String)value)) {
                this.condition = null;
            } else {
                if (this.condition == null) {
                    this.condition = new StringType();
                }
                this.condition.setValue(value);
            }
            return this;
        }

        public StringType getCheckElement() {
            if (this.check == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.check");
                }
                if (Configuration.doAutoCreate()) {
                    this.check = new StringType();
                }
            }
            return this.check;
        }

        public boolean hasCheckElement() {
            return this.check != null && !this.check.isEmpty();
        }

        public boolean hasCheck() {
            return this.check != null && !this.check.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setCheckElement(StringType value) {
            this.check = value;
            return this;
        }

        public String getCheck() {
            return this.check == null ? null : (String)this.check.getValue();
        }

        public StructureMapGroupRuleSourceComponent setCheck(String value) {
            if (Utilities.noString((String)value)) {
                this.check = null;
            } else {
                if (this.check == null) {
                    this.check = new StringType();
                }
                this.check.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("required", "boolean", "Whether this rule applies if the source isn't found.", 0, Integer.MAX_VALUE, this.required));
            childrenList.add(new Property(StructureMap.SP_CONTEXT, "id", "Type or variable this rule applies to.", 0, Integer.MAX_VALUE, this.context));
            childrenList.add(new Property("contextType", "code", "How to interpret the context.", 0, Integer.MAX_VALUE, this.contextType));
            childrenList.add(new Property("element", "string", "Optional field for this source.", 0, Integer.MAX_VALUE, this.element));
            childrenList.add(new Property("listMode", "code", "How to handle the list mode for this element.", 0, Integer.MAX_VALUE, this.listMode));
            childrenList.add(new Property("variable", "id", "Named context for field, if a field is specified.", 0, Integer.MAX_VALUE, this.variable));
            childrenList.add(new Property("condition", "string", "FluentPath expression  - must be true or the rule does not apply.", 0, Integer.MAX_VALUE, this.condition));
            childrenList.add(new Property("check", "string", "FluentPath expression  - must be true or the mapping engine throws an error instead of completing.", 0, Integer.MAX_VALUE, this.check));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    Base[] baseArray;
                    if (this.required == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.required;
                    }
                    return baseArray;
                }
                case 951530927: {
                    Base[] baseArray;
                    if (this.context == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.context;
                    }
                    return baseArray;
                }
                case -102839927: {
                    Base[] baseArray;
                    if (this.contextType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.contextType;
                    }
                    return baseArray;
                }
                case -1662836996: {
                    Base[] baseArray;
                    if (this.element == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.element;
                    }
                    return baseArray;
                }
                case 1345445729: {
                    Base[] baseArray;
                    if (this.listMode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.listMode;
                    }
                    return baseArray;
                }
                case -1249586564: {
                    Base[] baseArray;
                    if (this.variable == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.variable;
                    }
                    return baseArray;
                }
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.condition;
                    }
                    return baseArray;
                }
                case 94627080: {
                    Base[] baseArray;
                    if (this.check == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.check;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    this.required = this.castToBoolean(value);
                    break;
                }
                case 951530927: {
                    this.context = this.castToId(value);
                    break;
                }
                case -102839927: {
                    this.contextType = new StructureMapContextTypeEnumFactory().fromType(value);
                    break;
                }
                case -1662836996: {
                    this.element = this.castToString(value);
                    break;
                }
                case 1345445729: {
                    this.listMode = new StructureMapListModeEnumFactory().fromType(value);
                    break;
                }
                case -1249586564: {
                    this.variable = this.castToId(value);
                    break;
                }
                case -861311717: {
                    this.condition = this.castToString(value);
                    break;
                }
                case 94627080: {
                    this.check = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("required")) {
                this.required = this.castToBoolean(value);
            } else if (name.equals(StructureMap.SP_CONTEXT)) {
                this.context = this.castToId(value);
            } else if (name.equals("contextType")) {
                this.contextType = new StructureMapContextTypeEnumFactory().fromType(value);
            } else if (name.equals("element")) {
                this.element = this.castToString(value);
            } else if (name.equals("listMode")) {
                this.listMode = new StructureMapListModeEnumFactory().fromType(value);
            } else if (name.equals("variable")) {
                this.variable = this.castToId(value);
            } else if (name.equals("condition")) {
                this.condition = this.castToString(value);
            } else if (name.equals("check")) {
                this.check = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    throw new FHIRException("Cannot make property required as it is not a complex type");
                }
                case 951530927: {
                    throw new FHIRException("Cannot make property context as it is not a complex type");
                }
                case -102839927: {
                    throw new FHIRException("Cannot make property contextType as it is not a complex type");
                }
                case -1662836996: {
                    throw new FHIRException("Cannot make property element as it is not a complex type");
                }
                case 1345445729: {
                    throw new FHIRException("Cannot make property listMode as it is not a complex type");
                }
                case -1249586564: {
                    throw new FHIRException("Cannot make property variable as it is not a complex type");
                }
                case -861311717: {
                    throw new FHIRException("Cannot make property condition as it is not a complex type");
                }
                case 94627080: {
                    throw new FHIRException("Cannot make property check as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.required");
            }
            if (name.equals(StructureMap.SP_CONTEXT)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.context");
            }
            if (name.equals("contextType")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.contextType");
            }
            if (name.equals("element")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.element");
            }
            if (name.equals("listMode")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.listMode");
            }
            if (name.equals("variable")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.variable");
            }
            if (name.equals("condition")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.condition");
            }
            if (name.equals("check")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.check");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleSourceComponent copy() {
            StructureMapGroupRuleSourceComponent dst = new StructureMapGroupRuleSourceComponent();
            this.copyValues(dst);
            dst.required = this.required == null ? null : this.required.copy();
            dst.context = this.context == null ? null : this.context.copy();
            dst.contextType = this.contextType == null ? null : this.contextType.copy();
            dst.element = this.element == null ? null : this.element.copy();
            dst.listMode = this.listMode == null ? null : this.listMode.copy();
            dst.variable = this.variable == null ? null : this.variable.copy();
            dst.condition = this.condition == null ? null : this.condition.copy();
            dst.check = this.check == null ? null : this.check.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleSourceComponent)) {
                return false;
            }
            StructureMapGroupRuleSourceComponent o = (StructureMapGroupRuleSourceComponent)other;
            return StructureMapGroupRuleSourceComponent.compareDeep(this.required, o.required, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.context, o.context, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.contextType, o.contextType, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.element, o.element, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.listMode, o.listMode, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.variable, o.variable, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.condition, o.condition, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.check, o.check, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleSourceComponent)) {
                return false;
            }
            StructureMapGroupRuleSourceComponent o = (StructureMapGroupRuleSourceComponent)other;
            return StructureMapGroupRuleSourceComponent.compareValues(this.required, o.required, true) && StructureMapGroupRuleSourceComponent.compareValues(this.context, o.context, true) && StructureMapGroupRuleSourceComponent.compareValues(this.contextType, o.contextType, true) && StructureMapGroupRuleSourceComponent.compareValues(this.element, o.element, true) && StructureMapGroupRuleSourceComponent.compareValues(this.listMode, o.listMode, true) && StructureMapGroupRuleSourceComponent.compareValues(this.variable, o.variable, true) && StructureMapGroupRuleSourceComponent.compareValues(this.condition, o.condition, true) && StructureMapGroupRuleSourceComponent.compareValues(this.check, o.check, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.required != null && !this.required.isEmpty() || this.context != null && !this.context.isEmpty() || this.contextType != null && !this.contextType.isEmpty() || this.element != null && !this.element.isEmpty() || this.listMode != null && !this.listMode.isEmpty() || this.variable != null && !this.variable.isEmpty() || this.condition != null && !this.condition.isEmpty() || this.check != null && !this.check.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule.source";
        }
    }

    @Block
    public static class StructureMapGroupRuleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of the rule for internal references", formalDefinition="Name of the rule for internal references.")
        protected IdType name;
        @Child(name="source", type={}, order=2, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Source inputs to the mapping", formalDefinition="Source inputs to the mapping.")
        protected List<StructureMapGroupRuleSourceComponent> source;
        @Child(name="target", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Content to create because of this mapping rule", formalDefinition="Content to create because of this mapping rule.")
        protected List<StructureMapGroupRuleTargetComponent> target;
        @Child(name="rule", type={StructureMapGroupRuleComponent.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Rules contained in this rule", formalDefinition="Rules contained in this rule.")
        protected List<StructureMapGroupRuleComponent> rule;
        @Child(name="dependent", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Which other rules to apply in the context of this rule", formalDefinition="Which other rules to apply in the context of this rule.")
        protected List<StructureMapGroupRuleDependentComponent> dependent;
        @Child(name="documentation", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation for this instance of data", formalDefinition="Documentation for this instance of data.")
        protected StringType documentation;
        private static final long serialVersionUID = 773925517L;

        public StructureMapGroupRuleComponent() {
        }

        public StructureMapGroupRuleComponent(IdType name) {
            this.name = name;
        }

        public IdType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new IdType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureMapGroupRuleComponent setNameElement(IdType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : this.name.getValue();
        }

        public StructureMapGroupRuleComponent setName(String value) {
            if (this.name == null) {
                this.name = new IdType();
            }
            this.name.setValue(value);
            return this;
        }

        public List<StructureMapGroupRuleSourceComponent> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<StructureMapGroupRuleSourceComponent>();
            }
            return this.source;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (StructureMapGroupRuleSourceComponent item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleSourceComponent addSource() {
            StructureMapGroupRuleSourceComponent t = new StructureMapGroupRuleSourceComponent();
            if (this.source == null) {
                this.source = new ArrayList<StructureMapGroupRuleSourceComponent>();
            }
            this.source.add(t);
            return t;
        }

        public StructureMapGroupRuleComponent addSource(StructureMapGroupRuleSourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<StructureMapGroupRuleSourceComponent>();
            }
            this.source.add(t);
            return this;
        }

        public List<StructureMapGroupRuleTargetComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<StructureMapGroupRuleTargetComponent>();
            }
            return this.target;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (StructureMapGroupRuleTargetComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleTargetComponent addTarget() {
            StructureMapGroupRuleTargetComponent t = new StructureMapGroupRuleTargetComponent();
            if (this.target == null) {
                this.target = new ArrayList<StructureMapGroupRuleTargetComponent>();
            }
            this.target.add(t);
            return t;
        }

        public StructureMapGroupRuleComponent addTarget(StructureMapGroupRuleTargetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<StructureMapGroupRuleTargetComponent>();
            }
            this.target.add(t);
            return this;
        }

        public List<StructureMapGroupRuleComponent> getRule() {
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            return this.rule;
        }

        public boolean hasRule() {
            if (this.rule == null) {
                return false;
            }
            for (StructureMapGroupRuleComponent item : this.rule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleComponent addRule() {
            StructureMapGroupRuleComponent t = new StructureMapGroupRuleComponent();
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            this.rule.add(t);
            return t;
        }

        public StructureMapGroupRuleComponent addRule(StructureMapGroupRuleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            this.rule.add(t);
            return this;
        }

        public List<StructureMapGroupRuleDependentComponent> getDependent() {
            if (this.dependent == null) {
                this.dependent = new ArrayList<StructureMapGroupRuleDependentComponent>();
            }
            return this.dependent;
        }

        public boolean hasDependent() {
            if (this.dependent == null) {
                return false;
            }
            for (StructureMapGroupRuleDependentComponent item : this.dependent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleDependentComponent addDependent() {
            StructureMapGroupRuleDependentComponent t = new StructureMapGroupRuleDependentComponent();
            if (this.dependent == null) {
                this.dependent = new ArrayList<StructureMapGroupRuleDependentComponent>();
            }
            this.dependent.add(t);
            return t;
        }

        public StructureMapGroupRuleComponent addDependent(StructureMapGroupRuleDependentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dependent == null) {
                this.dependent = new ArrayList<StructureMapGroupRuleDependentComponent>();
            }
            this.dependent.add(t);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public StructureMapGroupRuleComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public StructureMapGroupRuleComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(StructureMap.SP_NAME, "id", "Name of the rule for internal references.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("source", "", "Source inputs to the mapping.", 0, Integer.MAX_VALUE, this.source));
            childrenList.add(new Property("target", "", "Content to create because of this mapping rule.", 0, Integer.MAX_VALUE, this.target));
            childrenList.add(new Property("rule", "@StructureMap.group.rule", "Rules contained in this rule.", 0, Integer.MAX_VALUE, this.rule));
            childrenList.add(new Property("dependent", "", "Which other rules to apply in the context of this rule.", 0, Integer.MAX_VALUE, this.dependent));
            childrenList.add(new Property("documentation", "string", "Documentation for this instance of data.", 0, Integer.MAX_VALUE, this.documentation));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
                case -880905839: {
                    return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
                }
                case 3512060: {
                    return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
                }
                case -1109226753: {
                    return this.dependent == null ? new Base[]{} : this.dependent.toArray(new Base[this.dependent.size()]);
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToId(value);
                    break;
                }
                case -896505829: {
                    this.getSource().add((StructureMapGroupRuleSourceComponent)value);
                    break;
                }
                case -880905839: {
                    this.getTarget().add((StructureMapGroupRuleTargetComponent)value);
                    break;
                }
                case 3512060: {
                    this.getRule().add((StructureMapGroupRuleComponent)value);
                    break;
                }
                case -1109226753: {
                    this.getDependent().add((StructureMapGroupRuleDependentComponent)value);
                    break;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                this.name = this.castToId(value);
            } else if (name.equals("source")) {
                this.getSource().add((StructureMapGroupRuleSourceComponent)value);
            } else if (name.equals("target")) {
                this.getTarget().add((StructureMapGroupRuleTargetComponent)value);
            } else if (name.equals("rule")) {
                this.getRule().add((StructureMapGroupRuleComponent)value);
            } else if (name.equals("dependent")) {
                this.getDependent().add((StructureMapGroupRuleDependentComponent)value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -896505829: {
                    return this.addSource();
                }
                case -880905839: {
                    return this.addTarget();
                }
                case 3512060: {
                    return this.addRule();
                }
                case -1109226753: {
                    return this.addDependent();
                }
                case 1587405498: {
                    throw new FHIRException("Cannot make property documentation as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            if (name.equals("target")) {
                return this.addTarget();
            }
            if (name.equals("rule")) {
                return this.addRule();
            }
            if (name.equals("dependent")) {
                return this.addDependent();
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleComponent copy() {
            StructureMapGroupRuleComponent dst = new StructureMapGroupRuleComponent();
            this.copyValues(dst);
            IdType idType = dst.name = this.name == null ? null : this.name.copy();
            if (this.source != null) {
                dst.source = new ArrayList<StructureMapGroupRuleSourceComponent>();
                for (StructureMapGroupRuleSourceComponent structureMapGroupRuleSourceComponent : this.source) {
                    dst.source.add(structureMapGroupRuleSourceComponent.copy());
                }
            }
            if (this.target != null) {
                dst.target = new ArrayList<StructureMapGroupRuleTargetComponent>();
                for (StructureMapGroupRuleTargetComponent structureMapGroupRuleTargetComponent : this.target) {
                    dst.target.add(structureMapGroupRuleTargetComponent.copy());
                }
            }
            if (this.rule != null) {
                dst.rule = new ArrayList<StructureMapGroupRuleComponent>();
                for (StructureMapGroupRuleComponent structureMapGroupRuleComponent : this.rule) {
                    dst.rule.add(structureMapGroupRuleComponent.copy());
                }
            }
            if (this.dependent != null) {
                dst.dependent = new ArrayList<StructureMapGroupRuleDependentComponent>();
                for (StructureMapGroupRuleDependentComponent structureMapGroupRuleDependentComponent : this.dependent) {
                    dst.dependent.add(structureMapGroupRuleDependentComponent.copy());
                }
            }
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleComponent)) {
                return false;
            }
            StructureMapGroupRuleComponent o = (StructureMapGroupRuleComponent)other;
            return StructureMapGroupRuleComponent.compareDeep(this.name, o.name, true) && StructureMapGroupRuleComponent.compareDeep(this.source, o.source, true) && StructureMapGroupRuleComponent.compareDeep(this.target, o.target, true) && StructureMapGroupRuleComponent.compareDeep(this.rule, o.rule, true) && StructureMapGroupRuleComponent.compareDeep(this.dependent, o.dependent, true) && StructureMapGroupRuleComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupRuleComponent)) {
                return false;
            }
            StructureMapGroupRuleComponent o = (StructureMapGroupRuleComponent)other;
            return StructureMapGroupRuleComponent.compareValues(this.name, o.name, true) && StructureMapGroupRuleComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.source != null && !this.source.isEmpty() || this.target != null && !this.target.isEmpty() || this.rule != null && !this.rule.isEmpty() || this.dependent != null && !this.dependent.isEmpty() || this.documentation != null && !this.documentation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule";
        }
    }

    @Block
    public static class StructureMapGroupInputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name for this instance of data", formalDefinition="Name for this instance of data.")
        protected IdType name;
        @Child(name="type", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type for this instance of data", formalDefinition="Type for this instance of data.")
        protected StringType type;
        @Child(name="mode", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="source | target", formalDefinition="Mode for this instance of data.")
        protected Enumeration<StructureMapInputMode> mode;
        @Child(name="documentation", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation for this instance of data", formalDefinition="Documentation for this instance of data.")
        protected StringType documentation;
        private static final long serialVersionUID = -25050724L;

        public StructureMapGroupInputComponent() {
        }

        public StructureMapGroupInputComponent(IdType name, Enumeration<StructureMapInputMode> mode) {
            this.name = name;
            this.mode = mode;
        }

        public IdType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupInputComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new IdType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureMapGroupInputComponent setNameElement(IdType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : this.name.getValue();
        }

        public StructureMapGroupInputComponent setName(String value) {
            if (this.name == null) {
                this.name = new IdType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupInputComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public StructureMapGroupInputComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public StructureMapGroupInputComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new StringType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public Enumeration<StructureMapInputMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupInputComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<StructureMapInputMode>(new StructureMapInputModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public StructureMapGroupInputComponent setModeElement(Enumeration<StructureMapInputMode> value) {
            this.mode = value;
            return this;
        }

        public StructureMapInputMode getMode() {
            return this.mode == null ? null : (StructureMapInputMode)((Object)this.mode.getValue());
        }

        public StructureMapGroupInputComponent setMode(StructureMapInputMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<StructureMapInputMode>(new StructureMapInputModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupInputComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public StructureMapGroupInputComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public StructureMapGroupInputComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(StructureMap.SP_NAME, "id", "Name for this instance of data.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("type", "string", "Type for this instance of data.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("mode", "code", "Mode for this instance of data.", 0, Integer.MAX_VALUE, this.mode));
            childrenList.add(new Property("documentation", "string", "Documentation for this instance of data.", 0, Integer.MAX_VALUE, this.documentation));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.mode;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToId(value);
                    break;
                }
                case 3575610: {
                    this.type = this.castToString(value);
                    break;
                }
                case 0x3339A3: {
                    this.mode = new StructureMapInputModeEnumFactory().fromType(value);
                    break;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                this.name = this.castToId(value);
            } else if (name.equals("type")) {
                this.type = this.castToString(value);
            } else if (name.equals("mode")) {
                this.mode = new StructureMapInputModeEnumFactory().fromType(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 0x3339A3: {
                    throw new FHIRException("Cannot make property mode as it is not a complex type");
                }
                case 1587405498: {
                    throw new FHIRException("Cannot make property documentation as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.type");
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.mode");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupInputComponent copy() {
            StructureMapGroupInputComponent dst = new StructureMapGroupInputComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupInputComponent)) {
                return false;
            }
            StructureMapGroupInputComponent o = (StructureMapGroupInputComponent)other;
            return StructureMapGroupInputComponent.compareDeep(this.name, o.name, true) && StructureMapGroupInputComponent.compareDeep(this.type, o.type, true) && StructureMapGroupInputComponent.compareDeep(this.mode, o.mode, true) && StructureMapGroupInputComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupInputComponent)) {
                return false;
            }
            StructureMapGroupInputComponent o = (StructureMapGroupInputComponent)other;
            return StructureMapGroupInputComponent.compareValues(this.name, o.name, true) && StructureMapGroupInputComponent.compareValues(this.type, o.type, true) && StructureMapGroupInputComponent.compareValues(this.mode, o.mode, true) && StructureMapGroupInputComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.type != null && !this.type.isEmpty() || this.mode != null && !this.mode.isEmpty() || this.documentation != null && !this.documentation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.input";
        }
    }

    @Block
    public static class StructureMapGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Descriptive name for a user", formalDefinition="Descriptive name for a user.")
        protected IdType name;
        @Child(name="extends", type={IdType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Another group that this group adds rules to", formalDefinition="Another group that this group adds rules to.")
        protected IdType extends_;
        @Child(name="documentation", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Documentation for this group", formalDefinition="Documentation for this group.")
        protected StringType documentation;
        @Child(name="input", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Named instance provided when invoking the map", formalDefinition="A name assigned to an instance of data. The instance must be provided when the mapping is invoked.")
        protected List<StructureMapGroupInputComponent> input;
        @Child(name="rule", type={}, order=5, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Transform Rule from source to target", formalDefinition="Transform Rule from source to target.")
        protected List<StructureMapGroupRuleComponent> rule;
        private static final long serialVersionUID = -1311232924L;

        public StructureMapGroupComponent() {
        }

        public StructureMapGroupComponent(IdType name) {
            this.name = name;
        }

        public IdType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new IdType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureMapGroupComponent setNameElement(IdType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : this.name.getValue();
        }

        public StructureMapGroupComponent setName(String value) {
            if (this.name == null) {
                this.name = new IdType();
            }
            this.name.setValue(value);
            return this;
        }

        public IdType getExtendsElement() {
            if (this.extends_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupComponent.extends_");
                }
                if (Configuration.doAutoCreate()) {
                    this.extends_ = new IdType();
                }
            }
            return this.extends_;
        }

        public boolean hasExtendsElement() {
            return this.extends_ != null && !this.extends_.isEmpty();
        }

        public boolean hasExtends() {
            return this.extends_ != null && !this.extends_.isEmpty();
        }

        public StructureMapGroupComponent setExtendsElement(IdType value) {
            this.extends_ = value;
            return this;
        }

        public String getExtends() {
            return this.extends_ == null ? null : this.extends_.getValue();
        }

        public StructureMapGroupComponent setExtends(String value) {
            if (Utilities.noString((String)value)) {
                this.extends_ = null;
            } else {
                if (this.extends_ == null) {
                    this.extends_ = new IdType();
                }
                this.extends_.setValue(value);
            }
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public StructureMapGroupComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public StructureMapGroupComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public List<StructureMapGroupInputComponent> getInput() {
            if (this.input == null) {
                this.input = new ArrayList<StructureMapGroupInputComponent>();
            }
            return this.input;
        }

        public boolean hasInput() {
            if (this.input == null) {
                return false;
            }
            for (StructureMapGroupInputComponent item : this.input) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupInputComponent addInput() {
            StructureMapGroupInputComponent t = new StructureMapGroupInputComponent();
            if (this.input == null) {
                this.input = new ArrayList<StructureMapGroupInputComponent>();
            }
            this.input.add(t);
            return t;
        }

        public StructureMapGroupComponent addInput(StructureMapGroupInputComponent t) {
            if (t == null) {
                return this;
            }
            if (this.input == null) {
                this.input = new ArrayList<StructureMapGroupInputComponent>();
            }
            this.input.add(t);
            return this;
        }

        public List<StructureMapGroupRuleComponent> getRule() {
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            return this.rule;
        }

        public boolean hasRule() {
            if (this.rule == null) {
                return false;
            }
            for (StructureMapGroupRuleComponent item : this.rule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleComponent addRule() {
            StructureMapGroupRuleComponent t = new StructureMapGroupRuleComponent();
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            this.rule.add(t);
            return t;
        }

        public StructureMapGroupComponent addRule(StructureMapGroupRuleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            this.rule.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(StructureMap.SP_NAME, "id", "Descriptive name for a user.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("extends", "id", "Another group that this group adds rules to.", 0, Integer.MAX_VALUE, this.extends_));
            childrenList.add(new Property("documentation", "string", "Documentation for this group.", 0, Integer.MAX_VALUE, this.documentation));
            childrenList.add(new Property("input", "", "A name assigned to an instance of data. The instance must be provided when the mapping is invoked.", 0, Integer.MAX_VALUE, this.input));
            childrenList.add(new Property("rule", "", "Transform Rule from source to target.", 0, Integer.MAX_VALUE, this.rule));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1305664359: {
                    Base[] baseArray;
                    if (this.extends_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.extends_;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.documentation;
                    }
                    return baseArray;
                }
                case 100358090: {
                    return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
                }
                case 3512060: {
                    return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToId(value);
                    break;
                }
                case -1305664359: {
                    this.extends_ = this.castToId(value);
                    break;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    break;
                }
                case 100358090: {
                    this.getInput().add((StructureMapGroupInputComponent)value);
                    break;
                }
                case 3512060: {
                    this.getRule().add((StructureMapGroupRuleComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                this.name = this.castToId(value);
            } else if (name.equals("extends")) {
                this.extends_ = this.castToId(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else if (name.equals("input")) {
                this.getInput().add((StructureMapGroupInputComponent)value);
            } else if (name.equals("rule")) {
                this.getRule().add((StructureMapGroupRuleComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1305664359: {
                    throw new FHIRException("Cannot make property extends as it is not a complex type");
                }
                case 1587405498: {
                    throw new FHIRException("Cannot make property documentation as it is not a complex type");
                }
                case 100358090: {
                    return this.addInput();
                }
                case 3512060: {
                    return this.addRule();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
            }
            if (name.equals("extends")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.extends");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.documentation");
            }
            if (name.equals("input")) {
                return this.addInput();
            }
            if (name.equals("rule")) {
                return this.addRule();
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupComponent copy() {
            StructureMapGroupComponent dst = new StructureMapGroupComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.extends_ = this.extends_ == null ? null : this.extends_.copy();
            StringType stringType = dst.documentation = this.documentation == null ? null : this.documentation.copy();
            if (this.input != null) {
                dst.input = new ArrayList<StructureMapGroupInputComponent>();
                for (StructureMapGroupInputComponent structureMapGroupInputComponent : this.input) {
                    dst.input.add(structureMapGroupInputComponent.copy());
                }
            }
            if (this.rule != null) {
                dst.rule = new ArrayList<StructureMapGroupRuleComponent>();
                for (StructureMapGroupRuleComponent structureMapGroupRuleComponent : this.rule) {
                    dst.rule.add(structureMapGroupRuleComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupComponent)) {
                return false;
            }
            StructureMapGroupComponent o = (StructureMapGroupComponent)other;
            return StructureMapGroupComponent.compareDeep(this.name, o.name, true) && StructureMapGroupComponent.compareDeep(this.extends_, o.extends_, true) && StructureMapGroupComponent.compareDeep(this.documentation, o.documentation, true) && StructureMapGroupComponent.compareDeep(this.input, o.input, true) && StructureMapGroupComponent.compareDeep(this.rule, o.rule, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureMapGroupComponent)) {
                return false;
            }
            StructureMapGroupComponent o = (StructureMapGroupComponent)other;
            return StructureMapGroupComponent.compareValues(this.name, o.name, true) && StructureMapGroupComponent.compareValues(this.extends_, o.extends_, true) && StructureMapGroupComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.extends_ != null && !this.extends_.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.input != null && !this.input.isEmpty() || this.rule != null && !this.rule.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureMap.group";
        }
    }

    @Block
    public static class StructureMapStructureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="url", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Canonical URL for structure definition", formalDefinition="The canonical URL that identifies the structure.")
        protected UriType url;
        @Child(name="mode", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="source | queried | target | produced", formalDefinition="How the referenced structure is used in this mapping.")
        protected Enumeration<StructureMapModelMode> mode;
        @Child(name="documentation", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation on use of structure", formalDefinition="Documentation that describes how the structure is used in the mapping.")
        protected StringType documentation;
        private static final long serialVersionUID = -451631915L;

        public StructureMapStructureComponent() {
        }

        public StructureMapStructureComponent(UriType url, Enumeration<StructureMapModelMode> mode) {
            this.url = url;
            this.mode = mode;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapStructureComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public StructureMapStructureComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public StructureMapStructureComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        public Enumeration<StructureMapModelMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapStructureComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<StructureMapModelMode>(new StructureMapModelModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public StructureMapStructureComponent setModeElement(Enumeration<StructureMapModelMode> value) {
            this.mode = value;
            return this;
        }

        public StructureMapModelMode getMode() {
            return this.mode == null ? null : (StructureMapModelMode)((Object)this.mode.getValue());
        }

        public StructureMapStructureComponent setMode(StructureMapModelMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<StructureMapModelMode>(new StructureMapModelModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapStructureComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public StructureMapStructureComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public StructureMapStructureComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(StructureMap.SP_URL, "uri", "The canonical URL that identifies the structure.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("mode", "code", "How the referenced structure is used in this mapping.", 0, Integer.MAX_VALUE, this.mode));
            childrenList.add(new Property("documentation", "string", "Documentation that describes how the structure is used in the mapping.", 0, Integer.MAX_VALUE, this.documentation));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.url;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.mode;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                case 0x3339A3: {
                    this.mode = new StructureMapModelModeEnumFactory().fromType(value);
                    break;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_URL)) {
                this.url = this.castToUri(value);
            } else if (name.equals("mode")) {
                this.mode = new StructureMapModelModeEnumFactory().fromType(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
                case 0x3339A3: {
                    throw new FHIRException("Cannot make property mode as it is not a complex type");
                }
                case 1587405498: {
                    throw new FHIRException("Cannot make property documentation as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.url");
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.mode");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapStructureComponent copy() {
            StructureMapStructureComponent dst = new StructureMapStructureComponent();
            this.copyValues(dst);
            dst.url = this.url == null ? null : this.url.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureMapStructureComponent)) {
                return false;
            }
            StructureMapStructureComponent o = (StructureMapStructureComponent)other;
            return StructureMapStructureComponent.compareDeep(this.url, o.url, true) && StructureMapStructureComponent.compareDeep(this.mode, o.mode, true) && StructureMapStructureComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureMapStructureComponent)) {
                return false;
            }
            StructureMapStructureComponent o = (StructureMapStructureComponent)other;
            return StructureMapStructureComponent.compareValues(this.url, o.url, true) && StructureMapStructureComponent.compareValues(this.mode, o.mode, true) && StructureMapStructureComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.mode != null && !this.mode.isEmpty() || this.documentation != null && !this.documentation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureMap.structure";
        }
    }

    @Block
    public static class StructureMapContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the structure map.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureMapContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public StructureMapContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public StructureMapContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(StructureMap.SP_NAME, "string", "The name of an individual to contact regarding the structure map.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapContactComponent copy() {
            StructureMapContactComponent dst = new StructureMapContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureMapContactComponent)) {
                return false;
            }
            StructureMapContactComponent o = (StructureMapContactComponent)other;
            return StructureMapContactComponent.compareDeep(this.name, o.name, true) && StructureMapContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureMapContactComponent)) {
                return false;
            }
            StructureMapContactComponent o = (StructureMapContactComponent)other;
            return StructureMapContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureMap.contact";
        }
    }

    public static class StructureMapTransformEnumFactory
    implements EnumFactory<StructureMapTransform> {
        @Override
        public StructureMapTransform fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("create".equals(codeString)) {
                return StructureMapTransform.CREATE;
            }
            if ("copy".equals(codeString)) {
                return StructureMapTransform.COPY;
            }
            if ("truncate".equals(codeString)) {
                return StructureMapTransform.TRUNCATE;
            }
            if ("escape".equals(codeString)) {
                return StructureMapTransform.ESCAPE;
            }
            if ("cast".equals(codeString)) {
                return StructureMapTransform.CAST;
            }
            if ("append".equals(codeString)) {
                return StructureMapTransform.APPEND;
            }
            if ("translate".equals(codeString)) {
                return StructureMapTransform.TRANSLATE;
            }
            if ("reference".equals(codeString)) {
                return StructureMapTransform.REFERENCE;
            }
            if ("dateOp".equals(codeString)) {
                return StructureMapTransform.DATEOP;
            }
            if ("uuid".equals(codeString)) {
                return StructureMapTransform.UUID;
            }
            if ("pointer".equals(codeString)) {
                return StructureMapTransform.POINTER;
            }
            if ("evaluate".equals(codeString)) {
                return StructureMapTransform.EVALUATE;
            }
            throw new IllegalArgumentException("Unknown StructureMapTransform code '" + codeString + "'");
        }

        public Enumeration<StructureMapTransform> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.CREATE);
            }
            if ("copy".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.COPY);
            }
            if ("truncate".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.TRUNCATE);
            }
            if ("escape".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.ESCAPE);
            }
            if ("cast".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.CAST);
            }
            if ("append".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.APPEND);
            }
            if ("translate".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.TRANSLATE);
            }
            if ("reference".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.REFERENCE);
            }
            if ("dateOp".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.DATEOP);
            }
            if ("uuid".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.UUID);
            }
            if ("pointer".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.POINTER);
            }
            if ("evaluate".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.EVALUATE);
            }
            throw new FHIRException("Unknown StructureMapTransform code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapTransform code) {
            if (code == StructureMapTransform.CREATE) {
                return "create";
            }
            if (code == StructureMapTransform.COPY) {
                return "copy";
            }
            if (code == StructureMapTransform.TRUNCATE) {
                return "truncate";
            }
            if (code == StructureMapTransform.ESCAPE) {
                return "escape";
            }
            if (code == StructureMapTransform.CAST) {
                return "cast";
            }
            if (code == StructureMapTransform.APPEND) {
                return "append";
            }
            if (code == StructureMapTransform.TRANSLATE) {
                return "translate";
            }
            if (code == StructureMapTransform.REFERENCE) {
                return "reference";
            }
            if (code == StructureMapTransform.DATEOP) {
                return "dateOp";
            }
            if (code == StructureMapTransform.UUID) {
                return "uuid";
            }
            if (code == StructureMapTransform.POINTER) {
                return "pointer";
            }
            if (code == StructureMapTransform.EVALUATE) {
                return "evaluate";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapTransform code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapTransform {
        CREATE,
        COPY,
        TRUNCATE,
        ESCAPE,
        CAST,
        APPEND,
        TRANSLATE,
        REFERENCE,
        DATEOP,
        UUID,
        POINTER,
        EVALUATE,
        NULL;


        public static StructureMapTransform fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("copy".equals(codeString)) {
                return COPY;
            }
            if ("truncate".equals(codeString)) {
                return TRUNCATE;
            }
            if ("escape".equals(codeString)) {
                return ESCAPE;
            }
            if ("cast".equals(codeString)) {
                return CAST;
            }
            if ("append".equals(codeString)) {
                return APPEND;
            }
            if ("translate".equals(codeString)) {
                return TRANSLATE;
            }
            if ("reference".equals(codeString)) {
                return REFERENCE;
            }
            if ("dateOp".equals(codeString)) {
                return DATEOP;
            }
            if ("uuid".equals(codeString)) {
                return UUID;
            }
            if ("pointer".equals(codeString)) {
                return POINTER;
            }
            if ("evaluate".equals(codeString)) {
                return EVALUATE;
            }
            throw new FHIRException("Unknown StructureMapTransform code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case COPY: {
                    return "copy";
                }
                case TRUNCATE: {
                    return "truncate";
                }
                case ESCAPE: {
                    return "escape";
                }
                case CAST: {
                    return "cast";
                }
                case APPEND: {
                    return "append";
                }
                case TRANSLATE: {
                    return "translate";
                }
                case REFERENCE: {
                    return "reference";
                }
                case DATEOP: {
                    return "dateOp";
                }
                case UUID: {
                    return "uuid";
                }
                case POINTER: {
                    return "pointer";
                }
                case EVALUATE: {
                    return "evaluate";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CREATE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case COPY: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case TRUNCATE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case ESCAPE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case CAST: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case APPEND: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case TRANSLATE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case REFERENCE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case DATEOP: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case UUID: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case POINTER: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case EVALUATE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CREATE: {
                    return "create(type : string) - type is passed through to the application on the standard API, and must be known by it";
                }
                case COPY: {
                    return "copy(source)";
                }
                case TRUNCATE: {
                    return "truncate(source, length) - source must be stringy type";
                }
                case ESCAPE: {
                    return "escape(source, fmt1, fmt2) - change source from one kind of escaping to another (plain, java, xml, json). note that this is for when the string itself is escaped";
                }
                case CAST: {
                    return "cast(source, type?) - case source from one type to another. target type can be left as implicit if there is one and only one target type known";
                }
                case APPEND: {
                    return "append(source...) - source is element or string";
                }
                case TRANSLATE: {
                    return "translate(source, uri_of_map) - use the translate operation";
                }
                case REFERENCE: {
                    return "reference(source : object) - return a string that references the provided tree properly";
                }
                case DATEOP: {
                    return "something";
                }
                case UUID: {
                    return "something";
                }
                case POINTER: {
                    return "something";
                }
                case EVALUATE: {
                    return "something";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case COPY: {
                    return "copy";
                }
                case TRUNCATE: {
                    return "truncate";
                }
                case ESCAPE: {
                    return "escape";
                }
                case CAST: {
                    return "cast";
                }
                case APPEND: {
                    return "append";
                }
                case TRANSLATE: {
                    return "translate";
                }
                case REFERENCE: {
                    return "reference";
                }
                case DATEOP: {
                    return "dateOp";
                }
                case UUID: {
                    return "uuid";
                }
                case POINTER: {
                    return "pointer";
                }
                case EVALUATE: {
                    return "evaluate";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class StructureMapListModeEnumFactory
    implements EnumFactory<StructureMapListMode> {
        @Override
        public StructureMapListMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("first".equals(codeString)) {
                return StructureMapListMode.FIRST;
            }
            if ("share".equals(codeString)) {
                return StructureMapListMode.SHARE;
            }
            if ("last".equals(codeString)) {
                return StructureMapListMode.LAST;
            }
            throw new IllegalArgumentException("Unknown StructureMapListMode code '" + codeString + "'");
        }

        public Enumeration<StructureMapListMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("first".equals(codeString)) {
                return new Enumeration<StructureMapListMode>(this, StructureMapListMode.FIRST);
            }
            if ("share".equals(codeString)) {
                return new Enumeration<StructureMapListMode>(this, StructureMapListMode.SHARE);
            }
            if ("last".equals(codeString)) {
                return new Enumeration<StructureMapListMode>(this, StructureMapListMode.LAST);
            }
            throw new FHIRException("Unknown StructureMapListMode code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapListMode code) {
            if (code == StructureMapListMode.FIRST) {
                return "first";
            }
            if (code == StructureMapListMode.SHARE) {
                return "share";
            }
            if (code == StructureMapListMode.LAST) {
                return "last";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapListMode code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapListMode {
        FIRST,
        SHARE,
        LAST,
        NULL;


        public static StructureMapListMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("first".equals(codeString)) {
                return FIRST;
            }
            if ("share".equals(codeString)) {
                return SHARE;
            }
            if ("last".equals(codeString)) {
                return LAST;
            }
            throw new FHIRException("Unknown StructureMapListMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case FIRST: {
                    return "first";
                }
                case SHARE: {
                    return "share";
                }
                case LAST: {
                    return "last";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case FIRST: {
                    return "http://hl7.org/fhir/map-list-mode";
                }
                case SHARE: {
                    return "http://hl7.org/fhir/map-list-mode";
                }
                case LAST: {
                    return "http://hl7.org/fhir/map-list-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case FIRST: {
                    return "when the target list is being assembled, the items for this rule go first. If more that one rule defines a first item (for a given instance of mapping) then this is an error";
                }
                case SHARE: {
                    return "the target instance is shared with the target instances generated by another rule (up to the first common n items, then create new ones)";
                }
                case LAST: {
                    return "when the target list is being assembled, the items for this rule go last. If more that one rule defines a last item (for a given instance of mapping) then this is an error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case FIRST: {
                    return "First";
                }
                case SHARE: {
                    return "Share";
                }
                case LAST: {
                    return "Last";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class StructureMapContextTypeEnumFactory
    implements EnumFactory<StructureMapContextType> {
        @Override
        public StructureMapContextType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("type".equals(codeString)) {
                return StructureMapContextType.TYPE;
            }
            if ("variable".equals(codeString)) {
                return StructureMapContextType.VARIABLE;
            }
            throw new IllegalArgumentException("Unknown StructureMapContextType code '" + codeString + "'");
        }

        public Enumeration<StructureMapContextType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("type".equals(codeString)) {
                return new Enumeration<StructureMapContextType>(this, StructureMapContextType.TYPE);
            }
            if ("variable".equals(codeString)) {
                return new Enumeration<StructureMapContextType>(this, StructureMapContextType.VARIABLE);
            }
            throw new FHIRException("Unknown StructureMapContextType code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapContextType code) {
            if (code == StructureMapContextType.TYPE) {
                return "type";
            }
            if (code == StructureMapContextType.VARIABLE) {
                return "variable";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapContextType code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapContextType {
        TYPE,
        VARIABLE,
        NULL;


        public static StructureMapContextType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("type".equals(codeString)) {
                return TYPE;
            }
            if ("variable".equals(codeString)) {
                return VARIABLE;
            }
            throw new FHIRException("Unknown StructureMapContextType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TYPE: {
                    return "type";
                }
                case VARIABLE: {
                    return "variable";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TYPE: {
                    return "http://hl7.org/fhir/map-context-type";
                }
                case VARIABLE: {
                    return "http://hl7.org/fhir/map-context-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TYPE: {
                    return "The context specifies a type";
                }
                case VARIABLE: {
                    return "The context specifies a variable";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TYPE: {
                    return "Type";
                }
                case VARIABLE: {
                    return "Variable";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class StructureMapInputModeEnumFactory
    implements EnumFactory<StructureMapInputMode> {
        @Override
        public StructureMapInputMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("source".equals(codeString)) {
                return StructureMapInputMode.SOURCE;
            }
            if ("target".equals(codeString)) {
                return StructureMapInputMode.TARGET;
            }
            throw new IllegalArgumentException("Unknown StructureMapInputMode code '" + codeString + "'");
        }

        public Enumeration<StructureMapInputMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("source".equals(codeString)) {
                return new Enumeration<StructureMapInputMode>(this, StructureMapInputMode.SOURCE);
            }
            if ("target".equals(codeString)) {
                return new Enumeration<StructureMapInputMode>(this, StructureMapInputMode.TARGET);
            }
            throw new FHIRException("Unknown StructureMapInputMode code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapInputMode code) {
            if (code == StructureMapInputMode.SOURCE) {
                return "source";
            }
            if (code == StructureMapInputMode.TARGET) {
                return "target";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapInputMode code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapInputMode {
        SOURCE,
        TARGET,
        NULL;


        public static StructureMapInputMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("source".equals(codeString)) {
                return SOURCE;
            }
            if ("target".equals(codeString)) {
                return TARGET;
            }
            throw new FHIRException("Unknown StructureMapInputMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SOURCE: {
                    return "source";
                }
                case TARGET: {
                    return "target";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SOURCE: {
                    return "http://hl7.org/fhir/map-input-mode";
                }
                case TARGET: {
                    return "http://hl7.org/fhir/map-input-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SOURCE: {
                    return "Names an input instance used a source for mapping";
                }
                case TARGET: {
                    return "Names an instance that is being populated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SOURCE: {
                    return "Source Instance";
                }
                case TARGET: {
                    return "Target Instance";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class StructureMapModelModeEnumFactory
    implements EnumFactory<StructureMapModelMode> {
        @Override
        public StructureMapModelMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("source".equals(codeString)) {
                return StructureMapModelMode.SOURCE;
            }
            if ("queried".equals(codeString)) {
                return StructureMapModelMode.QUERIED;
            }
            if ("target".equals(codeString)) {
                return StructureMapModelMode.TARGET;
            }
            if ("produced".equals(codeString)) {
                return StructureMapModelMode.PRODUCED;
            }
            throw new IllegalArgumentException("Unknown StructureMapModelMode code '" + codeString + "'");
        }

        public Enumeration<StructureMapModelMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("source".equals(codeString)) {
                return new Enumeration<StructureMapModelMode>(this, StructureMapModelMode.SOURCE);
            }
            if ("queried".equals(codeString)) {
                return new Enumeration<StructureMapModelMode>(this, StructureMapModelMode.QUERIED);
            }
            if ("target".equals(codeString)) {
                return new Enumeration<StructureMapModelMode>(this, StructureMapModelMode.TARGET);
            }
            if ("produced".equals(codeString)) {
                return new Enumeration<StructureMapModelMode>(this, StructureMapModelMode.PRODUCED);
            }
            throw new FHIRException("Unknown StructureMapModelMode code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapModelMode code) {
            if (code == StructureMapModelMode.SOURCE) {
                return "source";
            }
            if (code == StructureMapModelMode.QUERIED) {
                return "queried";
            }
            if (code == StructureMapModelMode.TARGET) {
                return "target";
            }
            if (code == StructureMapModelMode.PRODUCED) {
                return "produced";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapModelMode code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapModelMode {
        SOURCE,
        QUERIED,
        TARGET,
        PRODUCED,
        NULL;


        public static StructureMapModelMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("source".equals(codeString)) {
                return SOURCE;
            }
            if ("queried".equals(codeString)) {
                return QUERIED;
            }
            if ("target".equals(codeString)) {
                return TARGET;
            }
            if ("produced".equals(codeString)) {
                return PRODUCED;
            }
            throw new FHIRException("Unknown StructureMapModelMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SOURCE: {
                    return "source";
                }
                case QUERIED: {
                    return "queried";
                }
                case TARGET: {
                    return "target";
                }
                case PRODUCED: {
                    return "produced";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SOURCE: {
                    return "http://hl7.org/fhir/map-model-mode";
                }
                case QUERIED: {
                    return "http://hl7.org/fhir/map-model-mode";
                }
                case TARGET: {
                    return "http://hl7.org/fhir/map-model-mode";
                }
                case PRODUCED: {
                    return "http://hl7.org/fhir/map-model-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SOURCE: {
                    return "This structure describes an instance passed to the mapping engine that is used a source of data";
                }
                case QUERIED: {
                    return "This structure describes an instance that the mapping engine may ask for that is used a source of data";
                }
                case TARGET: {
                    return "This structure describes an instance passed to the mapping engine that is used a target of data";
                }
                case PRODUCED: {
                    return "This structure describes an instance that the mapping engine may ask to create that is used a target of data";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SOURCE: {
                    return "Source Structure Definition";
                }
                case QUERIED: {
                    return "Queried Structure Definition";
                }
                case TARGET: {
                    return "Target Structure Definition";
                }
                case PRODUCED: {
                    return "Produced Structure Definition";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

