/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcPatientPersonNameUse {
    _188,
    _191,
    _812,
    NULL;


    public static HspcPatientPersonNameUse fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("188".equals(codeString)) {
            return _188;
        }
        if ("191".equals(codeString)) {
            return _191;
        }
        if ("812".equals(codeString)) {
            return _812;
        }
        throw new FHIRException("Unknown HspcPatientPersonNameUse code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _188: {
                return "188";
            }
            case _191: {
                return "191";
            }
            case _812: {
                return "812";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/patient-hspc-PersonNameUse";
    }

    public String getDefinition() {
        switch (this) {
            case _188: {
                return "A name by which an individual previously identified by.";
            }
            case _191: {
                return "The name by which an individual prefers to be known by.";
            }
            case _812: {
                return "The name by which an individual in known by professionally.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _188: {
                return "Previous Name";
            }
            case _191: {
                return "Preferred Name";
            }
            case _812: {
                return "Professional Name";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

