/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="Flag", profile="http://hl7.org/fhir/Profile/Flag")
public class Flag
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Identifier assigned to the flag for external use (outside the FHIR environment).")
    protected List<Identifier> identifier;
    @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinical, administrative, etc.", formalDefinition="Allows an flag to be divided into different categories like clinical, administrative etc. Intended to be used as a means of filtering which flags are displayed to particular user or in a given context.")
    protected CodeableConcept category;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="Supports basic workflow.")
    protected Enumeration<FlagStatus> status;
    @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period when flag is active", formalDefinition="The period of time from the activation of the flag to inactivation of the flag. If the flag is active, the end of the period should be unspecified.")
    protected Period period;
    @Child(name="subject", type={Patient.class, Location.class, Group.class, Organization.class, Practitioner.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/What is flag about?", formalDefinition="The patient, location, group , organization , or practitioner this is about record this flag is associated with.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="encounter", type={Encounter.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Alert relevant during encounter", formalDefinition="This alert is only relevant during the encounter.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="author", type={Device.class, Organization.class, Patient.class, Practitioner.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Flag creator", formalDefinition="The person, organization or device that created the flag.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="code", type={CodeableConcept.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Partially deaf, Requires easy open caps, No permanent address, etc.", formalDefinition="The coded value or textual component of the flag to display to the user.")
    protected CodeableConcept code;
    private static final long serialVersionUID = 701147751L;
    @SearchParamDefinition(name="author", path="Flag.author", description="Flag creator", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("Flag:author").toLocked();
    @SearchParamDefinition(name="patient", path="Flag.subject", description="The identity of a subject to list flags for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Flag:patient").toLocked();
    @SearchParamDefinition(name="subject", path="Flag.subject", description="The identity of a subject to list flags for", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Flag:subject").toLocked();
    @SearchParamDefinition(name="encounter", path="Flag.encounter", description="Alert relevant during encounter", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Flag:encounter").toLocked();
    @SearchParamDefinition(name="date", path="Flag.period", description="Time period when flag is active", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");

    public Flag() {
    }

    public Flag(Enumeration<FlagStatus> status, Reference subject, CodeableConcept code) {
        this.status = status;
        this.subject = subject;
        this.code = code;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Flag addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public Flag setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Enumeration<FlagStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FlagStatus>(new FlagStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Flag setStatusElement(Enumeration<FlagStatus> value) {
        this.status = value;
        return this;
    }

    public FlagStatus getStatus() {
        return this.status == null ? null : (FlagStatus)((Object)this.status.getValue());
    }

    public Flag setStatus(FlagStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<FlagStatus>(new FlagStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Flag setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Flag setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Flag setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Flag setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public Flag setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Flag setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public Flag setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Flag setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("identifier", "Identifier", "Identifier assigned to the flag for external use (outside the FHIR environment).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("category", "CodeableConcept", "Allows an flag to be divided into different categories like clinical, administrative etc. Intended to be used as a means of filtering which flags are displayed to particular user or in a given context.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property("status", "code", "Supports basic workflow.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("period", "Period", "The period of time from the activation of the flag to inactivation of the flag. If the flag is active, the end of the period should be unspecified.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Location|Group|Organization|Practitioner)", "The patient, location, group , organization , or practitioner this is about record this flag is associated with.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "This alert is only relevant during the encounter.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Device|Organization|Patient|Practitioner)", "The person, organization or device that created the flag.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property("code", "CodeableConcept", "The coded value or textual component of the flag to display to the user.", 0, Integer.MAX_VALUE, this.code));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.category;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.period;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.author;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.code;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                break;
            }
            case -892481550: {
                this.status = new FlagStatusEnumFactory().fromType(value);
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                break;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                break;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("category")) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals("status")) {
            this.status = new FlagStatusEnumFactory().fromType(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 50511102: {
                return this.getCategory();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case 3059181: {
                return this.getCode();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("category")) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property Flag.status");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Flag";
    }

    @Override
    public Flag copy() {
        Flag dst = new Flag();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.category = this.category == null ? null : this.category.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.author = this.author == null ? null : this.author.copy();
        dst.code = this.code == null ? null : this.code.copy();
        return dst;
    }

    protected Flag typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Flag)) {
            return false;
        }
        Flag o = (Flag)other;
        return Flag.compareDeep(this.identifier, o.identifier, true) && Flag.compareDeep(this.category, o.category, true) && Flag.compareDeep(this.status, o.status, true) && Flag.compareDeep(this.period, o.period, true) && Flag.compareDeep(this.subject, o.subject, true) && Flag.compareDeep(this.encounter, o.encounter, true) && Flag.compareDeep(this.author, o.author, true) && Flag.compareDeep(this.code, o.code, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Flag)) {
            return false;
        }
        Flag o = (Flag)other;
        return Flag.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.category != null && !this.category.isEmpty() || this.status != null && !this.status.isEmpty() || this.period != null && !this.period.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.author != null && !this.author.isEmpty() || this.code != null && !this.code.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Flag;
    }

    public static class FlagStatusEnumFactory
    implements EnumFactory<FlagStatus> {
        @Override
        public FlagStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return FlagStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return FlagStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return FlagStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown FlagStatus code '" + codeString + "'");
        }

        public Enumeration<FlagStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<FlagStatus>(this, FlagStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<FlagStatus>(this, FlagStatus.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FlagStatus>(this, FlagStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown FlagStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(FlagStatus code) {
            if (code == FlagStatus.ACTIVE) {
                return "active";
            }
            if (code == FlagStatus.INACTIVE) {
                return "inactive";
            }
            if (code == FlagStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(FlagStatus code) {
            return code.getSystem();
        }
    }

    public static enum FlagStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static FlagStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown FlagStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/flag-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/flag-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/flag-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "A current flag that should be displayed to a user. A system may use the category to determine which roles should view the flag.";
                }
                case INACTIVE: {
                    return "The flag does not need to be displayed any more.";
                }
                case ENTEREDINERROR: {
                    return "The flag was added in error, and should no longer be displayed.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

