/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.GoalCategory;

public class GoalCategoryEnumFactory
implements EnumFactory<GoalCategory> {
    @Override
    public GoalCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("dietary".equals(codeString)) {
            return GoalCategory.DIETARY;
        }
        if ("safety".equals(codeString)) {
            return GoalCategory.SAFETY;
        }
        if ("behavioral".equals(codeString)) {
            return GoalCategory.BEHAVIORAL;
        }
        if ("nursing".equals(codeString)) {
            return GoalCategory.NURSING;
        }
        if ("physiotherapy".equals(codeString)) {
            return GoalCategory.PHYSIOTHERAPY;
        }
        throw new IllegalArgumentException("Unknown GoalCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(GoalCategory code) {
        if (code == GoalCategory.DIETARY) {
            return "dietary";
        }
        if (code == GoalCategory.SAFETY) {
            return "safety";
        }
        if (code == GoalCategory.BEHAVIORAL) {
            return "behavioral";
        }
        if (code == GoalCategory.NURSING) {
            return "nursing";
        }
        if (code == GoalCategory.PHYSIOTHERAPY) {
            return "physiotherapy";
        }
        return "?";
    }

    @Override
    public String toSystem(GoalCategory code) {
        return code.getSystem();
    }
}

