/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.AllergyIntolerance;
import org.hl7.fhir.dstu2016may.model.Appointment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CarePlan;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.CommunicationRequest;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DeviceUseRequest;
import org.hl7.fhir.dstu2016may.model.DiagnosticOrder;
import org.hl7.fhir.dstu2016may.model.DiagnosticReport;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.FamilyMemberHistory;
import org.hl7.fhir.dstu2016may.model.MedicationOrder;
import org.hl7.fhir.dstu2016may.model.NutritionOrder;
import org.hl7.fhir.dstu2016may.model.Observation;
import org.hl7.fhir.dstu2016may.model.Order;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Procedure;
import org.hl7.fhir.dstu2016may.model.ProcedureRequest;
import org.hl7.fhir.dstu2016may.model.ProcessRequest;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ReferralRequest;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.SupplyRequest;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ClinicalImpression", profile="http://hl7.org/fhir/Profile/ClinicalImpression")
public class ClinicalImpression
extends DomainResource {
    @Child(name="patient", type={Patient.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient being assessed", formalDefinition="The patient being assessed.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="assessor", type={Practitioner.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The clinician performing the assessment", formalDefinition="The clinician performing the assessment.")
    protected Reference assessor;
    protected Practitioner assessorTarget;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | entered-in-error", formalDefinition="Identifies the workflow status of the assessment.")
    protected Enumeration<ClinicalImpressionStatus> status;
    @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the assessment occurred", formalDefinition="The point in time at which the assessment was concluded (not when it was recorded).")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why/how the assessment was performed", formalDefinition="A summary of the context and/or cause of the assessment - why / where was it peformed, and what patient events/sstatus prompted it.")
    protected StringType description;
    @Child(name="previous", type={ClinicalImpression.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to last assessment", formalDefinition="A reference to the last assesment that was conducted bon this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes.")
    protected Reference previous;
    protected ClinicalImpression previousTarget;
    @Child(name="problem", type={Condition.class, AllergyIntolerance.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="General assessment of patient state", formalDefinition="This a list of the general problems/conditions for a patient.")
    protected List<Reference> problem;
    protected List<Resource> problemTarget;
    @Child(name="trigger", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Request or event that necessitated this assessment", formalDefinition="The request or event that necessitated this assessment. This may be a diagnosis, a Care Plan, a Request Referral, or some other resource.")
    protected Type trigger;
    @Child(name="investigations", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="One or more sets of investigations (signs, symptions, etc.)", formalDefinition="One or more sets of investigations (signs, symptions, etc.). The actual grouping of investigations vary greatly depending on the type and context of the assessment. These investigations may include data generated during the assessment process, or data previously generated and recorded that is pertinent to the outcomes.")
    protected List<ClinicalImpressionInvestigationsComponent> investigations;
    @Child(name="protocol", type={UriType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical Protocol followed", formalDefinition="Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis.")
    protected UriType protocol;
    @Child(name="summary", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Summary of the assessment", formalDefinition="A text summary of the investigations and the diagnosis.")
    protected StringType summary;
    @Child(name="finding", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Possible or likely findings and diagnoses", formalDefinition="Specific findings or diagnoses that was considered likely or relevant to ongoing treatment.")
    protected List<ClinicalImpressionFindingComponent> finding;
    @Child(name="resolved", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Diagnoses/conditions resolved since previous assessment", formalDefinition="Diagnoses/conditions resolved since the last assessment.")
    protected List<CodeableConcept> resolved;
    @Child(name="ruledOut", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Diagnosis considered not possible", formalDefinition="Diagnosis considered not possible.")
    protected List<ClinicalImpressionRuledOutComponent> ruledOut;
    @Child(name="prognosis", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Estimate of likely outcome", formalDefinition="Estimate of likely outcome.")
    protected StringType prognosis;
    @Child(name="plan", type={CarePlan.class, Appointment.class, CommunicationRequest.class, DeviceUseRequest.class, DiagnosticOrder.class, MedicationOrder.class, NutritionOrder.class, Order.class, ProcedureRequest.class, ProcessRequest.class, ReferralRequest.class, SupplyRequest.class, VisionPrescription.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Plan of action after assessment", formalDefinition="Plan of action after assessment.")
    protected List<Reference> plan;
    protected List<Resource> planTarget;
    @Child(name="action", type={ReferralRequest.class, ProcedureRequest.class, Procedure.class, MedicationOrder.class, DiagnosticOrder.class, NutritionOrder.class, SupplyRequest.class, Appointment.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Actions taken during assessment", formalDefinition="Actions taken during assessment.")
    protected List<Reference> action;
    protected List<Resource> actionTarget;
    private static final long serialVersionUID = 0x62600006L;
    @SearchParamDefinition(name="assessor", path="ClinicalImpression.assessor", description="The clinician performing the assessment", type="reference")
    public static final String SP_ASSESSOR = "assessor";
    public static final ReferenceClientParam ASSESSOR = new ReferenceClientParam("assessor");
    public static final Include INCLUDE_ASSESSOR = new Include("ClinicalImpression:assessor").toLocked();
    @SearchParamDefinition(name="trigger", path="ClinicalImpression.trigger.as(Reference)", description="Request or event that necessitated this assessment", type="reference")
    public static final String SP_TRIGGER = "trigger";
    public static final ReferenceClientParam TRIGGER = new ReferenceClientParam("trigger");
    public static final Include INCLUDE_TRIGGER = new Include("ClinicalImpression:trigger").toLocked();
    @SearchParamDefinition(name="patient", path="ClinicalImpression.patient", description="The patient being assessed", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ClinicalImpression:patient").toLocked();
    @SearchParamDefinition(name="plan", path="ClinicalImpression.plan", description="Plan of action after assessment", type="reference")
    public static final String SP_PLAN = "plan";
    public static final ReferenceClientParam PLAN = new ReferenceClientParam("plan");
    public static final Include INCLUDE_PLAN = new Include("ClinicalImpression:plan").toLocked();
    @SearchParamDefinition(name="resolved", path="ClinicalImpression.resolved", description="Diagnoses/conditions resolved since previous assessment", type="token")
    public static final String SP_RESOLVED = "resolved";
    public static final TokenClientParam RESOLVED = new TokenClientParam("resolved");
    @SearchParamDefinition(name="trigger-code", path="ClinicalImpression.trigger.as(CodeableConcept)", description="Request or event that necessitated this assessment", type="token")
    public static final String SP_TRIGGER_CODE = "trigger-code";
    public static final TokenClientParam TRIGGER_CODE = new TokenClientParam("trigger-code");
    @SearchParamDefinition(name="previous", path="ClinicalImpression.previous", description="Reference to last assessment", type="reference")
    public static final String SP_PREVIOUS = "previous";
    public static final ReferenceClientParam PREVIOUS = new ReferenceClientParam("previous");
    public static final Include INCLUDE_PREVIOUS = new Include("ClinicalImpression:previous").toLocked();
    @SearchParamDefinition(name="status", path="ClinicalImpression.status", description="in-progress | completed | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="action", path="ClinicalImpression.action", description="Actions taken during assessment", type="reference")
    public static final String SP_ACTION = "action";
    public static final ReferenceClientParam ACTION = new ReferenceClientParam("action");
    public static final Include INCLUDE_ACTION = new Include("ClinicalImpression:action").toLocked();
    @SearchParamDefinition(name="finding", path="ClinicalImpression.finding.item", description="Specific text or code for finding", type="token")
    public static final String SP_FINDING = "finding";
    public static final TokenClientParam FINDING = new TokenClientParam("finding");
    @SearchParamDefinition(name="investigation", path="ClinicalImpression.investigations.item", description="Record of a specific investigation", type="reference")
    public static final String SP_INVESTIGATION = "investigation";
    public static final ReferenceClientParam INVESTIGATION = new ReferenceClientParam("investigation");
    public static final Include INCLUDE_INVESTIGATION = new Include("ClinicalImpression:investigation").toLocked();
    @SearchParamDefinition(name="problem", path="ClinicalImpression.problem", description="General assessment of patient state", type="reference")
    public static final String SP_PROBLEM = "problem";
    public static final ReferenceClientParam PROBLEM = new ReferenceClientParam("problem");
    public static final Include INCLUDE_PROBLEM = new Include("ClinicalImpression:problem").toLocked();
    @SearchParamDefinition(name="date", path="ClinicalImpression.date", description="When the assessment occurred", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="ruledout", path="ClinicalImpression.ruledOut.item", description="Specific text of code for diagnosis", type="token")
    public static final String SP_RULEDOUT = "ruledout";
    public static final TokenClientParam RULEDOUT = new TokenClientParam("ruledout");

    public ClinicalImpression() {
    }

    public ClinicalImpression(Reference patient, Enumeration<ClinicalImpressionStatus> status) {
        this.patient = patient;
        this.status = status;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ClinicalImpression setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ClinicalImpression setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getAssessor() {
        if (this.assessor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.assessor");
            }
            if (Configuration.doAutoCreate()) {
                this.assessor = new Reference();
            }
        }
        return this.assessor;
    }

    public boolean hasAssessor() {
        return this.assessor != null && !this.assessor.isEmpty();
    }

    public ClinicalImpression setAssessor(Reference value) {
        this.assessor = value;
        return this;
    }

    public Practitioner getAssessorTarget() {
        if (this.assessorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.assessor");
            }
            if (Configuration.doAutoCreate()) {
                this.assessorTarget = new Practitioner();
            }
        }
        return this.assessorTarget;
    }

    public ClinicalImpression setAssessorTarget(Practitioner value) {
        this.assessorTarget = value;
        return this;
    }

    public Enumeration<ClinicalImpressionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ClinicalImpressionStatus>(new ClinicalImpressionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ClinicalImpression setStatusElement(Enumeration<ClinicalImpressionStatus> value) {
        this.status = value;
        return this;
    }

    public ClinicalImpressionStatus getStatus() {
        return this.status == null ? null : (ClinicalImpressionStatus)((Object)this.status.getValue());
    }

    public ClinicalImpression setStatus(ClinicalImpressionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ClinicalImpressionStatus>(new ClinicalImpressionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ClinicalImpression setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ClinicalImpression setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ClinicalImpression setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ClinicalImpression setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Reference getPrevious() {
        if (this.previous == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.previous");
            }
            if (Configuration.doAutoCreate()) {
                this.previous = new Reference();
            }
        }
        return this.previous;
    }

    public boolean hasPrevious() {
        return this.previous != null && !this.previous.isEmpty();
    }

    public ClinicalImpression setPrevious(Reference value) {
        this.previous = value;
        return this;
    }

    public ClinicalImpression getPreviousTarget() {
        if (this.previousTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.previous");
            }
            if (Configuration.doAutoCreate()) {
                this.previousTarget = new ClinicalImpression();
            }
        }
        return this.previousTarget;
    }

    public ClinicalImpression setPreviousTarget(ClinicalImpression value) {
        this.previousTarget = value;
        return this;
    }

    public List<Reference> getProblem() {
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        return this.problem;
    }

    public boolean hasProblem() {
        if (this.problem == null) {
            return false;
        }
        for (Reference item : this.problem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProblem() {
        Reference t = new Reference();
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        this.problem.add(t);
        return t;
    }

    public ClinicalImpression addProblem(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        this.problem.add(t);
        return this;
    }

    public List<Resource> getProblemTarget() {
        if (this.problemTarget == null) {
            this.problemTarget = new ArrayList<Resource>();
        }
        return this.problemTarget;
    }

    public Type getTrigger() {
        return this.trigger;
    }

    public CodeableConcept getTriggerCodeableConcept() throws FHIRException {
        if (!(this.trigger instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.trigger.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.trigger;
    }

    public boolean hasTriggerCodeableConcept() {
        return this.trigger instanceof CodeableConcept;
    }

    public Reference getTriggerReference() throws FHIRException {
        if (!(this.trigger instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.trigger.getClass().getName() + " was encountered");
        }
        return (Reference)this.trigger;
    }

    public boolean hasTriggerReference() {
        return this.trigger instanceof Reference;
    }

    public boolean hasTrigger() {
        return this.trigger != null && !this.trigger.isEmpty();
    }

    public ClinicalImpression setTrigger(Type value) {
        this.trigger = value;
        return this;
    }

    public List<ClinicalImpressionInvestigationsComponent> getInvestigations() {
        if (this.investigations == null) {
            this.investigations = new ArrayList<ClinicalImpressionInvestigationsComponent>();
        }
        return this.investigations;
    }

    public boolean hasInvestigations() {
        if (this.investigations == null) {
            return false;
        }
        for (ClinicalImpressionInvestigationsComponent item : this.investigations) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClinicalImpressionInvestigationsComponent addInvestigations() {
        ClinicalImpressionInvestigationsComponent t = new ClinicalImpressionInvestigationsComponent();
        if (this.investigations == null) {
            this.investigations = new ArrayList<ClinicalImpressionInvestigationsComponent>();
        }
        this.investigations.add(t);
        return t;
    }

    public ClinicalImpression addInvestigations(ClinicalImpressionInvestigationsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.investigations == null) {
            this.investigations = new ArrayList<ClinicalImpressionInvestigationsComponent>();
        }
        this.investigations.add(t);
        return this;
    }

    public UriType getProtocolElement() {
        if (this.protocol == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.protocol");
            }
            if (Configuration.doAutoCreate()) {
                this.protocol = new UriType();
            }
        }
        return this.protocol;
    }

    public boolean hasProtocolElement() {
        return this.protocol != null && !this.protocol.isEmpty();
    }

    public boolean hasProtocol() {
        return this.protocol != null && !this.protocol.isEmpty();
    }

    public ClinicalImpression setProtocolElement(UriType value) {
        this.protocol = value;
        return this;
    }

    public String getProtocol() {
        return this.protocol == null ? null : (String)this.protocol.getValue();
    }

    public ClinicalImpression setProtocol(String value) {
        if (Utilities.noString((String)value)) {
            this.protocol = null;
        } else {
            if (this.protocol == null) {
                this.protocol = new UriType();
            }
            this.protocol.setValue(value);
        }
        return this;
    }

    public StringType getSummaryElement() {
        if (this.summary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.summary");
            }
            if (Configuration.doAutoCreate()) {
                this.summary = new StringType();
            }
        }
        return this.summary;
    }

    public boolean hasSummaryElement() {
        return this.summary != null && !this.summary.isEmpty();
    }

    public boolean hasSummary() {
        return this.summary != null && !this.summary.isEmpty();
    }

    public ClinicalImpression setSummaryElement(StringType value) {
        this.summary = value;
        return this;
    }

    public String getSummary() {
        return this.summary == null ? null : (String)this.summary.getValue();
    }

    public ClinicalImpression setSummary(String value) {
        if (Utilities.noString((String)value)) {
            this.summary = null;
        } else {
            if (this.summary == null) {
                this.summary = new StringType();
            }
            this.summary.setValue(value);
        }
        return this;
    }

    public List<ClinicalImpressionFindingComponent> getFinding() {
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFindingComponent>();
        }
        return this.finding;
    }

    public boolean hasFinding() {
        if (this.finding == null) {
            return false;
        }
        for (ClinicalImpressionFindingComponent item : this.finding) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClinicalImpressionFindingComponent addFinding() {
        ClinicalImpressionFindingComponent t = new ClinicalImpressionFindingComponent();
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFindingComponent>();
        }
        this.finding.add(t);
        return t;
    }

    public ClinicalImpression addFinding(ClinicalImpressionFindingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFindingComponent>();
        }
        this.finding.add(t);
        return this;
    }

    public List<CodeableConcept> getResolved() {
        if (this.resolved == null) {
            this.resolved = new ArrayList<CodeableConcept>();
        }
        return this.resolved;
    }

    public boolean hasResolved() {
        if (this.resolved == null) {
            return false;
        }
        for (CodeableConcept item : this.resolved) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addResolved() {
        CodeableConcept t = new CodeableConcept();
        if (this.resolved == null) {
            this.resolved = new ArrayList<CodeableConcept>();
        }
        this.resolved.add(t);
        return t;
    }

    public ClinicalImpression addResolved(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.resolved == null) {
            this.resolved = new ArrayList<CodeableConcept>();
        }
        this.resolved.add(t);
        return this;
    }

    public List<ClinicalImpressionRuledOutComponent> getRuledOut() {
        if (this.ruledOut == null) {
            this.ruledOut = new ArrayList<ClinicalImpressionRuledOutComponent>();
        }
        return this.ruledOut;
    }

    public boolean hasRuledOut() {
        if (this.ruledOut == null) {
            return false;
        }
        for (ClinicalImpressionRuledOutComponent item : this.ruledOut) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClinicalImpressionRuledOutComponent addRuledOut() {
        ClinicalImpressionRuledOutComponent t = new ClinicalImpressionRuledOutComponent();
        if (this.ruledOut == null) {
            this.ruledOut = new ArrayList<ClinicalImpressionRuledOutComponent>();
        }
        this.ruledOut.add(t);
        return t;
    }

    public ClinicalImpression addRuledOut(ClinicalImpressionRuledOutComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ruledOut == null) {
            this.ruledOut = new ArrayList<ClinicalImpressionRuledOutComponent>();
        }
        this.ruledOut.add(t);
        return this;
    }

    public StringType getPrognosisElement() {
        if (this.prognosis == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.prognosis");
            }
            if (Configuration.doAutoCreate()) {
                this.prognosis = new StringType();
            }
        }
        return this.prognosis;
    }

    public boolean hasPrognosisElement() {
        return this.prognosis != null && !this.prognosis.isEmpty();
    }

    public boolean hasPrognosis() {
        return this.prognosis != null && !this.prognosis.isEmpty();
    }

    public ClinicalImpression setPrognosisElement(StringType value) {
        this.prognosis = value;
        return this;
    }

    public String getPrognosis() {
        return this.prognosis == null ? null : (String)this.prognosis.getValue();
    }

    public ClinicalImpression setPrognosis(String value) {
        if (Utilities.noString((String)value)) {
            this.prognosis = null;
        } else {
            if (this.prognosis == null) {
                this.prognosis = new StringType();
            }
            this.prognosis.setValue(value);
        }
        return this;
    }

    public List<Reference> getPlan() {
        if (this.plan == null) {
            this.plan = new ArrayList<Reference>();
        }
        return this.plan;
    }

    public boolean hasPlan() {
        if (this.plan == null) {
            return false;
        }
        for (Reference item : this.plan) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPlan() {
        Reference t = new Reference();
        if (this.plan == null) {
            this.plan = new ArrayList<Reference>();
        }
        this.plan.add(t);
        return t;
    }

    public ClinicalImpression addPlan(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.plan == null) {
            this.plan = new ArrayList<Reference>();
        }
        this.plan.add(t);
        return this;
    }

    public List<Resource> getPlanTarget() {
        if (this.planTarget == null) {
            this.planTarget = new ArrayList<Resource>();
        }
        return this.planTarget;
    }

    public List<Reference> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<Reference>();
        }
        return this.action;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (Reference item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAction() {
        Reference t = new Reference();
        if (this.action == null) {
            this.action = new ArrayList<Reference>();
        }
        this.action.add(t);
        return t;
    }

    public ClinicalImpression addAction(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<Reference>();
        }
        this.action.add(t);
        return this;
    }

    public List<Resource> getActionTarget() {
        if (this.actionTarget == null) {
            this.actionTarget = new ArrayList<Resource>();
        }
        return this.actionTarget;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient being assessed.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_ASSESSOR, "Reference(Practitioner)", "The clinician performing the assessment.", 0, Integer.MAX_VALUE, this.assessor));
        childrenList.add(new Property(SP_STATUS, "code", "Identifies the workflow status of the assessment.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_DATE, "dateTime", "The point in time at which the assessment was concluded (not when it was recorded).", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property("description", "string", "A summary of the context and/or cause of the assessment - why / where was it peformed, and what patient events/sstatus prompted it.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property(SP_PREVIOUS, "Reference(ClinicalImpression)", "A reference to the last assesment that was conducted bon this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes.", 0, Integer.MAX_VALUE, this.previous));
        childrenList.add(new Property(SP_PROBLEM, "Reference(Condition|AllergyIntolerance)", "This a list of the general problems/conditions for a patient.", 0, Integer.MAX_VALUE, this.problem));
        childrenList.add(new Property("trigger[x]", "CodeableConcept|Reference(Any)", "The request or event that necessitated this assessment. This may be a diagnosis, a Care Plan, a Request Referral, or some other resource.", 0, Integer.MAX_VALUE, this.trigger));
        childrenList.add(new Property("investigations", "", "One or more sets of investigations (signs, symptions, etc.). The actual grouping of investigations vary greatly depending on the type and context of the assessment. These investigations may include data generated during the assessment process, or data previously generated and recorded that is pertinent to the outcomes.", 0, Integer.MAX_VALUE, this.investigations));
        childrenList.add(new Property("protocol", "uri", "Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis.", 0, Integer.MAX_VALUE, this.protocol));
        childrenList.add(new Property("summary", "string", "A text summary of the investigations and the diagnosis.", 0, Integer.MAX_VALUE, this.summary));
        childrenList.add(new Property(SP_FINDING, "", "Specific findings or diagnoses that was considered likely or relevant to ongoing treatment.", 0, Integer.MAX_VALUE, this.finding));
        childrenList.add(new Property(SP_RESOLVED, "CodeableConcept", "Diagnoses/conditions resolved since the last assessment.", 0, Integer.MAX_VALUE, this.resolved));
        childrenList.add(new Property("ruledOut", "", "Diagnosis considered not possible.", 0, Integer.MAX_VALUE, this.ruledOut));
        childrenList.add(new Property("prognosis", "string", "Estimate of likely outcome.", 0, Integer.MAX_VALUE, this.prognosis));
        childrenList.add(new Property(SP_PLAN, "Reference(CarePlan|Appointment|CommunicationRequest|DeviceUseRequest|DiagnosticOrder|MedicationOrder|NutritionOrder|Order|ProcedureRequest|ProcessRequest|ReferralRequest|SupplyRequest|VisionPrescription)", "Plan of action after assessment.", 0, Integer.MAX_VALUE, this.plan));
        childrenList.add(new Property(SP_ACTION, "Reference(ReferralRequest|ProcedureRequest|Procedure|MedicationOrder|DiagnosticOrder|NutritionOrder|SupplyRequest|Appointment)", "Actions taken during assessment.", 0, Integer.MAX_VALUE, this.action));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.patient;
                }
                return baseArray;
            }
            case -373213113: {
                Base[] baseArray;
                if (this.assessor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.assessor;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.date;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.description;
                }
                return baseArray;
            }
            case -1273775369: {
                Base[] baseArray;
                if (this.previous == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.previous;
                }
                return baseArray;
            }
            case -309542241: {
                return this.problem == null ? new Base[]{} : this.problem.toArray(new Base[this.problem.size()]);
            }
            case -1059891784: {
                Base[] baseArray;
                if (this.trigger == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.trigger;
                }
                return baseArray;
            }
            case -428294735: {
                return this.investigations == null ? new Base[]{} : this.investigations.toArray(new Base[this.investigations.size()]);
            }
            case -989163880: {
                Base[] baseArray;
                if (this.protocol == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.protocol;
                }
                return baseArray;
            }
            case -1857640538: {
                Base[] baseArray;
                if (this.summary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.summary;
                }
                return baseArray;
            }
            case -853173367: {
                return this.finding == null ? new Base[]{} : this.finding.toArray(new Base[this.finding.size()]);
            }
            case -341328904: {
                return this.resolved == null ? new Base[]{} : this.resolved.toArray(new Base[this.resolved.size()]);
            }
            case 763913542: {
                return this.ruledOut == null ? new Base[]{} : this.ruledOut.toArray(new Base[this.ruledOut.size()]);
            }
            case -972050334: {
                Base[] baseArray;
                if (this.prognosis == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.prognosis;
                }
                return baseArray;
            }
            case 3443497: {
                return this.plan == null ? new Base[]{} : this.plan.toArray(new Base[this.plan.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -373213113: {
                this.assessor = this.castToReference(value);
                break;
            }
            case -892481550: {
                this.status = new ClinicalImpressionStatusEnumFactory().fromType(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -1273775369: {
                this.previous = this.castToReference(value);
                break;
            }
            case -309542241: {
                this.getProblem().add(this.castToReference(value));
                break;
            }
            case -1059891784: {
                this.trigger = (Type)value;
                break;
            }
            case -428294735: {
                this.getInvestigations().add((ClinicalImpressionInvestigationsComponent)value);
                break;
            }
            case -989163880: {
                this.protocol = this.castToUri(value);
                break;
            }
            case -1857640538: {
                this.summary = this.castToString(value);
                break;
            }
            case -853173367: {
                this.getFinding().add((ClinicalImpressionFindingComponent)value);
                break;
            }
            case -341328904: {
                this.getResolved().add(this.castToCodeableConcept(value));
                break;
            }
            case 763913542: {
                this.getRuledOut().add((ClinicalImpressionRuledOutComponent)value);
                break;
            }
            case -972050334: {
                this.prognosis = this.castToString(value);
                break;
            }
            case 3443497: {
                this.getPlan().add(this.castToReference(value));
                break;
            }
            case -1422950858: {
                this.getAction().add(this.castToReference(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_ASSESSOR)) {
            this.assessor = this.castToReference(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new ClinicalImpressionStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals(SP_PREVIOUS)) {
            this.previous = this.castToReference(value);
        } else if (name.equals(SP_PROBLEM)) {
            this.getProblem().add(this.castToReference(value));
        } else if (name.equals("trigger[x]")) {
            this.trigger = (Type)value;
        } else if (name.equals("investigations")) {
            this.getInvestigations().add((ClinicalImpressionInvestigationsComponent)value);
        } else if (name.equals("protocol")) {
            this.protocol = this.castToUri(value);
        } else if (name.equals("summary")) {
            this.summary = this.castToString(value);
        } else if (name.equals(SP_FINDING)) {
            this.getFinding().add((ClinicalImpressionFindingComponent)value);
        } else if (name.equals(SP_RESOLVED)) {
            this.getResolved().add(this.castToCodeableConcept(value));
        } else if (name.equals("ruledOut")) {
            this.getRuledOut().add((ClinicalImpressionRuledOutComponent)value);
        } else if (name.equals("prognosis")) {
            this.prognosis = this.castToString(value);
        } else if (name.equals(SP_PLAN)) {
            this.getPlan().add(this.castToReference(value));
        } else if (name.equals(SP_ACTION)) {
            this.getAction().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -791418107: {
                return this.getPatient();
            }
            case -373213113: {
                return this.getAssessor();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -1273775369: {
                return this.getPrevious();
            }
            case -309542241: {
                return this.addProblem();
            }
            case 1363514312: {
                return this.getTrigger();
            }
            case -428294735: {
                return this.addInvestigations();
            }
            case -989163880: {
                throw new FHIRException("Cannot make property protocol as it is not a complex type");
            }
            case -1857640538: {
                throw new FHIRException("Cannot make property summary as it is not a complex type");
            }
            case -853173367: {
                return this.addFinding();
            }
            case -341328904: {
                return this.addResolved();
            }
            case 763913542: {
                return this.addRuledOut();
            }
            case -972050334: {
                throw new FHIRException("Cannot make property prognosis as it is not a complex type");
            }
            case 3443497: {
                return this.addPlan();
            }
            case -1422950858: {
                return this.addAction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_ASSESSOR)) {
            this.assessor = new Reference();
            return this.assessor;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ClinicalImpression.status");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ClinicalImpression.date");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property ClinicalImpression.description");
        }
        if (name.equals(SP_PREVIOUS)) {
            this.previous = new Reference();
            return this.previous;
        }
        if (name.equals(SP_PROBLEM)) {
            return this.addProblem();
        }
        if (name.equals("triggerCodeableConcept")) {
            this.trigger = new CodeableConcept();
            return this.trigger;
        }
        if (name.equals("triggerReference")) {
            this.trigger = new Reference();
            return this.trigger;
        }
        if (name.equals("investigations")) {
            return this.addInvestigations();
        }
        if (name.equals("protocol")) {
            throw new FHIRException("Cannot call addChild on a singleton property ClinicalImpression.protocol");
        }
        if (name.equals("summary")) {
            throw new FHIRException("Cannot call addChild on a singleton property ClinicalImpression.summary");
        }
        if (name.equals(SP_FINDING)) {
            return this.addFinding();
        }
        if (name.equals(SP_RESOLVED)) {
            return this.addResolved();
        }
        if (name.equals("ruledOut")) {
            return this.addRuledOut();
        }
        if (name.equals("prognosis")) {
            throw new FHIRException("Cannot call addChild on a singleton property ClinicalImpression.prognosis");
        }
        if (name.equals(SP_PLAN)) {
            return this.addPlan();
        }
        if (name.equals(SP_ACTION)) {
            return this.addAction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ClinicalImpression";
    }

    @Override
    public ClinicalImpression copy() {
        ClinicalImpression dst = new ClinicalImpression();
        this.copyValues(dst);
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.assessor = this.assessor == null ? null : this.assessor.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.description = this.description == null ? null : this.description.copy();
        Reference reference = dst.previous = this.previous == null ? null : this.previous.copy();
        if (this.problem != null) {
            dst.problem = new ArrayList<Reference>();
            for (Reference reference2 : this.problem) {
                dst.problem.add(reference2.copy());
            }
        }
        Type type = dst.trigger = this.trigger == null ? null : this.trigger.copy();
        if (this.investigations != null) {
            dst.investigations = new ArrayList<ClinicalImpressionInvestigationsComponent>();
            for (ClinicalImpressionInvestigationsComponent clinicalImpressionInvestigationsComponent : this.investigations) {
                dst.investigations.add(clinicalImpressionInvestigationsComponent.copy());
            }
        }
        dst.protocol = this.protocol == null ? null : this.protocol.copy();
        StringType stringType = dst.summary = this.summary == null ? null : this.summary.copy();
        if (this.finding != null) {
            dst.finding = new ArrayList<ClinicalImpressionFindingComponent>();
            for (ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : this.finding) {
                dst.finding.add(clinicalImpressionFindingComponent.copy());
            }
        }
        if (this.resolved != null) {
            dst.resolved = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.resolved) {
                dst.resolved.add(codeableConcept.copy());
            }
        }
        if (this.ruledOut != null) {
            dst.ruledOut = new ArrayList<ClinicalImpressionRuledOutComponent>();
            for (ClinicalImpressionRuledOutComponent clinicalImpressionRuledOutComponent : this.ruledOut) {
                dst.ruledOut.add(clinicalImpressionRuledOutComponent.copy());
            }
        }
        StringType stringType2 = dst.prognosis = this.prognosis == null ? null : this.prognosis.copy();
        if (this.plan != null) {
            dst.plan = new ArrayList<Reference>();
            for (Reference reference3 : this.plan) {
                dst.plan.add(reference3.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<Reference>();
            for (Reference reference4 : this.action) {
                dst.action.add(reference4.copy());
            }
        }
        return dst;
    }

    protected ClinicalImpression typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ClinicalImpression)) {
            return false;
        }
        ClinicalImpression o = (ClinicalImpression)other;
        return ClinicalImpression.compareDeep(this.patient, o.patient, true) && ClinicalImpression.compareDeep(this.assessor, o.assessor, true) && ClinicalImpression.compareDeep(this.status, o.status, true) && ClinicalImpression.compareDeep(this.date, o.date, true) && ClinicalImpression.compareDeep(this.description, o.description, true) && ClinicalImpression.compareDeep(this.previous, o.previous, true) && ClinicalImpression.compareDeep(this.problem, o.problem, true) && ClinicalImpression.compareDeep(this.trigger, o.trigger, true) && ClinicalImpression.compareDeep(this.investigations, o.investigations, true) && ClinicalImpression.compareDeep(this.protocol, o.protocol, true) && ClinicalImpression.compareDeep(this.summary, o.summary, true) && ClinicalImpression.compareDeep(this.finding, o.finding, true) && ClinicalImpression.compareDeep(this.resolved, o.resolved, true) && ClinicalImpression.compareDeep(this.ruledOut, o.ruledOut, true) && ClinicalImpression.compareDeep(this.prognosis, o.prognosis, true) && ClinicalImpression.compareDeep(this.plan, o.plan, true) && ClinicalImpression.compareDeep(this.action, o.action, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ClinicalImpression)) {
            return false;
        }
        ClinicalImpression o = (ClinicalImpression)other;
        return ClinicalImpression.compareValues(this.status, o.status, true) && ClinicalImpression.compareValues(this.date, o.date, true) && ClinicalImpression.compareValues(this.description, o.description, true) && ClinicalImpression.compareValues(this.protocol, o.protocol, true) && ClinicalImpression.compareValues(this.summary, o.summary, true) && ClinicalImpression.compareValues(this.prognosis, o.prognosis, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.assessor != null && !this.assessor.isEmpty() || this.status != null && !this.status.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.previous != null && !this.previous.isEmpty() || this.problem != null && !this.problem.isEmpty() || this.trigger != null && !this.trigger.isEmpty() || this.investigations != null && !this.investigations.isEmpty() || this.protocol != null && !this.protocol.isEmpty() || this.summary != null && !this.summary.isEmpty() || this.finding != null && !this.finding.isEmpty() || this.resolved != null && !this.resolved.isEmpty() || this.ruledOut != null && !this.ruledOut.isEmpty() || this.prognosis != null && !this.prognosis.isEmpty() || this.plan != null && !this.plan.isEmpty() || this.action != null && !this.action.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ClinicalImpression;
    }

    @Block
    public static class ClinicalImpressionRuledOutComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific text of code for diagnosis", formalDefinition="Specific text of code for diagnosis.")
        protected CodeableConcept item;
        @Child(name="reason", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Grounds for elimination", formalDefinition="Grounds for elimination.")
        protected StringType reason;
        private static final long serialVersionUID = -1001661243L;

        public ClinicalImpressionRuledOutComponent() {
        }

        public ClinicalImpressionRuledOutComponent(CodeableConcept item) {
            this.item = item;
        }

        public CodeableConcept getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionRuledOutComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableConcept();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public ClinicalImpressionRuledOutComponent setItem(CodeableConcept value) {
            this.item = value;
            return this;
        }

        public StringType getReasonElement() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionRuledOutComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new StringType();
                }
            }
            return this.reason;
        }

        public boolean hasReasonElement() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public ClinicalImpressionRuledOutComponent setReasonElement(StringType value) {
            this.reason = value;
            return this;
        }

        public String getReason() {
            return this.reason == null ? null : (String)this.reason.getValue();
        }

        public ClinicalImpressionRuledOutComponent setReason(String value) {
            if (Utilities.noString((String)value)) {
                this.reason = null;
            } else {
                if (this.reason == null) {
                    this.reason = new StringType();
                }
                this.reason.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("item", "CodeableConcept", "Specific text of code for diagnosis.", 0, Integer.MAX_VALUE, this.item));
            childrenList.add(new Property("reason", "string", "Grounds for elimination.", 0, Integer.MAX_VALUE, this.reason));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = this.castToCodeableConcept(value);
                    break;
                }
                case -934964668: {
                    this.reason = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.item = this.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.getItem();
                }
                case -934964668: {
                    throw new FHIRException("Cannot make property reason as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("reason")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClinicalImpression.reason");
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalImpressionRuledOutComponent copy() {
            ClinicalImpressionRuledOutComponent dst = new ClinicalImpressionRuledOutComponent();
            this.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ClinicalImpressionRuledOutComponent)) {
                return false;
            }
            ClinicalImpressionRuledOutComponent o = (ClinicalImpressionRuledOutComponent)other;
            return ClinicalImpressionRuledOutComponent.compareDeep(this.item, o.item, true) && ClinicalImpressionRuledOutComponent.compareDeep(this.reason, o.reason, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ClinicalImpressionRuledOutComponent)) {
                return false;
            }
            ClinicalImpressionRuledOutComponent o = (ClinicalImpressionRuledOutComponent)other;
            return ClinicalImpressionRuledOutComponent.compareValues(this.reason, o.reason, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.item != null && !this.item.isEmpty() || this.reason != null && !this.reason.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClinicalImpression.ruledOut";
        }
    }

    @Block
    public static class ClinicalImpressionFindingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific text or code for finding", formalDefinition="Specific text of code for finding or diagnosis.")
        protected CodeableConcept item;
        @Child(name="cause", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Which investigations support finding", formalDefinition="Which investigations support finding or diagnosis.")
        protected StringType cause;
        private static final long serialVersionUID = -888590978L;

        public ClinicalImpressionFindingComponent() {
        }

        public ClinicalImpressionFindingComponent(CodeableConcept item) {
            this.item = item;
        }

        public CodeableConcept getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionFindingComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableConcept();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public ClinicalImpressionFindingComponent setItem(CodeableConcept value) {
            this.item = value;
            return this;
        }

        public StringType getCauseElement() {
            if (this.cause == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionFindingComponent.cause");
                }
                if (Configuration.doAutoCreate()) {
                    this.cause = new StringType();
                }
            }
            return this.cause;
        }

        public boolean hasCauseElement() {
            return this.cause != null && !this.cause.isEmpty();
        }

        public boolean hasCause() {
            return this.cause != null && !this.cause.isEmpty();
        }

        public ClinicalImpressionFindingComponent setCauseElement(StringType value) {
            this.cause = value;
            return this;
        }

        public String getCause() {
            return this.cause == null ? null : (String)this.cause.getValue();
        }

        public ClinicalImpressionFindingComponent setCause(String value) {
            if (Utilities.noString((String)value)) {
                this.cause = null;
            } else {
                if (this.cause == null) {
                    this.cause = new StringType();
                }
                this.cause.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("item", "CodeableConcept", "Specific text of code for finding or diagnosis.", 0, Integer.MAX_VALUE, this.item));
            childrenList.add(new Property("cause", "string", "Which investigations support finding or diagnosis.", 0, Integer.MAX_VALUE, this.cause));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case 94434409: {
                    Base[] baseArray;
                    if (this.cause == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.cause;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = this.castToCodeableConcept(value);
                    break;
                }
                case 94434409: {
                    this.cause = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.item = this.castToCodeableConcept(value);
            } else if (name.equals("cause")) {
                this.cause = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.getItem();
                }
                case 94434409: {
                    throw new FHIRException("Cannot make property cause as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("cause")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClinicalImpression.cause");
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalImpressionFindingComponent copy() {
            ClinicalImpressionFindingComponent dst = new ClinicalImpressionFindingComponent();
            this.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.cause = this.cause == null ? null : this.cause.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ClinicalImpressionFindingComponent)) {
                return false;
            }
            ClinicalImpressionFindingComponent o = (ClinicalImpressionFindingComponent)other;
            return ClinicalImpressionFindingComponent.compareDeep(this.item, o.item, true) && ClinicalImpressionFindingComponent.compareDeep(this.cause, o.cause, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ClinicalImpressionFindingComponent)) {
                return false;
            }
            ClinicalImpressionFindingComponent o = (ClinicalImpressionFindingComponent)other;
            return ClinicalImpressionFindingComponent.compareValues(this.cause, o.cause, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.item != null && !this.item.isEmpty() || this.cause != null && !this.cause.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClinicalImpression.finding";
        }
    }

    @Block
    public static class ClinicalImpressionInvestigationsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name/code for the set", formalDefinition="A name/code for the group (\"set\") of investigations. Typically, this will be something like \"signs\", \"symptoms\", \"clinical\", \"diagnostic\", but the list is not constrained, and others such groups such as (exposure|family|travel|nutitirional) history may be used.")
        protected CodeableConcept code;
        @Child(name="item", type={Observation.class, QuestionnaireResponse.class, FamilyMemberHistory.class, DiagnosticReport.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Record of a specific investigation", formalDefinition="A record of a specific investigation that was undertaken.")
        protected List<Reference> item;
        protected List<Resource> itemTarget;
        private static final long serialVersionUID = -301363326L;

        public ClinicalImpressionInvestigationsComponent() {
        }

        public ClinicalImpressionInvestigationsComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionInvestigationsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ClinicalImpressionInvestigationsComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<Reference> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<Reference>();
            }
            return this.item;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (Reference item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addItem() {
            Reference t = new Reference();
            if (this.item == null) {
                this.item = new ArrayList<Reference>();
            }
            this.item.add(t);
            return t;
        }

        public ClinicalImpressionInvestigationsComponent addItem(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<Reference>();
            }
            this.item.add(t);
            return this;
        }

        public List<Resource> getItemTarget() {
            if (this.itemTarget == null) {
                this.itemTarget = new ArrayList<Resource>();
            }
            return this.itemTarget;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "CodeableConcept", "A name/code for the group (\"set\") of investigations. Typically, this will be something like \"signs\", \"symptoms\", \"clinical\", \"diagnostic\", but the list is not constrained, and others such groups such as (exposure|family|travel|nutitirional) history may be used.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("item", "Reference(Observation|QuestionnaireResponse|FamilyMemberHistory|DiagnosticReport)", "A record of a specific investigation that was undertaken.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    break;
                }
                case 3242771: {
                    this.getItem().add(this.castToReference(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("item")) {
                this.getItem().add(this.castToReference(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("item")) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalImpressionInvestigationsComponent copy() {
            ClinicalImpressionInvestigationsComponent dst = new ClinicalImpressionInvestigationsComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.item != null) {
                dst.item = new ArrayList<Reference>();
                for (Reference i : this.item) {
                    dst.item.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ClinicalImpressionInvestigationsComponent)) {
                return false;
            }
            ClinicalImpressionInvestigationsComponent o = (ClinicalImpressionInvestigationsComponent)other;
            return ClinicalImpressionInvestigationsComponent.compareDeep(this.code, o.code, true) && ClinicalImpressionInvestigationsComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ClinicalImpressionInvestigationsComponent)) {
                return false;
            }
            ClinicalImpressionInvestigationsComponent o = (ClinicalImpressionInvestigationsComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.item != null && !this.item.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClinicalImpression.investigations";
        }
    }

    public static class ClinicalImpressionStatusEnumFactory
    implements EnumFactory<ClinicalImpressionStatus> {
        @Override
        public ClinicalImpressionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return ClinicalImpressionStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return ClinicalImpressionStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ClinicalImpressionStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ClinicalImpressionStatus code '" + codeString + "'");
        }

        public Enumeration<ClinicalImpressionStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<ClinicalImpressionStatus>(this, ClinicalImpressionStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ClinicalImpressionStatus>(this, ClinicalImpressionStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ClinicalImpressionStatus>(this, ClinicalImpressionStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ClinicalImpressionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ClinicalImpressionStatus code) {
            if (code == ClinicalImpressionStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == ClinicalImpressionStatus.COMPLETED) {
                return "completed";
            }
            if (code == ClinicalImpressionStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ClinicalImpressionStatus code) {
            return code.getSystem();
        }
    }

    public static enum ClinicalImpressionStatus {
        INPROGRESS,
        COMPLETED,
        ENTEREDINERROR,
        NULL;


        public static ClinicalImpressionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown ClinicalImpressionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/clinical-impression-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/clinical-impression-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/clinical-impression-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "The assessment is still on-going and results are not yet final.";
                }
                case COMPLETED: {
                    return "The assessment is done and the results are final.";
                }
                case ENTEREDINERROR: {
                    return "This assessment was never actually done and the record is erroneous (e.g. Wrong patient).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

