/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Contract;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EligibilityRequest;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Money;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EligibilityResponse", profile="http://hl7.org/fhir/Profile/EligibilityResponse")
public class EligibilityResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="request", type={Identifier.class, EligibilityRequest.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Claim reference", formalDefinition="Original request resource reference.")
    protected Type request;
    @Child(name="outcome", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="complete | error", formalDefinition="Transaction status: error, complete.")
    protected Enumeration<Enumerations.RemittanceOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="ruleset", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource version", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="organization", type={Identifier.class, Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer", formalDefinition="The Insurer who produced this adjudicated response.")
    protected Type organization;
    @Child(name="requestProvider", type={Identifier.class, Practitioner.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Type requestProvider;
    @Child(name="requestOrganization", type={Identifier.class, Organization.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Type requestOrganization;
    @Child(name="inforce", type={BooleanType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage inforce", formalDefinition="Flag indicating if the coverage provided is inforce currently  if no service date(s) specified or for the whole duration of the service dates.")
    protected BooleanType inforce;
    @Child(name="contract", type={Contract.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Contract details", formalDefinition="The contract resource which may provide more detailed information.")
    protected Reference contract;
    protected Contract contractTarget;
    @Child(name="form", type={Coding.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    protected Coding form;
    @Child(name="benefitBalance", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Benefits by Category", formalDefinition="Benefits and optionally current balances by Category.")
    protected List<BenefitsComponent> benefitBalance;
    @Child(name="error", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Processing errors", formalDefinition="Mutually exclusive with Services Provided (Item).")
    protected List<ErrorsComponent> error;
    private static final long serialVersionUID = -674605791L;
    @SearchParamDefinition(name="requestorganizationreference", path="EligibilityResponse.requestOrganization.as(Reference)", description="The EligibilityRequest organization", type="reference")
    public static final String SP_REQUESTORGANIZATIONREFERENCE = "requestorganizationreference";
    public static final ReferenceClientParam REQUESTORGANIZATIONREFERENCE = new ReferenceClientParam("requestorganizationreference");
    public static final Include INCLUDE_REQUESTORGANIZATIONREFERENCE = new Include("EligibilityResponse:requestorganizationreference").toLocked();
    @SearchParamDefinition(name="created", path="EligibilityResponse.created", description="The creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="requestorganizationidentifier", path="EligibilityResponse.requestOrganization.as(Identifier)", description="The EligibilityRequest organization", type="token")
    public static final String SP_REQUESTORGANIZATIONIDENTIFIER = "requestorganizationidentifier";
    public static final TokenClientParam REQUESTORGANIZATIONIDENTIFIER = new TokenClientParam("requestorganizationidentifier");
    @SearchParamDefinition(name="requestprovideridentifier", path="EligibilityResponse.requestProvider.as(Identifier)", description="The EligibilityRequest provider", type="token")
    public static final String SP_REQUESTPROVIDERIDENTIFIER = "requestprovideridentifier";
    public static final TokenClientParam REQUESTPROVIDERIDENTIFIER = new TokenClientParam("requestprovideridentifier");
    @SearchParamDefinition(name="requestidentifier", path="EligibilityResponse.request.as(Identifier)", description="The EligibilityRequest reference", type="token")
    public static final String SP_REQUESTIDENTIFIER = "requestidentifier";
    public static final TokenClientParam REQUESTIDENTIFIER = new TokenClientParam("requestidentifier");
    @SearchParamDefinition(name="requestreference", path="EligibilityResponse.request.as(Reference)", description="The EligibilityRequest reference", type="reference")
    public static final String SP_REQUESTREFERENCE = "requestreference";
    public static final ReferenceClientParam REQUESTREFERENCE = new ReferenceClientParam("requestreference");
    public static final Include INCLUDE_REQUESTREFERENCE = new Include("EligibilityResponse:requestreference").toLocked();
    @SearchParamDefinition(name="organizationidentifier", path="EligibilityResponse.organization.as(Identifier)", description="The organization which generated this resource", type="token")
    public static final String SP_ORGANIZATIONIDENTIFIER = "organizationidentifier";
    public static final TokenClientParam ORGANIZATIONIDENTIFIER = new TokenClientParam("organizationidentifier");
    @SearchParamDefinition(name="requestproviderreference", path="EligibilityResponse.requestProvider.as(Reference)", description="The EligibilityRequest provider", type="reference")
    public static final String SP_REQUESTPROVIDERREFERENCE = "requestproviderreference";
    public static final ReferenceClientParam REQUESTPROVIDERREFERENCE = new ReferenceClientParam("requestproviderreference");
    public static final Include INCLUDE_REQUESTPROVIDERREFERENCE = new Include("EligibilityResponse:requestproviderreference").toLocked();
    @SearchParamDefinition(name="organizationreference", path="EligibilityResponse.organization.as(Reference)", description="The organization which generated this resource", type="reference")
    public static final String SP_ORGANIZATIONREFERENCE = "organizationreference";
    public static final ReferenceClientParam ORGANIZATIONREFERENCE = new ReferenceClientParam("organizationreference");
    public static final Include INCLUDE_ORGANIZATIONREFERENCE = new Include("EligibilityResponse:organizationreference").toLocked();
    @SearchParamDefinition(name="outcome", path="EligibilityResponse.outcome", description="The processing outcome", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="identifier", path="EligibilityResponse.identifier", description="The business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="disposition", path="EligibilityResponse.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EligibilityResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Type getRequest() {
        return this.request;
    }

    public Identifier getRequestIdentifier() throws FHIRException {
        if (!(this.request instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.request.getClass().getName() + " was encountered");
        }
        return (Identifier)this.request;
    }

    public boolean hasRequestIdentifier() {
        return this.request instanceof Identifier;
    }

    public Reference getRequestReference() throws FHIRException {
        if (!(this.request instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.request.getClass().getName() + " was encountered");
        }
        return (Reference)this.request;
    }

    public boolean hasRequestReference() {
        return this.request instanceof Reference;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public EligibilityResponse setRequest(Type value) {
        this.request = value;
        return this;
    }

    public Enumeration<Enumerations.RemittanceOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public EligibilityResponse setOutcomeElement(Enumeration<Enumerations.RemittanceOutcome> value) {
        this.outcome = value;
        return this;
    }

    public Enumerations.RemittanceOutcome getOutcome() {
        return this.outcome == null ? null : (Enumerations.RemittanceOutcome)((Object)this.outcome.getValue());
    }

    public EligibilityResponse setOutcome(Enumerations.RemittanceOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public EligibilityResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public EligibilityResponse setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public EligibilityResponse setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public EligibilityResponse setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public EligibilityResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public EligibilityResponse setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Type getOrganization() {
        return this.organization;
    }

    public Identifier getOrganizationIdentifier() throws FHIRException {
        if (!(this.organization instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Identifier)this.organization;
    }

    public boolean hasOrganizationIdentifier() {
        return this.organization instanceof Identifier;
    }

    public Reference getOrganizationReference() throws FHIRException {
        if (!(this.organization instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Reference)this.organization;
    }

    public boolean hasOrganizationReference() {
        return this.organization instanceof Reference;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public EligibilityResponse setOrganization(Type value) {
        this.organization = value;
        return this;
    }

    public Type getRequestProvider() {
        return this.requestProvider;
    }

    public Identifier getRequestProviderIdentifier() throws FHIRException {
        if (!(this.requestProvider instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.requestProvider.getClass().getName() + " was encountered");
        }
        return (Identifier)this.requestProvider;
    }

    public boolean hasRequestProviderIdentifier() {
        return this.requestProvider instanceof Identifier;
    }

    public Reference getRequestProviderReference() throws FHIRException {
        if (!(this.requestProvider instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.requestProvider.getClass().getName() + " was encountered");
        }
        return (Reference)this.requestProvider;
    }

    public boolean hasRequestProviderReference() {
        return this.requestProvider instanceof Reference;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public EligibilityResponse setRequestProvider(Type value) {
        this.requestProvider = value;
        return this;
    }

    public Type getRequestOrganization() {
        return this.requestOrganization;
    }

    public Identifier getRequestOrganizationIdentifier() throws FHIRException {
        if (!(this.requestOrganization instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.requestOrganization.getClass().getName() + " was encountered");
        }
        return (Identifier)this.requestOrganization;
    }

    public boolean hasRequestOrganizationIdentifier() {
        return this.requestOrganization instanceof Identifier;
    }

    public Reference getRequestOrganizationReference() throws FHIRException {
        if (!(this.requestOrganization instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.requestOrganization.getClass().getName() + " was encountered");
        }
        return (Reference)this.requestOrganization;
    }

    public boolean hasRequestOrganizationReference() {
        return this.requestOrganization instanceof Reference;
    }

    public boolean hasRequestOrganization() {
        return this.requestOrganization != null && !this.requestOrganization.isEmpty();
    }

    public EligibilityResponse setRequestOrganization(Type value) {
        this.requestOrganization = value;
        return this;
    }

    public BooleanType getInforceElement() {
        if (this.inforce == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.inforce");
            }
            if (Configuration.doAutoCreate()) {
                this.inforce = new BooleanType();
            }
        }
        return this.inforce;
    }

    public boolean hasInforceElement() {
        return this.inforce != null && !this.inforce.isEmpty();
    }

    public boolean hasInforce() {
        return this.inforce != null && !this.inforce.isEmpty();
    }

    public EligibilityResponse setInforceElement(BooleanType value) {
        this.inforce = value;
        return this;
    }

    public boolean getInforce() {
        return this.inforce == null || this.inforce.isEmpty() ? false : (Boolean)this.inforce.getValue();
    }

    public EligibilityResponse setInforce(boolean value) {
        if (this.inforce == null) {
            this.inforce = new BooleanType();
        }
        this.inforce.setValue((Object)value);
        return this;
    }

    public Reference getContract() {
        if (this.contract == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.contract");
            }
            if (Configuration.doAutoCreate()) {
                this.contract = new Reference();
            }
        }
        return this.contract;
    }

    public boolean hasContract() {
        return this.contract != null && !this.contract.isEmpty();
    }

    public EligibilityResponse setContract(Reference value) {
        this.contract = value;
        return this;
    }

    public Contract getContractTarget() {
        if (this.contractTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.contract");
            }
            if (Configuration.doAutoCreate()) {
                this.contractTarget = new Contract();
            }
        }
        return this.contractTarget;
    }

    public EligibilityResponse setContractTarget(Contract value) {
        this.contractTarget = value;
        return this;
    }

    public Coding getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new Coding();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public EligibilityResponse setForm(Coding value) {
        this.form = value;
        return this;
    }

    public List<BenefitsComponent> getBenefitBalance() {
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<BenefitsComponent>();
        }
        return this.benefitBalance;
    }

    public boolean hasBenefitBalance() {
        if (this.benefitBalance == null) {
            return false;
        }
        for (BenefitsComponent item : this.benefitBalance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BenefitsComponent addBenefitBalance() {
        BenefitsComponent t = new BenefitsComponent();
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<BenefitsComponent>();
        }
        this.benefitBalance.add(t);
        return t;
    }

    public EligibilityResponse addBenefitBalance(BenefitsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<BenefitsComponent>();
        }
        this.benefitBalance.add(t);
        return this;
    }

    public List<ErrorsComponent> getError() {
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        return this.error;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (ErrorsComponent item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ErrorsComponent addError() {
        ErrorsComponent t = new ErrorsComponent();
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        this.error.add(t);
        return t;
    }

    public EligibilityResponse addError(ErrorsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        this.error.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("request[x]", "Identifier|Reference(EligibilityRequest)", "Original request resource reference.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property(SP_OUTCOME, "code", "Transaction status: error, complete.", 0, Integer.MAX_VALUE, this.outcome));
        childrenList.add(new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, Integer.MAX_VALUE, this.disposition));
        childrenList.add(new Property("ruleset", "Coding", "The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property(SP_CREATED, "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("organization[x]", "Identifier|Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("requestProvider[x]", "Identifier|Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestProvider));
        childrenList.add(new Property("requestOrganization[x]", "Identifier|Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestOrganization));
        childrenList.add(new Property("inforce", "boolean", "Flag indicating if the coverage provided is inforce currently  if no service date(s) specified or for the whole duration of the service dates.", 0, Integer.MAX_VALUE, this.inforce));
        childrenList.add(new Property("contract", "Reference(Contract)", "The contract resource which may provide more detailed information.", 0, Integer.MAX_VALUE, this.contract));
        childrenList.add(new Property("form", "Coding", "The form to be used for printing the content.", 0, Integer.MAX_VALUE, this.form));
        childrenList.add(new Property("benefitBalance", "", "Benefits and optionally current balances by Category.", 0, Integer.MAX_VALUE, this.benefitBalance));
        childrenList.add(new Property("error", "", "Mutually exclusive with Services Provided (Item).", 0, Integer.MAX_VALUE, this.error));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.disposition;
                }
                return baseArray;
            }
            case 1548678118: {
                Base[] baseArray;
                if (this.ruleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.ruleset;
                }
                return baseArray;
            }
            case 1089373397: {
                Base[] baseArray;
                if (this.originalRuleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.originalRuleset;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.created;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.organization;
                }
                return baseArray;
            }
            case 1601527200: {
                Base[] baseArray;
                if (this.requestProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.requestProvider;
                }
                return baseArray;
            }
            case 599053666: {
                Base[] baseArray;
                if (this.requestOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.requestOrganization;
                }
                return baseArray;
            }
            case 1945431270: {
                Base[] baseArray;
                if (this.inforce == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.inforce;
                }
                return baseArray;
            }
            case -566947566: {
                Base[] baseArray;
                if (this.contract == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.contract;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.form;
                }
                return baseArray;
            }
            case 596003397: {
                return this.benefitBalance == null ? new Base[]{} : this.benefitBalance.toArray(new Base[this.benefitBalance.size()]);
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 1095692943: {
                this.request = (Type)value;
                break;
            }
            case -1106507950: {
                this.outcome = new Enumerations.RemittanceOutcomeEnumFactory().fromType(value);
                break;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                break;
            }
            case 1548678118: {
                this.ruleset = this.castToCoding(value);
                break;
            }
            case 1089373397: {
                this.originalRuleset = this.castToCoding(value);
                break;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                break;
            }
            case 1178922291: {
                this.organization = (Type)value;
                break;
            }
            case 1601527200: {
                this.requestProvider = (Type)value;
                break;
            }
            case 599053666: {
                this.requestOrganization = (Type)value;
                break;
            }
            case 1945431270: {
                this.inforce = this.castToBoolean(value);
                break;
            }
            case -566947566: {
                this.contract = this.castToReference(value);
                break;
            }
            case 3148996: {
                this.form = this.castToCoding(value);
                break;
            }
            case 596003397: {
                this.getBenefitBalance().add((BenefitsComponent)value);
                break;
            }
            case 96784904: {
                this.getError().add((ErrorsComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("request[x]")) {
            this.request = (Type)value;
        } else if (name.equals(SP_OUTCOME)) {
            this.outcome = new Enumerations.RemittanceOutcomeEnumFactory().fromType(value);
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = this.castToString(value);
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("organization[x]")) {
            this.organization = (Type)value;
        } else if (name.equals("requestProvider[x]")) {
            this.requestProvider = (Type)value;
        } else if (name.equals("requestOrganization[x]")) {
            this.requestOrganization = (Type)value;
        } else if (name.equals("inforce")) {
            this.inforce = this.castToBoolean(value);
        } else if (name.equals("contract")) {
            this.contract = this.castToReference(value);
        } else if (name.equals("form")) {
            this.form = this.castToCoding(value);
        } else if (name.equals("benefitBalance")) {
            this.getBenefitBalance().add((BenefitsComponent)value);
        } else if (name.equals("error")) {
            this.getError().add((ErrorsComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 37106577: {
                return this.getRequest();
            }
            case -1106507950: {
                throw new FHIRException("Cannot make property outcome as it is not a complex type");
            }
            case 583380919: {
                throw new FHIRException("Cannot make property disposition as it is not a complex type");
            }
            case 1548678118: {
                return this.getRuleset();
            }
            case 1089373397: {
                return this.getOriginalRuleset();
            }
            case 1028554472: {
                throw new FHIRException("Cannot make property created as it is not a complex type");
            }
            case 1326483053: {
                return this.getOrganization();
            }
            case -1694784800: {
                return this.getRequestProvider();
            }
            case 818740190: {
                return this.getRequestOrganization();
            }
            case 1945431270: {
                throw new FHIRException("Cannot make property inforce as it is not a complex type");
            }
            case -566947566: {
                return this.getContract();
            }
            case 3148996: {
                return this.getForm();
            }
            case 596003397: {
                return this.addBenefitBalance();
            }
            case 96784904: {
                return this.addError();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("requestIdentifier")) {
            this.request = new Identifier();
            return this.request;
        }
        if (name.equals("requestReference")) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_OUTCOME)) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.outcome");
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.disposition");
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.created");
        }
        if (name.equals("organizationIdentifier")) {
            this.organization = new Identifier();
            return this.organization;
        }
        if (name.equals("organizationReference")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("requestProviderIdentifier")) {
            this.requestProvider = new Identifier();
            return this.requestProvider;
        }
        if (name.equals("requestProviderReference")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        if (name.equals("requestOrganizationIdentifier")) {
            this.requestOrganization = new Identifier();
            return this.requestOrganization;
        }
        if (name.equals("requestOrganizationReference")) {
            this.requestOrganization = new Reference();
            return this.requestOrganization;
        }
        if (name.equals("inforce")) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.inforce");
        }
        if (name.equals("contract")) {
            this.contract = new Reference();
            return this.contract;
        }
        if (name.equals("form")) {
            this.form = new Coding();
            return this.form;
        }
        if (name.equals("benefitBalance")) {
            return this.addBenefitBalance();
        }
        if (name.equals("error")) {
            return this.addError();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EligibilityResponse";
    }

    @Override
    public EligibilityResponse copy() {
        EligibilityResponse dst = new EligibilityResponse();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
        dst.requestOrganization = this.requestOrganization == null ? null : this.requestOrganization.copy();
        dst.inforce = this.inforce == null ? null : this.inforce.copy();
        dst.contract = this.contract == null ? null : this.contract.copy();
        Coding coding = dst.form = this.form == null ? null : this.form.copy();
        if (this.benefitBalance != null) {
            dst.benefitBalance = new ArrayList<BenefitsComponent>();
            for (BenefitsComponent benefitsComponent : this.benefitBalance) {
                dst.benefitBalance.add(benefitsComponent.copy());
            }
        }
        if (this.error != null) {
            dst.error = new ArrayList<ErrorsComponent>();
            for (ErrorsComponent errorsComponent : this.error) {
                dst.error.add(errorsComponent.copy());
            }
        }
        return dst;
    }

    protected EligibilityResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof EligibilityResponse)) {
            return false;
        }
        EligibilityResponse o = (EligibilityResponse)other;
        return EligibilityResponse.compareDeep(this.identifier, o.identifier, true) && EligibilityResponse.compareDeep(this.request, o.request, true) && EligibilityResponse.compareDeep(this.outcome, o.outcome, true) && EligibilityResponse.compareDeep(this.disposition, o.disposition, true) && EligibilityResponse.compareDeep(this.ruleset, o.ruleset, true) && EligibilityResponse.compareDeep(this.originalRuleset, o.originalRuleset, true) && EligibilityResponse.compareDeep(this.created, o.created, true) && EligibilityResponse.compareDeep(this.organization, o.organization, true) && EligibilityResponse.compareDeep(this.requestProvider, o.requestProvider, true) && EligibilityResponse.compareDeep(this.requestOrganization, o.requestOrganization, true) && EligibilityResponse.compareDeep(this.inforce, o.inforce, true) && EligibilityResponse.compareDeep(this.contract, o.contract, true) && EligibilityResponse.compareDeep(this.form, o.form, true) && EligibilityResponse.compareDeep(this.benefitBalance, o.benefitBalance, true) && EligibilityResponse.compareDeep(this.error, o.error, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof EligibilityResponse)) {
            return false;
        }
        EligibilityResponse o = (EligibilityResponse)other;
        return EligibilityResponse.compareValues(this.outcome, o.outcome, true) && EligibilityResponse.compareValues(this.disposition, o.disposition, true) && EligibilityResponse.compareValues(this.created, o.created, true) && EligibilityResponse.compareValues(this.inforce, o.inforce, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.request != null && !this.request.isEmpty() || this.outcome != null && !this.outcome.isEmpty() || this.disposition != null && !this.disposition.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.requestProvider != null && !this.requestProvider.isEmpty() || this.requestOrganization != null && !this.requestOrganization.isEmpty() || this.inforce != null && !this.inforce.isEmpty() || this.contract != null && !this.contract.isEmpty() || this.form != null && !this.form.isEmpty() || this.benefitBalance != null && !this.benefitBalance.isEmpty() || this.error != null && !this.error.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EligibilityResponse;
    }

    @Block
    public static class ErrorsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Error code detailing processing issues", formalDefinition="An error code,from a specified code system, which details why the eligibility check could not be performed.")
        protected Coding code;
        private static final long serialVersionUID = -739538393L;

        public ErrorsComponent() {
        }

        public ErrorsComponent(Coding code) {
            this.code = code;
        }

        public Coding getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Coding();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ErrorsComponent setCode(Coding value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "Coding", "An error code,from a specified code system, which details why the eligibility check could not be performed.", 0, Integer.MAX_VALUE, this.code));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new Coding();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ErrorsComponent copy() {
            ErrorsComponent dst = new ErrorsComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ErrorsComponent)) {
                return false;
            }
            ErrorsComponent o = (ErrorsComponent)other;
            return ErrorsComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ErrorsComponent)) {
                return false;
            }
            ErrorsComponent o = (ErrorsComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.code == null || this.code.isEmpty());
        }

        @Override
        public String fhirType() {
            return "EligibilityResponse.error";
        }
    }

    @Block
    public static class BenefitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Deductable, visits, benefit amount", formalDefinition="Deductable, visits, benefit amount.")
        protected Coding type;
        @Child(name="benefit", type={UnsignedIntType.class, Money.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Benefits allowed", formalDefinition="Benefits allowed.")
        protected Type benefit;
        @Child(name="benefitUsed", type={UnsignedIntType.class, Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Benefits used", formalDefinition="Benefits used.")
        protected Type benefitUsed;
        private static final long serialVersionUID = 1742418909L;

        public BenefitComponent() {
        }

        public BenefitComponent(Coding type) {
            this.type = type;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public BenefitComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Type getBenefit() {
            return this.benefit;
        }

        public UnsignedIntType getBenefitUnsignedIntType() throws FHIRException {
            if (!(this.benefit instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.benefit.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.benefit;
        }

        public boolean hasBenefitUnsignedIntType() {
            return this.benefit instanceof UnsignedIntType;
        }

        public Money getBenefitMoney() throws FHIRException {
            if (!(this.benefit instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.benefit.getClass().getName() + " was encountered");
            }
            return (Money)this.benefit;
        }

        public boolean hasBenefitMoney() {
            return this.benefit instanceof Money;
        }

        public boolean hasBenefit() {
            return this.benefit != null && !this.benefit.isEmpty();
        }

        public BenefitComponent setBenefit(Type value) {
            this.benefit = value;
            return this;
        }

        public Type getBenefitUsed() {
            return this.benefitUsed;
        }

        public UnsignedIntType getBenefitUsedUnsignedIntType() throws FHIRException {
            if (!(this.benefitUsed instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.benefitUsed.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.benefitUsed;
        }

        public boolean hasBenefitUsedUnsignedIntType() {
            return this.benefitUsed instanceof UnsignedIntType;
        }

        public Money getBenefitUsedMoney() throws FHIRException {
            if (!(this.benefitUsed instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.benefitUsed.getClass().getName() + " was encountered");
            }
            return (Money)this.benefitUsed;
        }

        public boolean hasBenefitUsedMoney() {
            return this.benefitUsed instanceof Money;
        }

        public boolean hasBenefitUsed() {
            return this.benefitUsed != null && !this.benefitUsed.isEmpty();
        }

        public BenefitComponent setBenefitUsed(Type value) {
            this.benefitUsed = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "Deductable, visits, benefit amount.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("benefit[x]", "unsignedInt|Money", "Benefits allowed.", 0, Integer.MAX_VALUE, this.benefit));
            childrenList.add(new Property("benefitUsed[x]", "unsignedInt|Money", "Benefits used.", 0, Integer.MAX_VALUE, this.benefitUsed));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -222710633: {
                    Base[] baseArray;
                    if (this.benefit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.benefit;
                    }
                    return baseArray;
                }
                case -549981964: {
                    Base[] baseArray;
                    if (this.benefitUsed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.benefitUsed;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case -222710633: {
                    this.benefit = (Type)value;
                    break;
                }
                case -549981964: {
                    this.benefitUsed = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("benefit[x]")) {
                this.benefit = (Type)value;
            } else if (name.equals("benefitUsed[x]")) {
                this.benefitUsed = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 952095881: {
                    return this.getBenefit();
                }
                case 787635980: {
                    return this.getBenefitUsed();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("benefitUnsignedInt")) {
                this.benefit = new UnsignedIntType();
                return this.benefit;
            }
            if (name.equals("benefitMoney")) {
                this.benefit = new Money();
                return this.benefit;
            }
            if (name.equals("benefitUsedUnsignedInt")) {
                this.benefitUsed = new UnsignedIntType();
                return this.benefitUsed;
            }
            if (name.equals("benefitUsedMoney")) {
                this.benefitUsed = new Money();
                return this.benefitUsed;
            }
            return super.addChild(name);
        }

        @Override
        public BenefitComponent copy() {
            BenefitComponent dst = new BenefitComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.benefit = this.benefit == null ? null : this.benefit.copy();
            dst.benefitUsed = this.benefitUsed == null ? null : this.benefitUsed.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other;
            return BenefitComponent.compareDeep(this.type, o.type, true) && BenefitComponent.compareDeep(this.benefit, o.benefit, true) && BenefitComponent.compareDeep(this.benefitUsed, o.benefitUsed, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.benefit != null && !this.benefit.isEmpty() || this.benefitUsed != null && !this.benefitUsed.isEmpty());
        }

        @Override
        public String fhirType() {
            return "EligibilityResponse.benefitBalance.financial";
        }
    }

    @Block
    public static class BenefitsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Benefit Category", formalDefinition="Dental, Vision, Medical, Pharmacy, Rehab etc.")
        protected Coding category;
        @Child(name="subCategory", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Benefit SubCategory", formalDefinition="Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.")
        protected Coding subCategory;
        @Child(name="network", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="In or out of network", formalDefinition="Network designation.")
        protected Coding network;
        @Child(name="unit", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Individual or family", formalDefinition="Unit designation: individual or family.")
        protected Coding unit;
        @Child(name="term", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Annual or lifetime", formalDefinition="The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.")
        protected Coding term;
        @Child(name="financial", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Benefit Summary", formalDefinition="Benefits Used to date.")
        protected List<BenefitComponent> financial;
        private static final long serialVersionUID = 1708176773L;

        public BenefitsComponent() {
        }

        public BenefitsComponent(Coding category) {
            this.category = category;
        }

        public Coding getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Coding();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public BenefitsComponent setCategory(Coding value) {
            this.category = value;
            return this;
        }

        public Coding getSubCategory() {
            if (this.subCategory == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.subCategory");
                }
                if (Configuration.doAutoCreate()) {
                    this.subCategory = new Coding();
                }
            }
            return this.subCategory;
        }

        public boolean hasSubCategory() {
            return this.subCategory != null && !this.subCategory.isEmpty();
        }

        public BenefitsComponent setSubCategory(Coding value) {
            this.subCategory = value;
            return this;
        }

        public Coding getNetwork() {
            if (this.network == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.network");
                }
                if (Configuration.doAutoCreate()) {
                    this.network = new Coding();
                }
            }
            return this.network;
        }

        public boolean hasNetwork() {
            return this.network != null && !this.network.isEmpty();
        }

        public BenefitsComponent setNetwork(Coding value) {
            this.network = value;
            return this;
        }

        public Coding getUnit() {
            if (this.unit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.unit");
                }
                if (Configuration.doAutoCreate()) {
                    this.unit = new Coding();
                }
            }
            return this.unit;
        }

        public boolean hasUnit() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public BenefitsComponent setUnit(Coding value) {
            this.unit = value;
            return this;
        }

        public Coding getTerm() {
            if (this.term == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.term");
                }
                if (Configuration.doAutoCreate()) {
                    this.term = new Coding();
                }
            }
            return this.term;
        }

        public boolean hasTerm() {
            return this.term != null && !this.term.isEmpty();
        }

        public BenefitsComponent setTerm(Coding value) {
            this.term = value;
            return this;
        }

        public List<BenefitComponent> getFinancial() {
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            return this.financial;
        }

        public boolean hasFinancial() {
            if (this.financial == null) {
                return false;
            }
            for (BenefitComponent item : this.financial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BenefitComponent addFinancial() {
            BenefitComponent t = new BenefitComponent();
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            this.financial.add(t);
            return t;
        }

        public BenefitsComponent addFinancial(BenefitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            this.financial.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("category", "Coding", "Dental, Vision, Medical, Pharmacy, Rehab etc.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property("subCategory", "Coding", "Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.", 0, Integer.MAX_VALUE, this.subCategory));
            childrenList.add(new Property("network", "Coding", "Network designation.", 0, Integer.MAX_VALUE, this.network));
            childrenList.add(new Property("unit", "Coding", "Unit designation: individual or family.", 0, Integer.MAX_VALUE, this.unit));
            childrenList.add(new Property("term", "Coding", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.", 0, Integer.MAX_VALUE, this.term));
            childrenList.add(new Property("financial", "", "Benefits Used to date.", 0, Integer.MAX_VALUE, this.financial));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 1365024606: {
                    Base[] baseArray;
                    if (this.subCategory == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.subCategory;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    Base[] baseArray;
                    if (this.network == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.network;
                    }
                    return baseArray;
                }
                case 3594628: {
                    Base[] baseArray;
                    if (this.unit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.unit;
                    }
                    return baseArray;
                }
                case 3556460: {
                    Base[] baseArray;
                    if (this.term == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.term;
                    }
                    return baseArray;
                }
                case 357555337: {
                    return this.financial == null ? new Base[]{} : this.financial.toArray(new Base[this.financial.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCoding(value);
                    break;
                }
                case 1365024606: {
                    this.subCategory = this.castToCoding(value);
                    break;
                }
                case 1843485230: {
                    this.network = this.castToCoding(value);
                    break;
                }
                case 3594628: {
                    this.unit = this.castToCoding(value);
                    break;
                }
                case 3556460: {
                    this.term = this.castToCoding(value);
                    break;
                }
                case 357555337: {
                    this.getFinancial().add((BenefitComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCoding(value);
            } else if (name.equals("subCategory")) {
                this.subCategory = this.castToCoding(value);
            } else if (name.equals("network")) {
                this.network = this.castToCoding(value);
            } else if (name.equals("unit")) {
                this.unit = this.castToCoding(value);
            } else if (name.equals("term")) {
                this.term = this.castToCoding(value);
            } else if (name.equals("financial")) {
                this.getFinancial().add((BenefitComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 1365024606: {
                    return this.getSubCategory();
                }
                case 1843485230: {
                    return this.getNetwork();
                }
                case 3594628: {
                    return this.getUnit();
                }
                case 3556460: {
                    return this.getTerm();
                }
                case 357555337: {
                    return this.addFinancial();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new Coding();
                return this.category;
            }
            if (name.equals("subCategory")) {
                this.subCategory = new Coding();
                return this.subCategory;
            }
            if (name.equals("network")) {
                this.network = new Coding();
                return this.network;
            }
            if (name.equals("unit")) {
                this.unit = new Coding();
                return this.unit;
            }
            if (name.equals("term")) {
                this.term = new Coding();
                return this.term;
            }
            if (name.equals("financial")) {
                return this.addFinancial();
            }
            return super.addChild(name);
        }

        @Override
        public BenefitsComponent copy() {
            BenefitsComponent dst = new BenefitsComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.subCategory = this.subCategory == null ? null : this.subCategory.copy();
            dst.network = this.network == null ? null : this.network.copy();
            dst.unit = this.unit == null ? null : this.unit.copy();
            Coding coding = dst.term = this.term == null ? null : this.term.copy();
            if (this.financial != null) {
                dst.financial = new ArrayList<BenefitComponent>();
                for (BenefitComponent i : this.financial) {
                    dst.financial.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof BenefitsComponent)) {
                return false;
            }
            BenefitsComponent o = (BenefitsComponent)other;
            return BenefitsComponent.compareDeep(this.category, o.category, true) && BenefitsComponent.compareDeep(this.subCategory, o.subCategory, true) && BenefitsComponent.compareDeep(this.network, o.network, true) && BenefitsComponent.compareDeep(this.unit, o.unit, true) && BenefitsComponent.compareDeep(this.term, o.term, true) && BenefitsComponent.compareDeep(this.financial, o.financial, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof BenefitsComponent)) {
                return false;
            }
            BenefitsComponent o = (BenefitsComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.category != null && !this.category.isEmpty() || this.subCategory != null && !this.subCategory.isEmpty() || this.network != null && !this.network.isEmpty() || this.unit != null && !this.unit.isEmpty() || this.term != null && !this.term.isEmpty() || this.financial != null && !this.financial.isEmpty());
        }

        @Override
        public String fhirType() {
            return "EligibilityResponse.benefitBalance";
        }
    }
}

