/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Identifier")
public class Identifier
extends Type
implements ICompositeType {
    @Child(name="use", type={CodeType.class}, order=0, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="usual | official | temp | secondary (If known)", formalDefinition="The purpose of this identifier.")
    protected Enumeration<IdentifierUse> use;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of identifier", formalDefinition="A coded type for the identifier that can be used to determine which identifier to use for a specific purpose.")
    protected CodeableConcept type;
    @Child(name="system", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The namespace for the identifier", formalDefinition="Establishes the namespace in which set of possible id values is unique.")
    protected UriType system;
    @Child(name="value", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The value that is unique", formalDefinition="The portion of the identifier typically relevant to the user and which is unique within the context of the system.")
    protected StringType value;
    @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period when id is/was valid for use", formalDefinition="Time period during which identifier is/was valid for use.")
    protected Period period;
    @Child(name="assigner", type={Organization.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that issued id (may be just text)", formalDefinition="Organization that issued/manages the identifier.")
    protected Reference assigner;
    protected Organization assignerTarget;
    private static final long serialVersionUID = -478840981L;

    public Enumeration<IdentifierUse> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<IdentifierUse>(new IdentifierUseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public Identifier setUseElement(Enumeration<IdentifierUse> value) {
        this.use = value;
        return this;
    }

    public IdentifierUse getUse() {
        return this.use == null ? null : (IdentifierUse)((Object)this.use.getValue());
    }

    public Identifier setUse(IdentifierUse value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<IdentifierUse>(new IdentifierUseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Identifier setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public UriType getSystemElement() {
        if (this.system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.system");
            }
            if (Configuration.doAutoCreate()) {
                this.system = new UriType();
            }
        }
        return this.system;
    }

    public boolean hasSystemElement() {
        return this.system != null && !this.system.isEmpty();
    }

    public boolean hasSystem() {
        return this.system != null && !this.system.isEmpty();
    }

    public Identifier setSystemElement(UriType value) {
        this.system = value;
        return this;
    }

    public String getSystem() {
        return this.system == null ? null : (String)this.system.getValue();
    }

    public Identifier setSystem(String value) {
        if (Utilities.noString((String)value)) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
        }
        return this;
    }

    public StringType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new StringType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public Identifier setValueElement(StringType value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value == null ? null : (String)this.value.getValue();
    }

    public Identifier setValue(String value) {
        if (Utilities.noString((String)value)) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
        }
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Identifier setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getAssigner() {
        if (this.assigner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.assigner");
            }
            if (Configuration.doAutoCreate()) {
                this.assigner = new Reference();
            }
        }
        return this.assigner;
    }

    public boolean hasAssigner() {
        return this.assigner != null && !this.assigner.isEmpty();
    }

    public Identifier setAssigner(Reference value) {
        this.assigner = value;
        return this;
    }

    public Organization getAssignerTarget() {
        if (this.assignerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.assigner");
            }
            if (Configuration.doAutoCreate()) {
                this.assignerTarget = new Organization();
            }
        }
        return this.assignerTarget;
    }

    public Identifier setAssignerTarget(Organization value) {
        this.assignerTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("use", "code", "The purpose of this identifier.", 0, Integer.MAX_VALUE, this.use));
        childrenList.add(new Property("type", "CodeableConcept", "A coded type for the identifier that can be used to determine which identifier to use for a specific purpose.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("system", "uri", "Establishes the namespace in which set of possible id values is unique.", 0, Integer.MAX_VALUE, this.system));
        childrenList.add(new Property("value", "string", "The portion of the identifier typically relevant to the user and which is unique within the context of the system.", 0, Integer.MAX_VALUE, this.value));
        childrenList.add(new Property("period", "Period", "Time period during which identifier is/was valid for use.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property("assigner", "Reference(Organization)", "Organization that issued/manages the identifier.", 0, Integer.MAX_VALUE, this.assigner));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.use;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -887328209: {
                Base[] baseArray;
                if (this.system == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.system;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.value;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.period;
                }
                return baseArray;
            }
            case -369881636: {
                Base[] baseArray;
                if (this.assigner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.assigner;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116103: {
                this.use = new IdentifierUseEnumFactory().fromType(value);
                break;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                break;
            }
            case -887328209: {
                this.system = this.castToUri(value);
                break;
            }
            case 111972721: {
                this.value = this.castToString(value);
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case -369881636: {
                this.assigner = this.castToReference(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("use")) {
            this.use = new IdentifierUseEnumFactory().fromType(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("system")) {
            this.system = this.castToUri(value);
        } else if (name.equals("value")) {
            this.value = this.castToString(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("assigner")) {
            this.assigner = this.castToReference(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116103: {
                throw new FHIRException("Cannot make property use as it is not a complex type");
            }
            case 3575610: {
                return this.getType();
            }
            case -887328209: {
                throw new FHIRException("Cannot make property system as it is not a complex type");
            }
            case 111972721: {
                throw new FHIRException("Cannot make property value as it is not a complex type");
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -369881636: {
                return this.getAssigner();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a singleton property Identifier.use");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("system")) {
            throw new FHIRException("Cannot call addChild on a singleton property Identifier.system");
        }
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property Identifier.value");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("assigner")) {
            this.assigner = new Reference();
            return this.assigner;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Identifier";
    }

    @Override
    public Identifier copy() {
        Identifier dst = new Identifier();
        this.copyValues(dst);
        dst.use = this.use == null ? null : this.use.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.system = this.system == null ? null : this.system.copy();
        dst.value = this.value == null ? null : this.value.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.assigner = this.assigner == null ? null : this.assigner.copy();
        return dst;
    }

    @Override
    protected Identifier typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Identifier)) {
            return false;
        }
        Identifier o = (Identifier)other;
        return Identifier.compareDeep(this.use, o.use, true) && Identifier.compareDeep(this.type, o.type, true) && Identifier.compareDeep(this.system, o.system, true) && Identifier.compareDeep(this.value, o.value, true) && Identifier.compareDeep(this.period, o.period, true) && Identifier.compareDeep(this.assigner, o.assigner, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Identifier)) {
            return false;
        }
        Identifier o = (Identifier)other;
        return Identifier.compareValues(this.use, o.use, true) && Identifier.compareValues(this.system, o.system, true) && Identifier.compareValues(this.value, o.value, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.use != null && !this.use.isEmpty() || this.type != null && !this.type.isEmpty() || this.system != null && !this.system.isEmpty() || this.value != null && !this.value.isEmpty() || this.period != null && !this.period.isEmpty() || this.assigner != null && !this.assigner.isEmpty());
    }

    public static class IdentifierUseEnumFactory
    implements EnumFactory<IdentifierUse> {
        @Override
        public IdentifierUse fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return IdentifierUse.USUAL;
            }
            if ("official".equals(codeString)) {
                return IdentifierUse.OFFICIAL;
            }
            if ("temp".equals(codeString)) {
                return IdentifierUse.TEMP;
            }
            if ("secondary".equals(codeString)) {
                return IdentifierUse.SECONDARY;
            }
            throw new IllegalArgumentException("Unknown IdentifierUse code '" + codeString + "'");
        }

        public Enumeration<IdentifierUse> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.USUAL);
            }
            if ("official".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.OFFICIAL);
            }
            if ("temp".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.TEMP);
            }
            if ("secondary".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.SECONDARY);
            }
            throw new FHIRException("Unknown IdentifierUse code '" + codeString + "'");
        }

        @Override
        public String toCode(IdentifierUse code) {
            if (code == IdentifierUse.USUAL) {
                return "usual";
            }
            if (code == IdentifierUse.OFFICIAL) {
                return "official";
            }
            if (code == IdentifierUse.TEMP) {
                return "temp";
            }
            if (code == IdentifierUse.SECONDARY) {
                return "secondary";
            }
            return "?";
        }

        @Override
        public String toSystem(IdentifierUse code) {
            return code.getSystem();
        }
    }

    public static enum IdentifierUse {
        USUAL,
        OFFICIAL,
        TEMP,
        SECONDARY,
        NULL;


        public static IdentifierUse fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return USUAL;
            }
            if ("official".equals(codeString)) {
                return OFFICIAL;
            }
            if ("temp".equals(codeString)) {
                return TEMP;
            }
            if ("secondary".equals(codeString)) {
                return SECONDARY;
            }
            throw new FHIRException("Unknown IdentifierUse code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case USUAL: {
                    return "usual";
                }
                case OFFICIAL: {
                    return "official";
                }
                case TEMP: {
                    return "temp";
                }
                case SECONDARY: {
                    return "secondary";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case USUAL: {
                    return "http://hl7.org/fhir/identifier-use";
                }
                case OFFICIAL: {
                    return "http://hl7.org/fhir/identifier-use";
                }
                case TEMP: {
                    return "http://hl7.org/fhir/identifier-use";
                }
                case SECONDARY: {
                    return "http://hl7.org/fhir/identifier-use";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case USUAL: {
                    return "The identifier recommended for display and use in real-world interactions.";
                }
                case OFFICIAL: {
                    return "The identifier considered to be most trusted for the identification of this item.";
                }
                case TEMP: {
                    return "A temporary identifier.";
                }
                case SECONDARY: {
                    return "An identifier that was assigned in secondary use - it serves to identify the object in a relative context, but cannot be consistently assigned to the same object again in a different context.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case USUAL: {
                    return "Usual";
                }
                case OFFICIAL: {
                    return "Official";
                }
                case TEMP: {
                    return "Temp";
                }
                case SECONDARY: {
                    return "Secondary";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

