/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.IdentifierUse;

public class IdentifierUseEnumFactory
implements EnumFactory<IdentifierUse> {
    @Override
    public IdentifierUse fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("usual".equals(codeString)) {
            return IdentifierUse.USUAL;
        }
        if ("official".equals(codeString)) {
            return IdentifierUse.OFFICIAL;
        }
        if ("temp".equals(codeString)) {
            return IdentifierUse.TEMP;
        }
        if ("secondary".equals(codeString)) {
            return IdentifierUse.SECONDARY;
        }
        throw new IllegalArgumentException("Unknown IdentifierUse code '" + codeString + "'");
    }

    @Override
    public String toCode(IdentifierUse code) {
        if (code == IdentifierUse.USUAL) {
            return "usual";
        }
        if (code == IdentifierUse.OFFICIAL) {
            return "official";
        }
        if (code == IdentifierUse.TEMP) {
            return "temp";
        }
        if (code == IdentifierUse.SECONDARY) {
            return "secondary";
        }
        return "?";
    }

    @Override
    public String toSystem(IdentifierUse code) {
        return code.getSystem();
    }
}

