/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.MedicationOrderStatus;

public class MedicationOrderStatusEnumFactory
implements EnumFactory<MedicationOrderStatus> {
    @Override
    public MedicationOrderStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return MedicationOrderStatus.ACTIVE;
        }
        if ("on-hold".equals(codeString)) {
            return MedicationOrderStatus.ONHOLD;
        }
        if ("completed".equals(codeString)) {
            return MedicationOrderStatus.COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return MedicationOrderStatus.ENTEREDINERROR;
        }
        if ("stopped".equals(codeString)) {
            return MedicationOrderStatus.STOPPED;
        }
        if ("draft".equals(codeString)) {
            return MedicationOrderStatus.DRAFT;
        }
        throw new IllegalArgumentException("Unknown MedicationOrderStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(MedicationOrderStatus code) {
        if (code == MedicationOrderStatus.ACTIVE) {
            return "active";
        }
        if (code == MedicationOrderStatus.ONHOLD) {
            return "on-hold";
        }
        if (code == MedicationOrderStatus.COMPLETED) {
            return "completed";
        }
        if (code == MedicationOrderStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        if (code == MedicationOrderStatus.STOPPED) {
            return "stopped";
        }
        if (code == MedicationOrderStatus.DRAFT) {
            return "draft";
        }
        return "?";
    }

    @Override
    public String toSystem(MedicationOrderStatus code) {
        return code.getSystem();
    }
}

