/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaNehtaDysplasia {
    WITHDYSPLASIA,
    WITHOUTDYSPLASIA,
    NULL;


    public static NehtaNehtaDysplasia fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("with_dysplasia".equals(codeString)) {
            return WITHDYSPLASIA;
        }
        if ("without_dysplasia".equals(codeString)) {
            return WITHOUTDYSPLASIA;
        }
        throw new FHIRException("Unknown NehtaNehtaDysplasia code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case WITHDYSPLASIA: {
                return "with_dysplasia";
            }
            case WITHOUTDYSPLASIA: {
                return "without_dysplasia";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nehta-dysplasia";
    }

    public String getDefinition() {
        switch (this) {
            case WITHDYSPLASIA: {
                return "Indicates the presence of dysplasia";
            }
            case WITHOUTDYSPLASIA: {
                return "Indicates the absence of dysplasia";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case WITHDYSPLASIA: {
                return "With dysplasia";
            }
            case WITHOUTDYSPLASIA: {
                return "Without dysplasia";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

