/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DataRequirement;
import org.hl7.fhir.dstu2016may.model.DecisionSupportRule;
import org.hl7.fhir.dstu2016may.model.DecisionSupportServiceModule;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Duration;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Parameters;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Person;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="GuidanceResponse", profile="http://hl7.org/fhir/Profile/GuidanceResponse")
public class GuidanceResponse
extends DomainResource {
    @Child(name="requestId", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The id of the request associated with this response, if any", formalDefinition="The id of the request associated with this response. If an id was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.")
    protected StringType requestId;
    @Child(name="module", type={DecisionSupportServiceModule.class, DecisionSupportRule.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="A reference to a knowledge module", formalDefinition="A reference to the knowledge module that was invoked.")
    protected Reference module;
    protected Resource moduleTarget;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="success | data-requested | data-required | in-progress | failure", formalDefinition="The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.")
    protected Enumeration<GuidanceResponseStatus> status;
    @Child(name="evaluationMessage", type={OperationOutcome.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Messages resulting from the evaluation of the artifact or artifacts", formalDefinition="Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.")
    protected List<Reference> evaluationMessage;
    protected List<OperationOutcome> evaluationMessageTarget;
    @Child(name="outputParameters", type={Parameters.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The output parameters of the evaluation, if any", formalDefinition="The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.")
    protected Reference outputParameters;
    protected Parameters outputParametersTarget;
    @Child(name="action", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Proposed actions, if any", formalDefinition="The actions, if any, produced by the evaluation of the artifact.")
    protected List<GuidanceResponseActionComponent> action;
    @Child(name="dataRequirement", type={DataRequirement.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional required data", formalDefinition="If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.")
    protected List<DataRequirement> dataRequirement;
    private static final long serialVersionUID = -918912174L;

    public GuidanceResponse() {
    }

    public GuidanceResponse(Reference module, Enumeration<GuidanceResponseStatus> status) {
        this.module = module;
        this.status = status;
    }

    public StringType getRequestIdElement() {
        if (this.requestId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.requestId");
            }
            if (Configuration.doAutoCreate()) {
                this.requestId = new StringType();
            }
        }
        return this.requestId;
    }

    public boolean hasRequestIdElement() {
        return this.requestId != null && !this.requestId.isEmpty();
    }

    public boolean hasRequestId() {
        return this.requestId != null && !this.requestId.isEmpty();
    }

    public GuidanceResponse setRequestIdElement(StringType value) {
        this.requestId = value;
        return this;
    }

    public String getRequestId() {
        return this.requestId == null ? null : (String)this.requestId.getValue();
    }

    public GuidanceResponse setRequestId(String value) {
        if (Utilities.noString((String)value)) {
            this.requestId = null;
        } else {
            if (this.requestId == null) {
                this.requestId = new StringType();
            }
            this.requestId.setValue(value);
        }
        return this;
    }

    public Reference getModule() {
        if (this.module == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.module");
            }
            if (Configuration.doAutoCreate()) {
                this.module = new Reference();
            }
        }
        return this.module;
    }

    public boolean hasModule() {
        return this.module != null && !this.module.isEmpty();
    }

    public GuidanceResponse setModule(Reference value) {
        this.module = value;
        return this;
    }

    public Resource getModuleTarget() {
        return this.moduleTarget;
    }

    public GuidanceResponse setModuleTarget(Resource value) {
        this.moduleTarget = value;
        return this;
    }

    public Enumeration<GuidanceResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<GuidanceResponseStatus>(new GuidanceResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public GuidanceResponse setStatusElement(Enumeration<GuidanceResponseStatus> value) {
        this.status = value;
        return this;
    }

    public GuidanceResponseStatus getStatus() {
        return this.status == null ? null : (GuidanceResponseStatus)((Object)this.status.getValue());
    }

    public GuidanceResponse setStatus(GuidanceResponseStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<GuidanceResponseStatus>(new GuidanceResponseStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<Reference> getEvaluationMessage() {
        if (this.evaluationMessage == null) {
            this.evaluationMessage = new ArrayList<Reference>();
        }
        return this.evaluationMessage;
    }

    public boolean hasEvaluationMessage() {
        if (this.evaluationMessage == null) {
            return false;
        }
        for (Reference item : this.evaluationMessage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEvaluationMessage() {
        Reference t = new Reference();
        if (this.evaluationMessage == null) {
            this.evaluationMessage = new ArrayList<Reference>();
        }
        this.evaluationMessage.add(t);
        return t;
    }

    public GuidanceResponse addEvaluationMessage(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.evaluationMessage == null) {
            this.evaluationMessage = new ArrayList<Reference>();
        }
        this.evaluationMessage.add(t);
        return this;
    }

    public List<OperationOutcome> getEvaluationMessageTarget() {
        if (this.evaluationMessageTarget == null) {
            this.evaluationMessageTarget = new ArrayList<OperationOutcome>();
        }
        return this.evaluationMessageTarget;
    }

    public OperationOutcome addEvaluationMessageTarget() {
        OperationOutcome r = new OperationOutcome();
        if (this.evaluationMessageTarget == null) {
            this.evaluationMessageTarget = new ArrayList<OperationOutcome>();
        }
        this.evaluationMessageTarget.add(r);
        return r;
    }

    public Reference getOutputParameters() {
        if (this.outputParameters == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.outputParameters");
            }
            if (Configuration.doAutoCreate()) {
                this.outputParameters = new Reference();
            }
        }
        return this.outputParameters;
    }

    public boolean hasOutputParameters() {
        return this.outputParameters != null && !this.outputParameters.isEmpty();
    }

    public GuidanceResponse setOutputParameters(Reference value) {
        this.outputParameters = value;
        return this;
    }

    public Parameters getOutputParametersTarget() {
        if (this.outputParametersTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.outputParameters");
            }
            if (Configuration.doAutoCreate()) {
                this.outputParametersTarget = new Parameters();
            }
        }
        return this.outputParametersTarget;
    }

    public GuidanceResponse setOutputParametersTarget(Parameters value) {
        this.outputParametersTarget = value;
        return this;
    }

    public List<GuidanceResponseActionComponent> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<GuidanceResponseActionComponent>();
        }
        return this.action;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (GuidanceResponseActionComponent item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GuidanceResponseActionComponent addAction() {
        GuidanceResponseActionComponent t = new GuidanceResponseActionComponent();
        if (this.action == null) {
            this.action = new ArrayList<GuidanceResponseActionComponent>();
        }
        this.action.add(t);
        return t;
    }

    public GuidanceResponse addAction(GuidanceResponseActionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<GuidanceResponseActionComponent>();
        }
        this.action.add(t);
        return this;
    }

    public List<DataRequirement> getDataRequirement() {
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        return this.dataRequirement;
    }

    public boolean hasDataRequirement() {
        if (this.dataRequirement == null) {
            return false;
        }
        for (DataRequirement item : this.dataRequirement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirement addDataRequirement() {
        DataRequirement t = new DataRequirement();
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return t;
    }

    public GuidanceResponse addDataRequirement(DataRequirement t) {
        if (t == null) {
            return this;
        }
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("requestId", "string", "The id of the request associated with this response. If an id was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.", 0, Integer.MAX_VALUE, this.requestId));
        childrenList.add(new Property("module", "Reference(DecisionSupportServiceModule|DecisionSupportRule)", "A reference to the knowledge module that was invoked.", 0, Integer.MAX_VALUE, this.module));
        childrenList.add(new Property("status", "code", "The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("evaluationMessage", "Reference(OperationOutcome)", "Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.", 0, Integer.MAX_VALUE, this.evaluationMessage));
        childrenList.add(new Property("outputParameters", "Reference(Parameters)", "The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.", 0, Integer.MAX_VALUE, this.outputParameters));
        childrenList.add(new Property("action", "", "The actions, if any, produced by the evaluation of the artifact.", 0, Integer.MAX_VALUE, this.action));
        childrenList.add(new Property("dataRequirement", "DataRequirement", "If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.", 0, Integer.MAX_VALUE, this.dataRequirement));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 693933066: {
                Base[] baseArray;
                if (this.requestId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.requestId;
                }
                return baseArray;
            }
            case -1068784020: {
                Base[] baseArray;
                if (this.module == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.module;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 1081619755: {
                return this.evaluationMessage == null ? new Base[]{} : this.evaluationMessage.toArray(new Base[this.evaluationMessage.size()]);
            }
            case 525609419: {
                Base[] baseArray;
                if (this.outputParameters == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.outputParameters;
                }
                return baseArray;
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
            case 629147193: {
                return this.dataRequirement == null ? new Base[]{} : this.dataRequirement.toArray(new Base[this.dataRequirement.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 693933066: {
                this.requestId = this.castToString(value);
                break;
            }
            case -1068784020: {
                this.module = this.castToReference(value);
                break;
            }
            case -892481550: {
                this.status = new GuidanceResponseStatusEnumFactory().fromType(value);
                break;
            }
            case 1081619755: {
                this.getEvaluationMessage().add(this.castToReference(value));
                break;
            }
            case 525609419: {
                this.outputParameters = this.castToReference(value);
                break;
            }
            case -1422950858: {
                this.getAction().add((GuidanceResponseActionComponent)value);
                break;
            }
            case 629147193: {
                this.getDataRequirement().add(this.castToDataRequirement(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("requestId")) {
            this.requestId = this.castToString(value);
        } else if (name.equals("module")) {
            this.module = this.castToReference(value);
        } else if (name.equals("status")) {
            this.status = new GuidanceResponseStatusEnumFactory().fromType(value);
        } else if (name.equals("evaluationMessage")) {
            this.getEvaluationMessage().add(this.castToReference(value));
        } else if (name.equals("outputParameters")) {
            this.outputParameters = this.castToReference(value);
        } else if (name.equals("action")) {
            this.getAction().add((GuidanceResponseActionComponent)value);
        } else if (name.equals("dataRequirement")) {
            this.getDataRequirement().add(this.castToDataRequirement(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 693933066: {
                throw new FHIRException("Cannot make property requestId as it is not a complex type");
            }
            case -1068784020: {
                return this.getModule();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 1081619755: {
                return this.addEvaluationMessage();
            }
            case 525609419: {
                return this.getOutputParameters();
            }
            case -1422950858: {
                return this.addAction();
            }
            case 629147193: {
                return this.addDataRequirement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("requestId")) {
            throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.requestId");
        }
        if (name.equals("module")) {
            this.module = new Reference();
            return this.module;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.status");
        }
        if (name.equals("evaluationMessage")) {
            return this.addEvaluationMessage();
        }
        if (name.equals("outputParameters")) {
            this.outputParameters = new Reference();
            return this.outputParameters;
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        if (name.equals("dataRequirement")) {
            return this.addDataRequirement();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "GuidanceResponse";
    }

    @Override
    public GuidanceResponse copy() {
        GuidanceResponse dst = new GuidanceResponse();
        this.copyValues(dst);
        dst.requestId = this.requestId == null ? null : this.requestId.copy();
        dst.module = this.module == null ? null : this.module.copy();
        Enumeration<GuidanceResponseStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.evaluationMessage != null) {
            dst.evaluationMessage = new ArrayList<Reference>();
            for (Reference reference : this.evaluationMessage) {
                dst.evaluationMessage.add(reference.copy());
            }
        }
        Reference reference = dst.outputParameters = this.outputParameters == null ? null : this.outputParameters.copy();
        if (this.action != null) {
            dst.action = new ArrayList<GuidanceResponseActionComponent>();
            for (GuidanceResponseActionComponent guidanceResponseActionComponent : this.action) {
                dst.action.add(guidanceResponseActionComponent.copy());
            }
        }
        if (this.dataRequirement != null) {
            dst.dataRequirement = new ArrayList<DataRequirement>();
            for (DataRequirement dataRequirement : this.dataRequirement) {
                dst.dataRequirement.add(dataRequirement.copy());
            }
        }
        return dst;
    }

    protected GuidanceResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof GuidanceResponse)) {
            return false;
        }
        GuidanceResponse o = (GuidanceResponse)other;
        return GuidanceResponse.compareDeep(this.requestId, o.requestId, true) && GuidanceResponse.compareDeep(this.module, o.module, true) && GuidanceResponse.compareDeep(this.status, o.status, true) && GuidanceResponse.compareDeep(this.evaluationMessage, o.evaluationMessage, true) && GuidanceResponse.compareDeep(this.outputParameters, o.outputParameters, true) && GuidanceResponse.compareDeep(this.action, o.action, true) && GuidanceResponse.compareDeep(this.dataRequirement, o.dataRequirement, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof GuidanceResponse)) {
            return false;
        }
        GuidanceResponse o = (GuidanceResponse)other;
        return GuidanceResponse.compareValues(this.requestId, o.requestId, true) && GuidanceResponse.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.requestId != null && !this.requestId.isEmpty() || this.module != null && !this.module.isEmpty() || this.status != null && !this.status.isEmpty() || this.evaluationMessage != null && !this.evaluationMessage.isEmpty() || this.outputParameters != null && !this.outputParameters.isEmpty() || this.action != null && !this.action.isEmpty() || this.dataRequirement != null && !this.dataRequirement.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.GuidanceResponse;
    }

    @Block
    public static class GuidanceResponseActionBehaviorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of behavior (grouping, precheck, selection, cardinality, etc)", formalDefinition="The type of the behavior to be described, such as grouping, visual, or selection behaviors.")
        protected Coding type;
        @Child(name="value", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific behavior (e.g. required, at-most-one, single, etc)", formalDefinition="The specific behavior. The code used here is determined by the type of behavior being described. For example, the grouping behavior uses the grouping-behavior-type valueset.")
        protected Coding value;
        private static final long serialVersionUID = -1054119695L;

        public GuidanceResponseActionBehaviorComponent() {
        }

        public GuidanceResponseActionBehaviorComponent(Coding type, Coding value) {
            this.type = type;
            this.value = value;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionBehaviorComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public GuidanceResponseActionBehaviorComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Coding getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionBehaviorComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Coding();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public GuidanceResponseActionBehaviorComponent setValue(Coding value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "The type of the behavior to be described, such as grouping, visual, or selection behaviors.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("value", "Coding", "The specific behavior. The code used here is determined by the type of behavior being described. For example, the grouping behavior uses the grouping-behavior-type valueset.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("value")) {
                this.value = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("value")) {
                this.value = new Coding();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public GuidanceResponseActionBehaviorComponent copy() {
            GuidanceResponseActionBehaviorComponent dst = new GuidanceResponseActionBehaviorComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof GuidanceResponseActionBehaviorComponent)) {
                return false;
            }
            GuidanceResponseActionBehaviorComponent o = (GuidanceResponseActionBehaviorComponent)other;
            return GuidanceResponseActionBehaviorComponent.compareDeep(this.type, o.type, true) && GuidanceResponseActionBehaviorComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof GuidanceResponseActionBehaviorComponent)) {
                return false;
            }
            GuidanceResponseActionBehaviorComponent o = (GuidanceResponseActionBehaviorComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "GuidanceResponse.action.behavior";
        }
    }

    @Block
    public static class GuidanceResponseActionRelatedActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actionIdentifier", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier of the related action", formalDefinition="The unique identifier of the related action.")
        protected Identifier actionIdentifier;
        @Child(name="relationship", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="before | after", formalDefinition="The relationship of this action to the related action.")
        protected CodeType relationship;
        @Child(name="offset", type={Duration.class, Range.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time offset for the relationship", formalDefinition="A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.")
        protected Type offset;
        @Child(name="anchor", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="start | end", formalDefinition="An optional indicator for how the relationship is anchored to the related action. For example \"before the start\" or \"before the end\" of the related action.")
        protected CodeType anchor;
        private static final long serialVersionUID = -1200619014L;

        public GuidanceResponseActionRelatedActionComponent() {
        }

        public GuidanceResponseActionRelatedActionComponent(Identifier actionIdentifier, CodeType relationship) {
            this.actionIdentifier = actionIdentifier;
            this.relationship = relationship;
        }

        public Identifier getActionIdentifier() {
            if (this.actionIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionRelatedActionComponent.actionIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.actionIdentifier = new Identifier();
                }
            }
            return this.actionIdentifier;
        }

        public boolean hasActionIdentifier() {
            return this.actionIdentifier != null && !this.actionIdentifier.isEmpty();
        }

        public GuidanceResponseActionRelatedActionComponent setActionIdentifier(Identifier value) {
            this.actionIdentifier = value;
            return this;
        }

        public CodeType getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionRelatedActionComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new CodeType();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public GuidanceResponseActionRelatedActionComponent setRelationshipElement(CodeType value) {
            this.relationship = value;
            return this;
        }

        public String getRelationship() {
            return this.relationship == null ? null : (String)this.relationship.getValue();
        }

        public GuidanceResponseActionRelatedActionComponent setRelationship(String value) {
            if (this.relationship == null) {
                this.relationship = new CodeType();
            }
            this.relationship.setValue(value);
            return this;
        }

        public Type getOffset() {
            return this.offset;
        }

        public Duration getOffsetDuration() throws FHIRException {
            if (!(this.offset instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Duration)this.offset;
        }

        public boolean hasOffsetDuration() {
            return this.offset instanceof Duration;
        }

        public Range getOffsetRange() throws FHIRException {
            if (!(this.offset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Range)this.offset;
        }

        public boolean hasOffsetRange() {
            return this.offset instanceof Range;
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public GuidanceResponseActionRelatedActionComponent setOffset(Type value) {
            this.offset = value;
            return this;
        }

        public CodeType getAnchorElement() {
            if (this.anchor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionRelatedActionComponent.anchor");
                }
                if (Configuration.doAutoCreate()) {
                    this.anchor = new CodeType();
                }
            }
            return this.anchor;
        }

        public boolean hasAnchorElement() {
            return this.anchor != null && !this.anchor.isEmpty();
        }

        public boolean hasAnchor() {
            return this.anchor != null && !this.anchor.isEmpty();
        }

        public GuidanceResponseActionRelatedActionComponent setAnchorElement(CodeType value) {
            this.anchor = value;
            return this;
        }

        public String getAnchor() {
            return this.anchor == null ? null : (String)this.anchor.getValue();
        }

        public GuidanceResponseActionRelatedActionComponent setAnchor(String value) {
            if (Utilities.noString((String)value)) {
                this.anchor = null;
            } else {
                if (this.anchor == null) {
                    this.anchor = new CodeType();
                }
                this.anchor.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("actionIdentifier", "Identifier", "The unique identifier of the related action.", 0, Integer.MAX_VALUE, this.actionIdentifier));
            childrenList.add(new Property("relationship", "code", "The relationship of this action to the related action.", 0, Integer.MAX_VALUE, this.relationship));
            childrenList.add(new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, Integer.MAX_VALUE, this.offset));
            childrenList.add(new Property("anchor", "code", "An optional indicator for how the relationship is anchored to the related action. For example \"before the start\" or \"before the end\" of the related action.", 0, Integer.MAX_VALUE, this.anchor));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -889046145: {
                    Base[] baseArray;
                    if (this.actionIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actionIdentifier;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.offset;
                    }
                    return baseArray;
                }
                case -1413299531: {
                    Base[] baseArray;
                    if (this.anchor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.anchor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -889046145: {
                    this.actionIdentifier = this.castToIdentifier(value);
                    break;
                }
                case -261851592: {
                    this.relationship = this.castToCode(value);
                    break;
                }
                case -1019779949: {
                    this.offset = (Type)value;
                    break;
                }
                case -1413299531: {
                    this.anchor = this.castToCode(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actionIdentifier")) {
                this.actionIdentifier = this.castToIdentifier(value);
            } else if (name.equals("relationship")) {
                this.relationship = this.castToCode(value);
            } else if (name.equals("offset[x]")) {
                this.offset = (Type)value;
            } else if (name.equals("anchor")) {
                this.anchor = this.castToCode(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -889046145: {
                    return this.getActionIdentifier();
                }
                case -261851592: {
                    throw new FHIRException("Cannot make property relationship as it is not a complex type");
                }
                case -1960684787: {
                    return this.getOffset();
                }
                case -1413299531: {
                    throw new FHIRException("Cannot make property anchor as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actionIdentifier")) {
                this.actionIdentifier = new Identifier();
                return this.actionIdentifier;
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.relationship");
            }
            if (name.equals("offsetDuration")) {
                this.offset = new Duration();
                return this.offset;
            }
            if (name.equals("offsetRange")) {
                this.offset = new Range();
                return this.offset;
            }
            if (name.equals("anchor")) {
                throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.anchor");
            }
            return super.addChild(name);
        }

        @Override
        public GuidanceResponseActionRelatedActionComponent copy() {
            GuidanceResponseActionRelatedActionComponent dst = new GuidanceResponseActionRelatedActionComponent();
            this.copyValues(dst);
            dst.actionIdentifier = this.actionIdentifier == null ? null : this.actionIdentifier.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.offset = this.offset == null ? null : this.offset.copy();
            dst.anchor = this.anchor == null ? null : this.anchor.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof GuidanceResponseActionRelatedActionComponent)) {
                return false;
            }
            GuidanceResponseActionRelatedActionComponent o = (GuidanceResponseActionRelatedActionComponent)other;
            return GuidanceResponseActionRelatedActionComponent.compareDeep(this.actionIdentifier, o.actionIdentifier, true) && GuidanceResponseActionRelatedActionComponent.compareDeep(this.relationship, o.relationship, true) && GuidanceResponseActionRelatedActionComponent.compareDeep(this.offset, o.offset, true) && GuidanceResponseActionRelatedActionComponent.compareDeep(this.anchor, o.anchor, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof GuidanceResponseActionRelatedActionComponent)) {
                return false;
            }
            GuidanceResponseActionRelatedActionComponent o = (GuidanceResponseActionRelatedActionComponent)other;
            return GuidanceResponseActionRelatedActionComponent.compareValues(this.relationship, o.relationship, true) && GuidanceResponseActionRelatedActionComponent.compareValues(this.anchor, o.anchor, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.actionIdentifier != null && !this.actionIdentifier.isEmpty() || this.relationship != null && !this.relationship.isEmpty() || this.offset != null && !this.offset.isEmpty() || this.anchor != null && !this.anchor.isEmpty());
        }

        @Override
        public String fhirType() {
            return "GuidanceResponse.action.relatedAction";
        }
    }

    @Block
    public static class GuidanceResponseActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actionIdentifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Unique identifier", formalDefinition="A unique identifier for the action. The identifier SHALL be unique within the container in which it appears, and MAY be universally unique.")
        protected Identifier actionIdentifier;
        @Child(name="label", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible label for the action (e.g. 1. or A.)", formalDefinition="A user-visible label for the action.")
        protected StringType label;
        @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="The title of the action displayed to a user.")
        protected StringType title;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short description of the action", formalDefinition="A short description of the action used to provide a summary to display to the user.")
        protected StringType description;
        @Child(name="textEquivalent", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Static text equivalent of the action, used if the dynamic aspects cannot be interpreted by the receiving system", formalDefinition="A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.")
        protected StringType textEquivalent;
        @Child(name="concept", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The meaning of the action or its sub-actions", formalDefinition="The concept represented by this action or its sub-actions.")
        protected List<CodeableConcept> concept;
        @Child(name="supportingEvidence", type={Attachment.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Evidence that supports taking the action", formalDefinition="The evidence grade and the sources of evidence for this action.")
        protected List<Attachment> supportingEvidence;
        @Child(name="relatedAction", type={}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Relationship to another action", formalDefinition="A relationship to another action such as \"before\" or \"30-60 minutes after start of\".")
        protected GuidanceResponseActionRelatedActionComponent relatedAction;
        @Child(name="documentation", type={Attachment.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting documentation for the intended performer of the action", formalDefinition="Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.")
        protected List<Attachment> documentation;
        @Child(name="participant", type={Patient.class, Person.class, Practitioner.class, RelatedPerson.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Participant", formalDefinition="The participant in the action.")
        protected List<Reference> participant;
        protected List<Resource> participantTarget;
        @Child(name="type", type={CodeType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="create | update | remove | fire-event", formalDefinition="The type of action to perform (create, update, remove).")
        protected CodeType type;
        @Child(name="behavior", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Defines behaviors such as selection and grouping", formalDefinition="A behavior associated with the action. Behaviors define how the action is to be presented and/or executed within the receiving environment.")
        protected List<GuidanceResponseActionBehaviorComponent> behavior;
        @Child(name="resource", type={}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The target of the action", formalDefinition="The resource that is the target of the action (e.g. CommunicationRequest).")
        protected Reference resource;
        protected Resource resourceTarget;
        @Child(name="action", type={GuidanceResponseActionComponent.class}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Sub action", formalDefinition="Sub actions.")
        protected List<GuidanceResponseActionComponent> action;
        private static final long serialVersionUID = -1602697381L;

        public Identifier getActionIdentifier() {
            if (this.actionIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionComponent.actionIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.actionIdentifier = new Identifier();
                }
            }
            return this.actionIdentifier;
        }

        public boolean hasActionIdentifier() {
            return this.actionIdentifier != null && !this.actionIdentifier.isEmpty();
        }

        public GuidanceResponseActionComponent setActionIdentifier(Identifier value) {
            this.actionIdentifier = value;
            return this;
        }

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public GuidanceResponseActionComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public GuidanceResponseActionComponent setLabel(String value) {
            if (Utilities.noString((String)value)) {
                this.label = null;
            } else {
                if (this.label == null) {
                    this.label = new StringType();
                }
                this.label.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public GuidanceResponseActionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public GuidanceResponseActionComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public GuidanceResponseActionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public GuidanceResponseActionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getTextEquivalentElement() {
            if (this.textEquivalent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionComponent.textEquivalent");
                }
                if (Configuration.doAutoCreate()) {
                    this.textEquivalent = new StringType();
                }
            }
            return this.textEquivalent;
        }

        public boolean hasTextEquivalentElement() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public boolean hasTextEquivalent() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public GuidanceResponseActionComponent setTextEquivalentElement(StringType value) {
            this.textEquivalent = value;
            return this;
        }

        public String getTextEquivalent() {
            return this.textEquivalent == null ? null : (String)this.textEquivalent.getValue();
        }

        public GuidanceResponseActionComponent setTextEquivalent(String value) {
            if (Utilities.noString((String)value)) {
                this.textEquivalent = null;
            } else {
                if (this.textEquivalent == null) {
                    this.textEquivalent = new StringType();
                }
                this.textEquivalent.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<CodeableConcept>();
            }
            return this.concept;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (CodeableConcept item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addConcept() {
            CodeableConcept t = new CodeableConcept();
            if (this.concept == null) {
                this.concept = new ArrayList<CodeableConcept>();
            }
            this.concept.add(t);
            return t;
        }

        public GuidanceResponseActionComponent addConcept(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<CodeableConcept>();
            }
            this.concept.add(t);
            return this;
        }

        public List<Attachment> getSupportingEvidence() {
            if (this.supportingEvidence == null) {
                this.supportingEvidence = new ArrayList<Attachment>();
            }
            return this.supportingEvidence;
        }

        public boolean hasSupportingEvidence() {
            if (this.supportingEvidence == null) {
                return false;
            }
            for (Attachment item : this.supportingEvidence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Attachment addSupportingEvidence() {
            Attachment t = new Attachment();
            if (this.supportingEvidence == null) {
                this.supportingEvidence = new ArrayList<Attachment>();
            }
            this.supportingEvidence.add(t);
            return t;
        }

        public GuidanceResponseActionComponent addSupportingEvidence(Attachment t) {
            if (t == null) {
                return this;
            }
            if (this.supportingEvidence == null) {
                this.supportingEvidence = new ArrayList<Attachment>();
            }
            this.supportingEvidence.add(t);
            return this;
        }

        public GuidanceResponseActionRelatedActionComponent getRelatedAction() {
            if (this.relatedAction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionComponent.relatedAction");
                }
                if (Configuration.doAutoCreate()) {
                    this.relatedAction = new GuidanceResponseActionRelatedActionComponent();
                }
            }
            return this.relatedAction;
        }

        public boolean hasRelatedAction() {
            return this.relatedAction != null && !this.relatedAction.isEmpty();
        }

        public GuidanceResponseActionComponent setRelatedAction(GuidanceResponseActionRelatedActionComponent value) {
            this.relatedAction = value;
            return this;
        }

        public List<Attachment> getDocumentation() {
            if (this.documentation == null) {
                this.documentation = new ArrayList<Attachment>();
            }
            return this.documentation;
        }

        public boolean hasDocumentation() {
            if (this.documentation == null) {
                return false;
            }
            for (Attachment item : this.documentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Attachment addDocumentation() {
            Attachment t = new Attachment();
            if (this.documentation == null) {
                this.documentation = new ArrayList<Attachment>();
            }
            this.documentation.add(t);
            return t;
        }

        public GuidanceResponseActionComponent addDocumentation(Attachment t) {
            if (t == null) {
                return this;
            }
            if (this.documentation == null) {
                this.documentation = new ArrayList<Attachment>();
            }
            this.documentation.add(t);
            return this;
        }

        public List<Reference> getParticipant() {
            if (this.participant == null) {
                this.participant = new ArrayList<Reference>();
            }
            return this.participant;
        }

        public boolean hasParticipant() {
            if (this.participant == null) {
                return false;
            }
            for (Reference item : this.participant) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addParticipant() {
            Reference t = new Reference();
            if (this.participant == null) {
                this.participant = new ArrayList<Reference>();
            }
            this.participant.add(t);
            return t;
        }

        public GuidanceResponseActionComponent addParticipant(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.participant == null) {
                this.participant = new ArrayList<Reference>();
            }
            this.participant.add(t);
            return this;
        }

        public List<Resource> getParticipantTarget() {
            if (this.participantTarget == null) {
                this.participantTarget = new ArrayList<Resource>();
            }
            return this.participantTarget;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public GuidanceResponseActionComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public GuidanceResponseActionComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new CodeType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public List<GuidanceResponseActionBehaviorComponent> getBehavior() {
            if (this.behavior == null) {
                this.behavior = new ArrayList<GuidanceResponseActionBehaviorComponent>();
            }
            return this.behavior;
        }

        public boolean hasBehavior() {
            if (this.behavior == null) {
                return false;
            }
            for (GuidanceResponseActionBehaviorComponent item : this.behavior) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GuidanceResponseActionBehaviorComponent addBehavior() {
            GuidanceResponseActionBehaviorComponent t = new GuidanceResponseActionBehaviorComponent();
            if (this.behavior == null) {
                this.behavior = new ArrayList<GuidanceResponseActionBehaviorComponent>();
            }
            this.behavior.add(t);
            return t;
        }

        public GuidanceResponseActionComponent addBehavior(GuidanceResponseActionBehaviorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.behavior == null) {
                this.behavior = new ArrayList<GuidanceResponseActionBehaviorComponent>();
            }
            this.behavior.add(t);
            return this;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuidanceResponseActionComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public GuidanceResponseActionComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        public Resource getResourceTarget() {
            return this.resourceTarget;
        }

        public GuidanceResponseActionComponent setResourceTarget(Resource value) {
            this.resourceTarget = value;
            return this;
        }

        public List<GuidanceResponseActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<GuidanceResponseActionComponent>();
            }
            return this.action;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (GuidanceResponseActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GuidanceResponseActionComponent addAction() {
            GuidanceResponseActionComponent t = new GuidanceResponseActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<GuidanceResponseActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public GuidanceResponseActionComponent addAction(GuidanceResponseActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<GuidanceResponseActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("actionIdentifier", "Identifier", "A unique identifier for the action. The identifier SHALL be unique within the container in which it appears, and MAY be universally unique.", 0, Integer.MAX_VALUE, this.actionIdentifier));
            childrenList.add(new Property("label", "string", "A user-visible label for the action.", 0, Integer.MAX_VALUE, this.label));
            childrenList.add(new Property("title", "string", "The title of the action displayed to a user.", 0, Integer.MAX_VALUE, this.title));
            childrenList.add(new Property("description", "string", "A short description of the action used to provide a summary to display to the user.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.", 0, Integer.MAX_VALUE, this.textEquivalent));
            childrenList.add(new Property("concept", "CodeableConcept", "The concept represented by this action or its sub-actions.", 0, Integer.MAX_VALUE, this.concept));
            childrenList.add(new Property("supportingEvidence", "Attachment", "The evidence grade and the sources of evidence for this action.", 0, Integer.MAX_VALUE, this.supportingEvidence));
            childrenList.add(new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction));
            childrenList.add(new Property("documentation", "Attachment", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation));
            childrenList.add(new Property("participant", "Reference(Patient|Person|Practitioner|RelatedPerson)", "The participant in the action.", 0, Integer.MAX_VALUE, this.participant));
            childrenList.add(new Property("type", "code", "The type of action to perform (create, update, remove).", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("behavior", "", "A behavior associated with the action. Behaviors define how the action is to be presented and/or executed within the receiving environment.", 0, Integer.MAX_VALUE, this.behavior));
            childrenList.add(new Property("resource", "Reference(Any)", "The resource that is the target of the action (e.g. CommunicationRequest).", 0, Integer.MAX_VALUE, this.resource));
            childrenList.add(new Property("action", "@GuidanceResponse.action", "Sub actions.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -889046145: {
                    Base[] baseArray;
                    if (this.actionIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actionIdentifier;
                    }
                    return baseArray;
                }
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.label;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -900391049: {
                    Base[] baseArray;
                    if (this.textEquivalent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.textEquivalent;
                    }
                    return baseArray;
                }
                case 951024232: {
                    return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
                }
                case -1735429846: {
                    return this.supportingEvidence == null ? new Base[]{} : this.supportingEvidence.toArray(new Base[this.supportingEvidence.size()]);
                }
                case -384107967: {
                    Base[] baseArray;
                    if (this.relatedAction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.relatedAction;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    return this.documentation == null ? new Base[]{} : this.documentation.toArray(new Base[this.documentation.size()]);
                }
                case 767422259: {
                    return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.type;
                    }
                    return baseArray;
                }
                case 1510912594: {
                    return this.behavior == null ? new Base[]{} : this.behavior.toArray(new Base[this.behavior.size()]);
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.resource;
                    }
                    return baseArray;
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -889046145: {
                    this.actionIdentifier = this.castToIdentifier(value);
                    break;
                }
                case 102727412: {
                    this.label = this.castToString(value);
                    break;
                }
                case 110371416: {
                    this.title = this.castToString(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -900391049: {
                    this.textEquivalent = this.castToString(value);
                    break;
                }
                case 951024232: {
                    this.getConcept().add(this.castToCodeableConcept(value));
                    break;
                }
                case -1735429846: {
                    this.getSupportingEvidence().add(this.castToAttachment(value));
                    break;
                }
                case -384107967: {
                    this.relatedAction = (GuidanceResponseActionRelatedActionComponent)value;
                    break;
                }
                case 1587405498: {
                    this.getDocumentation().add(this.castToAttachment(value));
                    break;
                }
                case 767422259: {
                    this.getParticipant().add(this.castToReference(value));
                    break;
                }
                case 3575610: {
                    this.type = this.castToCode(value);
                    break;
                }
                case 1510912594: {
                    this.getBehavior().add((GuidanceResponseActionBehaviorComponent)value);
                    break;
                }
                case -341064690: {
                    this.resource = this.castToReference(value);
                    break;
                }
                case -1422950858: {
                    this.getAction().add((GuidanceResponseActionComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actionIdentifier")) {
                this.actionIdentifier = this.castToIdentifier(value);
            } else if (name.equals("label")) {
                this.label = this.castToString(value);
            } else if (name.equals("title")) {
                this.title = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("textEquivalent")) {
                this.textEquivalent = this.castToString(value);
            } else if (name.equals("concept")) {
                this.getConcept().add(this.castToCodeableConcept(value));
            } else if (name.equals("supportingEvidence")) {
                this.getSupportingEvidence().add(this.castToAttachment(value));
            } else if (name.equals("relatedAction")) {
                this.relatedAction = (GuidanceResponseActionRelatedActionComponent)value;
            } else if (name.equals("documentation")) {
                this.getDocumentation().add(this.castToAttachment(value));
            } else if (name.equals("participant")) {
                this.getParticipant().add(this.castToReference(value));
            } else if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("behavior")) {
                this.getBehavior().add((GuidanceResponseActionBehaviorComponent)value);
            } else if (name.equals("resource")) {
                this.resource = this.castToReference(value);
            } else if (name.equals("action")) {
                this.getAction().add((GuidanceResponseActionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -889046145: {
                    return this.getActionIdentifier();
                }
                case 102727412: {
                    throw new FHIRException("Cannot make property label as it is not a complex type");
                }
                case 110371416: {
                    throw new FHIRException("Cannot make property title as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -900391049: {
                    throw new FHIRException("Cannot make property textEquivalent as it is not a complex type");
                }
                case 951024232: {
                    return this.addConcept();
                }
                case -1735429846: {
                    return this.addSupportingEvidence();
                }
                case -384107967: {
                    return this.getRelatedAction();
                }
                case 1587405498: {
                    return this.addDocumentation();
                }
                case 767422259: {
                    return this.addParticipant();
                }
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 1510912594: {
                    return this.addBehavior();
                }
                case -341064690: {
                    return this.getResource();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actionIdentifier")) {
                this.actionIdentifier = new Identifier();
                return this.actionIdentifier;
            }
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.label");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.description");
            }
            if (name.equals("textEquivalent")) {
                throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.textEquivalent");
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            if (name.equals("supportingEvidence")) {
                return this.addSupportingEvidence();
            }
            if (name.equals("relatedAction")) {
                this.relatedAction = new GuidanceResponseActionRelatedActionComponent();
                return this.relatedAction;
            }
            if (name.equals("documentation")) {
                return this.addDocumentation();
            }
            if (name.equals("participant")) {
                return this.addParticipant();
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.type");
            }
            if (name.equals("behavior")) {
                return this.addBehavior();
            }
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public GuidanceResponseActionComponent copy() {
            GuidanceResponseActionComponent dst = new GuidanceResponseActionComponent();
            this.copyValues(dst);
            dst.actionIdentifier = this.actionIdentifier == null ? null : this.actionIdentifier.copy();
            dst.label = this.label == null ? null : this.label.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            StringType stringType = dst.textEquivalent = this.textEquivalent == null ? null : this.textEquivalent.copy();
            if (this.concept != null) {
                dst.concept = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.concept) {
                    dst.concept.add(codeableConcept.copy());
                }
            }
            if (this.supportingEvidence != null) {
                dst.supportingEvidence = new ArrayList<Attachment>();
                for (Attachment attachment : this.supportingEvidence) {
                    dst.supportingEvidence.add(attachment.copy());
                }
            }
            GuidanceResponseActionRelatedActionComponent guidanceResponseActionRelatedActionComponent = dst.relatedAction = this.relatedAction == null ? null : this.relatedAction.copy();
            if (this.documentation != null) {
                dst.documentation = new ArrayList<Attachment>();
                for (Attachment attachment : this.documentation) {
                    dst.documentation.add(attachment.copy());
                }
            }
            if (this.participant != null) {
                dst.participant = new ArrayList<Reference>();
                for (Reference reference : this.participant) {
                    dst.participant.add(reference.copy());
                }
            }
            CodeType codeType = dst.type = this.type == null ? null : this.type.copy();
            if (this.behavior != null) {
                dst.behavior = new ArrayList<GuidanceResponseActionBehaviorComponent>();
                for (GuidanceResponseActionBehaviorComponent guidanceResponseActionBehaviorComponent : this.behavior) {
                    dst.behavior.add(guidanceResponseActionBehaviorComponent.copy());
                }
            }
            Reference reference = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.action != null) {
                dst.action = new ArrayList<GuidanceResponseActionComponent>();
                for (GuidanceResponseActionComponent guidanceResponseActionComponent : this.action) {
                    dst.action.add(guidanceResponseActionComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof GuidanceResponseActionComponent)) {
                return false;
            }
            GuidanceResponseActionComponent o = (GuidanceResponseActionComponent)other;
            return GuidanceResponseActionComponent.compareDeep(this.actionIdentifier, o.actionIdentifier, true) && GuidanceResponseActionComponent.compareDeep(this.label, o.label, true) && GuidanceResponseActionComponent.compareDeep(this.title, o.title, true) && GuidanceResponseActionComponent.compareDeep(this.description, o.description, true) && GuidanceResponseActionComponent.compareDeep(this.textEquivalent, o.textEquivalent, true) && GuidanceResponseActionComponent.compareDeep(this.concept, o.concept, true) && GuidanceResponseActionComponent.compareDeep(this.supportingEvidence, o.supportingEvidence, true) && GuidanceResponseActionComponent.compareDeep(this.relatedAction, o.relatedAction, true) && GuidanceResponseActionComponent.compareDeep(this.documentation, o.documentation, true) && GuidanceResponseActionComponent.compareDeep(this.participant, o.participant, true) && GuidanceResponseActionComponent.compareDeep(this.type, o.type, true) && GuidanceResponseActionComponent.compareDeep(this.behavior, o.behavior, true) && GuidanceResponseActionComponent.compareDeep(this.resource, o.resource, true) && GuidanceResponseActionComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof GuidanceResponseActionComponent)) {
                return false;
            }
            GuidanceResponseActionComponent o = (GuidanceResponseActionComponent)other;
            return GuidanceResponseActionComponent.compareValues(this.label, o.label, true) && GuidanceResponseActionComponent.compareValues(this.title, o.title, true) && GuidanceResponseActionComponent.compareValues(this.description, o.description, true) && GuidanceResponseActionComponent.compareValues(this.textEquivalent, o.textEquivalent, true) && GuidanceResponseActionComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.actionIdentifier != null && !this.actionIdentifier.isEmpty() || this.label != null && !this.label.isEmpty() || this.title != null && !this.title.isEmpty() || this.description != null && !this.description.isEmpty() || this.textEquivalent != null && !this.textEquivalent.isEmpty() || this.concept != null && !this.concept.isEmpty() || this.supportingEvidence != null && !this.supportingEvidence.isEmpty() || this.relatedAction != null && !this.relatedAction.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.participant != null && !this.participant.isEmpty() || this.type != null && !this.type.isEmpty() || this.behavior != null && !this.behavior.isEmpty() || this.resource != null && !this.resource.isEmpty() || this.action != null && !this.action.isEmpty());
        }

        @Override
        public String fhirType() {
            return "GuidanceResponse.action";
        }
    }

    public static class GuidanceResponseStatusEnumFactory
    implements EnumFactory<GuidanceResponseStatus> {
        @Override
        public GuidanceResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("success".equals(codeString)) {
                return GuidanceResponseStatus.SUCCESS;
            }
            if ("data-requested".equals(codeString)) {
                return GuidanceResponseStatus.DATAREQUESTED;
            }
            if ("data-required".equals(codeString)) {
                return GuidanceResponseStatus.DATAREQUIRED;
            }
            if ("in-progress".equals(codeString)) {
                return GuidanceResponseStatus.INPROGRESS;
            }
            if ("failure".equals(codeString)) {
                return GuidanceResponseStatus.FAILURE;
            }
            throw new IllegalArgumentException("Unknown GuidanceResponseStatus code '" + codeString + "'");
        }

        public Enumeration<GuidanceResponseStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("success".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.SUCCESS);
            }
            if ("data-requested".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.DATAREQUESTED);
            }
            if ("data-required".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.DATAREQUIRED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.INPROGRESS);
            }
            if ("failure".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.FAILURE);
            }
            throw new FHIRException("Unknown GuidanceResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(GuidanceResponseStatus code) {
            if (code == GuidanceResponseStatus.NULL) {
                return null;
            }
            if (code == GuidanceResponseStatus.SUCCESS) {
                return "success";
            }
            if (code == GuidanceResponseStatus.DATAREQUESTED) {
                return "data-requested";
            }
            if (code == GuidanceResponseStatus.DATAREQUIRED) {
                return "data-required";
            }
            if (code == GuidanceResponseStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == GuidanceResponseStatus.FAILURE) {
                return "failure";
            }
            return "?";
        }

        @Override
        public String toSystem(GuidanceResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum GuidanceResponseStatus {
        SUCCESS,
        DATAREQUESTED,
        DATAREQUIRED,
        INPROGRESS,
        FAILURE,
        NULL;


        public static GuidanceResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("success".equals(codeString)) {
                return SUCCESS;
            }
            if ("data-requested".equals(codeString)) {
                return DATAREQUESTED;
            }
            if ("data-required".equals(codeString)) {
                return DATAREQUIRED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("failure".equals(codeString)) {
                return FAILURE;
            }
            throw new FHIRException("Unknown GuidanceResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SUCCESS: {
                    return "success";
                }
                case DATAREQUESTED: {
                    return "data-requested";
                }
                case DATAREQUIRED: {
                    return "data-required";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case FAILURE: {
                    return "failure";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SUCCESS: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case DATAREQUESTED: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case DATAREQUIRED: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case FAILURE: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SUCCESS: {
                    return "The request was processed successfully";
                }
                case DATAREQUESTED: {
                    return "The request was processed successfully, but more data may result in a more complete evaluation";
                }
                case DATAREQUIRED: {
                    return "The request was processed, but more data is required to complete the evaluation";
                }
                case INPROGRESS: {
                    return "The request is currently being processed";
                }
                case FAILURE: {
                    return "The request was not processed successfully";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SUCCESS: {
                    return "Success";
                }
                case DATAREQUESTED: {
                    return "Data Requested";
                }
                case DATAREQUIRED: {
                    return "Data Required";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case FAILURE: {
                    return "Failure";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

