/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.terminologies;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Factory;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.terminologies.CodeSystemUtilities;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetCheckerSimple;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.utilities.Utilities;

public class ValueSetExpanderSimple
implements ValueSetExpander {
    private IWorkerContext context;
    private List<ValueSet.ValueSetExpansionContainsComponent> codes = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
    private Map<String, ValueSet.ValueSetExpansionContainsComponent> map = new HashMap<String, ValueSet.ValueSetExpansionContainsComponent>();
    private ValueSet focus;
    private ValueSetExpanderFactory factory;

    public ValueSetExpanderSimple(IWorkerContext context, ValueSetExpanderFactory factory) {
        this.context = context;
        this.factory = factory;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet source) {
        try {
            this.focus = source.copy();
            this.focus.setExpansion(new ValueSet.ValueSetExpansionComponent());
            this.focus.getExpansion().setTimestampElement(DateTimeType.now());
            this.focus.getExpansion().setIdentifier(Factory.createUUID());
            if (source.hasCompose()) {
                this.handleCompose(source.getCompose(), this.focus.getExpansion().getParameter());
            }
            for (ValueSet.ValueSetExpansionContainsComponent c : this.codes) {
                if (!this.map.containsKey(this.key(c))) continue;
                this.focus.getExpansion().getContains().add(c);
            }
            return new ValueSetExpander.ValueSetExpansionOutcome(this.focus, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(new ValueSetCheckerSimple(source, this.factory, this.context), e.getMessage());
        }
    }

    private void handleCompose(ValueSet.ValueSetComposeComponent compose, List<ValueSet.ValueSetExpansionParameterComponent> params) throws TerminologyServiceException, ValueSetExpander.ETooCostly, FileNotFoundException, IOException {
        for (UriType imp : compose.getImport()) {
            this.importValueSet((String)imp.getValue(), params);
        }
        for (ValueSet.ConceptSetComponent inc : compose.getInclude()) {
            this.includeCodes(inc, params);
        }
        for (ValueSet.ConceptSetComponent inc : compose.getExclude()) {
            this.excludeCodes(inc, params);
        }
    }

    private void importValueSet(String value, List<ValueSet.ValueSetExpansionParameterComponent> params) throws ValueSetExpander.ETooCostly, TerminologyServiceException, FileNotFoundException, IOException {
        if (value == null) {
            throw new TerminologyServiceException("unable to find value set with no identity");
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, value);
        if (vs == null) {
            throw new TerminologyServiceException("Unable to find imported value set " + value);
        }
        ValueSetExpander.ValueSetExpansionOutcome vso = this.factory.getExpander().expand(vs);
        if (vso.getService() != null) {
            throw new TerminologyServiceException("Unable to expand imported value set " + value);
        }
        if (vs.hasVersion() && !this.existsInParams(params, "version", new UriType(vs.getUrl() + "?version=" + vs.getVersion()))) {
            params.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(vs.getUrl() + "?version=" + vs.getVersion())));
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(params, p.getName(), p.getValue())) continue;
            params.add(p);
        }
        for (ValueSet.ValueSetExpansionContainsComponent c : vso.getValueset().getExpansion().getContains()) {
            this.addCode(c.getSystem(), c.getCode(), c.getDisplay());
        }
    }

    private boolean existsInParams(List<ValueSet.ValueSetExpansionParameterComponent> params, String name, Type value) {
        for (ValueSet.ValueSetExpansionParameterComponent p : params) {
            if (!p.getName().equals(name) || !PrimitiveType.compareDeep(p.getValue(), value, false)) continue;
            return true;
        }
        return false;
    }

    private void includeCodes(ValueSet.ConceptSetComponent inc, List<ValueSet.ValueSetExpansionParameterComponent> params) throws TerminologyServiceException, ValueSetExpander.ETooCostly {
        CodeSystem cs;
        if (this.context.supportsSystem(inc.getSystem())) {
            try {
                int i = this.codes.size();
                this.addCodes(this.context.expandVS(inc), params);
                if (this.codes.size() > i) {
                    return;
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if ((cs = this.context.fetchCodeSystem(inc.getSystem())) == null) {
            throw new TerminologyServiceException("unable to find code system " + inc.getSystem().toString());
        }
        if (cs.hasVersion() && !this.existsInParams(params, "version", new UriType(cs.getUrl() + "?version=" + cs.getVersion()))) {
            params.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(cs.getUrl() + "?version=" + cs.getVersion())));
        }
        if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                this.addCodeAndDescendents(cs, inc.getSystem(), def);
            }
        }
        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
            this.addCode(inc.getSystem(), c.getCode(), Utilities.noString((String)c.getDisplay()) ? this.getCodeDisplay(cs, c.getCode()) : c.getDisplay());
        }
        if (inc.getFilter().size() > 1) {
            throw new TerminologyServiceException("Multiple filters not handled yet");
        }
        if (inc.getFilter().size() == 1) {
            ValueSet.ConceptSetFilterComponent fc = inc.getFilter().get(0);
            if ("concept".equals(fc.getProperty()) && fc.getOp() == ValueSet.FilterOperator.ISA) {
                CodeSystem.ConceptDefinitionComponent def;
                def = this.getConceptForCode(cs.getConcept(), fc.getValue());
                if (def == null) {
                    throw new TerminologyServiceException("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
                }
                this.addCodeAndDescendents(cs, inc.getSystem(), def);
            } else {
                throw new NotImplementedException("not done yet");
            }
        }
    }

    private void addCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params) throws ValueSetExpander.ETooCostly {
        if (expand.getContains().size() > 500) {
            throw new ValueSetExpander.ETooCostly("Too many codes to display (>" + Integer.toString(expand.getContains().size()) + ")");
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : expand.getParameter()) {
            if (this.existsInParams(params, p.getName(), p.getValue())) continue;
            params.add(p);
        }
        for (ValueSet.ValueSetExpansionContainsComponent c : expand.getContains()) {
            this.addCode(c.getSystem(), c.getCode(), c.getDisplay());
        }
    }

    private void addCodeAndDescendents(CodeSystem cs, String system, CodeSystem.ConceptDefinitionComponent def) {
        if (!CodeSystemUtilities.isDeprecated(cs, def)) {
            if (!CodeSystemUtilities.isAbstract(cs, def)) {
                this.addCode(system, def.getCode(), def.getDisplay());
            }
            for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
                this.addCodeAndDescendents(cs, system, c);
            }
        }
    }

    private void excludeCodes(ValueSet.ConceptSetComponent inc, List<ValueSet.ValueSetExpansionParameterComponent> params) throws TerminologyServiceException {
        CodeSystem cs = this.context.fetchCodeSystem(inc.getSystem().toString());
        if (cs == null) {
            throw new TerminologyServiceException("unable to find value set " + inc.getSystem().toString());
        }
        if (inc.getConcept().size() != 0 || inc.getFilter().size() == 0) {
            // empty if block
        }
        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
            this.map.remove(this.key(inc.getSystem(), c.getCode()));
        }
        if (inc.getFilter().size() > 0) {
            throw new NotImplementedException("not done yet");
        }
    }

    private String getCodeDisplay(CodeSystem cs, String code) throws TerminologyServiceException {
        CodeSystem.ConceptDefinitionComponent def = this.getConceptForCode(cs.getConcept(), code);
        if (def == null) {
            throw new TerminologyServiceException("Unable to find code '" + code + "' in code system " + cs.getUrl());
        }
        return def.getDisplay();
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> clist, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : clist) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private String key(ValueSet.ValueSetExpansionContainsComponent c) {
        return this.key(c.getSystem(), c.getCode());
    }

    private String key(String uri, String code) {
        return "{" + uri + "}" + code;
    }

    private void addCode(String system, String code, String display) {
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(system);
        n.setCode(code);
        n.setDisplay(display);
        String s = this.key(n);
        if (!this.map.containsKey(s)) {
            this.codes.add(n);
            this.map.put(s, n);
        }
    }
}

