/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.Appointment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.CommunicationRequest;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DeviceUseRequest;
import org.hl7.fhir.dstu2016may.model.DiagnosticOrder;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.EpisodeOfCare;
import org.hl7.fhir.dstu2016may.model.Goal;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Medication;
import org.hl7.fhir.dstu2016may.model.MedicationOrder;
import org.hl7.fhir.dstu2016may.model.NutritionOrder;
import org.hl7.fhir.dstu2016may.model.Order;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.ProcedureRequest;
import org.hl7.fhir.dstu2016may.model.ProcessRequest;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ReferralRequest;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Substance;
import org.hl7.fhir.dstu2016may.model.SupplyRequest;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CarePlan", profile="http://hl7.org/fhir/Profile/CarePlan")
public class CarePlan
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this plan", formalDefinition="This records identifiers associated with this care plan that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="subject", type={Patient.class, Group.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who care plan is for", formalDefinition="Identifies the patient or group whose intended care is described by the plan.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | draft | active | completed | cancelled", formalDefinition="Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.")
    protected Enumeration<CarePlanStatus> status;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Created in context of", formalDefinition="Identifies the context in which this particular CarePlan is defined.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period plan covers", formalDefinition="Indicates when the plan did (or is intended to) come into effect and end.")
    protected Period period;
    @Child(name="author", type={Patient.class, Practitioner.class, RelatedPerson.class, Organization.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is responsible for contents of the plan", formalDefinition="Identifies the individual(s) or ogranization who is responsible for the content of the care plan.")
    protected List<Reference> author;
    protected List<Resource> authorTarget;
    @Child(name="modified", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When last updated", formalDefinition="Identifies the most recent date on which the plan has been revised.")
    protected DateTimeType modified;
    @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of plan", formalDefinition="Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", \"wellness plan\", etc.")
    protected List<CodeableConcept> category;
    @Child(name="description", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Summary of nature of plan", formalDefinition="A description of the scope and nature of the plan.")
    protected StringType description;
    @Child(name="addresses", type={Condition.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Health issues this plan addresses", formalDefinition="Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.")
    protected List<Reference> addresses;
    protected List<Condition> addressesTarget;
    @Child(name="support", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information considered as part of plan", formalDefinition="Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include co-morbidities, recent procedures, limitations, recent assessments, etc.")
    protected List<Reference> support;
    protected List<Resource> supportTarget;
    @Child(name="relatedPlan", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Plans related to this one", formalDefinition="Identifies CarePlans with some sort of formal relationship to the current plan.")
    protected List<CarePlanRelatedPlanComponent> relatedPlan;
    @Child(name="participant", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who's involved in plan?", formalDefinition="Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.")
    protected List<CarePlanParticipantComponent> participant;
    @Child(name="goal", type={Goal.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Desired outcome of plan", formalDefinition="Describes the intended objective(s) of carrying out the care plan.")
    protected List<Reference> goal;
    protected List<Goal> goalTarget;
    @Child(name="activity", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Action to occur as part of plan", formalDefinition="Identifies a planned action to occur as part of the plan.  For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.")
    protected List<CarePlanActivityComponent> activity;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the plan", formalDefinition="General notes about the care plan not covered elsewhere.")
    protected Annotation note;
    private static final long serialVersionUID = -307500543L;
    @SearchParamDefinition(name="activitycode", path="CarePlan.activity.detail.code", description="Detail type of activity", type="token")
    public static final String SP_ACTIVITYCODE = "activitycode";
    public static final TokenClientParam ACTIVITYCODE = new TokenClientParam("activitycode");
    @SearchParamDefinition(name="condition", path="CarePlan.addresses", description="Health issues this plan addresses", type="reference")
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    public static final Include INCLUDE_CONDITION = new Include("CarePlan:condition").toLocked();
    @SearchParamDefinition(name="subject", path="CarePlan.subject", description="Who care plan is for", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("CarePlan:subject").toLocked();
    @SearchParamDefinition(name="activitydate", path="CarePlan.activity.detail.scheduled", description="Specified date occurs within period specified by CarePlan.activity.timingSchedule", type="date")
    public static final String SP_ACTIVITYDATE = "activitydate";
    public static final DateClientParam ACTIVITYDATE = new DateClientParam("activitydate");
    @SearchParamDefinition(name="date", path="CarePlan.period", description="Time period plan covers", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="goal", path="CarePlan.goal", description="Desired outcome of plan", type="reference")
    public static final String SP_GOAL = "goal";
    public static final ReferenceClientParam GOAL = new ReferenceClientParam("goal");
    public static final Include INCLUDE_GOAL = new Include("CarePlan:goal").toLocked();
    @SearchParamDefinition(name="related", path="", description="A combination of the type of relationship and the related plan", type="composite", compositeOf={"relatedcode", "relatedplan"})
    public static final String SP_RELATED = "related";
    public static final CompositeClientParam<TokenClientParam, ReferenceClientParam> RELATED = new CompositeClientParam("related");
    @SearchParamDefinition(name="relatedcode", path="CarePlan.relatedPlan.code", description="includes | replaces | fulfills", type="token")
    public static final String SP_RELATEDCODE = "relatedcode";
    public static final TokenClientParam RELATEDCODE = new TokenClientParam("relatedcode");
    @SearchParamDefinition(name="patient", path="CarePlan.subject", description="Who care plan is for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("CarePlan:patient").toLocked();
    @SearchParamDefinition(name="participant", path="CarePlan.participant.member", description="Who is involved", type="reference")
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("CarePlan:participant").toLocked();
    @SearchParamDefinition(name="performer", path="CarePlan.activity.detail.performer", description="Matches if the practitioner is listed as a performer in any of the \"simple\" activities.  (For performers of the detailed activities, chain through the activitydetail search parameter.)", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("CarePlan:performer").toLocked();
    @SearchParamDefinition(name="activityreference", path="CarePlan.activity.reference", description="Activity details defined in specific resource", type="reference")
    public static final String SP_ACTIVITYREFERENCE = "activityreference";
    public static final ReferenceClientParam ACTIVITYREFERENCE = new ReferenceClientParam("activityreference");
    public static final Include INCLUDE_ACTIVITYREFERENCE = new Include("CarePlan:activityreference").toLocked();
    @SearchParamDefinition(name="relatedplan", path="CarePlan.relatedPlan.plan", description="Plan relationship exists with", type="reference")
    public static final String SP_RELATEDPLAN = "relatedplan";
    public static final ReferenceClientParam RELATEDPLAN = new ReferenceClientParam("relatedplan");
    public static final Include INCLUDE_RELATEDPLAN = new Include("CarePlan:relatedplan").toLocked();

    public CarePlan() {
    }

    public CarePlan(Enumeration<CarePlanStatus> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CarePlan addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public CarePlan setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public CarePlan setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Enumeration<CarePlanStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CarePlanStatus>(new CarePlanStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CarePlan setStatusElement(Enumeration<CarePlanStatus> value) {
        this.status = value;
        return this;
    }

    public CarePlanStatus getStatus() {
        return this.status == null ? null : (CarePlanStatus)((Object)this.status.getValue());
    }

    public CarePlan setStatus(CarePlanStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<CarePlanStatus>(new CarePlanStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public CarePlan setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public CarePlan setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public CarePlan setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (Reference item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthor() {
        Reference t = new Reference();
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return t;
    }

    public CarePlan addAuthor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return this;
    }

    public List<Resource> getAuthorTarget() {
        if (this.authorTarget == null) {
            this.authorTarget = new ArrayList<Resource>();
        }
        return this.authorTarget;
    }

    public DateTimeType getModifiedElement() {
        if (this.modified == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.modified");
            }
            if (Configuration.doAutoCreate()) {
                this.modified = new DateTimeType();
            }
        }
        return this.modified;
    }

    public boolean hasModifiedElement() {
        return this.modified != null && !this.modified.isEmpty();
    }

    public boolean hasModified() {
        return this.modified != null && !this.modified.isEmpty();
    }

    public CarePlan setModifiedElement(DateTimeType value) {
        this.modified = value;
        return this;
    }

    public Date getModified() {
        return this.modified == null ? null : (Date)this.modified.getValue();
    }

    public CarePlan setModified(Date value) {
        if (value == null) {
            this.modified = null;
        } else {
            if (this.modified == null) {
                this.modified = new DateTimeType();
            }
            this.modified.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public CarePlan addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public CarePlan setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public CarePlan setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Reference> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        return this.addresses;
    }

    public boolean hasAddresses() {
        if (this.addresses == null) {
            return false;
        }
        for (Reference item : this.addresses) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAddresses() {
        Reference t = new Reference();
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        this.addresses.add(t);
        return t;
    }

    public CarePlan addAddresses(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        this.addresses.add(t);
        return this;
    }

    public List<Condition> getAddressesTarget() {
        if (this.addressesTarget == null) {
            this.addressesTarget = new ArrayList<Condition>();
        }
        return this.addressesTarget;
    }

    public Condition addAddressesTarget() {
        Condition r = new Condition();
        if (this.addressesTarget == null) {
            this.addressesTarget = new ArrayList<Condition>();
        }
        this.addressesTarget.add(r);
        return r;
    }

    public List<Reference> getSupport() {
        if (this.support == null) {
            this.support = new ArrayList<Reference>();
        }
        return this.support;
    }

    public boolean hasSupport() {
        if (this.support == null) {
            return false;
        }
        for (Reference item : this.support) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupport() {
        Reference t = new Reference();
        if (this.support == null) {
            this.support = new ArrayList<Reference>();
        }
        this.support.add(t);
        return t;
    }

    public CarePlan addSupport(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.support == null) {
            this.support = new ArrayList<Reference>();
        }
        this.support.add(t);
        return this;
    }

    public List<Resource> getSupportTarget() {
        if (this.supportTarget == null) {
            this.supportTarget = new ArrayList<Resource>();
        }
        return this.supportTarget;
    }

    public List<CarePlanRelatedPlanComponent> getRelatedPlan() {
        if (this.relatedPlan == null) {
            this.relatedPlan = new ArrayList<CarePlanRelatedPlanComponent>();
        }
        return this.relatedPlan;
    }

    public boolean hasRelatedPlan() {
        if (this.relatedPlan == null) {
            return false;
        }
        for (CarePlanRelatedPlanComponent item : this.relatedPlan) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CarePlanRelatedPlanComponent addRelatedPlan() {
        CarePlanRelatedPlanComponent t = new CarePlanRelatedPlanComponent();
        if (this.relatedPlan == null) {
            this.relatedPlan = new ArrayList<CarePlanRelatedPlanComponent>();
        }
        this.relatedPlan.add(t);
        return t;
    }

    public CarePlan addRelatedPlan(CarePlanRelatedPlanComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatedPlan == null) {
            this.relatedPlan = new ArrayList<CarePlanRelatedPlanComponent>();
        }
        this.relatedPlan.add(t);
        return this;
    }

    public List<CarePlanParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<CarePlanParticipantComponent>();
        }
        return this.participant;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (CarePlanParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CarePlanParticipantComponent addParticipant() {
        CarePlanParticipantComponent t = new CarePlanParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<CarePlanParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public CarePlan addParticipant(CarePlanParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<CarePlanParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public List<Reference> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        return this.goal;
    }

    public boolean hasGoal() {
        if (this.goal == null) {
            return false;
        }
        for (Reference item : this.goal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addGoal() {
        Reference t = new Reference();
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return t;
    }

    public CarePlan addGoal(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return this;
    }

    public List<Goal> getGoalTarget() {
        if (this.goalTarget == null) {
            this.goalTarget = new ArrayList<Goal>();
        }
        return this.goalTarget;
    }

    public Goal addGoalTarget() {
        Goal r = new Goal();
        if (this.goalTarget == null) {
            this.goalTarget = new ArrayList<Goal>();
        }
        this.goalTarget.add(r);
        return r;
    }

    public List<CarePlanActivityComponent> getActivity() {
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivityComponent>();
        }
        return this.activity;
    }

    public boolean hasActivity() {
        if (this.activity == null) {
            return false;
        }
        for (CarePlanActivityComponent item : this.activity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CarePlanActivityComponent addActivity() {
        CarePlanActivityComponent t = new CarePlanActivityComponent();
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivityComponent>();
        }
        this.activity.add(t);
        return t;
    }

    public CarePlan addActivity(CarePlanActivityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivityComponent>();
        }
        this.activity.add(t);
        return this;
    }

    public Annotation getNote() {
        if (this.note == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.note");
            }
            if (Configuration.doAutoCreate()) {
                this.note = new Annotation();
            }
        }
        return this.note;
    }

    public boolean hasNote() {
        return this.note != null && !this.note.isEmpty();
    }

    public CarePlan setNote(Annotation value) {
        this.note = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("identifier", "Identifier", "This records identifiers associated with this care plan that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "Identifies the patient or group whose intended care is described by the plan.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("status", "code", "Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("context", "Reference(Encounter|EpisodeOfCare)", "Identifies the context in which this particular CarePlan is defined.", 0, Integer.MAX_VALUE, this.context));
        childrenList.add(new Property("period", "Period", "Indicates when the plan did (or is intended to) come into effect and end.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property("author", "Reference(Patient|Practitioner|RelatedPerson|Organization)", "Identifies the individual(s) or ogranization who is responsible for the content of the care plan.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property("modified", "dateTime", "Identifies the most recent date on which the plan has been revised.", 0, Integer.MAX_VALUE, this.modified));
        childrenList.add(new Property("category", "CodeableConcept", "Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", \"wellness plan\", etc.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property("description", "string", "A description of the scope and nature of the plan.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("addresses", "Reference(Condition)", "Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.", 0, Integer.MAX_VALUE, this.addresses));
        childrenList.add(new Property("support", "Reference(Any)", "Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include co-morbidities, recent procedures, limitations, recent assessments, etc.", 0, Integer.MAX_VALUE, this.support));
        childrenList.add(new Property("relatedPlan", "", "Identifies CarePlans with some sort of formal relationship to the current plan.", 0, Integer.MAX_VALUE, this.relatedPlan));
        childrenList.add(new Property(SP_PARTICIPANT, "", "Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.", 0, Integer.MAX_VALUE, this.participant));
        childrenList.add(new Property(SP_GOAL, "Reference(Goal)", "Describes the intended objective(s) of carrying out the care plan.", 0, Integer.MAX_VALUE, this.goal));
        childrenList.add(new Property("activity", "", "Identifies a planned action to occur as part of the plan.  For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.", 0, Integer.MAX_VALUE, this.activity));
        childrenList.add(new Property("note", "Annotation", "General notes about the care plan not covered elsewhere.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.subject;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.context;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -615513399: {
                Base[] baseArray;
                if (this.modified == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.modified;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.description;
                }
                return baseArray;
            }
            case 874544034: {
                return this.addresses == null ? new Base[]{} : this.addresses.toArray(new Base[this.addresses.size()]);
            }
            case -1854767153: {
                return this.support == null ? new Base[]{} : this.support.toArray(new Base[this.support.size()]);
            }
            case 1112903156: {
                return this.relatedPlan == null ? new Base[]{} : this.relatedPlan.toArray(new Base[this.relatedPlan.size()]);
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case 3178259: {
                return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
            }
            case -1655966961: {
                return this.activity == null ? new Base[]{} : this.activity.toArray(new Base[this.activity.size()]);
            }
            case 3387378: {
                Base[] baseArray;
                if (this.note == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.note;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case -892481550: {
                this.status = new CarePlanStatusEnumFactory().fromType(value);
                break;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case -1406328437: {
                this.getAuthor().add(this.castToReference(value));
                break;
            }
            case -615513399: {
                this.modified = this.castToDateTime(value);
                break;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case 874544034: {
                this.getAddresses().add(this.castToReference(value));
                break;
            }
            case -1854767153: {
                this.getSupport().add(this.castToReference(value));
                break;
            }
            case 1112903156: {
                this.getRelatedPlan().add((CarePlanRelatedPlanComponent)value);
                break;
            }
            case 767422259: {
                this.getParticipant().add((CarePlanParticipantComponent)value);
                break;
            }
            case 3178259: {
                this.getGoal().add(this.castToReference(value));
                break;
            }
            case -1655966961: {
                this.getActivity().add((CarePlanActivityComponent)value);
                break;
            }
            case 3387378: {
                this.note = this.castToAnnotation(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("status")) {
            this.status = new CarePlanStatusEnumFactory().fromType(value);
        } else if (name.equals("context")) {
            this.context = this.castToReference(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("author")) {
            this.getAuthor().add(this.castToReference(value));
        } else if (name.equals("modified")) {
            this.modified = this.castToDateTime(value);
        } else if (name.equals("category")) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("addresses")) {
            this.getAddresses().add(this.castToReference(value));
        } else if (name.equals("support")) {
            this.getSupport().add(this.castToReference(value));
        } else if (name.equals("relatedPlan")) {
            this.getRelatedPlan().add((CarePlanRelatedPlanComponent)value);
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((CarePlanParticipantComponent)value);
        } else if (name.equals(SP_GOAL)) {
            this.getGoal().add(this.castToReference(value));
        } else if (name.equals("activity")) {
            this.getActivity().add((CarePlanActivityComponent)value);
        } else if (name.equals("note")) {
            this.note = this.castToAnnotation(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 951530927: {
                return this.getContext();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -615513399: {
                throw new FHIRException("Cannot make property modified as it is not a complex type");
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case 874544034: {
                return this.addAddresses();
            }
            case -1854767153: {
                return this.addSupport();
            }
            case 1112903156: {
                return this.addRelatedPlan();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case 3178259: {
                return this.addGoal();
            }
            case -1655966961: {
                return this.addActivity();
            }
            case 3387378: {
                return this.getNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property CarePlan.status");
        }
        if (name.equals("context")) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("modified")) {
            throw new FHIRException("Cannot call addChild on a singleton property CarePlan.modified");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property CarePlan.description");
        }
        if (name.equals("addresses")) {
            return this.addAddresses();
        }
        if (name.equals("support")) {
            return this.addSupport();
        }
        if (name.equals("relatedPlan")) {
            return this.addRelatedPlan();
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals(SP_GOAL)) {
            return this.addGoal();
        }
        if (name.equals("activity")) {
            return this.addActivity();
        }
        if (name.equals("note")) {
            this.note = new Annotation();
            return this.note;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CarePlan";
    }

    @Override
    public CarePlan copy() {
        CarePlan dst = new CarePlan();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.context = this.context == null ? null : this.context.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.author != null) {
            dst.author = new ArrayList<Reference>();
            for (Reference reference : this.author) {
                dst.author.add(reference.copy());
            }
        }
        DateTimeType dateTimeType = dst.modified = this.modified == null ? null : this.modified.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.addresses != null) {
            dst.addresses = new ArrayList<Reference>();
            for (Reference reference : this.addresses) {
                dst.addresses.add(reference.copy());
            }
        }
        if (this.support != null) {
            dst.support = new ArrayList<Reference>();
            for (Reference reference : this.support) {
                dst.support.add(reference.copy());
            }
        }
        if (this.relatedPlan != null) {
            dst.relatedPlan = new ArrayList<CarePlanRelatedPlanComponent>();
            for (CarePlanRelatedPlanComponent carePlanRelatedPlanComponent : this.relatedPlan) {
                dst.relatedPlan.add(carePlanRelatedPlanComponent.copy());
            }
        }
        if (this.participant != null) {
            dst.participant = new ArrayList<CarePlanParticipantComponent>();
            for (CarePlanParticipantComponent carePlanParticipantComponent : this.participant) {
                dst.participant.add(carePlanParticipantComponent.copy());
            }
        }
        if (this.goal != null) {
            dst.goal = new ArrayList<Reference>();
            for (Reference reference : this.goal) {
                dst.goal.add(reference.copy());
            }
        }
        if (this.activity != null) {
            dst.activity = new ArrayList<CarePlanActivityComponent>();
            for (CarePlanActivityComponent carePlanActivityComponent : this.activity) {
                dst.activity.add(carePlanActivityComponent.copy());
            }
        }
        dst.note = this.note == null ? null : this.note.copy();
        return dst;
    }

    protected CarePlan typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof CarePlan)) {
            return false;
        }
        CarePlan o = (CarePlan)other;
        return CarePlan.compareDeep(this.identifier, o.identifier, true) && CarePlan.compareDeep(this.subject, o.subject, true) && CarePlan.compareDeep(this.status, o.status, true) && CarePlan.compareDeep(this.context, o.context, true) && CarePlan.compareDeep(this.period, o.period, true) && CarePlan.compareDeep(this.author, o.author, true) && CarePlan.compareDeep(this.modified, o.modified, true) && CarePlan.compareDeep(this.category, o.category, true) && CarePlan.compareDeep(this.description, o.description, true) && CarePlan.compareDeep(this.addresses, o.addresses, true) && CarePlan.compareDeep(this.support, o.support, true) && CarePlan.compareDeep(this.relatedPlan, o.relatedPlan, true) && CarePlan.compareDeep(this.participant, o.participant, true) && CarePlan.compareDeep(this.goal, o.goal, true) && CarePlan.compareDeep(this.activity, o.activity, true) && CarePlan.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof CarePlan)) {
            return false;
        }
        CarePlan o = (CarePlan)other;
        return CarePlan.compareValues(this.status, o.status, true) && CarePlan.compareValues(this.modified, o.modified, true) && CarePlan.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.status != null && !this.status.isEmpty() || this.context != null && !this.context.isEmpty() || this.period != null && !this.period.isEmpty() || this.author != null && !this.author.isEmpty() || this.modified != null && !this.modified.isEmpty() || this.category != null && !this.category.isEmpty() || this.description != null && !this.description.isEmpty() || this.addresses != null && !this.addresses.isEmpty() || this.support != null && !this.support.isEmpty() || this.relatedPlan != null && !this.relatedPlan.isEmpty() || this.participant != null && !this.participant.isEmpty() || this.goal != null && !this.goal.isEmpty() || this.activity != null && !this.activity.isEmpty() || this.note != null && !this.note.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CarePlan;
    }

    @Block
    public static class CarePlanActivityDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="diet | drug | encounter | observation | procedure | supply | other", formalDefinition="High-level categorization of the type of activity in a care plan.")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detail type of activity", formalDefinition="Detailed description of the type of planned activity; e.g. What lab test, what procedure, what kind of encounter.")
        protected CodeableConcept code;
        @Child(name="reasonCode", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why activity should be done", formalDefinition="Provides the rationale that drove the inclusion of this particular activity as part of the plan.")
        protected List<CodeableConcept> reasonCode;
        @Child(name="reasonReference", type={Condition.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Condition triggering need for activity", formalDefinition="Provides the health condition(s) that drove the inclusion of this particular activity as part of the plan.")
        protected List<Reference> reasonReference;
        protected List<Condition> reasonReferenceTarget;
        @Child(name="goal", type={Goal.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Goals this activity relates to", formalDefinition="Internal reference that identifies the goals that this activity is intended to contribute towards meeting.")
        protected List<Reference> goal;
        protected List<Goal> goalTarget;
        @Child(name="status", type={CodeType.class}, order=6, min=0, max=1, modifier=true, summary=false)
        @Description(shortDefinition="not-started | scheduled | in-progress | on-hold | completed | cancelled", formalDefinition="Identifies what progress is being made for the specific activity.")
        protected Enumeration<CarePlanActivityStatus> status;
        @Child(name="statusReason", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason for current status", formalDefinition="Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.")
        protected CodeableConcept statusReason;
        @Child(name="prohibited", type={BooleanType.class}, order=8, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="Do NOT do", formalDefinition="If true, indicates that the described activity is one that must NOT be engaged in when following the plan.")
        protected BooleanType prohibited;
        @Child(name="scheduled", type={Timing.class, Period.class, StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When activity is to occur", formalDefinition="The period, timing or frequency upon which the described activity is to occur.")
        protected Type scheduled;
        @Child(name="location", type={Location.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.")
        protected Reference location;
        protected Location locationTarget;
        @Child(name="performer", type={Practitioner.class, Organization.class, RelatedPerson.class, Patient.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who will be responsible?", formalDefinition="Identifies who's expected to be involved in the activity.")
        protected List<Reference> performer;
        protected List<Resource> performerTarget;
        @Child(name="product", type={CodeableConcept.class, Medication.class, Substance.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What is to be administered/supplied", formalDefinition="Identifies the food, drug or other product to be consumed or supplied in the activity.")
        protected Type product;
        @Child(name="dailyAmount", type={SimpleQuantity.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How to consume/day?", formalDefinition="Identifies the quantity expected to be consumed in a given day.")
        protected SimpleQuantity dailyAmount;
        @Child(name="quantity", type={SimpleQuantity.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How much to administer/supply/consume", formalDefinition="Identifies the quantity expected to be supplied, administered or consumed by the subject.")
        protected SimpleQuantity quantity;
        @Child(name="description", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Extra info describing activity to perform", formalDefinition="This provides a textual description of constraints on the intended activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.")
        protected StringType description;
        private static final long serialVersionUID = -1763965702L;

        public CarePlanActivityDetailComponent() {
        }

        public CarePlanActivityDetailComponent(BooleanType prohibited) {
            this.prohibited = prohibited;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public CarePlanActivityDetailComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CarePlanActivityDetailComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<CodeableConcept> getReasonCode() {
            if (this.reasonCode == null) {
                this.reasonCode = new ArrayList<CodeableConcept>();
            }
            return this.reasonCode;
        }

        public boolean hasReasonCode() {
            if (this.reasonCode == null) {
                return false;
            }
            for (CodeableConcept item : this.reasonCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReasonCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.reasonCode == null) {
                this.reasonCode = new ArrayList<CodeableConcept>();
            }
            this.reasonCode.add(t);
            return t;
        }

        public CarePlanActivityDetailComponent addReasonCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reasonCode == null) {
                this.reasonCode = new ArrayList<CodeableConcept>();
            }
            this.reasonCode.add(t);
            return this;
        }

        public List<Reference> getReasonReference() {
            if (this.reasonReference == null) {
                this.reasonReference = new ArrayList<Reference>();
            }
            return this.reasonReference;
        }

        public boolean hasReasonReference() {
            if (this.reasonReference == null) {
                return false;
            }
            for (Reference item : this.reasonReference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addReasonReference() {
            Reference t = new Reference();
            if (this.reasonReference == null) {
                this.reasonReference = new ArrayList<Reference>();
            }
            this.reasonReference.add(t);
            return t;
        }

        public CarePlanActivityDetailComponent addReasonReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.reasonReference == null) {
                this.reasonReference = new ArrayList<Reference>();
            }
            this.reasonReference.add(t);
            return this;
        }

        public List<Condition> getReasonReferenceTarget() {
            if (this.reasonReferenceTarget == null) {
                this.reasonReferenceTarget = new ArrayList<Condition>();
            }
            return this.reasonReferenceTarget;
        }

        public Condition addReasonReferenceTarget() {
            Condition r = new Condition();
            if (this.reasonReferenceTarget == null) {
                this.reasonReferenceTarget = new ArrayList<Condition>();
            }
            this.reasonReferenceTarget.add(r);
            return r;
        }

        public List<Reference> getGoal() {
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            return this.goal;
        }

        public boolean hasGoal() {
            if (this.goal == null) {
                return false;
            }
            for (Reference item : this.goal) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addGoal() {
            Reference t = new Reference();
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return t;
        }

        public CarePlanActivityDetailComponent addGoal(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return this;
        }

        public List<Goal> getGoalTarget() {
            if (this.goalTarget == null) {
                this.goalTarget = new ArrayList<Goal>();
            }
            return this.goalTarget;
        }

        public Goal addGoalTarget() {
            Goal r = new Goal();
            if (this.goalTarget == null) {
                this.goalTarget = new ArrayList<Goal>();
            }
            this.goalTarget.add(r);
            return r;
        }

        public Enumeration<CarePlanActivityStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<CarePlanActivityStatus>(new CarePlanActivityStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public CarePlanActivityDetailComponent setStatusElement(Enumeration<CarePlanActivityStatus> value) {
            this.status = value;
            return this;
        }

        public CarePlanActivityStatus getStatus() {
            return this.status == null ? null : (CarePlanActivityStatus)((Object)this.status.getValue());
        }

        public CarePlanActivityDetailComponent setStatus(CarePlanActivityStatus value) {
            if (value == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration<CarePlanActivityStatus>(new CarePlanActivityStatusEnumFactory());
                }
                this.status.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getStatusReason() {
            if (this.statusReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.statusReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.statusReason = new CodeableConcept();
                }
            }
            return this.statusReason;
        }

        public boolean hasStatusReason() {
            return this.statusReason != null && !this.statusReason.isEmpty();
        }

        public CarePlanActivityDetailComponent setStatusReason(CodeableConcept value) {
            this.statusReason = value;
            return this;
        }

        public BooleanType getProhibitedElement() {
            if (this.prohibited == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.prohibited");
                }
                if (Configuration.doAutoCreate()) {
                    this.prohibited = new BooleanType();
                }
            }
            return this.prohibited;
        }

        public boolean hasProhibitedElement() {
            return this.prohibited != null && !this.prohibited.isEmpty();
        }

        public boolean hasProhibited() {
            return this.prohibited != null && !this.prohibited.isEmpty();
        }

        public CarePlanActivityDetailComponent setProhibitedElement(BooleanType value) {
            this.prohibited = value;
            return this;
        }

        public boolean getProhibited() {
            return this.prohibited == null || this.prohibited.isEmpty() ? false : (Boolean)this.prohibited.getValue();
        }

        public CarePlanActivityDetailComponent setProhibited(boolean value) {
            if (this.prohibited == null) {
                this.prohibited = new BooleanType();
            }
            this.prohibited.setValue((Object)value);
            return this;
        }

        public Type getScheduled() {
            return this.scheduled;
        }

        public Timing getScheduledTiming() throws FHIRException {
            if (!(this.scheduled instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.scheduled.getClass().getName() + " was encountered");
            }
            return (Timing)this.scheduled;
        }

        public boolean hasScheduledTiming() {
            return this.scheduled instanceof Timing;
        }

        public Period getScheduledPeriod() throws FHIRException {
            if (!(this.scheduled instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.scheduled.getClass().getName() + " was encountered");
            }
            return (Period)this.scheduled;
        }

        public boolean hasScheduledPeriod() {
            return this.scheduled instanceof Period;
        }

        public StringType getScheduledStringType() throws FHIRException {
            if (!(this.scheduled instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.scheduled.getClass().getName() + " was encountered");
            }
            return (StringType)this.scheduled;
        }

        public boolean hasScheduledStringType() {
            return this.scheduled instanceof StringType;
        }

        public boolean hasScheduled() {
            return this.scheduled != null && !this.scheduled.isEmpty();
        }

        public CarePlanActivityDetailComponent setScheduled(Type value) {
            this.scheduled = value;
            return this;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public CarePlanActivityDetailComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Location getLocationTarget() {
            if (this.locationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.locationTarget = new Location();
                }
            }
            return this.locationTarget;
        }

        public CarePlanActivityDetailComponent setLocationTarget(Location value) {
            this.locationTarget = value;
            return this;
        }

        public List<Reference> getPerformer() {
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            return this.performer;
        }

        public boolean hasPerformer() {
            if (this.performer == null) {
                return false;
            }
            for (Reference item : this.performer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addPerformer() {
            Reference t = new Reference();
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return t;
        }

        public CarePlanActivityDetailComponent addPerformer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return this;
        }

        public List<Resource> getPerformerTarget() {
            if (this.performerTarget == null) {
                this.performerTarget = new ArrayList<Resource>();
            }
            return this.performerTarget;
        }

        public Type getProduct() {
            return this.product;
        }

        public CodeableConcept getProductCodeableConcept() throws FHIRException {
            if (!(this.product instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.product.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.product;
        }

        public boolean hasProductCodeableConcept() {
            return this.product instanceof CodeableConcept;
        }

        public Reference getProductReference() throws FHIRException {
            if (!(this.product instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.product.getClass().getName() + " was encountered");
            }
            return (Reference)this.product;
        }

        public boolean hasProductReference() {
            return this.product instanceof Reference;
        }

        public boolean hasProduct() {
            return this.product != null && !this.product.isEmpty();
        }

        public CarePlanActivityDetailComponent setProduct(Type value) {
            this.product = value;
            return this;
        }

        public SimpleQuantity getDailyAmount() {
            if (this.dailyAmount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.dailyAmount");
                }
                if (Configuration.doAutoCreate()) {
                    this.dailyAmount = new SimpleQuantity();
                }
            }
            return this.dailyAmount;
        }

        public boolean hasDailyAmount() {
            return this.dailyAmount != null && !this.dailyAmount.isEmpty();
        }

        public CarePlanActivityDetailComponent setDailyAmount(SimpleQuantity value) {
            this.dailyAmount = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public CarePlanActivityDetailComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CarePlanActivityDetailComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CarePlanActivityDetailComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("category", "CodeableConcept", "High-level categorization of the type of activity in a care plan.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property("code", "CodeableConcept", "Detailed description of the type of planned activity; e.g. What lab test, what procedure, what kind of encounter.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("reasonCode", "CodeableConcept", "Provides the rationale that drove the inclusion of this particular activity as part of the plan.", 0, Integer.MAX_VALUE, this.reasonCode));
            childrenList.add(new Property("reasonReference", "Reference(Condition)", "Provides the health condition(s) that drove the inclusion of this particular activity as part of the plan.", 0, Integer.MAX_VALUE, this.reasonReference));
            childrenList.add(new Property(CarePlan.SP_GOAL, "Reference(Goal)", "Internal reference that identifies the goals that this activity is intended to contribute towards meeting.", 0, Integer.MAX_VALUE, this.goal));
            childrenList.add(new Property("status", "code", "Identifies what progress is being made for the specific activity.", 0, Integer.MAX_VALUE, this.status));
            childrenList.add(new Property("statusReason", "CodeableConcept", "Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.", 0, Integer.MAX_VALUE, this.statusReason));
            childrenList.add(new Property("prohibited", "boolean", "If true, indicates that the described activity is one that must NOT be engaged in when following the plan.", 0, Integer.MAX_VALUE, this.prohibited));
            childrenList.add(new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, Integer.MAX_VALUE, this.scheduled));
            childrenList.add(new Property("location", "Reference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, Integer.MAX_VALUE, this.location));
            childrenList.add(new Property(CarePlan.SP_PERFORMER, "Reference(Practitioner|Organization|RelatedPerson|Patient)", "Identifies who's expected to be involved in the activity.", 0, Integer.MAX_VALUE, this.performer));
            childrenList.add(new Property("product[x]", "CodeableConcept|Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, Integer.MAX_VALUE, this.product));
            childrenList.add(new Property("dailyAmount", "SimpleQuantity", "Identifies the quantity expected to be consumed in a given day.", 0, Integer.MAX_VALUE, this.dailyAmount));
            childrenList.add(new Property("quantity", "SimpleQuantity", "Identifies the quantity expected to be supplied, administered or consumed by the subject.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("description", "string", "This provides a textual description of constraints on the intended activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.", 0, Integer.MAX_VALUE, this.description));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 722137681: {
                    return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
                }
                case -1146218137: {
                    return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
                }
                case 3178259: {
                    return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.status;
                    }
                    return baseArray;
                }
                case 2051346646: {
                    Base[] baseArray;
                    if (this.statusReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.statusReason;
                    }
                    return baseArray;
                }
                case 663275198: {
                    Base[] baseArray;
                    if (this.prohibited == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.prohibited;
                    }
                    return baseArray;
                }
                case -160710483: {
                    Base[] baseArray;
                    if (this.scheduled == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.scheduled;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.location;
                    }
                    return baseArray;
                }
                case 481140686: {
                    return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
                }
                case -309474065: {
                    Base[] baseArray;
                    if (this.product == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.product;
                    }
                    return baseArray;
                }
                case -768908335: {
                    Base[] baseArray;
                    if (this.dailyAmount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.dailyAmount;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    break;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    break;
                }
                case 722137681: {
                    this.getReasonCode().add(this.castToCodeableConcept(value));
                    break;
                }
                case -1146218137: {
                    this.getReasonReference().add(this.castToReference(value));
                    break;
                }
                case 3178259: {
                    this.getGoal().add(this.castToReference(value));
                    break;
                }
                case -892481550: {
                    this.status = new CarePlanActivityStatusEnumFactory().fromType(value);
                    break;
                }
                case 2051346646: {
                    this.statusReason = this.castToCodeableConcept(value);
                    break;
                }
                case 663275198: {
                    this.prohibited = this.castToBoolean(value);
                    break;
                }
                case -160710483: {
                    this.scheduled = (Type)value;
                    break;
                }
                case 1901043637: {
                    this.location = this.castToReference(value);
                    break;
                }
                case 481140686: {
                    this.getPerformer().add(this.castToReference(value));
                    break;
                }
                case -309474065: {
                    this.product = (Type)value;
                    break;
                }
                case -768908335: {
                    this.dailyAmount = this.castToSimpleQuantity(value);
                    break;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("reasonCode")) {
                this.getReasonCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("reasonReference")) {
                this.getReasonReference().add(this.castToReference(value));
            } else if (name.equals(CarePlan.SP_GOAL)) {
                this.getGoal().add(this.castToReference(value));
            } else if (name.equals("status")) {
                this.status = new CarePlanActivityStatusEnumFactory().fromType(value);
            } else if (name.equals("statusReason")) {
                this.statusReason = this.castToCodeableConcept(value);
            } else if (name.equals("prohibited")) {
                this.prohibited = this.castToBoolean(value);
            } else if (name.equals("scheduled[x]")) {
                this.scheduled = (Type)value;
            } else if (name.equals("location")) {
                this.location = this.castToReference(value);
            } else if (name.equals(CarePlan.SP_PERFORMER)) {
                this.getPerformer().add(this.castToReference(value));
            } else if (name.equals("product[x]")) {
                this.product = (Type)value;
            } else if (name.equals("dailyAmount")) {
                this.dailyAmount = this.castToSimpleQuantity(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 722137681: {
                    return this.addReasonCode();
                }
                case -1146218137: {
                    return this.addReasonReference();
                }
                case 3178259: {
                    return this.addGoal();
                }
                case -892481550: {
                    throw new FHIRException("Cannot make property status as it is not a complex type");
                }
                case 2051346646: {
                    return this.getStatusReason();
                }
                case 663275198: {
                    throw new FHIRException("Cannot make property prohibited as it is not a complex type");
                }
                case 1162627251: {
                    return this.getScheduled();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case 481140686: {
                    return this.addPerformer();
                }
                case 1753005361: {
                    return this.getProduct();
                }
                case -768908335: {
                    return this.getDailyAmount();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("reasonCode")) {
                return this.addReasonCode();
            }
            if (name.equals("reasonReference")) {
                return this.addReasonReference();
            }
            if (name.equals(CarePlan.SP_GOAL)) {
                return this.addGoal();
            }
            if (name.equals("status")) {
                throw new FHIRException("Cannot call addChild on a singleton property CarePlan.status");
            }
            if (name.equals("statusReason")) {
                this.statusReason = new CodeableConcept();
                return this.statusReason;
            }
            if (name.equals("prohibited")) {
                throw new FHIRException("Cannot call addChild on a singleton property CarePlan.prohibited");
            }
            if (name.equals("scheduledTiming")) {
                this.scheduled = new Timing();
                return this.scheduled;
            }
            if (name.equals("scheduledPeriod")) {
                this.scheduled = new Period();
                return this.scheduled;
            }
            if (name.equals("scheduledString")) {
                this.scheduled = new StringType();
                return this.scheduled;
            }
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals(CarePlan.SP_PERFORMER)) {
                return this.addPerformer();
            }
            if (name.equals("productCodeableConcept")) {
                this.product = new CodeableConcept();
                return this.product;
            }
            if (name.equals("productReference")) {
                this.product = new Reference();
                return this.product;
            }
            if (name.equals("dailyAmount")) {
                this.dailyAmount = new SimpleQuantity();
                return this.dailyAmount;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property CarePlan.description");
            }
            return super.addChild(name);
        }

        @Override
        public CarePlanActivityDetailComponent copy() {
            CarePlanActivityDetailComponent dst = new CarePlanActivityDetailComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.reasonCode != null) {
                dst.reasonCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.reasonCode) {
                    dst.reasonCode.add(codeableConcept2.copy());
                }
            }
            if (this.reasonReference != null) {
                dst.reasonReference = new ArrayList<Reference>();
                for (Reference reference : this.reasonReference) {
                    dst.reasonReference.add(reference.copy());
                }
            }
            if (this.goal != null) {
                dst.goal = new ArrayList<Reference>();
                for (Reference reference : this.goal) {
                    dst.goal.add(reference.copy());
                }
            }
            dst.status = this.status == null ? null : this.status.copy();
            dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
            dst.prohibited = this.prohibited == null ? null : this.prohibited.copy();
            dst.scheduled = this.scheduled == null ? null : this.scheduled.copy();
            Reference reference = dst.location = this.location == null ? null : this.location.copy();
            if (this.performer != null) {
                dst.performer = new ArrayList<Reference>();
                for (Reference reference2 : this.performer) {
                    dst.performer.add(reference2.copy());
                }
            }
            dst.product = this.product == null ? null : this.product.copy();
            dst.dailyAmount = this.dailyAmount == null ? null : this.dailyAmount.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.description = this.description == null ? null : this.description.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CarePlanActivityDetailComponent)) {
                return false;
            }
            CarePlanActivityDetailComponent o = (CarePlanActivityDetailComponent)other;
            return CarePlanActivityDetailComponent.compareDeep(this.category, o.category, true) && CarePlanActivityDetailComponent.compareDeep(this.code, o.code, true) && CarePlanActivityDetailComponent.compareDeep(this.reasonCode, o.reasonCode, true) && CarePlanActivityDetailComponent.compareDeep(this.reasonReference, o.reasonReference, true) && CarePlanActivityDetailComponent.compareDeep(this.goal, o.goal, true) && CarePlanActivityDetailComponent.compareDeep(this.status, o.status, true) && CarePlanActivityDetailComponent.compareDeep(this.statusReason, o.statusReason, true) && CarePlanActivityDetailComponent.compareDeep(this.prohibited, o.prohibited, true) && CarePlanActivityDetailComponent.compareDeep(this.scheduled, o.scheduled, true) && CarePlanActivityDetailComponent.compareDeep(this.location, o.location, true) && CarePlanActivityDetailComponent.compareDeep(this.performer, o.performer, true) && CarePlanActivityDetailComponent.compareDeep(this.product, o.product, true) && CarePlanActivityDetailComponent.compareDeep(this.dailyAmount, o.dailyAmount, true) && CarePlanActivityDetailComponent.compareDeep(this.quantity, o.quantity, true) && CarePlanActivityDetailComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CarePlanActivityDetailComponent)) {
                return false;
            }
            CarePlanActivityDetailComponent o = (CarePlanActivityDetailComponent)other;
            return CarePlanActivityDetailComponent.compareValues(this.status, o.status, true) && CarePlanActivityDetailComponent.compareValues(this.prohibited, o.prohibited, true) && CarePlanActivityDetailComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.category != null && !this.category.isEmpty() || this.code != null && !this.code.isEmpty() || this.reasonCode != null && !this.reasonCode.isEmpty() || this.reasonReference != null && !this.reasonReference.isEmpty() || this.goal != null && !this.goal.isEmpty() || this.status != null && !this.status.isEmpty() || this.statusReason != null && !this.statusReason.isEmpty() || this.prohibited != null && !this.prohibited.isEmpty() || this.scheduled != null && !this.scheduled.isEmpty() || this.location != null && !this.location.isEmpty() || this.performer != null && !this.performer.isEmpty() || this.product != null && !this.product.isEmpty() || this.dailyAmount != null && !this.dailyAmount.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.description != null && !this.description.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CarePlan.activity.detail";
        }
    }

    @Block
    public static class CarePlanActivityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actionResulting", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Appointments, orders, etc.", formalDefinition="Resources that describe follow-on actions resulting from the plan, such as drug prescriptions, encounter records, appointments, etc.")
        protected List<Reference> actionResulting;
        protected List<Resource> actionResultingTarget;
        @Child(name="progress", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Comments about the activity status/progress", formalDefinition="Notes about the adherence/status/progress of the activity.")
        protected List<Annotation> progress;
        @Child(name="reference", type={Appointment.class, CommunicationRequest.class, DeviceUseRequest.class, DiagnosticOrder.class, MedicationOrder.class, NutritionOrder.class, Order.class, ProcedureRequest.class, ProcessRequest.class, ReferralRequest.class, SupplyRequest.class, VisionPrescription.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Activity details defined in specific resource", formalDefinition="The details of the proposed activity represented in a specific resource.")
        protected Reference reference;
        protected Resource referenceTarget;
        @Child(name="detail", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="In-line definition of activity", formalDefinition="A simple summary of a planned activity suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.")
        protected CarePlanActivityDetailComponent detail;
        private static final long serialVersionUID = 40181608L;

        public List<Reference> getActionResulting() {
            if (this.actionResulting == null) {
                this.actionResulting = new ArrayList<Reference>();
            }
            return this.actionResulting;
        }

        public boolean hasActionResulting() {
            if (this.actionResulting == null) {
                return false;
            }
            for (Reference item : this.actionResulting) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addActionResulting() {
            Reference t = new Reference();
            if (this.actionResulting == null) {
                this.actionResulting = new ArrayList<Reference>();
            }
            this.actionResulting.add(t);
            return t;
        }

        public CarePlanActivityComponent addActionResulting(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.actionResulting == null) {
                this.actionResulting = new ArrayList<Reference>();
            }
            this.actionResulting.add(t);
            return this;
        }

        public List<Resource> getActionResultingTarget() {
            if (this.actionResultingTarget == null) {
                this.actionResultingTarget = new ArrayList<Resource>();
            }
            return this.actionResultingTarget;
        }

        public List<Annotation> getProgress() {
            if (this.progress == null) {
                this.progress = new ArrayList<Annotation>();
            }
            return this.progress;
        }

        public boolean hasProgress() {
            if (this.progress == null) {
                return false;
            }
            for (Annotation item : this.progress) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addProgress() {
            Annotation t = new Annotation();
            if (this.progress == null) {
                this.progress = new ArrayList<Annotation>();
            }
            this.progress.add(t);
            return t;
        }

        public CarePlanActivityComponent addProgress(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.progress == null) {
                this.progress = new ArrayList<Annotation>();
            }
            this.progress.add(t);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public CarePlanActivityComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public CarePlanActivityComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        public CarePlanActivityDetailComponent getDetail() {
            if (this.detail == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityComponent.detail");
                }
                if (Configuration.doAutoCreate()) {
                    this.detail = new CarePlanActivityDetailComponent();
                }
            }
            return this.detail;
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public CarePlanActivityComponent setDetail(CarePlanActivityDetailComponent value) {
            this.detail = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("actionResulting", "Reference(Any)", "Resources that describe follow-on actions resulting from the plan, such as drug prescriptions, encounter records, appointments, etc.", 0, Integer.MAX_VALUE, this.actionResulting));
            childrenList.add(new Property("progress", "Annotation", "Notes about the adherence/status/progress of the activity.", 0, Integer.MAX_VALUE, this.progress));
            childrenList.add(new Property("reference", "Reference(Appointment|CommunicationRequest|DeviceUseRequest|DiagnosticOrder|MedicationOrder|NutritionOrder|Order|ProcedureRequest|ProcessRequest|ReferralRequest|SupplyRequest|VisionPrescription)", "The details of the proposed activity represented in a specific resource.", 0, Integer.MAX_VALUE, this.reference));
            childrenList.add(new Property("detail", "", "A simple summary of a planned activity suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 836386063: {
                    return this.actionResulting == null ? new Base[]{} : this.actionResulting.toArray(new Base[this.actionResulting.size()]);
                }
                case -1001078227: {
                    return this.progress == null ? new Base[]{} : this.progress.toArray(new Base[this.progress.size()]);
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reference;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detail;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 836386063: {
                    this.getActionResulting().add(this.castToReference(value));
                    break;
                }
                case -1001078227: {
                    this.getProgress().add(this.castToAnnotation(value));
                    break;
                }
                case -925155509: {
                    this.reference = this.castToReference(value);
                    break;
                }
                case -1335224239: {
                    this.detail = (CarePlanActivityDetailComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actionResulting")) {
                this.getActionResulting().add(this.castToReference(value));
            } else if (name.equals("progress")) {
                this.getProgress().add(this.castToAnnotation(value));
            } else if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else if (name.equals("detail")) {
                this.detail = (CarePlanActivityDetailComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 836386063: {
                    return this.addActionResulting();
                }
                case -1001078227: {
                    return this.addProgress();
                }
                case -925155509: {
                    return this.getReference();
                }
                case -1335224239: {
                    return this.getDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actionResulting")) {
                return this.addActionResulting();
            }
            if (name.equals("progress")) {
                return this.addProgress();
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals("detail")) {
                this.detail = new CarePlanActivityDetailComponent();
                return this.detail;
            }
            return super.addChild(name);
        }

        @Override
        public CarePlanActivityComponent copy() {
            CarePlanActivityComponent dst = new CarePlanActivityComponent();
            this.copyValues(dst);
            if (this.actionResulting != null) {
                dst.actionResulting = new ArrayList<Reference>();
                for (Reference reference : this.actionResulting) {
                    dst.actionResulting.add(reference.copy());
                }
            }
            if (this.progress != null) {
                dst.progress = new ArrayList<Annotation>();
                for (Annotation annotation : this.progress) {
                    dst.progress.add(annotation.copy());
                }
            }
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CarePlanActivityComponent)) {
                return false;
            }
            CarePlanActivityComponent o = (CarePlanActivityComponent)other;
            return CarePlanActivityComponent.compareDeep(this.actionResulting, o.actionResulting, true) && CarePlanActivityComponent.compareDeep(this.progress, o.progress, true) && CarePlanActivityComponent.compareDeep(this.reference, o.reference, true) && CarePlanActivityComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CarePlanActivityComponent)) {
                return false;
            }
            CarePlanActivityComponent o = (CarePlanActivityComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.actionResulting != null && !this.actionResulting.isEmpty() || this.progress != null && !this.progress.isEmpty() || this.reference != null && !this.reference.isEmpty() || this.detail != null && !this.detail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CarePlan.activity";
        }
    }

    @Block
    public static class CarePlanParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of involvement", formalDefinition="Indicates specific responsibility of an individual within the care plan; e.g. \"Primary physician\", \"Team coordinator\", \"Caregiver\", etc.")
        protected CodeableConcept role;
        @Child(name="member", type={Practitioner.class, RelatedPerson.class, Patient.class, Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who is involved", formalDefinition="The specific person or organization who is participating/expected to participate in the care plan.")
        protected Reference member;
        protected Resource memberTarget;
        private static final long serialVersionUID = -466811117L;

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CarePlanParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getMember() {
            if (this.member == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanParticipantComponent.member");
                }
                if (Configuration.doAutoCreate()) {
                    this.member = new Reference();
                }
            }
            return this.member;
        }

        public boolean hasMember() {
            return this.member != null && !this.member.isEmpty();
        }

        public CarePlanParticipantComponent setMember(Reference value) {
            this.member = value;
            return this;
        }

        public Resource getMemberTarget() {
            return this.memberTarget;
        }

        public CarePlanParticipantComponent setMemberTarget(Resource value) {
            this.memberTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("role", "CodeableConcept", "Indicates specific responsibility of an individual within the care plan; e.g. \"Primary physician\", \"Team coordinator\", \"Caregiver\", etc.", 0, Integer.MAX_VALUE, this.role));
            childrenList.add(new Property("member", "Reference(Practitioner|RelatedPerson|Patient|Organization)", "The specific person or organization who is participating/expected to participate in the care plan.", 0, Integer.MAX_VALUE, this.member));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -1077769574: {
                    Base[] baseArray;
                    if (this.member == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.member;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    break;
                }
                case -1077769574: {
                    this.member = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("member")) {
                this.member = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -1077769574: {
                    return this.getMember();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("member")) {
                this.member = new Reference();
                return this.member;
            }
            return super.addChild(name);
        }

        @Override
        public CarePlanParticipantComponent copy() {
            CarePlanParticipantComponent dst = new CarePlanParticipantComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.member = this.member == null ? null : this.member.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CarePlanParticipantComponent)) {
                return false;
            }
            CarePlanParticipantComponent o = (CarePlanParticipantComponent)other;
            return CarePlanParticipantComponent.compareDeep(this.role, o.role, true) && CarePlanParticipantComponent.compareDeep(this.member, o.member, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CarePlanParticipantComponent)) {
                return false;
            }
            CarePlanParticipantComponent o = (CarePlanParticipantComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.role != null && !this.role.isEmpty() || this.member != null && !this.member.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CarePlan.participant";
        }
    }

    @Block
    public static class CarePlanRelatedPlanComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="includes | replaces | fulfills", formalDefinition="Identifies the type of relationship this plan has to the target plan.")
        protected Enumeration<CarePlanRelationship> code;
        @Child(name="plan", type={CarePlan.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Plan relationship exists with", formalDefinition="A reference to the plan to which a relationship is asserted.")
        protected Reference plan;
        protected CarePlan planTarget;
        private static final long serialVersionUID = 1875598050L;

        public CarePlanRelatedPlanComponent() {
        }

        public CarePlanRelatedPlanComponent(Reference plan) {
            this.plan = plan;
        }

        public Enumeration<CarePlanRelationship> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanRelatedPlanComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<CarePlanRelationship>(new CarePlanRelationshipEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CarePlanRelatedPlanComponent setCodeElement(Enumeration<CarePlanRelationship> value) {
            this.code = value;
            return this;
        }

        public CarePlanRelationship getCode() {
            return this.code == null ? null : (CarePlanRelationship)((Object)this.code.getValue());
        }

        public CarePlanRelatedPlanComponent setCode(CarePlanRelationship value) {
            if (value == null) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new Enumeration<CarePlanRelationship>(new CarePlanRelationshipEnumFactory());
                }
                this.code.setValue((Object)value);
            }
            return this;
        }

        public Reference getPlan() {
            if (this.plan == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanRelatedPlanComponent.plan");
                }
                if (Configuration.doAutoCreate()) {
                    this.plan = new Reference();
                }
            }
            return this.plan;
        }

        public boolean hasPlan() {
            return this.plan != null && !this.plan.isEmpty();
        }

        public CarePlanRelatedPlanComponent setPlan(Reference value) {
            this.plan = value;
            return this;
        }

        public CarePlan getPlanTarget() {
            if (this.planTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanRelatedPlanComponent.plan");
                }
                if (Configuration.doAutoCreate()) {
                    this.planTarget = new CarePlan();
                }
            }
            return this.planTarget;
        }

        public CarePlanRelatedPlanComponent setPlanTarget(CarePlan value) {
            this.planTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "code", "Identifies the type of relationship this plan has to the target plan.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("plan", "Reference(CarePlan)", "A reference to the plan to which a relationship is asserted.", 0, Integer.MAX_VALUE, this.plan));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 3443497: {
                    Base[] baseArray;
                    if (this.plan == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.plan;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = new CarePlanRelationshipEnumFactory().fromType(value);
                    break;
                }
                case 3443497: {
                    this.plan = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CarePlanRelationshipEnumFactory().fromType(value);
            } else if (name.equals("plan")) {
                this.plan = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    throw new FHIRException("Cannot make property code as it is not a complex type");
                }
                case 3443497: {
                    return this.getPlan();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property CarePlan.code");
            }
            if (name.equals("plan")) {
                this.plan = new Reference();
                return this.plan;
            }
            return super.addChild(name);
        }

        @Override
        public CarePlanRelatedPlanComponent copy() {
            CarePlanRelatedPlanComponent dst = new CarePlanRelatedPlanComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.plan = this.plan == null ? null : this.plan.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CarePlanRelatedPlanComponent)) {
                return false;
            }
            CarePlanRelatedPlanComponent o = (CarePlanRelatedPlanComponent)other;
            return CarePlanRelatedPlanComponent.compareDeep(this.code, o.code, true) && CarePlanRelatedPlanComponent.compareDeep(this.plan, o.plan, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CarePlanRelatedPlanComponent)) {
                return false;
            }
            CarePlanRelatedPlanComponent o = (CarePlanRelatedPlanComponent)other;
            return CarePlanRelatedPlanComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.plan != null && !this.plan.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CarePlan.relatedPlan";
        }
    }

    public static class CarePlanActivityStatusEnumFactory
    implements EnumFactory<CarePlanActivityStatus> {
        @Override
        public CarePlanActivityStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-started".equals(codeString)) {
                return CarePlanActivityStatus.NOTSTARTED;
            }
            if ("scheduled".equals(codeString)) {
                return CarePlanActivityStatus.SCHEDULED;
            }
            if ("in-progress".equals(codeString)) {
                return CarePlanActivityStatus.INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return CarePlanActivityStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return CarePlanActivityStatus.COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CarePlanActivityStatus.CANCELLED;
            }
            throw new IllegalArgumentException("Unknown CarePlanActivityStatus code '" + codeString + "'");
        }

        public Enumeration<CarePlanActivityStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-started".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.NOTSTARTED);
            }
            if ("scheduled".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.SCHEDULED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.INPROGRESS);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.ONHOLD);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.COMPLETED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.CANCELLED);
            }
            throw new FHIRException("Unknown CarePlanActivityStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CarePlanActivityStatus code) {
            if (code == CarePlanActivityStatus.NULL) {
                return null;
            }
            if (code == CarePlanActivityStatus.NOTSTARTED) {
                return "not-started";
            }
            if (code == CarePlanActivityStatus.SCHEDULED) {
                return "scheduled";
            }
            if (code == CarePlanActivityStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == CarePlanActivityStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == CarePlanActivityStatus.COMPLETED) {
                return "completed";
            }
            if (code == CarePlanActivityStatus.CANCELLED) {
                return "cancelled";
            }
            return "?";
        }

        @Override
        public String toSystem(CarePlanActivityStatus code) {
            return code.getSystem();
        }
    }

    public static enum CarePlanActivityStatus {
        NOTSTARTED,
        SCHEDULED,
        INPROGRESS,
        ONHOLD,
        COMPLETED,
        CANCELLED,
        NULL;


        public static CarePlanActivityStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-started".equals(codeString)) {
                return NOTSTARTED;
            }
            if ("scheduled".equals(codeString)) {
                return SCHEDULED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            throw new FHIRException("Unknown CarePlanActivityStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTSTARTED: {
                    return "not-started";
                }
                case SCHEDULED: {
                    return "scheduled";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTSTARTED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case SCHEDULED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTSTARTED: {
                    return "Activity is planned but no action has yet been taken.";
                }
                case SCHEDULED: {
                    return "Appointment or other booking has occurred but activity has not yet begun.";
                }
                case INPROGRESS: {
                    return "Activity has been started but is not yet complete.";
                }
                case ONHOLD: {
                    return "Activity was started but has temporarily ceased with an expectation of resumption at a future time.";
                }
                case COMPLETED: {
                    return "The activities have been completed (more or less) as planned.";
                }
                case CANCELLED: {
                    return "The activities have been ended prior to completion (perhaps even before they were started).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTSTARTED: {
                    return "Not Started";
                }
                case SCHEDULED: {
                    return "Scheduled";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CarePlanRelationshipEnumFactory
    implements EnumFactory<CarePlanRelationship> {
        @Override
        public CarePlanRelationship fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("includes".equals(codeString)) {
                return CarePlanRelationship.INCLUDES;
            }
            if ("replaces".equals(codeString)) {
                return CarePlanRelationship.REPLACES;
            }
            if ("fulfills".equals(codeString)) {
                return CarePlanRelationship.FULFILLS;
            }
            throw new IllegalArgumentException("Unknown CarePlanRelationship code '" + codeString + "'");
        }

        public Enumeration<CarePlanRelationship> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("includes".equals(codeString)) {
                return new Enumeration<CarePlanRelationship>(this, CarePlanRelationship.INCLUDES);
            }
            if ("replaces".equals(codeString)) {
                return new Enumeration<CarePlanRelationship>(this, CarePlanRelationship.REPLACES);
            }
            if ("fulfills".equals(codeString)) {
                return new Enumeration<CarePlanRelationship>(this, CarePlanRelationship.FULFILLS);
            }
            throw new FHIRException("Unknown CarePlanRelationship code '" + codeString + "'");
        }

        @Override
        public String toCode(CarePlanRelationship code) {
            if (code == CarePlanRelationship.NULL) {
                return null;
            }
            if (code == CarePlanRelationship.INCLUDES) {
                return "includes";
            }
            if (code == CarePlanRelationship.REPLACES) {
                return "replaces";
            }
            if (code == CarePlanRelationship.FULFILLS) {
                return "fulfills";
            }
            return "?";
        }

        @Override
        public String toSystem(CarePlanRelationship code) {
            return code.getSystem();
        }
    }

    public static enum CarePlanRelationship {
        INCLUDES,
        REPLACES,
        FULFILLS,
        NULL;


        public static CarePlanRelationship fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("includes".equals(codeString)) {
                return INCLUDES;
            }
            if ("replaces".equals(codeString)) {
                return REPLACES;
            }
            if ("fulfills".equals(codeString)) {
                return FULFILLS;
            }
            throw new FHIRException("Unknown CarePlanRelationship code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INCLUDES: {
                    return "includes";
                }
                case REPLACES: {
                    return "replaces";
                }
                case FULFILLS: {
                    return "fulfills";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INCLUDES: {
                    return "http://hl7.org/fhir/care-plan-relationship";
                }
                case REPLACES: {
                    return "http://hl7.org/fhir/care-plan-relationship";
                }
                case FULFILLS: {
                    return "http://hl7.org/fhir/care-plan-relationship";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INCLUDES: {
                    return "The referenced plan is considered to be part of this plan.";
                }
                case REPLACES: {
                    return "This plan takes the places of the referenced plan.";
                }
                case FULFILLS: {
                    return "This plan provides details about how to perform activities defined at a higher level by the referenced plan.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INCLUDES: {
                    return "Includes";
                }
                case REPLACES: {
                    return "Replaces";
                }
                case FULFILLS: {
                    return "Fulfills";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CarePlanStatusEnumFactory
    implements EnumFactory<CarePlanStatus> {
        @Override
        public CarePlanStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return CarePlanStatus.PROPOSED;
            }
            if ("draft".equals(codeString)) {
                return CarePlanStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return CarePlanStatus.ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return CarePlanStatus.COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CarePlanStatus.CANCELLED;
            }
            throw new IllegalArgumentException("Unknown CarePlanStatus code '" + codeString + "'");
        }

        public Enumeration<CarePlanStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.PROPOSED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.DRAFT);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.ACTIVE);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.COMPLETED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.CANCELLED);
            }
            throw new FHIRException("Unknown CarePlanStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CarePlanStatus code) {
            if (code == CarePlanStatus.NULL) {
                return null;
            }
            if (code == CarePlanStatus.PROPOSED) {
                return "proposed";
            }
            if (code == CarePlanStatus.DRAFT) {
                return "draft";
            }
            if (code == CarePlanStatus.ACTIVE) {
                return "active";
            }
            if (code == CarePlanStatus.COMPLETED) {
                return "completed";
            }
            if (code == CarePlanStatus.CANCELLED) {
                return "cancelled";
            }
            return "?";
        }

        @Override
        public String toSystem(CarePlanStatus code) {
            return code.getSystem();
        }
    }

    public static enum CarePlanStatus {
        PROPOSED,
        DRAFT,
        ACTIVE,
        COMPLETED,
        CANCELLED,
        NULL;


        public static CarePlanStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            throw new FHIRException("Unknown CarePlanStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case COMPLETED: {
                    return "completed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "The plan has been suggested but no commitment to it has yet been made.";
                }
                case DRAFT: {
                    return "The plan is in development or awaiting use but is not yet intended to be acted upon.";
                }
                case ACTIVE: {
                    return "The plan is intended to be followed and used as part of patient care.";
                }
                case COMPLETED: {
                    return "The plan is no longer in use and is not expected to be followed or used in patient care.";
                }
                case CANCELLED: {
                    return "The plan has been terminated prior to reaching completion (though it may have been replaced by a new plan).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case DRAFT: {
                    return "Pending";
                }
                case ACTIVE: {
                    return "Active";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

