/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Duration;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Medication;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Substance;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Protocol", profile="http://hl7.org/fhir/Profile/Protocol")
public class Protocol
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique Id for this particular protocol", formalDefinition="A unique identifier for the protocol instance.")
    protected List<Identifier> identifier;
    @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of protocol", formalDefinition="Name of protocol.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | testing | review | active | withdrawn | superseded", formalDefinition="The status of the protocol.")
    protected Enumeration<ProtocolStatus> status;
    @Child(name="type", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="condition | device | drug | study", formalDefinition="A code that classifies the general type of context to which these behavior definitions apply.  This is used for searching, sorting and display purposes.")
    protected Enumeration<ProtocolType> type;
    @Child(name="subject", type={Condition.class, Device.class, Medication.class}, order=4, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="What does protocol deal with?", formalDefinition="What does protocol deal with?")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="group", type={Group.class}, order=5, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="To whom does Protocol apply?", formalDefinition="To whom does Protocol apply?")
    protected Reference group;
    protected Group groupTarget;
    @Child(name="purpose", type={StringType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When is protocol to be used?", formalDefinition="When is protocol to be used?")
    protected StringType purpose;
    @Child(name="author", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who wrote protocol?", formalDefinition="Who wrote protocol?")
    protected Reference author;
    protected Organization authorTarget;
    @Child(name="step", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What's done as part of protocol", formalDefinition="What's done as part of protocol.")
    protected List<ProtocolStepComponent> step;
    private static final long serialVersionUID = -1458830869L;
    @SearchParamDefinition(name="subject", path="Protocol.subject", description="Protocols with specified subject", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Protocol:subject").toLocked();
    @SearchParamDefinition(name="identifier", path="Protocol.identifier", description="The unique id for a particular protocol", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public Protocol() {
    }

    public Protocol(Enumeration<ProtocolStatus> status, Enumeration<ProtocolType> type, StringType purpose) {
        this.status = status;
        this.type = type;
        this.purpose = purpose;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Protocol addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Protocol.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public Protocol setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public Protocol setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public Enumeration<ProtocolStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Protocol.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ProtocolStatus>(new ProtocolStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Protocol setStatusElement(Enumeration<ProtocolStatus> value) {
        this.status = value;
        return this;
    }

    public ProtocolStatus getStatus() {
        return this.status == null ? null : (ProtocolStatus)((Object)this.status.getValue());
    }

    public Protocol setStatus(ProtocolStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ProtocolStatus>(new ProtocolStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<ProtocolType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Protocol.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<ProtocolType>(new ProtocolTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Protocol setTypeElement(Enumeration<ProtocolType> value) {
        this.type = value;
        return this;
    }

    public ProtocolType getType() {
        return this.type == null ? null : (ProtocolType)((Object)this.type.getValue());
    }

    public Protocol setType(ProtocolType value) {
        if (this.type == null) {
            this.type = new Enumeration<ProtocolType>(new ProtocolTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Protocol.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Protocol setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Protocol setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getGroup() {
        if (this.group == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Protocol.group");
            }
            if (Configuration.doAutoCreate()) {
                this.group = new Reference();
            }
        }
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    public Protocol setGroup(Reference value) {
        this.group = value;
        return this;
    }

    public Group getGroupTarget() {
        if (this.groupTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Protocol.group");
            }
            if (Configuration.doAutoCreate()) {
                this.groupTarget = new Group();
            }
        }
        return this.groupTarget;
    }

    public Protocol setGroupTarget(Group value) {
        this.groupTarget = value;
        return this;
    }

    public StringType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Protocol.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new StringType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public Protocol setPurposeElement(StringType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public Protocol setPurpose(String value) {
        if (this.purpose == null) {
            this.purpose = new StringType();
        }
        this.purpose.setValue(value);
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Protocol.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Protocol setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Organization getAuthorTarget() {
        if (this.authorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Protocol.author");
            }
            if (Configuration.doAutoCreate()) {
                this.authorTarget = new Organization();
            }
        }
        return this.authorTarget;
    }

    public Protocol setAuthorTarget(Organization value) {
        this.authorTarget = value;
        return this;
    }

    public List<ProtocolStepComponent> getStep() {
        if (this.step == null) {
            this.step = new ArrayList<ProtocolStepComponent>();
        }
        return this.step;
    }

    public boolean hasStep() {
        if (this.step == null) {
            return false;
        }
        for (ProtocolStepComponent item : this.step) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProtocolStepComponent addStep() {
        ProtocolStepComponent t = new ProtocolStepComponent();
        if (this.step == null) {
            this.step = new ArrayList<ProtocolStepComponent>();
        }
        this.step.add(t);
        return t;
    }

    public Protocol addStep(ProtocolStepComponent t) {
        if (t == null) {
            return this;
        }
        if (this.step == null) {
            this.step = new ArrayList<ProtocolStepComponent>();
        }
        this.step.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier for the protocol instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("title", "string", "Name of protocol.", 0, Integer.MAX_VALUE, this.title));
        childrenList.add(new Property("status", "code", "The status of the protocol.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("type", "code", "A code that classifies the general type of context to which these behavior definitions apply.  This is used for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Condition|Device|Medication)", "What does protocol deal with?", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("group", "Reference(Group)", "To whom does Protocol apply?", 0, Integer.MAX_VALUE, this.group));
        childrenList.add(new Property("purpose", "string", "When is protocol to be used?", 0, Integer.MAX_VALUE, this.purpose));
        childrenList.add(new Property("author", "Reference(Organization)", "Who wrote protocol?", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property("step", "", "What's done as part of protocol.", 0, Integer.MAX_VALUE, this.step));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 98629247: {
                Base[] baseArray;
                if (this.group == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.group;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.purpose;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.author;
                }
                return baseArray;
            }
            case 3540684: {
                return this.step == null ? new Base[]{} : this.step.toArray(new Base[this.step.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 110371416: {
                this.title = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new ProtocolStatusEnumFactory().fromType(value);
                break;
            }
            case 3575610: {
                this.type = new ProtocolTypeEnumFactory().fromType(value);
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case 98629247: {
                this.group = this.castToReference(value);
                break;
            }
            case -220463842: {
                this.purpose = this.castToString(value);
                break;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                break;
            }
            case 3540684: {
                this.getStep().add((ProtocolStepComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("title")) {
            this.title = this.castToString(value);
        } else if (name.equals("status")) {
            this.status = new ProtocolStatusEnumFactory().fromType(value);
        } else if (name.equals("type")) {
            this.type = new ProtocolTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("group")) {
            this.group = this.castToReference(value);
        } else if (name.equals("purpose")) {
            this.purpose = this.castToString(value);
        } else if (name.equals("author")) {
            this.author = this.castToReference(value);
        } else if (name.equals("step")) {
            this.getStep().add((ProtocolStepComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 110371416: {
                throw new FHIRException("Cannot make property title as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 98629247: {
                return this.getGroup();
            }
            case -220463842: {
                throw new FHIRException("Cannot make property purpose as it is not a complex type");
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case 3540684: {
                return this.addStep();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a singleton property Protocol.title");
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property Protocol.status");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property Protocol.type");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("group")) {
            this.group = new Reference();
            return this.group;
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property Protocol.purpose");
        }
        if (name.equals("author")) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("step")) {
            return this.addStep();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Protocol";
    }

    @Override
    public Protocol copy() {
        Protocol dst = new Protocol();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.group = this.group == null ? null : this.group.copy();
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        Reference reference = dst.author = this.author == null ? null : this.author.copy();
        if (this.step != null) {
            dst.step = new ArrayList<ProtocolStepComponent>();
            for (ProtocolStepComponent protocolStepComponent : this.step) {
                dst.step.add(protocolStepComponent.copy());
            }
        }
        return dst;
    }

    protected Protocol typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Protocol)) {
            return false;
        }
        Protocol o = (Protocol)other;
        return Protocol.compareDeep(this.identifier, o.identifier, true) && Protocol.compareDeep(this.title, o.title, true) && Protocol.compareDeep(this.status, o.status, true) && Protocol.compareDeep(this.type, o.type, true) && Protocol.compareDeep(this.subject, o.subject, true) && Protocol.compareDeep(this.group, o.group, true) && Protocol.compareDeep(this.purpose, o.purpose, true) && Protocol.compareDeep(this.author, o.author, true) && Protocol.compareDeep(this.step, o.step, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Protocol)) {
            return false;
        }
        Protocol o = (Protocol)other;
        return Protocol.compareValues(this.title, o.title, true) && Protocol.compareValues(this.status, o.status, true) && Protocol.compareValues(this.type, o.type, true) && Protocol.compareValues(this.purpose, o.purpose, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.title != null && !this.title.isEmpty() || this.status != null && !this.status.isEmpty() || this.type != null && !this.type.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.group != null && !this.group.isEmpty() || this.purpose != null && !this.purpose.isEmpty() || this.author != null && !this.author.isEmpty() || this.step != null && !this.step.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Protocol;
    }

    @Block
    public static class ProtocolStepNextComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description of what happens next", formalDefinition="Description of what happens next.")
        protected StringType description;
        @Child(name="reference", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Id of following step", formalDefinition="Id of following step.")
        protected UriType reference;
        @Child(name="condition", type={ProtocolStepPreconditionComponent.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Condition in which next step is executed", formalDefinition="Condition in which next step is executed.")
        protected ProtocolStepPreconditionComponent condition;
        private static final long serialVersionUID = -1343883194L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepNextComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ProtocolStepNextComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ProtocolStepNextComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public UriType getReferenceElement() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepNextComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new UriType();
                }
            }
            return this.reference;
        }

        public boolean hasReferenceElement() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ProtocolStepNextComponent setReferenceElement(UriType value) {
            this.reference = value;
            return this;
        }

        public String getReference() {
            return this.reference == null ? null : (String)this.reference.getValue();
        }

        public ProtocolStepNextComponent setReference(String value) {
            if (Utilities.noString((String)value)) {
                this.reference = null;
            } else {
                if (this.reference == null) {
                    this.reference = new UriType();
                }
                this.reference.setValue(value);
            }
            return this;
        }

        public ProtocolStepPreconditionComponent getCondition() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepNextComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new ProtocolStepPreconditionComponent();
                }
            }
            return this.condition;
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public ProtocolStepNextComponent setCondition(ProtocolStepPreconditionComponent value) {
            this.condition = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("description", "string", "Description of what happens next.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("reference", "uri", "Id of following step.", 0, Integer.MAX_VALUE, this.reference));
            childrenList.add(new Property("condition", "@Protocol.step.precondition", "Condition in which next step is executed.", 0, Integer.MAX_VALUE, this.condition));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.condition;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -925155509: {
                    this.reference = this.castToUri(value);
                    break;
                }
                case -861311717: {
                    this.condition = (ProtocolStepPreconditionComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("reference")) {
                this.reference = this.castToUri(value);
            } else if (name.equals("condition")) {
                this.condition = (ProtocolStepPreconditionComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -925155509: {
                    throw new FHIRException("Cannot make property reference as it is not a complex type");
                }
                case -861311717: {
                    return this.getCondition();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.description");
            }
            if (name.equals("reference")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.reference");
            }
            if (name.equals("condition")) {
                this.condition = new ProtocolStepPreconditionComponent();
                return this.condition;
            }
            return super.addChild(name);
        }

        @Override
        public ProtocolStepNextComponent copy() {
            ProtocolStepNextComponent dst = new ProtocolStepNextComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.condition = this.condition == null ? null : this.condition.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepNextComponent)) {
                return false;
            }
            ProtocolStepNextComponent o = (ProtocolStepNextComponent)other;
            return ProtocolStepNextComponent.compareDeep(this.description, o.description, true) && ProtocolStepNextComponent.compareDeep(this.reference, o.reference, true) && ProtocolStepNextComponent.compareDeep(this.condition, o.condition, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepNextComponent)) {
                return false;
            }
            ProtocolStepNextComponent o = (ProtocolStepNextComponent)other;
            return ProtocolStepNextComponent.compareValues(this.description, o.description, true) && ProtocolStepNextComponent.compareValues(this.reference, o.reference, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.description != null && !this.description.isEmpty() || this.reference != null && !this.reference.isEmpty() || this.condition != null && !this.condition.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Protocol.step.next";
        }
    }

    @Block
    public static class ProtocolStepActivityDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="diet | drug | encounter | observation +", formalDefinition="High-level categorization of the type of activity.")
        protected Enumeration<ActivityDefinitionCategory> category;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Detail type of activity", formalDefinition="Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.")
        protected CodeableConcept code;
        @Child(name="timing", type={CodeableConcept.class, Timing.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When activity is to occur", formalDefinition="The period, timing or frequency upon which the described activity is to occur.")
        protected Type timing;
        @Child(name="location", type={Location.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.")
        protected Reference location;
        protected Location locationTarget;
        @Child(name="performer", type={Practitioner.class, Organization.class, RelatedPerson.class, Patient.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Who's responsible?", formalDefinition="Identifies who's expected to be involved in the activity.")
        protected List<Reference> performer;
        protected List<Resource> performerTarget;
        @Child(name="product", type={Medication.class, Substance.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What's administered/supplied", formalDefinition="Identifies the food, drug or other product being consumed or supplied in the activity.")
        protected Reference product;
        protected Resource productTarget;
        @Child(name="quantity", type={SimpleQuantity.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How much is administered/consumed/supplied", formalDefinition="Identifies the quantity expected to be consumed at once (per dose, per meal, etc.).")
        protected SimpleQuantity quantity;
        @Child(name="description", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Extra info on activity occurrence", formalDefinition="This provides a textual description of constraints on the activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.")
        protected StringType description;
        private static final long serialVersionUID = 8207475L;

        public Enumeration<ActivityDefinitionCategory> getCategoryElement() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityDetailComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Enumeration<ActivityDefinitionCategory>(new ActivityDefinitionCategoryEnumFactory());
                }
            }
            return this.category;
        }

        public boolean hasCategoryElement() {
            return this.category != null && !this.category.isEmpty();
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ProtocolStepActivityDetailComponent setCategoryElement(Enumeration<ActivityDefinitionCategory> value) {
            this.category = value;
            return this;
        }

        public ActivityDefinitionCategory getCategory() {
            return this.category == null ? null : (ActivityDefinitionCategory)((Object)this.category.getValue());
        }

        public ProtocolStepActivityDetailComponent setCategory(ActivityDefinitionCategory value) {
            if (value == null) {
                this.category = null;
            } else {
                if (this.category == null) {
                    this.category = new Enumeration<ActivityDefinitionCategory>(new ActivityDefinitionCategoryEnumFactory());
                }
                this.category.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityDetailComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ProtocolStepActivityDetailComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Type getTiming() {
            return this.timing;
        }

        public CodeableConcept getTimingCodeableConcept() throws FHIRException {
            if (!(this.timing instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.timing;
        }

        public boolean hasTimingCodeableConcept() {
            return this.timing instanceof CodeableConcept;
        }

        public Timing getTimingTiming() throws FHIRException {
            if (!(this.timing instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Timing)this.timing;
        }

        public boolean hasTimingTiming() {
            return this.timing instanceof Timing;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public ProtocolStepActivityDetailComponent setTiming(Type value) {
            this.timing = value;
            return this;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityDetailComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public ProtocolStepActivityDetailComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Location getLocationTarget() {
            if (this.locationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityDetailComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.locationTarget = new Location();
                }
            }
            return this.locationTarget;
        }

        public ProtocolStepActivityDetailComponent setLocationTarget(Location value) {
            this.locationTarget = value;
            return this;
        }

        public List<Reference> getPerformer() {
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            return this.performer;
        }

        public boolean hasPerformer() {
            if (this.performer == null) {
                return false;
            }
            for (Reference item : this.performer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addPerformer() {
            Reference t = new Reference();
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return t;
        }

        public ProtocolStepActivityDetailComponent addPerformer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return this;
        }

        public List<Resource> getPerformerTarget() {
            if (this.performerTarget == null) {
                this.performerTarget = new ArrayList<Resource>();
            }
            return this.performerTarget;
        }

        public Reference getProduct() {
            if (this.product == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityDetailComponent.product");
                }
                if (Configuration.doAutoCreate()) {
                    this.product = new Reference();
                }
            }
            return this.product;
        }

        public boolean hasProduct() {
            return this.product != null && !this.product.isEmpty();
        }

        public ProtocolStepActivityDetailComponent setProduct(Reference value) {
            this.product = value;
            return this;
        }

        public Resource getProductTarget() {
            return this.productTarget;
        }

        public ProtocolStepActivityDetailComponent setProductTarget(Resource value) {
            this.productTarget = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ProtocolStepActivityDetailComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityDetailComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ProtocolStepActivityDetailComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ProtocolStepActivityDetailComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("category", "code", "High-level categorization of the type of activity.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property("code", "CodeableConcept", "Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("timing[x]", "CodeableConcept|Timing", "The period, timing or frequency upon which the described activity is to occur.", 0, Integer.MAX_VALUE, this.timing));
            childrenList.add(new Property("location", "Reference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, Integer.MAX_VALUE, this.location));
            childrenList.add(new Property("performer", "Reference(Practitioner|Organization|RelatedPerson|Patient)", "Identifies who's expected to be involved in the activity.", 0, Integer.MAX_VALUE, this.performer));
            childrenList.add(new Property("product", "Reference(Medication|Substance)", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, Integer.MAX_VALUE, this.product));
            childrenList.add(new Property("quantity", "SimpleQuantity", "Identifies the quantity expected to be consumed at once (per dose, per meal, etc.).", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("description", "string", "This provides a textual description of constraints on the activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.", 0, Integer.MAX_VALUE, this.description));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.timing;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.location;
                    }
                    return baseArray;
                }
                case 481140686: {
                    return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
                }
                case -309474065: {
                    Base[] baseArray;
                    if (this.product == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.product;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = new ActivityDefinitionCategoryEnumFactory().fromType(value);
                    break;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    break;
                }
                case -873664438: {
                    this.timing = (Type)value;
                    break;
                }
                case 1901043637: {
                    this.location = this.castToReference(value);
                    break;
                }
                case 481140686: {
                    this.getPerformer().add(this.castToReference(value));
                    break;
                }
                case -309474065: {
                    this.product = this.castToReference(value);
                    break;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = new ActivityDefinitionCategoryEnumFactory().fromType(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("timing[x]")) {
                this.timing = (Type)value;
            } else if (name.equals("location")) {
                this.location = this.castToReference(value);
            } else if (name.equals("performer")) {
                this.getPerformer().add(this.castToReference(value));
            } else if (name.equals("product")) {
                this.product = this.castToReference(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    throw new FHIRException("Cannot make property category as it is not a complex type");
                }
                case 3059181: {
                    return this.getCode();
                }
                case 164632566: {
                    return this.getTiming();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case 481140686: {
                    return this.addPerformer();
                }
                case -309474065: {
                    return this.getProduct();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.category");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("timingCodeableConcept")) {
                this.timing = new CodeableConcept();
                return this.timing;
            }
            if (name.equals("timingTiming")) {
                this.timing = new Timing();
                return this.timing;
            }
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("performer")) {
                return this.addPerformer();
            }
            if (name.equals("product")) {
                this.product = new Reference();
                return this.product;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.description");
            }
            return super.addChild(name);
        }

        @Override
        public ProtocolStepActivityDetailComponent copy() {
            ProtocolStepActivityDetailComponent dst = new ProtocolStepActivityDetailComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.timing = this.timing == null ? null : this.timing.copy();
            Reference reference = dst.location = this.location == null ? null : this.location.copy();
            if (this.performer != null) {
                dst.performer = new ArrayList<Reference>();
                for (Reference i : this.performer) {
                    dst.performer.add(i.copy());
                }
            }
            dst.product = this.product == null ? null : this.product.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.description = this.description == null ? null : this.description.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepActivityDetailComponent)) {
                return false;
            }
            ProtocolStepActivityDetailComponent o = (ProtocolStepActivityDetailComponent)other;
            return ProtocolStepActivityDetailComponent.compareDeep(this.category, o.category, true) && ProtocolStepActivityDetailComponent.compareDeep(this.code, o.code, true) && ProtocolStepActivityDetailComponent.compareDeep(this.timing, o.timing, true) && ProtocolStepActivityDetailComponent.compareDeep(this.location, o.location, true) && ProtocolStepActivityDetailComponent.compareDeep(this.performer, o.performer, true) && ProtocolStepActivityDetailComponent.compareDeep(this.product, o.product, true) && ProtocolStepActivityDetailComponent.compareDeep(this.quantity, o.quantity, true) && ProtocolStepActivityDetailComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepActivityDetailComponent)) {
                return false;
            }
            ProtocolStepActivityDetailComponent o = (ProtocolStepActivityDetailComponent)other;
            return ProtocolStepActivityDetailComponent.compareValues(this.category, o.category, true) && ProtocolStepActivityDetailComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.category != null && !this.category.isEmpty() || this.code != null && !this.code.isEmpty() || this.timing != null && !this.timing.isEmpty() || this.location != null && !this.location.isEmpty() || this.performer != null && !this.performer.isEmpty() || this.product != null && !this.product.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.description != null && !this.description.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Protocol.step.activity.detail";
        }
    }

    @Block
    public static class ProtocolStepActivityComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={IntegerType.class}, order=1, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="Order of occurrence", formalDefinition="Order of occurrence.")
        protected IntegerType sequence;
        @Child(name="activity", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Component activity", formalDefinition="Component activity.")
        protected UriType activity;
        private static final long serialVersionUID = -856295616L;

        public ProtocolStepActivityComponentComponent() {
        }

        public ProtocolStepActivityComponentComponent(UriType activity) {
            this.activity = activity;
        }

        public IntegerType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityComponentComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new IntegerType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ProtocolStepActivityComponentComponent setSequenceElement(IntegerType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ProtocolStepActivityComponentComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new IntegerType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public UriType getActivityElement() {
            if (this.activity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityComponentComponent.activity");
                }
                if (Configuration.doAutoCreate()) {
                    this.activity = new UriType();
                }
            }
            return this.activity;
        }

        public boolean hasActivityElement() {
            return this.activity != null && !this.activity.isEmpty();
        }

        public boolean hasActivity() {
            return this.activity != null && !this.activity.isEmpty();
        }

        public ProtocolStepActivityComponentComponent setActivityElement(UriType value) {
            this.activity = value;
            return this;
        }

        public String getActivity() {
            return this.activity == null ? null : (String)this.activity.getValue();
        }

        public ProtocolStepActivityComponentComponent setActivity(String value) {
            if (this.activity == null) {
                this.activity = new UriType();
            }
            this.activity.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "integer", "Order of occurrence.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("activity", "uri", "Component activity.", 0, Integer.MAX_VALUE, this.activity));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case -1655966961: {
                    Base[] baseArray;
                    if (this.activity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.activity;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToInteger(value);
                    break;
                }
                case -1655966961: {
                    this.activity = this.castToUri(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToInteger(value);
            } else if (name.equals("activity")) {
                this.activity = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    throw new FHIRException("Cannot make property sequence as it is not a complex type");
                }
                case -1655966961: {
                    throw new FHIRException("Cannot make property activity as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.sequence");
            }
            if (name.equals("activity")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.activity");
            }
            return super.addChild(name);
        }

        @Override
        public ProtocolStepActivityComponentComponent copy() {
            ProtocolStepActivityComponentComponent dst = new ProtocolStepActivityComponentComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.activity = this.activity == null ? null : this.activity.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepActivityComponentComponent)) {
                return false;
            }
            ProtocolStepActivityComponentComponent o = (ProtocolStepActivityComponentComponent)other;
            return ProtocolStepActivityComponentComponent.compareDeep(this.sequence, o.sequence, true) && ProtocolStepActivityComponentComponent.compareDeep(this.activity, o.activity, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepActivityComponentComponent)) {
                return false;
            }
            ProtocolStepActivityComponentComponent o = (ProtocolStepActivityComponentComponent)other;
            return ProtocolStepActivityComponentComponent.compareValues(this.sequence, o.sequence, true) && ProtocolStepActivityComponentComponent.compareValues(this.activity, o.activity, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.activity != null && !this.activity.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Protocol.step.activity.component";
        }
    }

    @Block
    public static class ProtocolStepActivityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="alternative", type={UriType.class}, order=1, min=0, max=-1, modifier=true, summary=true)
        @Description(shortDefinition="What can be done instead?", formalDefinition="What can be done instead?")
        protected List<UriType> alternative;
        @Child(name="component", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Activities that are part of this activity", formalDefinition="Activities that are part of this activity.")
        protected List<ProtocolStepActivityComponentComponent> component;
        @Child(name="following", type={UriType.class}, order=3, min=0, max=-1, modifier=true, summary=true)
        @Description(shortDefinition="What happens next", formalDefinition="What happens next.")
        protected List<UriType> following;
        @Child(name="wait", type={Duration.class}, order=4, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="Pause before start", formalDefinition="Indicates the length of time to wait between the conditions being satisfied for the activity to start and the actual start of the activity.")
        protected Duration wait;
        @Child(name="detail", type={}, order=5, min=1, max=1, modifier=true, summary=true)
        @Description(shortDefinition="Details of activity", formalDefinition="Information about the nature of the activity, including type, timing and other qualifiers.")
        protected ProtocolStepActivityDetailComponent detail;
        private static final long serialVersionUID = 1430131373L;

        public ProtocolStepActivityComponent() {
        }

        public ProtocolStepActivityComponent(ProtocolStepActivityDetailComponent detail) {
            this.detail = detail;
        }

        public List<UriType> getAlternative() {
            if (this.alternative == null) {
                this.alternative = new ArrayList<UriType>();
            }
            return this.alternative;
        }

        public boolean hasAlternative() {
            if (this.alternative == null) {
                return false;
            }
            for (UriType item : this.alternative) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addAlternativeElement() {
            UriType t = new UriType();
            if (this.alternative == null) {
                this.alternative = new ArrayList<UriType>();
            }
            this.alternative.add(t);
            return t;
        }

        public ProtocolStepActivityComponent addAlternative(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.alternative == null) {
                this.alternative = new ArrayList<UriType>();
            }
            this.alternative.add(t);
            return this;
        }

        public boolean hasAlternative(String value) {
            if (this.alternative == null) {
                return false;
            }
            for (UriType v : this.alternative) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<ProtocolStepActivityComponentComponent> getComponent() {
            if (this.component == null) {
                this.component = new ArrayList<ProtocolStepActivityComponentComponent>();
            }
            return this.component;
        }

        public boolean hasComponent() {
            if (this.component == null) {
                return false;
            }
            for (ProtocolStepActivityComponentComponent item : this.component) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProtocolStepActivityComponentComponent addComponent() {
            ProtocolStepActivityComponentComponent t = new ProtocolStepActivityComponentComponent();
            if (this.component == null) {
                this.component = new ArrayList<ProtocolStepActivityComponentComponent>();
            }
            this.component.add(t);
            return t;
        }

        public ProtocolStepActivityComponent addComponent(ProtocolStepActivityComponentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.component == null) {
                this.component = new ArrayList<ProtocolStepActivityComponentComponent>();
            }
            this.component.add(t);
            return this;
        }

        public List<UriType> getFollowing() {
            if (this.following == null) {
                this.following = new ArrayList<UriType>();
            }
            return this.following;
        }

        public boolean hasFollowing() {
            if (this.following == null) {
                return false;
            }
            for (UriType item : this.following) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addFollowingElement() {
            UriType t = new UriType();
            if (this.following == null) {
                this.following = new ArrayList<UriType>();
            }
            this.following.add(t);
            return t;
        }

        public ProtocolStepActivityComponent addFollowing(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.following == null) {
                this.following = new ArrayList<UriType>();
            }
            this.following.add(t);
            return this;
        }

        public boolean hasFollowing(String value) {
            if (this.following == null) {
                return false;
            }
            for (UriType v : this.following) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Duration getWait() {
            if (this.wait == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityComponent.wait");
                }
                if (Configuration.doAutoCreate()) {
                    this.wait = new Duration();
                }
            }
            return this.wait;
        }

        public boolean hasWait() {
            return this.wait != null && !this.wait.isEmpty();
        }

        public ProtocolStepActivityComponent setWait(Duration value) {
            this.wait = value;
            return this;
        }

        public ProtocolStepActivityDetailComponent getDetail() {
            if (this.detail == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepActivityComponent.detail");
                }
                if (Configuration.doAutoCreate()) {
                    this.detail = new ProtocolStepActivityDetailComponent();
                }
            }
            return this.detail;
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public ProtocolStepActivityComponent setDetail(ProtocolStepActivityDetailComponent value) {
            this.detail = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("alternative", "uri", "What can be done instead?", 0, Integer.MAX_VALUE, this.alternative));
            childrenList.add(new Property("component", "", "Activities that are part of this activity.", 0, Integer.MAX_VALUE, this.component));
            childrenList.add(new Property("following", "uri", "What happens next.", 0, Integer.MAX_VALUE, this.following));
            childrenList.add(new Property("wait", "Duration", "Indicates the length of time to wait between the conditions being satisfied for the activity to start and the actual start of the activity.", 0, Integer.MAX_VALUE, this.wait));
            childrenList.add(new Property("detail", "", "Information about the nature of the activity, including type, timing and other qualifiers.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -196794451: {
                    return this.alternative == null ? new Base[]{} : this.alternative.toArray(new Base[this.alternative.size()]);
                }
                case -1399907075: {
                    return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
                }
                case 765915793: {
                    return this.following == null ? new Base[]{} : this.following.toArray(new Base[this.following.size()]);
                }
                case 3641717: {
                    Base[] baseArray;
                    if (this.wait == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.wait;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detail;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -196794451: {
                    this.getAlternative().add(this.castToUri(value));
                    break;
                }
                case -1399907075: {
                    this.getComponent().add((ProtocolStepActivityComponentComponent)value);
                    break;
                }
                case 765915793: {
                    this.getFollowing().add(this.castToUri(value));
                    break;
                }
                case 3641717: {
                    this.wait = this.castToDuration(value);
                    break;
                }
                case -1335224239: {
                    this.detail = (ProtocolStepActivityDetailComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("alternative")) {
                this.getAlternative().add(this.castToUri(value));
            } else if (name.equals("component")) {
                this.getComponent().add((ProtocolStepActivityComponentComponent)value);
            } else if (name.equals("following")) {
                this.getFollowing().add(this.castToUri(value));
            } else if (name.equals("wait")) {
                this.wait = this.castToDuration(value);
            } else if (name.equals("detail")) {
                this.detail = (ProtocolStepActivityDetailComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -196794451: {
                    throw new FHIRException("Cannot make property alternative as it is not a complex type");
                }
                case -1399907075: {
                    return this.addComponent();
                }
                case 765915793: {
                    throw new FHIRException("Cannot make property following as it is not a complex type");
                }
                case 3641717: {
                    return this.getWait();
                }
                case -1335224239: {
                    return this.getDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("alternative")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.alternative");
            }
            if (name.equals("component")) {
                return this.addComponent();
            }
            if (name.equals("following")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.following");
            }
            if (name.equals("wait")) {
                this.wait = new Duration();
                return this.wait;
            }
            if (name.equals("detail")) {
                this.detail = new ProtocolStepActivityDetailComponent();
                return this.detail;
            }
            return super.addChild(name);
        }

        @Override
        public ProtocolStepActivityComponent copy() {
            ProtocolStepActivityComponent dst = new ProtocolStepActivityComponent();
            this.copyValues(dst);
            if (this.alternative != null) {
                dst.alternative = new ArrayList<UriType>();
                for (UriType uriType : this.alternative) {
                    dst.alternative.add(uriType.copy());
                }
            }
            if (this.component != null) {
                dst.component = new ArrayList<ProtocolStepActivityComponentComponent>();
                for (ProtocolStepActivityComponentComponent protocolStepActivityComponentComponent : this.component) {
                    dst.component.add(protocolStepActivityComponentComponent.copy());
                }
            }
            if (this.following != null) {
                dst.following = new ArrayList<UriType>();
                for (UriType uriType : this.following) {
                    dst.following.add(uriType.copy());
                }
            }
            dst.wait = this.wait == null ? null : this.wait.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepActivityComponent)) {
                return false;
            }
            ProtocolStepActivityComponent o = (ProtocolStepActivityComponent)other;
            return ProtocolStepActivityComponent.compareDeep(this.alternative, o.alternative, true) && ProtocolStepActivityComponent.compareDeep(this.component, o.component, true) && ProtocolStepActivityComponent.compareDeep(this.following, o.following, true) && ProtocolStepActivityComponent.compareDeep(this.wait, o.wait, true) && ProtocolStepActivityComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepActivityComponent)) {
                return false;
            }
            ProtocolStepActivityComponent o = (ProtocolStepActivityComponent)other;
            return ProtocolStepActivityComponent.compareValues(this.alternative, o.alternative, true) && ProtocolStepActivityComponent.compareValues(this.following, o.following, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.alternative != null && !this.alternative.isEmpty() || this.component != null && !this.component.isEmpty() || this.following != null && !this.following.isEmpty() || this.wait != null && !this.wait.isEmpty() || this.detail != null && !this.detail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Protocol.step.activity";
        }
    }

    @Block
    public static class ProtocolStepPreconditionConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Observation / test / assertion", formalDefinition="The type of observation, test or other assertion being evaluated by the condition.")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, BooleanType.class, SimpleQuantity.class, Range.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Value needed to satisfy condition", formalDefinition="Indicates what value the observation/test/assertion must have in order for the condition to be considered to be satisfied.")
        protected Type value;
        private static final long serialVersionUID = -491121170L;

        public ProtocolStepPreconditionConditionComponent() {
        }

        public ProtocolStepPreconditionConditionComponent(CodeableConcept type, Type value) {
            this.type = type;
            this.value = value;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepPreconditionConditionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProtocolStepPreconditionConditionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this.value instanceof CodeableConcept;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public SimpleQuantity getValueQuantity() throws FHIRException {
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SimpleQuantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this.value instanceof Range;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ProtocolStepPreconditionConditionComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "CodeableConcept", "The type of observation, test or other assertion being evaluated by the condition.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("value[x]", "CodeableConcept|boolean|SimpleQuantity|Range", "Indicates what value the observation/test/assertion must have in order for the condition to be considered to be satisfied.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    break;
                }
                case 111972721: {
                    this.value = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueSimpleQuantity")) {
                this.value = new SimpleQuantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ProtocolStepPreconditionConditionComponent copy() {
            ProtocolStepPreconditionConditionComponent dst = new ProtocolStepPreconditionConditionComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepPreconditionConditionComponent)) {
                return false;
            }
            ProtocolStepPreconditionConditionComponent o = (ProtocolStepPreconditionConditionComponent)other;
            return ProtocolStepPreconditionConditionComponent.compareDeep(this.type, o.type, true) && ProtocolStepPreconditionConditionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepPreconditionConditionComponent)) {
                return false;
            }
            ProtocolStepPreconditionConditionComponent o = (ProtocolStepPreconditionConditionComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Protocol.step.precondition.condition";
        }
    }

    @Block
    public static class ProtocolStepPreconditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description of condition", formalDefinition="Human-readable description of the condition.")
        protected StringType description;
        @Child(name="condition", type={}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Condition evaluated", formalDefinition="Defines the name/value pair that must hold for the condition to be met.")
        protected ProtocolStepPreconditionConditionComponent condition;
        @Child(name="intersection", type={ProtocolStepPreconditionComponent.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="And conditions", formalDefinition="Lists a set of conditions that must all be met.")
        protected List<ProtocolStepPreconditionComponent> intersection;
        @Child(name="union", type={ProtocolStepPreconditionComponent.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Or conditions", formalDefinition="Lists alternative conditions, at least one of must be met.")
        protected List<ProtocolStepPreconditionComponent> union;
        @Child(name="exclude", type={ProtocolStepPreconditionComponent.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Not conditions", formalDefinition="Lists conditions of which none must be met.")
        protected List<ProtocolStepPreconditionComponent> exclude;
        private static final long serialVersionUID = -1469954145L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepPreconditionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ProtocolStepPreconditionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ProtocolStepPreconditionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public ProtocolStepPreconditionConditionComponent getCondition() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepPreconditionComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new ProtocolStepPreconditionConditionComponent();
                }
            }
            return this.condition;
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public ProtocolStepPreconditionComponent setCondition(ProtocolStepPreconditionConditionComponent value) {
            this.condition = value;
            return this;
        }

        public List<ProtocolStepPreconditionComponent> getIntersection() {
            if (this.intersection == null) {
                this.intersection = new ArrayList<ProtocolStepPreconditionComponent>();
            }
            return this.intersection;
        }

        public boolean hasIntersection() {
            if (this.intersection == null) {
                return false;
            }
            for (ProtocolStepPreconditionComponent item : this.intersection) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProtocolStepPreconditionComponent addIntersection() {
            ProtocolStepPreconditionComponent t = new ProtocolStepPreconditionComponent();
            if (this.intersection == null) {
                this.intersection = new ArrayList<ProtocolStepPreconditionComponent>();
            }
            this.intersection.add(t);
            return t;
        }

        public ProtocolStepPreconditionComponent addIntersection(ProtocolStepPreconditionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.intersection == null) {
                this.intersection = new ArrayList<ProtocolStepPreconditionComponent>();
            }
            this.intersection.add(t);
            return this;
        }

        public List<ProtocolStepPreconditionComponent> getUnion() {
            if (this.union == null) {
                this.union = new ArrayList<ProtocolStepPreconditionComponent>();
            }
            return this.union;
        }

        public boolean hasUnion() {
            if (this.union == null) {
                return false;
            }
            for (ProtocolStepPreconditionComponent item : this.union) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProtocolStepPreconditionComponent addUnion() {
            ProtocolStepPreconditionComponent t = new ProtocolStepPreconditionComponent();
            if (this.union == null) {
                this.union = new ArrayList<ProtocolStepPreconditionComponent>();
            }
            this.union.add(t);
            return t;
        }

        public ProtocolStepPreconditionComponent addUnion(ProtocolStepPreconditionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.union == null) {
                this.union = new ArrayList<ProtocolStepPreconditionComponent>();
            }
            this.union.add(t);
            return this;
        }

        public List<ProtocolStepPreconditionComponent> getExclude() {
            if (this.exclude == null) {
                this.exclude = new ArrayList<ProtocolStepPreconditionComponent>();
            }
            return this.exclude;
        }

        public boolean hasExclude() {
            if (this.exclude == null) {
                return false;
            }
            for (ProtocolStepPreconditionComponent item : this.exclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProtocolStepPreconditionComponent addExclude() {
            ProtocolStepPreconditionComponent t = new ProtocolStepPreconditionComponent();
            if (this.exclude == null) {
                this.exclude = new ArrayList<ProtocolStepPreconditionComponent>();
            }
            this.exclude.add(t);
            return t;
        }

        public ProtocolStepPreconditionComponent addExclude(ProtocolStepPreconditionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.exclude == null) {
                this.exclude = new ArrayList<ProtocolStepPreconditionComponent>();
            }
            this.exclude.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("description", "string", "Human-readable description of the condition.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("condition", "", "Defines the name/value pair that must hold for the condition to be met.", 0, Integer.MAX_VALUE, this.condition));
            childrenList.add(new Property("intersection", "@Protocol.step.precondition", "Lists a set of conditions that must all be met.", 0, Integer.MAX_VALUE, this.intersection));
            childrenList.add(new Property("union", "@Protocol.step.precondition", "Lists alternative conditions, at least one of must be met.", 0, Integer.MAX_VALUE, this.union));
            childrenList.add(new Property("exclude", "@Protocol.step.precondition", "Lists conditions of which none must be met.", 0, Integer.MAX_VALUE, this.exclude));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.condition;
                    }
                    return baseArray;
                }
                case 169749129: {
                    return this.intersection == null ? new Base[]{} : this.intersection.toArray(new Base[this.intersection.size()]);
                }
                case 111433423: {
                    return this.union == null ? new Base[]{} : this.union.toArray(new Base[this.union.size()]);
                }
                case -1321148966: {
                    return this.exclude == null ? new Base[]{} : this.exclude.toArray(new Base[this.exclude.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -861311717: {
                    this.condition = (ProtocolStepPreconditionConditionComponent)value;
                    break;
                }
                case 169749129: {
                    this.getIntersection().add((ProtocolStepPreconditionComponent)value);
                    break;
                }
                case 111433423: {
                    this.getUnion().add((ProtocolStepPreconditionComponent)value);
                    break;
                }
                case -1321148966: {
                    this.getExclude().add((ProtocolStepPreconditionComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("condition")) {
                this.condition = (ProtocolStepPreconditionConditionComponent)value;
            } else if (name.equals("intersection")) {
                this.getIntersection().add((ProtocolStepPreconditionComponent)value);
            } else if (name.equals("union")) {
                this.getUnion().add((ProtocolStepPreconditionComponent)value);
            } else if (name.equals("exclude")) {
                this.getExclude().add((ProtocolStepPreconditionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -861311717: {
                    return this.getCondition();
                }
                case 169749129: {
                    return this.addIntersection();
                }
                case 111433423: {
                    return this.addUnion();
                }
                case -1321148966: {
                    return this.addExclude();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.description");
            }
            if (name.equals("condition")) {
                this.condition = new ProtocolStepPreconditionConditionComponent();
                return this.condition;
            }
            if (name.equals("intersection")) {
                return this.addIntersection();
            }
            if (name.equals("union")) {
                return this.addUnion();
            }
            if (name.equals("exclude")) {
                return this.addExclude();
            }
            return super.addChild(name);
        }

        @Override
        public ProtocolStepPreconditionComponent copy() {
            ProtocolStepPreconditionComponent dst = new ProtocolStepPreconditionComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            ProtocolStepPreconditionConditionComponent protocolStepPreconditionConditionComponent = dst.condition = this.condition == null ? null : this.condition.copy();
            if (this.intersection != null) {
                dst.intersection = new ArrayList<ProtocolStepPreconditionComponent>();
                for (ProtocolStepPreconditionComponent i : this.intersection) {
                    dst.intersection.add(i.copy());
                }
            }
            if (this.union != null) {
                dst.union = new ArrayList<ProtocolStepPreconditionComponent>();
                for (ProtocolStepPreconditionComponent i : this.union) {
                    dst.union.add(i.copy());
                }
            }
            if (this.exclude != null) {
                dst.exclude = new ArrayList<ProtocolStepPreconditionComponent>();
                for (ProtocolStepPreconditionComponent i : this.exclude) {
                    dst.exclude.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepPreconditionComponent)) {
                return false;
            }
            ProtocolStepPreconditionComponent o = (ProtocolStepPreconditionComponent)other;
            return ProtocolStepPreconditionComponent.compareDeep(this.description, o.description, true) && ProtocolStepPreconditionComponent.compareDeep(this.condition, o.condition, true) && ProtocolStepPreconditionComponent.compareDeep(this.intersection, o.intersection, true) && ProtocolStepPreconditionComponent.compareDeep(this.union, o.union, true) && ProtocolStepPreconditionComponent.compareDeep(this.exclude, o.exclude, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepPreconditionComponent)) {
                return false;
            }
            ProtocolStepPreconditionComponent o = (ProtocolStepPreconditionComponent)other;
            return ProtocolStepPreconditionComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.description != null && !this.description.isEmpty() || this.condition != null && !this.condition.isEmpty() || this.intersection != null && !this.intersection.isEmpty() || this.union != null && !this.union.isEmpty() || this.exclude != null && !this.exclude.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Protocol.step.precondition";
        }
    }

    @Block
    public static class ProtocolStepComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Label for step", formalDefinition="Label for step.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human description of activity", formalDefinition="Human description of activity.")
        protected StringType description;
        @Child(name="duration", type={Duration.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How long does step last?", formalDefinition="How long does step last?")
        protected Duration duration;
        @Child(name="precondition", type={}, order=4, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="Rules prior to execution", formalDefinition="Rules prior to execution.")
        protected ProtocolStepPreconditionComponent precondition;
        @Child(name="exit", type={ProtocolStepPreconditionComponent.class}, order=5, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="Rules prior to completion", formalDefinition="Indicates the conditions that must be met for activities that are part of this time point to terminate.")
        protected ProtocolStepPreconditionComponent exit;
        @Child(name="firstActivity", type={UriType.class}, order=6, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="First activity within timepoint", formalDefinition="First activity within timepoint.")
        protected UriType firstActivity;
        @Child(name="activity", type={}, order=7, min=0, max=-1, modifier=true, summary=true)
        @Description(shortDefinition="Activities that occur within timepoint", formalDefinition="Activities that occur within timepoint.")
        protected List<ProtocolStepActivityComponent> activity;
        @Child(name="next", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="What happens next?", formalDefinition="What happens next?")
        protected List<ProtocolStepNextComponent> next;
        private static final long serialVersionUID = 626452062L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ProtocolStepComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ProtocolStepComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ProtocolStepComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ProtocolStepComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Duration getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Duration();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public ProtocolStepComponent setDuration(Duration value) {
            this.duration = value;
            return this;
        }

        public ProtocolStepPreconditionComponent getPrecondition() {
            if (this.precondition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepComponent.precondition");
                }
                if (Configuration.doAutoCreate()) {
                    this.precondition = new ProtocolStepPreconditionComponent();
                }
            }
            return this.precondition;
        }

        public boolean hasPrecondition() {
            return this.precondition != null && !this.precondition.isEmpty();
        }

        public ProtocolStepComponent setPrecondition(ProtocolStepPreconditionComponent value) {
            this.precondition = value;
            return this;
        }

        public ProtocolStepPreconditionComponent getExit() {
            if (this.exit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepComponent.exit");
                }
                if (Configuration.doAutoCreate()) {
                    this.exit = new ProtocolStepPreconditionComponent();
                }
            }
            return this.exit;
        }

        public boolean hasExit() {
            return this.exit != null && !this.exit.isEmpty();
        }

        public ProtocolStepComponent setExit(ProtocolStepPreconditionComponent value) {
            this.exit = value;
            return this;
        }

        public UriType getFirstActivityElement() {
            if (this.firstActivity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProtocolStepComponent.firstActivity");
                }
                if (Configuration.doAutoCreate()) {
                    this.firstActivity = new UriType();
                }
            }
            return this.firstActivity;
        }

        public boolean hasFirstActivityElement() {
            return this.firstActivity != null && !this.firstActivity.isEmpty();
        }

        public boolean hasFirstActivity() {
            return this.firstActivity != null && !this.firstActivity.isEmpty();
        }

        public ProtocolStepComponent setFirstActivityElement(UriType value) {
            this.firstActivity = value;
            return this;
        }

        public String getFirstActivity() {
            return this.firstActivity == null ? null : (String)this.firstActivity.getValue();
        }

        public ProtocolStepComponent setFirstActivity(String value) {
            if (Utilities.noString((String)value)) {
                this.firstActivity = null;
            } else {
                if (this.firstActivity == null) {
                    this.firstActivity = new UriType();
                }
                this.firstActivity.setValue(value);
            }
            return this;
        }

        public List<ProtocolStepActivityComponent> getActivity() {
            if (this.activity == null) {
                this.activity = new ArrayList<ProtocolStepActivityComponent>();
            }
            return this.activity;
        }

        public boolean hasActivity() {
            if (this.activity == null) {
                return false;
            }
            for (ProtocolStepActivityComponent item : this.activity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProtocolStepActivityComponent addActivity() {
            ProtocolStepActivityComponent t = new ProtocolStepActivityComponent();
            if (this.activity == null) {
                this.activity = new ArrayList<ProtocolStepActivityComponent>();
            }
            this.activity.add(t);
            return t;
        }

        public ProtocolStepComponent addActivity(ProtocolStepActivityComponent t) {
            if (t == null) {
                return this;
            }
            if (this.activity == null) {
                this.activity = new ArrayList<ProtocolStepActivityComponent>();
            }
            this.activity.add(t);
            return this;
        }

        public List<ProtocolStepNextComponent> getNext() {
            if (this.next == null) {
                this.next = new ArrayList<ProtocolStepNextComponent>();
            }
            return this.next;
        }

        public boolean hasNext() {
            if (this.next == null) {
                return false;
            }
            for (ProtocolStepNextComponent item : this.next) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProtocolStepNextComponent addNext() {
            ProtocolStepNextComponent t = new ProtocolStepNextComponent();
            if (this.next == null) {
                this.next = new ArrayList<ProtocolStepNextComponent>();
            }
            this.next.add(t);
            return t;
        }

        public ProtocolStepComponent addNext(ProtocolStepNextComponent t) {
            if (t == null) {
                return this;
            }
            if (this.next == null) {
                this.next = new ArrayList<ProtocolStepNextComponent>();
            }
            this.next.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "Label for step.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("description", "string", "Human description of activity.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("duration", "Duration", "How long does step last?", 0, Integer.MAX_VALUE, this.duration));
            childrenList.add(new Property("precondition", "", "Rules prior to execution.", 0, Integer.MAX_VALUE, this.precondition));
            childrenList.add(new Property("exit", "@Protocol.step.precondition", "Indicates the conditions that must be met for activities that are part of this time point to terminate.", 0, Integer.MAX_VALUE, this.exit));
            childrenList.add(new Property("firstActivity", "uri", "First activity within timepoint.", 0, Integer.MAX_VALUE, this.firstActivity));
            childrenList.add(new Property("activity", "", "Activities that occur within timepoint.", 0, Integer.MAX_VALUE, this.activity));
            childrenList.add(new Property("next", "", "What happens next?", 0, Integer.MAX_VALUE, this.next));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.duration;
                    }
                    return baseArray;
                }
                case -650968616: {
                    Base[] baseArray;
                    if (this.precondition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.precondition;
                    }
                    return baseArray;
                }
                case 3127582: {
                    Base[] baseArray;
                    if (this.exit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.exit;
                    }
                    return baseArray;
                }
                case 185563615: {
                    Base[] baseArray;
                    if (this.firstActivity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.firstActivity;
                    }
                    return baseArray;
                }
                case -1655966961: {
                    return this.activity == null ? new Base[]{} : this.activity.toArray(new Base[this.activity.size()]);
                }
                case 3377907: {
                    return this.next == null ? new Base[]{} : this.next.toArray(new Base[this.next.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -1992012396: {
                    this.duration = this.castToDuration(value);
                    break;
                }
                case -650968616: {
                    this.precondition = (ProtocolStepPreconditionComponent)value;
                    break;
                }
                case 3127582: {
                    this.exit = (ProtocolStepPreconditionComponent)value;
                    break;
                }
                case 185563615: {
                    this.firstActivity = this.castToUri(value);
                    break;
                }
                case -1655966961: {
                    this.getActivity().add((ProtocolStepActivityComponent)value);
                    break;
                }
                case 3377907: {
                    this.getNext().add((ProtocolStepNextComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("duration")) {
                this.duration = this.castToDuration(value);
            } else if (name.equals("precondition")) {
                this.precondition = (ProtocolStepPreconditionComponent)value;
            } else if (name.equals("exit")) {
                this.exit = (ProtocolStepPreconditionComponent)value;
            } else if (name.equals("firstActivity")) {
                this.firstActivity = this.castToUri(value);
            } else if (name.equals("activity")) {
                this.getActivity().add((ProtocolStepActivityComponent)value);
            } else if (name.equals("next")) {
                this.getNext().add((ProtocolStepNextComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -1992012396: {
                    return this.getDuration();
                }
                case -650968616: {
                    return this.getPrecondition();
                }
                case 3127582: {
                    return this.getExit();
                }
                case 185563615: {
                    throw new FHIRException("Cannot make property firstActivity as it is not a complex type");
                }
                case -1655966961: {
                    return this.addActivity();
                }
                case 3377907: {
                    return this.addNext();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.description");
            }
            if (name.equals("duration")) {
                this.duration = new Duration();
                return this.duration;
            }
            if (name.equals("precondition")) {
                this.precondition = new ProtocolStepPreconditionComponent();
                return this.precondition;
            }
            if (name.equals("exit")) {
                this.exit = new ProtocolStepPreconditionComponent();
                return this.exit;
            }
            if (name.equals("firstActivity")) {
                throw new FHIRException("Cannot call addChild on a singleton property Protocol.firstActivity");
            }
            if (name.equals("activity")) {
                return this.addActivity();
            }
            if (name.equals("next")) {
                return this.addNext();
            }
            return super.addChild(name);
        }

        @Override
        public ProtocolStepComponent copy() {
            ProtocolStepComponent dst = new ProtocolStepComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
            dst.precondition = this.precondition == null ? null : this.precondition.copy();
            dst.exit = this.exit == null ? null : this.exit.copy();
            UriType uriType = dst.firstActivity = this.firstActivity == null ? null : this.firstActivity.copy();
            if (this.activity != null) {
                dst.activity = new ArrayList<ProtocolStepActivityComponent>();
                for (ProtocolStepActivityComponent protocolStepActivityComponent : this.activity) {
                    dst.activity.add(protocolStepActivityComponent.copy());
                }
            }
            if (this.next != null) {
                dst.next = new ArrayList<ProtocolStepNextComponent>();
                for (ProtocolStepNextComponent protocolStepNextComponent : this.next) {
                    dst.next.add(protocolStepNextComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepComponent)) {
                return false;
            }
            ProtocolStepComponent o = (ProtocolStepComponent)other;
            return ProtocolStepComponent.compareDeep(this.name, o.name, true) && ProtocolStepComponent.compareDeep(this.description, o.description, true) && ProtocolStepComponent.compareDeep(this.duration, o.duration, true) && ProtocolStepComponent.compareDeep(this.precondition, o.precondition, true) && ProtocolStepComponent.compareDeep(this.exit, o.exit, true) && ProtocolStepComponent.compareDeep(this.firstActivity, o.firstActivity, true) && ProtocolStepComponent.compareDeep(this.activity, o.activity, true) && ProtocolStepComponent.compareDeep(this.next, o.next, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProtocolStepComponent)) {
                return false;
            }
            ProtocolStepComponent o = (ProtocolStepComponent)other;
            return ProtocolStepComponent.compareValues(this.name, o.name, true) && ProtocolStepComponent.compareValues(this.description, o.description, true) && ProtocolStepComponent.compareValues(this.firstActivity, o.firstActivity, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.description != null && !this.description.isEmpty() || this.duration != null && !this.duration.isEmpty() || this.precondition != null && !this.precondition.isEmpty() || this.exit != null && !this.exit.isEmpty() || this.firstActivity != null && !this.firstActivity.isEmpty() || this.activity != null && !this.activity.isEmpty() || this.next != null && !this.next.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Protocol.step";
        }
    }

    public static class ActivityDefinitionCategoryEnumFactory
    implements EnumFactory<ActivityDefinitionCategory> {
        @Override
        public ActivityDefinitionCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("diet".equals(codeString)) {
                return ActivityDefinitionCategory.DIET;
            }
            if ("drug".equals(codeString)) {
                return ActivityDefinitionCategory.DRUG;
            }
            if ("encounter".equals(codeString)) {
                return ActivityDefinitionCategory.ENCOUNTER;
            }
            if ("observation".equals(codeString)) {
                return ActivityDefinitionCategory.OBSERVATION;
            }
            if ("procedure".equals(codeString)) {
                return ActivityDefinitionCategory.PROCEDURE;
            }
            if ("supply".equals(codeString)) {
                return ActivityDefinitionCategory.SUPPLY;
            }
            if ("other".equals(codeString)) {
                return ActivityDefinitionCategory.OTHER;
            }
            throw new IllegalArgumentException("Unknown ActivityDefinitionCategory code '" + codeString + "'");
        }

        public Enumeration<ActivityDefinitionCategory> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("diet".equals(codeString)) {
                return new Enumeration<ActivityDefinitionCategory>(this, ActivityDefinitionCategory.DIET);
            }
            if ("drug".equals(codeString)) {
                return new Enumeration<ActivityDefinitionCategory>(this, ActivityDefinitionCategory.DRUG);
            }
            if ("encounter".equals(codeString)) {
                return new Enumeration<ActivityDefinitionCategory>(this, ActivityDefinitionCategory.ENCOUNTER);
            }
            if ("observation".equals(codeString)) {
                return new Enumeration<ActivityDefinitionCategory>(this, ActivityDefinitionCategory.OBSERVATION);
            }
            if ("procedure".equals(codeString)) {
                return new Enumeration<ActivityDefinitionCategory>(this, ActivityDefinitionCategory.PROCEDURE);
            }
            if ("supply".equals(codeString)) {
                return new Enumeration<ActivityDefinitionCategory>(this, ActivityDefinitionCategory.SUPPLY);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<ActivityDefinitionCategory>(this, ActivityDefinitionCategory.OTHER);
            }
            throw new FHIRException("Unknown ActivityDefinitionCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(ActivityDefinitionCategory code) {
            if (code == ActivityDefinitionCategory.NULL) {
                return null;
            }
            if (code == ActivityDefinitionCategory.DIET) {
                return "diet";
            }
            if (code == ActivityDefinitionCategory.DRUG) {
                return "drug";
            }
            if (code == ActivityDefinitionCategory.ENCOUNTER) {
                return "encounter";
            }
            if (code == ActivityDefinitionCategory.OBSERVATION) {
                return "observation";
            }
            if (code == ActivityDefinitionCategory.PROCEDURE) {
                return "procedure";
            }
            if (code == ActivityDefinitionCategory.SUPPLY) {
                return "supply";
            }
            if (code == ActivityDefinitionCategory.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(ActivityDefinitionCategory code) {
            return code.getSystem();
        }
    }

    public static enum ActivityDefinitionCategory {
        DIET,
        DRUG,
        ENCOUNTER,
        OBSERVATION,
        PROCEDURE,
        SUPPLY,
        OTHER,
        NULL;


        public static ActivityDefinitionCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("diet".equals(codeString)) {
                return DIET;
            }
            if ("drug".equals(codeString)) {
                return DRUG;
            }
            if ("encounter".equals(codeString)) {
                return ENCOUNTER;
            }
            if ("observation".equals(codeString)) {
                return OBSERVATION;
            }
            if ("procedure".equals(codeString)) {
                return PROCEDURE;
            }
            if ("supply".equals(codeString)) {
                return SUPPLY;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            throw new FHIRException("Unknown ActivityDefinitionCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DIET: {
                    return "diet";
                }
                case DRUG: {
                    return "drug";
                }
                case ENCOUNTER: {
                    return "encounter";
                }
                case OBSERVATION: {
                    return "observation";
                }
                case PROCEDURE: {
                    return "procedure";
                }
                case SUPPLY: {
                    return "supply";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DIET: {
                    return "http://hl7.org/fhir/activity-definition-category";
                }
                case DRUG: {
                    return "http://hl7.org/fhir/activity-definition-category";
                }
                case ENCOUNTER: {
                    return "http://hl7.org/fhir/activity-definition-category";
                }
                case OBSERVATION: {
                    return "http://hl7.org/fhir/activity-definition-category";
                }
                case PROCEDURE: {
                    return "http://hl7.org/fhir/activity-definition-category";
                }
                case SUPPLY: {
                    return "http://hl7.org/fhir/activity-definition-category";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/activity-definition-category";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DIET: {
                    return "To consume food of a specified nature";
                }
                case DRUG: {
                    return "To consume/receive a drug, vaccine or other product";
                }
                case ENCOUNTER: {
                    return "To meet or communicate with the patient (in-patient, out-patient, phone call, etc.)";
                }
                case OBSERVATION: {
                    return "To capture information about a patient (vitals, labs, diagnostic images, etc.)";
                }
                case PROCEDURE: {
                    return "To modify the patient in some way (surgery, physiotherapy, education, counseling, etc.)";
                }
                case SUPPLY: {
                    return "To provide something to the patient (medication, medical supply, etc.)";
                }
                case OTHER: {
                    return "Some other form of action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DIET: {
                    return "Diet";
                }
                case DRUG: {
                    return "Drug";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case OBSERVATION: {
                    return "Observation";
                }
                case PROCEDURE: {
                    return "Procedure";
                }
                case SUPPLY: {
                    return "Supply";
                }
                case OTHER: {
                    return "Other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ProtocolTypeEnumFactory
    implements EnumFactory<ProtocolType> {
        @Override
        public ProtocolType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("condition".equals(codeString)) {
                return ProtocolType.CONDITION;
            }
            if ("device".equals(codeString)) {
                return ProtocolType.DEVICE;
            }
            if ("drug".equals(codeString)) {
                return ProtocolType.DRUG;
            }
            if ("study".equals(codeString)) {
                return ProtocolType.STUDY;
            }
            throw new IllegalArgumentException("Unknown ProtocolType code '" + codeString + "'");
        }

        public Enumeration<ProtocolType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("condition".equals(codeString)) {
                return new Enumeration<ProtocolType>(this, ProtocolType.CONDITION);
            }
            if ("device".equals(codeString)) {
                return new Enumeration<ProtocolType>(this, ProtocolType.DEVICE);
            }
            if ("drug".equals(codeString)) {
                return new Enumeration<ProtocolType>(this, ProtocolType.DRUG);
            }
            if ("study".equals(codeString)) {
                return new Enumeration<ProtocolType>(this, ProtocolType.STUDY);
            }
            throw new FHIRException("Unknown ProtocolType code '" + codeString + "'");
        }

        @Override
        public String toCode(ProtocolType code) {
            if (code == ProtocolType.NULL) {
                return null;
            }
            if (code == ProtocolType.CONDITION) {
                return "condition";
            }
            if (code == ProtocolType.DEVICE) {
                return "device";
            }
            if (code == ProtocolType.DRUG) {
                return "drug";
            }
            if (code == ProtocolType.STUDY) {
                return "study";
            }
            return "?";
        }

        @Override
        public String toSystem(ProtocolType code) {
            return code.getSystem();
        }
    }

    public static enum ProtocolType {
        CONDITION,
        DEVICE,
        DRUG,
        STUDY,
        NULL;


        public static ProtocolType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("condition".equals(codeString)) {
                return CONDITION;
            }
            if ("device".equals(codeString)) {
                return DEVICE;
            }
            if ("drug".equals(codeString)) {
                return DRUG;
            }
            if ("study".equals(codeString)) {
                return STUDY;
            }
            throw new FHIRException("Unknown ProtocolType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CONDITION: {
                    return "condition";
                }
                case DEVICE: {
                    return "device";
                }
                case DRUG: {
                    return "drug";
                }
                case STUDY: {
                    return "study";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CONDITION: {
                    return "http://hl7.org/fhir/protocol-type";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/protocol-type";
                }
                case DRUG: {
                    return "http://hl7.org/fhir/protocol-type";
                }
                case STUDY: {
                    return "http://hl7.org/fhir/protocol-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CONDITION: {
                    return "The protocol describes the steps to manage a particular health condition including monitoring, treatment, mitigation and/or follow-up";
                }
                case DEVICE: {
                    return "The protocol describes the appropriate use of a particular device (medical device, software, etc.)";
                }
                case DRUG: {
                    return "The protocol describes the appropriate use of a particular medication including indications for use, dosages, treatment cycles, etc.";
                }
                case STUDY: {
                    return "The protocol describes the set of steps to occur for study subjects enrolled in an interventional study";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CONDITION: {
                    return "Condition";
                }
                case DEVICE: {
                    return "Device";
                }
                case DRUG: {
                    return "Drug";
                }
                case STUDY: {
                    return "Study";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ProtocolStatusEnumFactory
    implements EnumFactory<ProtocolStatus> {
        @Override
        public ProtocolStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ProtocolStatus.DRAFT;
            }
            if ("testing".equals(codeString)) {
                return ProtocolStatus.TESTING;
            }
            if ("review".equals(codeString)) {
                return ProtocolStatus.REVIEW;
            }
            if ("active".equals(codeString)) {
                return ProtocolStatus.ACTIVE;
            }
            if ("withdrawn".equals(codeString)) {
                return ProtocolStatus.WITHDRAWN;
            }
            if ("superseded".equals(codeString)) {
                return ProtocolStatus.SUPERSEDED;
            }
            throw new IllegalArgumentException("Unknown ProtocolStatus code '" + codeString + "'");
        }

        public Enumeration<ProtocolStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ProtocolStatus>(this, ProtocolStatus.DRAFT);
            }
            if ("testing".equals(codeString)) {
                return new Enumeration<ProtocolStatus>(this, ProtocolStatus.TESTING);
            }
            if ("review".equals(codeString)) {
                return new Enumeration<ProtocolStatus>(this, ProtocolStatus.REVIEW);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ProtocolStatus>(this, ProtocolStatus.ACTIVE);
            }
            if ("withdrawn".equals(codeString)) {
                return new Enumeration<ProtocolStatus>(this, ProtocolStatus.WITHDRAWN);
            }
            if ("superseded".equals(codeString)) {
                return new Enumeration<ProtocolStatus>(this, ProtocolStatus.SUPERSEDED);
            }
            throw new FHIRException("Unknown ProtocolStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ProtocolStatus code) {
            if (code == ProtocolStatus.NULL) {
                return null;
            }
            if (code == ProtocolStatus.DRAFT) {
                return "draft";
            }
            if (code == ProtocolStatus.TESTING) {
                return "testing";
            }
            if (code == ProtocolStatus.REVIEW) {
                return "review";
            }
            if (code == ProtocolStatus.ACTIVE) {
                return "active";
            }
            if (code == ProtocolStatus.WITHDRAWN) {
                return "withdrawn";
            }
            if (code == ProtocolStatus.SUPERSEDED) {
                return "superseded";
            }
            return "?";
        }

        @Override
        public String toSystem(ProtocolStatus code) {
            return code.getSystem();
        }
    }

    public static enum ProtocolStatus {
        DRAFT,
        TESTING,
        REVIEW,
        ACTIVE,
        WITHDRAWN,
        SUPERSEDED,
        NULL;


        public static ProtocolStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("testing".equals(codeString)) {
                return TESTING;
            }
            if ("review".equals(codeString)) {
                return REVIEW;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("withdrawn".equals(codeString)) {
                return WITHDRAWN;
            }
            if ("superseded".equals(codeString)) {
                return SUPERSEDED;
            }
            throw new FHIRException("Unknown ProtocolStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case TESTING: {
                    return "testing";
                }
                case REVIEW: {
                    return "review";
                }
                case ACTIVE: {
                    return "active";
                }
                case WITHDRAWN: {
                    return "withdrawn";
                }
                case SUPERSEDED: {
                    return "superseded";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/protocol-status";
                }
                case TESTING: {
                    return "http://hl7.org/fhir/protocol-status";
                }
                case REVIEW: {
                    return "http://hl7.org/fhir/protocol-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/protocol-status";
                }
                case WITHDRAWN: {
                    return "http://hl7.org/fhir/protocol-status";
                }
                case SUPERSEDED: {
                    return "http://hl7.org/fhir/protocol-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "This protocol is still under development";
                }
                case TESTING: {
                    return "This protocol was authored for testing purposes (or education/evaluation/marketing)";
                }
                case REVIEW: {
                    return "This protocol is undergoing review to check that it is ready for production use";
                }
                case ACTIVE: {
                    return "This protocol is ready for use in production systems";
                }
                case WITHDRAWN: {
                    return "This protocol has been withdrawn and should no longer be used";
                }
                case SUPERSEDED: {
                    return "This protocol has been replaced and a different protocol should be used in its place";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case TESTING: {
                    return "Testing";
                }
                case REVIEW: {
                    return "Review";
                }
                case ACTIVE: {
                    return "Active";
                }
                case WITHDRAWN: {
                    return "Withdrawn";
                }
                case SUPERSEDED: {
                    return "Superseded";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

