/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DocumentManifest", profile="http://hl7.org/fhir/Profile/DocumentManifest")
public class DocumentManifest
extends DomainResource {
    @Child(name="masterIdentifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique Identifier for the set of documents", formalDefinition="A single identifier that uniquely identifies this manifest. Principally used to refer to the manifest in non-FHIR contexts.")
    protected Identifier masterIdentifier;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other identifiers for the manifest", formalDefinition="Other identifiers associated with the document manifest, including version independent  identifiers.")
    protected List<Identifier> identifier;
    @Child(name="subject", type={Patient.class, Practitioner.class, Group.class, Device.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the set of documents", formalDefinition="Who or what the set of documents is about. The documents can be about a person, (patient or healthcare practitioner), a device (i.e. machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure). If the documents cross more than one subject, then more than one subject is allowed here (unusual use case).")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="recipient", type={Patient.class, Practitioner.class, RelatedPerson.class, Organization.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended to get notified about this set of documents", formalDefinition="A patient, practitioner, or organization for which this set of documents is intended.")
    protected List<Reference> recipient;
    protected List<Resource> recipientTarget;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of document set", formalDefinition="Specifies the kind of this set of documents (e.g. Patient Summary, Discharge Summary, Prescription, etc.). The type of a set of documents may be the same as one of the documents in it - especially if there is only one - but it may be wider.")
    protected CodeableConcept type;
    @Child(name="author", type={Practitioner.class, Organization.class, Device.class, Patient.class, RelatedPerson.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what authored the manifest", formalDefinition="Identifies who is responsible for creating the manifest, and adding  documents to it.")
    protected List<Reference> author;
    protected List<Resource> authorTarget;
    @Child(name="created", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this document manifest created", formalDefinition="When the document manifest was created for submission to the server (not necessarily the same thing as the actual resource last modified time, since it may be modified, replicated, etc.).")
    protected DateTimeType created;
    @Child(name="source", type={UriType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source system/application/software", formalDefinition="Identifies the source system, application, or software that produced the document manifest.")
    protected UriType source;
    @Child(name="status", type={CodeType.class}, order=8, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="current | superseded | entered-in-error", formalDefinition="The status of this document manifest.")
    protected Enumeration<Enumerations.DocumentReferenceStatus> status;
    @Child(name="description", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable description (title)", formalDefinition="Human-readable description of the source document. This is sometimes known as the \"title\".")
    protected StringType description;
    @Child(name="content", type={}, order=10, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The items included", formalDefinition="The list of Documents included in the manifest.")
    protected List<DocumentManifestContentComponent> content;
    @Child(name="related", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Related things", formalDefinition="Related identifiers or resources associated with the DocumentManifest.")
    protected List<DocumentManifestRelatedComponent> related;
    private static final long serialVersionUID = -2056683927L;
    @SearchParamDefinition(name="related-ref", path="DocumentManifest.related.ref", description="Related Resource", type="reference")
    public static final String SP_RELATED_REF = "related-ref";
    public static final ReferenceClientParam RELATED_REF = new ReferenceClientParam("related-ref");
    public static final Include INCLUDE_RELATED_REF = new Include("DocumentManifest:related-ref").toLocked();
    @SearchParamDefinition(name="related-id", path="DocumentManifest.related.identifier", description="Identifiers of things that are related", type="token")
    public static final String SP_RELATED_ID = "related-id";
    public static final TokenClientParam RELATED_ID = new TokenClientParam("related-id");
    @SearchParamDefinition(name="content-ref", path="DocumentManifest.content.p.as(Reference)", description="Contents of this set of documents", type="reference")
    public static final String SP_CONTENT_REF = "content-ref";
    public static final ReferenceClientParam CONTENT_REF = new ReferenceClientParam("content-ref");
    public static final Include INCLUDE_CONTENT_REF = new Include("DocumentManifest:content-ref").toLocked();
    @SearchParamDefinition(name="status", path="DocumentManifest.status", description="current | superseded | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DocumentManifest.subject", description="The subject of the set of documents", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DocumentManifest:subject").toLocked();
    @SearchParamDefinition(name="type", path="DocumentManifest.type", description="Kind of document set", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="recipient", path="DocumentManifest.recipient", description="Intended to get notified about this set of documents", type="reference")
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    public static final Include INCLUDE_RECIPIENT = new Include("DocumentManifest:recipient").toLocked();
    @SearchParamDefinition(name="author", path="DocumentManifest.author", description="Who and/or what authored the manifest", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("DocumentManifest:author").toLocked();
    @SearchParamDefinition(name="patient", path="DocumentManifest.subject", description="The subject of the set of documents", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DocumentManifest:patient").toLocked();
    @SearchParamDefinition(name="source", path="DocumentManifest.source", description="The source system/application/software", type="uri")
    public static final String SP_SOURCE = "source";
    public static final UriClientParam SOURCE = new UriClientParam("source");
    @SearchParamDefinition(name="created", path="DocumentManifest.created", description="When this document manifest created", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="description", path="DocumentManifest.description", description="Human-readable description (title)", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="DocumentManifest.masterIdentifier | DocumentManifest.identifier", description="Unique Identifier for the set of documents", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public DocumentManifest() {
    }

    public DocumentManifest(Enumeration<Enumerations.DocumentReferenceStatus> status) {
        this.status = status;
    }

    public Identifier getMasterIdentifier() {
        if (this.masterIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentManifest.masterIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.masterIdentifier = new Identifier();
            }
        }
        return this.masterIdentifier;
    }

    public boolean hasMasterIdentifier() {
        return this.masterIdentifier != null && !this.masterIdentifier.isEmpty();
    }

    public DocumentManifest setMasterIdentifier(Identifier value) {
        this.masterIdentifier = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DocumentManifest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentManifest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DocumentManifest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DocumentManifest setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public boolean hasRecipient() {
        if (this.recipient == null) {
            return false;
        }
        for (Reference item : this.recipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRecipient() {
        Reference t = new Reference();
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return t;
    }

    public DocumentManifest addRecipient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return this;
    }

    public List<Resource> getRecipientTarget() {
        if (this.recipientTarget == null) {
            this.recipientTarget = new ArrayList<Resource>();
        }
        return this.recipientTarget;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentManifest.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DocumentManifest setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (Reference item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthor() {
        Reference t = new Reference();
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return t;
    }

    public DocumentManifest addAuthor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return this;
    }

    public List<Resource> getAuthorTarget() {
        if (this.authorTarget == null) {
            this.authorTarget = new ArrayList<Resource>();
        }
        return this.authorTarget;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentManifest.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public DocumentManifest setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public DocumentManifest setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public UriType getSourceElement() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentManifest.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new UriType();
            }
        }
        return this.source;
    }

    public boolean hasSourceElement() {
        return this.source != null && !this.source.isEmpty();
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public DocumentManifest setSourceElement(UriType value) {
        this.source = value;
        return this;
    }

    public String getSource() {
        return this.source == null ? null : (String)this.source.getValue();
    }

    public DocumentManifest setSource(String value) {
        if (Utilities.noString((String)value)) {
            this.source = null;
        } else {
            if (this.source == null) {
                this.source = new UriType();
            }
            this.source.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.DocumentReferenceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentManifest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DocumentManifest setStatusElement(Enumeration<Enumerations.DocumentReferenceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.DocumentReferenceStatus getStatus() {
        return this.status == null ? null : (Enumerations.DocumentReferenceStatus)((Object)this.status.getValue());
    }

    public DocumentManifest setStatus(Enumerations.DocumentReferenceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentManifest.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public DocumentManifest setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public DocumentManifest setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<DocumentManifestContentComponent> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<DocumentManifestContentComponent>();
        }
        return this.content;
    }

    public boolean hasContent() {
        if (this.content == null) {
            return false;
        }
        for (DocumentManifestContentComponent item : this.content) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentManifestContentComponent addContent() {
        DocumentManifestContentComponent t = new DocumentManifestContentComponent();
        if (this.content == null) {
            this.content = new ArrayList<DocumentManifestContentComponent>();
        }
        this.content.add(t);
        return t;
    }

    public DocumentManifest addContent(DocumentManifestContentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.content == null) {
            this.content = new ArrayList<DocumentManifestContentComponent>();
        }
        this.content.add(t);
        return this;
    }

    public List<DocumentManifestRelatedComponent> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<DocumentManifestRelatedComponent>();
        }
        return this.related;
    }

    public boolean hasRelated() {
        if (this.related == null) {
            return false;
        }
        for (DocumentManifestRelatedComponent item : this.related) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentManifestRelatedComponent addRelated() {
        DocumentManifestRelatedComponent t = new DocumentManifestRelatedComponent();
        if (this.related == null) {
            this.related = new ArrayList<DocumentManifestRelatedComponent>();
        }
        this.related.add(t);
        return t;
    }

    public DocumentManifest addRelated(DocumentManifestRelatedComponent t) {
        if (t == null) {
            return this;
        }
        if (this.related == null) {
            this.related = new ArrayList<DocumentManifestRelatedComponent>();
        }
        this.related.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("masterIdentifier", "Identifier", "A single identifier that uniquely identifies this manifest. Principally used to refer to the manifest in non-FHIR contexts.", 0, Integer.MAX_VALUE, this.masterIdentifier));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Other identifiers associated with the document manifest, including version independent  identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group|Device)", "Who or what the set of documents is about. The documents can be about a person, (patient or healthcare practitioner), a device (i.e. machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure). If the documents cross more than one subject, then more than one subject is allowed here (unusual use case).", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_RECIPIENT, "Reference(Patient|Practitioner|RelatedPerson|Organization)", "A patient, practitioner, or organization for which this set of documents is intended.", 0, Integer.MAX_VALUE, this.recipient));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "Specifies the kind of this set of documents (e.g. Patient Summary, Discharge Summary, Prescription, etc.). The type of a set of documents may be the same as one of the documents in it - especially if there is only one - but it may be wider.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Practitioner|Organization|Device|Patient|RelatedPerson)", "Identifies who is responsible for creating the manifest, and adding  documents to it.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property(SP_CREATED, "dateTime", "When the document manifest was created for submission to the server (not necessarily the same thing as the actual resource last modified time, since it may be modified, replicated, etc.).", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property(SP_SOURCE, "uri", "Identifies the source system, application, or software that produced the document manifest.", 0, Integer.MAX_VALUE, this.source));
        childrenList.add(new Property(SP_STATUS, "code", "The status of this document manifest.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "Human-readable description of the source document. This is sometimes known as the \"title\".", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("content", "", "The list of Documents included in the manifest.", 0, Integer.MAX_VALUE, this.content));
        childrenList.add(new Property("related", "", "Related identifiers or resources associated with the DocumentManifest.", 0, Integer.MAX_VALUE, this.related));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 243769515: {
                Base[] baseArray;
                if (this.masterIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.masterIdentifier;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case 820081177: {
                return this.recipient == null ? new Base[]{} : this.recipient.toArray(new Base[this.recipient.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.created;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.source;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.description;
                }
                return baseArray;
            }
            case 951530617: {
                return this.content == null ? new Base[]{} : this.content.toArray(new Base[this.content.size()]);
            }
            case 1090493483: {
                return this.related == null ? new Base[]{} : this.related.toArray(new Base[this.related.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 243769515: {
                this.masterIdentifier = this.castToIdentifier(value);
                break;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case 820081177: {
                this.getRecipient().add(this.castToReference(value));
                break;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                break;
            }
            case -1406328437: {
                this.getAuthor().add(this.castToReference(value));
                break;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                break;
            }
            case -896505829: {
                this.source = this.castToUri(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.DocumentReferenceStatusEnumFactory().fromType(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case 951530617: {
                this.getContent().add((DocumentManifestContentComponent)value);
                break;
            }
            case 1090493483: {
                this.getRelated().add((DocumentManifestRelatedComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("masterIdentifier")) {
            this.masterIdentifier = this.castToIdentifier(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.getRecipient().add(this.castToReference(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.getAuthor().add(this.castToReference(value));
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = this.castToUri(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.DocumentReferenceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("content")) {
            this.getContent().add((DocumentManifestContentComponent)value);
        } else if (name.equals("related")) {
            this.getRelated().add((DocumentManifestRelatedComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 243769515: {
                return this.getMasterIdentifier();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 820081177: {
                return this.addRecipient();
            }
            case 3575610: {
                return this.getType();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case 1028554472: {
                throw new FHIRException("Cannot make property created as it is not a complex type");
            }
            case -896505829: {
                throw new FHIRException("Cannot make property source as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case 951530617: {
                return this.addContent();
            }
            case 1090493483: {
                return this.addRelated();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("masterIdentifier")) {
            this.masterIdentifier = new Identifier();
            return this.masterIdentifier;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_RECIPIENT)) {
            return this.addRecipient();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_AUTHOR)) {
            return this.addAuthor();
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property DocumentManifest.created");
        }
        if (name.equals(SP_SOURCE)) {
            throw new FHIRException("Cannot call addChild on a singleton property DocumentManifest.source");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property DocumentManifest.status");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property DocumentManifest.description");
        }
        if (name.equals("content")) {
            return this.addContent();
        }
        if (name.equals("related")) {
            return this.addRelated();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DocumentManifest";
    }

    @Override
    public DocumentManifest copy() {
        DocumentManifest dst = new DocumentManifest();
        this.copyValues(dst);
        Identifier identifier = dst.masterIdentifier = this.masterIdentifier == null ? null : this.masterIdentifier.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier2 : this.identifier) {
                dst.identifier.add(identifier2.copy());
            }
        }
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.recipient != null) {
            dst.recipient = new ArrayList<Reference>();
            for (Reference reference2 : this.recipient) {
                dst.recipient.add(reference2.copy());
            }
        }
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.author != null) {
            dst.author = new ArrayList<Reference>();
            for (Reference reference3 : this.author) {
                dst.author.add(reference3.copy());
            }
        }
        dst.created = this.created == null ? null : this.created.copy();
        dst.source = this.source == null ? null : this.source.copy();
        dst.status = this.status == null ? null : this.status.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.content != null) {
            dst.content = new ArrayList<DocumentManifestContentComponent>();
            for (DocumentManifestContentComponent documentManifestContentComponent : this.content) {
                dst.content.add(documentManifestContentComponent.copy());
            }
        }
        if (this.related != null) {
            dst.related = new ArrayList<DocumentManifestRelatedComponent>();
            for (DocumentManifestRelatedComponent documentManifestRelatedComponent : this.related) {
                dst.related.add(documentManifestRelatedComponent.copy());
            }
        }
        return dst;
    }

    protected DocumentManifest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DocumentManifest)) {
            return false;
        }
        DocumentManifest o = (DocumentManifest)other;
        return DocumentManifest.compareDeep(this.masterIdentifier, o.masterIdentifier, true) && DocumentManifest.compareDeep(this.identifier, o.identifier, true) && DocumentManifest.compareDeep(this.subject, o.subject, true) && DocumentManifest.compareDeep(this.recipient, o.recipient, true) && DocumentManifest.compareDeep(this.type, o.type, true) && DocumentManifest.compareDeep(this.author, o.author, true) && DocumentManifest.compareDeep(this.created, o.created, true) && DocumentManifest.compareDeep(this.source, o.source, true) && DocumentManifest.compareDeep(this.status, o.status, true) && DocumentManifest.compareDeep(this.description, o.description, true) && DocumentManifest.compareDeep(this.content, o.content, true) && DocumentManifest.compareDeep(this.related, o.related, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DocumentManifest)) {
            return false;
        }
        DocumentManifest o = (DocumentManifest)other;
        return DocumentManifest.compareValues(this.created, o.created, true) && DocumentManifest.compareValues(this.source, o.source, true) && DocumentManifest.compareValues(this.status, o.status, true) && DocumentManifest.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.masterIdentifier != null && !this.masterIdentifier.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.recipient != null && !this.recipient.isEmpty() || this.type != null && !this.type.isEmpty() || this.author != null && !this.author.isEmpty() || this.created != null && !this.created.isEmpty() || this.source != null && !this.source.isEmpty() || this.status != null && !this.status.isEmpty() || this.description != null && !this.description.isEmpty() || this.content != null && !this.content.isEmpty() || this.related != null && !this.related.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DocumentManifest;
    }

    @Block
    public static class DocumentManifestContentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="p", type={Attachment.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contents of this set of documents", formalDefinition="The list of references to document content, or Attachment that consist of the parts of this document manifest. Usually, these would be document references, but direct references to Media or Attachments are also allowed.")
        protected Type p;
        private static final long serialVersionUID = -347538500L;

        public DocumentManifestContentComponent() {
        }

        public DocumentManifestContentComponent(Type p) {
            this.p = p;
        }

        public Type getP() {
            return this.p;
        }

        public Attachment getPAttachment() throws FHIRException {
            if (!(this.p instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.p.getClass().getName() + " was encountered");
            }
            return (Attachment)this.p;
        }

        public boolean hasPAttachment() {
            return this.p instanceof Attachment;
        }

        public Reference getPReference() throws FHIRException {
            if (!(this.p instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.p.getClass().getName() + " was encountered");
            }
            return (Reference)this.p;
        }

        public boolean hasPReference() {
            return this.p instanceof Reference;
        }

        public boolean hasP() {
            return this.p != null && !this.p.isEmpty();
        }

        public DocumentManifestContentComponent setP(Type value) {
            this.p = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("p[x]", "Attachment|Reference(Any)", "The list of references to document content, or Attachment that consist of the parts of this document manifest. Usually, these would be document references, but direct references to Media or Attachments are also allowed.", 0, Integer.MAX_VALUE, this.p));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 112: {
                    Base[] baseArray;
                    if (this.p == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.p;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 112: {
                    this.p = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("p[x]")) {
                this.p = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3427856: {
                    return this.getP();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("pAttachment")) {
                this.p = new Attachment();
                return this.p;
            }
            if (name.equals("pReference")) {
                this.p = new Reference();
                return this.p;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentManifestContentComponent copy() {
            DocumentManifestContentComponent dst = new DocumentManifestContentComponent();
            this.copyValues(dst);
            dst.p = this.p == null ? null : this.p.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DocumentManifestContentComponent)) {
                return false;
            }
            DocumentManifestContentComponent o = (DocumentManifestContentComponent)other;
            return DocumentManifestContentComponent.compareDeep(this.p, o.p, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DocumentManifestContentComponent)) {
                return false;
            }
            DocumentManifestContentComponent o = (DocumentManifestContentComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.p == null || this.p.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DocumentManifest.content";
        }
    }

    @Block
    public static class DocumentManifestRelatedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifiers of things that are related", formalDefinition="Related identifier to this DocumentManifest.  For example, Order numbers, accession numbers, XDW workflow numbers.")
        protected Identifier identifier;
        @Child(name="ref", type={}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Related Resource", formalDefinition="Related Resource to this DocumentManifest. For example, Order, DiagnosticOrder,  Procedure, EligibilityRequest, etc.")
        protected Reference ref;
        protected Resource refTarget;
        private static final long serialVersionUID = -1670123330L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentManifestRelatedComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public DocumentManifestRelatedComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public Reference getRef() {
            if (this.ref == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentManifestRelatedComponent.ref");
                }
                if (Configuration.doAutoCreate()) {
                    this.ref = new Reference();
                }
            }
            return this.ref;
        }

        public boolean hasRef() {
            return this.ref != null && !this.ref.isEmpty();
        }

        public DocumentManifestRelatedComponent setRef(Reference value) {
            this.ref = value;
            return this;
        }

        public Resource getRefTarget() {
            return this.refTarget;
        }

        public DocumentManifestRelatedComponent setRefTarget(Resource value) {
            this.refTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(DocumentManifest.SP_IDENTIFIER, "Identifier", "Related identifier to this DocumentManifest.  For example, Order numbers, accession numbers, XDW workflow numbers.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("ref", "Reference(Any)", "Related Resource to this DocumentManifest. For example, Order, DiagnosticOrder,  Procedure, EligibilityRequest, etc.", 0, Integer.MAX_VALUE, this.ref));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 112787: {
                    Base[] baseArray;
                    if (this.ref == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.ref;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    break;
                }
                case 112787: {
                    this.ref = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DocumentManifest.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("ref")) {
                this.ref = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 112787: {
                    return this.getRef();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DocumentManifest.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("ref")) {
                this.ref = new Reference();
                return this.ref;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentManifestRelatedComponent copy() {
            DocumentManifestRelatedComponent dst = new DocumentManifestRelatedComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.ref = this.ref == null ? null : this.ref.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DocumentManifestRelatedComponent)) {
                return false;
            }
            DocumentManifestRelatedComponent o = (DocumentManifestRelatedComponent)other;
            return DocumentManifestRelatedComponent.compareDeep(this.identifier, o.identifier, true) && DocumentManifestRelatedComponent.compareDeep(this.ref, o.ref, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DocumentManifestRelatedComponent)) {
                return false;
            }
            DocumentManifestRelatedComponent o = (DocumentManifestRelatedComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.ref != null && !this.ref.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DocumentManifest.related";
        }
    }
}

