/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ExpansionProfile", profile="http://hl7.org/fhir/Profile/ExpansionProfile")
public class ExpansionProfile
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Globally unique logical identifier for  expansion profile", formalDefinition="An absolute URL that is used to identify this expansion profile when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this expansion profile is (or will be) published.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the expansion profile (e.g. an Object Identifier)", formalDefinition="Formal identifier that is used to identify this expansion profile when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected Identifier identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical identifier for this version of the expansion profile", formalDefinition="Used to identify this version of the expansion profile when it is referenced in a specification, model, design or instance.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this expansion profile", formalDefinition="A free text natural language name for the expansion profile.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the expansion profile.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This expansion profile was authored for testing purposes (or education/evaluation/marketing), and is not intended for genuine production usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the individual or organization that published the expansion profile.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<ExpansionProfileContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date for given status", formalDefinition="The date that the expansion profile status was last changed. The date must change when the business version changes, if it does, and it must change if the status code changes.")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human language description of the expansion profile", formalDefinition="A free text natural language description of the use of the expansion profile - reason for definition,  conditions of use, etc. The description may include a list of expected usages for the expansion profile and can also describe the approach taken to build the expansion profile.")
    protected StringType description;
    @Child(name="codeSystem", type={}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the expansion profile imposes code system contraints", formalDefinition="A set of criteria that provide the constraints imposed on the value set expansion by including or excluding codes from specific code systems (or versions).")
    protected ExpansionProfileCodeSystemComponent codeSystem;
    @Child(name="includeDesignations", type={BooleanType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the expansion should include concept designations", formalDefinition="Controls whether concept designations are to be included or excluded in value set expansions.")
    protected BooleanType includeDesignations;
    @Child(name="designation", type={}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the expansion profile imposes designation contraints", formalDefinition="A set of criteria that provide the constraints imposed on the value set expansion by including or excluding designations.")
    protected ExpansionProfileDesignationComponent designation;
    @Child(name="includeDefinition", type={BooleanType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include or exclude the value set definition in the expansion", formalDefinition="Controls whether the value set definition is included or excluded in value set expansions.")
    protected BooleanType includeDefinition;
    @Child(name="includeInactive", type={BooleanType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include or exclude inactive concepts in the expansion", formalDefinition="Controls whether inactive concepts are included or excluded in value set expansions.")
    protected BooleanType includeInactive;
    @Child(name="excludeNested", type={BooleanType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include or exclude nested codes in the value set expansion", formalDefinition="Controls whether or not the value set expansion includes nested codes (i.e. ValueSet.expansion.contains.contains).")
    protected BooleanType excludeNested;
    @Child(name="excludeNotForUI", type={BooleanType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include or exclude codes which cannot be rendered in user interfaces in the value set expansion", formalDefinition="Controls whether or not the value set expansion includes codes which cannot be displayed in user interfaces.")
    protected BooleanType excludeNotForUI;
    @Child(name="excludePostCoordinated", type={BooleanType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include or exclude codes which are post coordinated expressions in the value set expansion", formalDefinition="Controls whether or not the value set expansion includes post coordinated codes.")
    protected BooleanType excludePostCoordinated;
    @Child(name="displayLanguage", type={CodeType.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specify the language for the display element of codes in the value set expansion", formalDefinition="Specifies the language to be used for description in the expansions i.e. the language to be used for ValueSet.expansion.contains.display.")
    protected CodeType displayLanguage;
    @Child(name="limitedExpansion", type={BooleanType.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Controls behaviour of the value set expand operation when value sets are too large to be completely expanded", formalDefinition="If the value set being expanded is incomplete (because it is too big to expand), return a limited expansion (a subset) with an indicator that expansion is incomplete.")
    protected BooleanType limitedExpansion;
    private static final long serialVersionUID = -651123079L;
    @SearchParamDefinition(name="status", path="ExpansionProfile.status", description="The status of the expansion profile", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="ExpansionProfile.description", description="Text search in the description of the expansion profile", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="name", path="ExpansionProfile.name", description="The name of the expansion profile", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="date", path="ExpansionProfile.date", description="The expansion profile publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ExpansionProfile.identifier", description="The identifier for the expansion profile", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="url", path="ExpansionProfile.url", description="The logical URL for the expansion profile", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="publisher", path="ExpansionProfile.publisher", description="Name of the publisher of the expansion profile", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="version", path="ExpansionProfile.version", description="The version identifier of the expansion profile", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ExpansionProfile() {
    }

    public ExpansionProfile(Enumeration<Enumerations.ConformanceResourceStatus> status) {
        this.status = status;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public ExpansionProfile setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public ExpansionProfile setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ExpansionProfile setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public ExpansionProfile setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public ExpansionProfile setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ExpansionProfile setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ExpansionProfile setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ExpansionProfile setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public ExpansionProfile setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public ExpansionProfile setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public ExpansionProfile setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public ExpansionProfile setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public ExpansionProfile setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ExpansionProfileContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ExpansionProfileContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ExpansionProfileContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExpansionProfileContactComponent addContact() {
        ExpansionProfileContactComponent t = new ExpansionProfileContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<ExpansionProfileContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public ExpansionProfile addContact(ExpansionProfileContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ExpansionProfileContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ExpansionProfile setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ExpansionProfile setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ExpansionProfile setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ExpansionProfile setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public ExpansionProfileCodeSystemComponent getCodeSystem() {
        if (this.codeSystem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.codeSystem");
            }
            if (Configuration.doAutoCreate()) {
                this.codeSystem = new ExpansionProfileCodeSystemComponent();
            }
        }
        return this.codeSystem;
    }

    public boolean hasCodeSystem() {
        return this.codeSystem != null && !this.codeSystem.isEmpty();
    }

    public ExpansionProfile setCodeSystem(ExpansionProfileCodeSystemComponent value) {
        this.codeSystem = value;
        return this;
    }

    public BooleanType getIncludeDesignationsElement() {
        if (this.includeDesignations == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.includeDesignations");
            }
            if (Configuration.doAutoCreate()) {
                this.includeDesignations = new BooleanType();
            }
        }
        return this.includeDesignations;
    }

    public boolean hasIncludeDesignationsElement() {
        return this.includeDesignations != null && !this.includeDesignations.isEmpty();
    }

    public boolean hasIncludeDesignations() {
        return this.includeDesignations != null && !this.includeDesignations.isEmpty();
    }

    public ExpansionProfile setIncludeDesignationsElement(BooleanType value) {
        this.includeDesignations = value;
        return this;
    }

    public boolean getIncludeDesignations() {
        return this.includeDesignations == null || this.includeDesignations.isEmpty() ? false : (Boolean)this.includeDesignations.getValue();
    }

    public ExpansionProfile setIncludeDesignations(boolean value) {
        if (this.includeDesignations == null) {
            this.includeDesignations = new BooleanType();
        }
        this.includeDesignations.setValue((Object)value);
        return this;
    }

    public ExpansionProfileDesignationComponent getDesignation() {
        if (this.designation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.designation");
            }
            if (Configuration.doAutoCreate()) {
                this.designation = new ExpansionProfileDesignationComponent();
            }
        }
        return this.designation;
    }

    public boolean hasDesignation() {
        return this.designation != null && !this.designation.isEmpty();
    }

    public ExpansionProfile setDesignation(ExpansionProfileDesignationComponent value) {
        this.designation = value;
        return this;
    }

    public BooleanType getIncludeDefinitionElement() {
        if (this.includeDefinition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.includeDefinition");
            }
            if (Configuration.doAutoCreate()) {
                this.includeDefinition = new BooleanType();
            }
        }
        return this.includeDefinition;
    }

    public boolean hasIncludeDefinitionElement() {
        return this.includeDefinition != null && !this.includeDefinition.isEmpty();
    }

    public boolean hasIncludeDefinition() {
        return this.includeDefinition != null && !this.includeDefinition.isEmpty();
    }

    public ExpansionProfile setIncludeDefinitionElement(BooleanType value) {
        this.includeDefinition = value;
        return this;
    }

    public boolean getIncludeDefinition() {
        return this.includeDefinition == null || this.includeDefinition.isEmpty() ? false : (Boolean)this.includeDefinition.getValue();
    }

    public ExpansionProfile setIncludeDefinition(boolean value) {
        if (this.includeDefinition == null) {
            this.includeDefinition = new BooleanType();
        }
        this.includeDefinition.setValue((Object)value);
        return this;
    }

    public BooleanType getIncludeInactiveElement() {
        if (this.includeInactive == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.includeInactive");
            }
            if (Configuration.doAutoCreate()) {
                this.includeInactive = new BooleanType();
            }
        }
        return this.includeInactive;
    }

    public boolean hasIncludeInactiveElement() {
        return this.includeInactive != null && !this.includeInactive.isEmpty();
    }

    public boolean hasIncludeInactive() {
        return this.includeInactive != null && !this.includeInactive.isEmpty();
    }

    public ExpansionProfile setIncludeInactiveElement(BooleanType value) {
        this.includeInactive = value;
        return this;
    }

    public boolean getIncludeInactive() {
        return this.includeInactive == null || this.includeInactive.isEmpty() ? false : (Boolean)this.includeInactive.getValue();
    }

    public ExpansionProfile setIncludeInactive(boolean value) {
        if (this.includeInactive == null) {
            this.includeInactive = new BooleanType();
        }
        this.includeInactive.setValue((Object)value);
        return this;
    }

    public BooleanType getExcludeNestedElement() {
        if (this.excludeNested == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.excludeNested");
            }
            if (Configuration.doAutoCreate()) {
                this.excludeNested = new BooleanType();
            }
        }
        return this.excludeNested;
    }

    public boolean hasExcludeNestedElement() {
        return this.excludeNested != null && !this.excludeNested.isEmpty();
    }

    public boolean hasExcludeNested() {
        return this.excludeNested != null && !this.excludeNested.isEmpty();
    }

    public ExpansionProfile setExcludeNestedElement(BooleanType value) {
        this.excludeNested = value;
        return this;
    }

    public boolean getExcludeNested() {
        return this.excludeNested == null || this.excludeNested.isEmpty() ? false : (Boolean)this.excludeNested.getValue();
    }

    public ExpansionProfile setExcludeNested(boolean value) {
        if (this.excludeNested == null) {
            this.excludeNested = new BooleanType();
        }
        this.excludeNested.setValue((Object)value);
        return this;
    }

    public BooleanType getExcludeNotForUIElement() {
        if (this.excludeNotForUI == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.excludeNotForUI");
            }
            if (Configuration.doAutoCreate()) {
                this.excludeNotForUI = new BooleanType();
            }
        }
        return this.excludeNotForUI;
    }

    public boolean hasExcludeNotForUIElement() {
        return this.excludeNotForUI != null && !this.excludeNotForUI.isEmpty();
    }

    public boolean hasExcludeNotForUI() {
        return this.excludeNotForUI != null && !this.excludeNotForUI.isEmpty();
    }

    public ExpansionProfile setExcludeNotForUIElement(BooleanType value) {
        this.excludeNotForUI = value;
        return this;
    }

    public boolean getExcludeNotForUI() {
        return this.excludeNotForUI == null || this.excludeNotForUI.isEmpty() ? false : (Boolean)this.excludeNotForUI.getValue();
    }

    public ExpansionProfile setExcludeNotForUI(boolean value) {
        if (this.excludeNotForUI == null) {
            this.excludeNotForUI = new BooleanType();
        }
        this.excludeNotForUI.setValue((Object)value);
        return this;
    }

    public BooleanType getExcludePostCoordinatedElement() {
        if (this.excludePostCoordinated == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.excludePostCoordinated");
            }
            if (Configuration.doAutoCreate()) {
                this.excludePostCoordinated = new BooleanType();
            }
        }
        return this.excludePostCoordinated;
    }

    public boolean hasExcludePostCoordinatedElement() {
        return this.excludePostCoordinated != null && !this.excludePostCoordinated.isEmpty();
    }

    public boolean hasExcludePostCoordinated() {
        return this.excludePostCoordinated != null && !this.excludePostCoordinated.isEmpty();
    }

    public ExpansionProfile setExcludePostCoordinatedElement(BooleanType value) {
        this.excludePostCoordinated = value;
        return this;
    }

    public boolean getExcludePostCoordinated() {
        return this.excludePostCoordinated == null || this.excludePostCoordinated.isEmpty() ? false : (Boolean)this.excludePostCoordinated.getValue();
    }

    public ExpansionProfile setExcludePostCoordinated(boolean value) {
        if (this.excludePostCoordinated == null) {
            this.excludePostCoordinated = new BooleanType();
        }
        this.excludePostCoordinated.setValue((Object)value);
        return this;
    }

    public CodeType getDisplayLanguageElement() {
        if (this.displayLanguage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.displayLanguage");
            }
            if (Configuration.doAutoCreate()) {
                this.displayLanguage = new CodeType();
            }
        }
        return this.displayLanguage;
    }

    public boolean hasDisplayLanguageElement() {
        return this.displayLanguage != null && !this.displayLanguage.isEmpty();
    }

    public boolean hasDisplayLanguage() {
        return this.displayLanguage != null && !this.displayLanguage.isEmpty();
    }

    public ExpansionProfile setDisplayLanguageElement(CodeType value) {
        this.displayLanguage = value;
        return this;
    }

    public String getDisplayLanguage() {
        return this.displayLanguage == null ? null : (String)this.displayLanguage.getValue();
    }

    public ExpansionProfile setDisplayLanguage(String value) {
        if (Utilities.noString((String)value)) {
            this.displayLanguage = null;
        } else {
            if (this.displayLanguage == null) {
                this.displayLanguage = new CodeType();
            }
            this.displayLanguage.setValue(value);
        }
        return this;
    }

    public BooleanType getLimitedExpansionElement() {
        if (this.limitedExpansion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.limitedExpansion");
            }
            if (Configuration.doAutoCreate()) {
                this.limitedExpansion = new BooleanType();
            }
        }
        return this.limitedExpansion;
    }

    public boolean hasLimitedExpansionElement() {
        return this.limitedExpansion != null && !this.limitedExpansion.isEmpty();
    }

    public boolean hasLimitedExpansion() {
        return this.limitedExpansion != null && !this.limitedExpansion.isEmpty();
    }

    public ExpansionProfile setLimitedExpansionElement(BooleanType value) {
        this.limitedExpansion = value;
        return this;
    }

    public boolean getLimitedExpansion() {
        return this.limitedExpansion == null || this.limitedExpansion.isEmpty() ? false : (Boolean)this.limitedExpansion.getValue();
    }

    public ExpansionProfile setLimitedExpansion(boolean value) {
        if (this.limitedExpansion == null) {
            this.limitedExpansion = new BooleanType();
        }
        this.limitedExpansion.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this expansion profile when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this expansion profile is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Formal identifier that is used to identify this expansion profile when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_VERSION, "string", "Used to identify this version of the expansion profile when it is referenced in a specification, model, design or instance.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name for the expansion profile.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, "code", "The status of the expansion profile.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("experimental", "boolean", "This expansion profile was authored for testing purposes (or education/evaluation/marketing), and is not intended for genuine production usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the expansion profile.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date that the expansion profile status was last changed. The date must change when the business version changes, if it does, and it must change if the status code changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A free text natural language description of the use of the expansion profile - reason for definition,  conditions of use, etc. The description may include a list of expected usages for the expansion profile and can also describe the approach taken to build the expansion profile.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("codeSystem", "", "A set of criteria that provide the constraints imposed on the value set expansion by including or excluding codes from specific code systems (or versions).", 0, Integer.MAX_VALUE, this.codeSystem));
        childrenList.add(new Property("includeDesignations", "boolean", "Controls whether concept designations are to be included or excluded in value set expansions.", 0, Integer.MAX_VALUE, this.includeDesignations));
        childrenList.add(new Property("designation", "", "A set of criteria that provide the constraints imposed on the value set expansion by including or excluding designations.", 0, Integer.MAX_VALUE, this.designation));
        childrenList.add(new Property("includeDefinition", "boolean", "Controls whether the value set definition is included or excluded in value set expansions.", 0, Integer.MAX_VALUE, this.includeDefinition));
        childrenList.add(new Property("includeInactive", "boolean", "Controls whether inactive concepts are included or excluded in value set expansions.", 0, Integer.MAX_VALUE, this.includeInactive));
        childrenList.add(new Property("excludeNested", "boolean", "Controls whether or not the value set expansion includes nested codes (i.e. ValueSet.expansion.contains.contains).", 0, Integer.MAX_VALUE, this.excludeNested));
        childrenList.add(new Property("excludeNotForUI", "boolean", "Controls whether or not the value set expansion includes codes which cannot be displayed in user interfaces.", 0, Integer.MAX_VALUE, this.excludeNotForUI));
        childrenList.add(new Property("excludePostCoordinated", "boolean", "Controls whether or not the value set expansion includes post coordinated codes.", 0, Integer.MAX_VALUE, this.excludePostCoordinated));
        childrenList.add(new Property("displayLanguage", "code", "Specifies the language to be used for description in the expansions i.e. the language to be used for ValueSet.expansion.contains.display.", 0, Integer.MAX_VALUE, this.displayLanguage));
        childrenList.add(new Property("limitedExpansion", "boolean", "If the value set being expanded is incomplete (because it is too big to expand), return a limited expansion (a subset) with an indicator that expansion is incomplete.", 0, Integer.MAX_VALUE, this.limitedExpansion));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -916511108: {
                Base[] baseArray;
                if (this.codeSystem == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.codeSystem;
                }
                return baseArray;
            }
            case 461507620: {
                Base[] baseArray;
                if (this.includeDesignations == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.includeDesignations;
                }
                return baseArray;
            }
            case -900931593: {
                Base[] baseArray;
                if (this.designation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.designation;
                }
                return baseArray;
            }
            case 127972379: {
                Base[] baseArray;
                if (this.includeDefinition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.includeDefinition;
                }
                return baseArray;
            }
            case 1634790707: {
                Base[] baseArray;
                if (this.includeInactive == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.includeInactive;
                }
                return baseArray;
            }
            case 424992625: {
                Base[] baseArray;
                if (this.excludeNested == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.excludeNested;
                }
                return baseArray;
            }
            case 667582980: {
                Base[] baseArray;
                if (this.excludeNotForUI == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.excludeNotForUI;
                }
                return baseArray;
            }
            case 563335154: {
                Base[] baseArray;
                if (this.excludePostCoordinated == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.excludePostCoordinated;
                }
                return baseArray;
            }
            case 1486237242: {
                Base[] baseArray;
                if (this.displayLanguage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.displayLanguage;
                }
                return baseArray;
            }
            case 597771333: {
                Base[] baseArray;
                if (this.limitedExpansion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.limitedExpansion;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((ExpansionProfileContactComponent)value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -916511108: {
                this.codeSystem = (ExpansionProfileCodeSystemComponent)value;
                break;
            }
            case 461507620: {
                this.includeDesignations = this.castToBoolean(value);
                break;
            }
            case -900931593: {
                this.designation = (ExpansionProfileDesignationComponent)value;
                break;
            }
            case 127972379: {
                this.includeDefinition = this.castToBoolean(value);
                break;
            }
            case 1634790707: {
                this.includeInactive = this.castToBoolean(value);
                break;
            }
            case 424992625: {
                this.excludeNested = this.castToBoolean(value);
                break;
            }
            case 667582980: {
                this.excludeNotForUI = this.castToBoolean(value);
                break;
            }
            case 563335154: {
                this.excludePostCoordinated = this.castToBoolean(value);
                break;
            }
            case 1486237242: {
                this.displayLanguage = this.castToCode(value);
                break;
            }
            case 597771333: {
                this.limitedExpansion = this.castToBoolean(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((ExpansionProfileContactComponent)value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("codeSystem")) {
            this.codeSystem = (ExpansionProfileCodeSystemComponent)value;
        } else if (name.equals("includeDesignations")) {
            this.includeDesignations = this.castToBoolean(value);
        } else if (name.equals("designation")) {
            this.designation = (ExpansionProfileDesignationComponent)value;
        } else if (name.equals("includeDefinition")) {
            this.includeDefinition = this.castToBoolean(value);
        } else if (name.equals("includeInactive")) {
            this.includeInactive = this.castToBoolean(value);
        } else if (name.equals("excludeNested")) {
            this.excludeNested = this.castToBoolean(value);
        } else if (name.equals("excludeNotForUI")) {
            this.excludeNotForUI = this.castToBoolean(value);
        } else if (name.equals("excludePostCoordinated")) {
            this.excludePostCoordinated = this.castToBoolean(value);
        } else if (name.equals("displayLanguage")) {
            this.displayLanguage = this.castToCode(value);
        } else if (name.equals("limitedExpansion")) {
            this.limitedExpansion = this.castToBoolean(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -916511108: {
                return this.getCodeSystem();
            }
            case 461507620: {
                throw new FHIRException("Cannot make property includeDesignations as it is not a complex type");
            }
            case -900931593: {
                return this.getDesignation();
            }
            case 127972379: {
                throw new FHIRException("Cannot make property includeDefinition as it is not a complex type");
            }
            case 1634790707: {
                throw new FHIRException("Cannot make property includeInactive as it is not a complex type");
            }
            case 424992625: {
                throw new FHIRException("Cannot make property excludeNested as it is not a complex type");
            }
            case 667582980: {
                throw new FHIRException("Cannot make property excludeNotForUI as it is not a complex type");
            }
            case 563335154: {
                throw new FHIRException("Cannot make property excludePostCoordinated as it is not a complex type");
            }
            case 1486237242: {
                throw new FHIRException("Cannot make property displayLanguage as it is not a complex type");
            }
            case 597771333: {
                throw new FHIRException("Cannot make property limitedExpansion as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.experimental");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.date");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.description");
        }
        if (name.equals("codeSystem")) {
            this.codeSystem = new ExpansionProfileCodeSystemComponent();
            return this.codeSystem;
        }
        if (name.equals("includeDesignations")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.includeDesignations");
        }
        if (name.equals("designation")) {
            this.designation = new ExpansionProfileDesignationComponent();
            return this.designation;
        }
        if (name.equals("includeDefinition")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.includeDefinition");
        }
        if (name.equals("includeInactive")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.includeInactive");
        }
        if (name.equals("excludeNested")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.excludeNested");
        }
        if (name.equals("excludeNotForUI")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.excludeNotForUI");
        }
        if (name.equals("excludePostCoordinated")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.excludePostCoordinated");
        }
        if (name.equals("displayLanguage")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.displayLanguage");
        }
        if (name.equals("limitedExpansion")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.limitedExpansion");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ExpansionProfile";
    }

    @Override
    public ExpansionProfile copy() {
        ExpansionProfile dst = new ExpansionProfile();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ExpansionProfileContactComponent>();
            for (ExpansionProfileContactComponent i : this.contact) {
                dst.contact.add(i.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.codeSystem = this.codeSystem == null ? null : this.codeSystem.copy();
        dst.includeDesignations = this.includeDesignations == null ? null : this.includeDesignations.copy();
        dst.designation = this.designation == null ? null : this.designation.copy();
        dst.includeDefinition = this.includeDefinition == null ? null : this.includeDefinition.copy();
        dst.includeInactive = this.includeInactive == null ? null : this.includeInactive.copy();
        dst.excludeNested = this.excludeNested == null ? null : this.excludeNested.copy();
        dst.excludeNotForUI = this.excludeNotForUI == null ? null : this.excludeNotForUI.copy();
        dst.excludePostCoordinated = this.excludePostCoordinated == null ? null : this.excludePostCoordinated.copy();
        dst.displayLanguage = this.displayLanguage == null ? null : this.displayLanguage.copy();
        dst.limitedExpansion = this.limitedExpansion == null ? null : this.limitedExpansion.copy();
        return dst;
    }

    protected ExpansionProfile typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ExpansionProfile)) {
            return false;
        }
        ExpansionProfile o = (ExpansionProfile)other;
        return ExpansionProfile.compareDeep(this.url, o.url, true) && ExpansionProfile.compareDeep(this.identifier, o.identifier, true) && ExpansionProfile.compareDeep(this.version, o.version, true) && ExpansionProfile.compareDeep(this.name, o.name, true) && ExpansionProfile.compareDeep(this.status, o.status, true) && ExpansionProfile.compareDeep(this.experimental, o.experimental, true) && ExpansionProfile.compareDeep(this.publisher, o.publisher, true) && ExpansionProfile.compareDeep(this.contact, o.contact, true) && ExpansionProfile.compareDeep(this.date, o.date, true) && ExpansionProfile.compareDeep(this.description, o.description, true) && ExpansionProfile.compareDeep(this.codeSystem, o.codeSystem, true) && ExpansionProfile.compareDeep(this.includeDesignations, o.includeDesignations, true) && ExpansionProfile.compareDeep(this.designation, o.designation, true) && ExpansionProfile.compareDeep(this.includeDefinition, o.includeDefinition, true) && ExpansionProfile.compareDeep(this.includeInactive, o.includeInactive, true) && ExpansionProfile.compareDeep(this.excludeNested, o.excludeNested, true) && ExpansionProfile.compareDeep(this.excludeNotForUI, o.excludeNotForUI, true) && ExpansionProfile.compareDeep(this.excludePostCoordinated, o.excludePostCoordinated, true) && ExpansionProfile.compareDeep(this.displayLanguage, o.displayLanguage, true) && ExpansionProfile.compareDeep(this.limitedExpansion, o.limitedExpansion, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ExpansionProfile)) {
            return false;
        }
        ExpansionProfile o = (ExpansionProfile)other;
        return ExpansionProfile.compareValues(this.url, o.url, true) && ExpansionProfile.compareValues(this.version, o.version, true) && ExpansionProfile.compareValues(this.name, o.name, true) && ExpansionProfile.compareValues(this.status, o.status, true) && ExpansionProfile.compareValues(this.experimental, o.experimental, true) && ExpansionProfile.compareValues(this.publisher, o.publisher, true) && ExpansionProfile.compareValues(this.date, o.date, true) && ExpansionProfile.compareValues(this.description, o.description, true) && ExpansionProfile.compareValues(this.includeDesignations, o.includeDesignations, true) && ExpansionProfile.compareValues(this.includeDefinition, o.includeDefinition, true) && ExpansionProfile.compareValues(this.includeInactive, o.includeInactive, true) && ExpansionProfile.compareValues(this.excludeNested, o.excludeNested, true) && ExpansionProfile.compareValues(this.excludeNotForUI, o.excludeNotForUI, true) && ExpansionProfile.compareValues(this.excludePostCoordinated, o.excludePostCoordinated, true) && ExpansionProfile.compareValues(this.displayLanguage, o.displayLanguage, true) && ExpansionProfile.compareValues(this.limitedExpansion, o.limitedExpansion, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.codeSystem != null && !this.codeSystem.isEmpty() || this.includeDesignations != null && !this.includeDesignations.isEmpty() || this.designation != null && !this.designation.isEmpty() || this.includeDefinition != null && !this.includeDefinition.isEmpty() || this.includeInactive != null && !this.includeInactive.isEmpty() || this.excludeNested != null && !this.excludeNested.isEmpty() || this.excludeNotForUI != null && !this.excludeNotForUI.isEmpty() || this.excludePostCoordinated != null && !this.excludePostCoordinated.isEmpty() || this.displayLanguage != null && !this.displayLanguage.isEmpty() || this.limitedExpansion != null && !this.limitedExpansion.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ExpansionProfile;
    }

    @Block
    public static class ExpansionProfileContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the expansion profile.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ExpansionProfileContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ExpansionProfileContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ExpansionProfileContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ExpansionProfile.SP_NAME, "string", "The name of an individual to contact regarding the expansion profile.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ExpansionProfile.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ExpansionProfile.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public ExpansionProfileContactComponent copy() {
            ExpansionProfileContactComponent dst = new ExpansionProfileContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ExpansionProfileContactComponent)) {
                return false;
            }
            ExpansionProfileContactComponent o = (ExpansionProfileContactComponent)other;
            return ExpansionProfileContactComponent.compareDeep(this.name, o.name, true) && ExpansionProfileContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ExpansionProfileContactComponent)) {
                return false;
            }
            ExpansionProfileContactComponent o = (ExpansionProfileContactComponent)other;
            return ExpansionProfileContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.contact";
        }
    }

    @Block
    public static class ExpansionProfileCodeSystemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="include", type={}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code systems to be included", formalDefinition="Code systems to be included in value set expansions.")
        protected CodeSystemIncludeComponent include;
        @Child(name="exclude", type={}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code systems to be excluded", formalDefinition="Code systems to be excluded from value set expansions.")
        protected CodeSystemExcludeComponent exclude;
        private static final long serialVersionUID = 340558624L;

        public CodeSystemIncludeComponent getInclude() {
            if (this.include == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileCodeSystemComponent.include");
                }
                if (Configuration.doAutoCreate()) {
                    this.include = new CodeSystemIncludeComponent();
                }
            }
            return this.include;
        }

        public boolean hasInclude() {
            return this.include != null && !this.include.isEmpty();
        }

        public ExpansionProfileCodeSystemComponent setInclude(CodeSystemIncludeComponent value) {
            this.include = value;
            return this;
        }

        public CodeSystemExcludeComponent getExclude() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileCodeSystemComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new CodeSystemExcludeComponent();
                }
            }
            return this.exclude;
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public ExpansionProfileCodeSystemComponent setExclude(CodeSystemExcludeComponent value) {
            this.exclude = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("include", "", "Code systems to be included in value set expansions.", 0, Integer.MAX_VALUE, this.include));
            childrenList.add(new Property("exclude", "", "Code systems to be excluded from value set expansions.", 0, Integer.MAX_VALUE, this.exclude));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    Base[] baseArray;
                    if (this.include == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.include;
                    }
                    return baseArray;
                }
                case -1321148966: {
                    Base[] baseArray;
                    if (this.exclude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.exclude;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    this.include = (CodeSystemIncludeComponent)value;
                    break;
                }
                case -1321148966: {
                    this.exclude = (CodeSystemExcludeComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("include")) {
                this.include = (CodeSystemIncludeComponent)value;
            } else if (name.equals("exclude")) {
                this.exclude = (CodeSystemExcludeComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    return this.getInclude();
                }
                case -1321148966: {
                    return this.getExclude();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("include")) {
                this.include = new CodeSystemIncludeComponent();
                return this.include;
            }
            if (name.equals("exclude")) {
                this.exclude = new CodeSystemExcludeComponent();
                return this.exclude;
            }
            return super.addChild(name);
        }

        @Override
        public ExpansionProfileCodeSystemComponent copy() {
            ExpansionProfileCodeSystemComponent dst = new ExpansionProfileCodeSystemComponent();
            this.copyValues(dst);
            dst.include = this.include == null ? null : this.include.copy();
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ExpansionProfileCodeSystemComponent)) {
                return false;
            }
            ExpansionProfileCodeSystemComponent o = (ExpansionProfileCodeSystemComponent)other;
            return ExpansionProfileCodeSystemComponent.compareDeep(this.include, o.include, true) && ExpansionProfileCodeSystemComponent.compareDeep(this.exclude, o.exclude, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ExpansionProfileCodeSystemComponent)) {
                return false;
            }
            ExpansionProfileCodeSystemComponent o = (ExpansionProfileCodeSystemComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.include != null && !this.include.isEmpty() || this.exclude != null && !this.exclude.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.codeSystem";
        }
    }

    @Block
    public static class ExpansionProfileDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="include", type={}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Designations to be included", formalDefinition="Designations to be included.")
        protected DesignationIncludeComponent include;
        @Child(name="exclude", type={}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Designations to be excluded", formalDefinition="Designations to be excluded.")
        protected DesignationExcludeComponent exclude;
        private static final long serialVersionUID = -2080476436L;

        public DesignationIncludeComponent getInclude() {
            if (this.include == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileDesignationComponent.include");
                }
                if (Configuration.doAutoCreate()) {
                    this.include = new DesignationIncludeComponent();
                }
            }
            return this.include;
        }

        public boolean hasInclude() {
            return this.include != null && !this.include.isEmpty();
        }

        public ExpansionProfileDesignationComponent setInclude(DesignationIncludeComponent value) {
            this.include = value;
            return this;
        }

        public DesignationExcludeComponent getExclude() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileDesignationComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new DesignationExcludeComponent();
                }
            }
            return this.exclude;
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public ExpansionProfileDesignationComponent setExclude(DesignationExcludeComponent value) {
            this.exclude = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("include", "", "Designations to be included.", 0, Integer.MAX_VALUE, this.include));
            childrenList.add(new Property("exclude", "", "Designations to be excluded.", 0, Integer.MAX_VALUE, this.exclude));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    Base[] baseArray;
                    if (this.include == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.include;
                    }
                    return baseArray;
                }
                case -1321148966: {
                    Base[] baseArray;
                    if (this.exclude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.exclude;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    this.include = (DesignationIncludeComponent)value;
                    break;
                }
                case -1321148966: {
                    this.exclude = (DesignationExcludeComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("include")) {
                this.include = (DesignationIncludeComponent)value;
            } else if (name.equals("exclude")) {
                this.exclude = (DesignationExcludeComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    return this.getInclude();
                }
                case -1321148966: {
                    return this.getExclude();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("include")) {
                this.include = new DesignationIncludeComponent();
                return this.include;
            }
            if (name.equals("exclude")) {
                this.exclude = new DesignationExcludeComponent();
                return this.exclude;
            }
            return super.addChild(name);
        }

        @Override
        public ExpansionProfileDesignationComponent copy() {
            ExpansionProfileDesignationComponent dst = new ExpansionProfileDesignationComponent();
            this.copyValues(dst);
            dst.include = this.include == null ? null : this.include.copy();
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ExpansionProfileDesignationComponent)) {
                return false;
            }
            ExpansionProfileDesignationComponent o = (ExpansionProfileDesignationComponent)other;
            return ExpansionProfileDesignationComponent.compareDeep(this.include, o.include, true) && ExpansionProfileDesignationComponent.compareDeep(this.exclude, o.exclude, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ExpansionProfileDesignationComponent)) {
                return false;
            }
            ExpansionProfileDesignationComponent o = (ExpansionProfileDesignationComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.include != null && !this.include.isEmpty() || this.exclude != null && !this.exclude.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation";
        }
    }

    @Block
    public static class DesignationExcludeDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human language of the designation to be excluded", formalDefinition="The language this designation is defined for.")
        protected CodeType language;
        @Child(name="use", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Designation use", formalDefinition="Designation uses for exclusion in the expansion.")
        protected Coding use;
        private static final long serialVersionUID = 242239292L;

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DesignationExcludeDesignationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public DesignationExcludeDesignationComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public DesignationExcludeDesignationComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public Coding getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DesignationExcludeDesignationComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Coding();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public DesignationExcludeDesignationComponent setUse(Coding value) {
            this.use = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("language", "code", "The language this designation is defined for.", 0, Integer.MAX_VALUE, this.language));
            childrenList.add(new Property("use", "Coding", "Designation uses for exclusion in the expansion.", 0, Integer.MAX_VALUE, this.use));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = this.castToCode(value);
                    break;
                }
                case 116103: {
                    this.use = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = this.castToCode(value);
            } else if (name.equals("use")) {
                this.use = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    throw new FHIRException("Cannot make property language as it is not a complex type");
                }
                case 116103: {
                    return this.getUse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.language");
            }
            if (name.equals("use")) {
                this.use = new Coding();
                return this.use;
            }
            return super.addChild(name);
        }

        @Override
        public DesignationExcludeDesignationComponent copy() {
            DesignationExcludeDesignationComponent dst = new DesignationExcludeDesignationComponent();
            this.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.use = this.use == null ? null : this.use.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DesignationExcludeDesignationComponent)) {
                return false;
            }
            DesignationExcludeDesignationComponent o = (DesignationExcludeDesignationComponent)other;
            return DesignationExcludeDesignationComponent.compareDeep(this.language, o.language, true) && DesignationExcludeDesignationComponent.compareDeep(this.use, o.use, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DesignationExcludeDesignationComponent)) {
                return false;
            }
            DesignationExcludeDesignationComponent o = (DesignationExcludeDesignationComponent)other;
            return DesignationExcludeDesignationComponent.compareValues(this.language, o.language, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.language != null && !this.language.isEmpty() || this.use != null && !this.use.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation.exclude.designation";
        }
    }

    @Block
    public static class DesignationExcludeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="designation", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The designation to be excluded", formalDefinition="A data group for each designation to be excluded.")
        protected List<DesignationExcludeDesignationComponent> designation;
        private static final long serialVersionUID = 1045849752L;

        public List<DesignationExcludeDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationExcludeDesignationComponent>();
            }
            return this.designation;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (DesignationExcludeDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DesignationExcludeDesignationComponent addDesignation() {
            DesignationExcludeDesignationComponent t = new DesignationExcludeDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationExcludeDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public DesignationExcludeComponent addDesignation(DesignationExcludeDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationExcludeDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("designation", "", "A data group for each designation to be excluded.", 0, Integer.MAX_VALUE, this.designation));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    this.getDesignation().add((DesignationExcludeDesignationComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("designation")) {
                this.getDesignation().add((DesignationExcludeDesignationComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return this.addDesignation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            return super.addChild(name);
        }

        @Override
        public DesignationExcludeComponent copy() {
            DesignationExcludeComponent dst = new DesignationExcludeComponent();
            this.copyValues(dst);
            if (this.designation != null) {
                dst.designation = new ArrayList<DesignationExcludeDesignationComponent>();
                for (DesignationExcludeDesignationComponent i : this.designation) {
                    dst.designation.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DesignationExcludeComponent)) {
                return false;
            }
            DesignationExcludeComponent o = (DesignationExcludeComponent)other;
            return DesignationExcludeComponent.compareDeep(this.designation, o.designation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DesignationExcludeComponent)) {
                return false;
            }
            DesignationExcludeComponent o = (DesignationExcludeComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.designation == null || this.designation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation.exclude";
        }
    }

    @Block
    public static class DesignationIncludeDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human language of the designation to be included", formalDefinition="The language this designation is defined for.")
        protected CodeType language;
        @Child(name="use", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Designation use", formalDefinition="Designation uses for inclusion in the expansion.")
        protected Coding use;
        private static final long serialVersionUID = 242239292L;

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DesignationIncludeDesignationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public DesignationIncludeDesignationComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public DesignationIncludeDesignationComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public Coding getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DesignationIncludeDesignationComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Coding();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public DesignationIncludeDesignationComponent setUse(Coding value) {
            this.use = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("language", "code", "The language this designation is defined for.", 0, Integer.MAX_VALUE, this.language));
            childrenList.add(new Property("use", "Coding", "Designation uses for inclusion in the expansion.", 0, Integer.MAX_VALUE, this.use));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = this.castToCode(value);
                    break;
                }
                case 116103: {
                    this.use = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = this.castToCode(value);
            } else if (name.equals("use")) {
                this.use = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    throw new FHIRException("Cannot make property language as it is not a complex type");
                }
                case 116103: {
                    return this.getUse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.language");
            }
            if (name.equals("use")) {
                this.use = new Coding();
                return this.use;
            }
            return super.addChild(name);
        }

        @Override
        public DesignationIncludeDesignationComponent copy() {
            DesignationIncludeDesignationComponent dst = new DesignationIncludeDesignationComponent();
            this.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.use = this.use == null ? null : this.use.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DesignationIncludeDesignationComponent)) {
                return false;
            }
            DesignationIncludeDesignationComponent o = (DesignationIncludeDesignationComponent)other;
            return DesignationIncludeDesignationComponent.compareDeep(this.language, o.language, true) && DesignationIncludeDesignationComponent.compareDeep(this.use, o.use, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DesignationIncludeDesignationComponent)) {
                return false;
            }
            DesignationIncludeDesignationComponent o = (DesignationIncludeDesignationComponent)other;
            return DesignationIncludeDesignationComponent.compareValues(this.language, o.language, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.language != null && !this.language.isEmpty() || this.use != null && !this.use.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation.include.designation";
        }
    }

    @Block
    public static class DesignationIncludeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="designation", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The designation to be included", formalDefinition="A data group for each designation to be included.")
        protected List<DesignationIncludeDesignationComponent> designation;
        private static final long serialVersionUID = -1989669274L;

        public List<DesignationIncludeDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationIncludeDesignationComponent>();
            }
            return this.designation;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (DesignationIncludeDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DesignationIncludeDesignationComponent addDesignation() {
            DesignationIncludeDesignationComponent t = new DesignationIncludeDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationIncludeDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public DesignationIncludeComponent addDesignation(DesignationIncludeDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationIncludeDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("designation", "", "A data group for each designation to be included.", 0, Integer.MAX_VALUE, this.designation));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    this.getDesignation().add((DesignationIncludeDesignationComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("designation")) {
                this.getDesignation().add((DesignationIncludeDesignationComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return this.addDesignation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            return super.addChild(name);
        }

        @Override
        public DesignationIncludeComponent copy() {
            DesignationIncludeComponent dst = new DesignationIncludeComponent();
            this.copyValues(dst);
            if (this.designation != null) {
                dst.designation = new ArrayList<DesignationIncludeDesignationComponent>();
                for (DesignationIncludeDesignationComponent i : this.designation) {
                    dst.designation.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DesignationIncludeComponent)) {
                return false;
            }
            DesignationIncludeComponent o = (DesignationIncludeComponent)other;
            return DesignationIncludeComponent.compareDeep(this.designation, o.designation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DesignationIncludeComponent)) {
                return false;
            }
            DesignationIncludeComponent o = (DesignationIncludeComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.designation == null || this.designation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation.include";
        }
    }

    @Block
    public static class CodeSystemExcludeCodeSystemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specific code system to be excluded", formalDefinition="An absolute URI which is the code system to be excluded.")
        protected UriType system;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific version of the code system referred to", formalDefinition="The version of the code system from which codes in the expansion should be excluded.")
        protected StringType version;
        private static final long serialVersionUID = 1145288774L;

        public CodeSystemExcludeCodeSystemComponent() {
        }

        public CodeSystemExcludeCodeSystemComponent(UriType system) {
            this.system = system;
        }

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemExcludeCodeSystemComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public CodeSystemExcludeCodeSystemComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public CodeSystemExcludeCodeSystemComponent setSystem(String value) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemExcludeCodeSystemComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public CodeSystemExcludeCodeSystemComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public CodeSystemExcludeCodeSystemComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("system", "uri", "An absolute URI which is the code system to be excluded.", 0, Integer.MAX_VALUE, this.system));
            childrenList.add(new Property(ExpansionProfile.SP_VERSION, "string", "The version of the code system from which codes in the expansion should be excluded.", 0, Integer.MAX_VALUE, this.version));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.system;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    this.system = this.castToUri(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = this.castToUri(value);
            } else if (name.equals(ExpansionProfile.SP_VERSION)) {
                this.version = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    throw new FHIRException("Cannot make property system as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.system");
            }
            if (name.equals(ExpansionProfile.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.version");
            }
            return super.addChild(name);
        }

        @Override
        public CodeSystemExcludeCodeSystemComponent copy() {
            CodeSystemExcludeCodeSystemComponent dst = new CodeSystemExcludeCodeSystemComponent();
            this.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            dst.version = this.version == null ? null : this.version.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemExcludeCodeSystemComponent)) {
                return false;
            }
            CodeSystemExcludeCodeSystemComponent o = (CodeSystemExcludeCodeSystemComponent)other;
            return CodeSystemExcludeCodeSystemComponent.compareDeep(this.system, o.system, true) && CodeSystemExcludeCodeSystemComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemExcludeCodeSystemComponent)) {
                return false;
            }
            CodeSystemExcludeCodeSystemComponent o = (CodeSystemExcludeCodeSystemComponent)other;
            return CodeSystemExcludeCodeSystemComponent.compareValues(this.system, o.system, true) && CodeSystemExcludeCodeSystemComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.system != null && !this.system.isEmpty() || this.version != null && !this.version.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.codeSystem.exclude.codeSystem";
        }
    }

    @Block
    public static class CodeSystemExcludeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="codeSystem", type={}, order=1, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The code systems to be excluded", formalDefinition="A data group for each code system to be excluded.")
        protected List<CodeSystemExcludeCodeSystemComponent> codeSystem;
        private static final long serialVersionUID = 1960514347L;

        public List<CodeSystemExcludeCodeSystemComponent> getCodeSystem() {
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<CodeSystemExcludeCodeSystemComponent>();
            }
            return this.codeSystem;
        }

        public boolean hasCodeSystem() {
            if (this.codeSystem == null) {
                return false;
            }
            for (CodeSystemExcludeCodeSystemComponent item : this.codeSystem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeSystemExcludeCodeSystemComponent addCodeSystem() {
            CodeSystemExcludeCodeSystemComponent t = new CodeSystemExcludeCodeSystemComponent();
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<CodeSystemExcludeCodeSystemComponent>();
            }
            this.codeSystem.add(t);
            return t;
        }

        public CodeSystemExcludeComponent addCodeSystem(CodeSystemExcludeCodeSystemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<CodeSystemExcludeCodeSystemComponent>();
            }
            this.codeSystem.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("codeSystem", "", "A data group for each code system to be excluded.", 0, Integer.MAX_VALUE, this.codeSystem));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -916511108: {
                    return this.codeSystem == null ? new Base[]{} : this.codeSystem.toArray(new Base[this.codeSystem.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -916511108: {
                    this.getCodeSystem().add((CodeSystemExcludeCodeSystemComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("codeSystem")) {
                this.getCodeSystem().add((CodeSystemExcludeCodeSystemComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -916511108: {
                    return this.addCodeSystem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("codeSystem")) {
                return this.addCodeSystem();
            }
            return super.addChild(name);
        }

        @Override
        public CodeSystemExcludeComponent copy() {
            CodeSystemExcludeComponent dst = new CodeSystemExcludeComponent();
            this.copyValues(dst);
            if (this.codeSystem != null) {
                dst.codeSystem = new ArrayList<CodeSystemExcludeCodeSystemComponent>();
                for (CodeSystemExcludeCodeSystemComponent i : this.codeSystem) {
                    dst.codeSystem.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemExcludeComponent)) {
                return false;
            }
            CodeSystemExcludeComponent o = (CodeSystemExcludeComponent)other;
            return CodeSystemExcludeComponent.compareDeep(this.codeSystem, o.codeSystem, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemExcludeComponent)) {
                return false;
            }
            CodeSystemExcludeComponent o = (CodeSystemExcludeComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.codeSystem == null || this.codeSystem.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.codeSystem.exclude";
        }
    }

    @Block
    public static class CodeSystemIncludeCodeSystemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specific code system to be included", formalDefinition="An absolute URI which is the code system to be included.")
        protected UriType system;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific version of the code system referred to", formalDefinition="The version of the code system from which codes in the expansion should be included.")
        protected StringType version;
        private static final long serialVersionUID = 1145288774L;

        public CodeSystemIncludeCodeSystemComponent() {
        }

        public CodeSystemIncludeCodeSystemComponent(UriType system) {
            this.system = system;
        }

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemIncludeCodeSystemComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public CodeSystemIncludeCodeSystemComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public CodeSystemIncludeCodeSystemComponent setSystem(String value) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemIncludeCodeSystemComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public CodeSystemIncludeCodeSystemComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public CodeSystemIncludeCodeSystemComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("system", "uri", "An absolute URI which is the code system to be included.", 0, Integer.MAX_VALUE, this.system));
            childrenList.add(new Property(ExpansionProfile.SP_VERSION, "string", "The version of the code system from which codes in the expansion should be included.", 0, Integer.MAX_VALUE, this.version));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.system;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    this.system = this.castToUri(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = this.castToUri(value);
            } else if (name.equals(ExpansionProfile.SP_VERSION)) {
                this.version = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    throw new FHIRException("Cannot make property system as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.system");
            }
            if (name.equals(ExpansionProfile.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.version");
            }
            return super.addChild(name);
        }

        @Override
        public CodeSystemIncludeCodeSystemComponent copy() {
            CodeSystemIncludeCodeSystemComponent dst = new CodeSystemIncludeCodeSystemComponent();
            this.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            dst.version = this.version == null ? null : this.version.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemIncludeCodeSystemComponent)) {
                return false;
            }
            CodeSystemIncludeCodeSystemComponent o = (CodeSystemIncludeCodeSystemComponent)other;
            return CodeSystemIncludeCodeSystemComponent.compareDeep(this.system, o.system, true) && CodeSystemIncludeCodeSystemComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemIncludeCodeSystemComponent)) {
                return false;
            }
            CodeSystemIncludeCodeSystemComponent o = (CodeSystemIncludeCodeSystemComponent)other;
            return CodeSystemIncludeCodeSystemComponent.compareValues(this.system, o.system, true) && CodeSystemIncludeCodeSystemComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.system != null && !this.system.isEmpty() || this.version != null && !this.version.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.codeSystem.include.codeSystem";
        }
    }

    @Block
    public static class CodeSystemIncludeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="codeSystem", type={}, order=1, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The code systems to be included", formalDefinition="A data group for each code system to be included.")
        protected List<CodeSystemIncludeCodeSystemComponent> codeSystem;
        private static final long serialVersionUID = 1076909689L;

        public List<CodeSystemIncludeCodeSystemComponent> getCodeSystem() {
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<CodeSystemIncludeCodeSystemComponent>();
            }
            return this.codeSystem;
        }

        public boolean hasCodeSystem() {
            if (this.codeSystem == null) {
                return false;
            }
            for (CodeSystemIncludeCodeSystemComponent item : this.codeSystem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeSystemIncludeCodeSystemComponent addCodeSystem() {
            CodeSystemIncludeCodeSystemComponent t = new CodeSystemIncludeCodeSystemComponent();
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<CodeSystemIncludeCodeSystemComponent>();
            }
            this.codeSystem.add(t);
            return t;
        }

        public CodeSystemIncludeComponent addCodeSystem(CodeSystemIncludeCodeSystemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<CodeSystemIncludeCodeSystemComponent>();
            }
            this.codeSystem.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("codeSystem", "", "A data group for each code system to be included.", 0, Integer.MAX_VALUE, this.codeSystem));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -916511108: {
                    return this.codeSystem == null ? new Base[]{} : this.codeSystem.toArray(new Base[this.codeSystem.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -916511108: {
                    this.getCodeSystem().add((CodeSystemIncludeCodeSystemComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("codeSystem")) {
                this.getCodeSystem().add((CodeSystemIncludeCodeSystemComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -916511108: {
                    return this.addCodeSystem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("codeSystem")) {
                return this.addCodeSystem();
            }
            return super.addChild(name);
        }

        @Override
        public CodeSystemIncludeComponent copy() {
            CodeSystemIncludeComponent dst = new CodeSystemIncludeComponent();
            this.copyValues(dst);
            if (this.codeSystem != null) {
                dst.codeSystem = new ArrayList<CodeSystemIncludeCodeSystemComponent>();
                for (CodeSystemIncludeCodeSystemComponent i : this.codeSystem) {
                    dst.codeSystem.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemIncludeComponent)) {
                return false;
            }
            CodeSystemIncludeComponent o = (CodeSystemIncludeComponent)other;
            return CodeSystemIncludeComponent.compareDeep(this.codeSystem, o.codeSystem, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemIncludeComponent)) {
                return false;
            }
            CodeSystemIncludeComponent o = (CodeSystemIncludeComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.codeSystem == null || this.codeSystem.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.codeSystem.include";
        }
    }
}

