/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="NamingSystem", profile="http://hl7.org/fhir/Profile/NamingSystem")
public class NamingSystem
extends DomainResource {
    @Child(name="name", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Human-readable label", formalDefinition="The descriptive name of this particular identifier type or code system.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=false)
    @Description(shortDefinition="draft | active | retired", formalDefinition="Indicates whether the naming system is \"ready for use\" or not.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="kind", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="codesystem | identifier | root", formalDefinition="Indicates the purpose for the naming system - what kinds of things does it make unique?")
    protected Enumeration<NamingSystemType> kind;
    @Child(name="date", type={DateTimeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Publication Date(/time)", formalDefinition="The date  (and optionally time) when the system was registered or published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the registration changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the naming system.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<NamingSystemContactComponent> contact;
    @Child(name="responsible", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who maintains system namespace?", formalDefinition="The name of the organization that is responsible for issuing identifiers or codes for this namespace and ensuring their non-collision.")
    protected StringType responsible;
    @Child(name="type", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="e.g. driver,  provider,  patient, bank etc.", formalDefinition="Categorizes a naming system for easier search by grouping related naming systems.")
    protected CodeableConcept type;
    @Child(name="description", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What does naming system identify?", formalDefinition="Details about what the namespace identifies including scope, granularity, version labeling, etc.")
    protected StringType description;
    @Child(name="useContext", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of naming systems.")
    protected List<CodeableConcept> useContext;
    @Child(name="usage", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How/where is it used", formalDefinition="Provides guidance on the use of the namespace, including the handling of formatting characters, use of upper vs. lower case, etc.")
    protected StringType usage;
    @Child(name="uniqueId", type={}, order=11, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Unique identifiers used for system", formalDefinition="Indicates how the system may be identified when referenced in electronic exchange.")
    protected List<NamingSystemUniqueIdComponent> uniqueId;
    @Child(name="replacedBy", type={NamingSystem.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use this instead", formalDefinition="For naming systems that are retired, indicates the naming system that should be used in their place (if any).")
    protected Reference replacedBy;
    protected NamingSystem replacedByTarget;
    private static final long serialVersionUID = -1633030631L;
    @SearchParamDefinition(name="responsible", path="NamingSystem.responsible", description="Who maintains system namespace?", type="string")
    public static final String SP_RESPONSIBLE = "responsible";
    public static final StringClientParam RESPONSIBLE = new StringClientParam("responsible");
    @SearchParamDefinition(name="status", path="NamingSystem.status", description="draft | active | retired", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="type", path="NamingSystem.type", description="e.g. driver,  provider,  patient, bank etc.", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="date", path="NamingSystem.date", description="Publication Date(/time)", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="period", path="NamingSystem.uniqueId.period", description="When is identifier valid?", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="contact", path="NamingSystem.contact.name", description="Name of an individual to contact", type="string")
    public static final String SP_CONTACT = "contact";
    public static final StringClientParam CONTACT = new StringClientParam("contact");
    @SearchParamDefinition(name="kind", path="NamingSystem.kind", description="codesystem | identifier | root", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="publisher", path="NamingSystem.publisher", description="Name of the publisher (Organization or individual)", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="id-type", path="NamingSystem.uniqueId.type", description="oid | uuid | uri | other", type="token")
    public static final String SP_ID_TYPE = "id-type";
    public static final TokenClientParam ID_TYPE = new TokenClientParam("id-type");
    @SearchParamDefinition(name="name", path="NamingSystem.name", description="Human-readable label", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="NamingSystem.useContext", description="Content intends to support these contexts", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="value", path="NamingSystem.uniqueId.value", description="The unique identifier", type="string")
    public static final String SP_VALUE = "value";
    public static final StringClientParam VALUE = new StringClientParam("value");
    @SearchParamDefinition(name="telecom", path="NamingSystem.contact.telecom", description="Contact details for individual or publisher", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="replaced-by", path="NamingSystem.replacedBy", description="Use this instead", type="reference")
    public static final String SP_REPLACED_BY = "replaced-by";
    public static final ReferenceClientParam REPLACED_BY = new ReferenceClientParam("replaced-by");
    public static final Include INCLUDE_REPLACED_BY = new Include("NamingSystem:replaced-by").toLocked();

    public NamingSystem() {
    }

    public NamingSystem(StringType name, Enumeration<Enumerations.ConformanceResourceStatus> status, Enumeration<NamingSystemType> kind, DateTimeType date) {
        this.name = name;
        this.status = status;
        this.kind = kind;
        this.date = date;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public NamingSystem setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public NamingSystem setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public NamingSystem setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public NamingSystem setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<NamingSystemType> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<NamingSystemType>(new NamingSystemTypeEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public NamingSystem setKindElement(Enumeration<NamingSystemType> value) {
        this.kind = value;
        return this;
    }

    public NamingSystemType getKind() {
        return this.kind == null ? null : (NamingSystemType)((Object)this.kind.getValue());
    }

    public NamingSystem setKind(NamingSystemType value) {
        if (this.kind == null) {
            this.kind = new Enumeration<NamingSystemType>(new NamingSystemTypeEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public NamingSystem setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public NamingSystem setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public NamingSystem setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public NamingSystem setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<NamingSystemContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<NamingSystemContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (NamingSystemContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NamingSystemContactComponent addContact() {
        NamingSystemContactComponent t = new NamingSystemContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<NamingSystemContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public NamingSystem addContact(NamingSystemContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<NamingSystemContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public StringType getResponsibleElement() {
        if (this.responsible == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.responsible");
            }
            if (Configuration.doAutoCreate()) {
                this.responsible = new StringType();
            }
        }
        return this.responsible;
    }

    public boolean hasResponsibleElement() {
        return this.responsible != null && !this.responsible.isEmpty();
    }

    public boolean hasResponsible() {
        return this.responsible != null && !this.responsible.isEmpty();
    }

    public NamingSystem setResponsibleElement(StringType value) {
        this.responsible = value;
        return this;
    }

    public String getResponsible() {
        return this.responsible == null ? null : (String)this.responsible.getValue();
    }

    public NamingSystem setResponsible(String value) {
        if (Utilities.noString((String)value)) {
            this.responsible = null;
        } else {
            if (this.responsible == null) {
                this.responsible = new StringType();
            }
            this.responsible.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public NamingSystem setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public NamingSystem setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public NamingSystem setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public NamingSystem addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public NamingSystem setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public NamingSystem setUsage(String value) {
        if (Utilities.noString((String)value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    public List<NamingSystemUniqueIdComponent> getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = new ArrayList<NamingSystemUniqueIdComponent>();
        }
        return this.uniqueId;
    }

    public boolean hasUniqueId() {
        if (this.uniqueId == null) {
            return false;
        }
        for (NamingSystemUniqueIdComponent item : this.uniqueId) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NamingSystemUniqueIdComponent addUniqueId() {
        NamingSystemUniqueIdComponent t = new NamingSystemUniqueIdComponent();
        if (this.uniqueId == null) {
            this.uniqueId = new ArrayList<NamingSystemUniqueIdComponent>();
        }
        this.uniqueId.add(t);
        return t;
    }

    public NamingSystem addUniqueId(NamingSystemUniqueIdComponent t) {
        if (t == null) {
            return this;
        }
        if (this.uniqueId == null) {
            this.uniqueId = new ArrayList<NamingSystemUniqueIdComponent>();
        }
        this.uniqueId.add(t);
        return this;
    }

    public Reference getReplacedBy() {
        if (this.replacedBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.replacedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.replacedBy = new Reference();
            }
        }
        return this.replacedBy;
    }

    public boolean hasReplacedBy() {
        return this.replacedBy != null && !this.replacedBy.isEmpty();
    }

    public NamingSystem setReplacedBy(Reference value) {
        this.replacedBy = value;
        return this;
    }

    public NamingSystem getReplacedByTarget() {
        if (this.replacedByTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.replacedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.replacedByTarget = new NamingSystem();
            }
        }
        return this.replacedByTarget;
    }

    public NamingSystem setReplacedByTarget(NamingSystem value) {
        this.replacedByTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_NAME, "string", "The descriptive name of this particular identifier type or code system.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, "code", "Indicates whether the naming system is \"ready for use\" or not.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_KIND, "code", "Indicates the purpose for the naming system - what kinds of things does it make unique?", 0, Integer.MAX_VALUE, this.kind));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the system was registered or published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the registration changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the naming system.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property(SP_CONTACT, "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_RESPONSIBLE, "string", "The name of the organization that is responsible for issuing identifiers or codes for this namespace and ensuring their non-collision.", 0, Integer.MAX_VALUE, this.responsible));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "Categorizes a naming system for easier search by grouping related naming systems.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("description", "string", "Details about what the namespace identifies including scope, granularity, version labeling, etc.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of naming systems.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("usage", "string", "Provides guidance on the use of the namespace, including the handling of formatting characters, use of upper vs. lower case, etc.", 0, Integer.MAX_VALUE, this.usage));
        childrenList.add(new Property("uniqueId", "", "Indicates how the system may be identified when referenced in electronic exchange.", 0, Integer.MAX_VALUE, this.uniqueId));
        childrenList.add(new Property("replacedBy", "Reference(NamingSystem)", "For naming systems that are retired, indicates the naming system that should be used in their place (if any).", 0, Integer.MAX_VALUE, this.replacedBy));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.kind;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1847674614: {
                Base[] baseArray;
                if (this.responsible == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.responsible;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.type;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.usage;
                }
                return baseArray;
            }
            case -294460212: {
                return this.uniqueId == null ? new Base[]{} : this.uniqueId.toArray(new Base[this.uniqueId.size()]);
            }
            case -1233035097: {
                Base[] baseArray;
                if (this.replacedBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.replacedBy;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case 3292052: {
                this.kind = new NamingSystemTypeEnumFactory().fromType(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((NamingSystemContactComponent)value);
                break;
            }
            case 1847674614: {
                this.responsible = this.castToString(value);
                break;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case 111574433: {
                this.usage = this.castToString(value);
                break;
            }
            case -294460212: {
                this.getUniqueId().add((NamingSystemUniqueIdComponent)value);
                break;
            }
            case -1233035097: {
                this.replacedBy = this.castToReference(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_KIND)) {
            this.kind = new NamingSystemTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals(SP_CONTACT)) {
            this.getContact().add((NamingSystemContactComponent)value);
        } else if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = this.castToString(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("usage")) {
            this.usage = this.castToString(value);
        } else if (name.equals("uniqueId")) {
            this.getUniqueId().add((NamingSystemUniqueIdComponent)value);
        } else if (name.equals("replacedBy")) {
            this.replacedBy = this.castToReference(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3292052: {
                throw new FHIRException("Cannot make property kind as it is not a complex type");
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case 1847674614: {
                throw new FHIRException("Cannot make property responsible as it is not a complex type");
            }
            case 3575610: {
                return this.getType();
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -669707736: {
                return this.addUseContext();
            }
            case 111574433: {
                throw new FHIRException("Cannot make property usage as it is not a complex type");
            }
            case -294460212: {
                return this.addUniqueId();
            }
            case -1233035097: {
                return this.getReplacedBy();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.status");
        }
        if (name.equals(SP_KIND)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.kind");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.publisher");
        }
        if (name.equals(SP_CONTACT)) {
            return this.addContact();
        }
        if (name.equals(SP_RESPONSIBLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.responsible");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.usage");
        }
        if (name.equals("uniqueId")) {
            return this.addUniqueId();
        }
        if (name.equals("replacedBy")) {
            this.replacedBy = new Reference();
            return this.replacedBy;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "NamingSystem";
    }

    @Override
    public NamingSystem copy() {
        NamingSystem dst = new NamingSystem();
        this.copyValues(dst);
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<NamingSystemContactComponent>();
            for (NamingSystemContactComponent namingSystemContactComponent : this.contact) {
                dst.contact.add(namingSystemContactComponent.copy());
            }
        }
        dst.responsible = this.responsible == null ? null : this.responsible.copy();
        dst.type = this.type == null ? null : this.type.copy();
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        StringType stringType3 = dst.usage = this.usage == null ? null : this.usage.copy();
        if (this.uniqueId != null) {
            dst.uniqueId = new ArrayList<NamingSystemUniqueIdComponent>();
            for (NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : this.uniqueId) {
                dst.uniqueId.add(namingSystemUniqueIdComponent.copy());
            }
        }
        dst.replacedBy = this.replacedBy == null ? null : this.replacedBy.copy();
        return dst;
    }

    protected NamingSystem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof NamingSystem)) {
            return false;
        }
        NamingSystem o = (NamingSystem)other;
        return NamingSystem.compareDeep(this.name, o.name, true) && NamingSystem.compareDeep(this.status, o.status, true) && NamingSystem.compareDeep(this.kind, o.kind, true) && NamingSystem.compareDeep(this.date, o.date, true) && NamingSystem.compareDeep(this.publisher, o.publisher, true) && NamingSystem.compareDeep(this.contact, o.contact, true) && NamingSystem.compareDeep(this.responsible, o.responsible, true) && NamingSystem.compareDeep(this.type, o.type, true) && NamingSystem.compareDeep(this.description, o.description, true) && NamingSystem.compareDeep(this.useContext, o.useContext, true) && NamingSystem.compareDeep(this.usage, o.usage, true) && NamingSystem.compareDeep(this.uniqueId, o.uniqueId, true) && NamingSystem.compareDeep(this.replacedBy, o.replacedBy, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof NamingSystem)) {
            return false;
        }
        NamingSystem o = (NamingSystem)other;
        return NamingSystem.compareValues(this.name, o.name, true) && NamingSystem.compareValues(this.status, o.status, true) && NamingSystem.compareValues(this.kind, o.kind, true) && NamingSystem.compareValues(this.date, o.date, true) && NamingSystem.compareValues(this.publisher, o.publisher, true) && NamingSystem.compareValues(this.responsible, o.responsible, true) && NamingSystem.compareValues(this.description, o.description, true) && NamingSystem.compareValues(this.usage, o.usage, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.kind != null && !this.kind.isEmpty() || this.date != null && !this.date.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.responsible != null && !this.responsible.isEmpty() || this.type != null && !this.type.isEmpty() || this.description != null && !this.description.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.usage != null && !this.usage.isEmpty() || this.uniqueId != null && !this.uniqueId.isEmpty() || this.replacedBy != null && !this.replacedBy.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.NamingSystem;
    }

    public static class NamingSystemTypeEnumFactory
    implements EnumFactory<NamingSystemType> {
        @Override
        public NamingSystemType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("codesystem".equals(codeString)) {
                return NamingSystemType.CODESYSTEM;
            }
            if ("identifier".equals(codeString)) {
                return NamingSystemType.IDENTIFIER;
            }
            if ("root".equals(codeString)) {
                return NamingSystemType.ROOT;
            }
            throw new IllegalArgumentException("Unknown NamingSystemType code '" + codeString + "'");
        }

        public Enumeration<NamingSystemType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("codesystem".equals(codeString)) {
                return new Enumeration<NamingSystemType>(this, NamingSystemType.CODESYSTEM);
            }
            if ("identifier".equals(codeString)) {
                return new Enumeration<NamingSystemType>(this, NamingSystemType.IDENTIFIER);
            }
            if ("root".equals(codeString)) {
                return new Enumeration<NamingSystemType>(this, NamingSystemType.ROOT);
            }
            throw new FHIRException("Unknown NamingSystemType code '" + codeString + "'");
        }

        @Override
        public String toCode(NamingSystemType code) {
            if (code == NamingSystemType.NULL) {
                return null;
            }
            if (code == NamingSystemType.CODESYSTEM) {
                return "codesystem";
            }
            if (code == NamingSystemType.IDENTIFIER) {
                return "identifier";
            }
            if (code == NamingSystemType.ROOT) {
                return "root";
            }
            return "?";
        }

        @Override
        public String toSystem(NamingSystemType code) {
            return code.getSystem();
        }
    }

    public static enum NamingSystemType {
        CODESYSTEM,
        IDENTIFIER,
        ROOT,
        NULL;


        public static NamingSystemType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("codesystem".equals(codeString)) {
                return CODESYSTEM;
            }
            if ("identifier".equals(codeString)) {
                return IDENTIFIER;
            }
            if ("root".equals(codeString)) {
                return ROOT;
            }
            throw new FHIRException("Unknown NamingSystemType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CODESYSTEM: {
                    return "codesystem";
                }
                case IDENTIFIER: {
                    return "identifier";
                }
                case ROOT: {
                    return "root";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CODESYSTEM: {
                    return "http://hl7.org/fhir/namingsystem-type";
                }
                case IDENTIFIER: {
                    return "http://hl7.org/fhir/namingsystem-type";
                }
                case ROOT: {
                    return "http://hl7.org/fhir/namingsystem-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CODESYSTEM: {
                    return "The naming system is used to define concepts and symbols to represent those concepts; e.g. UCUM, LOINC, NDC code, local lab codes, etc.";
                }
                case IDENTIFIER: {
                    return "The naming system is used to manage identifiers (e.g. license numbers, order numbers, etc.).";
                }
                case ROOT: {
                    return "The naming system is used as the root for other identifiers and naming systems.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CODESYSTEM: {
                    return "Code System";
                }
                case IDENTIFIER: {
                    return "Identifier";
                }
                case ROOT: {
                    return "Root";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class NamingSystemContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the naming system.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public NamingSystemContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public NamingSystemContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public NamingSystemContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(NamingSystem.SP_NAME, "string", "The name of an individual to contact regarding the naming system.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(NamingSystem.SP_TELECOM, "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(NamingSystem.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(NamingSystem.SP_TELECOM)) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(NamingSystem.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.name");
            }
            if (name.equals(NamingSystem.SP_TELECOM)) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public NamingSystemContactComponent copy() {
            NamingSystemContactComponent dst = new NamingSystemContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NamingSystemContactComponent)) {
                return false;
            }
            NamingSystemContactComponent o = (NamingSystemContactComponent)other;
            return NamingSystemContactComponent.compareDeep(this.name, o.name, true) && NamingSystemContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NamingSystemContactComponent)) {
                return false;
            }
            NamingSystemContactComponent o = (NamingSystemContactComponent)other;
            return NamingSystemContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "NamingSystem.contact";
        }
    }

    @Block
    public static class NamingSystemUniqueIdComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="oid | uuid | uri | other", formalDefinition="Identifies the unique identifier scheme used for this particular identifier.")
        protected Enumeration<NamingSystemIdentifierType> type;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The unique identifier", formalDefinition="The string that should be sent over the wire to identify the code system or identifier system.")
        protected StringType value;
        @Child(name="preferred", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is this the id that should be used for this type", formalDefinition="Indicates whether this identifier is the \"preferred\" identifier of this type.")
        protected BooleanType preferred;
        @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When is identifier valid?", formalDefinition="Identifies the period of time over which this identifier is considered appropriate to refer to the naming system.  Outside of this window, the identifier might be non-deterministic.")
        protected Period period;
        private static final long serialVersionUID = -193711840L;

        public NamingSystemUniqueIdComponent() {
        }

        public NamingSystemUniqueIdComponent(Enumeration<NamingSystemIdentifierType> type, StringType value) {
            this.type = type;
            this.value = value;
        }

        public Enumeration<NamingSystemIdentifierType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemUniqueIdComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<NamingSystemIdentifierType>(new NamingSystemIdentifierTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NamingSystemUniqueIdComponent setTypeElement(Enumeration<NamingSystemIdentifierType> value) {
            this.type = value;
            return this;
        }

        public NamingSystemIdentifierType getType() {
            return this.type == null ? null : (NamingSystemIdentifierType)((Object)this.type.getValue());
        }

        public NamingSystemUniqueIdComponent setType(NamingSystemIdentifierType value) {
            if (this.type == null) {
                this.type = new Enumeration<NamingSystemIdentifierType>(new NamingSystemIdentifierTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemUniqueIdComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public NamingSystemUniqueIdComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public NamingSystemUniqueIdComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        public BooleanType getPreferredElement() {
            if (this.preferred == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemUniqueIdComponent.preferred");
                }
                if (Configuration.doAutoCreate()) {
                    this.preferred = new BooleanType();
                }
            }
            return this.preferred;
        }

        public boolean hasPreferredElement() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public boolean hasPreferred() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public NamingSystemUniqueIdComponent setPreferredElement(BooleanType value) {
            this.preferred = value;
            return this;
        }

        public boolean getPreferred() {
            return this.preferred == null || this.preferred.isEmpty() ? false : (Boolean)this.preferred.getValue();
        }

        public NamingSystemUniqueIdComponent setPreferred(boolean value) {
            if (this.preferred == null) {
                this.preferred = new BooleanType();
            }
            this.preferred.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemUniqueIdComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public NamingSystemUniqueIdComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(NamingSystem.SP_TYPE, "code", "Identifies the unique identifier scheme used for this particular identifier.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property(NamingSystem.SP_VALUE, "string", "The string that should be sent over the wire to identify the code system or identifier system.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property("preferred", "boolean", "Indicates whether this identifier is the \"preferred\" identifier of this type.", 0, Integer.MAX_VALUE, this.preferred));
            childrenList.add(new Property(NamingSystem.SP_PERIOD, "Period", "Identifies the period of time over which this identifier is considered appropriate to refer to the naming system.  Outside of this window, the identifier might be non-deterministic.", 0, Integer.MAX_VALUE, this.period));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1294005119: {
                    Base[] baseArray;
                    if (this.preferred == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.preferred;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = new NamingSystemIdentifierTypeEnumFactory().fromType(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                case -1294005119: {
                    this.preferred = this.castToBoolean(value);
                    break;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(NamingSystem.SP_TYPE)) {
                this.type = new NamingSystemIdentifierTypeEnumFactory().fromType(value);
            } else if (name.equals(NamingSystem.SP_VALUE)) {
                this.value = this.castToString(value);
            } else if (name.equals("preferred")) {
                this.preferred = this.castToBoolean(value);
            } else if (name.equals(NamingSystem.SP_PERIOD)) {
                this.period = this.castToPeriod(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
                case -1294005119: {
                    throw new FHIRException("Cannot make property preferred as it is not a complex type");
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(NamingSystem.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.type");
            }
            if (name.equals(NamingSystem.SP_VALUE)) {
                throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.value");
            }
            if (name.equals("preferred")) {
                throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.preferred");
            }
            if (name.equals(NamingSystem.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public NamingSystemUniqueIdComponent copy() {
            NamingSystemUniqueIdComponent dst = new NamingSystemUniqueIdComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.preferred = this.preferred == null ? null : this.preferred.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NamingSystemUniqueIdComponent)) {
                return false;
            }
            NamingSystemUniqueIdComponent o = (NamingSystemUniqueIdComponent)other;
            return NamingSystemUniqueIdComponent.compareDeep(this.type, o.type, true) && NamingSystemUniqueIdComponent.compareDeep(this.value, o.value, true) && NamingSystemUniqueIdComponent.compareDeep(this.preferred, o.preferred, true) && NamingSystemUniqueIdComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NamingSystemUniqueIdComponent)) {
                return false;
            }
            NamingSystemUniqueIdComponent o = (NamingSystemUniqueIdComponent)other;
            return NamingSystemUniqueIdComponent.compareValues(this.type, o.type, true) && NamingSystemUniqueIdComponent.compareValues(this.value, o.value, true) && NamingSystemUniqueIdComponent.compareValues(this.preferred, o.preferred, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.value != null && !this.value.isEmpty() || this.preferred != null && !this.preferred.isEmpty() || this.period != null && !this.period.isEmpty());
        }

        @Override
        public String fhirType() {
            return "NamingSystem.uniqueId";
        }
    }

    public static class NamingSystemIdentifierTypeEnumFactory
    implements EnumFactory<NamingSystemIdentifierType> {
        @Override
        public NamingSystemIdentifierType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("oid".equals(codeString)) {
                return NamingSystemIdentifierType.OID;
            }
            if ("uuid".equals(codeString)) {
                return NamingSystemIdentifierType.UUID;
            }
            if ("uri".equals(codeString)) {
                return NamingSystemIdentifierType.URI;
            }
            if ("other".equals(codeString)) {
                return NamingSystemIdentifierType.OTHER;
            }
            throw new IllegalArgumentException("Unknown NamingSystemIdentifierType code '" + codeString + "'");
        }

        public Enumeration<NamingSystemIdentifierType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("oid".equals(codeString)) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.OID);
            }
            if ("uuid".equals(codeString)) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.UUID);
            }
            if ("uri".equals(codeString)) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.URI);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.OTHER);
            }
            throw new FHIRException("Unknown NamingSystemIdentifierType code '" + codeString + "'");
        }

        @Override
        public String toCode(NamingSystemIdentifierType code) {
            if (code == NamingSystemIdentifierType.NULL) {
                return null;
            }
            if (code == NamingSystemIdentifierType.OID) {
                return "oid";
            }
            if (code == NamingSystemIdentifierType.UUID) {
                return "uuid";
            }
            if (code == NamingSystemIdentifierType.URI) {
                return "uri";
            }
            if (code == NamingSystemIdentifierType.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(NamingSystemIdentifierType code) {
            return code.getSystem();
        }
    }

    public static enum NamingSystemIdentifierType {
        OID,
        UUID,
        URI,
        OTHER,
        NULL;


        public static NamingSystemIdentifierType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("oid".equals(codeString)) {
                return OID;
            }
            if ("uuid".equals(codeString)) {
                return UUID;
            }
            if ("uri".equals(codeString)) {
                return URI;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            throw new FHIRException("Unknown NamingSystemIdentifierType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OID: {
                    return "oid";
                }
                case UUID: {
                    return "uuid";
                }
                case URI: {
                    return "uri";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OID: {
                    return "http://hl7.org/fhir/namingsystem-identifier-type";
                }
                case UUID: {
                    return "http://hl7.org/fhir/namingsystem-identifier-type";
                }
                case URI: {
                    return "http://hl7.org/fhir/namingsystem-identifier-type";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/namingsystem-identifier-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OID: {
                    return "An ISO object identifier; e.g. 1.2.3.4.5.";
                }
                case UUID: {
                    return "A universally unique identifier of the form a5afddf4-e880-459b-876e-e4591b0acc11.";
                }
                case URI: {
                    return "A uniform resource identifier (ideally a URL - uniform resource locator); e.g. http://unitsofmeasure.org.";
                }
                case OTHER: {
                    return "Some other type of unique identifier; e.g. HL7-assigned reserved string such as LN for LOINC.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OID: {
                    return "OID";
                }
                case UUID: {
                    return "UUID";
                }
                case URI: {
                    return "URI";
                }
                case OTHER: {
                    return "Other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

