/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.LinkType;

public class LinkTypeEnumFactory
implements EnumFactory<LinkType> {
    @Override
    public LinkType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("replace".equals(codeString)) {
            return LinkType.REPLACE;
        }
        if ("refer".equals(codeString)) {
            return LinkType.REFER;
        }
        if ("seealso".equals(codeString)) {
            return LinkType.SEEALSO;
        }
        throw new IllegalArgumentException("Unknown LinkType code '" + codeString + "'");
    }

    @Override
    public String toCode(LinkType code) {
        if (code == LinkType.NULL) {
            return null;
        }
        if (code == LinkType.REPLACE) {
            return "replace";
        }
        if (code == LinkType.REFER) {
            return "refer";
        }
        if (code == LinkType.SEEALSO) {
            return "seealso";
        }
        return "?";
    }

    @Override
    public String toSystem(LinkType code) {
        return code.getSystem();
    }
}

