/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VisionProduct {
    LENS,
    CONTACT,
    NULL;


    public static VisionProduct fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("lens".equals(codeString)) {
            return LENS;
        }
        if ("contact".equals(codeString)) {
            return CONTACT;
        }
        throw new FHIRException("Unknown VisionProduct code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LENS: {
                return "lens";
            }
            case CONTACT: {
                return "contact";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-visionprescriptionproduct";
    }

    public String getDefinition() {
        switch (this) {
            case LENS: {
                return "";
            }
            case CONTACT: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LENS: {
                return "lens";
            }
            case CONTACT: {
                return "contact";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

