/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CarePlan;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DiagnosticOrder;
import org.hl7.fhir.dstu2016may.model.DiagnosticReport;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Medication;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.ProcedureRequest;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ReferralRequest;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.Substance;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Procedure", profile="http://hl7.org/fhir/Profile/Procedure")
public class Procedure
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Identifiers for this procedure", formalDefinition="This records identifiers associated with this procedure that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="subject", type={Patient.class, Group.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the procedure was performed on", formalDefinition="The person, animal or group on which the procedure was performed.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | aborted | completed | entered-in-error", formalDefinition="A code specifying the state of the procedure. Generally this will be in-progress or completed state.")
    protected Enumeration<ProcedureStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of the procedure", formalDefinition="A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").")
    protected CodeableConcept category;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identification of the procedure", formalDefinition="The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. \"Laparoscopic Appendectomy\").")
    protected CodeableConcept code;
    @Child(name="notPerformed", type={BooleanType.class}, order=5, min=0, max=1, modifier=true, summary=false)
    @Description(shortDefinition="True if procedure was not performed as scheduled", formalDefinition="Set this to true if the record is saying that the procedure was NOT performed.")
    protected BooleanType notPerformed;
    @Child(name="reasonNotPerformed", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason procedure was not performed", formalDefinition="A code indicating why the procedure was not performed.")
    protected List<CodeableConcept> reasonNotPerformed;
    @Child(name="bodySite", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Target body sites", formalDefinition="Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.")
    protected List<CodeableConcept> bodySite;
    @Child(name="reason", type={CodeableConcept.class, Condition.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason procedure performed", formalDefinition="The reason why the procedure was performed. This may be due to a Condition, may be coded entity of some type, or may simply be present as text.")
    protected Type reason;
    @Child(name="performer", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The people who performed the procedure", formalDefinition="Limited to 'real' people rather than equipment.")
    protected List<ProcedurePerformerComponent> performer;
    @Child(name="performed", type={DateTimeType.class, Period.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Period the procedure was performed", formalDefinition="The date(time)/period over which the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.")
    protected Type performed;
    @Child(name="encounter", type={Encounter.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The encounter associated with the procedure", formalDefinition="The encounter during which the procedure was performed.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="location", type={Location.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the procedure happened", formalDefinition="The location where the procedure actually happened.  E.g. a newborn at home, a tracheostomy at a restaurant.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="outcome", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The result of procedure", formalDefinition="The outcome of the procedure - did it resolve reasons for the procedure being performed?")
    protected CodeableConcept outcome;
    @Child(name="report", type={DiagnosticReport.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Any report resulting from the procedure", formalDefinition="This could be a histology result, pathology report, surgical report, etc..")
    protected List<Reference> report;
    protected List<DiagnosticReport> reportTarget;
    @Child(name="complication", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Complication following the procedure", formalDefinition="Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues.")
    protected List<CodeableConcept> complication;
    @Child(name="followUp", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instructions for follow up", formalDefinition="If the procedure required specific follow up - e.g. removal of sutures. The followup may be represented as a simple note, or could potentially be more complex in which case the CarePlan resource can be used.")
    protected List<CodeableConcept> followUp;
    @Child(name="request", type={CarePlan.class, DiagnosticOrder.class, ProcedureRequest.class, ReferralRequest.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A request for this procedure", formalDefinition="A reference to a resource that contains details of the request for this procedure.")
    protected Reference request;
    protected Resource requestTarget;
    @Child(name="notes", type={Annotation.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information about the procedure", formalDefinition="Any other notes about the procedure.  E.g. the operative notes.")
    protected List<Annotation> notes;
    @Child(name="focalDevice", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device changed in procedure", formalDefinition="A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.")
    protected List<ProcedureFocalDeviceComponent> focalDevice;
    @Child(name="used", type={Device.class, Medication.class, Substance.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Items used during procedure", formalDefinition="Identifies medications, devices and any other substance used as part of the procedure.")
    protected List<Reference> used;
    protected List<Resource> usedTarget;
    private static final long serialVersionUID = -489125036L;
    @SearchParamDefinition(name="patient", path="Procedure.subject", description="Search by subject - a patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Procedure:patient").toLocked();
    @SearchParamDefinition(name="location", path="Procedure.location", description="Where the procedure happened", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Procedure:location").toLocked();
    @SearchParamDefinition(name="subject", path="Procedure.subject", description="Search by subject", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Procedure:subject").toLocked();
    @SearchParamDefinition(name="performer", path="Procedure.performer.actor", description="The reference to the practitioner", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("Procedure:performer").toLocked();
    @SearchParamDefinition(name="encounter", path="Procedure.encounter", description="The encounter associated with the procedure", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Procedure:encounter").toLocked();
    @SearchParamDefinition(name="code", path="Procedure.code", description="A code to identify a  procedure", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="Procedure.performed", description="Date/Period the procedure was performed", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Procedure.identifier", description="A unique identifier for a procedure", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public Procedure() {
    }

    public Procedure(Reference subject, Enumeration<ProcedureStatus> status, CodeableConcept code) {
        this.subject = subject;
        this.status = status;
        this.code = code;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Procedure addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Procedure setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Procedure setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Enumeration<ProcedureStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ProcedureStatus>(new ProcedureStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Procedure setStatusElement(Enumeration<ProcedureStatus> value) {
        this.status = value;
        return this;
    }

    public ProcedureStatus getStatus() {
        return this.status == null ? null : (ProcedureStatus)((Object)this.status.getValue());
    }

    public Procedure setStatus(ProcedureStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ProcedureStatus>(new ProcedureStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public Procedure setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Procedure setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public BooleanType getNotPerformedElement() {
        if (this.notPerformed == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.notPerformed");
            }
            if (Configuration.doAutoCreate()) {
                this.notPerformed = new BooleanType();
            }
        }
        return this.notPerformed;
    }

    public boolean hasNotPerformedElement() {
        return this.notPerformed != null && !this.notPerformed.isEmpty();
    }

    public boolean hasNotPerformed() {
        return this.notPerformed != null && !this.notPerformed.isEmpty();
    }

    public Procedure setNotPerformedElement(BooleanType value) {
        this.notPerformed = value;
        return this;
    }

    public boolean getNotPerformed() {
        return this.notPerformed == null || this.notPerformed.isEmpty() ? false : (Boolean)this.notPerformed.getValue();
    }

    public Procedure setNotPerformed(boolean value) {
        if (this.notPerformed == null) {
            this.notPerformed = new BooleanType();
        }
        this.notPerformed.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getReasonNotPerformed() {
        if (this.reasonNotPerformed == null) {
            this.reasonNotPerformed = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotPerformed;
    }

    public boolean hasReasonNotPerformed() {
        if (this.reasonNotPerformed == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonNotPerformed) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonNotPerformed() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonNotPerformed == null) {
            this.reasonNotPerformed = new ArrayList<CodeableConcept>();
        }
        this.reasonNotPerformed.add(t);
        return t;
    }

    public Procedure addReasonNotPerformed(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonNotPerformed == null) {
            this.reasonNotPerformed = new ArrayList<CodeableConcept>();
        }
        this.reasonNotPerformed.add(t);
        return this;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public Procedure addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public Procedure setReason(Type value) {
        this.reason = value;
        return this;
    }

    public List<ProcedurePerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformerComponent>();
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (ProcedurePerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedurePerformerComponent addPerformer() {
        ProcedurePerformerComponent t = new ProcedurePerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public Procedure addPerformer(ProcedurePerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public Type getPerformed() {
        return this.performed;
    }

    public DateTimeType getPerformedDateTimeType() throws FHIRException {
        if (!(this.performed instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.performed.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.performed;
    }

    public boolean hasPerformedDateTimeType() {
        return this.performed instanceof DateTimeType;
    }

    public Period getPerformedPeriod() throws FHIRException {
        if (!(this.performed instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.performed.getClass().getName() + " was encountered");
        }
        return (Period)this.performed;
    }

    public boolean hasPerformedPeriod() {
        return this.performed instanceof Period;
    }

    public boolean hasPerformed() {
        return this.performed != null && !this.performed.isEmpty();
    }

    public Procedure setPerformed(Type value) {
        this.performed = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Procedure setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public Procedure setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Procedure setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public Procedure setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public CodeableConcept getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new CodeableConcept();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public Procedure setOutcome(CodeableConcept value) {
        this.outcome = value;
        return this;
    }

    public List<Reference> getReport() {
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        return this.report;
    }

    public boolean hasReport() {
        if (this.report == null) {
            return false;
        }
        for (Reference item : this.report) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReport() {
        Reference t = new Reference();
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        this.report.add(t);
        return t;
    }

    public Procedure addReport(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        this.report.add(t);
        return this;
    }

    public List<DiagnosticReport> getReportTarget() {
        if (this.reportTarget == null) {
            this.reportTarget = new ArrayList<DiagnosticReport>();
        }
        return this.reportTarget;
    }

    public DiagnosticReport addReportTarget() {
        DiagnosticReport r = new DiagnosticReport();
        if (this.reportTarget == null) {
            this.reportTarget = new ArrayList<DiagnosticReport>();
        }
        this.reportTarget.add(r);
        return r;
    }

    public List<CodeableConcept> getComplication() {
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableConcept>();
        }
        return this.complication;
    }

    public boolean hasComplication() {
        if (this.complication == null) {
            return false;
        }
        for (CodeableConcept item : this.complication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addComplication() {
        CodeableConcept t = new CodeableConcept();
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableConcept>();
        }
        this.complication.add(t);
        return t;
    }

    public Procedure addComplication(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableConcept>();
        }
        this.complication.add(t);
        return this;
    }

    public List<CodeableConcept> getFollowUp() {
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        return this.followUp;
    }

    public boolean hasFollowUp() {
        if (this.followUp == null) {
            return false;
        }
        for (CodeableConcept item : this.followUp) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addFollowUp() {
        CodeableConcept t = new CodeableConcept();
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        this.followUp.add(t);
        return t;
    }

    public Procedure addFollowUp(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        this.followUp.add(t);
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public Procedure setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Resource getRequestTarget() {
        return this.requestTarget;
    }

    public Procedure setRequestTarget(Resource value) {
        this.requestTarget = value;
        return this;
    }

    public List<Annotation> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<Annotation>();
        }
        return this.notes;
    }

    public boolean hasNotes() {
        if (this.notes == null) {
            return false;
        }
        for (Annotation item : this.notes) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNotes() {
        Annotation t = new Annotation();
        if (this.notes == null) {
            this.notes = new ArrayList<Annotation>();
        }
        this.notes.add(t);
        return t;
    }

    public Procedure addNotes(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.notes == null) {
            this.notes = new ArrayList<Annotation>();
        }
        this.notes.add(t);
        return this;
    }

    public List<ProcedureFocalDeviceComponent> getFocalDevice() {
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
        }
        return this.focalDevice;
    }

    public boolean hasFocalDevice() {
        if (this.focalDevice == null) {
            return false;
        }
        for (ProcedureFocalDeviceComponent item : this.focalDevice) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedureFocalDeviceComponent addFocalDevice() {
        ProcedureFocalDeviceComponent t = new ProcedureFocalDeviceComponent();
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
        }
        this.focalDevice.add(t);
        return t;
    }

    public Procedure addFocalDevice(ProcedureFocalDeviceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
        }
        this.focalDevice.add(t);
        return this;
    }

    public List<Reference> getUsed() {
        if (this.used == null) {
            this.used = new ArrayList<Reference>();
        }
        return this.used;
    }

    public boolean hasUsed() {
        if (this.used == null) {
            return false;
        }
        for (Reference item : this.used) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addUsed() {
        Reference t = new Reference();
        if (this.used == null) {
            this.used = new ArrayList<Reference>();
        }
        this.used.add(t);
        return t;
    }

    public Procedure addUsed(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.used == null) {
            this.used = new ArrayList<Reference>();
        }
        this.used.add(t);
        return this;
    }

    public List<Resource> getUsedTarget() {
        if (this.usedTarget == null) {
            this.usedTarget = new ArrayList<Resource>();
        }
        return this.usedTarget;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this procedure that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group on which the procedure was performed.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("status", SP_CODE, "A code specifying the state of the procedure. Generally this will be in-progress or completed state.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("category", "CodeableConcept", "A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. \"Laparoscopic Appendectomy\").", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("notPerformed", "boolean", "Set this to true if the record is saying that the procedure was NOT performed.", 0, Integer.MAX_VALUE, this.notPerformed));
        childrenList.add(new Property("reasonNotPerformed", "CodeableConcept", "A code indicating why the procedure was not performed.", 0, Integer.MAX_VALUE, this.reasonNotPerformed));
        childrenList.add(new Property("bodySite", "CodeableConcept", "Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.", 0, Integer.MAX_VALUE, this.bodySite));
        childrenList.add(new Property("reason[x]", "CodeableConcept|Reference(Condition)", "The reason why the procedure was performed. This may be due to a Condition, may be coded entity of some type, or may simply be present as text.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property(SP_PERFORMER, "", "Limited to 'real' people rather than equipment.", 0, Integer.MAX_VALUE, this.performer));
        childrenList.add(new Property("performed[x]", "dateTime|Period", "The date(time)/period over which the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, Integer.MAX_VALUE, this.performed));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter during which the procedure was performed.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property(SP_LOCATION, "Reference(Location)", "The location where the procedure actually happened.  E.g. a newborn at home, a tracheostomy at a restaurant.", 0, Integer.MAX_VALUE, this.location));
        childrenList.add(new Property("outcome", "CodeableConcept", "The outcome of the procedure - did it resolve reasons for the procedure being performed?", 0, Integer.MAX_VALUE, this.outcome));
        childrenList.add(new Property("report", "Reference(DiagnosticReport)", "This could be a histology result, pathology report, surgical report, etc..", 0, Integer.MAX_VALUE, this.report));
        childrenList.add(new Property("complication", "CodeableConcept", "Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues.", 0, Integer.MAX_VALUE, this.complication));
        childrenList.add(new Property("followUp", "CodeableConcept", "If the procedure required specific follow up - e.g. removal of sutures. The followup may be represented as a simple note, or could potentially be more complex in which case the CarePlan resource can be used.", 0, Integer.MAX_VALUE, this.followUp));
        childrenList.add(new Property("request", "Reference(CarePlan|DiagnosticOrder|ProcedureRequest|ReferralRequest)", "A reference to a resource that contains details of the request for this procedure.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property("notes", "Annotation", "Any other notes about the procedure.  E.g. the operative notes.", 0, Integer.MAX_VALUE, this.notes));
        childrenList.add(new Property("focalDevice", "", "A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.", 0, Integer.MAX_VALUE, this.focalDevice));
        childrenList.add(new Property("used", "Reference(Device|Medication|Substance)", "Identifies medications, devices and any other substance used as part of the procedure.", 0, Integer.MAX_VALUE, this.used));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.subject;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.code;
                }
                return baseArray;
            }
            case 585470509: {
                Base[] baseArray;
                if (this.notPerformed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.notPerformed;
                }
                return baseArray;
            }
            case -906415471: {
                return this.reasonNotPerformed == null ? new Base[]{} : this.reasonNotPerformed.toArray(new Base[this.reasonNotPerformed.size()]);
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.reason;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 481140672: {
                Base[] baseArray;
                if (this.performed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.performed;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.encounter;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.location;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.outcome;
                }
                return baseArray;
            }
            case -934521548: {
                return this.report == null ? new Base[]{} : this.report.toArray(new Base[this.report.size()]);
            }
            case -1644401602: {
                return this.complication == null ? new Base[]{} : this.complication.toArray(new Base[this.complication.size()]);
            }
            case 301801004: {
                return this.followUp == null ? new Base[]{} : this.followUp.toArray(new Base[this.followUp.size()]);
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.request;
                }
                return baseArray;
            }
            case 105008833: {
                return this.notes == null ? new Base[]{} : this.notes.toArray(new Base[this.notes.size()]);
            }
            case -1129235173: {
                return this.focalDevice == null ? new Base[]{} : this.focalDevice.toArray(new Base[this.focalDevice.size()]);
            }
            case 3599293: {
                return this.used == null ? new Base[]{} : this.used.toArray(new Base[this.used.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case -892481550: {
                this.status = new ProcedureStatusEnumFactory().fromType(value);
                break;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                break;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                break;
            }
            case 585470509: {
                this.notPerformed = this.castToBoolean(value);
                break;
            }
            case -906415471: {
                this.getReasonNotPerformed().add(this.castToCodeableConcept(value));
                break;
            }
            case 1702620169: {
                this.getBodySite().add(this.castToCodeableConcept(value));
                break;
            }
            case -934964668: {
                this.reason = (Type)value;
                break;
            }
            case 481140686: {
                this.getPerformer().add((ProcedurePerformerComponent)value);
                break;
            }
            case 481140672: {
                this.performed = (Type)value;
                break;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                break;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                break;
            }
            case -1106507950: {
                this.outcome = this.castToCodeableConcept(value);
                break;
            }
            case -934521548: {
                this.getReport().add(this.castToReference(value));
                break;
            }
            case -1644401602: {
                this.getComplication().add(this.castToCodeableConcept(value));
                break;
            }
            case 301801004: {
                this.getFollowUp().add(this.castToCodeableConcept(value));
                break;
            }
            case 1095692943: {
                this.request = this.castToReference(value);
                break;
            }
            case 105008833: {
                this.getNotes().add(this.castToAnnotation(value));
                break;
            }
            case -1129235173: {
                this.getFocalDevice().add((ProcedureFocalDeviceComponent)value);
                break;
            }
            case 3599293: {
                this.getUsed().add(this.castToReference(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("status")) {
            this.status = new ProcedureStatusEnumFactory().fromType(value);
        } else if (name.equals("category")) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("notPerformed")) {
            this.notPerformed = this.castToBoolean(value);
        } else if (name.equals("reasonNotPerformed")) {
            this.getReasonNotPerformed().add(this.castToCodeableConcept(value));
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(this.castToCodeableConcept(value));
        } else if (name.equals("reason[x]")) {
            this.reason = (Type)value;
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((ProcedurePerformerComponent)value);
        } else if (name.equals("performed[x]")) {
            this.performed = (Type)value;
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals("outcome")) {
            this.outcome = this.castToCodeableConcept(value);
        } else if (name.equals("report")) {
            this.getReport().add(this.castToReference(value));
        } else if (name.equals("complication")) {
            this.getComplication().add(this.castToCodeableConcept(value));
        } else if (name.equals("followUp")) {
            this.getFollowUp().add(this.castToCodeableConcept(value));
        } else if (name.equals("request")) {
            this.request = this.castToReference(value);
        } else if (name.equals("notes")) {
            this.getNotes().add(this.castToAnnotation(value));
        } else if (name.equals("focalDevice")) {
            this.getFocalDevice().add((ProcedureFocalDeviceComponent)value);
        } else if (name.equals("used")) {
            this.getUsed().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 50511102: {
                return this.getCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case 585470509: {
                throw new FHIRException("Cannot make property notPerformed as it is not a complex type");
            }
            case -906415471: {
                return this.addReasonNotPerformed();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case -669418564: {
                return this.getReason();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1355984064: {
                return this.getPerformed();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case -934521548: {
                return this.addReport();
            }
            case -1644401602: {
                return this.addComplication();
            }
            case 301801004: {
                return this.addFollowUp();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case 105008833: {
                return this.addNotes();
            }
            case -1129235173: {
                return this.addFocalDevice();
            }
            case 3599293: {
                return this.addUsed();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property Procedure.status");
        }
        if (name.equals("category")) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("notPerformed")) {
            throw new FHIRException("Cannot call addChild on a singleton property Procedure.notPerformed");
        }
        if (name.equals("reasonNotPerformed")) {
            return this.addReasonNotPerformed();
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("performedDateTime")) {
            this.performed = new DateTimeType();
            return this.performed;
        }
        if (name.equals("performedPeriod")) {
            this.performed = new Period();
            return this.performed;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("outcome")) {
            this.outcome = new CodeableConcept();
            return this.outcome;
        }
        if (name.equals("report")) {
            return this.addReport();
        }
        if (name.equals("complication")) {
            return this.addComplication();
        }
        if (name.equals("followUp")) {
            return this.addFollowUp();
        }
        if (name.equals("request")) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("notes")) {
            return this.addNotes();
        }
        if (name.equals("focalDevice")) {
            return this.addFocalDevice();
        }
        if (name.equals("used")) {
            return this.addUsed();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Procedure";
    }

    @Override
    public Procedure copy() {
        Procedure dst = new Procedure();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.code = this.code == null ? null : this.code.copy();
        BooleanType booleanType = dst.notPerformed = this.notPerformed == null ? null : this.notPerformed.copy();
        if (this.reasonNotPerformed != null) {
            dst.reasonNotPerformed = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonNotPerformed) {
                dst.reasonNotPerformed.add(codeableConcept.copy());
            }
        }
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.bodySite) {
                dst.bodySite.add(codeableConcept.copy());
            }
        }
        Type type = dst.reason = this.reason == null ? null : this.reason.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<ProcedurePerformerComponent>();
            for (ProcedurePerformerComponent procedurePerformerComponent : this.performer) {
                dst.performer.add(procedurePerformerComponent.copy());
            }
        }
        dst.performed = this.performed == null ? null : this.performed.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.location = this.location == null ? null : this.location.copy();
        CodeableConcept codeableConcept = dst.outcome = this.outcome == null ? null : this.outcome.copy();
        if (this.report != null) {
            dst.report = new ArrayList<Reference>();
            for (Reference reference : this.report) {
                dst.report.add(reference.copy());
            }
        }
        if (this.complication != null) {
            dst.complication = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.complication) {
                dst.complication.add(codeableConcept2.copy());
            }
        }
        if (this.followUp != null) {
            dst.followUp = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.followUp) {
                dst.followUp.add(codeableConcept3.copy());
            }
        }
        Reference reference = dst.request = this.request == null ? null : this.request.copy();
        if (this.notes != null) {
            dst.notes = new ArrayList<Annotation>();
            for (Annotation annotation : this.notes) {
                dst.notes.add(annotation.copy());
            }
        }
        if (this.focalDevice != null) {
            dst.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
            for (ProcedureFocalDeviceComponent procedureFocalDeviceComponent : this.focalDevice) {
                dst.focalDevice.add(procedureFocalDeviceComponent.copy());
            }
        }
        if (this.used != null) {
            dst.used = new ArrayList<Reference>();
            for (Reference reference2 : this.used) {
                dst.used.add(reference2.copy());
            }
        }
        return dst;
    }

    protected Procedure typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Procedure)) {
            return false;
        }
        Procedure o = (Procedure)other;
        return Procedure.compareDeep(this.identifier, o.identifier, true) && Procedure.compareDeep(this.subject, o.subject, true) && Procedure.compareDeep(this.status, o.status, true) && Procedure.compareDeep(this.category, o.category, true) && Procedure.compareDeep(this.code, o.code, true) && Procedure.compareDeep(this.notPerformed, o.notPerformed, true) && Procedure.compareDeep(this.reasonNotPerformed, o.reasonNotPerformed, true) && Procedure.compareDeep(this.bodySite, o.bodySite, true) && Procedure.compareDeep(this.reason, o.reason, true) && Procedure.compareDeep(this.performer, o.performer, true) && Procedure.compareDeep(this.performed, o.performed, true) && Procedure.compareDeep(this.encounter, o.encounter, true) && Procedure.compareDeep(this.location, o.location, true) && Procedure.compareDeep(this.outcome, o.outcome, true) && Procedure.compareDeep(this.report, o.report, true) && Procedure.compareDeep(this.complication, o.complication, true) && Procedure.compareDeep(this.followUp, o.followUp, true) && Procedure.compareDeep(this.request, o.request, true) && Procedure.compareDeep(this.notes, o.notes, true) && Procedure.compareDeep(this.focalDevice, o.focalDevice, true) && Procedure.compareDeep(this.used, o.used, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Procedure)) {
            return false;
        }
        Procedure o = (Procedure)other;
        return Procedure.compareValues(this.status, o.status, true) && Procedure.compareValues(this.notPerformed, o.notPerformed, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.status != null && !this.status.isEmpty() || this.category != null && !this.category.isEmpty() || this.code != null && !this.code.isEmpty() || this.notPerformed != null && !this.notPerformed.isEmpty() || this.reasonNotPerformed != null && !this.reasonNotPerformed.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.performer != null && !this.performer.isEmpty() || this.performed != null && !this.performed.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.location != null && !this.location.isEmpty() || this.outcome != null && !this.outcome.isEmpty() || this.report != null && !this.report.isEmpty() || this.complication != null && !this.complication.isEmpty() || this.followUp != null && !this.followUp.isEmpty() || this.request != null && !this.request.isEmpty() || this.notes != null && !this.notes.isEmpty() || this.focalDevice != null && !this.focalDevice.isEmpty() || this.used != null && !this.used.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Procedure;
    }

    public static class ProcedureStatusEnumFactory
    implements EnumFactory<ProcedureStatus> {
        @Override
        public ProcedureStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return ProcedureStatus.INPROGRESS;
            }
            if ("aborted".equals(codeString)) {
                return ProcedureStatus.ABORTED;
            }
            if ("completed".equals(codeString)) {
                return ProcedureStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ProcedureStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ProcedureStatus code '" + codeString + "'");
        }

        public Enumeration<ProcedureStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.INPROGRESS);
            }
            if ("aborted".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.ABORTED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ProcedureStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ProcedureStatus code) {
            if (code == ProcedureStatus.NULL) {
                return null;
            }
            if (code == ProcedureStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == ProcedureStatus.ABORTED) {
                return "aborted";
            }
            if (code == ProcedureStatus.COMPLETED) {
                return "completed";
            }
            if (code == ProcedureStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ProcedureStatus code) {
            return code.getSystem();
        }
    }

    public static enum ProcedureStatus {
        INPROGRESS,
        ABORTED,
        COMPLETED,
        ENTEREDINERROR,
        NULL;


        public static ProcedureStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("aborted".equals(codeString)) {
                return ABORTED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown ProcedureStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case ABORTED: {
                    return "aborted";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/procedure-status";
                }
                case ABORTED: {
                    return "http://hl7.org/fhir/procedure-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/procedure-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/procedure-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "The procedure is still occurring.";
                }
                case ABORTED: {
                    return "The procedure was terminated without completing successfully.";
                }
                case COMPLETED: {
                    return "All actions involved in the procedure have taken place.";
                }
                case ENTEREDINERROR: {
                    return "The statement was entered in error and Is not valid.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case ABORTED: {
                    return "Aboted";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class ProcedurePerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actor", type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The reference to the practitioner", formalDefinition="The practitioner who was involved in the procedure.")
        protected Reference actor;
        protected Resource actorTarget;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The role the actor was in", formalDefinition="For example: surgeon, anaethetist, endoscopist.")
        protected CodeableConcept role;
        private static final long serialVersionUID = -843698327L;

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ProcedurePerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public ProcedurePerformerComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ProcedurePerformerComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("actor", "Reference(Practitioner|Organization|Patient|RelatedPerson)", "The practitioner who was involved in the procedure.", 0, Integer.MAX_VALUE, this.actor));
            childrenList.add(new Property("role", "CodeableConcept", "For example: surgeon, anaethetist, endoscopist.", 0, Integer.MAX_VALUE, this.role));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actor;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    this.actor = this.castToReference(value);
                    break;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = this.castToReference(value);
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return this.getActor();
                }
                case 3506294: {
                    return this.getRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedurePerformerComponent copy() {
            ProcedurePerformerComponent dst = new ProcedurePerformerComponent();
            this.copyValues(dst);
            dst.actor = this.actor == null ? null : this.actor.copy();
            dst.role = this.role == null ? null : this.role.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProcedurePerformerComponent)) {
                return false;
            }
            ProcedurePerformerComponent o = (ProcedurePerformerComponent)other;
            return ProcedurePerformerComponent.compareDeep(this.actor, o.actor, true) && ProcedurePerformerComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProcedurePerformerComponent)) {
                return false;
            }
            ProcedurePerformerComponent o = (ProcedurePerformerComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.actor != null && !this.actor.isEmpty() || this.role != null && !this.role.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Procedure.performer";
        }
    }

    @Block
    public static class ProcedureFocalDeviceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of change to device", formalDefinition="The kind of change that happened to the device during the procedure.")
        protected CodeableConcept action;
        @Child(name="manipulated", type={Device.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Device that was changed", formalDefinition="The device that was manipulated (changed) during the procedure.")
        protected Reference manipulated;
        protected Device manipulatedTarget;
        private static final long serialVersionUID = 1779937807L;

        public ProcedureFocalDeviceComponent() {
        }

        public ProcedureFocalDeviceComponent(Reference manipulated) {
            this.manipulated = manipulated;
        }

        public CodeableConcept getAction() {
            if (this.action == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureFocalDeviceComponent.action");
                }
                if (Configuration.doAutoCreate()) {
                    this.action = new CodeableConcept();
                }
            }
            return this.action;
        }

        public boolean hasAction() {
            return this.action != null && !this.action.isEmpty();
        }

        public ProcedureFocalDeviceComponent setAction(CodeableConcept value) {
            this.action = value;
            return this;
        }

        public Reference getManipulated() {
            if (this.manipulated == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureFocalDeviceComponent.manipulated");
                }
                if (Configuration.doAutoCreate()) {
                    this.manipulated = new Reference();
                }
            }
            return this.manipulated;
        }

        public boolean hasManipulated() {
            return this.manipulated != null && !this.manipulated.isEmpty();
        }

        public ProcedureFocalDeviceComponent setManipulated(Reference value) {
            this.manipulated = value;
            return this;
        }

        public Device getManipulatedTarget() {
            if (this.manipulatedTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureFocalDeviceComponent.manipulated");
                }
                if (Configuration.doAutoCreate()) {
                    this.manipulatedTarget = new Device();
                }
            }
            return this.manipulatedTarget;
        }

        public ProcedureFocalDeviceComponent setManipulatedTarget(Device value) {
            this.manipulatedTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("action", "CodeableConcept", "The kind of change that happened to the device during the procedure.", 0, Integer.MAX_VALUE, this.action));
            childrenList.add(new Property("manipulated", "Reference(Device)", "The device that was manipulated (changed) during the procedure.", 0, Integer.MAX_VALUE, this.manipulated));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    Base[] baseArray;
                    if (this.action == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.action;
                    }
                    return baseArray;
                }
                case 947372650: {
                    Base[] baseArray;
                    if (this.manipulated == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.manipulated;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.action = this.castToCodeableConcept(value);
                    break;
                }
                case 947372650: {
                    this.manipulated = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("action")) {
                this.action = this.castToCodeableConcept(value);
            } else if (name.equals("manipulated")) {
                this.manipulated = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.getAction();
                }
                case 947372650: {
                    return this.getManipulated();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                this.action = new CodeableConcept();
                return this.action;
            }
            if (name.equals("manipulated")) {
                this.manipulated = new Reference();
                return this.manipulated;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedureFocalDeviceComponent copy() {
            ProcedureFocalDeviceComponent dst = new ProcedureFocalDeviceComponent();
            this.copyValues(dst);
            dst.action = this.action == null ? null : this.action.copy();
            dst.manipulated = this.manipulated == null ? null : this.manipulated.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProcedureFocalDeviceComponent)) {
                return false;
            }
            ProcedureFocalDeviceComponent o = (ProcedureFocalDeviceComponent)other;
            return ProcedureFocalDeviceComponent.compareDeep(this.action, o.action, true) && ProcedureFocalDeviceComponent.compareDeep(this.manipulated, o.manipulated, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProcedureFocalDeviceComponent)) {
                return false;
            }
            ProcedureFocalDeviceComponent o = (ProcedureFocalDeviceComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.action != null && !this.action.isEmpty() || this.manipulated != null && !this.manipulated.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Procedure.focalDevice";
        }
    }
}

