/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExtensionContext {
    RESOURCE,
    DATATYPE,
    EXTENSION,
    NULL;


    public static ExtensionContext fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("resource".equals(codeString)) {
            return RESOURCE;
        }
        if ("datatype".equals(codeString)) {
            return DATATYPE;
        }
        if ("extension".equals(codeString)) {
            return EXTENSION;
        }
        throw new FHIRException("Unknown ExtensionContext code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RESOURCE: {
                return "resource";
            }
            case DATATYPE: {
                return "datatype";
            }
            case EXTENSION: {
                return "extension";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/extension-context";
    }

    public String getDefinition() {
        switch (this) {
            case RESOURCE: {
                return "The context is all elements matching a particular resource element path.";
            }
            case DATATYPE: {
                return "The context is all nodes matching a particular data type element path (root or repeating element) or all elements referencing a particular primitive data type (expressed as the datatype name).";
            }
            case EXTENSION: {
                return "The context is a particular extension from a particular profile, a uri that identifies the extension definition.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RESOURCE: {
                return "Resource";
            }
            case DATATYPE: {
                return "Datatype";
            }
            case EXTENSION: {
                return "Extension";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

