/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.elementmodel.Element;
import org.hl7.fhir.dstu3.elementmodel.ParserBase;
import org.hl7.fhir.dstu3.elementmodel.Property;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.JsonCreator;
import org.hl7.fhir.dstu3.formats.JsonCreatorCanonical;
import org.hl7.fhir.dstu3.formats.JsonCreatorGson;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.utilities.Utilities;

public class JsonLDParser
extends ParserBase {
    private JsonCreator json;
    private String base;
    private String jsonLDBase = "http://build.fhir.org/";

    public JsonLDParser(IWorkerContext context) {
        super(context);
    }

    @Override
    public Element parse(InputStream stream) {
        throw new NotImplementedException("not done yet");
    }

    protected void prop(String name, String value) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void open(String name) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginObject();
    }

    protected void close() throws IOException {
        this.json.endObject();
    }

    protected void openArray(String name) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginArray();
    }

    protected void closeArray() throws IOException {
        this.json.endArray();
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String base) throws IOException {
        this.base = base;
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF-8");
        this.json = style == IParser.OutputStyle.CANONICAL ? new JsonCreatorCanonical(osw) : new JsonCreatorGson(osw);
        this.json.setIndent(style == IParser.OutputStyle.PRETTY ? "  " : "");
        this.json.beginObject();
        this.prop("@type", "fhir:" + e.getType());
        this.prop("@context", this.jsonLDBase + "fhir.jsonld");
        this.prop("role", "fhir:treeRoot");
        String id = e.getChildValue("id");
        if (base != null && id != null) {
            if (base.endsWith("#")) {
                this.prop("@id", base + e.getType() + "-" + id + ">");
            } else {
                this.prop("@id", Utilities.pathURL((String[])new String[]{base, e.getType(), id}));
            }
        }
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        this.json.endObject();
        this.json.finish();
        osw.flush();
    }

    private void compose(String path, Element e, Set<String> done, Element child) throws IOException {
        if (!child.isList()) {
            this.compose(path, child);
        } else if (!done.contains(child.getName())) {
            done.add(child.getName());
            List<Element> list = e.getChildrenByName(child.getName());
            this.composeList(path, list);
        }
    }

    private void composeList(String path, List<Element> list) throws IOException {
        String en = this.getFormalName(list.get(0));
        this.openArray(en);
        for (Element item : list) {
            this.open(null);
            this.json.name("index");
            this.json.value(item.getIndex());
            if ((item.isPrimitive() || this.isPrimitive(item.getType())) && item.hasValue()) {
                this.primitiveValue(item);
            }
            if (item.getProperty().isResource()) {
                this.prop("@type", "fhir:" + item.getType());
            }
            HashSet<String> done = new HashSet<String>();
            for (Element child : item.getChildren()) {
                this.compose(path + "." + item.getName(), item, done, child);
            }
            if ("Coding".equals(item.getType())) {
                this.decorateCoding(item);
            }
            if ("CodeableConcept".equals(item.getType())) {
                this.decorateCodeableConcept(item);
            }
            if ("Reference".equals(item.getType())) {
                this.decorateReference(item);
            }
            this.close();
        }
        this.closeArray();
    }

    private void primitiveValue(Element item) throws IOException {
        String type = item.getType();
        if (Utilities.existsInList((String)type, (String[])new String[]{"date", "dateTime", "instant"})) {
            String v = item.getValue();
            if (v.length() > 10) {
                int i = v.substring(10).indexOf("-");
                if (i == -1) {
                    i = v.substring(10).indexOf("+");
                }
                String string = v = i == -1 ? v : v.substring(0, 10 + i);
            }
            if (v.length() > 10) {
                this.json.name("dateTime");
            } else if (v.length() == 10) {
                this.json.name("date");
            } else if (v.length() == 7) {
                this.json.name("gYearMonth");
            } else if (v.length() == 4) {
                this.json.name("gYear");
            }
            this.json.value(item.getValue());
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"boolean"})) {
            this.json.name("boolean");
            this.json.value(item.getValue().equals("true") ? new Boolean(true) : new Boolean(false));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"integer", "unsignedInt", "positiveInt"})) {
            this.json.name("integer");
            this.json.value(new Integer(item.getValue()));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"decimal"})) {
            this.json.name("decimal");
            this.json.value(item.getValue());
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"base64Binary"})) {
            this.json.name("binary");
            this.json.value(item.getValue());
        } else {
            this.json.name("value");
            this.json.value(item.getValue());
        }
    }

    private void compose(String path, Element element) throws IOException {
        Property p = element.hasElementProperty() ? element.getElementProperty() : element.getProperty();
        String en = this.getFormalName(element);
        if (element.fhirType().equals("xhtml")) {
            this.json.name(en);
            this.json.value(element.getValue());
        } else if (element.hasChildren() || element.hasComments() || element.hasValue()) {
            this.open(en);
            if (element.getProperty().isResource()) {
                this.prop("@type", "fhir:" + element.getType());
            }
            if ((element.isPrimitive() || this.isPrimitive(element.getType())) && element.hasValue()) {
                this.primitiveValue(element);
            }
            HashSet<String> done = new HashSet<String>();
            for (Element child : element.getChildren()) {
                this.compose(path + "." + element.getName(), element, done, child);
            }
            if ("Coding".equals(element.getType())) {
                this.decorateCoding(element);
            }
            if ("CodeableConcept".equals(element.getType())) {
                this.decorateCodeableConcept(element);
            }
            if ("Reference".equals(element.getType())) {
                this.decorateReference(element);
            }
            this.close();
        }
    }

    private void decorateReference(Element element) throws IOException {
        String ref = element.getChildValue("reference");
        if (ref != null && (ref.startsWith("http://") || ref.startsWith("https://"))) {
            this.json.name("link");
            this.json.value(ref);
        } else if (this.base != null && ref != null && ref.contains("/")) {
            this.json.name("link");
            this.json.value(Utilities.pathURL((String[])new String[]{this.base, ref}));
        }
    }

    protected void decorateCoding(Element coding) throws IOException {
        String system = coding.getChildValue("system");
        String code = coding.getChildValue("code");
        if (system == null) {
            return;
        }
        if ("http://snomed.info/sct".equals(system)) {
            this.json.name("concept");
            this.json.value("http://snomed.info/id/" + code);
        } else if ("http://loinc.org".equals(system)) {
            this.json.name("concept");
            this.json.value("http://loinc.org/rdf#" + code);
        }
    }

    private void decorateCodeableConcept(Element element) throws IOException {
    }

    private String getFormalName(Element element) {
        String en = null;
        if (element.getSpecial() == null) {
            if (element.getProperty().getDefinition().hasBase()) {
                en = element.getProperty().getDefinition().getBase().getPath();
            }
        } else {
            en = element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY ? "Bundle.entry.resource" : (element.getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME ? "Bundle.entry.response.outcome" : (element.getSpecial() == Element.SpecialElement.PARAMETER ? element.getElementProperty().getDefinition().getPath() : "DomainResource.contained"));
        }
        if (en == null) {
            en = element.getProperty().getDefinition().getPath();
        }
        boolean doType = false;
        if (en.endsWith("[x]")) {
            en = en.substring(0, en.length() - 3);
            doType = true;
        }
        if (doType || element.getProperty().getDefinition().getType().size() > 1 && !this.allReference(element.getProperty().getDefinition().getType())) {
            en = en + Utilities.capitalize((String)element.getType());
        }
        return en;
    }

    private boolean allReference(List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent t : types) {
            if (t.getCode().equals("Reference")) continue;
            return false;
        }
        return true;
    }
}

