/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.RequestStage;

public class RequestStageEnumFactory
implements EnumFactory<RequestStage> {
    @Override
    public RequestStage fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return RequestStage.PROPOSAL;
        }
        if ("plan".equals(codeString)) {
            return RequestStage.PLAN;
        }
        if ("original-order".equals(codeString)) {
            return RequestStage.ORIGINALORDER;
        }
        if ("encoded".equals(codeString)) {
            return RequestStage.ENCODED;
        }
        if ("reflex-order".equals(codeString)) {
            return RequestStage.REFLEXORDER;
        }
        throw new IllegalArgumentException("Unknown RequestStage code '" + codeString + "'");
    }

    @Override
    public String toCode(RequestStage code) {
        if (code == RequestStage.PROPOSAL) {
            return "proposal";
        }
        if (code == RequestStage.PLAN) {
            return "plan";
        }
        if (code == RequestStage.ORIGINALORDER) {
            return "original-order";
        }
        if (code == RequestStage.ENCODED) {
            return "encoded";
        }
        if (code == RequestStage.REFLEXORDER) {
            return "reflex-order";
        }
        return "?";
    }

    @Override
    public String toSystem(RequestStage code) {
        return code.getSystem();
    }
}

