/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum FmStatus {
    ACTIVE,
    CANCELLED,
    DRAFT,
    ENTEREDINERROR,
    NULL;


    public static FmStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown FmStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case DRAFT: {
                return "draft";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/fm-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The instance is currently in-force.";
            }
            case CANCELLED: {
                return "The instance is withdrawn, rescinded or reversed.";
            }
            case DRAFT: {
                return "A new instance the contents of which is not complete.";
            }
            case ENTEREDINERROR: {
                return "The instance was entered in error.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case DRAFT: {
                return "Draft";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
        }
        return "?";
    }
}

