/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProviderQualification {
    _311405,
    _604215,
    _604210,
    NULL;


    public static ProviderQualification fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("311405".equals(codeString)) {
            return _311405;
        }
        if ("604215".equals(codeString)) {
            return _604215;
        }
        if ("604210".equals(codeString)) {
            return _604210;
        }
        throw new FHIRException("Unknown ProviderQualification code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _311405: {
                return "311405";
            }
            case _604215: {
                return "604215";
            }
            case _604210: {
                return "604210";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-providerqualification";
    }

    public String getDefinition() {
        switch (this) {
            case _311405: {
                return "Dentist General Practitioner (DDS, DDM).";
            }
            case _604215: {
                return "Ophthalmologist.";
            }
            case _604210: {
                return "Optometrist.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _311405: {
                return "Dentist";
            }
            case _604215: {
                return "Ophthalmologist";
            }
            case _604210: {
                return "Optometrist";
            }
        }
        return "?";
    }
}

