/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum TaskPerformerType {
    REQUESTER,
    DISPATCHER,
    SCHEDULER,
    PERFORMER,
    MONITOR,
    MANAGER,
    ACQUIRER,
    REVIEWER,
    NULL;


    public static TaskPerformerType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("requester".equals(codeString)) {
            return REQUESTER;
        }
        if ("dispatcher".equals(codeString)) {
            return DISPATCHER;
        }
        if ("scheduler".equals(codeString)) {
            return SCHEDULER;
        }
        if ("performer".equals(codeString)) {
            return PERFORMER;
        }
        if ("monitor".equals(codeString)) {
            return MONITOR;
        }
        if ("manager".equals(codeString)) {
            return MANAGER;
        }
        if ("acquirer".equals(codeString)) {
            return ACQUIRER;
        }
        if ("reviewer".equals(codeString)) {
            return REVIEWER;
        }
        throw new FHIRException("Unknown TaskPerformerType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REQUESTER: {
                return "requester";
            }
            case DISPATCHER: {
                return "dispatcher";
            }
            case SCHEDULER: {
                return "scheduler";
            }
            case PERFORMER: {
                return "performer";
            }
            case MONITOR: {
                return "monitor";
            }
            case MANAGER: {
                return "manager";
            }
            case ACQUIRER: {
                return "acquirer";
            }
            case REVIEWER: {
                return "reviewer";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/task-performer-type";
    }

    public String getDefinition() {
        switch (this) {
            case REQUESTER: {
                return "A workflow participant that requests services.";
            }
            case DISPATCHER: {
                return "A workflow participant that dispatches services (assigns another task to a participant).";
            }
            case SCHEDULER: {
                return "A workflow participant that schedules (dispatches and sets the time or date for performance of) services.";
            }
            case PERFORMER: {
                return "A workflow participant that performs services.";
            }
            case MONITOR: {
                return "A workflow participant that monitors task activity.";
            }
            case MANAGER: {
                return "A workflow participant that manages task activity.";
            }
            case ACQUIRER: {
                return "A workflow participant that acquires resources (specimens, images, etc) necessary to perform the task.";
            }
            case REVIEWER: {
                return "A workflow participant that reviews task inputs or outputs.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REQUESTER: {
                return "Requester";
            }
            case DISPATCHER: {
                return "Dispatcher";
            }
            case SCHEDULER: {
                return "Scheduler";
            }
            case PERFORMER: {
                return "Performer";
            }
            case MONITOR: {
                return "Monitor";
            }
            case MANAGER: {
                return "Manager";
            }
            case ACQUIRER: {
                return "Acquirer";
            }
            case REVIEWER: {
                return "Reviewer";
            }
        }
        return "?";
    }
}

