/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.ClaimResponse;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.Coverage;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Claim", profile="http://hl7.org/fhir/Profile/Claim")
public class Claim
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Claim number", formalDefinition="The business identifier for the instance: claim number, pre-determination or pre-authorization number.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<ClaimStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type or discipline", formalDefinition="The category of claim, eg, oral, pharmacy, vision, insitutional, professional.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-type")
    protected CodeableConcept type;
    @Child(name="subType", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Finer grained claim type information", formalDefinition="A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the BillType.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-subtype")
    protected List<CodeableConcept> subType;
    @Child(name="use", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="complete | proposed | exploratory | other", formalDefinition="Complete (Bill or Claim), Proposed (Pre-Authorization), Exploratory (Pre-determination).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-use")
    protected Enumeration<Use> use;
    @Child(name="patient", type={Patient.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The subject of the Products and Services", formalDefinition="Patient Resource.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="billablePeriod", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Period for charge submission", formalDefinition="The billable period for which charges are being submitted.")
    protected Period billablePeriod;
    @Child(name="created", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="enterer", type={Practitioner.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Author", formalDefinition="Person who created the invoice/claim/pre-determination or pre-authorization.")
    protected Reference enterer;
    protected Practitioner entererTarget;
    @Child(name="insurer", type={Organization.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Target", formalDefinition="The Insurer who is target of the request.")
    protected Reference insurer;
    protected Organization insurerTarget;
    @Child(name="provider", type={Practitioner.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible provider", formalDefinition="The provider which is responsible for the bill, claim pre-determination, pre-authorization.")
    protected Reference provider;
    protected Practitioner providerTarget;
    @Child(name="organization", type={Organization.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the bill, claim pre-determination, pre-authorization.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="priority", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Desired processing priority", formalDefinition="Immediate (STAT), best effort (NORMAL), deferred (DEFER).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/process-priority")
    protected CodeableConcept priority;
    @Child(name="fundsReserve", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Funds requested to be reserved", formalDefinition="In the case of a Pre-Determination/Pre-Authorization the provider may request that funds in the amount of the expected Benefit be reserved ('Patient' or 'Provider') to pay for the Benefits determined on the subsequent claim(s). 'None' explicitly indicates no funds reserving is requested.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fundsreserve")
    protected CodeableConcept fundsReserve;
    @Child(name="related", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Related Claims which may be revelant to processing this claimn", formalDefinition="Other claims which are related to this claim such as prior claim versions or for related services.")
    protected List<RelatedClaimComponent> related;
    @Child(name="prescription", type={MedicationRequest.class, VisionPrescription.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Prescription authorizing services or products", formalDefinition="Prescription to support the dispensing of Pharmacy or Vision products.")
    protected Reference prescription;
    protected Resource prescriptionTarget;
    @Child(name="originalPrescription", type={MedicationRequest.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Original prescription if superceded by fulfiller", formalDefinition="Original prescription which has been superceded by this prescription to support the dispensing of pharmacy services, medications or products. For example, a physician may prescribe a medication which the pharmacy determines is contraindicated, or for which the patient has an intolerance, and therefor issues a new precription for an alternate medication which has the same theraputic intent. The prescription from the pharmacy becomes the 'prescription' and that from the physician becomes the 'original prescription'.")
    protected Reference originalPrescription;
    protected MedicationRequest originalPrescriptionTarget;
    @Child(name="payee", type={}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Party to be paid any benefits payable", formalDefinition="The party to be reimbursed for the services.")
    protected PayeeComponent payee;
    @Child(name="referral", type={ReferralRequest.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Treatment Referral", formalDefinition="The referral resource which lists the date, practitioner, reason and other supporting information.")
    protected Reference referral;
    protected ReferralRequest referralTarget;
    @Child(name="facility", type={Location.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Servicing Facility", formalDefinition="Facility where the services were provided.")
    protected Reference facility;
    protected Location facilityTarget;
    @Child(name="careTeam", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Members of the care team", formalDefinition="The members of the team who provided the overall service as well as their role and whether responsible and qualifications.")
    protected List<CareTeamComponent> careTeam;
    @Child(name="information", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Exceptions, special considerations, the condition, situation, prior or concurrent issues", formalDefinition="Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues. Often there are mutiple jurisdiction specific valuesets which are required.")
    protected List<SpecialConditionComponent> information;
    @Child(name="diagnosis", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of Diagnosis", formalDefinition="List of patient diagnosis for which care is sought.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="procedure", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Procedures performed", formalDefinition="Ordered list of patient procedures performed to support the adjudication.")
    protected List<ProcedureComponent> procedure;
    @Child(name="insurance", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care.")
    protected List<InsuranceComponent> insurance;
    @Child(name="accident", type={}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about an accident", formalDefinition="An accident which resulted in the need for healthcare services.")
    protected AccidentComponent accident;
    @Child(name="employmentImpacted", type={Period.class}, order=26, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Period unable to work", formalDefinition="The start and optional end dates of when the patient was precluded from working due to the treatable condition(s).")
    protected Period employmentImpacted;
    @Child(name="hospitalization", type={Period.class}, order=27, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Period in hospital", formalDefinition="The start and optional end dates of when the patient was confined to a treatment center.")
    protected Period hospitalization;
    @Child(name="item", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Goods and Services", formalDefinition="First tier of goods and services.")
    protected List<ItemComponent> item;
    @Child(name="total", type={Money.class}, order=29, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Total claim cost", formalDefinition="The total value of the claim.")
    protected Money total;
    private static final long serialVersionUID = 1731171342L;
    @SearchParamDefinition(name="care-team", path="Claim.careTeam.provider", description="Member of the CareTeam", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class})
    public static final String SP_CARE_TEAM = "care-team";
    public static final ReferenceClientParam CARE_TEAM = new ReferenceClientParam("care-team");
    public static final Include INCLUDE_CARE_TEAM = new Include("Claim:care-team").toLocked();
    @SearchParamDefinition(name="identifier", path="Claim.identifier", description="The primary identifier of the financial resource", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="use", path="Claim.use", description="The kind of financial resource", type="token")
    public static final String SP_USE = "use";
    public static final TokenClientParam USE = new TokenClientParam("use");
    @SearchParamDefinition(name="created", path="Claim.created", description="The creation date for the Claim", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="encounter", path="Claim.item.encounter", description="Encounters associated with a billed line item", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Claim:encounter").toLocked();
    @SearchParamDefinition(name="priority", path="Claim.priority", description="Processing priority requested", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="payee", path="Claim.payee.party", description="The party receiving any payment for the Claim", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_PAYEE = "payee";
    public static final ReferenceClientParam PAYEE = new ReferenceClientParam("payee");
    public static final Include INCLUDE_PAYEE = new Include("Claim:payee").toLocked();
    @SearchParamDefinition(name="provider", path="Claim.provider", description="Provider responsible for the Claim", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PROVIDER = new Include("Claim:provider").toLocked();
    @SearchParamDefinition(name="patient", path="Claim.patient", description="Patient receiving the services", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Claim:patient").toLocked();
    @SearchParamDefinition(name="insurer", path="Claim.insurer", description="The target payor/insurer for the Claim", type="reference", target={Organization.class})
    public static final String SP_INSURER = "insurer";
    public static final ReferenceClientParam INSURER = new ReferenceClientParam("insurer");
    public static final Include INCLUDE_INSURER = new Include("Claim:insurer").toLocked();
    @SearchParamDefinition(name="organization", path="Claim.organization", description="The reference to the providing organization", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Claim:organization").toLocked();
    @SearchParamDefinition(name="enterer", path="Claim.enterer", description="The party responsible for the entry of the Claim", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    public static final Include INCLUDE_ENTERER = new Include("Claim:enterer").toLocked();
    @SearchParamDefinition(name="facility", path="Claim.facility", description="Facility responsible for the goods and services", type="reference", target={Location.class})
    public static final String SP_FACILITY = "facility";
    public static final ReferenceClientParam FACILITY = new ReferenceClientParam("facility");
    public static final Include INCLUDE_FACILITY = new Include("Claim:facility").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Claim setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Claim addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ClaimStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ClaimStatus>(new ClaimStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Claim setStatusElement(Enumeration<ClaimStatus> value) {
        this.status = value;
        return this;
    }

    public ClaimStatus getStatus() {
        return this.status == null ? null : (ClaimStatus)((Object)this.status.getValue());
    }

    public Claim setStatus(ClaimStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<ClaimStatus>(new ClaimStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Claim setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<CodeableConcept> getSubType() {
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        return this.subType;
    }

    public Claim setSubType(List<CodeableConcept> theSubType) {
        this.subType = theSubType;
        return this;
    }

    public boolean hasSubType() {
        if (this.subType == null) {
            return false;
        }
        for (CodeableConcept item : this.subType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSubType() {
        CodeableConcept t = new CodeableConcept();
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        this.subType.add(t);
        return t;
    }

    public Claim addSubType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        this.subType.add(t);
        return this;
    }

    public CodeableConcept getSubTypeFirstRep() {
        if (this.getSubType().isEmpty()) {
            this.addSubType();
        }
        return this.getSubType().get(0);
    }

    public Enumeration<Use> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<Use>(new UseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public Claim setUseElement(Enumeration<Use> value) {
        this.use = value;
        return this;
    }

    public Use getUse() {
        return this.use == null ? null : (Use)((Object)this.use.getValue());
    }

    public Claim setUse(Use value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<Use>(new UseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Claim setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Claim setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Period getBillablePeriod() {
        if (this.billablePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.billablePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.billablePeriod = new Period();
            }
        }
        return this.billablePeriod;
    }

    public boolean hasBillablePeriod() {
        return this.billablePeriod != null && !this.billablePeriod.isEmpty();
    }

    public Claim setBillablePeriod(Period value) {
        this.billablePeriod = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public Claim setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public Claim setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public Claim setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Practitioner getEntererTarget() {
        if (this.entererTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.entererTarget = new Practitioner();
            }
        }
        return this.entererTarget;
    }

    public Claim setEntererTarget(Practitioner value) {
        this.entererTarget = value;
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public Claim setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Organization getInsurerTarget() {
        if (this.insurerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurerTarget = new Organization();
            }
        }
        return this.insurerTarget;
    }

    public Claim setInsurerTarget(Organization value) {
        this.insurerTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public Claim setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Practitioner getProviderTarget() {
        if (this.providerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.providerTarget = new Practitioner();
            }
        }
        return this.providerTarget;
    }

    public Claim setProviderTarget(Practitioner value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public Claim setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public Claim setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Claim setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public CodeableConcept getFundsReserve() {
        if (this.fundsReserve == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.fundsReserve");
            }
            if (Configuration.doAutoCreate()) {
                this.fundsReserve = new CodeableConcept();
            }
        }
        return this.fundsReserve;
    }

    public boolean hasFundsReserve() {
        return this.fundsReserve != null && !this.fundsReserve.isEmpty();
    }

    public Claim setFundsReserve(CodeableConcept value) {
        this.fundsReserve = value;
        return this;
    }

    public List<RelatedClaimComponent> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimComponent>();
        }
        return this.related;
    }

    public Claim setRelated(List<RelatedClaimComponent> theRelated) {
        this.related = theRelated;
        return this;
    }

    public boolean hasRelated() {
        if (this.related == null) {
            return false;
        }
        for (RelatedClaimComponent item : this.related) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedClaimComponent addRelated() {
        RelatedClaimComponent t = new RelatedClaimComponent();
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimComponent>();
        }
        this.related.add(t);
        return t;
    }

    public Claim addRelated(RelatedClaimComponent t) {
        if (t == null) {
            return this;
        }
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimComponent>();
        }
        this.related.add(t);
        return this;
    }

    public RelatedClaimComponent getRelatedFirstRep() {
        if (this.getRelated().isEmpty()) {
            this.addRelated();
        }
        return this.getRelated().get(0);
    }

    public Reference getPrescription() {
        if (this.prescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.prescription");
            }
            if (Configuration.doAutoCreate()) {
                this.prescription = new Reference();
            }
        }
        return this.prescription;
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    public Claim setPrescription(Reference value) {
        this.prescription = value;
        return this;
    }

    public Resource getPrescriptionTarget() {
        return this.prescriptionTarget;
    }

    public Claim setPrescriptionTarget(Resource value) {
        this.prescriptionTarget = value;
        return this;
    }

    public Reference getOriginalPrescription() {
        if (this.originalPrescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.originalPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.originalPrescription = new Reference();
            }
        }
        return this.originalPrescription;
    }

    public boolean hasOriginalPrescription() {
        return this.originalPrescription != null && !this.originalPrescription.isEmpty();
    }

    public Claim setOriginalPrescription(Reference value) {
        this.originalPrescription = value;
        return this;
    }

    public MedicationRequest getOriginalPrescriptionTarget() {
        if (this.originalPrescriptionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.originalPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.originalPrescriptionTarget = new MedicationRequest();
            }
        }
        return this.originalPrescriptionTarget;
    }

    public Claim setOriginalPrescriptionTarget(MedicationRequest value) {
        this.originalPrescriptionTarget = value;
        return this;
    }

    public PayeeComponent getPayee() {
        if (this.payee == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.payee");
            }
            if (Configuration.doAutoCreate()) {
                this.payee = new PayeeComponent();
            }
        }
        return this.payee;
    }

    public boolean hasPayee() {
        return this.payee != null && !this.payee.isEmpty();
    }

    public Claim setPayee(PayeeComponent value) {
        this.payee = value;
        return this;
    }

    public Reference getReferral() {
        if (this.referral == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.referral");
            }
            if (Configuration.doAutoCreate()) {
                this.referral = new Reference();
            }
        }
        return this.referral;
    }

    public boolean hasReferral() {
        return this.referral != null && !this.referral.isEmpty();
    }

    public Claim setReferral(Reference value) {
        this.referral = value;
        return this;
    }

    public ReferralRequest getReferralTarget() {
        if (this.referralTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.referral");
            }
            if (Configuration.doAutoCreate()) {
                this.referralTarget = new ReferralRequest();
            }
        }
        return this.referralTarget;
    }

    public Claim setReferralTarget(ReferralRequest value) {
        this.referralTarget = value;
        return this;
    }

    public Reference getFacility() {
        if (this.facility == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facility = new Reference();
            }
        }
        return this.facility;
    }

    public boolean hasFacility() {
        return this.facility != null && !this.facility.isEmpty();
    }

    public Claim setFacility(Reference value) {
        this.facility = value;
        return this;
    }

    public Location getFacilityTarget() {
        if (this.facilityTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facilityTarget = new Location();
            }
        }
        return this.facilityTarget;
    }

    public Claim setFacilityTarget(Location value) {
        this.facilityTarget = value;
        return this;
    }

    public List<CareTeamComponent> getCareTeam() {
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<CareTeamComponent>();
        }
        return this.careTeam;
    }

    public Claim setCareTeam(List<CareTeamComponent> theCareTeam) {
        this.careTeam = theCareTeam;
        return this;
    }

    public boolean hasCareTeam() {
        if (this.careTeam == null) {
            return false;
        }
        for (CareTeamComponent item : this.careTeam) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CareTeamComponent addCareTeam() {
        CareTeamComponent t = new CareTeamComponent();
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<CareTeamComponent>();
        }
        this.careTeam.add(t);
        return t;
    }

    public Claim addCareTeam(CareTeamComponent t) {
        if (t == null) {
            return this;
        }
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<CareTeamComponent>();
        }
        this.careTeam.add(t);
        return this;
    }

    public CareTeamComponent getCareTeamFirstRep() {
        if (this.getCareTeam().isEmpty()) {
            this.addCareTeam();
        }
        return this.getCareTeam().get(0);
    }

    public List<SpecialConditionComponent> getInformation() {
        if (this.information == null) {
            this.information = new ArrayList<SpecialConditionComponent>();
        }
        return this.information;
    }

    public Claim setInformation(List<SpecialConditionComponent> theInformation) {
        this.information = theInformation;
        return this;
    }

    public boolean hasInformation() {
        if (this.information == null) {
            return false;
        }
        for (SpecialConditionComponent item : this.information) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecialConditionComponent addInformation() {
        SpecialConditionComponent t = new SpecialConditionComponent();
        if (this.information == null) {
            this.information = new ArrayList<SpecialConditionComponent>();
        }
        this.information.add(t);
        return t;
    }

    public Claim addInformation(SpecialConditionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.information == null) {
            this.information = new ArrayList<SpecialConditionComponent>();
        }
        this.information.add(t);
        return this;
    }

    public SpecialConditionComponent getInformationFirstRep() {
        if (this.getInformation().isEmpty()) {
            this.addInformation();
        }
        return this.getInformation().get(0);
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public Claim setDiagnosis(List<DiagnosisComponent> theDiagnosis) {
        this.diagnosis = theDiagnosis;
        return this;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public Claim addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public DiagnosisComponent getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public List<ProcedureComponent> getProcedure() {
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        return this.procedure;
    }

    public Claim setProcedure(List<ProcedureComponent> theProcedure) {
        this.procedure = theProcedure;
        return this;
    }

    public boolean hasProcedure() {
        if (this.procedure == null) {
            return false;
        }
        for (ProcedureComponent item : this.procedure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedureComponent addProcedure() {
        ProcedureComponent t = new ProcedureComponent();
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        this.procedure.add(t);
        return t;
    }

    public Claim addProcedure(ProcedureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        this.procedure.add(t);
        return this;
    }

    public ProcedureComponent getProcedureFirstRep() {
        if (this.getProcedure().isEmpty()) {
            this.addProcedure();
        }
        return this.getProcedure().get(0);
    }

    public List<InsuranceComponent> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        return this.insurance;
    }

    public Claim setInsurance(List<InsuranceComponent> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (InsuranceComponent item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsuranceComponent addInsurance() {
        InsuranceComponent t = new InsuranceComponent();
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return t;
    }

    public Claim addInsurance(InsuranceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return this;
    }

    public InsuranceComponent getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public AccidentComponent getAccident() {
        if (this.accident == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.accident");
            }
            if (Configuration.doAutoCreate()) {
                this.accident = new AccidentComponent();
            }
        }
        return this.accident;
    }

    public boolean hasAccident() {
        return this.accident != null && !this.accident.isEmpty();
    }

    public Claim setAccident(AccidentComponent value) {
        this.accident = value;
        return this;
    }

    public Period getEmploymentImpacted() {
        if (this.employmentImpacted == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.employmentImpacted");
            }
            if (Configuration.doAutoCreate()) {
                this.employmentImpacted = new Period();
            }
        }
        return this.employmentImpacted;
    }

    public boolean hasEmploymentImpacted() {
        return this.employmentImpacted != null && !this.employmentImpacted.isEmpty();
    }

    public Claim setEmploymentImpacted(Period value) {
        this.employmentImpacted = value;
        return this;
    }

    public Period getHospitalization() {
        if (this.hospitalization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.hospitalization");
            }
            if (Configuration.doAutoCreate()) {
                this.hospitalization = new Period();
            }
        }
        return this.hospitalization;
    }

    public boolean hasHospitalization() {
        return this.hospitalization != null && !this.hospitalization.isEmpty();
    }

    public Claim setHospitalization(Period value) {
        this.hospitalization = value;
        return this;
    }

    public List<ItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        return this.item;
    }

    public Claim setItem(List<ItemComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemComponent addItem() {
        ItemComponent t = new ItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public Claim addItem(ItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public ItemComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    public Money getTotal() {
        if (this.total == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.total");
            }
            if (Configuration.doAutoCreate()) {
                this.total = new Money();
            }
        }
        return this.total;
    }

    public boolean hasTotal() {
        return this.total != null && !this.total.isEmpty();
    }

    public Claim setTotal(Money value) {
        this.total = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The business identifier for the instance: claim number, pre-determination or pre-authorization number.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("status", "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("type", "CodeableConcept", "The category of claim, eg, oral, pharmacy, vision, insitutional, professional.", 0, 1, this.type));
        children.add(new Property("subType", "CodeableConcept", "A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the BillType.", 0, Integer.MAX_VALUE, this.subType));
        children.add(new Property(SP_USE, "code", "Complete (Bill or Claim), Proposed (Pre-Authorization), Exploratory (Pre-determination).", 0, 1, this.use));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, 1, this.patient));
        children.add(new Property("billablePeriod", "Period", "The billable period for which charges are being submitted.", 0, 1, this.billablePeriod));
        children.add(new Property(SP_CREATED, "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created));
        children.add(new Property(SP_ENTERER, "Reference(Practitioner)", "Person who created the invoice/claim/pre-determination or pre-authorization.", 0, 1, this.enterer));
        children.add(new Property(SP_INSURER, "Reference(Organization)", "The Insurer who is target of the request.", 0, 1, this.insurer));
        children.add(new Property(SP_PROVIDER, "Reference(Practitioner)", "The provider which is responsible for the bill, claim pre-determination, pre-authorization.", 0, 1, this.provider));
        children.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization which is responsible for the bill, claim pre-determination, pre-authorization.", 0, 1, this.organization));
        children.add(new Property(SP_PRIORITY, "CodeableConcept", "Immediate (STAT), best effort (NORMAL), deferred (DEFER).", 0, 1, this.priority));
        children.add(new Property("fundsReserve", "CodeableConcept", "In the case of a Pre-Determination/Pre-Authorization the provider may request that funds in the amount of the expected Benefit be reserved ('Patient' or 'Provider') to pay for the Benefits determined on the subsequent claim(s). 'None' explicitly indicates no funds reserving is requested.", 0, 1, this.fundsReserve));
        children.add(new Property("related", "", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, Integer.MAX_VALUE, this.related));
        children.add(new Property("prescription", "Reference(MedicationRequest|VisionPrescription)", "Prescription to support the dispensing of Pharmacy or Vision products.", 0, 1, this.prescription));
        children.add(new Property("originalPrescription", "Reference(MedicationRequest)", "Original prescription which has been superceded by this prescription to support the dispensing of pharmacy services, medications or products. For example, a physician may prescribe a medication which the pharmacy determines is contraindicated, or for which the patient has an intolerance, and therefor issues a new precription for an alternate medication which has the same theraputic intent. The prescription from the pharmacy becomes the 'prescription' and that from the physician becomes the 'original prescription'.", 0, 1, this.originalPrescription));
        children.add(new Property(SP_PAYEE, "", "The party to be reimbursed for the services.", 0, 1, this.payee));
        children.add(new Property("referral", "Reference(ReferralRequest)", "The referral resource which lists the date, practitioner, reason and other supporting information.", 0, 1, this.referral));
        children.add(new Property(SP_FACILITY, "Reference(Location)", "Facility where the services were provided.", 0, 1, this.facility));
        children.add(new Property("careTeam", "", "The members of the team who provided the overall service as well as their role and whether responsible and qualifications.", 0, Integer.MAX_VALUE, this.careTeam));
        children.add(new Property("information", "", "Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues. Often there are mutiple jurisdiction specific valuesets which are required.", 0, Integer.MAX_VALUE, this.information));
        children.add(new Property("diagnosis", "", "List of patient diagnosis for which care is sought.", 0, Integer.MAX_VALUE, this.diagnosis));
        children.add(new Property("procedure", "", "Ordered list of patient procedures performed to support the adjudication.", 0, Integer.MAX_VALUE, this.procedure));
        children.add(new Property("insurance", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("accident", "", "An accident which resulted in the need for healthcare services.", 0, 1, this.accident));
        children.add(new Property("employmentImpacted", "Period", "The start and optional end dates of when the patient was precluded from working due to the treatable condition(s).", 0, 1, this.employmentImpacted));
        children.add(new Property("hospitalization", "Period", "The start and optional end dates of when the patient was confined to a treatment center.", 0, 1, this.hospitalization));
        children.add(new Property("item", "", "First tier of goods and services.", 0, Integer.MAX_VALUE, this.item));
        children.add(new Property("total", "Money", "The total value of the claim.", 0, 1, this.total));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The business identifier for the instance: claim number, pre-determination or pre-authorization number.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The category of claim, eg, oral, pharmacy, vision, insitutional, professional.", 0, 1, this.type);
            }
            case -1868521062: {
                return new Property("subType", "CodeableConcept", "A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the BillType.", 0, Integer.MAX_VALUE, this.subType);
            }
            case 116103: {
                return new Property(SP_USE, "code", "Complete (Bill or Claim), Proposed (Pre-Authorization), Exploratory (Pre-determination).", 0, 1, this.use);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, 1, this.patient);
            }
            case -332066046: {
                return new Property("billablePeriod", "Period", "The billable period for which charges are being submitted.", 0, 1, this.billablePeriod);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created);
            }
            case -1591951995: {
                return new Property(SP_ENTERER, "Reference(Practitioner)", "Person who created the invoice/claim/pre-determination or pre-authorization.", 0, 1, this.enterer);
            }
            case 1957615864: {
                return new Property(SP_INSURER, "Reference(Organization)", "The Insurer who is target of the request.", 0, 1, this.insurer);
            }
            case -987494927: {
                return new Property(SP_PROVIDER, "Reference(Practitioner)", "The provider which is responsible for the bill, claim pre-determination, pre-authorization.", 0, 1, this.provider);
            }
            case 1178922291: {
                return new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization which is responsible for the bill, claim pre-determination, pre-authorization.", 0, 1, this.organization);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, "CodeableConcept", "Immediate (STAT), best effort (NORMAL), deferred (DEFER).", 0, 1, this.priority);
            }
            case 1314609806: {
                return new Property("fundsReserve", "CodeableConcept", "In the case of a Pre-Determination/Pre-Authorization the provider may request that funds in the amount of the expected Benefit be reserved ('Patient' or 'Provider') to pay for the Benefits determined on the subsequent claim(s). 'None' explicitly indicates no funds reserving is requested.", 0, 1, this.fundsReserve);
            }
            case 1090493483: {
                return new Property("related", "", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, Integer.MAX_VALUE, this.related);
            }
            case 460301338: {
                return new Property("prescription", "Reference(MedicationRequest|VisionPrescription)", "Prescription to support the dispensing of Pharmacy or Vision products.", 0, 1, this.prescription);
            }
            case -1814015861: {
                return new Property("originalPrescription", "Reference(MedicationRequest)", "Original prescription which has been superceded by this prescription to support the dispensing of pharmacy services, medications or products. For example, a physician may prescribe a medication which the pharmacy determines is contraindicated, or for which the patient has an intolerance, and therefor issues a new precription for an alternate medication which has the same theraputic intent. The prescription from the pharmacy becomes the 'prescription' and that from the physician becomes the 'original prescription'.", 0, 1, this.originalPrescription);
            }
            case 106443592: {
                return new Property(SP_PAYEE, "", "The party to be reimbursed for the services.", 0, 1, this.payee);
            }
            case -722568291: {
                return new Property("referral", "Reference(ReferralRequest)", "The referral resource which lists the date, practitioner, reason and other supporting information.", 0, 1, this.referral);
            }
            case 501116579: {
                return new Property(SP_FACILITY, "Reference(Location)", "Facility where the services were provided.", 0, 1, this.facility);
            }
            case -7323378: {
                return new Property("careTeam", "", "The members of the team who provided the overall service as well as their role and whether responsible and qualifications.", 0, Integer.MAX_VALUE, this.careTeam);
            }
            case 1968600364: {
                return new Property("information", "", "Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues. Often there are mutiple jurisdiction specific valuesets which are required.", 0, Integer.MAX_VALUE, this.information);
            }
            case 1196993265: {
                return new Property("diagnosis", "", "List of patient diagnosis for which care is sought.", 0, Integer.MAX_VALUE, this.diagnosis);
            }
            case -1095204141: {
                return new Property("procedure", "", "Ordered list of patient procedures performed to support the adjudication.", 0, Integer.MAX_VALUE, this.procedure);
            }
            case 73049818: {
                return new Property("insurance", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case -2143202801: {
                return new Property("accident", "", "An accident which resulted in the need for healthcare services.", 0, 1, this.accident);
            }
            case 1051487345: {
                return new Property("employmentImpacted", "Period", "The start and optional end dates of when the patient was precluded from working due to the treatable condition(s).", 0, 1, this.employmentImpacted);
            }
            case 1057894634: {
                return new Property("hospitalization", "Period", "The start and optional end dates of when the patient was confined to a treatment center.", 0, 1, this.hospitalization);
            }
            case 3242771: {
                return new Property("item", "", "First tier of goods and services.", 0, Integer.MAX_VALUE, this.item);
            }
            case 110549828: {
                return new Property("total", "Money", "The total value of the claim.", 0, 1, this.total);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1868521062: {
                return this.subType == null ? new Base[]{} : this.subType.toArray(new Base[this.subType.size()]);
            }
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.use;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.patient;
                }
                return baseArray;
            }
            case -332066046: {
                Base[] baseArray;
                if (this.billablePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.billablePeriod;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.created;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.enterer;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.insurer;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.provider;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.organization;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.priority;
                }
                return baseArray;
            }
            case 1314609806: {
                Base[] baseArray;
                if (this.fundsReserve == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.fundsReserve;
                }
                return baseArray;
            }
            case 1090493483: {
                return this.related == null ? new Base[]{} : this.related.toArray(new Base[this.related.size()]);
            }
            case 460301338: {
                Base[] baseArray;
                if (this.prescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.prescription;
                }
                return baseArray;
            }
            case -1814015861: {
                Base[] baseArray;
                if (this.originalPrescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.originalPrescription;
                }
                return baseArray;
            }
            case 106443592: {
                Base[] baseArray;
                if (this.payee == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.payee;
                }
                return baseArray;
            }
            case -722568291: {
                Base[] baseArray;
                if (this.referral == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.referral;
                }
                return baseArray;
            }
            case 501116579: {
                Base[] baseArray;
                if (this.facility == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.facility;
                }
                return baseArray;
            }
            case -7323378: {
                return this.careTeam == null ? new Base[]{} : this.careTeam.toArray(new Base[this.careTeam.size()]);
            }
            case 1968600364: {
                return this.information == null ? new Base[]{} : this.information.toArray(new Base[this.information.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -1095204141: {
                return this.procedure == null ? new Base[]{} : this.procedure.toArray(new Base[this.procedure.size()]);
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case -2143202801: {
                Base[] baseArray;
                if (this.accident == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.accident;
                }
                return baseArray;
            }
            case 1051487345: {
                Base[] baseArray;
                if (this.employmentImpacted == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.employmentImpacted;
                }
                return baseArray;
            }
            case 1057894634: {
                Base[] baseArray;
                if (this.hospitalization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.hospitalization;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
            case 110549828: {
                Base[] baseArray;
                if (this.total == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.total;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ClaimStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1868521062: {
                this.getSubType().add(this.castToCodeableConcept(value));
                return value;
            }
            case 116103: {
                value = new UseEnumFactory().fromType(this.castToCode(value));
                this.use = value;
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case -332066046: {
                this.billablePeriod = this.castToPeriod(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case -1591951995: {
                this.enterer = this.castToReference(value);
                return value;
            }
            case 1957615864: {
                this.insurer = this.castToReference(value);
                return value;
            }
            case -987494927: {
                this.provider = this.castToReference(value);
                return value;
            }
            case 1178922291: {
                this.organization = this.castToReference(value);
                return value;
            }
            case -1165461084: {
                this.priority = this.castToCodeableConcept(value);
                return value;
            }
            case 1314609806: {
                this.fundsReserve = this.castToCodeableConcept(value);
                return value;
            }
            case 1090493483: {
                this.getRelated().add((RelatedClaimComponent)((Object)value));
                return value;
            }
            case 460301338: {
                this.prescription = this.castToReference(value);
                return value;
            }
            case -1814015861: {
                this.originalPrescription = this.castToReference(value);
                return value;
            }
            case 106443592: {
                this.payee = (PayeeComponent)((Object)value);
                return value;
            }
            case -722568291: {
                this.referral = this.castToReference(value);
                return value;
            }
            case 501116579: {
                this.facility = this.castToReference(value);
                return value;
            }
            case -7323378: {
                this.getCareTeam().add((CareTeamComponent)((Object)value));
                return value;
            }
            case 1968600364: {
                this.getInformation().add((SpecialConditionComponent)((Object)value));
                return value;
            }
            case 1196993265: {
                this.getDiagnosis().add((DiagnosisComponent)((Object)value));
                return value;
            }
            case -1095204141: {
                this.getProcedure().add((ProcedureComponent)((Object)value));
                return value;
            }
            case 73049818: {
                this.getInsurance().add((InsuranceComponent)((Object)value));
                return value;
            }
            case -2143202801: {
                this.accident = (AccidentComponent)((Object)value);
                return value;
            }
            case 1051487345: {
                this.employmentImpacted = this.castToPeriod(value);
                return value;
            }
            case 1057894634: {
                this.hospitalization = this.castToPeriod(value);
                return value;
            }
            case 3242771: {
                this.getItem().add((ItemComponent)((Object)value));
                return value;
            }
            case 110549828: {
                this.total = this.castToMoney(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("status")) {
            value = new ClaimStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("subType")) {
            this.getSubType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_USE)) {
            value = new UseEnumFactory().fromType(this.castToCode(value));
            this.use = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("billablePeriod")) {
            this.billablePeriod = this.castToPeriod(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = this.castToReference(value);
        } else if (name.equals(SP_INSURER)) {
            this.insurer = this.castToReference(value);
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = this.castToReference(value);
        } else if (name.equals(SP_ORGANIZATION)) {
            this.organization = this.castToReference(value);
        } else if (name.equals(SP_PRIORITY)) {
            this.priority = this.castToCodeableConcept(value);
        } else if (name.equals("fundsReserve")) {
            this.fundsReserve = this.castToCodeableConcept(value);
        } else if (name.equals("related")) {
            this.getRelated().add((RelatedClaimComponent)((Object)value));
        } else if (name.equals("prescription")) {
            this.prescription = this.castToReference(value);
        } else if (name.equals("originalPrescription")) {
            this.originalPrescription = this.castToReference(value);
        } else if (name.equals(SP_PAYEE)) {
            this.payee = (PayeeComponent)((Object)value);
        } else if (name.equals("referral")) {
            this.referral = this.castToReference(value);
        } else if (name.equals(SP_FACILITY)) {
            this.facility = this.castToReference(value);
        } else if (name.equals("careTeam")) {
            this.getCareTeam().add((CareTeamComponent)((Object)value));
        } else if (name.equals("information")) {
            this.getInformation().add((SpecialConditionComponent)((Object)value));
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().add((DiagnosisComponent)((Object)value));
        } else if (name.equals("procedure")) {
            this.getProcedure().add((ProcedureComponent)((Object)value));
        } else if (name.equals("insurance")) {
            this.getInsurance().add((InsuranceComponent)((Object)value));
        } else if (name.equals("accident")) {
            this.accident = (AccidentComponent)((Object)value);
        } else if (name.equals("employmentImpacted")) {
            this.employmentImpacted = this.castToPeriod(value);
        } else if (name.equals("hospitalization")) {
            this.hospitalization = this.castToPeriod(value);
        } else if (name.equals("item")) {
            this.getItem().add((ItemComponent)((Object)value));
        } else if (name.equals("total")) {
            this.total = this.castToMoney(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1868521062: {
                return this.addSubType();
            }
            case 116103: {
                return this.getUseElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -332066046: {
                return this.getBillablePeriod();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case -987494927: {
                return this.getProvider();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case 1314609806: {
                return this.getFundsReserve();
            }
            case 1090493483: {
                return this.addRelated();
            }
            case 460301338: {
                return this.getPrescription();
            }
            case -1814015861: {
                return this.getOriginalPrescription();
            }
            case 106443592: {
                return this.getPayee();
            }
            case -722568291: {
                return this.getReferral();
            }
            case 501116579: {
                return this.getFacility();
            }
            case -7323378: {
                return this.addCareTeam();
            }
            case 1968600364: {
                return this.addInformation();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -1095204141: {
                return this.addProcedure();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case -2143202801: {
                return this.getAccident();
            }
            case 1051487345: {
                return this.getEmploymentImpacted();
            }
            case 1057894634: {
                return this.getHospitalization();
            }
            case 3242771: {
                return this.addItem();
            }
            case 110549828: {
                return this.getTotal();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1868521062: {
                return new String[]{"CodeableConcept"};
            }
            case 116103: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -332066046: {
                return new String[]{"Period"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case -987494927: {
                return new String[]{"Reference"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case 1314609806: {
                return new String[]{"CodeableConcept"};
            }
            case 1090493483: {
                return new String[0];
            }
            case 460301338: {
                return new String[]{"Reference"};
            }
            case -1814015861: {
                return new String[]{"Reference"};
            }
            case 106443592: {
                return new String[0];
            }
            case -722568291: {
                return new String[]{"Reference"};
            }
            case 501116579: {
                return new String[]{"Reference"};
            }
            case -7323378: {
                return new String[0];
            }
            case 1968600364: {
                return new String[0];
            }
            case 1196993265: {
                return new String[0];
            }
            case -1095204141: {
                return new String[0];
            }
            case 73049818: {
                return new String[0];
            }
            case -2143202801: {
                return new String[0];
            }
            case 1051487345: {
                return new String[]{"Period"};
            }
            case 1057894634: {
                return new String[]{"Period"};
            }
            case 3242771: {
                return new String[0];
            }
            case 110549828: {
                return new String[]{"Money"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type Claim.status");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("subType")) {
            return this.addSubType();
        }
        if (name.equals(SP_USE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Claim.use");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("billablePeriod")) {
            this.billablePeriod = new Period();
            return this.billablePeriod;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type Claim.created");
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals(SP_INSURER)) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals(SP_PROVIDER)) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals(SP_ORGANIZATION)) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals(SP_PRIORITY)) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals("fundsReserve")) {
            this.fundsReserve = new CodeableConcept();
            return this.fundsReserve;
        }
        if (name.equals("related")) {
            return this.addRelated();
        }
        if (name.equals("prescription")) {
            this.prescription = new Reference();
            return this.prescription;
        }
        if (name.equals("originalPrescription")) {
            this.originalPrescription = new Reference();
            return this.originalPrescription;
        }
        if (name.equals(SP_PAYEE)) {
            this.payee = new PayeeComponent();
            return this.payee;
        }
        if (name.equals("referral")) {
            this.referral = new Reference();
            return this.referral;
        }
        if (name.equals(SP_FACILITY)) {
            this.facility = new Reference();
            return this.facility;
        }
        if (name.equals("careTeam")) {
            return this.addCareTeam();
        }
        if (name.equals("information")) {
            return this.addInformation();
        }
        if (name.equals("diagnosis")) {
            return this.addDiagnosis();
        }
        if (name.equals("procedure")) {
            return this.addProcedure();
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("accident")) {
            this.accident = new AccidentComponent();
            return this.accident;
        }
        if (name.equals("employmentImpacted")) {
            this.employmentImpacted = new Period();
            return this.employmentImpacted;
        }
        if (name.equals("hospitalization")) {
            this.hospitalization = new Period();
            return this.hospitalization;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("total")) {
            this.total = new Money();
            return this.total;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Claim";
    }

    @Override
    public Claim copy() {
        Claim dst = new Claim();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.subType != null) {
            dst.subType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.subType) {
                dst.subType.add(codeableConcept2.copy());
            }
        }
        dst.use = this.use == null ? null : this.use.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.billablePeriod = this.billablePeriod == null ? null : this.billablePeriod.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        CodeableConcept codeableConcept3 = dst.fundsReserve = this.fundsReserve == null ? null : this.fundsReserve.copy();
        if (this.related != null) {
            dst.related = new ArrayList<RelatedClaimComponent>();
            for (RelatedClaimComponent relatedClaimComponent : this.related) {
                dst.related.add(relatedClaimComponent.copy());
            }
        }
        dst.prescription = this.prescription == null ? null : this.prescription.copy();
        dst.originalPrescription = this.originalPrescription == null ? null : this.originalPrescription.copy();
        dst.payee = this.payee == null ? null : this.payee.copy();
        dst.referral = this.referral == null ? null : this.referral.copy();
        Reference reference = dst.facility = this.facility == null ? null : this.facility.copy();
        if (this.careTeam != null) {
            dst.careTeam = new ArrayList<CareTeamComponent>();
            for (CareTeamComponent careTeamComponent : this.careTeam) {
                dst.careTeam.add(careTeamComponent.copy());
            }
        }
        if (this.information != null) {
            dst.information = new ArrayList<SpecialConditionComponent>();
            for (SpecialConditionComponent specialConditionComponent : this.information) {
                dst.information.add(specialConditionComponent.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        if (this.procedure != null) {
            dst.procedure = new ArrayList<ProcedureComponent>();
            for (ProcedureComponent procedureComponent : this.procedure) {
                dst.procedure.add(procedureComponent.copy());
            }
        }
        if (this.insurance != null) {
            dst.insurance = new ArrayList<InsuranceComponent>();
            for (InsuranceComponent insuranceComponent : this.insurance) {
                dst.insurance.add(insuranceComponent.copy());
            }
        }
        dst.accident = this.accident == null ? null : this.accident.copy();
        dst.employmentImpacted = this.employmentImpacted == null ? null : this.employmentImpacted.copy();
        Period period = dst.hospitalization = this.hospitalization == null ? null : this.hospitalization.copy();
        if (this.item != null) {
            dst.item = new ArrayList<ItemComponent>();
            for (ItemComponent itemComponent : this.item) {
                dst.item.add(itemComponent.copy());
            }
        }
        dst.total = this.total == null ? null : this.total.copy();
        return dst;
    }

    protected Claim typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Claim)) {
            return false;
        }
        Claim o = (Claim)other_;
        return Claim.compareDeep(this.identifier, o.identifier, true) && Claim.compareDeep(this.status, o.status, true) && Claim.compareDeep(this.type, o.type, true) && Claim.compareDeep(this.subType, o.subType, true) && Claim.compareDeep(this.use, o.use, true) && Claim.compareDeep(this.patient, o.patient, true) && Claim.compareDeep(this.billablePeriod, o.billablePeriod, true) && Claim.compareDeep(this.created, o.created, true) && Claim.compareDeep(this.enterer, o.enterer, true) && Claim.compareDeep(this.insurer, o.insurer, true) && Claim.compareDeep(this.provider, o.provider, true) && Claim.compareDeep(this.organization, o.organization, true) && Claim.compareDeep(this.priority, o.priority, true) && Claim.compareDeep(this.fundsReserve, o.fundsReserve, true) && Claim.compareDeep(this.related, o.related, true) && Claim.compareDeep(this.prescription, o.prescription, true) && Claim.compareDeep(this.originalPrescription, o.originalPrescription, true) && Claim.compareDeep(this.payee, o.payee, true) && Claim.compareDeep(this.referral, o.referral, true) && Claim.compareDeep(this.facility, o.facility, true) && Claim.compareDeep(this.careTeam, o.careTeam, true) && Claim.compareDeep(this.information, o.information, true) && Claim.compareDeep(this.diagnosis, o.diagnosis, true) && Claim.compareDeep(this.procedure, o.procedure, true) && Claim.compareDeep(this.insurance, o.insurance, true) && Claim.compareDeep(this.accident, o.accident, true) && Claim.compareDeep(this.employmentImpacted, o.employmentImpacted, true) && Claim.compareDeep(this.hospitalization, o.hospitalization, true) && Claim.compareDeep(this.item, o.item, true) && Claim.compareDeep(this.total, o.total, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Claim)) {
            return false;
        }
        Claim o = (Claim)other_;
        return Claim.compareValues(this.status, o.status, true) && Claim.compareValues(this.use, o.use, true) && Claim.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.type, this.subType, this.use, this.patient, this.billablePeriod, this.created, this.enterer, this.insurer, this.provider, this.organization, this.priority, this.fundsReserve, this.related, this.prescription, this.originalPrescription, this.payee, this.referral, this.facility, this.careTeam, this.information, this.diagnosis, this.procedure, this.insurance, this.accident, this.employmentImpacted, this.hospitalization, this.item, this.total});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Claim;
    }

    @Block
    public static class SubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="revenue", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of reveneu or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of service or product", formalDefinition="Health Care Service Type Codes  to identify the classification of service or benefits.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-subcategory")
        protected CodeableConcept category;
        @Child(name="service", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing Code", formalDefinition="A code to indicate the Professional Service or Product supplied (eg. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept service;
        @Child(name="modifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="quantity", type={SimpleQuantity.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="The fee for an addittional service or product or charge.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Net additional item cost", formalDefinition="The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        private static final long serialVersionUID = -1210367567L;

        public SubDetailComponent() {
        }

        public SubDetailComponent(PositiveIntType sequence) {
            this.sequence = sequence;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SubDetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public SubDetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public SubDetailComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SubDetailComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new CodeableConcept();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public SubDetailComponent setService(CodeableConcept value) {
            this.service = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public SubDetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public SubDetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public SubDetailComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public SubDetailComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SubDetailComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public SubDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public SubDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public SubDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public SubDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public SubDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public SubDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public SubDetailComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public SubDetailComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence));
            children.add(new Property("revenue", "CodeableConcept", "The type of reveneu or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("category", "CodeableConcept", "Health Care Service Type Codes  to identify the classification of service or benefits.", 0, 1, this.category));
            children.add(new Property("service", "CodeableConcept", "A code to indicate the Professional Service or Product supplied (eg. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI).", 0, 1, this.service));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "The fee for an addittional service or product or charge.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of reveneu or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Health Care Service Type Codes  to identify the classification of service or benefits.", 0, 1, this.category);
                }
                case 1984153269: {
                    return new Property("service", "CodeableConcept", "A code to indicate the Professional Service or Product supplied (eg. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI).", 0, 1, this.service);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "The fee for an addittional service or product or charge.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case 1984153269: {
                    Base[] baseArray;
                    if (this.service == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.service;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1099842588: {
                    this.revenue = this.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 1984153269: {
                    this.service = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("revenue")) {
                this.revenue = this.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("service")) {
                this.service = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 1984153269: {
                    return this.getService();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1984153269: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.sequence");
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("service")) {
                this.service = new CodeableConcept();
                return this.service;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailComponent copy() {
            SubDetailComponent dst = new SubDetailComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.service = this.service == null ? null : this.service.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareDeep(this.sequence, o.sequence, true) && SubDetailComponent.compareDeep(this.revenue, o.revenue, true) && SubDetailComponent.compareDeep(this.category, o.category, true) && SubDetailComponent.compareDeep(this.service, o.service, true) && SubDetailComponent.compareDeep(this.modifier, o.modifier, true) && SubDetailComponent.compareDeep(this.programCode, o.programCode, true) && SubDetailComponent.compareDeep(this.quantity, o.quantity, true) && SubDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && SubDetailComponent.compareDeep(this.factor, o.factor, true) && SubDetailComponent.compareDeep(this.net, o.net, true) && SubDetailComponent.compareDeep(this.udi, o.udi, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareValues(this.sequence, o.sequence, true) && SubDetailComponent.compareValues(this.factor, o.factor, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.revenue, this.category, this.service, this.modifier, this.programCode, this.quantity, this.unitPrice, this.factor, this.net, this.udi});
        }

        @Override
        public String fhirType() {
            return "Claim.item.detail.subDetail";
        }
    }

    @Block
    public static class DetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="revenue", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of reveneu or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of service or product", formalDefinition="Health Care Service Type Codes  to identify the classification of service or benefits.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-subcategory")
        protected CodeableConcept category;
        @Child(name="service", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing Code", formalDefinition="If this is an actual service or product line, ie. not a Group, then use code to indicate the Professional Service or Product supplied (eg. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept service;
        @Child(name="modifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="quantity", type={SimpleQuantity.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total additional item cost", formalDefinition="The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="subDetail", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional items", formalDefinition="Third tier of goods and services.")
        protected List<SubDetailComponent> subDetail;
        private static final long serialVersionUID = 718584656L;

        public DetailComponent() {
        }

        public DetailComponent(PositiveIntType sequence) {
            this.sequence = sequence;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public DetailComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public DetailComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new CodeableConcept();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public DetailComponent setService(CodeableConcept value) {
            this.service = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public DetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public DetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public DetailComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public DetailComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public DetailComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public DetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public DetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public DetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public DetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public DetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public DetailComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public DetailComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public List<SubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            return this.subDetail;
        }

        public DetailComponent setSubDetail(List<SubDetailComponent> theSubDetail) {
            this.subDetail = theSubDetail;
            return this;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (SubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailComponent addSubDetail() {
            SubDetailComponent t = new SubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public DetailComponent addSubDetail(SubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        public SubDetailComponent getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence));
            children.add(new Property("revenue", "CodeableConcept", "The type of reveneu or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("category", "CodeableConcept", "Health Care Service Type Codes  to identify the classification of service or benefits.", 0, 1, this.category));
            children.add(new Property("service", "CodeableConcept", "If this is an actual service or product line, ie. not a Group, then use code to indicate the Professional Service or Product supplied (eg. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.service));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            children.add(new Property("subDetail", "", "Third tier of goods and services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of reveneu or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Health Care Service Type Codes  to identify the classification of service or benefits.", 0, 1, this.category);
                }
                case 1984153269: {
                    return new Property("service", "CodeableConcept", "If this is an actual service or product line, ie. not a Group, then use code to indicate the Professional Service or Product supplied (eg. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.service);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
                case -828829007: {
                    return new Property("subDetail", "", "Third tier of goods and services.", 0, Integer.MAX_VALUE, this.subDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case 1984153269: {
                    Base[] baseArray;
                    if (this.service == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.service;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1099842588: {
                    this.revenue = this.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 1984153269: {
                    this.service = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
                case -828829007: {
                    this.getSubDetail().add((SubDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("revenue")) {
                this.revenue = this.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("service")) {
                this.service = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((SubDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 1984153269: {
                    return this.getService();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1984153269: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
                case -828829007: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.sequence");
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("service")) {
                this.service = new CodeableConcept();
                return this.service;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public DetailComponent copy() {
            DetailComponent dst = new DetailComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.service = this.service == null ? null : this.service.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<SubDetailComponent>();
                for (SubDetailComponent subDetailComponent : this.subDetail) {
                    dst.subDetail.add(subDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other_;
            return DetailComponent.compareDeep(this.sequence, o.sequence, true) && DetailComponent.compareDeep(this.revenue, o.revenue, true) && DetailComponent.compareDeep(this.category, o.category, true) && DetailComponent.compareDeep(this.service, o.service, true) && DetailComponent.compareDeep(this.modifier, o.modifier, true) && DetailComponent.compareDeep(this.programCode, o.programCode, true) && DetailComponent.compareDeep(this.quantity, o.quantity, true) && DetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && DetailComponent.compareDeep(this.factor, o.factor, true) && DetailComponent.compareDeep(this.net, o.net, true) && DetailComponent.compareDeep(this.udi, o.udi, true) && DetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other_;
            return DetailComponent.compareValues(this.sequence, o.sequence, true) && DetailComponent.compareValues(this.factor, o.factor, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.revenue, this.category, this.service, this.modifier, this.programCode, this.quantity, this.unitPrice, this.factor, this.net, this.udi, this.subDetail});
        }

        @Override
        public String fhirType() {
            return "Claim.item.detail";
        }
    }

    @Block
    public static class ItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="careTeamLinkId", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable careTeam members", formalDefinition="CareTeam applicable for this service or product line.")
        protected List<PositiveIntType> careTeamLinkId;
        @Child(name="diagnosisLinkId", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable diagnoses", formalDefinition="Diagnosis applicable for this service or product line.")
        protected List<PositiveIntType> diagnosisLinkId;
        @Child(name="procedureLinkId", type={PositiveIntType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable procedures", formalDefinition="Procedures applicable for this service or product line.")
        protected List<PositiveIntType> procedureLinkId;
        @Child(name="informationLinkId", type={PositiveIntType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable exception and supporting information", formalDefinition="Exceptions, special conditions and supporting information pplicable for this service or product line.")
        protected List<PositiveIntType> informationLinkId;
        @Child(name="revenue", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of reveneu or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of service or product", formalDefinition="Health Care Service Type Codes  to identify the classification of service or benefits.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-subcategory")
        protected CodeableConcept category;
        @Child(name="service", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing Code", formalDefinition="If this is an actual service or product line, ie. not a Group, then use code to indicate the Professional Service or Product supplied (eg. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,RXNorm,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept service;
        @Child(name="modifier", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reason codes for the inclusion or covering of this billed item under the program or sub-program.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="serviced", type={DateType.class, Period.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date or dates of Service", formalDefinition="The date or dates when the enclosed suite of services were performed or completed.")
        protected Type serviced;
        @Child(name="location", type={CodeableConcept.class, Address.class, Location.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Place of service", formalDefinition="Where the service was provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-place")
        protected Type location;
        @Child(name="quantity", type={SimpleQuantity.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=17, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="bodySite", type={CodeableConcept.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service Location", formalDefinition="Physical service site on the patient (limb, tooth, etc).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/tooth")
        protected CodeableConcept bodySite;
        @Child(name="subSite", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service Sub-location", formalDefinition="A region or surface of the site, eg. limb region or tooth surface(s).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/surface")
        protected List<CodeableConcept> subSite;
        @Child(name="encounter", type={Encounter.class}, order=20, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Encounters related to this billed item", formalDefinition="A billed item may include goods or services provided in multiple encounters.")
        protected List<Reference> encounter;
        protected List<Encounter> encounterTarget;
        @Child(name="detail", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional items", formalDefinition="Second tier of goods and services.")
        protected List<DetailComponent> detail;
        private static final long serialVersionUID = 784765825L;

        public ItemComponent() {
        }

        public ItemComponent(PositiveIntType sequence) {
            this.sequence = sequence;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ItemComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ItemComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getCareTeamLinkId() {
            if (this.careTeamLinkId == null) {
                this.careTeamLinkId = new ArrayList<PositiveIntType>();
            }
            return this.careTeamLinkId;
        }

        public ItemComponent setCareTeamLinkId(List<PositiveIntType> theCareTeamLinkId) {
            this.careTeamLinkId = theCareTeamLinkId;
            return this;
        }

        public boolean hasCareTeamLinkId() {
            if (this.careTeamLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.careTeamLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addCareTeamLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.careTeamLinkId == null) {
                this.careTeamLinkId = new ArrayList<PositiveIntType>();
            }
            this.careTeamLinkId.add(t);
            return t;
        }

        public ItemComponent addCareTeamLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.careTeamLinkId == null) {
                this.careTeamLinkId = new ArrayList<PositiveIntType>();
            }
            this.careTeamLinkId.add(t);
            return this;
        }

        public boolean hasCareTeamLinkId(int value) {
            if (this.careTeamLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.careTeamLinkId) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getDiagnosisLinkId() {
            if (this.diagnosisLinkId == null) {
                this.diagnosisLinkId = new ArrayList<PositiveIntType>();
            }
            return this.diagnosisLinkId;
        }

        public ItemComponent setDiagnosisLinkId(List<PositiveIntType> theDiagnosisLinkId) {
            this.diagnosisLinkId = theDiagnosisLinkId;
            return this;
        }

        public boolean hasDiagnosisLinkId() {
            if (this.diagnosisLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.diagnosisLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addDiagnosisLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.diagnosisLinkId == null) {
                this.diagnosisLinkId = new ArrayList<PositiveIntType>();
            }
            this.diagnosisLinkId.add(t);
            return t;
        }

        public ItemComponent addDiagnosisLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.diagnosisLinkId == null) {
                this.diagnosisLinkId = new ArrayList<PositiveIntType>();
            }
            this.diagnosisLinkId.add(t);
            return this;
        }

        public boolean hasDiagnosisLinkId(int value) {
            if (this.diagnosisLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.diagnosisLinkId) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getProcedureLinkId() {
            if (this.procedureLinkId == null) {
                this.procedureLinkId = new ArrayList<PositiveIntType>();
            }
            return this.procedureLinkId;
        }

        public ItemComponent setProcedureLinkId(List<PositiveIntType> theProcedureLinkId) {
            this.procedureLinkId = theProcedureLinkId;
            return this;
        }

        public boolean hasProcedureLinkId() {
            if (this.procedureLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.procedureLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addProcedureLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.procedureLinkId == null) {
                this.procedureLinkId = new ArrayList<PositiveIntType>();
            }
            this.procedureLinkId.add(t);
            return t;
        }

        public ItemComponent addProcedureLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.procedureLinkId == null) {
                this.procedureLinkId = new ArrayList<PositiveIntType>();
            }
            this.procedureLinkId.add(t);
            return this;
        }

        public boolean hasProcedureLinkId(int value) {
            if (this.procedureLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.procedureLinkId) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getInformationLinkId() {
            if (this.informationLinkId == null) {
                this.informationLinkId = new ArrayList<PositiveIntType>();
            }
            return this.informationLinkId;
        }

        public ItemComponent setInformationLinkId(List<PositiveIntType> theInformationLinkId) {
            this.informationLinkId = theInformationLinkId;
            return this;
        }

        public boolean hasInformationLinkId() {
            if (this.informationLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.informationLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addInformationLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.informationLinkId == null) {
                this.informationLinkId = new ArrayList<PositiveIntType>();
            }
            this.informationLinkId.add(t);
            return t;
        }

        public ItemComponent addInformationLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.informationLinkId == null) {
                this.informationLinkId = new ArrayList<PositiveIntType>();
            }
            this.informationLinkId.add(t);
            return this;
        }

        public boolean hasInformationLinkId(int value) {
            if (this.informationLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.informationLinkId) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public ItemComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ItemComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new CodeableConcept();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public ItemComponent setService(CodeableConcept value) {
            this.service = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public ItemComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public ItemComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public ItemComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public ItemComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public Type getServiced() {
            return this.serviced;
        }

        public DateType getServicedDateType() throws FHIRException {
            if (this.serviced == null) {
                return null;
            }
            if (!(this.serviced instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (DateType)this.serviced;
        }

        public boolean hasServicedDateType() {
            return this != null && this.serviced instanceof DateType;
        }

        public Period getServicedPeriod() throws FHIRException {
            if (this.serviced == null) {
                return null;
            }
            if (!(this.serviced instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (Period)this.serviced;
        }

        public boolean hasServicedPeriod() {
            return this != null && this.serviced instanceof Period;
        }

        public boolean hasServiced() {
            return this.serviced != null && !this.serviced.isEmpty();
        }

        public ItemComponent setServiced(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new FHIRFormatError("Not the right type for Claim.item.serviced[x]: " + value.fhirType());
            }
            this.serviced = value;
            return this;
        }

        public Type getLocation() {
            return this.location;
        }

        public CodeableConcept getLocationCodeableConcept() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.location;
        }

        public boolean hasLocationCodeableConcept() {
            return this != null && this.location instanceof CodeableConcept;
        }

        public Address getLocationAddress() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Address)this.location;
        }

        public boolean hasLocationAddress() {
            return this != null && this.location instanceof Address;
        }

        public Reference getLocationReference() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Reference)this.location;
        }

        public boolean hasLocationReference() {
            return this != null && this.location instanceof Reference;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public ItemComponent setLocation(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Address || value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Claim.item.location[x]: " + value.fhirType());
            }
            this.location = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ItemComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public ItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public ItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public ItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public ItemComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public ItemComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public ItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public ItemComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public ItemComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public CodeableConcept getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new CodeableConcept();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public ItemComponent setBodySite(CodeableConcept value) {
            this.bodySite = value;
            return this;
        }

        public List<CodeableConcept> getSubSite() {
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            return this.subSite;
        }

        public ItemComponent setSubSite(List<CodeableConcept> theSubSite) {
            this.subSite = theSubSite;
            return this;
        }

        public boolean hasSubSite() {
            if (this.subSite == null) {
                return false;
            }
            for (CodeableConcept item : this.subSite) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSubSite() {
            CodeableConcept t = new CodeableConcept();
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return t;
        }

        public ItemComponent addSubSite(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return this;
        }

        public CodeableConcept getSubSiteFirstRep() {
            if (this.getSubSite().isEmpty()) {
                this.addSubSite();
            }
            return this.getSubSite().get(0);
        }

        public List<Reference> getEncounter() {
            if (this.encounter == null) {
                this.encounter = new ArrayList<Reference>();
            }
            return this.encounter;
        }

        public ItemComponent setEncounter(List<Reference> theEncounter) {
            this.encounter = theEncounter;
            return this;
        }

        public boolean hasEncounter() {
            if (this.encounter == null) {
                return false;
            }
            for (Reference item : this.encounter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEncounter() {
            Reference t = new Reference();
            if (this.encounter == null) {
                this.encounter = new ArrayList<Reference>();
            }
            this.encounter.add(t);
            return t;
        }

        public ItemComponent addEncounter(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.encounter == null) {
                this.encounter = new ArrayList<Reference>();
            }
            this.encounter.add(t);
            return this;
        }

        public Reference getEncounterFirstRep() {
            if (this.getEncounter().isEmpty()) {
                this.addEncounter();
            }
            return this.getEncounter().get(0);
        }

        @Deprecated
        public List<Encounter> getEncounterTarget() {
            if (this.encounterTarget == null) {
                this.encounterTarget = new ArrayList<Encounter>();
            }
            return this.encounterTarget;
        }

        @Deprecated
        public Encounter addEncounterTarget() {
            Encounter r = new Encounter();
            if (this.encounterTarget == null) {
                this.encounterTarget = new ArrayList<Encounter>();
            }
            this.encounterTarget.add(r);
            return r;
        }

        public List<DetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            return this.detail;
        }

        public ItemComponent setDetail(List<DetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (DetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DetailComponent addDetail() {
            DetailComponent t = new DetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public ItemComponent addDetail(DetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public DetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence));
            children.add(new Property("careTeamLinkId", "positiveInt", "CareTeam applicable for this service or product line.", 0, Integer.MAX_VALUE, this.careTeamLinkId));
            children.add(new Property("diagnosisLinkId", "positiveInt", "Diagnosis applicable for this service or product line.", 0, Integer.MAX_VALUE, this.diagnosisLinkId));
            children.add(new Property("procedureLinkId", "positiveInt", "Procedures applicable for this service or product line.", 0, Integer.MAX_VALUE, this.procedureLinkId));
            children.add(new Property("informationLinkId", "positiveInt", "Exceptions, special conditions and supporting information pplicable for this service or product line.", 0, Integer.MAX_VALUE, this.informationLinkId));
            children.add(new Property("revenue", "CodeableConcept", "The type of reveneu or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("category", "CodeableConcept", "Health Care Service Type Codes  to identify the classification of service or benefits.", 0, 1, this.category));
            children.add(new Property("service", "CodeableConcept", "If this is an actual service or product line, ie. not a Group, then use code to indicate the Professional Service or Product supplied (eg. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,RXNorm,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.service));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "For programs which require reason codes for the inclusion or covering of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced));
            children.add(new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            children.add(new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc).", 0, 1, this.bodySite));
            children.add(new Property("subSite", "CodeableConcept", "A region or surface of the site, eg. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite));
            children.add(new Property(Claim.SP_ENCOUNTER, "Reference(Encounter)", "A billed item may include goods or services provided in multiple encounters.", 0, Integer.MAX_VALUE, this.encounter));
            children.add(new Property("detail", "", "Second tier of goods and services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence);
                }
                case -186757789: {
                    return new Property("careTeamLinkId", "positiveInt", "CareTeam applicable for this service or product line.", 0, Integer.MAX_VALUE, this.careTeamLinkId);
                }
                case -1659207418: {
                    return new Property("diagnosisLinkId", "positiveInt", "Diagnosis applicable for this service or product line.", 0, Integer.MAX_VALUE, this.diagnosisLinkId);
                }
                case -532846744: {
                    return new Property("procedureLinkId", "positiveInt", "Procedures applicable for this service or product line.", 0, Integer.MAX_VALUE, this.procedureLinkId);
                }
                case 1965585153: {
                    return new Property("informationLinkId", "positiveInt", "Exceptions, special conditions and supporting information pplicable for this service or product line.", 0, Integer.MAX_VALUE, this.informationLinkId);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of reveneu or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Health Care Service Type Codes  to identify the classification of service or benefits.", 0, 1, this.category);
                }
                case 1984153269: {
                    return new Property("service", "CodeableConcept", "If this is an actual service or product line, ie. not a Group, then use code to indicate the Professional Service or Product supplied (eg. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,RXNorm,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.service);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "For programs which require reason codes for the inclusion or covering of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1927922223: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
                }
                case 1379209295: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
                }
                case 363246749: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
                }
                case 1534966512: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
                }
                case 552316075: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case 1901043637: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1224800468: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1280020865: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case 755866390: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
                case 1702620169: {
                    return new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc).", 0, 1, this.bodySite);
                }
                case -1868566105: {
                    return new Property("subSite", "CodeableConcept", "A region or surface of the site, eg. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite);
                }
                case 1524132147: {
                    return new Property(Claim.SP_ENCOUNTER, "Reference(Encounter)", "A billed item may include goods or services provided in multiple encounters.", 0, Integer.MAX_VALUE, this.encounter);
                }
                case -1335224239: {
                    return new Property("detail", "", "Second tier of goods and services.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case -186757789: {
                    return this.careTeamLinkId == null ? new Base[]{} : this.careTeamLinkId.toArray(new Base[this.careTeamLinkId.size()]);
                }
                case -1659207418: {
                    return this.diagnosisLinkId == null ? new Base[]{} : this.diagnosisLinkId.toArray(new Base[this.diagnosisLinkId.size()]);
                }
                case -532846744: {
                    return this.procedureLinkId == null ? new Base[]{} : this.procedureLinkId.toArray(new Base[this.procedureLinkId.size()]);
                }
                case 1965585153: {
                    return this.informationLinkId == null ? new Base[]{} : this.informationLinkId.toArray(new Base[this.informationLinkId.size()]);
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case 1984153269: {
                    Base[] baseArray;
                    if (this.service == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.service;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case 1379209295: {
                    Base[] baseArray;
                    if (this.serviced == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.serviced;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.location;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -1868566105: {
                    return this.subSite == null ? new Base[]{} : this.subSite.toArray(new Base[this.subSite.size()]);
                }
                case 1524132147: {
                    return this.encounter == null ? new Base[]{} : this.encounter.toArray(new Base[this.encounter.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case -186757789: {
                    this.getCareTeamLinkId().add(this.castToPositiveInt(value));
                    return value;
                }
                case -1659207418: {
                    this.getDiagnosisLinkId().add(this.castToPositiveInt(value));
                    return value;
                }
                case -532846744: {
                    this.getProcedureLinkId().add(this.castToPositiveInt(value));
                    return value;
                }
                case 1965585153: {
                    this.getInformationLinkId().add(this.castToPositiveInt(value));
                    return value;
                }
                case 1099842588: {
                    this.revenue = this.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 1984153269: {
                    this.service = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1379209295: {
                    this.serviced = this.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToType(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
                case 1702620169: {
                    this.bodySite = this.castToCodeableConcept(value);
                    return value;
                }
                case -1868566105: {
                    this.getSubSite().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1524132147: {
                    this.getEncounter().add(this.castToReference(value));
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((DetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("careTeamLinkId")) {
                this.getCareTeamLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("diagnosisLinkId")) {
                this.getDiagnosisLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("procedureLinkId")) {
                this.getProcedureLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("informationLinkId")) {
                this.getInformationLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("revenue")) {
                this.revenue = this.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("service")) {
                this.service = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("serviced[x]")) {
                this.serviced = this.castToType(value);
            } else if (name.equals("location[x]")) {
                this.location = this.castToType(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCodeableConcept(value);
            } else if (name.equals("subSite")) {
                this.getSubSite().add(this.castToCodeableConcept(value));
            } else if (name.equals(Claim.SP_ENCOUNTER)) {
                this.getEncounter().add(this.castToReference(value));
            } else if (name.equals("detail")) {
                this.getDetail().add((DetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -186757789: {
                    return this.addCareTeamLinkIdElement();
                }
                case -1659207418: {
                    return this.addDiagnosisLinkIdElement();
                }
                case -532846744: {
                    return this.addProcedureLinkIdElement();
                }
                case 1965585153: {
                    return this.addInformationLinkIdElement();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 1984153269: {
                    return this.getService();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1927922223: {
                    return this.getServiced();
                }
                case 1379209295: {
                    return this.getServiced();
                }
                case 552316075: {
                    return this.getLocation();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -1868566105: {
                    return this.addSubSite();
                }
                case 1524132147: {
                    return this.addEncounter();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case -186757789: {
                    return new String[]{"positiveInt"};
                }
                case -1659207418: {
                    return new String[]{"positiveInt"};
                }
                case -532846744: {
                    return new String[]{"positiveInt"};
                }
                case 1965585153: {
                    return new String[]{"positiveInt"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1984153269: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case 1379209295: {
                    return new String[]{"date", "Period"};
                }
                case 1901043637: {
                    return new String[]{"CodeableConcept", "Address", "Reference"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
                case 1702620169: {
                    return new String[]{"CodeableConcept"};
                }
                case -1868566105: {
                    return new String[]{"CodeableConcept"};
                }
                case 1524132147: {
                    return new String[]{"Reference"};
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.sequence");
            }
            if (name.equals("careTeamLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.careTeamLinkId");
            }
            if (name.equals("diagnosisLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.diagnosisLinkId");
            }
            if (name.equals("procedureLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.procedureLinkId");
            }
            if (name.equals("informationLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.informationLinkId");
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("service")) {
                this.service = new CodeableConcept();
                return this.service;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("servicedDate")) {
                this.serviced = new DateType();
                return this.serviced;
            }
            if (name.equals("servicedPeriod")) {
                this.serviced = new Period();
                return this.serviced;
            }
            if (name.equals("locationCodeableConcept")) {
                this.location = new CodeableConcept();
                return this.location;
            }
            if (name.equals("locationAddress")) {
                this.location = new Address();
                return this.location;
            }
            if (name.equals("locationReference")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("bodySite")) {
                this.bodySite = new CodeableConcept();
                return this.bodySite;
            }
            if (name.equals("subSite")) {
                return this.addSubSite();
            }
            if (name.equals(Claim.SP_ENCOUNTER)) {
                return this.addEncounter();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemComponent copy() {
            ItemComponent dst = new ItemComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequence = this.sequence == null ? null : this.sequence.copy();
            if (this.careTeamLinkId != null) {
                dst.careTeamLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.careTeamLinkId) {
                    dst.careTeamLinkId.add(positiveIntType2.copy());
                }
            }
            if (this.diagnosisLinkId != null) {
                dst.diagnosisLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType3 : this.diagnosisLinkId) {
                    dst.diagnosisLinkId.add(positiveIntType3.copy());
                }
            }
            if (this.procedureLinkId != null) {
                dst.procedureLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType4 : this.procedureLinkId) {
                    dst.procedureLinkId.add(positiveIntType4.copy());
                }
            }
            if (this.informationLinkId != null) {
                dst.informationLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType5 : this.informationLinkId) {
                    dst.informationLinkId.add(positiveIntType5.copy());
                }
            }
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.service = this.service == null ? null : this.service.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.serviced = this.serviced == null ? null : this.serviced.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept4 = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            if (this.subSite != null) {
                dst.subSite = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept5 : this.subSite) {
                    dst.subSite.add(codeableConcept5.copy());
                }
            }
            if (this.encounter != null) {
                dst.encounter = new ArrayList<Reference>();
                for (Reference reference : this.encounter) {
                    dst.encounter.add(reference.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<DetailComponent>();
                for (DetailComponent detailComponent : this.detail) {
                    dst.detail.add(detailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareDeep(this.sequence, o.sequence, true) && ItemComponent.compareDeep(this.careTeamLinkId, o.careTeamLinkId, true) && ItemComponent.compareDeep(this.diagnosisLinkId, o.diagnosisLinkId, true) && ItemComponent.compareDeep(this.procedureLinkId, o.procedureLinkId, true) && ItemComponent.compareDeep(this.informationLinkId, o.informationLinkId, true) && ItemComponent.compareDeep(this.revenue, o.revenue, true) && ItemComponent.compareDeep(this.category, o.category, true) && ItemComponent.compareDeep(this.service, o.service, true) && ItemComponent.compareDeep(this.modifier, o.modifier, true) && ItemComponent.compareDeep(this.programCode, o.programCode, true) && ItemComponent.compareDeep(this.serviced, o.serviced, true) && ItemComponent.compareDeep(this.location, o.location, true) && ItemComponent.compareDeep(this.quantity, o.quantity, true) && ItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && ItemComponent.compareDeep(this.factor, o.factor, true) && ItemComponent.compareDeep(this.net, o.net, true) && ItemComponent.compareDeep(this.udi, o.udi, true) && ItemComponent.compareDeep(this.bodySite, o.bodySite, true) && ItemComponent.compareDeep(this.subSite, o.subSite, true) && ItemComponent.compareDeep(this.encounter, o.encounter, true) && ItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareValues(this.sequence, o.sequence, true) && ItemComponent.compareValues(this.careTeamLinkId, o.careTeamLinkId, true) && ItemComponent.compareValues(this.diagnosisLinkId, o.diagnosisLinkId, true) && ItemComponent.compareValues(this.procedureLinkId, o.procedureLinkId, true) && ItemComponent.compareValues(this.informationLinkId, o.informationLinkId, true) && ItemComponent.compareValues(this.factor, o.factor, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.careTeamLinkId, this.diagnosisLinkId, this.procedureLinkId, this.informationLinkId, this.revenue, this.category, this.service, this.modifier, this.programCode, this.serviced, this.location, this.quantity, this.unitPrice, this.factor, this.net, this.udi, this.bodySite, this.subSite, this.encounter, this.detail});
        }

        @Override
        public String fhirType() {
            return "Claim.item";
        }
    }

    @Block
    public static class AccidentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="date", type={DateType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the accident occurred\nsee information codes\nsee information codes", formalDefinition="Date of an accident which these services are addressing.")
        protected DateType date;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The nature of the accident", formalDefinition="Type of accident: work, auto, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActIncidentCode")
        protected CodeableConcept type;
        @Child(name="location", type={Address.class, Location.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Accident Place", formalDefinition="Accident Place.")
        protected Type location;
        private static final long serialVersionUID = 622904984L;

        public AccidentComponent() {
        }

        public AccidentComponent(DateType date) {
            this.date = date;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccidentComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public AccidentComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public AccidentComponent setDate(Date value) {
            if (this.date == null) {
                this.date = new DateType();
            }
            this.date.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccidentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AccidentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getLocation() {
            return this.location;
        }

        public Address getLocationAddress() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Address)this.location;
        }

        public boolean hasLocationAddress() {
            return this != null && this.location instanceof Address;
        }

        public Reference getLocationReference() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Reference)this.location;
        }

        public boolean hasLocationReference() {
            return this != null && this.location instanceof Reference;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public AccidentComponent setLocation(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof Address) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Claim.accident.location[x]: " + value.fhirType());
            }
            this.location = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("date", "date", "Date of an accident which these services are addressing.", 0, 1, this.date));
            children.add(new Property("type", "CodeableConcept", "Type of accident: work, auto, etc.", 0, 1, this.type));
            children.add(new Property("location[x]", "Address|Reference(Location)", "Accident Place.", 0, 1, this.location));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3076014: {
                    return new Property("date", "date", "Date of an accident which these services are addressing.", 0, 1, this.date);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of accident: work, auto, etc.", 0, 1, this.type);
                }
                case 552316075: {
                    return new Property("location[x]", "Address|Reference(Location)", "Accident Place.", 0, 1, this.location);
                }
                case 1901043637: {
                    return new Property("location[x]", "Address|Reference(Location)", "Accident Place.", 0, 1, this.location);
                }
                case -1280020865: {
                    return new Property("location[x]", "Address|Reference(Location)", "Accident Place.", 0, 1, this.location);
                }
                case 755866390: {
                    return new Property("location[x]", "Address|Reference(Location)", "Accident Place.", 0, 1, this.location);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.date;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.location;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    this.date = this.castToDate(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("location[x]")) {
                this.location = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return this.getDateElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case 552316075: {
                    return this.getLocation();
                }
                case 1901043637: {
                    return this.getLocation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return new String[]{"date"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1901043637: {
                    return new String[]{"Address", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.date");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("locationAddress")) {
                this.location = new Address();
                return this.location;
            }
            if (name.equals("locationReference")) {
                this.location = new Reference();
                return this.location;
            }
            return super.addChild(name);
        }

        @Override
        public AccidentComponent copy() {
            AccidentComponent dst = new AccidentComponent();
            this.copyValues(dst);
            dst.date = this.date == null ? null : this.date.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.location = this.location == null ? null : this.location.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AccidentComponent)) {
                return false;
            }
            AccidentComponent o = (AccidentComponent)other_;
            return AccidentComponent.compareDeep(this.date, o.date, true) && AccidentComponent.compareDeep(this.type, o.type, true) && AccidentComponent.compareDeep(this.location, o.location, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AccidentComponent)) {
                return false;
            }
            AccidentComponent o = (AccidentComponent)other_;
            return AccidentComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.date, this.type, this.location});
        }

        @Override
        public String fhirType() {
            return "Claim.accident";
        }
    }

    @Block
    public static class InsuranceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance identifier", formalDefinition="Sequence of coverage which serves to provide a link and convey coordination of benefit order.")
        protected PositiveIntType sequence;
        @Child(name="focal", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is the focal Coverage", formalDefinition="A flag to indicate that this Coverage is the focus for adjudication. The Coverage against which the claim is to be adjudicated.")
        protected BooleanType focal;
        @Child(name="coverage", type={Coverage.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
        protected Reference coverage;
        protected Coverage coverageTarget;
        @Child(name="businessArrangement", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business agreement", formalDefinition="The contract number of a business agreement which describes the terms and conditions.")
        protected StringType businessArrangement;
        @Child(name="preAuthRef", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pre-Authorization/Determination Reference", formalDefinition="A list of references from the Insurer to which these services pertain.")
        protected List<StringType> preAuthRef;
        @Child(name="claimResponse", type={ClaimResponse.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication results", formalDefinition="The Coverages adjudication details.")
        protected Reference claimResponse;
        protected ClaimResponse claimResponseTarget;
        private static final long serialVersionUID = -1216535489L;

        public InsuranceComponent() {
        }

        public InsuranceComponent(PositiveIntType sequence, BooleanType focal, Reference coverage) {
            this.sequence = sequence;
            this.focal = focal;
            this.coverage = coverage;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public InsuranceComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public InsuranceComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public BooleanType getFocalElement() {
            if (this.focal == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.focal");
                }
                if (Configuration.doAutoCreate()) {
                    this.focal = new BooleanType();
                }
            }
            return this.focal;
        }

        public boolean hasFocalElement() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public boolean hasFocal() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public InsuranceComponent setFocalElement(BooleanType value) {
            this.focal = value;
            return this;
        }

        public boolean getFocal() {
            return this.focal == null || this.focal.isEmpty() ? false : (Boolean)this.focal.getValue();
        }

        public InsuranceComponent setFocal(boolean value) {
            if (this.focal == null) {
                this.focal = new BooleanType();
            }
            this.focal.setValue((Object)value);
            return this;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public InsuranceComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public Coverage getCoverageTarget() {
            if (this.coverageTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageTarget = new Coverage();
                }
            }
            return this.coverageTarget;
        }

        public InsuranceComponent setCoverageTarget(Coverage value) {
            this.coverageTarget = value;
            return this;
        }

        public StringType getBusinessArrangementElement() {
            if (this.businessArrangement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.businessArrangement");
                }
                if (Configuration.doAutoCreate()) {
                    this.businessArrangement = new StringType();
                }
            }
            return this.businessArrangement;
        }

        public boolean hasBusinessArrangementElement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public boolean hasBusinessArrangement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public InsuranceComponent setBusinessArrangementElement(StringType value) {
            this.businessArrangement = value;
            return this;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
        }

        public InsuranceComponent setBusinessArrangement(String value) {
            if (Utilities.noString((String)value)) {
                this.businessArrangement = null;
            } else {
                if (this.businessArrangement == null) {
                    this.businessArrangement = new StringType();
                }
                this.businessArrangement.setValue(value);
            }
            return this;
        }

        public List<StringType> getPreAuthRef() {
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            return this.preAuthRef;
        }

        public InsuranceComponent setPreAuthRef(List<StringType> thePreAuthRef) {
            this.preAuthRef = thePreAuthRef;
            return this;
        }

        public boolean hasPreAuthRef() {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType item : this.preAuthRef) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPreAuthRefElement() {
            StringType t = new StringType();
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return t;
        }

        public InsuranceComponent addPreAuthRef(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return this;
        }

        public boolean hasPreAuthRef(String value) {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType v : this.preAuthRef) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public Reference getClaimResponse() {
            if (this.claimResponse == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponse = new Reference();
                }
            }
            return this.claimResponse;
        }

        public boolean hasClaimResponse() {
            return this.claimResponse != null && !this.claimResponse.isEmpty();
        }

        public InsuranceComponent setClaimResponse(Reference value) {
            this.claimResponse = value;
            return this;
        }

        public ClaimResponse getClaimResponseTarget() {
            if (this.claimResponseTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponseTarget = new ClaimResponse();
                }
            }
            return this.claimResponseTarget;
        }

        public InsuranceComponent setClaimResponseTarget(ClaimResponse value) {
            this.claimResponseTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence of coverage which serves to provide a link and convey coordination of benefit order.", 0, 1, this.sequence));
            children.add(new Property("focal", "boolean", "A flag to indicate that this Coverage is the focus for adjudication. The Coverage against which the claim is to be adjudicated.", 0, 1, this.focal));
            children.add(new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage));
            children.add(new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, 1, this.businessArrangement));
            children.add(new Property("preAuthRef", "string", "A list of references from the Insurer to which these services pertain.", 0, Integer.MAX_VALUE, this.preAuthRef));
            children.add(new Property("claimResponse", "Reference(ClaimResponse)", "The Coverages adjudication details.", 0, 1, this.claimResponse));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence of coverage which serves to provide a link and convey coordination of benefit order.", 0, 1, this.sequence);
                }
                case 97604197: {
                    return new Property("focal", "boolean", "A flag to indicate that this Coverage is the focus for adjudication. The Coverage against which the claim is to be adjudicated.", 0, 1, this.focal);
                }
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage);
                }
                case 259920682: {
                    return new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, 1, this.businessArrangement);
                }
                case 522246568: {
                    return new Property("preAuthRef", "string", "A list of references from the Insurer to which these services pertain.", 0, Integer.MAX_VALUE, this.preAuthRef);
                }
                case 689513629: {
                    return new Property("claimResponse", "Reference(ClaimResponse)", "The Coverages adjudication details.", 0, 1, this.claimResponse);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 97604197: {
                    Base[] baseArray;
                    if (this.focal == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.focal;
                    }
                    return baseArray;
                }
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.coverage;
                    }
                    return baseArray;
                }
                case 259920682: {
                    Base[] baseArray;
                    if (this.businessArrangement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.businessArrangement;
                    }
                    return baseArray;
                }
                case 522246568: {
                    return this.preAuthRef == null ? new Base[]{} : this.preAuthRef.toArray(new Base[this.preAuthRef.size()]);
                }
                case 689513629: {
                    Base[] baseArray;
                    if (this.claimResponse == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.claimResponse;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 97604197: {
                    this.focal = this.castToBoolean(value);
                    return value;
                }
                case -351767064: {
                    this.coverage = this.castToReference(value);
                    return value;
                }
                case 259920682: {
                    this.businessArrangement = this.castToString(value);
                    return value;
                }
                case 522246568: {
                    this.getPreAuthRef().add(this.castToString(value));
                    return value;
                }
                case 689513629: {
                    this.claimResponse = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("focal")) {
                this.focal = this.castToBoolean(value);
            } else if (name.equals("coverage")) {
                this.coverage = this.castToReference(value);
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = this.castToString(value);
            } else if (name.equals("preAuthRef")) {
                this.getPreAuthRef().add(this.castToString(value));
            } else if (name.equals("claimResponse")) {
                this.claimResponse = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 97604197: {
                    return this.getFocalElement();
                }
                case -351767064: {
                    return this.getCoverage();
                }
                case 259920682: {
                    return this.getBusinessArrangementElement();
                }
                case 522246568: {
                    return this.addPreAuthRefElement();
                }
                case 689513629: {
                    return this.getClaimResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 97604197: {
                    return new String[]{"boolean"};
                }
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case 259920682: {
                    return new String[]{"string"};
                }
                case 522246568: {
                    return new String[]{"string"};
                }
                case 689513629: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.sequence");
            }
            if (name.equals("focal")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.focal");
            }
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("businessArrangement")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.businessArrangement");
            }
            if (name.equals("preAuthRef")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.preAuthRef");
            }
            if (name.equals("claimResponse")) {
                this.claimResponse = new Reference();
                return this.claimResponse;
            }
            return super.addChild(name);
        }

        @Override
        public InsuranceComponent copy() {
            InsuranceComponent dst = new InsuranceComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.focal = this.focal == null ? null : this.focal.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            StringType stringType = dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
            if (this.preAuthRef != null) {
                dst.preAuthRef = new ArrayList<StringType>();
                for (StringType i : this.preAuthRef) {
                    dst.preAuthRef.add(i.copy());
                }
            }
            dst.claimResponse = this.claimResponse == null ? null : this.claimResponse.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareDeep(this.sequence, o.sequence, true) && InsuranceComponent.compareDeep(this.focal, o.focal, true) && InsuranceComponent.compareDeep(this.coverage, o.coverage, true) && InsuranceComponent.compareDeep(this.businessArrangement, o.businessArrangement, true) && InsuranceComponent.compareDeep(this.preAuthRef, o.preAuthRef, true) && InsuranceComponent.compareDeep(this.claimResponse, o.claimResponse, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareValues(this.sequence, o.sequence, true) && InsuranceComponent.compareValues(this.focal, o.focal, true) && InsuranceComponent.compareValues(this.businessArrangement, o.businessArrangement, true) && InsuranceComponent.compareValues(this.preAuthRef, o.preAuthRef, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.focal, this.coverage, this.businessArrangement, this.preAuthRef, this.claimResponse});
        }

        @Override
        public String fhirType() {
            return "Claim.insurance";
        }
    }

    @Block
    public static class ProcedureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Procedure sequence for reference", formalDefinition="Sequence of procedures which serves to order and provide a link.")
        protected PositiveIntType sequence;
        @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the procedure was performed", formalDefinition="Date and optionally time the procedure was performed .")
        protected DateTimeType date;
        @Child(name="procedure", type={CodeableConcept.class, Procedure.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Patient's list of procedures performed", formalDefinition="The procedure code.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/icd-10-procedures")
        protected Type procedure;
        private static final long serialVersionUID = 864307347L;

        public ProcedureComponent() {
        }

        public ProcedureComponent(PositiveIntType sequence, Type procedure) {
            this.sequence = sequence;
            this.procedure = procedure;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ProcedureComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ProcedureComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public ProcedureComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public ProcedureComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Type getProcedure() {
            return this.procedure;
        }

        public CodeableConcept getProcedureCodeableConcept() throws FHIRException {
            if (this.procedure == null) {
                return null;
            }
            if (!(this.procedure instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.procedure.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.procedure;
        }

        public boolean hasProcedureCodeableConcept() {
            return this != null && this.procedure instanceof CodeableConcept;
        }

        public Reference getProcedureReference() throws FHIRException {
            if (this.procedure == null) {
                return null;
            }
            if (!(this.procedure instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.procedure.getClass().getName() + " was encountered");
            }
            return (Reference)this.procedure;
        }

        public boolean hasProcedureReference() {
            return this != null && this.procedure instanceof Reference;
        }

        public boolean hasProcedure() {
            return this.procedure != null && !this.procedure.isEmpty();
        }

        public ProcedureComponent setProcedure(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Claim.procedure.procedure[x]: " + value.fhirType());
            }
            this.procedure = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence of procedures which serves to order and provide a link.", 0, 1, this.sequence));
            children.add(new Property("date", "dateTime", "Date and optionally time the procedure was performed .", 0, 1, this.date));
            children.add(new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence of procedures which serves to order and provide a link.", 0, 1, this.sequence);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "Date and optionally time the procedure was performed .", 0, 1, this.date);
                }
                case 1640074445: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure);
                }
                case -1095204141: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure);
                }
                case -1284783026: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure);
                }
                case 881809848: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.date;
                    }
                    return baseArray;
                }
                case -1095204141: {
                    Base[] baseArray;
                    if (this.procedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.procedure;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDateTime(value);
                    return value;
                }
                case -1095204141: {
                    this.procedure = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("date")) {
                this.date = this.castToDateTime(value);
            } else if (name.equals("procedure[x]")) {
                this.procedure = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case 1640074445: {
                    return this.getProcedure();
                }
                case -1095204141: {
                    return this.getProcedure();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
                case -1095204141: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.sequence");
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.date");
            }
            if (name.equals("procedureCodeableConcept")) {
                this.procedure = new CodeableConcept();
                return this.procedure;
            }
            if (name.equals("procedureReference")) {
                this.procedure = new Reference();
                return this.procedure;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedureComponent copy() {
            ProcedureComponent dst = new ProcedureComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.procedure = this.procedure == null ? null : this.procedure.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureComponent)) {
                return false;
            }
            ProcedureComponent o = (ProcedureComponent)other_;
            return ProcedureComponent.compareDeep(this.sequence, o.sequence, true) && ProcedureComponent.compareDeep(this.date, o.date, true) && ProcedureComponent.compareDeep(this.procedure, o.procedure, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureComponent)) {
                return false;
            }
            ProcedureComponent o = (ProcedureComponent)other_;
            return ProcedureComponent.compareValues(this.sequence, o.sequence, true) && ProcedureComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.date, this.procedure});
        }

        @Override
        public String fhirType() {
            return "Claim.procedure";
        }
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number to covey order of diagnosis", formalDefinition="Sequence of diagnosis which serves to provide a link.")
        protected PositiveIntType sequence;
        @Child(name="diagnosis", type={CodeableConcept.class, Condition.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Patient's diagnosis", formalDefinition="The diagnosis.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/icd-10")
        protected Type diagnosis;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Timing or nature of the diagnosis", formalDefinition="The type of the Diagnosis, for example: admitting, primary, secondary, discharge.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosistype")
        protected List<CodeableConcept> type;
        @Child(name="packageCode", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Package billing code", formalDefinition="The package billing code, for example DRG, based on the assigned grouping code system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosisrelatedgroup")
        protected CodeableConcept packageCode;
        private static final long serialVersionUID = -350960873L;

        public DiagnosisComponent() {
        }

        public DiagnosisComponent(PositiveIntType sequence, Type diagnosis) {
            this.sequence = sequence;
            this.diagnosis = diagnosis;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DiagnosisComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DiagnosisComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Type getDiagnosis() {
            return this.diagnosis;
        }

        public CodeableConcept getDiagnosisCodeableConcept() throws FHIRException {
            if (this.diagnosis == null) {
                return null;
            }
            if (!(this.diagnosis instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.diagnosis.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.diagnosis;
        }

        public boolean hasDiagnosisCodeableConcept() {
            return this != null && this.diagnosis instanceof CodeableConcept;
        }

        public Reference getDiagnosisReference() throws FHIRException {
            if (this.diagnosis == null) {
                return null;
            }
            if (!(this.diagnosis instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.diagnosis.getClass().getName() + " was encountered");
            }
            return (Reference)this.diagnosis;
        }

        public boolean hasDiagnosisReference() {
            return this != null && this.diagnosis instanceof Reference;
        }

        public boolean hasDiagnosis() {
            return this.diagnosis != null && !this.diagnosis.isEmpty();
        }

        public DiagnosisComponent setDiagnosis(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Claim.diagnosis.diagnosis[x]: " + value.fhirType());
            }
            this.diagnosis = value;
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public DiagnosisComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public DiagnosisComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public CodeableConcept getPackageCode() {
            if (this.packageCode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.packageCode");
                }
                if (Configuration.doAutoCreate()) {
                    this.packageCode = new CodeableConcept();
                }
            }
            return this.packageCode;
        }

        public boolean hasPackageCode() {
            return this.packageCode != null && !this.packageCode.isEmpty();
        }

        public DiagnosisComponent setPackageCode(CodeableConcept value) {
            this.packageCode = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence of diagnosis which serves to provide a link.", 0, 1, this.sequence));
            children.add(new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis));
            children.add(new Property("type", "CodeableConcept", "The type of the Diagnosis, for example: admitting, primary, secondary, discharge.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("packageCode", "CodeableConcept", "The package billing code, for example DRG, based on the assigned grouping code system.", 0, 1, this.packageCode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence of diagnosis which serves to provide a link.", 0, 1, this.sequence);
                }
                case -1487009809: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis);
                }
                case 1196993265: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis);
                }
                case 277781616: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis);
                }
                case 2050454362: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of the Diagnosis, for example: admitting, primary, secondary, discharge.", 0, Integer.MAX_VALUE, this.type);
                }
                case 908444499: {
                    return new Property("packageCode", "CodeableConcept", "The package billing code, for example DRG, based on the assigned grouping code system.", 0, 1, this.packageCode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1196993265: {
                    Base[] baseArray;
                    if (this.diagnosis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.diagnosis;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case 908444499: {
                    Base[] baseArray;
                    if (this.packageCode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.packageCode;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1196993265: {
                    this.diagnosis = this.castToType(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 908444499: {
                    this.packageCode = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("diagnosis[x]")) {
                this.diagnosis = this.castToType(value);
            } else if (name.equals("type")) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("packageCode")) {
                this.packageCode = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -1487009809: {
                    return this.getDiagnosis();
                }
                case 1196993265: {
                    return this.getDiagnosis();
                }
                case 3575610: {
                    return this.addType();
                }
                case 908444499: {
                    return this.getPackageCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1196993265: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 908444499: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.sequence");
            }
            if (name.equals("diagnosisCodeableConcept")) {
                this.diagnosis = new CodeableConcept();
                return this.diagnosis;
            }
            if (name.equals("diagnosisReference")) {
                this.diagnosis = new Reference();
                return this.diagnosis;
            }
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("packageCode")) {
                this.packageCode = new CodeableConcept();
                return this.packageCode;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            Type type = dst.diagnosis = this.diagnosis == null ? null : this.diagnosis.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.packageCode = this.packageCode == null ? null : this.packageCode.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareDeep(this.sequence, o.sequence, true) && DiagnosisComponent.compareDeep(this.diagnosis, o.diagnosis, true) && DiagnosisComponent.compareDeep(this.type, o.type, true) && DiagnosisComponent.compareDeep(this.packageCode, o.packageCode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.diagnosis, this.type, this.packageCode});
        }

        @Override
        public String fhirType() {
            return "Claim.diagnosis";
        }
    }

    @Block
    public static class SpecialConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Information instance identifier", formalDefinition="Sequence of the information element which serves to provide a link.")
        protected PositiveIntType sequence;
        @Child(name="category", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="General class of information", formalDefinition="The general class of the information supplied: information; exception; accident, employment; onset, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-informationcategory")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of information", formalDefinition="System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient  for which care is sought which may influence the adjudication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-exception")
        protected CodeableConcept code;
        @Child(name="timing", type={DateType.class, Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When it occurred", formalDefinition="The date when or period to which this information refers.")
        protected Type timing;
        @Child(name="value", type={StringType.class, Quantity.class, Attachment.class, Reference.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional Data or supporting information", formalDefinition="Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.")
        protected Type value;
        @Child(name="reason", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason associated with the information", formalDefinition="For example, provides the reason for: the additional stay, or missing tooth or any other situation where a reason code is required in addition to the content.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/missing-tooth-reason")
        protected CodeableConcept reason;
        private static final long serialVersionUID = -518630232L;

        public SpecialConditionComponent() {
        }

        public SpecialConditionComponent(PositiveIntType sequence, CodeableConcept category) {
            this.sequence = sequence;
            this.category = category;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecialConditionComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SpecialConditionComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public SpecialConditionComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecialConditionComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SpecialConditionComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecialConditionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SpecialConditionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Type getTiming() {
            return this.timing;
        }

        public DateType getTimingDateType() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (DateType)this.timing;
        }

        public boolean hasTimingDateType() {
            return this != null && this.timing instanceof DateType;
        }

        public Period getTimingPeriod() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Period)this.timing;
        }

        public boolean hasTimingPeriod() {
            return this != null && this.timing instanceof Period;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public SpecialConditionComponent setTiming(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new FHIRFormatError("Not the right type for Claim.information.timing[x]: " + value.fhirType());
            }
            this.timing = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SpecialConditionComponent setValue(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof StringType || value instanceof Quantity || value instanceof Attachment || value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Claim.information.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecialConditionComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public SpecialConditionComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence of the information element which serves to provide a link.", 0, 1, this.sequence));
            children.add(new Property("category", "CodeableConcept", "The general class of the information supplied: information; exception; accident, employment; onset, etc.", 0, 1, this.category));
            children.add(new Property("code", "CodeableConcept", "System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient  for which care is sought which may influence the adjudication.", 0, 1, this.code));
            children.add(new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing));
            children.add(new Property("value[x]", "string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value));
            children.add(new Property("reason", "CodeableConcept", "For example, provides the reason for: the additional stay, or missing tooth or any other situation where a reason code is required in addition to the content.", 0, 1, this.reason));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence of the information element which serves to provide a link.", 0, 1, this.sequence);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "The general class of the information supplied: information; exception; accident, employment; onset, etc.", 0, 1, this.category);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient  for which care is sought which may influence the adjudication.", 0, 1, this.code);
                }
                case 164632566: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case -873664438: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case 807935768: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case -615615829: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case -1410166417: {
                    return new Property("value[x]", "string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "For example, provides the reason for: the additional stay, or missing tooth or any other situation where a reason code is required in addition to the content.", 0, 1, this.reason);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.code;
                    }
                    return baseArray;
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.timing;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.value;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.reason;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -873664438: {
                    this.timing = this.castToType(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
                case -934964668: {
                    this.reason = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("timing[x]")) {
                this.timing = this.castToType(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 164632566: {
                    return this.getTiming();
                }
                case -873664438: {
                    return this.getTiming();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -934964668: {
                    return this.getReason();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -873664438: {
                    return new String[]{"date", "Period"};
                }
                case 111972721: {
                    return new String[]{"string", "Quantity", "Attachment", "Reference"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.sequence");
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("timingDate")) {
                this.timing = new DateType();
                return this.timing;
            }
            if (name.equals("timingPeriod")) {
                this.timing = new Period();
                return this.timing;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            return super.addChild(name);
        }

        @Override
        public SpecialConditionComponent copy() {
            SpecialConditionComponent dst = new SpecialConditionComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.timing = this.timing == null ? null : this.timing.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecialConditionComponent)) {
                return false;
            }
            SpecialConditionComponent o = (SpecialConditionComponent)other_;
            return SpecialConditionComponent.compareDeep(this.sequence, o.sequence, true) && SpecialConditionComponent.compareDeep(this.category, o.category, true) && SpecialConditionComponent.compareDeep(this.code, o.code, true) && SpecialConditionComponent.compareDeep(this.timing, o.timing, true) && SpecialConditionComponent.compareDeep(this.value, o.value, true) && SpecialConditionComponent.compareDeep(this.reason, o.reason, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecialConditionComponent)) {
                return false;
            }
            SpecialConditionComponent o = (SpecialConditionComponent)other_;
            return SpecialConditionComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.category, this.code, this.timing, this.value, this.reason});
        }

        @Override
        public String fhirType() {
            return "Claim.information";
        }
    }

    @Block
    public static class CareTeamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number to covey order of careTeam", formalDefinition="Sequence of the careTeam which serves to order and provide a link.")
        protected PositiveIntType sequence;
        @Child(name="provider", type={Practitioner.class, Organization.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Provider individual or organization", formalDefinition="Member of the team who provided the overall service.")
        protected Reference provider;
        protected Resource providerTarget;
        @Child(name="responsible", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing provider", formalDefinition="The party who is billing and responsible for the claimed good or service rendered to the patient.")
        protected BooleanType responsible;
        @Child(name="role", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Role on the team", formalDefinition="The lead, assisting or supervising practitioner and their discipline if a multidisiplinary team.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-careteamrole")
        protected CodeableConcept role;
        @Child(name="qualification", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type, classification or Specialization", formalDefinition="The qualification which is applicable for this service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/provider-qualification")
        protected CodeableConcept qualification;
        private static final long serialVersionUID = 1758966968L;

        public CareTeamComponent() {
        }

        public CareTeamComponent(PositiveIntType sequence, Reference provider) {
            this.sequence = sequence;
            this.provider = provider;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public CareTeamComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public CareTeamComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Reference getProvider() {
            if (this.provider == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.provider");
                }
                if (Configuration.doAutoCreate()) {
                    this.provider = new Reference();
                }
            }
            return this.provider;
        }

        public boolean hasProvider() {
            return this.provider != null && !this.provider.isEmpty();
        }

        public CareTeamComponent setProvider(Reference value) {
            this.provider = value;
            return this;
        }

        public Resource getProviderTarget() {
            return this.providerTarget;
        }

        public CareTeamComponent setProviderTarget(Resource value) {
            this.providerTarget = value;
            return this;
        }

        public BooleanType getResponsibleElement() {
            if (this.responsible == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.responsible");
                }
                if (Configuration.doAutoCreate()) {
                    this.responsible = new BooleanType();
                }
            }
            return this.responsible;
        }

        public boolean hasResponsibleElement() {
            return this.responsible != null && !this.responsible.isEmpty();
        }

        public boolean hasResponsible() {
            return this.responsible != null && !this.responsible.isEmpty();
        }

        public CareTeamComponent setResponsibleElement(BooleanType value) {
            this.responsible = value;
            return this;
        }

        public boolean getResponsible() {
            return this.responsible == null || this.responsible.isEmpty() ? false : (Boolean)this.responsible.getValue();
        }

        public CareTeamComponent setResponsible(boolean value) {
            if (this.responsible == null) {
                this.responsible = new BooleanType();
            }
            this.responsible.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CareTeamComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public CodeableConcept getQualification() {
            if (this.qualification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.qualification");
                }
                if (Configuration.doAutoCreate()) {
                    this.qualification = new CodeableConcept();
                }
            }
            return this.qualification;
        }

        public boolean hasQualification() {
            return this.qualification != null && !this.qualification.isEmpty();
        }

        public CareTeamComponent setQualification(CodeableConcept value) {
            this.qualification = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence of the careTeam which serves to order and provide a link.", 0, 1, this.sequence));
            children.add(new Property(Claim.SP_PROVIDER, "Reference(Practitioner|Organization)", "Member of the team who provided the overall service.", 0, 1, this.provider));
            children.add(new Property("responsible", "boolean", "The party who is billing and responsible for the claimed good or service rendered to the patient.", 0, 1, this.responsible));
            children.add(new Property("role", "CodeableConcept", "The lead, assisting or supervising practitioner and their discipline if a multidisiplinary team.", 0, 1, this.role));
            children.add(new Property("qualification", "CodeableConcept", "The qualification which is applicable for this service.", 0, 1, this.qualification));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence of the careTeam which serves to order and provide a link.", 0, 1, this.sequence);
                }
                case -987494927: {
                    return new Property(Claim.SP_PROVIDER, "Reference(Practitioner|Organization)", "Member of the team who provided the overall service.", 0, 1, this.provider);
                }
                case 1847674614: {
                    return new Property("responsible", "boolean", "The party who is billing and responsible for the claimed good or service rendered to the patient.", 0, 1, this.responsible);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The lead, assisting or supervising practitioner and their discipline if a multidisiplinary team.", 0, 1, this.role);
                }
                case -631333393: {
                    return new Property("qualification", "CodeableConcept", "The qualification which is applicable for this service.", 0, 1, this.qualification);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case -987494927: {
                    Base[] baseArray;
                    if (this.provider == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.provider;
                    }
                    return baseArray;
                }
                case 1847674614: {
                    Base[] baseArray;
                    if (this.responsible == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.responsible;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.role;
                    }
                    return baseArray;
                }
                case -631333393: {
                    Base[] baseArray;
                    if (this.qualification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.qualification;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case -987494927: {
                    this.provider = this.castToReference(value);
                    return value;
                }
                case 1847674614: {
                    this.responsible = this.castToBoolean(value);
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case -631333393: {
                    this.qualification = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals(Claim.SP_PROVIDER)) {
                this.provider = this.castToReference(value);
            } else if (name.equals("responsible")) {
                this.responsible = this.castToBoolean(value);
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("qualification")) {
                this.qualification = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -987494927: {
                    return this.getProvider();
                }
                case 1847674614: {
                    return this.getResponsibleElement();
                }
                case 3506294: {
                    return this.getRole();
                }
                case -631333393: {
                    return this.getQualification();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case -987494927: {
                    return new String[]{"Reference"};
                }
                case 1847674614: {
                    return new String[]{"boolean"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -631333393: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.sequence");
            }
            if (name.equals(Claim.SP_PROVIDER)) {
                this.provider = new Reference();
                return this.provider;
            }
            if (name.equals("responsible")) {
                throw new FHIRException("Cannot call addChild on a primitive type Claim.responsible");
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("qualification")) {
                this.qualification = new CodeableConcept();
                return this.qualification;
            }
            return super.addChild(name);
        }

        @Override
        public CareTeamComponent copy() {
            CareTeamComponent dst = new CareTeamComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.provider = this.provider == null ? null : this.provider.copy();
            dst.responsible = this.responsible == null ? null : this.responsible.copy();
            dst.role = this.role == null ? null : this.role.copy();
            dst.qualification = this.qualification == null ? null : this.qualification.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CareTeamComponent)) {
                return false;
            }
            CareTeamComponent o = (CareTeamComponent)other_;
            return CareTeamComponent.compareDeep(this.sequence, o.sequence, true) && CareTeamComponent.compareDeep(this.provider, o.provider, true) && CareTeamComponent.compareDeep(this.responsible, o.responsible, true) && CareTeamComponent.compareDeep(this.role, o.role, true) && CareTeamComponent.compareDeep(this.qualification, o.qualification, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CareTeamComponent)) {
                return false;
            }
            CareTeamComponent o = (CareTeamComponent)other_;
            return CareTeamComponent.compareValues(this.sequence, o.sequence, true) && CareTeamComponent.compareValues(this.responsible, o.responsible, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.provider, this.responsible, this.role, this.qualification});
        }

        @Override
        public String fhirType() {
            return "Claim.careTeam";
        }
    }

    @Block
    public static class PayeeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of party: Subscriber, Provider, other", formalDefinition="Type of Party to be reimbursed: Subscriber, provider, other.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/payeetype")
        protected CodeableConcept type;
        @Child(name="resourceType", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="organization | patient | practitioner | relatedperson", formalDefinition="organization | patient | practitioner | relatedperson.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-payee-resource-type")
        protected Coding resourceType;
        @Child(name="party", type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Party to receive the payable", formalDefinition="Party to be reimbursed: Subscriber, provider, other.")
        protected Reference party;
        protected Resource partyTarget;
        private static final long serialVersionUID = -1395150769L;

        public PayeeComponent() {
        }

        public PayeeComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PayeeComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Coding getResourceType() {
            if (this.resourceType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.resourceType");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceType = new Coding();
                }
            }
            return this.resourceType;
        }

        public boolean hasResourceType() {
            return this.resourceType != null && !this.resourceType.isEmpty();
        }

        public PayeeComponent setResourceType(Coding value) {
            this.resourceType = value;
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public PayeeComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public Resource getPartyTarget() {
            return this.partyTarget;
        }

        public PayeeComponent setPartyTarget(Resource value) {
            this.partyTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Type of Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.type));
            children.add(new Property("resourceType", "Coding", "organization | patient | practitioner | relatedperson.", 0, 1, this.resourceType));
            children.add(new Property("party", "Reference(Practitioner|Organization|Patient|RelatedPerson)", "Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.party));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.type);
                }
                case -384364440: {
                    return new Property("resourceType", "Coding", "organization | patient | practitioner | relatedperson.", 0, 1, this.resourceType);
                }
                case 106437350: {
                    return new Property("party", "Reference(Practitioner|Organization|Patient|RelatedPerson)", "Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.party);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -384364440: {
                    Base[] baseArray;
                    if (this.resourceType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resourceType;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.party;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -384364440: {
                    this.resourceType = this.castToCoding(value);
                    return value;
                }
                case 106437350: {
                    this.party = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("resourceType")) {
                this.resourceType = this.castToCoding(value);
            } else if (name.equals("party")) {
                this.party = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -384364440: {
                    return this.getResourceType();
                }
                case 106437350: {
                    return this.getParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -384364440: {
                    return new String[]{"Coding"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("resourceType")) {
                this.resourceType = new Coding();
                return this.resourceType;
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public PayeeComponent copy() {
            PayeeComponent dst = new PayeeComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.resourceType = this.resourceType == null ? null : this.resourceType.copy();
            dst.party = this.party == null ? null : this.party.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other_;
            return PayeeComponent.compareDeep(this.type, o.type, true) && PayeeComponent.compareDeep(this.resourceType, o.resourceType, true) && PayeeComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.resourceType, this.party});
        }

        @Override
        public String fhirType() {
            return "Claim.payee";
        }
    }

    @Block
    public static class RelatedClaimComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="claim", type={Claim.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to the related claim", formalDefinition="Other claims which are related to this claim such as prior claim versions or for related services.")
        protected Reference claim;
        protected Claim claimTarget;
        @Child(name="relationship", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the reference claim is related", formalDefinition="For example prior or umbrella.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/related-claim-relationship")
        protected CodeableConcept relationship;
        @Child(name="reference", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Related file or case reference", formalDefinition="An alternate organizational reference to the case or file to which this particular claim pertains - eg Property/Casualy insurer claim # or Workers Compensation case # .")
        protected Identifier reference;
        private static final long serialVersionUID = -379338905L;

        public Reference getClaim() {
            if (this.claim == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.claim");
                }
                if (Configuration.doAutoCreate()) {
                    this.claim = new Reference();
                }
            }
            return this.claim;
        }

        public boolean hasClaim() {
            return this.claim != null && !this.claim.isEmpty();
        }

        public RelatedClaimComponent setClaim(Reference value) {
            this.claim = value;
            return this;
        }

        public Claim getClaimTarget() {
            if (this.claimTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.claim");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimTarget = new Claim();
                }
            }
            return this.claimTarget;
        }

        public RelatedClaimComponent setClaimTarget(Claim value) {
            this.claimTarget = value;
            return this;
        }

        public CodeableConcept getRelationship() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new CodeableConcept();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public RelatedClaimComponent setRelationship(CodeableConcept value) {
            this.relationship = value;
            return this;
        }

        public Identifier getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Identifier();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public RelatedClaimComponent setReference(Identifier value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("claim", "Reference(Claim)", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, 1, this.claim));
            children.add(new Property("relationship", "CodeableConcept", "For example prior or umbrella.", 0, 1, this.relationship));
            children.add(new Property("reference", "Identifier", "An alternate organizational reference to the case or file to which this particular claim pertains - eg Property/Casualy insurer claim # or Workers Compensation case # .", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 94742588: {
                    return new Property("claim", "Reference(Claim)", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, 1, this.claim);
                }
                case -261851592: {
                    return new Property("relationship", "CodeableConcept", "For example prior or umbrella.", 0, 1, this.relationship);
                }
                case -925155509: {
                    return new Property("reference", "Identifier", "An alternate organizational reference to the case or file to which this particular claim pertains - eg Property/Casualy insurer claim # or Workers Compensation case # .", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    Base[] baseArray;
                    if (this.claim == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.claim;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    this.claim = this.castToReference(value);
                    return value;
                }
                case -261851592: {
                    this.relationship = this.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("claim")) {
                this.claim = this.castToReference(value);
            } else if (name.equals("relationship")) {
                this.relationship = this.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = this.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    return this.getClaim();
                }
                case -261851592: {
                    return this.getRelationship();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    return new String[]{"Reference"};
                }
                case -261851592: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("claim")) {
                this.claim = new Reference();
                return this.claim;
            }
            if (name.equals("relationship")) {
                this.relationship = new CodeableConcept();
                return this.relationship;
            }
            if (name.equals("reference")) {
                this.reference = new Identifier();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public RelatedClaimComponent copy() {
            RelatedClaimComponent dst = new RelatedClaimComponent();
            this.copyValues(dst);
            dst.claim = this.claim == null ? null : this.claim.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RelatedClaimComponent)) {
                return false;
            }
            RelatedClaimComponent o = (RelatedClaimComponent)other_;
            return RelatedClaimComponent.compareDeep(this.claim, o.claim, true) && RelatedClaimComponent.compareDeep(this.relationship, o.relationship, true) && RelatedClaimComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RelatedClaimComponent)) {
                return false;
            }
            RelatedClaimComponent o = (RelatedClaimComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.claim, this.relationship, this.reference});
        }

        @Override
        public String fhirType() {
            return "Claim.related";
        }
    }

    public static class UseEnumFactory
    implements EnumFactory<Use> {
        @Override
        public Use fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return Use.COMPLETE;
            }
            if ("proposed".equals(codeString)) {
                return Use.PROPOSED;
            }
            if ("exploratory".equals(codeString)) {
                return Use.EXPLORATORY;
            }
            if ("other".equals(codeString)) {
                return Use.OTHER;
            }
            throw new IllegalArgumentException("Unknown Use code '" + codeString + "'");
        }

        public Enumeration<Use> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<Use>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<Use>(this, Use.COMPLETE);
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<Use>(this, Use.PROPOSED);
            }
            if ("exploratory".equals(codeString)) {
                return new Enumeration<Use>(this, Use.EXPLORATORY);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<Use>(this, Use.OTHER);
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        @Override
        public String toCode(Use code) {
            if (code == Use.COMPLETE) {
                return "complete";
            }
            if (code == Use.PROPOSED) {
                return "proposed";
            }
            if (code == Use.EXPLORATORY) {
                return "exploratory";
            }
            if (code == Use.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(Use code) {
            return code.getSystem();
        }
    }

    public static enum Use {
        COMPLETE,
        PROPOSED,
        EXPLORATORY,
        OTHER,
        NULL;


        public static Use fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("exploratory".equals(codeString)) {
                return EXPLORATORY;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPLETE: {
                    return "complete";
                }
                case PROPOSED: {
                    return "proposed";
                }
                case EXPLORATORY: {
                    return "exploratory";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPLETE: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case PROPOSED: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case EXPLORATORY: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPLETE: {
                    return "The treatment is complete and this represents a Claim for the services.";
                }
                case PROPOSED: {
                    return "The treatment is proposed and this represents a Pre-authorization for the services.";
                }
                case EXPLORATORY: {
                    return "The treatment is proposed and this represents a Pre-determination for the services.";
                }
                case OTHER: {
                    return "A locally defined or otherwise resolved status.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPLETE: {
                    return "Complete";
                }
                case PROPOSED: {
                    return "Proposed";
                }
                case EXPLORATORY: {
                    return "Exploratory";
                }
                case OTHER: {
                    return "Other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ClaimStatusEnumFactory
    implements EnumFactory<ClaimStatus> {
        @Override
        public ClaimStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ClaimStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return ClaimStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return ClaimStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ClaimStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ClaimStatus code '" + codeString + "'");
        }

        public Enumeration<ClaimStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ClaimStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ClaimStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ClaimStatus code) {
            if (code == ClaimStatus.ACTIVE) {
                return "active";
            }
            if (code == ClaimStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ClaimStatus.DRAFT) {
                return "draft";
            }
            if (code == ClaimStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ClaimStatus code) {
            return code.getSystem();
        }
    }

    public static enum ClaimStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static ClaimStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ClaimStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

