/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Substance", profile="http://hl7.org/fhir/Profile/Substance")
public class Substance
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier for the substance.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="A code to indicate if the substance is actively used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/substance-status")
    protected Enumeration<FHIRSubstanceStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What class/type of substance this is", formalDefinition="A code that classifies the general type of substance.  This is used  for searching, sorting and display purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/substance-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What substance this is", formalDefinition="A code (or set of codes) that identify this substance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/substance-code")
    protected CodeableConcept code;
    @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual description of the substance, comments", formalDefinition="A description of the substance - its appearance, handling requirements, and other usage notes.")
    protected StringType description;
    @Child(name="instance", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="If this describes a specific package/container of the substance", formalDefinition="Substance may be used to describe a kind of substance, or a specific package/container of the substance: an instance.")
    protected List<SubstanceInstanceComponent> instance;
    @Child(name="ingredient", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Composition information about the substance", formalDefinition="A substance can be composed of other substances.")
    protected List<SubstanceIngredientComponent> ingredient;
    private static final long serialVersionUID = -1467626602L;
    @SearchParamDefinition(name="identifier", path="Substance.identifier", description="Unique identifier for the substance", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="container-identifier", path="Substance.instance.identifier", description="Identifier of the package/container", type="token")
    public static final String SP_CONTAINER_IDENTIFIER = "container-identifier";
    public static final TokenClientParam CONTAINER_IDENTIFIER = new TokenClientParam("container-identifier");
    @SearchParamDefinition(name="code", path="Substance.code | Substance.ingredient.substance.as(CodeableConcept)", description="The code of the substance or ingredient", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="quantity", path="Substance.instance.quantity", description="Amount of substance in the package", type="quantity")
    public static final String SP_QUANTITY = "quantity";
    public static final QuantityClientParam QUANTITY = new QuantityClientParam("quantity");
    @SearchParamDefinition(name="substance-reference", path="Substance.ingredient.substance.as(Reference)", description="A component of the substance", type="reference", target={Substance.class})
    public static final String SP_SUBSTANCE_REFERENCE = "substance-reference";
    public static final ReferenceClientParam SUBSTANCE_REFERENCE = new ReferenceClientParam("substance-reference");
    public static final Include INCLUDE_SUBSTANCE_REFERENCE = new Include("Substance:substance-reference").toLocked();
    @SearchParamDefinition(name="expiry", path="Substance.instance.expiry", description="Expiry date of package or container of substance", type="date")
    public static final String SP_EXPIRY = "expiry";
    public static final DateClientParam EXPIRY = new DateClientParam("expiry");
    @SearchParamDefinition(name="category", path="Substance.category", description="The category of the substance", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="Substance.status", description="active | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Substance() {
    }

    public Substance(CodeableConcept code) {
        this.code = code;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Substance setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Substance addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<FHIRSubstanceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Substance.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FHIRSubstanceStatus>(new FHIRSubstanceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Substance setStatusElement(Enumeration<FHIRSubstanceStatus> value) {
        this.status = value;
        return this;
    }

    public FHIRSubstanceStatus getStatus() {
        return this.status == null ? null : (FHIRSubstanceStatus)((Object)this.status.getValue());
    }

    public Substance setStatus(FHIRSubstanceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<FHIRSubstanceStatus>(new FHIRSubstanceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Substance setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Substance addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Substance.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Substance setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Substance.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Substance setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Substance setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<SubstanceInstanceComponent> getInstance() {
        if (this.instance == null) {
            this.instance = new ArrayList<SubstanceInstanceComponent>();
        }
        return this.instance;
    }

    public Substance setInstance(List<SubstanceInstanceComponent> theInstance) {
        this.instance = theInstance;
        return this;
    }

    public boolean hasInstance() {
        if (this.instance == null) {
            return false;
        }
        for (SubstanceInstanceComponent item : this.instance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceInstanceComponent addInstance() {
        SubstanceInstanceComponent t = new SubstanceInstanceComponent();
        if (this.instance == null) {
            this.instance = new ArrayList<SubstanceInstanceComponent>();
        }
        this.instance.add(t);
        return t;
    }

    public Substance addInstance(SubstanceInstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.instance == null) {
            this.instance = new ArrayList<SubstanceInstanceComponent>();
        }
        this.instance.add(t);
        return this;
    }

    public SubstanceInstanceComponent getInstanceFirstRep() {
        if (this.getInstance().isEmpty()) {
            this.addInstance();
        }
        return this.getInstance().get(0);
    }

    public List<SubstanceIngredientComponent> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<SubstanceIngredientComponent>();
        }
        return this.ingredient;
    }

    public Substance setIngredient(List<SubstanceIngredientComponent> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (SubstanceIngredientComponent item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceIngredientComponent addIngredient() {
        SubstanceIngredientComponent t = new SubstanceIngredientComponent();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<SubstanceIngredientComponent>();
        }
        this.ingredient.add(t);
        return t;
    }

    public Substance addIngredient(SubstanceIngredientComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<SubstanceIngredientComponent>();
        }
        this.ingredient.add(t);
        return this;
    }

    public SubstanceIngredientComponent getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for the substance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, SP_CODE, "A code to indicate if the substance is actively used.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of substance.  This is used  for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that identify this substance.", 0, 1, this.code));
        children.add(new Property("description", "string", "A description of the substance - its appearance, handling requirements, and other usage notes.", 0, 1, this.description));
        children.add(new Property("instance", "", "Substance may be used to describe a kind of substance, or a specific package/container of the substance: an instance.", 0, Integer.MAX_VALUE, this.instance));
        children.add(new Property("ingredient", "", "A substance can be composed of other substances.", 0, Integer.MAX_VALUE, this.ingredient));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for the substance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code to indicate if the substance is actively used.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of substance.  This is used  for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that identify this substance.", 0, 1, this.code);
            }
            case -1724546052: {
                return new Property("description", "string", "A description of the substance - its appearance, handling requirements, and other usage notes.", 0, 1, this.description);
            }
            case 555127957: {
                return new Property("instance", "", "Substance may be used to describe a kind of substance, or a specific package/container of the substance: an instance.", 0, Integer.MAX_VALUE, this.instance);
            }
            case -206409263: {
                return new Property("ingredient", "", "A substance can be composed of other substances.", 0, Integer.MAX_VALUE, this.ingredient);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.description;
                }
                return baseArray;
            }
            case 555127957: {
                return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new FHIRSubstanceStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case 555127957: {
                this.getInstance().add((SubstanceInstanceComponent)((Object)value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add((SubstanceIngredientComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new FHIRSubstanceStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("instance")) {
            this.getInstance().add((SubstanceInstanceComponent)((Object)value));
        } else if (name.equals("ingredient")) {
            this.getIngredient().add((SubstanceIngredientComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 555127957: {
                return this.addInstance();
            }
            case -206409263: {
                return this.addIngredient();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 555127957: {
                return new String[0];
            }
            case -206409263: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Substance.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Substance.description");
        }
        if (name.equals("instance")) {
            return this.addInstance();
        }
        if (name.equals("ingredient")) {
            return this.addIngredient();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Substance";
    }

    @Override
    public Substance copy() {
        Substance dst = new Substance();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<FHIRSubstanceStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.instance != null) {
            dst.instance = new ArrayList<SubstanceInstanceComponent>();
            for (SubstanceInstanceComponent substanceInstanceComponent : this.instance) {
                dst.instance.add(substanceInstanceComponent.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<SubstanceIngredientComponent>();
            for (SubstanceIngredientComponent substanceIngredientComponent : this.ingredient) {
                dst.ingredient.add(substanceIngredientComponent.copy());
            }
        }
        return dst;
    }

    protected Substance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Substance)) {
            return false;
        }
        Substance o = (Substance)other_;
        return Substance.compareDeep(this.identifier, o.identifier, true) && Substance.compareDeep(this.status, o.status, true) && Substance.compareDeep(this.category, o.category, true) && Substance.compareDeep(this.code, o.code, true) && Substance.compareDeep(this.description, o.description, true) && Substance.compareDeep(this.instance, o.instance, true) && Substance.compareDeep(this.ingredient, o.ingredient, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Substance)) {
            return false;
        }
        Substance o = (Substance)other_;
        return Substance.compareValues(this.status, o.status, true) && Substance.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.category, this.code, this.description, this.instance, this.ingredient});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Substance;
    }

    @Block
    public static class SubstanceIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={Ratio.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optional amount (concentration)", formalDefinition="The amount of the ingredient in the substance - a concentration ratio.")
        protected Ratio quantity;
        @Child(name="substance", type={CodeableConcept.class, Substance.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A component of the substance", formalDefinition="Another substance that is a component of this substance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/substance-code")
        protected Type substance;
        private static final long serialVersionUID = -469805322L;

        public SubstanceIngredientComponent() {
        }

        public SubstanceIngredientComponent(Type substance) {
            this.substance = substance;
        }

        public Ratio getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceIngredientComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Ratio();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SubstanceIngredientComponent setQuantity(Ratio value) {
            this.quantity = value;
            return this;
        }

        public Type getSubstance() {
            return this.substance;
        }

        public CodeableConcept getSubstanceCodeableConcept() throws FHIRException {
            if (this.substance == null) {
                return null;
            }
            if (!(this.substance instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.substance.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.substance;
        }

        public boolean hasSubstanceCodeableConcept() {
            return this != null && this.substance instanceof CodeableConcept;
        }

        public Reference getSubstanceReference() throws FHIRException {
            if (this.substance == null) {
                return null;
            }
            if (!(this.substance instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.substance.getClass().getName() + " was encountered");
            }
            return (Reference)this.substance;
        }

        public boolean hasSubstanceReference() {
            return this != null && this.substance instanceof Reference;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public SubstanceIngredientComponent setSubstance(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Substance.ingredient.substance[x]: " + value.fhirType());
            }
            this.substance = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Substance.SP_QUANTITY, "Ratio", "The amount of the ingredient in the substance - a concentration ratio.", 0, 1, this.quantity));
            children.add(new Property("substance[x]", "CodeableConcept|Reference(Substance)", "Another substance that is a component of this substance.", 0, 1, this.substance));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1285004149: {
                    return new Property(Substance.SP_QUANTITY, "Ratio", "The amount of the ingredient in the substance - a concentration ratio.", 0, 1, this.quantity);
                }
                case 2127194384: {
                    return new Property("substance[x]", "CodeableConcept|Reference(Substance)", "Another substance that is a component of this substance.", 0, 1, this.substance);
                }
                case 530040176: {
                    return new Property("substance[x]", "CodeableConcept|Reference(Substance)", "Another substance that is a component of this substance.", 0, 1, this.substance);
                }
                case -1974119407: {
                    return new Property("substance[x]", "CodeableConcept|Reference(Substance)", "Another substance that is a component of this substance.", 0, 1, this.substance);
                }
                case 516208571: {
                    return new Property("substance[x]", "CodeableConcept|Reference(Substance)", "Another substance that is a component of this substance.", 0, 1, this.substance);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.substance;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    this.quantity = this.castToRatio(value);
                    return value;
                }
                case 530040176: {
                    this.substance = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Substance.SP_QUANTITY)) {
                this.quantity = this.castToRatio(value);
            } else if (name.equals("substance[x]")) {
                this.substance = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return this.getQuantity();
                }
                case 2127194384: {
                    return this.getSubstance();
                }
                case 530040176: {
                    return this.getSubstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return new String[]{"Ratio"};
                }
                case 530040176: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Substance.SP_QUANTITY)) {
                this.quantity = new Ratio();
                return this.quantity;
            }
            if (name.equals("substanceCodeableConcept")) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals("substanceReference")) {
                this.substance = new Reference();
                return this.substance;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceIngredientComponent copy() {
            SubstanceIngredientComponent dst = new SubstanceIngredientComponent();
            this.copyValues(dst);
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.substance = this.substance == null ? null : this.substance.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceIngredientComponent)) {
                return false;
            }
            SubstanceIngredientComponent o = (SubstanceIngredientComponent)other_;
            return SubstanceIngredientComponent.compareDeep(this.quantity, o.quantity, true) && SubstanceIngredientComponent.compareDeep(this.substance, o.substance, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceIngredientComponent)) {
                return false;
            }
            SubstanceIngredientComponent o = (SubstanceIngredientComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.quantity, this.substance});
        }

        @Override
        public String fhirType() {
            return "Substance.ingredient";
        }
    }

    @Block
    public static class SubstanceInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier of the package/container", formalDefinition="Identifier associated with the package/container (usually a label affixed directly).")
        protected Identifier identifier;
        @Child(name="expiry", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When no longer valid to use", formalDefinition="When the substance is no longer valid to use. For some substances, a single arbitrary date is used for expiry.")
        protected DateTimeType expiry;
        @Child(name="quantity", type={SimpleQuantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount of substance in the package", formalDefinition="The amount of the substance.")
        protected SimpleQuantity quantity;
        private static final long serialVersionUID = -794314734L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceInstanceComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public SubstanceInstanceComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getExpiryElement() {
            if (this.expiry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceInstanceComponent.expiry");
                }
                if (Configuration.doAutoCreate()) {
                    this.expiry = new DateTimeType();
                }
            }
            return this.expiry;
        }

        public boolean hasExpiryElement() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public boolean hasExpiry() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public SubstanceInstanceComponent setExpiryElement(DateTimeType value) {
            this.expiry = value;
            return this;
        }

        public Date getExpiry() {
            return this.expiry == null ? null : (Date)this.expiry.getValue();
        }

        public SubstanceInstanceComponent setExpiry(Date value) {
            if (value == null) {
                this.expiry = null;
            } else {
                if (this.expiry == null) {
                    this.expiry = new DateTimeType();
                }
                this.expiry.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceInstanceComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SubstanceInstanceComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Substance.SP_IDENTIFIER, "Identifier", "Identifier associated with the package/container (usually a label affixed directly).", 0, 1, this.identifier));
            children.add(new Property(Substance.SP_EXPIRY, "dateTime", "When the substance is no longer valid to use. For some substances, a single arbitrary date is used for expiry.", 0, 1, this.expiry));
            children.add(new Property(Substance.SP_QUANTITY, "SimpleQuantity", "The amount of the substance.", 0, 1, this.quantity));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Substance.SP_IDENTIFIER, "Identifier", "Identifier associated with the package/container (usually a label affixed directly).", 0, 1, this.identifier);
                }
                case -1289159373: {
                    return new Property(Substance.SP_EXPIRY, "dateTime", "When the substance is no longer valid to use. For some substances, a single arbitrary date is used for expiry.", 0, 1, this.expiry);
                }
                case -1285004149: {
                    return new Property(Substance.SP_QUANTITY, "SimpleQuantity", "The amount of the substance.", 0, 1, this.quantity);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -1289159373: {
                    Base[] baseArray;
                    if (this.expiry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expiry;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case -1289159373: {
                    this.expiry = this.castToDateTime(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Substance.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals(Substance.SP_EXPIRY)) {
                this.expiry = this.castToDateTime(value);
            } else if (name.equals(Substance.SP_QUANTITY)) {
                this.quantity = this.castToSimpleQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -1289159373: {
                    return this.getExpiryElement();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -1289159373: {
                    return new String[]{"dateTime"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Substance.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(Substance.SP_EXPIRY)) {
                throw new FHIRException("Cannot call addChild on a primitive type Substance.expiry");
            }
            if (name.equals(Substance.SP_QUANTITY)) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceInstanceComponent copy() {
            SubstanceInstanceComponent dst = new SubstanceInstanceComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.expiry = this.expiry == null ? null : this.expiry.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceInstanceComponent)) {
                return false;
            }
            SubstanceInstanceComponent o = (SubstanceInstanceComponent)other_;
            return SubstanceInstanceComponent.compareDeep(this.identifier, o.identifier, true) && SubstanceInstanceComponent.compareDeep(this.expiry, o.expiry, true) && SubstanceInstanceComponent.compareDeep(this.quantity, o.quantity, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceInstanceComponent)) {
                return false;
            }
            SubstanceInstanceComponent o = (SubstanceInstanceComponent)other_;
            return SubstanceInstanceComponent.compareValues(this.expiry, o.expiry, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identifier, this.expiry, this.quantity});
        }

        @Override
        public String fhirType() {
            return "Substance.instance";
        }
    }

    public static class FHIRSubstanceStatusEnumFactory
    implements EnumFactory<FHIRSubstanceStatus> {
        @Override
        public FHIRSubstanceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return FHIRSubstanceStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return FHIRSubstanceStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return FHIRSubstanceStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown FHIRSubstanceStatus code '" + codeString + "'");
        }

        public Enumeration<FHIRSubstanceStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FHIRSubstanceStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<FHIRSubstanceStatus>(this, FHIRSubstanceStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<FHIRSubstanceStatus>(this, FHIRSubstanceStatus.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FHIRSubstanceStatus>(this, FHIRSubstanceStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown FHIRSubstanceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(FHIRSubstanceStatus code) {
            if (code == FHIRSubstanceStatus.ACTIVE) {
                return "active";
            }
            if (code == FHIRSubstanceStatus.INACTIVE) {
                return "inactive";
            }
            if (code == FHIRSubstanceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(FHIRSubstanceStatus code) {
            return code.getSystem();
        }
    }

    public static enum FHIRSubstanceStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static FHIRSubstanceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FHIRSubstanceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/substance-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/substance-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/substance-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The substance is considered for use or reference";
                }
                case INACTIVE: {
                    return "The substance is considered for reference, but not for use";
                }
                case ENTEREDINERROR: {
                    return "The substance was entered in error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

