/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DiagnosisRole {
    AD,
    DD,
    CC,
    CM,
    PREOP,
    POSTOP,
    BILLING,
    NULL;


    public static DiagnosisRole fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AD".equals(codeString)) {
            return AD;
        }
        if ("DD".equals(codeString)) {
            return DD;
        }
        if ("CC".equals(codeString)) {
            return CC;
        }
        if ("CM".equals(codeString)) {
            return CM;
        }
        if ("pre-op".equals(codeString)) {
            return PREOP;
        }
        if ("post-op".equals(codeString)) {
            return POSTOP;
        }
        if ("billing".equals(codeString)) {
            return BILLING;
        }
        throw new FHIRException("Unknown DiagnosisRole code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AD: {
                return "AD";
            }
            case DD: {
                return "DD";
            }
            case CC: {
                return "CC";
            }
            case CM: {
                return "CM";
            }
            case PREOP: {
                return "pre-op";
            }
            case POSTOP: {
                return "post-op";
            }
            case BILLING: {
                return "billing";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/diagnosis-role";
    }

    public String getDefinition() {
        switch (this) {
            case AD: {
                return "";
            }
            case DD: {
                return "";
            }
            case CC: {
                return "";
            }
            case CM: {
                return "";
            }
            case PREOP: {
                return "";
            }
            case POSTOP: {
                return "";
            }
            case BILLING: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AD: {
                return "Admission diagnosis";
            }
            case DD: {
                return "Discharge diagnosis";
            }
            case CC: {
                return "Chief complaint";
            }
            case CM: {
                return "Comorbidity diagnosis";
            }
            case PREOP: {
                return "pre-op diagnosis";
            }
            case POSTOP: {
                return "post-op diagnosis";
            }
            case BILLING: {
                return "Billing";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

