/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.elementmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu3.elementmodel.ObjectConverter;
import org.hl7.fhir.dstu3.elementmodel.Property;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class Element
extends Base {
    private List<String> comments;
    private String name;
    private String type;
    private String value;
    private int index = -1;
    private List<Element> children;
    private Property property;
    private Property elementProperty;
    private int line;
    private int col;
    private SpecialElement special;
    private XhtmlNode xhtml;

    public Element(String name) {
        this.name = name;
    }

    public Element(Element other) {
        this.name = other.name;
        this.type = other.type;
        this.property = other.property;
        this.elementProperty = other.elementProperty;
        this.special = other.special;
    }

    public Element(String name, Property property) {
        this.name = name;
        this.property = property;
    }

    public Element(String name, Property property, String type, String value) {
        this.name = name;
        this.property = property;
        this.type = type;
        this.value = value;
    }

    public void updateProperty(Property property, SpecialElement special, Property elementProperty) {
        this.property = property;
        this.elementProperty = elementProperty;
        this.special = special;
    }

    public SpecialElement getSpecial() {
        return this.special;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        if (this.type == null) {
            return this.property.getType(this.name);
        }
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<Element> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        return this.children;
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public List<String> getComments() {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        return this.comments;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public List<Element> getChildrenByName(String name) {
        ArrayList<Element> res = new ArrayList<Element>();
        if (this.hasChildren()) {
            for (Element child : this.children) {
                if (!name.equals(child.getName())) continue;
                res.add(child);
            }
        }
        return res;
    }

    public void numberChildren() {
        if (this.children == null) {
            return;
        }
        String last = "";
        int index = 0;
        for (Element child : this.children) {
            if (child.getProperty().isList()) {
                if (!last.equals(child.getName())) {
                    last = child.getName();
                    index = 0;
                }
                child.index = ++index;
            } else {
                child.index = -1;
            }
            child.numberChildren();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasIndex() {
        return this.index > -1;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getChildValue(String name) {
        if (this.children == null) {
            return null;
        }
        for (Element child : this.children) {
            if (!name.equals(child.getName())) continue;
            return child.getValue();
        }
        return null;
    }

    public void setChildValue(String name, String value) {
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        for (Element child : this.children) {
            if (!name.equals(child.getName())) continue;
            if (!child.isPrimitive()) {
                throw new Error("Cannot set a value of a non-primitive type (" + name + " on " + this.getName() + ")");
            }
            child.setValue(value);
        }
        try {
            this.setProperty(name.hashCode(), name, new StringType(value));
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    public List<Element> getChildren(String name) {
        ArrayList<Element> res = new ArrayList<Element>();
        if (this.children != null) {
            for (Element child : this.children) {
                if (!name.equals(child.getName())) continue;
                res.add(child);
            }
        }
        return res;
    }

    public boolean hasType() {
        if (this.type == null) {
            return this.property.hasType(this.name);
        }
        return true;
    }

    @Override
    public String fhirType() {
        return this.getType();
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        if (this.isPrimitive() && hash == "value".hashCode() && !Utilities.noString((String)this.value)) {
            Base[] b = new Base[]{new StringType(this.value)};
            return b;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        if (this.children != null) {
            for (Element child : this.children) {
                if (child.getName().equals(name)) {
                    result.add(child);
                }
                if (!child.getName().startsWith(name) || !child.getProperty().isChoice() || !child.getProperty().getName().equals(name + "[x]")) continue;
                result.add(child);
            }
        }
        if (!result.isEmpty() || checkValid) {
            // empty if block
        }
        return result.toArray(new Base[result.size()]);
    }

    @Override
    protected void listChildren(List<org.hl7.fhir.dstu3.model.Property> childProps) {
        if (this.children != null) {
            for (Element c : this.children) {
                childProps.add(new org.hl7.fhir.dstu3.model.Property(c.getName(), c.fhirType(), c.getProperty().getDefinition().getDefinition(), c.getProperty().getDefinition().getMin(), this.maxToInt(c.getProperty().getDefinition().getMax()), c));
            }
        }
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        Element ne;
        if (this.isPrimitive() && hash == "value".hashCode()) {
            this.value = this.castToString(value).asStringValue();
            return this;
        }
        if ("xhtml".equals(this.getType()) && hash == "value".hashCode()) {
            this.xhtml = this.castToXhtml(value);
            this.value = this.castToXhtmlString(value);
            return this;
        }
        if (!value.isPrimitive() && !(value instanceof Element)) {
            if (this.isDataType(value)) {
                value = this.convertToElement(this.property.getChild(name), value);
            } else {
                throw new FHIRException("Cannot set property " + name + " on " + this.name + " - value is not a primitive type (" + value.fhirType() + ") or an ElementModel type");
            }
        }
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        Element childForValue = null;
        for (Element child : this.children) {
            if (!child.getName().equals(name)) continue;
            if (!child.isList()) {
                childForValue = child;
                break;
            }
            ne = new Element(child);
            this.children.add(ne);
            this.numberChildren();
            childForValue = ne;
            break;
        }
        if (childForValue == null) {
            for (Property p : this.property.getChildProperties(this.name, this.type)) {
                if (!p.getName().equals(name) && !p.getName().equals(name + "[x]")) continue;
                ne = new Element(name, p);
                this.children.add(ne);
                childForValue = ne;
                break;
            }
        }
        if (childForValue == null) {
            throw new Error("Cannot set property " + name + " on " + this.name);
        }
        if (value.isPrimitive()) {
            if (childForValue.property.getName().endsWith("[x]")) {
                childForValue.name = name + Utilities.capitalize((String)value.fhirType());
            }
            childForValue.setValue(value.primitiveValue());
        } else {
            Element ve = (Element)value;
            childForValue.type = ve.getType();
            if (childForValue.property.getName().endsWith("[x]")) {
                childForValue.name = name + Utilities.capitalize((String)childForValue.type);
            } else if (value.isResource()) {
                if (childForValue.elementProperty == null) {
                    childForValue.elementProperty = childForValue.property;
                }
                childForValue.property = ve.property;
                childForValue.special = SpecialElement.BUNDLE_ENTRY;
            }
            if (ve.children != null) {
                if (childForValue.children == null) {
                    childForValue.children = new ArrayList<Element>();
                } else {
                    childForValue.children.clear();
                }
                childForValue.children.addAll(ve.children);
            }
        }
        return childForValue;
    }

    private Base convertToElement(Property prop, Base v) throws FHIRException {
        return new ObjectConverter(this.property.getContext()).convert(prop, (Type)v);
    }

    private boolean isDataType(Base v) {
        return v instanceof Type && this.property.getContext().getTypeNames().contains(v.fhirType());
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        if (this.isPrimitive() && hash == "value".hashCode()) {
            return new StringType(this.value);
        }
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        for (Element child : this.children) {
            if (!child.getName().equals(name)) continue;
            if (!child.isList()) {
                return child;
            }
            Element ne = new Element(child);
            this.children.add(ne);
            this.numberChildren();
            return ne;
        }
        for (Property p : this.property.getChildProperties(this.name, this.type)) {
            if (!p.getName().equals(name)) continue;
            Element ne = new Element(name, p);
            this.children.add(ne);
            return ne;
        }
        throw new Error("Unrecognised name " + name + " on " + this.name);
    }

    private int maxToInt(String max) {
        if (max.equals("*")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(max);
    }

    @Override
    public boolean isPrimitive() {
        return this.type != null ? this.property.isPrimitive(this.type) : this.property.isPrimitive(this.property.getType(this.name));
    }

    @Override
    public boolean isResource() {
        return this.property.isResource();
    }

    @Override
    public boolean hasPrimitiveValue() {
        return this.property.isPrimitiveName(this.name) || this.property.IsLogicalAndHasPrimitiveValue(this.name);
    }

    @Override
    public String primitiveValue() {
        if (this.isPrimitive()) {
            return this.value;
        }
        if (this.hasPrimitiveValue() && this.children != null) {
            for (Element c : this.children) {
                if (!c.getName().equals("value")) continue;
                return c.primitiveValue();
            }
        }
        return null;
    }

    public int line() {
        return this.line;
    }

    public int col() {
        return this.col;
    }

    public Element markLocation(int line, int col) {
        this.line = line;
        this.col = col;
        return this;
    }

    public void markValidation(StructureDefinition profile, ElementDefinition definition) {
    }

    public Element getNamedChild(String name) {
        if (this.children == null) {
            return null;
        }
        Element result = null;
        for (Element child : this.children) {
            if (!child.getName().equals(name)) continue;
            if (result == null) {
                result = child;
                continue;
            }
            throw new Error("Attempt to read a single element when there is more than one present (" + name + ")");
        }
        return result;
    }

    public void getNamedChildren(String name, List<Element> list) {
        if (this.children != null) {
            for (Element child : this.children) {
                if (!child.getName().equals(name)) continue;
                list.add(child);
            }
        }
    }

    public String getNamedChildValue(String name) {
        Element child = this.getNamedChild(name);
        return child == null ? null : child.value;
    }

    public void getNamedChildrenWithWildcard(String string, List<Element> values) {
        Validate.isTrue((boolean)string.endsWith("[x]"));
        String start = string.substring(0, string.length() - 3);
        if (this.children != null) {
            for (Element child : this.children) {
                if (!child.getName().startsWith(start)) continue;
                values.add(child);
            }
        }
    }

    public XhtmlNode getXhtml() {
        return this.xhtml;
    }

    public Element setXhtml(XhtmlNode xhtml) {
        this.xhtml = xhtml;
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (StringUtils.isNotBlank((CharSequence)this.value)) {
            return false;
        }
        for (Element next : this.getChildren()) {
            if (next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Property getElementProperty() {
        return this.elementProperty;
    }

    public boolean hasElementProperty() {
        return this.elementProperty != null;
    }

    public boolean hasChild(String name) {
        return this.getNamedChild(name) != null;
    }

    public String toString() {
        return this.name + "=" + this.fhirType() + "[" + (String)(this.children == null || this.hasValue() ? this.value : Integer.toString(this.children.size()) + " children") + "]";
    }

    @Override
    public String getIdBase() {
        return this.getChildValue("id");
    }

    @Override
    public void setIdBase(String value) {
        this.setChildValue("id", value);
    }

    @Override
    public boolean equalsDeep(Base other) {
        org.hl7.fhir.dstu3.model.Property o;
        String name;
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (this.isPrimitive() && other.isPrimitive()) {
            return this.primitiveValue().equals(other.primitiveValue());
        }
        if (this.isPrimitive() || other.isPrimitive()) {
            return false;
        }
        HashSet<String> processed = new HashSet<String>();
        for (org.hl7.fhir.dstu3.model.Property p : this.children()) {
            name = p.getName();
            processed.add(name);
            o = other.getChildByName(name);
            if (this.equalsDeep(p, o)) continue;
            return false;
        }
        for (org.hl7.fhir.dstu3.model.Property p : this.children()) {
            name = p.getName();
            if (processed.contains(name) || this.equalsDeep(p, o = other.getChildByName(name))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsDeep(org.hl7.fhir.dstu3.model.Property p, org.hl7.fhir.dstu3.model.Property o) {
        if (o == null || p == null) {
            return false;
        }
        if (p.getValues().size() != o.getValues().size()) {
            return false;
        }
        for (int i = 0; i < p.getValues().size(); ++i) {
            if (Base.compareDeep(p.getValues().get(i), o.getValues().get(i), true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (this.isPrimitive() && other.isPrimitive()) {
            return this.primitiveValue().equals(other.primitiveValue());
        }
        return !this.isPrimitive() && !other.isPrimitive();
    }

    public Type asType() throws FHIRException {
        return new ObjectConverter(this.property.getContext()).convertToType(this);
    }

    @Override
    public boolean isMetadataBased() {
        return true;
    }

    public boolean isList() {
        if (this.elementProperty != null) {
            return this.elementProperty.isList();
        }
        return this.property.isList();
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        Property p = this.property.getChildSimpleName(this.name, name);
        if (p != null) {
            HashSet<String> types = new HashSet<String>();
            for (ElementDefinition.TypeRefComponent tr : p.getDefinition().getType()) {
                types.add(tr.getCode());
            }
            return types.toArray(new String[0]);
        }
        return super.getTypesForProperty(hash, name);
    }

    public void sort() {
        if (this.children != null) {
            ArrayList<Element> remove = new ArrayList<Element>();
            for (Element child : this.children) {
                child.sort();
                if (!child.isEmpty()) continue;
                remove.add(child);
            }
            this.children.removeAll(remove);
            Collections.sort(this.children, new ElementSortComparator(this, this.property));
        }
    }

    public class ElementSortComparator
    implements Comparator<Element> {
        private List<ElementDefinition> children;

        public ElementSortComparator(Element e, Property property) {
            String tn = e.getType();
            StructureDefinition sd = property.getContext().fetchTypeDefinition(tn);
            this.children = sd != null && !sd.getAbstract() ? sd.getSnapshot().getElement() : property.getStructure().getSnapshot().getElement();
        }

        @Override
        public int compare(Element e0, Element e1) {
            int i1;
            int i0 = this.find(e0);
            return i0 < (i1 = this.find(e1)) ? -1 : (i0 == i1 ? 0 : 1);
        }

        private int find(Element e0) {
            int i = e0.elementProperty != null ? this.children.indexOf(e0.elementProperty.getDefinition()) : this.children.indexOf(e0.property.getDefinition());
            return i;
        }
    }

    public static enum SpecialElement {
        CONTAINED,
        BUNDLE_ENTRY,
        BUNDLE_OUTCOME,
        PARAMETER;


        public static SpecialElement fromProperty(Property property) {
            if (property.getStructure().getIdElement().getIdPart().equals("Parameters")) {
                return PARAMETER;
            }
            if (property.getStructure().getIdElement().getIdPart().equals("Bundle") && property.getName().equals("resource")) {
                return BUNDLE_ENTRY;
            }
            if (property.getStructure().getIdElement().getIdPart().equals("Bundle") && property.getName().equals("outcome")) {
                return BUNDLE_OUTCOME;
            }
            if (property.getName().equals("contained")) {
                return CONTAINED;
            }
            throw new Error("Unknown resource containing a native resource: " + property.getDefinition().getId());
        }
    }
}

