/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.elementmodel;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.elementmodel.Element;
import org.hl7.fhir.dstu3.elementmodel.ParserBase;
import org.hl7.fhir.dstu3.elementmodel.Property;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;

public class VerticalBarParser
extends ParserBase {
    private String charset = "ASCII";
    private Delimiters delimiters = new Delimiters();

    public VerticalBarParser(IWorkerContext context) {
        super(context);
    }

    @Override
    public Element parse(InputStream stream) throws IOException, FHIRFormatError, DefinitionException, FHIRException {
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/v2/StructureDefinition/Message");
        Element message = new Element("Message", new Property(this.context, sd.getSnapshot().getElementFirstRep(), sd));
        VerticalBarParserReader reader = new VerticalBarParserReader(new BufferedInputStream(stream), this.charset);
        this.preDecode(reader);
        while (!reader.isFinished()) {
            this.readSegment(message, reader);
        }
        return message;
    }

    private void preDecode(VerticalBarParserReader reader) throws FHIRException {
        reader.skipEOL();
        String temp = reader.read(3);
        this.rule(temp.equals("MSH") || temp.equals("FHS"), "Found '" + temp + "' looking for 'MSH' or 'FHS'");
        this.readDelimiters(reader);
        reader.reset();
    }

    private void rule(boolean test, String msg) throws FHIRException {
        if (!test) {
            throw new FHIRException(msg);
        }
    }

    private void readDelimiters(VerticalBarParserReader reader) throws FHIRException {
        this.delimiters.setFieldDelimiter(reader.read());
        if (reader.peek() != this.delimiters.getFieldDelimiter()) {
            this.delimiters.setComponentDelimiter(reader.read());
        }
        if (reader.peek() != this.delimiters.getFieldDelimiter()) {
            this.delimiters.setRepetitionDelimiter(reader.read());
        }
        if (reader.peek() != this.delimiters.getFieldDelimiter()) {
            this.delimiters.setEscapeCharacter(reader.read());
        }
        if (reader.peek() != this.delimiters.getFieldDelimiter()) {
            this.delimiters.setSubComponentDelimiter(reader.read());
        }
        this.delimiters.check();
    }

    private void readSegment(Element message, VerticalBarParserReader reader) throws FHIRException {
        Element segment = new Element("segment", message.getProperty().getChild("segment"));
        message.getChildren().add(segment);
        Element segmentCode = new Element("code", segment.getProperty().getChild("code"));
        segment.getChildren().add(segmentCode);
        segmentCode.setValue(reader.read(3));
        int index = 0;
        while (!reader.isFinished() && !reader.IsEOL()) {
            this.readField(reader, segment, ++index);
            if (reader.isFinished() || reader.IsEOL()) continue;
            this.rule(reader.read() == this.delimiters.getFieldDelimiter(), "Expected to find field delimiter");
        }
        if (!reader.isFinished()) {
            reader.skipEOL();
        }
    }

    private void readField(VerticalBarParserReader reader, Element segment, int index) {
    }

    @Override
    public void compose(Element e, OutputStream destination, IParser.OutputStyle style, String base) {
    }

    public class VerticalBarParserReader {
        private BufferedInputStream stream;
        private String charsetName;
        private InputStreamReader reader = null;
        private boolean finished;
        private char peeked;
        private char lastValue;
        private int offset;
        private int lineNumber;

        public VerticalBarParserReader(BufferedInputStream stream, String charsetName) throws FHIRException {
            this.setStream(stream);
            this.setCharsetName(charsetName);
            this.open();
        }

        public String getCharsetName() {
            return this.charsetName;
        }

        public void setCharsetName(String charsetName) {
            this.charsetName = charsetName;
        }

        public BufferedInputStream getStream() {
            return this.stream;
        }

        public void setStream(BufferedInputStream stream) {
            this.stream = stream;
        }

        private void open() throws FHIRException {
            try {
                this.stream.mark(2048);
                this.reader = new InputStreamReader((InputStream)this.stream, this.charsetName);
                this.offset = 0;
                this.lineNumber = 0;
                this.lastValue = (char)32;
                this.next();
            }
            catch (Exception e) {
                throw new FHIRException((Throwable)e);
            }
        }

        private void next() throws IOException, FHIRException {
            boolean bl = this.finished = !this.reader.ready();
            if (!this.finished) {
                char[] temp = new char[1];
                VerticalBarParser.this.rule(this.reader.read(temp, 0, 1) == 1, "unable to read 1 character from the stream");
                this.peeked = temp[0];
            }
        }

        public String read(int charCount) throws FHIRException {
            Object value = "";
            for (int i = 0; i < charCount; ++i) {
                value = (String)value + this.read();
            }
            return value;
        }

        public void skipEOL() throws FHIRException {
            while (!(this.finished || this.peek() != '\r' && this.peek() != '\n')) {
                this.read();
            }
        }

        public char read() throws FHIRException {
            VerticalBarParser.this.rule(!this.finished, "No more content to read");
            char value = this.peek();
            ++this.offset;
            if (!(value != '\r' && value != '\n' || this.lastValue == '\r' && value == '\n')) {
                ++this.lineNumber;
            }
            this.lastValue = value;
            try {
                this.next();
            }
            catch (Exception e) {
                throw new FHIRException((Throwable)e);
            }
            return value;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public char peek() throws FHIRException {
            VerticalBarParser.this.rule(!this.finished, "Cannot peek");
            return this.peeked;
        }

        public void mark() {
            this.stream.mark(2048);
        }

        public void reset() throws FHIRException {
            try {
                this.stream.reset();
            }
            catch (IOException e) {
                throw new FHIRException((Throwable)e);
            }
            this.open();
        }

        public boolean IsEOL() throws FHIRException {
            return this.peek() == '\r' || this.peek() == '\n';
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public class Delimiters {
        public static final char DEFAULT_DELIMITER_FIELD = '|';
        public static final char DEFAULT_DELIMITER_COMPONENT = '^';
        public static final char DEFAULT_DELIMITER_SUBCOMPONENT = '&';
        public static final char DEFAULT_DELIMITER_REPETITION = '~';
        public static final char DEFAULT_CHARACTER_ESCAPE = '\\';
        private char escapeCharacter;
        private char repetitionDelimiter;
        private char fieldDelimiter;
        private char subComponentDelimiter;
        private char componentDelimiter;

        public Delimiters() {
            this.reset();
        }

        public boolean matches(Delimiters other) {
            return this.escapeCharacter == other.escapeCharacter && this.repetitionDelimiter == other.repetitionDelimiter && this.fieldDelimiter == other.fieldDelimiter && this.subComponentDelimiter == other.subComponentDelimiter && this.componentDelimiter == other.componentDelimiter;
        }

        public char getComponentDelimiter() {
            return this.componentDelimiter;
        }

        public void setComponentDelimiter(char componentDelimiter) {
            this.componentDelimiter = componentDelimiter;
        }

        public char getEscapeCharacter() {
            return this.escapeCharacter;
        }

        public void setEscapeCharacter(char escapeCharacter) {
            this.escapeCharacter = escapeCharacter;
        }

        public char getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        public void setFieldDelimiter(char fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
        }

        public char getRepetitionDelimiter() {
            return this.repetitionDelimiter;
        }

        public void setRepetitionDelimiter(char repetitionDelimiter) {
            this.repetitionDelimiter = repetitionDelimiter;
        }

        public char getSubComponentDelimiter() {
            return this.subComponentDelimiter;
        }

        public void setSubComponentDelimiter(char subComponentDelimiter) {
            this.subComponentDelimiter = subComponentDelimiter;
        }

        public void reset() {
            this.fieldDelimiter = (char)124;
            this.componentDelimiter = (char)94;
            this.subComponentDelimiter = (char)38;
            this.repetitionDelimiter = (char)126;
            this.escapeCharacter = (char)92;
        }

        public void check() throws FHIRException {
            VerticalBarParser.this.rule(this.componentDelimiter != this.fieldDelimiter, "Delimiter Error: \"" + this.componentDelimiter + "\" is used for both CPComponent and CPField");
            VerticalBarParser.this.rule(this.subComponentDelimiter != this.fieldDelimiter, "Delimiter Error: \"" + this.subComponentDelimiter + "\" is used for both CPSubComponent and CPField");
            VerticalBarParser.this.rule(this.subComponentDelimiter != this.componentDelimiter, "Delimiter Error: \"" + this.subComponentDelimiter + "\" is used for both CPSubComponent and CPComponent");
            VerticalBarParser.this.rule(this.repetitionDelimiter != this.fieldDelimiter, "Delimiter Error: \"" + this.repetitionDelimiter + "\" is used for both Repetition and CPField");
            VerticalBarParser.this.rule(this.repetitionDelimiter != this.componentDelimiter, "Delimiter Error: \"" + this.repetitionDelimiter + "\" is used for both Repetition and CPComponent");
            VerticalBarParser.this.rule(this.repetitionDelimiter != this.subComponentDelimiter, "Delimiter Error: \"" + this.repetitionDelimiter + "\" is used for both Repetition and CPSubComponent");
            VerticalBarParser.this.rule(this.escapeCharacter != this.fieldDelimiter, "Delimiter Error: \"" + this.escapeCharacter + "\" is used for both Escape and CPField");
            VerticalBarParser.this.rule(this.escapeCharacter != this.componentDelimiter, "Delimiter Error: \"" + this.escapeCharacter + "\" is used for both Escape and CPComponent");
            VerticalBarParser.this.rule(this.escapeCharacter != this.subComponentDelimiter, "Delimiter Error: \"" + this.escapeCharacter + "\" is used for both Escape and CPSubComponent");
            VerticalBarParser.this.rule(this.escapeCharacter != this.repetitionDelimiter, "Delimiter Error: \"" + this.escapeCharacter + "\" is used for both Escape and Repetition");
        }

        public boolean isDelimiter(char ch) {
            return ch == this.escapeCharacter || ch == this.repetitionDelimiter || ch == this.fieldDelimiter || ch == this.subComponentDelimiter || ch == this.componentDelimiter;
        }

        public boolean isCellDelimiter(char ch) {
            return ch == this.repetitionDelimiter || ch == this.fieldDelimiter || ch == this.subComponentDelimiter || ch == this.componentDelimiter;
        }

        public String getEscape(char ch) {
            if (ch == this.escapeCharacter) {
                return this.escapeCharacter + "E" + this.escapeCharacter;
            }
            if (ch == this.fieldDelimiter) {
                return this.escapeCharacter + "F" + this.escapeCharacter;
            }
            if (ch == this.componentDelimiter) {
                return this.escapeCharacter + "S" + this.escapeCharacter;
            }
            if (ch == this.subComponentDelimiter) {
                return this.escapeCharacter + "T" + this.escapeCharacter;
            }
            if (ch == this.repetitionDelimiter) {
                return this.escapeCharacter + "R" + this.escapeCharacter;
            }
            return null;
        }

        public String forMSH2() {
            return "" + this.componentDelimiter + this.repetitionDelimiter + this.escapeCharacter + this.subComponentDelimiter;
        }

        public boolean isDelimiterEscape(char ch) {
            return ch == 'F' || ch == 'S' || ch == 'E' || ch == 'T' || ch == 'R';
        }

        public char getDelimiterEscapeChar(char ch) throws DefinitionException {
            if (ch == 'E') {
                return this.escapeCharacter;
            }
            if (ch == 'F') {
                return this.fieldDelimiter;
            }
            if (ch == 'S') {
                return this.componentDelimiter;
            }
            if (ch == 'T') {
                return this.subComponentDelimiter;
            }
            if (ch == 'R') {
                return this.repetitionDelimiter;
            }
            throw new DefinitionException("internal error in getDelimiterEscapeChar");
        }
    }
}

