/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DetectedIssue;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="MedicationRequest", profile="http://hl7.org/fhir/Profile/MedicationRequest")
public class MedicationRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External ids for this request", formalDefinition="This records identifiers associated with this medication request that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. For example a re-imbursement system might issue its own id for each prescription that is created.  This is particularly important where FHIR only provides part of an entire workflow process where records must be tracked through an entire system.")
    protected List<Identifier> identifier;
    @Child(name="definition", type={ActivityDefinition.class, PlanDefinition.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Protocol or definition", formalDefinition="Protocol or definition followed by this request.")
    protected List<Reference> definition;
    protected List<Resource> definitionTarget;
    @Child(name="basedOn", type={CarePlan.class, MedicationRequest.class, ProcedureRequest.class, ReferralRequest.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What request fulfills", formalDefinition="A plan or request that is fulfilled in whole or in part by this medication request.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="groupIdentifier", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composite request this is part of", formalDefinition="A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition or prescription.")
    protected Identifier groupIdentifier;
    @Child(name="status", type={CodeType.class}, order=4, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | on-hold | cancelled | completed | entered-in-error | stopped | draft | unknown", formalDefinition="A code specifying the current state of the order.  Generally this will be active or completed state.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-request-status")
    protected Enumeration<MedicationRequestStatus> status;
    @Child(name="intent", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | order | instance-order", formalDefinition="Whether the request is a proposal, plan, or an original order.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-request-intent")
    protected Enumeration<MedicationRequestIntent> intent;
    @Child(name="category", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of medication usage", formalDefinition="Indicates the type of medication order and where the medication is expected to be consumed or administered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-request-category")
    protected CodeableConcept category;
    @Child(name="priority", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | stat | asap", formalDefinition="Indicates how quickly the Medication Request should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-request-priority")
    protected Enumeration<MedicationRequestPriority> priority;
    @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Medication to be taken", formalDefinition="Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected Type medication;
    @Child(name="subject", type={Patient.class, Group.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who or group medication request is for", formalDefinition="A link to a resource representing the person or set of individuals to whom the medication will be given.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Created during encounter/admission/stay", formalDefinition="A link to an encounter, or episode of care, that identifies the particular occurrence or set occurrences of contact between patient and health care provider.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="supportingInformation", type={Reference.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information to support ordering of the medication", formalDefinition="Include additional information (for example, patient height and weight) that supports the ordering of the medication.")
    protected List<Reference> supportingInformation;
    protected List<Resource> supportingInformationTarget;
    @Child(name="authoredOn", type={DateTimeType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When request was initially authored", formalDefinition="The date (and perhaps time) when the prescription was initially written or authored on.")
    protected DateTimeType authoredOn;
    @Child(name="requester", type={}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/What requested the Request", formalDefinition="The individual, organization or device that initiated the request and has responsibility for its activation.")
    protected MedicationRequestRequesterComponent requester;
    @Child(name="recorder", type={Practitioner.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Person who entered the request", formalDefinition="The person who entered the order on behalf of another individual for example in the case of a verbal or a telephone order.")
    protected Reference recorder;
    protected Practitioner recorderTarget;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason or indication for writing the prescription", formalDefinition="The reason or the indication for ordering the medication.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Condition or Observation that supports why the prescription is being written", formalDefinition="Condition or observation that supports why the medication was ordered.")
    protected List<Reference> reasonReference;
    protected List<Resource> reasonReferenceTarget;
    @Child(name="note", type={Annotation.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the prescription", formalDefinition="Extra information about the prescription that could not be conveyed by the other attributes.")
    protected List<Annotation> note;
    @Child(name="dosageInstruction", type={Dosage.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="How the medication should be taken", formalDefinition="Indicates how the medication is to be used by the patient.")
    protected List<Dosage> dosageInstruction;
    @Child(name="dispenseRequest", type={}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Medication supply authorization", formalDefinition="Indicates the specific details for the dispense or medication supply part of a medication request (also known as a Medication Prescription or Medication Order).  Note that this information is not always sent with the order.  There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.")
    protected MedicationRequestDispenseRequestComponent dispenseRequest;
    @Child(name="substitution", type={}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Any restrictions on medication substitution", formalDefinition="Indicates whether or not substitution can or should be part of the dispense. In some cases substitution must happen, in other cases substitution must not happen. This block explains the prescriber's intent. If nothing is specified substitution may be done.")
    protected MedicationRequestSubstitutionComponent substitution;
    @Child(name="priorPrescription", type={MedicationRequest.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="An order/prescription that is being replaced", formalDefinition="A link to a resource representing an earlier order related order or prescription.")
    protected Reference priorPrescription;
    protected MedicationRequest priorPrescriptionTarget;
    @Child(name="detectedIssue", type={DetectedIssue.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical Issue with action", formalDefinition="Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, duplicate therapy, dosage alert etc.")
    protected List<Reference> detectedIssue;
    protected List<DetectedIssue> detectedIssueTarget;
    @Child(name="eventHistory", type={Provenance.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of events of interest in the lifecycle", formalDefinition="Links to Provenance records for past versions of this resource or fulfilling request or event resources that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the resource.")
    protected List<Reference> eventHistory;
    protected List<Provenance> eventHistoryTarget;
    private static final long serialVersionUID = 299392400L;
    @SearchParamDefinition(name="requester", path="MedicationRequest.requester.agent", description="Returns prescriptions prescribed by this prescriber", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("MedicationRequest:requester").toLocked();
    @SearchParamDefinition(name="date", path="MedicationRequest.dosageInstruction.timing.event", description="Returns medication request to be administered on a specific date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="MedicationRequest.identifier", description="Return prescriptions with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="intended-dispenser", path="MedicationRequest.dispenseRequest.performer", description="Returns prescriptions intended to be dispensed by this Organization", type="reference", target={Organization.class})
    public static final String SP_INTENDED_DISPENSER = "intended-dispenser";
    public static final ReferenceClientParam INTENDED_DISPENSER = new ReferenceClientParam("intended-dispenser");
    public static final Include INCLUDE_INTENDED_DISPENSER = new Include("MedicationRequest:intended-dispenser").toLocked();
    @SearchParamDefinition(name="authoredon", path="MedicationRequest.authoredOn", description="Return prescriptions written on this date", type="date")
    public static final String SP_AUTHOREDON = "authoredon";
    public static final DateClientParam AUTHOREDON = new DateClientParam("authoredon");
    @SearchParamDefinition(name="code", path="MedicationRequest.medication.as(CodeableConcept)", description="Return prescriptions of this medication code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="subject", path="MedicationRequest.subject", description="The identity of a patient to list orders  for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicationRequest:subject").toLocked();
    @SearchParamDefinition(name="medication", path="MedicationRequest.medication.as(Reference)", description="Return prescriptions of this medication reference", type="reference", target={Medication.class})
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationRequest:medication").toLocked();
    @SearchParamDefinition(name="priority", path="MedicationRequest.priority", description="Returns prescriptions with different priorities", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="intent", path="MedicationRequest.intent", description="Returns prescriptions with different intents", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="patient", path="MedicationRequest.subject", description="Returns prescriptions for a specific patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationRequest:patient").toLocked();
    @SearchParamDefinition(name="context", path="MedicationRequest.context", description="Return prescriptions with this encounter or episode of care identifier", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("MedicationRequest:context").toLocked();
    @SearchParamDefinition(name="category", path="MedicationRequest.category", description="Returns prescriptions with different categories", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="MedicationRequest.status", description="Status of the prescription", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public MedicationRequest() {
    }

    public MedicationRequest(Enumeration<MedicationRequestIntent> intent, Type medication, Reference subject) {
        this.intent = intent;
        this.medication = medication;
        this.subject = subject;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        return this.definition;
    }

    public MedicationRequest setDefinition(List<Reference> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (Reference item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDefinition() {
        Reference t = new Reference();
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return t;
    }

    public MedicationRequest addDefinition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return this;
    }

    public Reference getDefinitionFirstRep() {
        if (this.getDefinition().isEmpty()) {
            this.addDefinition();
        }
        return this.getDefinition().get(0);
    }

    @Deprecated
    public List<Resource> getDefinitionTarget() {
        if (this.definitionTarget == null) {
            this.definitionTarget = new ArrayList<Resource>();
        }
        return this.definitionTarget;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public MedicationRequest setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public MedicationRequest addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public MedicationRequest setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public Enumeration<MedicationRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationRequestStatus>(new MedicationRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationRequest setStatusElement(Enumeration<MedicationRequestStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationRequestStatus getStatus() {
        return this.status == null ? null : (MedicationRequestStatus)((Object)this.status.getValue());
    }

    public MedicationRequest setStatus(MedicationRequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<MedicationRequestStatus>(new MedicationRequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<MedicationRequestIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<MedicationRequestIntent>(new MedicationRequestIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public MedicationRequest setIntentElement(Enumeration<MedicationRequestIntent> value) {
        this.intent = value;
        return this;
    }

    public MedicationRequestIntent getIntent() {
        return this.intent == null ? null : (MedicationRequestIntent)((Object)this.intent.getValue());
    }

    public MedicationRequest setIntent(MedicationRequestIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<MedicationRequestIntent>(new MedicationRequestIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public MedicationRequest setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Enumeration<MedicationRequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<MedicationRequestPriority>(new MedicationRequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public MedicationRequest setPriorityElement(Enumeration<MedicationRequestPriority> value) {
        this.priority = value;
        return this;
    }

    public MedicationRequestPriority getPriority() {
        return this.priority == null ? null : (MedicationRequestPriority)((Object)this.priority.getValue());
    }

    public MedicationRequest setPriority(MedicationRequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<MedicationRequestPriority>(new MedicationRequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public Type getMedication() {
        return this.medication;
    }

    public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
        if (this.medication == null) {
            return null;
        }
        if (!(this.medication instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.medication;
    }

    public boolean hasMedicationCodeableConcept() {
        return this != null && this.medication instanceof CodeableConcept;
    }

    public Reference getMedicationReference() throws FHIRException {
        if (this.medication == null) {
            return null;
        }
        if (!(this.medication instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (Reference)this.medication;
    }

    public boolean hasMedicationReference() {
        return this != null && this.medication instanceof Reference;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationRequest setMedication(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for MedicationRequest.medication[x]: " + value.fhirType());
        }
        this.medication = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MedicationRequest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public MedicationRequest setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public MedicationRequest setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public MedicationRequest setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public MedicationRequest setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public MedicationRequest addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    @Deprecated
    public List<Resource> getSupportingInformationTarget() {
        if (this.supportingInformationTarget == null) {
            this.supportingInformationTarget = new ArrayList<Resource>();
        }
        return this.supportingInformationTarget;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public MedicationRequest setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public MedicationRequest setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public MedicationRequestRequesterComponent getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new MedicationRequestRequesterComponent();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public MedicationRequest setRequester(MedicationRequestRequesterComponent value) {
        this.requester = value;
        return this;
    }

    public Reference getRecorder() {
        if (this.recorder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.recorder");
            }
            if (Configuration.doAutoCreate()) {
                this.recorder = new Reference();
            }
        }
        return this.recorder;
    }

    public boolean hasRecorder() {
        return this.recorder != null && !this.recorder.isEmpty();
    }

    public MedicationRequest setRecorder(Reference value) {
        this.recorder = value;
        return this;
    }

    public Practitioner getRecorderTarget() {
        if (this.recorderTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.recorder");
            }
            if (Configuration.doAutoCreate()) {
                this.recorderTarget = new Practitioner();
            }
        }
        return this.recorderTarget;
    }

    public MedicationRequest setRecorderTarget(Practitioner value) {
        this.recorderTarget = value;
        return this;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public MedicationRequest setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public MedicationRequest addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public MedicationRequest setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public MedicationRequest addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    @Deprecated
    public List<Resource> getReasonReferenceTarget() {
        if (this.reasonReferenceTarget == null) {
            this.reasonReferenceTarget = new ArrayList<Resource>();
        }
        return this.reasonReferenceTarget;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public MedicationRequest setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public MedicationRequest addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Dosage> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<Dosage>();
        }
        return this.dosageInstruction;
    }

    public MedicationRequest setDosageInstruction(List<Dosage> theDosageInstruction) {
        this.dosageInstruction = theDosageInstruction;
        return this;
    }

    public boolean hasDosageInstruction() {
        if (this.dosageInstruction == null) {
            return false;
        }
        for (Dosage item : this.dosageInstruction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Dosage addDosageInstruction() {
        Dosage t = new Dosage();
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<Dosage>();
        }
        this.dosageInstruction.add(t);
        return t;
    }

    public MedicationRequest addDosageInstruction(Dosage t) {
        if (t == null) {
            return this;
        }
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<Dosage>();
        }
        this.dosageInstruction.add(t);
        return this;
    }

    public Dosage getDosageInstructionFirstRep() {
        if (this.getDosageInstruction().isEmpty()) {
            this.addDosageInstruction();
        }
        return this.getDosageInstruction().get(0);
    }

    public MedicationRequestDispenseRequestComponent getDispenseRequest() {
        if (this.dispenseRequest == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.dispenseRequest");
            }
            if (Configuration.doAutoCreate()) {
                this.dispenseRequest = new MedicationRequestDispenseRequestComponent();
            }
        }
        return this.dispenseRequest;
    }

    public boolean hasDispenseRequest() {
        return this.dispenseRequest != null && !this.dispenseRequest.isEmpty();
    }

    public MedicationRequest setDispenseRequest(MedicationRequestDispenseRequestComponent value) {
        this.dispenseRequest = value;
        return this;
    }

    public MedicationRequestSubstitutionComponent getSubstitution() {
        if (this.substitution == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.substitution");
            }
            if (Configuration.doAutoCreate()) {
                this.substitution = new MedicationRequestSubstitutionComponent();
            }
        }
        return this.substitution;
    }

    public boolean hasSubstitution() {
        return this.substitution != null && !this.substitution.isEmpty();
    }

    public MedicationRequest setSubstitution(MedicationRequestSubstitutionComponent value) {
        this.substitution = value;
        return this;
    }

    public Reference getPriorPrescription() {
        if (this.priorPrescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.priorPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.priorPrescription = new Reference();
            }
        }
        return this.priorPrescription;
    }

    public boolean hasPriorPrescription() {
        return this.priorPrescription != null && !this.priorPrescription.isEmpty();
    }

    public MedicationRequest setPriorPrescription(Reference value) {
        this.priorPrescription = value;
        return this;
    }

    public MedicationRequest getPriorPrescriptionTarget() {
        if (this.priorPrescriptionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.priorPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.priorPrescriptionTarget = new MedicationRequest();
            }
        }
        return this.priorPrescriptionTarget;
    }

    public MedicationRequest setPriorPrescriptionTarget(MedicationRequest value) {
        this.priorPrescriptionTarget = value;
        return this;
    }

    public List<Reference> getDetectedIssue() {
        if (this.detectedIssue == null) {
            this.detectedIssue = new ArrayList<Reference>();
        }
        return this.detectedIssue;
    }

    public MedicationRequest setDetectedIssue(List<Reference> theDetectedIssue) {
        this.detectedIssue = theDetectedIssue;
        return this;
    }

    public boolean hasDetectedIssue() {
        if (this.detectedIssue == null) {
            return false;
        }
        for (Reference item : this.detectedIssue) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDetectedIssue() {
        Reference t = new Reference();
        if (this.detectedIssue == null) {
            this.detectedIssue = new ArrayList<Reference>();
        }
        this.detectedIssue.add(t);
        return t;
    }

    public MedicationRequest addDetectedIssue(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.detectedIssue == null) {
            this.detectedIssue = new ArrayList<Reference>();
        }
        this.detectedIssue.add(t);
        return this;
    }

    public Reference getDetectedIssueFirstRep() {
        if (this.getDetectedIssue().isEmpty()) {
            this.addDetectedIssue();
        }
        return this.getDetectedIssue().get(0);
    }

    @Deprecated
    public List<DetectedIssue> getDetectedIssueTarget() {
        if (this.detectedIssueTarget == null) {
            this.detectedIssueTarget = new ArrayList<DetectedIssue>();
        }
        return this.detectedIssueTarget;
    }

    @Deprecated
    public DetectedIssue addDetectedIssueTarget() {
        DetectedIssue r = new DetectedIssue();
        if (this.detectedIssueTarget == null) {
            this.detectedIssueTarget = new ArrayList<DetectedIssue>();
        }
        this.detectedIssueTarget.add(r);
        return r;
    }

    public List<Reference> getEventHistory() {
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        return this.eventHistory;
    }

    public MedicationRequest setEventHistory(List<Reference> theEventHistory) {
        this.eventHistory = theEventHistory;
        return this;
    }

    public boolean hasEventHistory() {
        if (this.eventHistory == null) {
            return false;
        }
        for (Reference item : this.eventHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEventHistory() {
        Reference t = new Reference();
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return t;
    }

    public MedicationRequest addEventHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return this;
    }

    public Reference getEventHistoryFirstRep() {
        if (this.getEventHistory().isEmpty()) {
            this.addEventHistory();
        }
        return this.getEventHistory().get(0);
    }

    @Deprecated
    public List<Provenance> getEventHistoryTarget() {
        if (this.eventHistoryTarget == null) {
            this.eventHistoryTarget = new ArrayList<Provenance>();
        }
        return this.eventHistoryTarget;
    }

    @Deprecated
    public Provenance addEventHistoryTarget() {
        Provenance r = new Provenance();
        if (this.eventHistoryTarget == null) {
            this.eventHistoryTarget = new ArrayList<Provenance>();
        }
        this.eventHistoryTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this medication request that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. For example a re-imbursement system might issue its own id for each prescription that is created.  This is particularly important where FHIR only provides part of an entire workflow process where records must be tracked through an entire system.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("definition", "Reference(ActivityDefinition|PlanDefinition)", "Protocol or definition followed by this request.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("basedOn", "Reference(CarePlan|MedicationRequest|ProcedureRequest|ReferralRequest)", "A plan or request that is fulfilled in whole or in part by this medication request.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("groupIdentifier", "Identifier", "A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition or prescription.", 0, 1, this.groupIdentifier));
        children.add(new Property(SP_STATUS, SP_CODE, "A code specifying the current state of the order.  Generally this will be active or completed state.", 0, 1, this.status));
        children.add(new Property(SP_INTENT, SP_CODE, "Whether the request is a proposal, plan, or an original order.", 0, 1, this.intent));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Indicates the type of medication order and where the medication is expected to be consumed or administered.", 0, 1, this.category));
        children.add(new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the Medication Request should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "A link to a resource representing the person or set of individuals to whom the medication will be given.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "A link to an encounter, or episode of care, that identifies the particular occurrence or set occurrences of contact between patient and health care provider.", 0, 1, this.context));
        children.add(new Property("supportingInformation", "Reference(Any)", "Include additional information (for example, patient height and weight) that supports the ordering of the medication.", 0, Integer.MAX_VALUE, this.supportingInformation));
        children.add(new Property("authoredOn", "dateTime", "The date (and perhaps time) when the prescription was initially written or authored on.", 0, 1, this.authoredOn));
        children.add(new Property(SP_REQUESTER, "", "The individual, organization or device that initiated the request and has responsibility for its activation.", 0, 1, this.requester));
        children.add(new Property("recorder", "Reference(Practitioner)", "The person who entered the order on behalf of another individual for example in the case of a verbal or a telephone order.", 0, 1, this.recorder));
        children.add(new Property("reasonCode", "CodeableConcept", "The reason or the indication for ordering the medication.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation)", "Condition or observation that supports why the medication was ordered.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property("note", "Annotation", "Extra information about the prescription that could not be conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("dosageInstruction", "Dosage", "Indicates how the medication is to be used by the patient.", 0, Integer.MAX_VALUE, this.dosageInstruction));
        children.add(new Property("dispenseRequest", "", "Indicates the specific details for the dispense or medication supply part of a medication request (also known as a Medication Prescription or Medication Order).  Note that this information is not always sent with the order.  There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.", 0, 1, this.dispenseRequest));
        children.add(new Property("substitution", "", "Indicates whether or not substitution can or should be part of the dispense. In some cases substitution must happen, in other cases substitution must not happen. This block explains the prescriber's intent. If nothing is specified substitution may be done.", 0, 1, this.substitution));
        children.add(new Property("priorPrescription", "Reference(MedicationRequest)", "A link to a resource representing an earlier order related order or prescription.", 0, 1, this.priorPrescription));
        children.add(new Property("detectedIssue", "Reference(DetectedIssue)", "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, duplicate therapy, dosage alert etc.", 0, Integer.MAX_VALUE, this.detectedIssue));
        children.add(new Property("eventHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this resource or fulfilling request or event resources that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the resource.", 0, Integer.MAX_VALUE, this.eventHistory));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this medication request that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. For example a re-imbursement system might issue its own id for each prescription that is created.  This is particularly important where FHIR only provides part of an entire workflow process where records must be tracked through an entire system.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1014418093: {
                return new Property("definition", "Reference(ActivityDefinition|PlanDefinition)", "Protocol or definition followed by this request.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|MedicationRequest|ProcedureRequest|ReferralRequest)", "A plan or request that is fulfilled in whole or in part by this medication request.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition or prescription.", 0, 1, this.groupIdentifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code specifying the current state of the order.  Generally this will be active or completed state.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property(SP_INTENT, SP_CODE, "Whether the request is a proposal, plan, or an original order.", 0, 1, this.intent);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Indicates the type of medication order and where the medication is expected to be consumed or administered.", 0, 1, this.category);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the Medication Request should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case 1458402129: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 1998965455: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -209845038: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 2104315196: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "A link to a resource representing the person or set of individuals to whom the medication will be given.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "A link to an encounter, or episode of care, that identifies the particular occurrence or set occurrences of contact between patient and health care provider.", 0, 1, this.context);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Include additional information (for example, patient height and weight) that supports the ordering of the medication.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "The date (and perhaps time) when the prescription was initially written or authored on.", 0, 1, this.authoredOn);
            }
            case 693933948: {
                return new Property(SP_REQUESTER, "", "The individual, organization or device that initiated the request and has responsibility for its activation.", 0, 1, this.requester);
            }
            case -799233858: {
                return new Property("recorder", "Reference(Practitioner)", "The person who entered the order on behalf of another individual for example in the case of a verbal or a telephone order.", 0, 1, this.recorder);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "The reason or the indication for ordering the medication.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation)", "Condition or observation that supports why the medication was ordered.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Extra information about the prescription that could not be conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1201373865: {
                return new Property("dosageInstruction", "Dosage", "Indicates how the medication is to be used by the patient.", 0, Integer.MAX_VALUE, this.dosageInstruction);
            }
            case 824620658: {
                return new Property("dispenseRequest", "", "Indicates the specific details for the dispense or medication supply part of a medication request (also known as a Medication Prescription or Medication Order).  Note that this information is not always sent with the order.  There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.", 0, 1, this.dispenseRequest);
            }
            case 826147581: {
                return new Property("substitution", "", "Indicates whether or not substitution can or should be part of the dispense. In some cases substitution must happen, in other cases substitution must not happen. This block explains the prescriber's intent. If nothing is specified substitution may be done.", 0, 1, this.substitution);
            }
            case -486355964: {
                return new Property("priorPrescription", "Reference(MedicationRequest)", "A link to a resource representing an earlier order related order or prescription.", 0, 1, this.priorPrescription);
            }
            case 51602295: {
                return new Property("detectedIssue", "Reference(DetectedIssue)", "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, duplicate therapy, dosage alert etc.", 0, Integer.MAX_VALUE, this.detectedIssue);
            }
            case 1835190426: {
                return new Property("eventHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this resource or fulfilling request or event resources that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the resource.", 0, Integer.MAX_VALUE, this.eventHistory);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.intent;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.category;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.priority;
                }
                return baseArray;
            }
            case 1998965455: {
                Base[] baseArray;
                if (this.medication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.medication;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.context;
                }
                return baseArray;
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requester;
                }
                return baseArray;
            }
            case -799233858: {
                Base[] baseArray;
                if (this.recorder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.recorder;
                }
                return baseArray;
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1201373865: {
                return this.dosageInstruction == null ? new Base[]{} : this.dosageInstruction.toArray(new Base[this.dosageInstruction.size()]);
            }
            case 824620658: {
                Base[] baseArray;
                if (this.dispenseRequest == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.dispenseRequest;
                }
                return baseArray;
            }
            case 826147581: {
                Base[] baseArray;
                if (this.substitution == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.substitution;
                }
                return baseArray;
            }
            case -486355964: {
                Base[] baseArray;
                if (this.priorPrescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.priorPrescription;
                }
                return baseArray;
            }
            case 51602295: {
                return this.detectedIssue == null ? new Base[]{} : this.detectedIssue.toArray(new Base[this.detectedIssue.size()]);
            }
            case 1835190426: {
                return this.eventHistory == null ? new Base[]{} : this.eventHistory.toArray(new Base[this.eventHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new MedicationRequestStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                value = new MedicationRequestIntentEnumFactory().fromType(this.castToCode(value));
                this.intent = value;
                return value;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                return value;
            }
            case -1165461084: {
                value = new MedicationRequestPriorityEnumFactory().fromType(this.castToCode(value));
                this.priority = value;
                return value;
            }
            case 1998965455: {
                this.medication = this.castToType(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(this.castToReference(value));
                return value;
            }
            case -1500852503: {
                this.authoredOn = this.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = (MedicationRequestRequesterComponent)((Object)value);
                return value;
            }
            case -799233858: {
                this.recorder = this.castToReference(value);
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -1201373865: {
                this.getDosageInstruction().add(this.castToDosage(value));
                return value;
            }
            case 824620658: {
                this.dispenseRequest = (MedicationRequestDispenseRequestComponent)((Object)value);
                return value;
            }
            case 826147581: {
                this.substitution = (MedicationRequestSubstitutionComponent)((Object)value);
                return value;
            }
            case -486355964: {
                this.priorPrescription = this.castToReference(value);
                return value;
            }
            case 51602295: {
                this.getDetectedIssue().add(this.castToReference(value));
                return value;
            }
            case 1835190426: {
                this.getEventHistory().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("definition")) {
            this.getDefinition().add(this.castToReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationRequestStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_INTENT)) {
            value = new MedicationRequestIntentEnumFactory().fromType(this.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PRIORITY)) {
            value = new MedicationRequestPriorityEnumFactory().fromType(this.castToCode(value));
            this.priority = value;
        } else if (name.equals("medication[x]")) {
            this.medication = this.castToType(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(this.castToReference(value));
        } else if (name.equals("authoredOn")) {
            this.authoredOn = this.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = (MedicationRequestRequesterComponent)((Object)value);
        } else if (name.equals("recorder")) {
            this.recorder = this.castToReference(value);
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("dosageInstruction")) {
            this.getDosageInstruction().add(this.castToDosage(value));
        } else if (name.equals("dispenseRequest")) {
            this.dispenseRequest = (MedicationRequestDispenseRequestComponent)((Object)value);
        } else if (name.equals("substitution")) {
            this.substitution = (MedicationRequestSubstitutionComponent)((Object)value);
        } else if (name.equals("priorPrescription")) {
            this.priorPrescription = this.castToReference(value);
        } else if (name.equals("detectedIssue")) {
            this.getDetectedIssue().add(this.castToReference(value));
        } else if (name.equals("eventHistory")) {
            this.getEventHistory().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1014418093: {
                return this.addDefinition();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case 50511102: {
                return this.getCategory();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case 1458402129: {
                return this.getMedication();
            }
            case 1998965455: {
                return this.getMedication();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -799233858: {
                return this.getRecorder();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1201373865: {
                return this.addDosageInstruction();
            }
            case 824620658: {
                return this.getDispenseRequest();
            }
            case 826147581: {
                return this.getSubstitution();
            }
            case -486355964: {
                return this.getPriorPrescription();
            }
            case 51602295: {
                return this.addDetectedIssue();
            }
            case 1835190426: {
                return this.addEventHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1183762788: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1165461084: {
                return new String[]{SP_CODE};
            }
            case 1998965455: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[0];
            }
            case -799233858: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1201373865: {
                return new String[]{"Dosage"};
            }
            case 824620658: {
                return new String[0];
            }
            case 826147581: {
                return new String[0];
            }
            case -486355964: {
                return new String[]{"Reference"};
            }
            case 51602295: {
                return new String[]{"Reference"};
            }
            case 1835190426: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("definition")) {
            return this.addDefinition();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.status");
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.intent");
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.priority");
        }
        if (name.equals("medicationCodeableConcept")) {
            this.medication = new CodeableConcept();
            return this.medication;
        }
        if (name.equals("medicationReference")) {
            this.medication = new Reference();
            return this.medication;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.authoredOn");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new MedicationRequestRequesterComponent();
            return this.requester;
        }
        if (name.equals("recorder")) {
            this.recorder = new Reference();
            return this.recorder;
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("dosageInstruction")) {
            return this.addDosageInstruction();
        }
        if (name.equals("dispenseRequest")) {
            this.dispenseRequest = new MedicationRequestDispenseRequestComponent();
            return this.dispenseRequest;
        }
        if (name.equals("substitution")) {
            this.substitution = new MedicationRequestSubstitutionComponent();
            return this.substitution;
        }
        if (name.equals("priorPrescription")) {
            this.priorPrescription = new Reference();
            return this.priorPrescription;
        }
        if (name.equals("detectedIssue")) {
            return this.addDetectedIssue();
        }
        if (name.equals("eventHistory")) {
            return this.addEventHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationRequest";
    }

    @Override
    public MedicationRequest copy() {
        MedicationRequest dst = new MedicationRequest();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.definition != null) {
            dst.definition = new ArrayList<Reference>();
            for (Reference reference : this.definition) {
                dst.definition.add(reference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.medication = this.medication == null ? null : this.medication.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        Reference reference = dst.context = this.context == null ? null : this.context.copy();
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference2 : this.supportingInformation) {
                dst.supportingInformation.add(reference2.copy());
            }
        }
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        dst.requester = this.requester == null ? null : this.requester.copy();
        Reference reference3 = dst.recorder = this.recorder == null ? null : this.recorder.copy();
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference4 : this.reasonReference) {
                dst.reasonReference.add(reference4.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.dosageInstruction != null) {
            dst.dosageInstruction = new ArrayList<Dosage>();
            for (Dosage dosage : this.dosageInstruction) {
                dst.dosageInstruction.add(dosage.copy());
            }
        }
        dst.dispenseRequest = this.dispenseRequest == null ? null : this.dispenseRequest.copy();
        dst.substitution = this.substitution == null ? null : this.substitution.copy();
        Reference reference5 = dst.priorPrescription = this.priorPrescription == null ? null : this.priorPrescription.copy();
        if (this.detectedIssue != null) {
            dst.detectedIssue = new ArrayList<Reference>();
            for (Reference reference6 : this.detectedIssue) {
                dst.detectedIssue.add(reference6.copy());
            }
        }
        if (this.eventHistory != null) {
            dst.eventHistory = new ArrayList<Reference>();
            for (Reference reference7 : this.eventHistory) {
                dst.eventHistory.add(reference7.copy());
            }
        }
        return dst;
    }

    protected MedicationRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationRequest)) {
            return false;
        }
        MedicationRequest o = (MedicationRequest)other_;
        return MedicationRequest.compareDeep(this.identifier, o.identifier, true) && MedicationRequest.compareDeep(this.definition, o.definition, true) && MedicationRequest.compareDeep(this.basedOn, o.basedOn, true) && MedicationRequest.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && MedicationRequest.compareDeep(this.status, o.status, true) && MedicationRequest.compareDeep(this.intent, o.intent, true) && MedicationRequest.compareDeep(this.category, o.category, true) && MedicationRequest.compareDeep(this.priority, o.priority, true) && MedicationRequest.compareDeep(this.medication, o.medication, true) && MedicationRequest.compareDeep(this.subject, o.subject, true) && MedicationRequest.compareDeep(this.context, o.context, true) && MedicationRequest.compareDeep(this.supportingInformation, o.supportingInformation, true) && MedicationRequest.compareDeep(this.authoredOn, o.authoredOn, true) && MedicationRequest.compareDeep(this.requester, o.requester, true) && MedicationRequest.compareDeep(this.recorder, o.recorder, true) && MedicationRequest.compareDeep(this.reasonCode, o.reasonCode, true) && MedicationRequest.compareDeep(this.reasonReference, o.reasonReference, true) && MedicationRequest.compareDeep(this.note, o.note, true) && MedicationRequest.compareDeep(this.dosageInstruction, o.dosageInstruction, true) && MedicationRequest.compareDeep(this.dispenseRequest, o.dispenseRequest, true) && MedicationRequest.compareDeep(this.substitution, o.substitution, true) && MedicationRequest.compareDeep(this.priorPrescription, o.priorPrescription, true) && MedicationRequest.compareDeep(this.detectedIssue, o.detectedIssue, true) && MedicationRequest.compareDeep(this.eventHistory, o.eventHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationRequest)) {
            return false;
        }
        MedicationRequest o = (MedicationRequest)other_;
        return MedicationRequest.compareValues(this.status, o.status, true) && MedicationRequest.compareValues(this.intent, o.intent, true) && MedicationRequest.compareValues(this.priority, o.priority, true) && MedicationRequest.compareValues(this.authoredOn, o.authoredOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.definition, this.basedOn, this.groupIdentifier, this.status, this.intent, this.category, this.priority, this.medication, this.subject, this.context, this.supportingInformation, this.authoredOn, this.requester, this.recorder, this.reasonCode, this.reasonReference, this.note, this.dosageInstruction, this.dispenseRequest, this.substitution, this.priorPrescription, this.detectedIssue, this.eventHistory});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationRequest;
    }

    @Block
    public static class MedicationRequestSubstitutionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="allowed", type={BooleanType.class}, order=1, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="Whether substitution is allowed or not", formalDefinition="True if the prescriber allows a different drug to be dispensed from what was prescribed.")
        protected BooleanType allowed;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why should (not) substitution be made", formalDefinition="Indicates the reason for the substitution, or why substitution must or must not be performed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-SubstanceAdminSubstitutionReason")
        protected CodeableConcept reason;
        private static final long serialVersionUID = -141547037L;

        public MedicationRequestSubstitutionComponent() {
        }

        public MedicationRequestSubstitutionComponent(BooleanType allowed) {
            this.allowed = allowed;
        }

        public BooleanType getAllowedElement() {
            if (this.allowed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestSubstitutionComponent.allowed");
                }
                if (Configuration.doAutoCreate()) {
                    this.allowed = new BooleanType();
                }
            }
            return this.allowed;
        }

        public boolean hasAllowedElement() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public boolean hasAllowed() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public MedicationRequestSubstitutionComponent setAllowedElement(BooleanType value) {
            this.allowed = value;
            return this;
        }

        public boolean getAllowed() {
            return this.allowed == null || this.allowed.isEmpty() ? false : (Boolean)this.allowed.getValue();
        }

        public MedicationRequestSubstitutionComponent setAllowed(boolean value) {
            if (this.allowed == null) {
                this.allowed = new BooleanType();
            }
            this.allowed.setValue((Object)value);
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestSubstitutionComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public MedicationRequestSubstitutionComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("allowed", "boolean", "True if the prescriber allows a different drug to be dispensed from what was prescribed.", 0, 1, this.allowed));
            children.add(new Property("reason", "CodeableConcept", "Indicates the reason for the substitution, or why substitution must or must not be performed.", 0, 1, this.reason));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -911343192: {
                    return new Property("allowed", "boolean", "True if the prescriber allows a different drug to be dispensed from what was prescribed.", 0, 1, this.allowed);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "Indicates the reason for the substitution, or why substitution must or must not be performed.", 0, 1, this.reason);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -911343192: {
                    Base[] baseArray;
                    if (this.allowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.allowed;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -911343192: {
                    this.allowed = this.castToBoolean(value);
                    return value;
                }
                case -934964668: {
                    this.reason = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("allowed")) {
                this.allowed = this.castToBoolean(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -911343192: {
                    return this.getAllowedElement();
                }
                case -934964668: {
                    return this.getReason();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -911343192: {
                    return new String[]{"boolean"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("allowed")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.allowed");
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationRequestSubstitutionComponent copy() {
            MedicationRequestSubstitutionComponent dst = new MedicationRequestSubstitutionComponent();
            this.copyValues(dst);
            dst.allowed = this.allowed == null ? null : this.allowed.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestSubstitutionComponent)) {
                return false;
            }
            MedicationRequestSubstitutionComponent o = (MedicationRequestSubstitutionComponent)other_;
            return MedicationRequestSubstitutionComponent.compareDeep(this.allowed, o.allowed, true) && MedicationRequestSubstitutionComponent.compareDeep(this.reason, o.reason, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestSubstitutionComponent)) {
                return false;
            }
            MedicationRequestSubstitutionComponent o = (MedicationRequestSubstitutionComponent)other_;
            return MedicationRequestSubstitutionComponent.compareValues(this.allowed, o.allowed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.allowed, this.reason});
        }

        @Override
        public String fhirType() {
            return "MedicationRequest.substitution";
        }
    }

    @Block
    public static class MedicationRequestDispenseRequestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="validityPeriod", type={Period.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time period supply is authorized for", formalDefinition="This indicates the validity period of a prescription (stale dating the Prescription).")
        protected Period validityPeriod;
        @Child(name="numberOfRepeatsAllowed", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of refills authorized", formalDefinition="An integer indicating the number of times, in addition to the original dispense, (aka refills or repeats) that the patient can receive the prescribed medication. Usage Notes: This integer does not include the original order dispense. This means that if an order indicates dispense 30 tablets plus \"3 repeats\", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets.")
        protected PositiveIntType numberOfRepeatsAllowed;
        @Child(name="quantity", type={SimpleQuantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of medication to supply per dispense", formalDefinition="The amount that is to be dispensed for one fill.")
        protected SimpleQuantity quantity;
        @Child(name="expectedSupplyDuration", type={Duration.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of days supply per dispense", formalDefinition="Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.")
        protected Duration expectedSupplyDuration;
        @Child(name="performer", type={Organization.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Intended dispenser", formalDefinition="Indicates the intended dispensing Organization specified by the prescriber.")
        protected Reference performer;
        protected Organization performerTarget;
        private static final long serialVersionUID = 280197622L;

        public Period getValidityPeriod() {
            if (this.validityPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.validityPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.validityPeriod = new Period();
                }
            }
            return this.validityPeriod;
        }

        public boolean hasValidityPeriod() {
            return this.validityPeriod != null && !this.validityPeriod.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setValidityPeriod(Period value) {
            this.validityPeriod = value;
            return this;
        }

        public PositiveIntType getNumberOfRepeatsAllowedElement() {
            if (this.numberOfRepeatsAllowed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.numberOfRepeatsAllowed");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfRepeatsAllowed = new PositiveIntType();
                }
            }
            return this.numberOfRepeatsAllowed;
        }

        public boolean hasNumberOfRepeatsAllowedElement() {
            return this.numberOfRepeatsAllowed != null && !this.numberOfRepeatsAllowed.isEmpty();
        }

        public boolean hasNumberOfRepeatsAllowed() {
            return this.numberOfRepeatsAllowed != null && !this.numberOfRepeatsAllowed.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setNumberOfRepeatsAllowedElement(PositiveIntType value) {
            this.numberOfRepeatsAllowed = value;
            return this;
        }

        public int getNumberOfRepeatsAllowed() {
            return this.numberOfRepeatsAllowed == null || this.numberOfRepeatsAllowed.isEmpty() ? 0 : (Integer)this.numberOfRepeatsAllowed.getValue();
        }

        public MedicationRequestDispenseRequestComponent setNumberOfRepeatsAllowed(int value) {
            if (this.numberOfRepeatsAllowed == null) {
                this.numberOfRepeatsAllowed = new PositiveIntType();
            }
            this.numberOfRepeatsAllowed.setValue((Object)value);
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Duration getExpectedSupplyDuration() {
            if (this.expectedSupplyDuration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.expectedSupplyDuration");
                }
                if (Configuration.doAutoCreate()) {
                    this.expectedSupplyDuration = new Duration();
                }
            }
            return this.expectedSupplyDuration;
        }

        public boolean hasExpectedSupplyDuration() {
            return this.expectedSupplyDuration != null && !this.expectedSupplyDuration.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setExpectedSupplyDuration(Duration value) {
            this.expectedSupplyDuration = value;
            return this;
        }

        public Reference getPerformer() {
            if (this.performer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.performer");
                }
                if (Configuration.doAutoCreate()) {
                    this.performer = new Reference();
                }
            }
            return this.performer;
        }

        public boolean hasPerformer() {
            return this.performer != null && !this.performer.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setPerformer(Reference value) {
            this.performer = value;
            return this;
        }

        public Organization getPerformerTarget() {
            if (this.performerTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.performer");
                }
                if (Configuration.doAutoCreate()) {
                    this.performerTarget = new Organization();
                }
            }
            return this.performerTarget;
        }

        public MedicationRequestDispenseRequestComponent setPerformerTarget(Organization value) {
            this.performerTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("validityPeriod", "Period", "This indicates the validity period of a prescription (stale dating the Prescription).", 0, 1, this.validityPeriod));
            children.add(new Property("numberOfRepeatsAllowed", "positiveInt", "An integer indicating the number of times, in addition to the original dispense, (aka refills or repeats) that the patient can receive the prescribed medication. Usage Notes: This integer does not include the original order dispense. This means that if an order indicates dispense 30 tablets plus \"3 repeats\", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets.", 0, 1, this.numberOfRepeatsAllowed));
            children.add(new Property("quantity", "SimpleQuantity", "The amount that is to be dispensed for one fill.", 0, 1, this.quantity));
            children.add(new Property("expectedSupplyDuration", "Duration", "Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.", 0, 1, this.expectedSupplyDuration));
            children.add(new Property("performer", "Reference(Organization)", "Indicates the intended dispensing Organization specified by the prescriber.", 0, 1, this.performer));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1434195053: {
                    return new Property("validityPeriod", "Period", "This indicates the validity period of a prescription (stale dating the Prescription).", 0, 1, this.validityPeriod);
                }
                case -239736976: {
                    return new Property("numberOfRepeatsAllowed", "positiveInt", "An integer indicating the number of times, in addition to the original dispense, (aka refills or repeats) that the patient can receive the prescribed medication. Usage Notes: This integer does not include the original order dispense. This means that if an order indicates dispense 30 tablets plus \"3 repeats\", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets.", 0, 1, this.numberOfRepeatsAllowed);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The amount that is to be dispensed for one fill.", 0, 1, this.quantity);
                }
                case -1910182789: {
                    return new Property("expectedSupplyDuration", "Duration", "Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.", 0, 1, this.expectedSupplyDuration);
                }
                case 481140686: {
                    return new Property("performer", "Reference(Organization)", "Indicates the intended dispensing Organization specified by the prescriber.", 0, 1, this.performer);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1434195053: {
                    Base[] baseArray;
                    if (this.validityPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.validityPeriod;
                    }
                    return baseArray;
                }
                case -239736976: {
                    Base[] baseArray;
                    if (this.numberOfRepeatsAllowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.numberOfRepeatsAllowed;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1910182789: {
                    Base[] baseArray;
                    if (this.expectedSupplyDuration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.expectedSupplyDuration;
                    }
                    return baseArray;
                }
                case 481140686: {
                    Base[] baseArray;
                    if (this.performer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.performer;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1434195053: {
                    this.validityPeriod = this.castToPeriod(value);
                    return value;
                }
                case -239736976: {
                    this.numberOfRepeatsAllowed = this.castToPositiveInt(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
                case -1910182789: {
                    this.expectedSupplyDuration = this.castToDuration(value);
                    return value;
                }
                case 481140686: {
                    this.performer = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("validityPeriod")) {
                this.validityPeriod = this.castToPeriod(value);
            } else if (name.equals("numberOfRepeatsAllowed")) {
                this.numberOfRepeatsAllowed = this.castToPositiveInt(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("expectedSupplyDuration")) {
                this.expectedSupplyDuration = this.castToDuration(value);
            } else if (name.equals("performer")) {
                this.performer = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1434195053: {
                    return this.getValidityPeriod();
                }
                case -239736976: {
                    return this.getNumberOfRepeatsAllowedElement();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1910182789: {
                    return this.getExpectedSupplyDuration();
                }
                case 481140686: {
                    return this.getPerformer();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1434195053: {
                    return new String[]{"Period"};
                }
                case -239736976: {
                    return new String[]{"positiveInt"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -1910182789: {
                    return new String[]{"Duration"};
                }
                case 481140686: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("validityPeriod")) {
                this.validityPeriod = new Period();
                return this.validityPeriod;
            }
            if (name.equals("numberOfRepeatsAllowed")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.numberOfRepeatsAllowed");
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("expectedSupplyDuration")) {
                this.expectedSupplyDuration = new Duration();
                return this.expectedSupplyDuration;
            }
            if (name.equals("performer")) {
                this.performer = new Reference();
                return this.performer;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationRequestDispenseRequestComponent copy() {
            MedicationRequestDispenseRequestComponent dst = new MedicationRequestDispenseRequestComponent();
            this.copyValues(dst);
            dst.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.copy();
            dst.numberOfRepeatsAllowed = this.numberOfRepeatsAllowed == null ? null : this.numberOfRepeatsAllowed.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.expectedSupplyDuration = this.expectedSupplyDuration == null ? null : this.expectedSupplyDuration.copy();
            dst.performer = this.performer == null ? null : this.performer.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestDispenseRequestComponent)) {
                return false;
            }
            MedicationRequestDispenseRequestComponent o = (MedicationRequestDispenseRequestComponent)other_;
            return MedicationRequestDispenseRequestComponent.compareDeep(this.validityPeriod, o.validityPeriod, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.numberOfRepeatsAllowed, o.numberOfRepeatsAllowed, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.quantity, o.quantity, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.expectedSupplyDuration, o.expectedSupplyDuration, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.performer, o.performer, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestDispenseRequestComponent)) {
                return false;
            }
            MedicationRequestDispenseRequestComponent o = (MedicationRequestDispenseRequestComponent)other_;
            return MedicationRequestDispenseRequestComponent.compareValues(this.numberOfRepeatsAllowed, o.numberOfRepeatsAllowed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.validityPeriod, this.numberOfRepeatsAllowed, this.quantity, this.expectedSupplyDuration, this.performer});
        }

        @Override
        public String fhirType() {
            return "MedicationRequest.dispenseRequest";
        }
    }

    @Block
    public static class MedicationRequestRequesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="agent", type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class, Device.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who ordered the initial medication(s)", formalDefinition="The healthcare professional responsible for authorizing the initial prescription.")
        protected Reference agent;
        protected Resource agentTarget;
        @Child(name="onBehalfOf", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Organization agent is acting for", formalDefinition="The organization the device or practitioner was acting on behalf of.")
        protected Reference onBehalfOf;
        protected Organization onBehalfOfTarget;
        private static final long serialVersionUID = -71453027L;

        public MedicationRequestRequesterComponent() {
        }

        public MedicationRequestRequesterComponent(Reference agent) {
            this.agent = agent;
        }

        public Reference getAgent() {
            if (this.agent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestRequesterComponent.agent");
                }
                if (Configuration.doAutoCreate()) {
                    this.agent = new Reference();
                }
            }
            return this.agent;
        }

        public boolean hasAgent() {
            return this.agent != null && !this.agent.isEmpty();
        }

        public MedicationRequestRequesterComponent setAgent(Reference value) {
            this.agent = value;
            return this;
        }

        public Resource getAgentTarget() {
            return this.agentTarget;
        }

        public MedicationRequestRequesterComponent setAgentTarget(Resource value) {
            this.agentTarget = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public MedicationRequestRequesterComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Organization getOnBehalfOfTarget() {
            if (this.onBehalfOfTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOfTarget = new Organization();
                }
            }
            return this.onBehalfOfTarget;
        }

        public MedicationRequestRequesterComponent setOnBehalfOfTarget(Organization value) {
            this.onBehalfOfTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("agent", "Reference(Practitioner|Organization|Patient|RelatedPerson|Device)", "The healthcare professional responsible for authorizing the initial prescription.", 0, 1, this.agent));
            children.add(new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 92750597: {
                    return new Property("agent", "Reference(Practitioner|Organization|Patient|RelatedPerson|Device)", "The healthcare professional responsible for authorizing the initial prescription.", 0, 1, this.agent);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    Base[] baseArray;
                    if (this.agent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.agent;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    this.agent = this.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = this.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return this.getAgent();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = new Reference();
                return this.agent;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationRequestRequesterComponent copy() {
            MedicationRequestRequesterComponent dst = new MedicationRequestRequesterComponent();
            this.copyValues(dst);
            dst.agent = this.agent == null ? null : this.agent.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestRequesterComponent)) {
                return false;
            }
            MedicationRequestRequesterComponent o = (MedicationRequestRequesterComponent)other_;
            return MedicationRequestRequesterComponent.compareDeep(this.agent, o.agent, true) && MedicationRequestRequesterComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestRequesterComponent)) {
                return false;
            }
            MedicationRequestRequesterComponent o = (MedicationRequestRequesterComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.agent, this.onBehalfOf});
        }

        @Override
        public String fhirType() {
            return "MedicationRequest.requester";
        }
    }

    public static class MedicationRequestPriorityEnumFactory
    implements EnumFactory<MedicationRequestPriority> {
        @Override
        public MedicationRequestPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return MedicationRequestPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return MedicationRequestPriority.URGENT;
            }
            if ("stat".equals(codeString)) {
                return MedicationRequestPriority.STAT;
            }
            if ("asap".equals(codeString)) {
                return MedicationRequestPriority.ASAP;
            }
            throw new IllegalArgumentException("Unknown MedicationRequestPriority code '" + codeString + "'");
        }

        public Enumeration<MedicationRequestPriority> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationRequestPriority>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<MedicationRequestPriority>(this, MedicationRequestPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<MedicationRequestPriority>(this, MedicationRequestPriority.URGENT);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<MedicationRequestPriority>(this, MedicationRequestPriority.STAT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<MedicationRequestPriority>(this, MedicationRequestPriority.ASAP);
            }
            throw new FHIRException("Unknown MedicationRequestPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationRequestPriority code) {
            if (code == MedicationRequestPriority.ROUTINE) {
                return "routine";
            }
            if (code == MedicationRequestPriority.URGENT) {
                return "urgent";
            }
            if (code == MedicationRequestPriority.STAT) {
                return "stat";
            }
            if (code == MedicationRequestPriority.ASAP) {
                return "asap";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationRequestPriority code) {
            return code.getSystem();
        }
    }

    public static enum MedicationRequestPriority {
        ROUTINE,
        URGENT,
        STAT,
        ASAP,
        NULL;


        public static MedicationRequestPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationRequestPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case STAT: {
                    return "stat";
                }
                case ASAP: {
                    return "asap";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/medication-request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/medication-request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/medication-request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/medication-request-priority";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The order has a normal priority .";
                }
                case URGENT: {
                    return "The order should be urgently.";
                }
                case STAT: {
                    return "The order is time-critical.";
                }
                case ASAP: {
                    return "The order should be acted on as soon as possible.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case STAT: {
                    return "Stat";
                }
                case ASAP: {
                    return "ASAP";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class MedicationRequestIntentEnumFactory
    implements EnumFactory<MedicationRequestIntent> {
        @Override
        public MedicationRequestIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return MedicationRequestIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return MedicationRequestIntent.PLAN;
            }
            if ("order".equals(codeString)) {
                return MedicationRequestIntent.ORDER;
            }
            if ("instance-order".equals(codeString)) {
                return MedicationRequestIntent.INSTANCEORDER;
            }
            throw new IllegalArgumentException("Unknown MedicationRequestIntent code '" + codeString + "'");
        }

        public Enumeration<MedicationRequestIntent> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationRequestIntent>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.PROPOSAL);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.PLAN);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.ORDER);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.INSTANCEORDER);
            }
            throw new FHIRException("Unknown MedicationRequestIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationRequestIntent code) {
            if (code == MedicationRequestIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == MedicationRequestIntent.PLAN) {
                return "plan";
            }
            if (code == MedicationRequestIntent.ORDER) {
                return "order";
            }
            if (code == MedicationRequestIntent.INSTANCEORDER) {
                return "instance-order";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationRequestIntent code) {
            return code.getSystem();
        }
    }

    public static enum MedicationRequestIntent {
        PROPOSAL,
        PLAN,
        ORDER,
        INSTANCEORDER,
        NULL;


        public static MedicationRequestIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationRequestIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/medication-request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/medication-request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/medication-request-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/medication-request-intent";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that doesn't have an intention to ensure it occurs and without providing an authorization to act";
                }
                case PLAN: {
                    return "The request represents an intension to ensure something occurs without providing an authorization for others to act";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action";
                }
                case INSTANCEORDER: {
                    return "The request represents an instance for the particular order, for example a medication administration record.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class MedicationRequestStatusEnumFactory
    implements EnumFactory<MedicationRequestStatus> {
        @Override
        public MedicationRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationRequestStatus.ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationRequestStatus.ONHOLD;
            }
            if ("cancelled".equals(codeString)) {
                return MedicationRequestStatus.CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return MedicationRequestStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationRequestStatus.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return MedicationRequestStatus.STOPPED;
            }
            if ("draft".equals(codeString)) {
                return MedicationRequestStatus.DRAFT;
            }
            if ("unknown".equals(codeString)) {
                return MedicationRequestStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown MedicationRequestStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationRequestStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationRequestStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationRequestStatus>(this, MedicationRequestStatus.ACTIVE);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationRequestStatus>(this, MedicationRequestStatus.ONHOLD);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<MedicationRequestStatus>(this, MedicationRequestStatus.CANCELLED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationRequestStatus>(this, MedicationRequestStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationRequestStatus>(this, MedicationRequestStatus.ENTEREDINERROR);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationRequestStatus>(this, MedicationRequestStatus.STOPPED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<MedicationRequestStatus>(this, MedicationRequestStatus.DRAFT);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<MedicationRequestStatus>(this, MedicationRequestStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown MedicationRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationRequestStatus code) {
            if (code == MedicationRequestStatus.ACTIVE) {
                return "active";
            }
            if (code == MedicationRequestStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == MedicationRequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == MedicationRequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == MedicationRequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationRequestStatus.STOPPED) {
                return "stopped";
            }
            if (code == MedicationRequestStatus.DRAFT) {
                return "draft";
            }
            if (code == MedicationRequestStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum MedicationRequestStatus {
        ACTIVE,
        ONHOLD,
        CANCELLED,
        COMPLETED,
        ENTEREDINERROR,
        STOPPED,
        DRAFT,
        UNKNOWN,
        NULL;


        public static MedicationRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
                case DRAFT: {
                    return "draft";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/medication-request-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/medication-request-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/medication-request-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/medication-request-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/medication-request-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/medication-request-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/medication-request-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/medication-request-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The prescription is 'actionable', but not all actions that are implied by it have occurred yet.";
                }
                case ONHOLD: {
                    return "Actions implied by the prescription are to be temporarily halted, but are expected to continue later.  May also be called \"suspended\".";
                }
                case CANCELLED: {
                    return "The prescription has been withdrawn.";
                }
                case COMPLETED: {
                    return "All actions that are implied by the prescription have occurred.";
                }
                case ENTEREDINERROR: {
                    return "The prescription was entered in error.";
                }
                case STOPPED: {
                    return "Actions implied by the prescription are to be permanently halted, before all of them occurred.";
                }
                case DRAFT: {
                    return "The prescription is not yet 'actionable', i.e. it is a work in progress, requires sign-off or verification, and needs to be run through decision support process.";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case DRAFT: {
                    return "Draft";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

