/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogEntryStatus {
    APPROVED,
    PENDING,
    DISCONTINUED,
    OFFICIAL,
    NULL;


    public static CatalogEntryStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("approved".equals(codeString)) {
            return APPROVED;
        }
        if ("pending".equals(codeString)) {
            return PENDING;
        }
        if ("discontinued".equals(codeString)) {
            return DISCONTINUED;
        }
        if ("official".equals(codeString)) {
            return OFFICIAL;
        }
        throw new FHIRException("Unknown CatalogEntryStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case APPROVED: {
                return "approved";
            }
            case PENDING: {
                return "pending";
            }
            case DISCONTINUED: {
                return "discontinued";
            }
            case OFFICIAL: {
                return "official";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/catalog-entry-status";
    }

    public String getDefinition() {
        switch (this) {
            case APPROVED: {
                return "The entry is approved for use";
            }
            case PENDING: {
                return "The entry is pending some action e.g. confirmation or approval";
            }
            case DISCONTINUED: {
                return "The catalog entry is discontinued";
            }
            case OFFICIAL: {
                return "The catalog entry is considered official";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case APPROVED: {
                return "Approved";
            }
            case PENDING: {
                return "Pending";
            }
            case DISCONTINUED: {
                return "Discontinued";
            }
            case OFFICIAL: {
                return "Official";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

