/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogUpdateMode {
    UPDATE,
    REPLACE,
    UPSERT,
    NULL;


    public static CatalogUpdateMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("update".equals(codeString)) {
            return UPDATE;
        }
        if ("replace".equals(codeString)) {
            return REPLACE;
        }
        if ("upsert".equals(codeString)) {
            return UPSERT;
        }
        throw new FHIRException("Unknown CatalogUpdateMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UPDATE: {
                return "update";
            }
            case REPLACE: {
                return "replace";
            }
            case UPSERT: {
                return "upsert";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/catalog-update-mode";
    }

    public String getDefinition() {
        switch (this) {
            case UPDATE: {
                return "This is a product submission";
            }
            case REPLACE: {
                return "The catalog content is expected to be replacing the existing entries";
            }
            case UPSERT: {
                return "The catalog content is expected to update the entries, and if not existing, insert the entry";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UPDATE: {
                return "Update";
            }
            case REPLACE: {
                return "Replace";
            }
            case UPSERT: {
                return "Upsert";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

