/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RestfulSecurityService {
    OAUTH,
    SMARTONFHIR,
    NTLM,
    BASIC,
    KERBEROS,
    CERTIFICATES,
    NULL;


    public static RestfulSecurityService fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("OAuth".equals(codeString)) {
            return OAUTH;
        }
        if ("SMART-on-FHIR".equals(codeString)) {
            return SMARTONFHIR;
        }
        if ("NTLM".equals(codeString)) {
            return NTLM;
        }
        if ("Basic".equals(codeString)) {
            return BASIC;
        }
        if ("Kerberos".equals(codeString)) {
            return KERBEROS;
        }
        if ("Certificates".equals(codeString)) {
            return CERTIFICATES;
        }
        throw new FHIRException("Unknown RestfulSecurityService code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case OAUTH: {
                return "OAuth";
            }
            case SMARTONFHIR: {
                return "SMART-on-FHIR";
            }
            case NTLM: {
                return "NTLM";
            }
            case BASIC: {
                return "Basic";
            }
            case KERBEROS: {
                return "Kerberos";
            }
            case CERTIFICATES: {
                return "Certificates";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/restful-security-service";
    }

    public String getDefinition() {
        switch (this) {
            case OAUTH: {
                return "Oauth (unspecified version see oauth.net).";
            }
            case SMARTONFHIR: {
                return "OAuth2 using SMART-on-FHIR profile (see http://docs.smarthealthit.org/).";
            }
            case NTLM: {
                return "Microsoft NTLM Authentication.";
            }
            case BASIC: {
                return "Basic authentication defined in HTTP specification.";
            }
            case KERBEROS: {
                return "see http://www.ietf.org/rfc/rfc4120.txt.";
            }
            case CERTIFICATES: {
                return "SSL where client must have a certificate registered with the server.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case OAUTH: {
                return "OAuth";
            }
            case SMARTONFHIR: {
                return "SMART-on-FHIR";
            }
            case NTLM: {
                return "NTLM";
            }
            case BASIC: {
                return "Basic";
            }
            case KERBEROS: {
                return "Kerberos";
            }
            case CERTIFICATES: {
                return "Certificates";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

