/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ImagingStudy;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImagingManifest", profile="http://hl7.org/fhir/Profile/ImagingManifest")
public class ImagingManifest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="SOP Instance UID", formalDefinition="Unique identifier of the DICOM Key Object Selection (KOS) that this resource represents.")
    protected Identifier identifier;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient of the selected objects", formalDefinition="A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingManifest.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="authoringTime", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time when the selection of instances was made", formalDefinition="Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).")
    protected DateTimeType authoringTime;
    @Child(name="author", type={Practitioner.class, Device.class, Organization.class, Patient.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Author (human or machine)", formalDefinition="Author of ImagingManifest. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description text", formalDefinition="Free text narrative description of the ImagingManifest.  \nThe value may be derived from the DICOM Standard Part 16, CID-7010 descriptions (e.g. Best in Set, Complete Study Content). Note that those values cover the wide range of uses of the DICOM Key Object Selection object, several of which are not supported by ImagingManifest. Specifically, there is no expected behavior associated with descriptions that suggest referenced images be removed or not used.")
    protected StringType description;
    @Child(name="study", type={}, order=5, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Study identity of the selected instances", formalDefinition="Study identity and locating information of the DICOM SOP instances in the selection.")
    protected List<StudyComponent> study;
    private static final long serialVersionUID = 245941978L;
    @SearchParamDefinition(name="identifier", path="ImagingManifest.identifier", description="UID of the ImagingManifest (or a DICOM Key Object Selection which it represents)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="endpoint", path="ImagingManifest.study.endpoint | ImagingManifest.study.series.endpoint", description="The endpoint for the study or series", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("ImagingManifest:endpoint").toLocked();
    @SearchParamDefinition(name="authoring-time", path="ImagingManifest.authoringTime", description="Time of the ImagingManifest (or a DICOM Key Object Selection which it represents) authoring", type="date")
    public static final String SP_AUTHORING_TIME = "authoring-time";
    public static final DateClientParam AUTHORING_TIME = new DateClientParam("authoring-time");
    @SearchParamDefinition(name="selected-study", path="ImagingManifest.study.uid", description="Study selected in the ImagingManifest (or a DICOM Key Object Selection which it represents)", type="uri")
    public static final String SP_SELECTED_STUDY = "selected-study";
    public static final UriClientParam SELECTED_STUDY = new UriClientParam("selected-study");
    @SearchParamDefinition(name="author", path="ImagingManifest.author", description="Author of the ImagingManifest (or a DICOM Key Object Selection which it represents)", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("ImagingManifest:author").toLocked();
    @SearchParamDefinition(name="patient", path="ImagingManifest.patient", description="Subject of the ImagingManifest (or a DICOM Key Object Selection which it represents)", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImagingManifest:patient").toLocked();
    @SearchParamDefinition(name="imaging-study", path="ImagingManifest.study.imagingStudy", description="ImagingStudy resource selected in the ImagingManifest (or a DICOM Key Object Selection which it represents)", type="reference", target={ImagingStudy.class})
    public static final String SP_IMAGING_STUDY = "imaging-study";
    public static final ReferenceClientParam IMAGING_STUDY = new ReferenceClientParam("imaging-study");
    public static final Include INCLUDE_IMAGING_STUDY = new Include("ImagingManifest:imaging-study").toLocked();

    public ImagingManifest() {
    }

    public ImagingManifest(Reference patient) {
        this.patient = patient;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingManifest.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ImagingManifest setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingManifest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImagingManifest setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingManifest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ImagingManifest setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getAuthoringTimeElement() {
        if (this.authoringTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingManifest.authoringTime");
            }
            if (Configuration.doAutoCreate()) {
                this.authoringTime = new DateTimeType();
            }
        }
        return this.authoringTime;
    }

    public boolean hasAuthoringTimeElement() {
        return this.authoringTime != null && !this.authoringTime.isEmpty();
    }

    public boolean hasAuthoringTime() {
        return this.authoringTime != null && !this.authoringTime.isEmpty();
    }

    public ImagingManifest setAuthoringTimeElement(DateTimeType value) {
        this.authoringTime = value;
        return this;
    }

    public Date getAuthoringTime() {
        return this.authoringTime == null ? null : (Date)this.authoringTime.getValue();
    }

    public ImagingManifest setAuthoringTime(Date value) {
        if (value == null) {
            this.authoringTime = null;
        } else {
            if (this.authoringTime == null) {
                this.authoringTime = new DateTimeType();
            }
            this.authoringTime.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingManifest.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public ImagingManifest setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public ImagingManifest setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingManifest.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ImagingManifest setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ImagingManifest setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<StudyComponent> getStudy() {
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        return this.study;
    }

    public ImagingManifest setStudy(List<StudyComponent> theStudy) {
        this.study = theStudy;
        return this;
    }

    public boolean hasStudy() {
        if (this.study == null) {
            return false;
        }
        for (StudyComponent item : this.study) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StudyComponent addStudy() {
        StudyComponent t = new StudyComponent();
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        this.study.add(t);
        return t;
    }

    public ImagingManifest addStudy(StudyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        this.study.add(t);
        return this;
    }

    public StudyComponent getStudyFirstRep() {
        if (this.getStudy().isEmpty()) {
            this.addStudy();
        }
        return this.getStudy().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier of the DICOM Key Object Selection (KOS) that this resource represents.", 0, 1, this.identifier));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingManifest.", 0, 1, this.patient));
        children.add(new Property("authoringTime", "dateTime", "Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).", 0, 1, this.authoringTime));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner|Device|Organization|Patient|RelatedPerson)", "Author of ImagingManifest. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.", 0, 1, this.author));
        children.add(new Property("description", "string", "Free text narrative description of the ImagingManifest.  \nThe value may be derived from the DICOM Standard Part 16, CID-7010 descriptions (e.g. Best in Set, Complete Study Content). Note that those values cover the wide range of uses of the DICOM Key Object Selection object, several of which are not supported by ImagingManifest. Specifically, there is no expected behavior associated with descriptions that suggest referenced images be removed or not used.", 0, 1, this.description));
        children.add(new Property("study", "", "Study identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.study));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier of the DICOM Key Object Selection (KOS) that this resource represents.", 0, 1, this.identifier);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingManifest.", 0, 1, this.patient);
            }
            case -1724532252: {
                return new Property("authoringTime", "dateTime", "Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).", 0, 1, this.authoringTime);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner|Device|Organization|Patient|RelatedPerson)", "Author of ImagingManifest. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.", 0, 1, this.author);
            }
            case -1724546052: {
                return new Property("description", "string", "Free text narrative description of the ImagingManifest.  \nThe value may be derived from the DICOM Standard Part 16, CID-7010 descriptions (e.g. Best in Set, Complete Study Content). Note that those values cover the wide range of uses of the DICOM Key Object Selection object, several of which are not supported by ImagingManifest. Specifically, there is no expected behavior associated with descriptions that suggest referenced images be removed or not used.", 0, 1, this.description);
            }
            case 109776329: {
                return new Property("study", "", "Study identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.study);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case -1724532252: {
                Base[] baseArray;
                if (this.authoringTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.authoringTime;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.author;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.description;
                }
                return baseArray;
            }
            case 109776329: {
                return this.study == null ? new Base[]{} : this.study.toArray(new Base[this.study.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case -1724532252: {
                this.authoringTime = this.castToDateTime(value);
                return value;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case 109776329: {
                this.getStudy().add((StudyComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("authoringTime")) {
            this.authoringTime = this.castToDateTime(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("study")) {
            this.getStudy().add((StudyComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1724532252: {
                return this.getAuthoringTimeElement();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 109776329: {
                return this.addStudy();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -1724532252: {
                return new String[]{"dateTime"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 109776329: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("authoringTime")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImagingManifest.authoringTime");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImagingManifest.description");
        }
        if (name.equals("study")) {
            return this.addStudy();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImagingManifest";
    }

    @Override
    public ImagingManifest copy() {
        ImagingManifest dst = new ImagingManifest();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.authoringTime = this.authoringTime == null ? null : this.authoringTime.copy();
        dst.author = this.author == null ? null : this.author.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.study != null) {
            dst.study = new ArrayList<StudyComponent>();
            for (StudyComponent i : this.study) {
                dst.study.add(i.copy());
            }
        }
        return dst;
    }

    protected ImagingManifest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingManifest)) {
            return false;
        }
        ImagingManifest o = (ImagingManifest)other_;
        return ImagingManifest.compareDeep(this.identifier, o.identifier, true) && ImagingManifest.compareDeep(this.patient, o.patient, true) && ImagingManifest.compareDeep(this.authoringTime, o.authoringTime, true) && ImagingManifest.compareDeep(this.author, o.author, true) && ImagingManifest.compareDeep(this.description, o.description, true) && ImagingManifest.compareDeep(this.study, o.study, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingManifest)) {
            return false;
        }
        ImagingManifest o = (ImagingManifest)other_;
        return ImagingManifest.compareValues(this.authoringTime, o.authoringTime, true) && ImagingManifest.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.patient, this.authoringTime, this.author, this.description, this.study});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingManifest;
    }

    @Block
    public static class InstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sopClass", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="SOP class UID of instance", formalDefinition="SOP class UID of the selected instance.")
        protected OidType sopClass;
        @Child(name="uid", type={OidType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Selected instance UID", formalDefinition="SOP Instance UID of the selected instance.")
        protected OidType uid;
        private static final long serialVersionUID = -885780004L;

        public InstanceComponent() {
        }

        public InstanceComponent(OidType sopClass, OidType uid) {
            this.sopClass = sopClass;
            this.uid = uid;
        }

        public OidType getSopClassElement() {
            if (this.sopClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.sopClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.sopClass = new OidType();
                }
            }
            return this.sopClass;
        }

        public boolean hasSopClassElement() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public boolean hasSopClass() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public InstanceComponent setSopClassElement(OidType value) {
            this.sopClass = value;
            return this;
        }

        public String getSopClass() {
            return this.sopClass == null ? null : (String)this.sopClass.getValue();
        }

        public InstanceComponent setSopClass(String value) {
            if (this.sopClass == null) {
                this.sopClass = new OidType();
            }
            this.sopClass.setValue(value);
            return this;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public InstanceComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public InstanceComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sopClass", "oid", "SOP class UID of the selected instance.", 0, 1, this.sopClass));
            children.add(new Property("uid", "oid", "SOP Instance UID of the selected instance.", 0, 1, this.uid));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1560041540: {
                    return new Property("sopClass", "oid", "SOP class UID of the selected instance.", 0, 1, this.sopClass);
                }
                case 115792: {
                    return new Property("uid", "oid", "SOP Instance UID of the selected instance.", 0, 1, this.uid);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    Base[] baseArray;
                    if (this.sopClass == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sopClass;
                    }
                    return baseArray;
                }
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uid;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    this.sopClass = this.castToOid(value);
                    return value;
                }
                case 115792: {
                    this.uid = this.castToOid(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sopClass")) {
                this.sopClass = this.castToOid(value);
            } else if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    return this.getSopClassElement();
                }
                case 115792: {
                    return this.getUidElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    return new String[]{"oid"};
                }
                case 115792: {
                    return new String[]{"oid"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sopClass")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingManifest.sopClass");
            }
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingManifest.uid");
            }
            return super.addChild(name);
        }

        @Override
        public InstanceComponent copy() {
            InstanceComponent dst = new InstanceComponent();
            this.copyValues(dst);
            dst.sopClass = this.sopClass == null ? null : this.sopClass.copy();
            dst.uid = this.uid == null ? null : this.uid.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InstanceComponent)) {
                return false;
            }
            InstanceComponent o = (InstanceComponent)other_;
            return InstanceComponent.compareDeep(this.sopClass, o.sopClass, true) && InstanceComponent.compareDeep(this.uid, o.uid, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InstanceComponent)) {
                return false;
            }
            InstanceComponent o = (InstanceComponent)other_;
            return InstanceComponent.compareValues(this.sopClass, o.sopClass, true) && InstanceComponent.compareValues(this.uid, o.uid, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sopClass, this.uid});
        }

        @Override
        public String fhirType() {
            return "ImagingManifest.study.series.instance";
        }
    }

    @Block
    public static class SeriesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Series instance UID", formalDefinition="Series instance UID of the SOP instances in the selection.")
        protected OidType uid;
        @Child(name="endpoint", type={Endpoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Series access endpoint", formalDefinition="The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.type.")
        protected List<Reference> endpoint;
        protected List<Endpoint> endpointTarget;
        @Child(name="instance", type={}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The selected instance", formalDefinition="Identity and locating information of the selected DICOM SOP instances.")
        protected List<InstanceComponent> instance;
        private static final long serialVersionUID = -1682136598L;

        public SeriesComponent() {
        }

        public SeriesComponent(OidType uid) {
            this.uid = uid;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SeriesComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public SeriesComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public SeriesComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public List<Reference> getEndpoint() {
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            return this.endpoint;
        }

        public SeriesComponent setEndpoint(List<Reference> theEndpoint) {
            this.endpoint = theEndpoint;
            return this;
        }

        public boolean hasEndpoint() {
            if (this.endpoint == null) {
                return false;
            }
            for (Reference item : this.endpoint) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEndpoint() {
            Reference t = new Reference();
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            this.endpoint.add(t);
            return t;
        }

        public SeriesComponent addEndpoint(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            this.endpoint.add(t);
            return this;
        }

        public Reference getEndpointFirstRep() {
            if (this.getEndpoint().isEmpty()) {
                this.addEndpoint();
            }
            return this.getEndpoint().get(0);
        }

        @Deprecated
        public List<Endpoint> getEndpointTarget() {
            if (this.endpointTarget == null) {
                this.endpointTarget = new ArrayList<Endpoint>();
            }
            return this.endpointTarget;
        }

        @Deprecated
        public Endpoint addEndpointTarget() {
            Endpoint r = new Endpoint();
            if (this.endpointTarget == null) {
                this.endpointTarget = new ArrayList<Endpoint>();
            }
            this.endpointTarget.add(r);
            return r;
        }

        public List<InstanceComponent> getInstance() {
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            return this.instance;
        }

        public SeriesComponent setInstance(List<InstanceComponent> theInstance) {
            this.instance = theInstance;
            return this;
        }

        public boolean hasInstance() {
            if (this.instance == null) {
                return false;
            }
            for (InstanceComponent item : this.instance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InstanceComponent addInstance() {
            InstanceComponent t = new InstanceComponent();
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            this.instance.add(t);
            return t;
        }

        public SeriesComponent addInstance(InstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            this.instance.add(t);
            return this;
        }

        public InstanceComponent getInstanceFirstRep() {
            if (this.getInstance().isEmpty()) {
                this.addInstance();
            }
            return this.getInstance().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uid", "oid", "Series instance UID of the SOP instances in the selection.", 0, 1, this.uid));
            children.add(new Property(ImagingManifest.SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.type.", 0, Integer.MAX_VALUE, this.endpoint));
            children.add(new Property("instance", "", "Identity and locating information of the selected DICOM SOP instances.", 0, Integer.MAX_VALUE, this.instance));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 115792: {
                    return new Property("uid", "oid", "Series instance UID of the SOP instances in the selection.", 0, 1, this.uid);
                }
                case 1741102485: {
                    return new Property(ImagingManifest.SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.type.", 0, Integer.MAX_VALUE, this.endpoint);
                }
                case 555127957: {
                    return new Property("instance", "", "Identity and locating information of the selected DICOM SOP instances.", 0, Integer.MAX_VALUE, this.instance);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case 1741102485: {
                    return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
                }
                case 555127957: {
                    return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    return value;
                }
                case 1741102485: {
                    this.getEndpoint().add(this.castToReference(value));
                    return value;
                }
                case 555127957: {
                    this.getInstance().add((InstanceComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals(ImagingManifest.SP_ENDPOINT)) {
                this.getEndpoint().add(this.castToReference(value));
            } else if (name.equals("instance")) {
                this.getInstance().add((InstanceComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return this.getUidElement();
                }
                case 1741102485: {
                    return this.addEndpoint();
                }
                case 555127957: {
                    return this.addInstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return new String[]{"oid"};
                }
                case 1741102485: {
                    return new String[]{"Reference"};
                }
                case 555127957: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingManifest.uid");
            }
            if (name.equals(ImagingManifest.SP_ENDPOINT)) {
                return this.addEndpoint();
            }
            if (name.equals("instance")) {
                return this.addInstance();
            }
            return super.addChild(name);
        }

        @Override
        public SeriesComponent copy() {
            SeriesComponent dst = new SeriesComponent();
            this.copyValues(dst);
            OidType oidType = dst.uid = this.uid == null ? null : this.uid.copy();
            if (this.endpoint != null) {
                dst.endpoint = new ArrayList<Reference>();
                for (Reference reference : this.endpoint) {
                    dst.endpoint.add(reference.copy());
                }
            }
            if (this.instance != null) {
                dst.instance = new ArrayList<InstanceComponent>();
                for (InstanceComponent instanceComponent : this.instance) {
                    dst.instance.add(instanceComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SeriesComponent)) {
                return false;
            }
            SeriesComponent o = (SeriesComponent)other_;
            return SeriesComponent.compareDeep(this.uid, o.uid, true) && SeriesComponent.compareDeep(this.endpoint, o.endpoint, true) && SeriesComponent.compareDeep(this.instance, o.instance, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SeriesComponent)) {
                return false;
            }
            SeriesComponent o = (SeriesComponent)other_;
            return SeriesComponent.compareValues(this.uid, o.uid, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uid, this.endpoint, this.instance});
        }

        @Override
        public String fhirType() {
            return "ImagingManifest.study.series";
        }
    }

    @Block
    public static class StudyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Study instance UID", formalDefinition="Study instance UID of the SOP instances in the selection.")
        protected OidType uid;
        @Child(name="imagingStudy", type={ImagingStudy.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to ImagingStudy", formalDefinition="Reference to the Imaging Study in FHIR form.")
        protected Reference imagingStudy;
        protected ImagingStudy imagingStudyTarget;
        @Child(name="endpoint", type={Endpoint.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Study access service endpoint", formalDefinition="The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.type.")
        protected List<Reference> endpoint;
        protected List<Endpoint> endpointTarget;
        @Child(name="series", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Series identity of the selected instances", formalDefinition="Series identity and locating information of the DICOM SOP instances in the selection.")
        protected List<SeriesComponent> series;
        private static final long serialVersionUID = -538170921L;

        public StudyComponent() {
        }

        public StudyComponent(OidType uid) {
            this.uid = uid;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public StudyComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public StudyComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public Reference getImagingStudy() {
            if (this.imagingStudy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.imagingStudy");
                }
                if (Configuration.doAutoCreate()) {
                    this.imagingStudy = new Reference();
                }
            }
            return this.imagingStudy;
        }

        public boolean hasImagingStudy() {
            return this.imagingStudy != null && !this.imagingStudy.isEmpty();
        }

        public StudyComponent setImagingStudy(Reference value) {
            this.imagingStudy = value;
            return this;
        }

        public ImagingStudy getImagingStudyTarget() {
            if (this.imagingStudyTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.imagingStudy");
                }
                if (Configuration.doAutoCreate()) {
                    this.imagingStudyTarget = new ImagingStudy();
                }
            }
            return this.imagingStudyTarget;
        }

        public StudyComponent setImagingStudyTarget(ImagingStudy value) {
            this.imagingStudyTarget = value;
            return this;
        }

        public List<Reference> getEndpoint() {
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            return this.endpoint;
        }

        public StudyComponent setEndpoint(List<Reference> theEndpoint) {
            this.endpoint = theEndpoint;
            return this;
        }

        public boolean hasEndpoint() {
            if (this.endpoint == null) {
                return false;
            }
            for (Reference item : this.endpoint) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEndpoint() {
            Reference t = new Reference();
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            this.endpoint.add(t);
            return t;
        }

        public StudyComponent addEndpoint(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            this.endpoint.add(t);
            return this;
        }

        public Reference getEndpointFirstRep() {
            if (this.getEndpoint().isEmpty()) {
                this.addEndpoint();
            }
            return this.getEndpoint().get(0);
        }

        @Deprecated
        public List<Endpoint> getEndpointTarget() {
            if (this.endpointTarget == null) {
                this.endpointTarget = new ArrayList<Endpoint>();
            }
            return this.endpointTarget;
        }

        @Deprecated
        public Endpoint addEndpointTarget() {
            Endpoint r = new Endpoint();
            if (this.endpointTarget == null) {
                this.endpointTarget = new ArrayList<Endpoint>();
            }
            this.endpointTarget.add(r);
            return r;
        }

        public List<SeriesComponent> getSeries() {
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            return this.series;
        }

        public StudyComponent setSeries(List<SeriesComponent> theSeries) {
            this.series = theSeries;
            return this;
        }

        public boolean hasSeries() {
            if (this.series == null) {
                return false;
            }
            for (SeriesComponent item : this.series) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SeriesComponent addSeries() {
            SeriesComponent t = new SeriesComponent();
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            this.series.add(t);
            return t;
        }

        public StudyComponent addSeries(SeriesComponent t) {
            if (t == null) {
                return this;
            }
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            this.series.add(t);
            return this;
        }

        public SeriesComponent getSeriesFirstRep() {
            if (this.getSeries().isEmpty()) {
                this.addSeries();
            }
            return this.getSeries().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uid", "oid", "Study instance UID of the SOP instances in the selection.", 0, 1, this.uid));
            children.add(new Property("imagingStudy", "Reference(ImagingStudy)", "Reference to the Imaging Study in FHIR form.", 0, 1, this.imagingStudy));
            children.add(new Property(ImagingManifest.SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.type.", 0, Integer.MAX_VALUE, this.endpoint));
            children.add(new Property("series", "", "Series identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.series));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 115792: {
                    return new Property("uid", "oid", "Study instance UID of the SOP instances in the selection.", 0, 1, this.uid);
                }
                case -814900911: {
                    return new Property("imagingStudy", "Reference(ImagingStudy)", "Reference to the Imaging Study in FHIR form.", 0, 1, this.imagingStudy);
                }
                case 1741102485: {
                    return new Property(ImagingManifest.SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.type.", 0, Integer.MAX_VALUE, this.endpoint);
                }
                case -905838985: {
                    return new Property("series", "", "Series identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.series);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case -814900911: {
                    Base[] baseArray;
                    if (this.imagingStudy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.imagingStudy;
                    }
                    return baseArray;
                }
                case 1741102485: {
                    return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
                }
                case -905838985: {
                    return this.series == null ? new Base[]{} : this.series.toArray(new Base[this.series.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    return value;
                }
                case -814900911: {
                    this.imagingStudy = this.castToReference(value);
                    return value;
                }
                case 1741102485: {
                    this.getEndpoint().add(this.castToReference(value));
                    return value;
                }
                case -905838985: {
                    this.getSeries().add((SeriesComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("imagingStudy")) {
                this.imagingStudy = this.castToReference(value);
            } else if (name.equals(ImagingManifest.SP_ENDPOINT)) {
                this.getEndpoint().add(this.castToReference(value));
            } else if (name.equals("series")) {
                this.getSeries().add((SeriesComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return this.getUidElement();
                }
                case -814900911: {
                    return this.getImagingStudy();
                }
                case 1741102485: {
                    return this.addEndpoint();
                }
                case -905838985: {
                    return this.addSeries();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return new String[]{"oid"};
                }
                case -814900911: {
                    return new String[]{"Reference"};
                }
                case 1741102485: {
                    return new String[]{"Reference"};
                }
                case -905838985: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingManifest.uid");
            }
            if (name.equals("imagingStudy")) {
                this.imagingStudy = new Reference();
                return this.imagingStudy;
            }
            if (name.equals(ImagingManifest.SP_ENDPOINT)) {
                return this.addEndpoint();
            }
            if (name.equals("series")) {
                return this.addSeries();
            }
            return super.addChild(name);
        }

        @Override
        public StudyComponent copy() {
            StudyComponent dst = new StudyComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            Reference reference = dst.imagingStudy = this.imagingStudy == null ? null : this.imagingStudy.copy();
            if (this.endpoint != null) {
                dst.endpoint = new ArrayList<Reference>();
                for (Reference reference2 : this.endpoint) {
                    dst.endpoint.add(reference2.copy());
                }
            }
            if (this.series != null) {
                dst.series = new ArrayList<SeriesComponent>();
                for (SeriesComponent seriesComponent : this.series) {
                    dst.series.add(seriesComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StudyComponent)) {
                return false;
            }
            StudyComponent o = (StudyComponent)other_;
            return StudyComponent.compareDeep(this.uid, o.uid, true) && StudyComponent.compareDeep(this.imagingStudy, o.imagingStudy, true) && StudyComponent.compareDeep(this.endpoint, o.endpoint, true) && StudyComponent.compareDeep(this.series, o.series, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StudyComponent)) {
                return false;
            }
            StudyComponent o = (StudyComponent)other_;
            return StudyComponent.compareValues(this.uid, o.uid, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uid, this.imagingStudy, this.endpoint, this.series});
        }

        @Override
        public String fhirType() {
            return "ImagingManifest.study";
        }
    }
}

