/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum LOINC480020Answerlist {
    LA66832,
    LA66840,
    LA104291,
    LA181943,
    LA181950,
    LA181968,
    LA181976,
    NULL;


    public static LOINC480020Answerlist fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("LA6683-2".equals(codeString)) {
            return LA66832;
        }
        if ("LA6684-0".equals(codeString)) {
            return LA66840;
        }
        if ("LA10429-1".equals(codeString)) {
            return LA104291;
        }
        if ("LA18194-3".equals(codeString)) {
            return LA181943;
        }
        if ("LA18195-0".equals(codeString)) {
            return LA181950;
        }
        if ("LA18196-8".equals(codeString)) {
            return LA181968;
        }
        if ("LA18197-6".equals(codeString)) {
            return LA181976;
        }
        throw new FHIRException("Unknown LOINC480020Answerlist code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LA66832: {
                return "LA6683-2";
            }
            case LA66840: {
                return "LA6684-0";
            }
            case LA104291: {
                return "LA10429-1";
            }
            case LA181943: {
                return "LA18194-3";
            }
            case LA181950: {
                return "LA18195-0";
            }
            case LA181968: {
                return "LA18196-8";
            }
            case LA181976: {
                return "LA18197-6";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/LOINC-48002-0-answerlist";
    }

    public String getDefinition() {
        switch (this) {
            case LA66832: {
                return "Germline";
            }
            case LA66840: {
                return "Somatic";
            }
            case LA104291: {
                return "Prenatal";
            }
            case LA181943: {
                return "Likely Germline";
            }
            case LA181950: {
                return "Likely Somatic";
            }
            case LA181968: {
                return "Likely Prenatal";
            }
            case LA181976: {
                return "Unknown Genomic Origin";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LA66832: {
                return "Germline";
            }
            case LA66840: {
                return "Somatic";
            }
            case LA104291: {
                return "Prenatal";
            }
            case LA181943: {
                return "Likely Germline";
            }
            case LA181950: {
                return "Likely Somatic";
            }
            case LA181968: {
                return "Likely Prenatal";
            }
            case LA181976: {
                return "Unknown Genomic Origin";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

