/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.MessageEvents;

public class MessageEventsEnumFactory
implements EnumFactory<MessageEvents> {
    @Override
    public MessageEvents fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("CodeSystem-expand".equals(codeString)) {
            return MessageEvents.CODESYSTEMEXPAND;
        }
        if ("MedicationAdministration-Complete".equals(codeString)) {
            return MessageEvents.MEDICATIONADMINISTRATIONCOMPLETE;
        }
        if ("MedicationAdministration-Nullification".equals(codeString)) {
            return MessageEvents.MEDICATIONADMINISTRATIONNULLIFICATION;
        }
        if ("MedicationAdministration-Recording".equals(codeString)) {
            return MessageEvents.MEDICATIONADMINISTRATIONRECORDING;
        }
        if ("MedicationAdministration-Update".equals(codeString)) {
            return MessageEvents.MEDICATIONADMINISTRATIONUPDATE;
        }
        if ("admin-notify".equals(codeString)) {
            return MessageEvents.ADMINNOTIFY;
        }
        if ("communication-request".equals(codeString)) {
            return MessageEvents.COMMUNICATIONREQUEST;
        }
        if ("diagnosticreport-provide".equals(codeString)) {
            return MessageEvents.DIAGNOSTICREPORTPROVIDE;
        }
        if ("observation-provide".equals(codeString)) {
            return MessageEvents.OBSERVATIONPROVIDE;
        }
        if ("patient-link".equals(codeString)) {
            return MessageEvents.PATIENTLINK;
        }
        if ("patient-unlink".equals(codeString)) {
            return MessageEvents.PATIENTUNLINK;
        }
        if ("valueset-expand".equals(codeString)) {
            return MessageEvents.VALUESETEXPAND;
        }
        throw new IllegalArgumentException("Unknown MessageEvents code '" + codeString + "'");
    }

    @Override
    public String toCode(MessageEvents code) {
        if (code == MessageEvents.CODESYSTEMEXPAND) {
            return "CodeSystem-expand";
        }
        if (code == MessageEvents.MEDICATIONADMINISTRATIONCOMPLETE) {
            return "MedicationAdministration-Complete";
        }
        if (code == MessageEvents.MEDICATIONADMINISTRATIONNULLIFICATION) {
            return "MedicationAdministration-Nullification";
        }
        if (code == MessageEvents.MEDICATIONADMINISTRATIONRECORDING) {
            return "MedicationAdministration-Recording";
        }
        if (code == MessageEvents.MEDICATIONADMINISTRATIONUPDATE) {
            return "MedicationAdministration-Update";
        }
        if (code == MessageEvents.ADMINNOTIFY) {
            return "admin-notify";
        }
        if (code == MessageEvents.COMMUNICATIONREQUEST) {
            return "communication-request";
        }
        if (code == MessageEvents.DIAGNOSTICREPORTPROVIDE) {
            return "diagnosticreport-provide";
        }
        if (code == MessageEvents.OBSERVATIONPROVIDE) {
            return "observation-provide";
        }
        if (code == MessageEvents.PATIENTLINK) {
            return "patient-link";
        }
        if (code == MessageEvents.PATIENTUNLINK) {
            return "patient-unlink";
        }
        if (code == MessageEvents.VALUESETEXPAND) {
            return "valueset-expand";
        }
        return "?";
    }

    @Override
    public String toSystem(MessageEvents code) {
        return code.getSystem();
    }
}

