/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProcessresponseStatus {
    ACTIVE,
    CANCELLED,
    DRAFT,
    ENTEREDINERROR,
    NULL;


    public static ProcessresponseStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown ProcessresponseStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case DRAFT: {
                return "draft";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/processresponse-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The resource instance is currently in-force.";
            }
            case CANCELLED: {
                return "The resource instance is withdrawn, rescinded or reversed.";
            }
            case DRAFT: {
                return "A new resource instance the contents of which is not complete.";
            }
            case ENTEREDINERROR: {
                return "The resource instance was entered in error.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case DRAFT: {
                return "Draft";
            }
            case ENTEREDINERROR: {
                return "Entered In Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

