/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationAdministration", profile="http://hl7.org/fhir/Profile/MedicationAdministration")
public class MedicationAdministration
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External identifier", formalDefinition="External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.")
    protected List<Identifier> identifier;
    @Child(name="definition", type={PlanDefinition.class, ActivityDefinition.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates protocol or definition", formalDefinition="A protocol, guideline, orderset or other definition that was adhered to in whole or in part by this event.")
    protected List<Reference> definition;
    protected List<Resource> definitionTarget;
    @Child(name="partOf", type={MedicationAdministration.class, Procedure.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    protected List<Resource> partOfTarget;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | on-hold | completed | entered-in-error | stopped | unknown", formalDefinition="Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions it is possible for an administration to be started but not completed or it may be paused while some other process is under way.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-admin-status")
    protected Enumeration<MedicationAdministrationStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of medication usage", formalDefinition="Indicates the type of medication administration and where the medication is expected to be consumed or administered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-admin-category")
    protected CodeableConcept category;
    @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What was administered", formalDefinition="Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected Type medication;
    @Child(name="subject", type={Patient.class, Group.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who received medication", formalDefinition="The person or animal or group receiving the medication.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter or Episode of Care administered as part of", formalDefinition="The visit, admission or other contact between patient and health care provider the medication administration was performed as part of.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="supportingInformation", type={Reference.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information to support administration", formalDefinition="Additional information (for example, patient height and weight) that supports the administration of the medication.")
    protected List<Reference> supportingInformation;
    protected List<Resource> supportingInformationTarget;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end time of administration", formalDefinition="A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.")
    protected Type effective;
    @Child(name="performer", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who administered substance", formalDefinition="The individual who was responsible for giving the medication to the patient.")
    protected List<MedicationAdministrationPerformerComponent> performer;
    @Child(name="notGiven", type={BooleanType.class}, order=11, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if medication not administered", formalDefinition="Set this to true if the record is saying that the medication was NOT administered.")
    protected BooleanType notGiven;
    @Child(name="reasonNotGiven", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason administration not performed", formalDefinition="A code indicating why the administration was not performed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/reason-medication-not-given-codes")
    protected List<CodeableConcept> reasonNotGiven;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason administration performed", formalDefinition="A code indicating why the medication was given.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/reason-medication-given-codes")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Condition or Observation that supports why the medication was administered", formalDefinition="Condition or observation that supports why the medication was administered.")
    protected List<Reference> reasonReference;
    protected List<Resource> reasonReferenceTarget;
    @Child(name="prescription", type={MedicationRequest.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Request administration performed against", formalDefinition="The original request, instruction or authority to perform the administration.")
    protected Reference prescription;
    protected MedicationRequest prescriptionTarget;
    @Child(name="device", type={Device.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device used to administer", formalDefinition="The device used in administering the medication to the patient.  For example, a particular infusion pump.")
    protected List<Reference> device;
    protected List<Device> deviceTarget;
    @Child(name="note", type={Annotation.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the administration", formalDefinition="Extra information about the medication administration that is not conveyed by the other attributes.")
    protected List<Annotation> note;
    @Child(name="dosage", type={}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details of how medication was taken", formalDefinition="Describes the medication dosage information details e.g. dose, rate, site, route, etc.")
    protected MedicationAdministrationDosageComponent dosage;
    @Child(name="eventHistory", type={Provenance.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of events of interest in the lifecycle", formalDefinition="A summary of the events of interest that have occurred, such as when the administration was verified.")
    protected List<Reference> eventHistory;
    protected List<Provenance> eventHistoryTarget;
    private static final long serialVersionUID = 673777544L;
    @SearchParamDefinition(name="identifier", path="MedicationAdministration.identifier", description="Return administrations with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="code", path="MedicationAdministration.medication.as(CodeableConcept)", description="Return administrations of this medication code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="performer", path="MedicationAdministration.performer.actor", description="The identify of the individual who administered the medication", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("MedicationAdministration:performer").toLocked();
    @SearchParamDefinition(name="subject", path="MedicationAdministration.subject", description="The identify of the individual or group to list administrations for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicationAdministration:subject").toLocked();
    @SearchParamDefinition(name="not-given", path="MedicationAdministration.notGiven", description="Administrations that were not made", type="token")
    public static final String SP_NOT_GIVEN = "not-given";
    public static final TokenClientParam NOT_GIVEN = new TokenClientParam("not-given");
    @SearchParamDefinition(name="medication", path="MedicationAdministration.medication.as(Reference)", description="Return administrations of this medication resource", type="reference", target={Medication.class})
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationAdministration:medication").toLocked();
    @SearchParamDefinition(name="reason-given", path="MedicationAdministration.reasonCode", description="Reasons for administering the medication", type="token")
    public static final String SP_REASON_GIVEN = "reason-given";
    public static final TokenClientParam REASON_GIVEN = new TokenClientParam("reason-given");
    @SearchParamDefinition(name="prescription", path="MedicationAdministration.prescription", description="The identity of a prescription to list administrations from", type="reference", target={MedicationRequest.class})
    public static final String SP_PRESCRIPTION = "prescription";
    public static final ReferenceClientParam PRESCRIPTION = new ReferenceClientParam("prescription");
    public static final Include INCLUDE_PRESCRIPTION = new Include("MedicationAdministration:prescription").toLocked();
    @SearchParamDefinition(name="patient", path="MedicationAdministration.subject", description="The identity of a patient to list administrations  for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationAdministration:patient").toLocked();
    @SearchParamDefinition(name="effective-time", path="MedicationAdministration.effective", description="Date administration happened (or did not happen)", type="date")
    public static final String SP_EFFECTIVE_TIME = "effective-time";
    public static final DateClientParam EFFECTIVE_TIME = new DateClientParam("effective-time");
    @SearchParamDefinition(name="context", path="MedicationAdministration.context", description="Return administrations that share this encounter or episode of care", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("MedicationAdministration:context").toLocked();
    @SearchParamDefinition(name="reason-not-given", path="MedicationAdministration.reasonNotGiven", description="Reasons for not administering the medication", type="token")
    public static final String SP_REASON_NOT_GIVEN = "reason-not-given";
    public static final TokenClientParam REASON_NOT_GIVEN = new TokenClientParam("reason-not-given");
    @SearchParamDefinition(name="device", path="MedicationAdministration.device", description="Return administrations with this administration device identity", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("MedicationAdministration:device").toLocked();
    @SearchParamDefinition(name="status", path="MedicationAdministration.status", description="MedicationAdministration event status (for example one of active/paused/completed/nullified)", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public MedicationAdministration() {
    }

    public MedicationAdministration(Enumeration<MedicationAdministrationStatus> status, Type medication, Reference subject, Type effective) {
        this.status = status;
        this.medication = medication;
        this.subject = subject;
        this.effective = effective;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationAdministration setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationAdministration addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        return this.definition;
    }

    public MedicationAdministration setDefinition(List<Reference> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (Reference item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDefinition() {
        Reference t = new Reference();
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return t;
    }

    public MedicationAdministration addDefinition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return this;
    }

    public Reference getDefinitionFirstRep() {
        if (this.getDefinition().isEmpty()) {
            this.addDefinition();
        }
        return this.getDefinition().get(0);
    }

    @Deprecated
    public List<Resource> getDefinitionTarget() {
        if (this.definitionTarget == null) {
            this.definitionTarget = new ArrayList<Resource>();
        }
        return this.definitionTarget;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public MedicationAdministration setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public MedicationAdministration addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    @Deprecated
    public List<Resource> getPartOfTarget() {
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<Resource>();
        }
        return this.partOfTarget;
    }

    public Enumeration<MedicationAdministrationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationAdministrationStatus>(new MedicationAdministrationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationAdministration setStatusElement(Enumeration<MedicationAdministrationStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationAdministrationStatus getStatus() {
        return this.status == null ? null : (MedicationAdministrationStatus)((Object)this.status.getValue());
    }

    public MedicationAdministration setStatus(MedicationAdministrationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<MedicationAdministrationStatus>(new MedicationAdministrationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public MedicationAdministration setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Type getMedication() {
        return this.medication;
    }

    public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
        if (this.medication == null) {
            return null;
        }
        if (!(this.medication instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.medication;
    }

    public boolean hasMedicationCodeableConcept() {
        return this != null && this.medication instanceof CodeableConcept;
    }

    public Reference getMedicationReference() throws FHIRException {
        if (this.medication == null) {
            return null;
        }
        if (!(this.medication instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (Reference)this.medication;
    }

    public boolean hasMedicationReference() {
        return this != null && this.medication instanceof Reference;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationAdministration setMedication(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for MedicationAdministration.medication[x]: " + value.fhirType());
        }
        this.medication = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MedicationAdministration setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public MedicationAdministration setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public MedicationAdministration setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public MedicationAdministration setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public MedicationAdministration setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public MedicationAdministration addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    @Deprecated
    public List<Resource> getSupportingInformationTarget() {
        if (this.supportingInformationTarget == null) {
            this.supportingInformationTarget = new ArrayList<Resource>();
        }
        return this.supportingInformationTarget;
    }

    public Type getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            return null;
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            return null;
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public MedicationAdministration setEffective(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new FHIRFormatError("Not the right type for MedicationAdministration.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public List<MedicationAdministrationPerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
        }
        return this.performer;
    }

    public MedicationAdministration setPerformer(List<MedicationAdministrationPerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (MedicationAdministrationPerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationAdministrationPerformerComponent addPerformer() {
        MedicationAdministrationPerformerComponent t = new MedicationAdministrationPerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public MedicationAdministration addPerformer(MedicationAdministrationPerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public MedicationAdministrationPerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public BooleanType getNotGivenElement() {
        if (this.notGiven == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.notGiven");
            }
            if (Configuration.doAutoCreate()) {
                this.notGiven = new BooleanType();
            }
        }
        return this.notGiven;
    }

    public boolean hasNotGivenElement() {
        return this.notGiven != null && !this.notGiven.isEmpty();
    }

    public boolean hasNotGiven() {
        return this.notGiven != null && !this.notGiven.isEmpty();
    }

    public MedicationAdministration setNotGivenElement(BooleanType value) {
        this.notGiven = value;
        return this;
    }

    public boolean getNotGiven() {
        return this.notGiven == null || this.notGiven.isEmpty() ? false : (Boolean)this.notGiven.getValue();
    }

    public MedicationAdministration setNotGiven(boolean value) {
        if (this.notGiven == null) {
            this.notGiven = new BooleanType();
        }
        this.notGiven.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getReasonNotGiven() {
        if (this.reasonNotGiven == null) {
            this.reasonNotGiven = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotGiven;
    }

    public MedicationAdministration setReasonNotGiven(List<CodeableConcept> theReasonNotGiven) {
        this.reasonNotGiven = theReasonNotGiven;
        return this;
    }

    public boolean hasReasonNotGiven() {
        if (this.reasonNotGiven == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonNotGiven) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonNotGiven() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonNotGiven == null) {
            this.reasonNotGiven = new ArrayList<CodeableConcept>();
        }
        this.reasonNotGiven.add(t);
        return t;
    }

    public MedicationAdministration addReasonNotGiven(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonNotGiven == null) {
            this.reasonNotGiven = new ArrayList<CodeableConcept>();
        }
        this.reasonNotGiven.add(t);
        return this;
    }

    public CodeableConcept getReasonNotGivenFirstRep() {
        if (this.getReasonNotGiven().isEmpty()) {
            this.addReasonNotGiven();
        }
        return this.getReasonNotGiven().get(0);
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public MedicationAdministration setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public MedicationAdministration addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public MedicationAdministration setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public MedicationAdministration addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    @Deprecated
    public List<Resource> getReasonReferenceTarget() {
        if (this.reasonReferenceTarget == null) {
            this.reasonReferenceTarget = new ArrayList<Resource>();
        }
        return this.reasonReferenceTarget;
    }

    public Reference getPrescription() {
        if (this.prescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.prescription");
            }
            if (Configuration.doAutoCreate()) {
                this.prescription = new Reference();
            }
        }
        return this.prescription;
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    public MedicationAdministration setPrescription(Reference value) {
        this.prescription = value;
        return this;
    }

    public MedicationRequest getPrescriptionTarget() {
        if (this.prescriptionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.prescription");
            }
            if (Configuration.doAutoCreate()) {
                this.prescriptionTarget = new MedicationRequest();
            }
        }
        return this.prescriptionTarget;
    }

    public MedicationAdministration setPrescriptionTarget(MedicationRequest value) {
        this.prescriptionTarget = value;
        return this;
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public MedicationAdministration setDevice(List<Reference> theDevice) {
        this.device = theDevice;
        return this;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (Reference item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDevice() {
        Reference t = new Reference();
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return t;
    }

    public MedicationAdministration addDevice(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return this;
    }

    public Reference getDeviceFirstRep() {
        if (this.getDevice().isEmpty()) {
            this.addDevice();
        }
        return this.getDevice().get(0);
    }

    @Deprecated
    public List<Device> getDeviceTarget() {
        if (this.deviceTarget == null) {
            this.deviceTarget = new ArrayList<Device>();
        }
        return this.deviceTarget;
    }

    @Deprecated
    public Device addDeviceTarget() {
        Device r = new Device();
        if (this.deviceTarget == null) {
            this.deviceTarget = new ArrayList<Device>();
        }
        this.deviceTarget.add(r);
        return r;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public MedicationAdministration setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public MedicationAdministration addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public MedicationAdministrationDosageComponent getDosage() {
        if (this.dosage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.dosage");
            }
            if (Configuration.doAutoCreate()) {
                this.dosage = new MedicationAdministrationDosageComponent();
            }
        }
        return this.dosage;
    }

    public boolean hasDosage() {
        return this.dosage != null && !this.dosage.isEmpty();
    }

    public MedicationAdministration setDosage(MedicationAdministrationDosageComponent value) {
        this.dosage = value;
        return this;
    }

    public List<Reference> getEventHistory() {
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        return this.eventHistory;
    }

    public MedicationAdministration setEventHistory(List<Reference> theEventHistory) {
        this.eventHistory = theEventHistory;
        return this;
    }

    public boolean hasEventHistory() {
        if (this.eventHistory == null) {
            return false;
        }
        for (Reference item : this.eventHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEventHistory() {
        Reference t = new Reference();
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return t;
    }

    public MedicationAdministration addEventHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return this;
    }

    public Reference getEventHistoryFirstRep() {
        if (this.getEventHistory().isEmpty()) {
            this.addEventHistory();
        }
        return this.getEventHistory().get(0);
    }

    @Deprecated
    public List<Provenance> getEventHistoryTarget() {
        if (this.eventHistoryTarget == null) {
            this.eventHistoryTarget = new ArrayList<Provenance>();
        }
        return this.eventHistoryTarget;
    }

    @Deprecated
    public Provenance addEventHistoryTarget() {
        Provenance r = new Provenance();
        if (this.eventHistoryTarget == null) {
            this.eventHistoryTarget = new ArrayList<Provenance>();
        }
        this.eventHistoryTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("definition", "Reference(PlanDefinition|ActivityDefinition)", "A protocol, guideline, orderset or other definition that was adhered to in whole or in part by this event.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("partOf", "Reference(MedicationAdministration|Procedure)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions it is possible for an administration to be started but not completed or it may be paused while some other process is under way.", 0, 1, this.status));
        children.add(new Property("category", "CodeableConcept", "Indicates the type of medication administration and where the medication is expected to be consumed or administered.", 0, 1, this.category));
        children.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person or animal or group receiving the medication.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The visit, admission or other contact between patient and health care provider the medication administration was performed as part of.", 0, 1, this.context));
        children.add(new Property("supportingInformation", "Reference(Any)", "Additional information (for example, patient height and weight) that supports the administration of the medication.", 0, Integer.MAX_VALUE, this.supportingInformation));
        children.add(new Property("effective[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective));
        children.add(new Property(SP_PERFORMER, "", "The individual who was responsible for giving the medication to the patient.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("notGiven", "boolean", "Set this to true if the record is saying that the medication was NOT administered.", 0, 1, this.notGiven));
        children.add(new Property("reasonNotGiven", "CodeableConcept", "A code indicating why the administration was not performed.", 0, Integer.MAX_VALUE, this.reasonNotGiven));
        children.add(new Property("reasonCode", "CodeableConcept", "A code indicating why the medication was given.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation)", "Condition or observation that supports why the medication was administered.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property(SP_PRESCRIPTION, "Reference(MedicationRequest)", "The original request, instruction or authority to perform the administration.", 0, 1, this.prescription));
        children.add(new Property(SP_DEVICE, "Reference(Device)", "The device used in administering the medication to the patient.  For example, a particular infusion pump.", 0, Integer.MAX_VALUE, this.device));
        children.add(new Property("note", "Annotation", "Extra information about the medication administration that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("dosage", "", "Describes the medication dosage information details e.g. dose, rate, site, route, etc.", 0, 1, this.dosage));
        children.add(new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the administration was verified.", 0, Integer.MAX_VALUE, this.eventHistory));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1014418093: {
                return new Property("definition", "Reference(PlanDefinition|ActivityDefinition)", "A protocol, guideline, orderset or other definition that was adhered to in whole or in part by this event.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -995410646: {
                return new Property("partOf", "Reference(MedicationAdministration|Procedure)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions it is possible for an administration to be started but not completed or it may be paused while some other process is under way.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Indicates the type of medication administration and where the medication is expected to be consumed or administered.", 0, 1, this.category);
            }
            case 1458402129: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 1998965455: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -209845038: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 2104315196: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person or animal or group receiving the medication.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The visit, admission or other contact between patient and health care provider the medication administration was performed as part of.", 0, 1, this.context);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Additional information (for example, patient height and weight) that supports the administration of the medication.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "", "The individual who was responsible for giving the medication to the patient.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1554065514: {
                return new Property("notGiven", "boolean", "Set this to true if the record is saying that the medication was NOT administered.", 0, 1, this.notGiven);
            }
            case 2101123790: {
                return new Property("reasonNotGiven", "CodeableConcept", "A code indicating why the administration was not performed.", 0, Integer.MAX_VALUE, this.reasonNotGiven);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "A code indicating why the medication was given.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation)", "Condition or observation that supports why the medication was administered.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case 460301338: {
                return new Property(SP_PRESCRIPTION, "Reference(MedicationRequest)", "The original request, instruction or authority to perform the administration.", 0, 1, this.prescription);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "Reference(Device)", "The device used in administering the medication to the patient.  For example, a particular infusion pump.", 0, Integer.MAX_VALUE, this.device);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Extra information about the medication administration that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1326018889: {
                return new Property("dosage", "", "Describes the medication dosage information details e.g. dose, rate, site, route, etc.", 0, 1, this.dosage);
            }
            case 1835190426: {
                return new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the administration was verified.", 0, Integer.MAX_VALUE, this.eventHistory);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.category;
                }
                return baseArray;
            }
            case 1998965455: {
                Base[] baseArray;
                if (this.medication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.medication;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.context;
                }
                return baseArray;
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.effective;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1554065514: {
                Base[] baseArray;
                if (this.notGiven == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.notGiven;
                }
                return baseArray;
            }
            case 2101123790: {
                return this.reasonNotGiven == null ? new Base[]{} : this.reasonNotGiven.toArray(new Base[this.reasonNotGiven.size()]);
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case 460301338: {
                Base[] baseArray;
                if (this.prescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.prescription;
                }
                return baseArray;
            }
            case -1335157162: {
                return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1326018889: {
                Base[] baseArray;
                if (this.dosage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.dosage;
                }
                return baseArray;
            }
            case 1835190426: {
                return this.eventHistory == null ? new Base[]{} : this.eventHistory.toArray(new Base[this.eventHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new MedicationAdministrationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                return value;
            }
            case 1998965455: {
                this.medication = this.castToType(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(this.castToReference(value));
                return value;
            }
            case -1468651097: {
                this.effective = this.castToType(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((MedicationAdministrationPerformerComponent)((Object)value));
                return value;
            }
            case 1554065514: {
                this.notGiven = this.castToBoolean(value);
                return value;
            }
            case 2101123790: {
                this.getReasonNotGiven().add(this.castToCodeableConcept(value));
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case 460301338: {
                this.prescription = this.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.getDevice().add(this.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -1326018889: {
                this.dosage = (MedicationAdministrationDosageComponent)((Object)value);
                return value;
            }
            case 1835190426: {
                this.getEventHistory().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("definition")) {
            this.getDefinition().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationAdministrationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("category")) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals("medication[x]")) {
            this.medication = this.castToType(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(this.castToReference(value));
        } else if (name.equals("effective[x]")) {
            this.effective = this.castToType(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((MedicationAdministrationPerformerComponent)((Object)value));
        } else if (name.equals("notGiven")) {
            this.notGiven = this.castToBoolean(value);
        } else if (name.equals("reasonNotGiven")) {
            this.getReasonNotGiven().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals(SP_PRESCRIPTION)) {
            this.prescription = this.castToReference(value);
        } else if (name.equals(SP_DEVICE)) {
            this.getDevice().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("dosage")) {
            this.dosage = (MedicationAdministrationDosageComponent)((Object)value);
        } else if (name.equals("eventHistory")) {
            this.getEventHistory().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1014418093: {
                return this.addDefinition();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 1458402129: {
                return this.getMedication();
            }
            case 1998965455: {
                return this.getMedication();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1554065514: {
                return this.getNotGivenElement();
            }
            case 2101123790: {
                return this.addReasonNotGiven();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case 460301338: {
                return this.getPrescription();
            }
            case -1335157162: {
                return this.addDevice();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1326018889: {
                return this.getDosage();
            }
            case 1835190426: {
                return this.addEventHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 1998965455: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case 481140686: {
                return new String[0];
            }
            case 1554065514: {
                return new String[]{"boolean"};
            }
            case 2101123790: {
                return new String[]{"CodeableConcept"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case 460301338: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1326018889: {
                return new String[0];
            }
            case 1835190426: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("definition")) {
            return this.addDefinition();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationAdministration.status");
        }
        if (name.equals("category")) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("medicationCodeableConcept")) {
            this.medication = new CodeableConcept();
            return this.medication;
        }
        if (name.equals("medicationReference")) {
            this.medication = new Reference();
            return this.medication;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("notGiven")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationAdministration.notGiven");
        }
        if (name.equals("reasonNotGiven")) {
            return this.addReasonNotGiven();
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals(SP_PRESCRIPTION)) {
            this.prescription = new Reference();
            return this.prescription;
        }
        if (name.equals(SP_DEVICE)) {
            return this.addDevice();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("dosage")) {
            this.dosage = new MedicationAdministrationDosageComponent();
            return this.dosage;
        }
        if (name.equals("eventHistory")) {
            return this.addEventHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationAdministration";
    }

    @Override
    public MedicationAdministration copy() {
        MedicationAdministration dst = new MedicationAdministration();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.definition != null) {
            dst.definition = new ArrayList<Reference>();
            for (Reference reference : this.definition) {
                dst.definition.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.medication = this.medication == null ? null : this.medication.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        Reference reference = dst.context = this.context == null ? null : this.context.copy();
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference2 : this.supportingInformation) {
                dst.supportingInformation.add(reference2.copy());
            }
        }
        Type type = dst.effective = this.effective == null ? null : this.effective.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
            for (MedicationAdministrationPerformerComponent medicationAdministrationPerformerComponent : this.performer) {
                dst.performer.add(medicationAdministrationPerformerComponent.copy());
            }
        }
        BooleanType booleanType = dst.notGiven = this.notGiven == null ? null : this.notGiven.copy();
        if (this.reasonNotGiven != null) {
            dst.reasonNotGiven = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonNotGiven) {
                dst.reasonNotGiven.add(codeableConcept.copy());
            }
        }
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference3 : this.reasonReference) {
                dst.reasonReference.add(reference3.copy());
            }
        }
        Reference reference4 = dst.prescription = this.prescription == null ? null : this.prescription.copy();
        if (this.device != null) {
            dst.device = new ArrayList<Reference>();
            for (Reference reference5 : this.device) {
                dst.device.add(reference5.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        MedicationAdministrationDosageComponent medicationAdministrationDosageComponent = dst.dosage = this.dosage == null ? null : this.dosage.copy();
        if (this.eventHistory != null) {
            dst.eventHistory = new ArrayList<Reference>();
            for (Reference reference6 : this.eventHistory) {
                dst.eventHistory.add(reference6.copy());
            }
        }
        return dst;
    }

    protected MedicationAdministration typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationAdministration)) {
            return false;
        }
        MedicationAdministration o = (MedicationAdministration)other_;
        return MedicationAdministration.compareDeep(this.identifier, o.identifier, true) && MedicationAdministration.compareDeep(this.definition, o.definition, true) && MedicationAdministration.compareDeep(this.partOf, o.partOf, true) && MedicationAdministration.compareDeep(this.status, o.status, true) && MedicationAdministration.compareDeep(this.category, o.category, true) && MedicationAdministration.compareDeep(this.medication, o.medication, true) && MedicationAdministration.compareDeep(this.subject, o.subject, true) && MedicationAdministration.compareDeep(this.context, o.context, true) && MedicationAdministration.compareDeep(this.supportingInformation, o.supportingInformation, true) && MedicationAdministration.compareDeep(this.effective, o.effective, true) && MedicationAdministration.compareDeep(this.performer, o.performer, true) && MedicationAdministration.compareDeep(this.notGiven, o.notGiven, true) && MedicationAdministration.compareDeep(this.reasonNotGiven, o.reasonNotGiven, true) && MedicationAdministration.compareDeep(this.reasonCode, o.reasonCode, true) && MedicationAdministration.compareDeep(this.reasonReference, o.reasonReference, true) && MedicationAdministration.compareDeep(this.prescription, o.prescription, true) && MedicationAdministration.compareDeep(this.device, o.device, true) && MedicationAdministration.compareDeep(this.note, o.note, true) && MedicationAdministration.compareDeep(this.dosage, o.dosage, true) && MedicationAdministration.compareDeep(this.eventHistory, o.eventHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationAdministration)) {
            return false;
        }
        MedicationAdministration o = (MedicationAdministration)other_;
        return MedicationAdministration.compareValues(this.status, o.status, true) && MedicationAdministration.compareValues(this.notGiven, o.notGiven, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.definition, this.partOf, this.status, this.category, this.medication, this.subject, this.context, this.supportingInformation, this.effective, this.performer, this.notGiven, this.reasonNotGiven, this.reasonCode, this.reasonReference, this.prescription, this.device, this.note, this.dosage, this.eventHistory});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationAdministration;
    }

    @Block
    public static class MedicationAdministrationDosageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Free text dosage instructions e.g. SIG", formalDefinition="Free text dosage can be used for cases where the dosage administered is too complex to code. When coded dosage is present, the free text dosage may still be present for display to humans.\r\rThe dosage instructions should reflect the dosage of the medication that was administered.")
        protected StringType text;
        @Child(name="site", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Body site administered to", formalDefinition="A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/approach-site-codes")
        protected CodeableConcept site;
        @Child(name="route", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Path of substance into body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
        protected CodeableConcept route;
        @Child(name="method", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How drug was administered", formalDefinition="A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/administration-method-codes")
        protected CodeableConcept method;
        @Child(name="dose", type={SimpleQuantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of medication per dose", formalDefinition="The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.")
        protected SimpleQuantity dose;
        @Child(name="rate", type={Ratio.class, SimpleQuantity.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Dose quantity per unit of time", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient.  Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.")
        protected Type rate;
        private static final long serialVersionUID = 1316915516L;

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public MedicationAdministrationDosageComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public MedicationAdministrationDosageComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public CodeableConcept getSite() {
            if (this.site == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.site");
                }
                if (Configuration.doAutoCreate()) {
                    this.site = new CodeableConcept();
                }
            }
            return this.site;
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public MedicationAdministrationDosageComponent setSite(CodeableConcept value) {
            this.site = value;
            return this;
        }

        public CodeableConcept getRoute() {
            if (this.route == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.route");
                }
                if (Configuration.doAutoCreate()) {
                    this.route = new CodeableConcept();
                }
            }
            return this.route;
        }

        public boolean hasRoute() {
            return this.route != null && !this.route.isEmpty();
        }

        public MedicationAdministrationDosageComponent setRoute(CodeableConcept value) {
            this.route = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public MedicationAdministrationDosageComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public SimpleQuantity getDose() {
            if (this.dose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.dose");
                }
                if (Configuration.doAutoCreate()) {
                    this.dose = new SimpleQuantity();
                }
            }
            return this.dose;
        }

        public boolean hasDose() {
            return this.dose != null && !this.dose.isEmpty();
        }

        public MedicationAdministrationDosageComponent setDose(SimpleQuantity value) {
            this.dose = value;
            return this;
        }

        public Type getRate() {
            return this.rate;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (this.rate == null) {
                return null;
            }
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this != null && this.rate instanceof Ratio;
        }

        public SimpleQuantity getRateSimpleQuantity() throws FHIRException {
            if (this.rate == null) {
                return null;
            }
            if (!(this.rate instanceof SimpleQuantity)) {
                throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (SimpleQuantity)this.rate;
        }

        public boolean hasRateSimpleQuantity() {
            return this != null && this.rate instanceof SimpleQuantity;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public MedicationAdministrationDosageComponent setRate(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof Ratio) && !(value instanceof Quantity)) {
                throw new FHIRFormatError("Not the right type for MedicationAdministration.dosage.rate[x]: " + value.fhirType());
            }
            this.rate = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("text", "string", "Free text dosage can be used for cases where the dosage administered is too complex to code. When coded dosage is present, the free text dosage may still be present for display to humans.\r\rThe dosage instructions should reflect the dosage of the medication that was administered.", 0, 1, this.text));
            children.add(new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".", 0, 1, this.site));
            children.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.", 0, 1, this.route));
            children.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.", 0, 1, this.method));
            children.add(new Property("dose", "SimpleQuantity", "The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.", 0, 1, this.dose));
            children.add(new Property("rate[x]", "Ratio|SimpleQuantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3556653: {
                    return new Property("text", "string", "Free text dosage can be used for cases where the dosage administered is too complex to code. When coded dosage is present, the free text dosage may still be present for display to humans.\r\rThe dosage instructions should reflect the dosage of the medication that was administered.", 0, 1, this.text);
                }
                case 3530567: {
                    return new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".", 0, 1, this.site);
                }
                case 108704329: {
                    return new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.", 0, 1, this.route);
                }
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.", 0, 1, this.method);
                }
                case 3089437: {
                    return new Property("dose", "SimpleQuantity", "The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.", 0, 1, this.dose);
                }
                case 983460768: {
                    return new Property("rate[x]", "Ratio|SimpleQuantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
                case 3493088: {
                    return new Property("rate[x]", "Ratio|SimpleQuantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
                case 204021515: {
                    return new Property("rate[x]", "Ratio|SimpleQuantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
                case -2121057955: {
                    return new Property("rate[x]", "Ratio|SimpleQuantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.text;
                    }
                    return baseArray;
                }
                case 3530567: {
                    Base[] baseArray;
                    if (this.site == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.site;
                    }
                    return baseArray;
                }
                case 108704329: {
                    Base[] baseArray;
                    if (this.route == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.route;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.method;
                    }
                    return baseArray;
                }
                case 3089437: {
                    Base[] baseArray;
                    if (this.dose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.dose;
                    }
                    return baseArray;
                }
                case 3493088: {
                    Base[] baseArray;
                    if (this.rate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.rate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
                case 3530567: {
                    this.site = this.castToCodeableConcept(value);
                    return value;
                }
                case 108704329: {
                    this.route = this.castToCodeableConcept(value);
                    return value;
                }
                case -1077554975: {
                    this.method = this.castToCodeableConcept(value);
                    return value;
                }
                case 3089437: {
                    this.dose = this.castToSimpleQuantity(value);
                    return value;
                }
                case 3493088: {
                    this.rate = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("site")) {
                this.site = this.castToCodeableConcept(value);
            } else if (name.equals("route")) {
                this.route = this.castToCodeableConcept(value);
            } else if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else if (name.equals("dose")) {
                this.dose = this.castToSimpleQuantity(value);
            } else if (name.equals("rate[x]")) {
                this.rate = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    return this.getTextElement();
                }
                case 3530567: {
                    return this.getSite();
                }
                case 108704329: {
                    return this.getRoute();
                }
                case -1077554975: {
                    return this.getMethod();
                }
                case 3089437: {
                    return this.getDose();
                }
                case 983460768: {
                    return this.getRate();
                }
                case 3493088: {
                    return this.getRate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    return new String[]{"string"};
                }
                case 3530567: {
                    return new String[]{"CodeableConcept"};
                }
                case 108704329: {
                    return new String[]{"CodeableConcept"};
                }
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case 3089437: {
                    return new String[]{"SimpleQuantity"};
                }
                case 3493088: {
                    return new String[]{"Ratio", "SimpleQuantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property MedicationAdministration.text");
            }
            if (name.equals("site")) {
                this.site = new CodeableConcept();
                return this.site;
            }
            if (name.equals("route")) {
                this.route = new CodeableConcept();
                return this.route;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("dose")) {
                this.dose = new SimpleQuantity();
                return this.dose;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            if (name.equals("rateSimpleQuantity")) {
                this.rate = new SimpleQuantity();
                return this.rate;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationAdministrationDosageComponent copy() {
            MedicationAdministrationDosageComponent dst = new MedicationAdministrationDosageComponent();
            this.copyValues(dst);
            dst.text = this.text == null ? null : this.text.copy();
            dst.site = this.site == null ? null : this.site.copy();
            dst.route = this.route == null ? null : this.route.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.dose = this.dose == null ? null : this.dose.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationDosageComponent)) {
                return false;
            }
            MedicationAdministrationDosageComponent o = (MedicationAdministrationDosageComponent)other_;
            return MedicationAdministrationDosageComponent.compareDeep(this.text, o.text, true) && MedicationAdministrationDosageComponent.compareDeep(this.site, o.site, true) && MedicationAdministrationDosageComponent.compareDeep(this.route, o.route, true) && MedicationAdministrationDosageComponent.compareDeep(this.method, o.method, true) && MedicationAdministrationDosageComponent.compareDeep(this.dose, o.dose, true) && MedicationAdministrationDosageComponent.compareDeep(this.rate, o.rate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationDosageComponent)) {
                return false;
            }
            MedicationAdministrationDosageComponent o = (MedicationAdministrationDosageComponent)other_;
            return MedicationAdministrationDosageComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.text, this.site, this.route, this.method, this.dose, this.rate});
        }

        @Override
        public String fhirType() {
            return "MedicationAdministration.dosage";
        }
    }

    @Block
    public static class MedicationAdministrationPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actor", type={Practitioner.class, Patient.class, RelatedPerson.class, Device.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Individual who was performing", formalDefinition="The device, practitioner, etc. who performed the action.")
        protected Reference actor;
        protected Resource actorTarget;
        @Child(name="onBehalfOf", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization organization was acting for", formalDefinition="The organization the device or practitioner was acting on behalf of.")
        protected Reference onBehalfOf;
        protected Organization onBehalfOfTarget;
        private static final long serialVersionUID = -488386403L;

        public MedicationAdministrationPerformerComponent() {
        }

        public MedicationAdministrationPerformerComponent(Reference actor) {
            this.actor = actor;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public MedicationAdministrationPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public MedicationAdministrationPerformerComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationPerformerComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public MedicationAdministrationPerformerComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Organization getOnBehalfOfTarget() {
            if (this.onBehalfOfTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationPerformerComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOfTarget = new Organization();
                }
            }
            return this.onBehalfOfTarget;
        }

        public MedicationAdministrationPerformerComponent setOnBehalfOfTarget(Organization value) {
            this.onBehalfOfTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actor", "Reference(Practitioner|Patient|RelatedPerson|Device)", "The device, practitioner, etc. who performed the action.", 0, 1, this.actor));
            children.add(new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|Patient|RelatedPerson|Device)", "The device, practitioner, etc. who performed the action.", 0, 1, this.actor);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actor;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    this.actor = this.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = this.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return this.getActor();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationAdministrationPerformerComponent copy() {
            MedicationAdministrationPerformerComponent dst = new MedicationAdministrationPerformerComponent();
            this.copyValues(dst);
            dst.actor = this.actor == null ? null : this.actor.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationPerformerComponent)) {
                return false;
            }
            MedicationAdministrationPerformerComponent o = (MedicationAdministrationPerformerComponent)other_;
            return MedicationAdministrationPerformerComponent.compareDeep(this.actor, o.actor, true) && MedicationAdministrationPerformerComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationPerformerComponent)) {
                return false;
            }
            MedicationAdministrationPerformerComponent o = (MedicationAdministrationPerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.actor, this.onBehalfOf});
        }

        @Override
        public String fhirType() {
            return "MedicationAdministration.performer";
        }
    }

    public static class MedicationAdministrationStatusEnumFactory
    implements EnumFactory<MedicationAdministrationStatus> {
        @Override
        public MedicationAdministrationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return MedicationAdministrationStatus.INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationAdministrationStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return MedicationAdministrationStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationAdministrationStatus.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return MedicationAdministrationStatus.STOPPED;
            }
            if ("unknown".equals(codeString)) {
                return MedicationAdministrationStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown MedicationAdministrationStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationAdministrationStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationAdministrationStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.INPROGRESS);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.ONHOLD);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.ENTEREDINERROR);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.STOPPED);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown MedicationAdministrationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationAdministrationStatus code) {
            if (code == MedicationAdministrationStatus.NULL) {
                return null;
            }
            if (code == MedicationAdministrationStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == MedicationAdministrationStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == MedicationAdministrationStatus.COMPLETED) {
                return "completed";
            }
            if (code == MedicationAdministrationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationAdministrationStatus.STOPPED) {
                return "stopped";
            }
            if (code == MedicationAdministrationStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationAdministrationStatus code) {
            return code.getSystem();
        }
    }

    public static enum MedicationAdministrationStatus {
        INPROGRESS,
        ONHOLD,
        COMPLETED,
        ENTEREDINERROR,
        STOPPED,
        UNKNOWN,
        NULL;


        public static MedicationAdministrationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationAdministrationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "The administration has started but has not yet completed.";
                }
                case ONHOLD: {
                    return "Actions implied by the administration have been temporarily halted, but are expected to continue later. May also be called \"suspended\".";
                }
                case COMPLETED: {
                    return "All actions that are implied by the administration have occurred.";
                }
                case ENTEREDINERROR: {
                    return "The administration was entered in error and therefore nullified.";
                }
                case STOPPED: {
                    return "Actions implied by the administration have been permanently halted, before all of them occurred.";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

