/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CoverageLevel;

public class CoverageLevelEnumFactory
implements EnumFactory<CoverageLevel> {
    @Override
    public CoverageLevel fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("group".equals(codeString)) {
            return CoverageLevel.GROUP;
        }
        if ("subgroup".equals(codeString)) {
            return CoverageLevel.SUBGROUP;
        }
        if ("plan".equals(codeString)) {
            return CoverageLevel.PLAN;
        }
        if ("subplan".equals(codeString)) {
            return CoverageLevel.SUBPLAN;
        }
        if ("class".equals(codeString)) {
            return CoverageLevel.CLASS;
        }
        if ("subclass".equals(codeString)) {
            return CoverageLevel.SUBCLASS;
        }
        throw new IllegalArgumentException("Unknown CoverageLevel code '" + codeString + "'");
    }

    @Override
    public String toCode(CoverageLevel code) {
        if (code == CoverageLevel.NULL) {
            return null;
        }
        if (code == CoverageLevel.GROUP) {
            return "group";
        }
        if (code == CoverageLevel.SUBGROUP) {
            return "subgroup";
        }
        if (code == CoverageLevel.PLAN) {
            return "plan";
        }
        if (code == CoverageLevel.SUBPLAN) {
            return "subplan";
        }
        if (code == CoverageLevel.CLASS) {
            return "class";
        }
        if (code == CoverageLevel.SUBCLASS) {
            return "subclass";
        }
        return "?";
    }

    @Override
    public String toSystem(CoverageLevel code) {
        return code.getSystem();
    }
}

