/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.GoalPriority;

public class GoalPriorityEnumFactory
implements EnumFactory<GoalPriority> {
    @Override
    public GoalPriority fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("high-priority".equals(codeString)) {
            return GoalPriority.HIGHPRIORITY;
        }
        if ("medium-priority".equals(codeString)) {
            return GoalPriority.MEDIUMPRIORITY;
        }
        if ("low-priority".equals(codeString)) {
            return GoalPriority.LOWPRIORITY;
        }
        throw new IllegalArgumentException("Unknown GoalPriority code '" + codeString + "'");
    }

    @Override
    public String toCode(GoalPriority code) {
        if (code == GoalPriority.NULL) {
            return null;
        }
        if (code == GoalPriority.HIGHPRIORITY) {
            return "high-priority";
        }
        if (code == GoalPriority.MEDIUMPRIORITY) {
            return "medium-priority";
        }
        if (code == GoalPriority.LOWPRIORITY) {
            return "low-priority";
        }
        return "?";
    }

    @Override
    public String toSystem(GoalPriority code) {
        return code.getSystem();
    }
}

