/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.TaskStatus;

public class TaskStatusEnumFactory
implements EnumFactory<TaskStatus> {
    @Override
    public TaskStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return TaskStatus.DRAFT;
        }
        if ("requested".equals(codeString)) {
            return TaskStatus.REQUESTED;
        }
        if ("received".equals(codeString)) {
            return TaskStatus.RECEIVED;
        }
        if ("accepted".equals(codeString)) {
            return TaskStatus.ACCEPTED;
        }
        if ("rejected".equals(codeString)) {
            return TaskStatus.REJECTED;
        }
        if ("ready".equals(codeString)) {
            return TaskStatus.READY;
        }
        if ("cancelled".equals(codeString)) {
            return TaskStatus.CANCELLED;
        }
        if ("in-progress".equals(codeString)) {
            return TaskStatus.INPROGRESS;
        }
        if ("on-hold".equals(codeString)) {
            return TaskStatus.ONHOLD;
        }
        if ("failed".equals(codeString)) {
            return TaskStatus.FAILED;
        }
        if ("completed".equals(codeString)) {
            return TaskStatus.COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return TaskStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown TaskStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(TaskStatus code) {
        if (code == TaskStatus.NULL) {
            return null;
        }
        if (code == TaskStatus.DRAFT) {
            return "draft";
        }
        if (code == TaskStatus.REQUESTED) {
            return "requested";
        }
        if (code == TaskStatus.RECEIVED) {
            return "received";
        }
        if (code == TaskStatus.ACCEPTED) {
            return "accepted";
        }
        if (code == TaskStatus.REJECTED) {
            return "rejected";
        }
        if (code == TaskStatus.READY) {
            return "ready";
        }
        if (code == TaskStatus.CANCELLED) {
            return "cancelled";
        }
        if (code == TaskStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == TaskStatus.ONHOLD) {
            return "on-hold";
        }
        if (code == TaskStatus.FAILED) {
            return "failed";
        }
        if (code == TaskStatus.COMPLETED) {
            return "completed";
        }
        if (code == TaskStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(TaskStatus code) {
        return code.getSystem();
    }
}

