/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ExpansionProfile", profile="http://hl7.org/fhir/Profile/ExpansionProfile")
@ChildOrder(names={"url", "identifier", "version", "name", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "fixedVersion", "excludedSystem", "includeDesignations", "designation", "includeDefinition", "activeOnly", "excludeNested", "excludeNotForUI", "excludePostCoordinated", "displayLanguage", "limitedExpansion"})
public class ExpansionProfile
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the expansion profile", formalDefinition="A formal identifier that is used to identify this expansion profile when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected Identifier identifier;
    @Child(name="fixedVersion", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fix use of a code system to a particular version", formalDefinition="Fix use of a particular code system to a particular version.")
    protected List<ExpansionProfileFixedVersionComponent> fixedVersion;
    @Child(name="excludedSystem", type={}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Systems/Versions to be exclude", formalDefinition="Code system, or a particular version of a code system to be excluded from value set expansions.")
    protected ExpansionProfileExcludedSystemComponent excludedSystem;
    @Child(name="includeDesignations", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the expansion should include concept designations", formalDefinition="Controls whether concept designations are to be included or excluded in value set expansions.")
    protected BooleanType includeDesignations;
    @Child(name="designation", type={}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the expansion profile imposes designation contraints", formalDefinition="A set of criteria that provide the constraints imposed on the value set expansion by including or excluding designations.")
    protected ExpansionProfileDesignationComponent designation;
    @Child(name="includeDefinition", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include or exclude the value set definition in the expansion", formalDefinition="Controls whether the value set definition is included or excluded in value set expansions.")
    protected BooleanType includeDefinition;
    @Child(name="activeOnly", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include or exclude inactive concepts in the expansion", formalDefinition="Controls whether inactive concepts are included or excluded in value set expansions.")
    protected BooleanType activeOnly;
    @Child(name="excludeNested", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Nested codes in the expansion or not", formalDefinition="Controls whether or not the value set expansion nests codes or not (i.e. ValueSet.expansion.contains.contains).")
    protected BooleanType excludeNested;
    @Child(name="excludeNotForUI", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include or exclude codes which cannot be rendered in user interfaces in the value set expansion", formalDefinition="Controls whether or not the value set expansion includes codes which cannot be displayed in user interfaces.")
    protected BooleanType excludeNotForUI;
    @Child(name="excludePostCoordinated", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include or exclude codes which are post coordinated expressions in the value set expansion", formalDefinition="Controls whether or not the value set expansion includes post coordinated codes.")
    protected BooleanType excludePostCoordinated;
    @Child(name="displayLanguage", type={CodeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specify the language for the display element of codes in the value set expansion", formalDefinition="Specifies the language to be used for description in the expansions i.e. the language to be used for ValueSet.expansion.contains.display.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
    protected CodeType displayLanguage;
    @Child(name="limitedExpansion", type={BooleanType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Controls behaviour of the value set expand operation when value sets are too large to be completely expanded", formalDefinition="If the value set being expanded is incomplete (because it is too big to expand), return a limited expansion (a subset) with an indicator that expansion is incomplete, using the extension [http://hl7.org/fhir/StructureDefinition/valueset-toocostly](extension-valueset-toocostly.html).")
    protected BooleanType limitedExpansion;
    private static final long serialVersionUID = 1067457001L;
    @SearchParamDefinition(name="date", path="ExpansionProfile.date", description="The expansion profile publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ExpansionProfile.identifier", description="External identifier for the expansion profile", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ExpansionProfile.jurisdiction", description="Intended jurisdiction for the expansion profile", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ExpansionProfile.name", description="Computationally friendly name of the expansion profile", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="description", path="ExpansionProfile.description", description="The description of the expansion profile", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="publisher", path="ExpansionProfile.publisher", description="Name of the publisher of the expansion profile", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="version", path="ExpansionProfile.version", description="The business version of the expansion profile", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ExpansionProfile.url", description="The uri that identifies the expansion profile", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="status", path="ExpansionProfile.status", description="The current status of the expansion profile", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ExpansionProfile() {
    }

    public ExpansionProfile(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ExpansionProfile setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ExpansionProfile setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ExpansionProfile setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ExpansionProfile setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ExpansionProfile setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ExpansionProfile setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ExpansionProfile setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ExpansionProfile setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ExpansionProfile setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ExpansionProfile setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ExpansionProfile setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ExpansionProfile setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ExpansionProfile setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ExpansionProfile setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ExpansionProfile setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ExpansionProfile setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ExpansionProfile addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ExpansionProfile setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ExpansionProfile setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ExpansionProfile setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ExpansionProfile addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ExpansionProfile setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ExpansionProfile addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public List<ExpansionProfileFixedVersionComponent> getFixedVersion() {
        if (this.fixedVersion == null) {
            this.fixedVersion = new ArrayList<ExpansionProfileFixedVersionComponent>();
        }
        return this.fixedVersion;
    }

    public ExpansionProfile setFixedVersion(List<ExpansionProfileFixedVersionComponent> theFixedVersion) {
        this.fixedVersion = theFixedVersion;
        return this;
    }

    public boolean hasFixedVersion() {
        if (this.fixedVersion == null) {
            return false;
        }
        for (ExpansionProfileFixedVersionComponent item : this.fixedVersion) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExpansionProfileFixedVersionComponent addFixedVersion() {
        ExpansionProfileFixedVersionComponent t = new ExpansionProfileFixedVersionComponent();
        if (this.fixedVersion == null) {
            this.fixedVersion = new ArrayList<ExpansionProfileFixedVersionComponent>();
        }
        this.fixedVersion.add(t);
        return t;
    }

    public ExpansionProfile addFixedVersion(ExpansionProfileFixedVersionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.fixedVersion == null) {
            this.fixedVersion = new ArrayList<ExpansionProfileFixedVersionComponent>();
        }
        this.fixedVersion.add(t);
        return this;
    }

    public ExpansionProfileFixedVersionComponent getFixedVersionFirstRep() {
        if (this.getFixedVersion().isEmpty()) {
            this.addFixedVersion();
        }
        return this.getFixedVersion().get(0);
    }

    public ExpansionProfileExcludedSystemComponent getExcludedSystem() {
        if (this.excludedSystem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.excludedSystem");
            }
            if (Configuration.doAutoCreate()) {
                this.excludedSystem = new ExpansionProfileExcludedSystemComponent();
            }
        }
        return this.excludedSystem;
    }

    public boolean hasExcludedSystem() {
        return this.excludedSystem != null && !this.excludedSystem.isEmpty();
    }

    public ExpansionProfile setExcludedSystem(ExpansionProfileExcludedSystemComponent value) {
        this.excludedSystem = value;
        return this;
    }

    public BooleanType getIncludeDesignationsElement() {
        if (this.includeDesignations == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.includeDesignations");
            }
            if (Configuration.doAutoCreate()) {
                this.includeDesignations = new BooleanType();
            }
        }
        return this.includeDesignations;
    }

    public boolean hasIncludeDesignationsElement() {
        return this.includeDesignations != null && !this.includeDesignations.isEmpty();
    }

    public boolean hasIncludeDesignations() {
        return this.includeDesignations != null && !this.includeDesignations.isEmpty();
    }

    public ExpansionProfile setIncludeDesignationsElement(BooleanType value) {
        this.includeDesignations = value;
        return this;
    }

    public boolean getIncludeDesignations() {
        return this.includeDesignations == null || this.includeDesignations.isEmpty() ? false : (Boolean)this.includeDesignations.getValue();
    }

    public ExpansionProfile setIncludeDesignations(boolean value) {
        if (this.includeDesignations == null) {
            this.includeDesignations = new BooleanType();
        }
        this.includeDesignations.setValue((Object)value);
        return this;
    }

    public ExpansionProfileDesignationComponent getDesignation() {
        if (this.designation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.designation");
            }
            if (Configuration.doAutoCreate()) {
                this.designation = new ExpansionProfileDesignationComponent();
            }
        }
        return this.designation;
    }

    public boolean hasDesignation() {
        return this.designation != null && !this.designation.isEmpty();
    }

    public ExpansionProfile setDesignation(ExpansionProfileDesignationComponent value) {
        this.designation = value;
        return this;
    }

    public BooleanType getIncludeDefinitionElement() {
        if (this.includeDefinition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.includeDefinition");
            }
            if (Configuration.doAutoCreate()) {
                this.includeDefinition = new BooleanType();
            }
        }
        return this.includeDefinition;
    }

    public boolean hasIncludeDefinitionElement() {
        return this.includeDefinition != null && !this.includeDefinition.isEmpty();
    }

    public boolean hasIncludeDefinition() {
        return this.includeDefinition != null && !this.includeDefinition.isEmpty();
    }

    public ExpansionProfile setIncludeDefinitionElement(BooleanType value) {
        this.includeDefinition = value;
        return this;
    }

    public boolean getIncludeDefinition() {
        return this.includeDefinition == null || this.includeDefinition.isEmpty() ? false : (Boolean)this.includeDefinition.getValue();
    }

    public ExpansionProfile setIncludeDefinition(boolean value) {
        if (this.includeDefinition == null) {
            this.includeDefinition = new BooleanType();
        }
        this.includeDefinition.setValue((Object)value);
        return this;
    }

    public BooleanType getActiveOnlyElement() {
        if (this.activeOnly == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.activeOnly");
            }
            if (Configuration.doAutoCreate()) {
                this.activeOnly = new BooleanType();
            }
        }
        return this.activeOnly;
    }

    public boolean hasActiveOnlyElement() {
        return this.activeOnly != null && !this.activeOnly.isEmpty();
    }

    public boolean hasActiveOnly() {
        return this.activeOnly != null && !this.activeOnly.isEmpty();
    }

    public ExpansionProfile setActiveOnlyElement(BooleanType value) {
        this.activeOnly = value;
        return this;
    }

    public boolean getActiveOnly() {
        return this.activeOnly == null || this.activeOnly.isEmpty() ? false : (Boolean)this.activeOnly.getValue();
    }

    public ExpansionProfile setActiveOnly(boolean value) {
        if (this.activeOnly == null) {
            this.activeOnly = new BooleanType();
        }
        this.activeOnly.setValue((Object)value);
        return this;
    }

    public BooleanType getExcludeNestedElement() {
        if (this.excludeNested == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.excludeNested");
            }
            if (Configuration.doAutoCreate()) {
                this.excludeNested = new BooleanType();
            }
        }
        return this.excludeNested;
    }

    public boolean hasExcludeNestedElement() {
        return this.excludeNested != null && !this.excludeNested.isEmpty();
    }

    public boolean hasExcludeNested() {
        return this.excludeNested != null && !this.excludeNested.isEmpty();
    }

    public ExpansionProfile setExcludeNestedElement(BooleanType value) {
        this.excludeNested = value;
        return this;
    }

    public boolean getExcludeNested() {
        return this.excludeNested == null || this.excludeNested.isEmpty() ? false : (Boolean)this.excludeNested.getValue();
    }

    public ExpansionProfile setExcludeNested(boolean value) {
        if (this.excludeNested == null) {
            this.excludeNested = new BooleanType();
        }
        this.excludeNested.setValue((Object)value);
        return this;
    }

    public BooleanType getExcludeNotForUIElement() {
        if (this.excludeNotForUI == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.excludeNotForUI");
            }
            if (Configuration.doAutoCreate()) {
                this.excludeNotForUI = new BooleanType();
            }
        }
        return this.excludeNotForUI;
    }

    public boolean hasExcludeNotForUIElement() {
        return this.excludeNotForUI != null && !this.excludeNotForUI.isEmpty();
    }

    public boolean hasExcludeNotForUI() {
        return this.excludeNotForUI != null && !this.excludeNotForUI.isEmpty();
    }

    public ExpansionProfile setExcludeNotForUIElement(BooleanType value) {
        this.excludeNotForUI = value;
        return this;
    }

    public boolean getExcludeNotForUI() {
        return this.excludeNotForUI == null || this.excludeNotForUI.isEmpty() ? false : (Boolean)this.excludeNotForUI.getValue();
    }

    public ExpansionProfile setExcludeNotForUI(boolean value) {
        if (this.excludeNotForUI == null) {
            this.excludeNotForUI = new BooleanType();
        }
        this.excludeNotForUI.setValue((Object)value);
        return this;
    }

    public BooleanType getExcludePostCoordinatedElement() {
        if (this.excludePostCoordinated == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.excludePostCoordinated");
            }
            if (Configuration.doAutoCreate()) {
                this.excludePostCoordinated = new BooleanType();
            }
        }
        return this.excludePostCoordinated;
    }

    public boolean hasExcludePostCoordinatedElement() {
        return this.excludePostCoordinated != null && !this.excludePostCoordinated.isEmpty();
    }

    public boolean hasExcludePostCoordinated() {
        return this.excludePostCoordinated != null && !this.excludePostCoordinated.isEmpty();
    }

    public ExpansionProfile setExcludePostCoordinatedElement(BooleanType value) {
        this.excludePostCoordinated = value;
        return this;
    }

    public boolean getExcludePostCoordinated() {
        return this.excludePostCoordinated == null || this.excludePostCoordinated.isEmpty() ? false : (Boolean)this.excludePostCoordinated.getValue();
    }

    public ExpansionProfile setExcludePostCoordinated(boolean value) {
        if (this.excludePostCoordinated == null) {
            this.excludePostCoordinated = new BooleanType();
        }
        this.excludePostCoordinated.setValue((Object)value);
        return this;
    }

    public CodeType getDisplayLanguageElement() {
        if (this.displayLanguage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.displayLanguage");
            }
            if (Configuration.doAutoCreate()) {
                this.displayLanguage = new CodeType();
            }
        }
        return this.displayLanguage;
    }

    public boolean hasDisplayLanguageElement() {
        return this.displayLanguage != null && !this.displayLanguage.isEmpty();
    }

    public boolean hasDisplayLanguage() {
        return this.displayLanguage != null && !this.displayLanguage.isEmpty();
    }

    public ExpansionProfile setDisplayLanguageElement(CodeType value) {
        this.displayLanguage = value;
        return this;
    }

    public String getDisplayLanguage() {
        return this.displayLanguage == null ? null : (String)this.displayLanguage.getValue();
    }

    public ExpansionProfile setDisplayLanguage(String value) {
        if (Utilities.noString((String)value)) {
            this.displayLanguage = null;
        } else {
            if (this.displayLanguage == null) {
                this.displayLanguage = new CodeType();
            }
            this.displayLanguage.setValue(value);
        }
        return this;
    }

    public BooleanType getLimitedExpansionElement() {
        if (this.limitedExpansion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExpansionProfile.limitedExpansion");
            }
            if (Configuration.doAutoCreate()) {
                this.limitedExpansion = new BooleanType();
            }
        }
        return this.limitedExpansion;
    }

    public boolean hasLimitedExpansionElement() {
        return this.limitedExpansion != null && !this.limitedExpansion.isEmpty();
    }

    public boolean hasLimitedExpansion() {
        return this.limitedExpansion != null && !this.limitedExpansion.isEmpty();
    }

    public ExpansionProfile setLimitedExpansionElement(BooleanType value) {
        this.limitedExpansion = value;
        return this;
    }

    public boolean getLimitedExpansion() {
        return this.limitedExpansion == null || this.limitedExpansion.isEmpty() ? false : (Boolean)this.limitedExpansion.getValue();
    }

    public ExpansionProfile setLimitedExpansion(boolean value) {
        if (this.limitedExpansion == null) {
            this.limitedExpansion = new BooleanType();
        }
        this.limitedExpansion.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this expansion profile when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this expansion profile is (or will be) published. The URL SHOULD include the major version of the expansion profile. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this expansion profile when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, 1, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the expansion profile when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the expansion profile author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the expansion profile. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of this expansion profile. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A boolean value to indicate that this expansion profile is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the expansion profile was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the expansion profile changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the expansion profile.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the expansion profile from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate expansion profile instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the expansion profile is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("fixedVersion", "", "Fix use of a particular code system to a particular version.", 0, Integer.MAX_VALUE, this.fixedVersion));
        children.add(new Property("excludedSystem", "", "Code system, or a particular version of a code system to be excluded from value set expansions.", 0, 1, this.excludedSystem));
        children.add(new Property("includeDesignations", "boolean", "Controls whether concept designations are to be included or excluded in value set expansions.", 0, 1, this.includeDesignations));
        children.add(new Property("designation", "", "A set of criteria that provide the constraints imposed on the value set expansion by including or excluding designations.", 0, 1, this.designation));
        children.add(new Property("includeDefinition", "boolean", "Controls whether the value set definition is included or excluded in value set expansions.", 0, 1, this.includeDefinition));
        children.add(new Property("activeOnly", "boolean", "Controls whether inactive concepts are included or excluded in value set expansions.", 0, 1, this.activeOnly));
        children.add(new Property("excludeNested", "boolean", "Controls whether or not the value set expansion nests codes or not (i.e. ValueSet.expansion.contains.contains).", 0, 1, this.excludeNested));
        children.add(new Property("excludeNotForUI", "boolean", "Controls whether or not the value set expansion includes codes which cannot be displayed in user interfaces.", 0, 1, this.excludeNotForUI));
        children.add(new Property("excludePostCoordinated", "boolean", "Controls whether or not the value set expansion includes post coordinated codes.", 0, 1, this.excludePostCoordinated));
        children.add(new Property("displayLanguage", "code", "Specifies the language to be used for description in the expansions i.e. the language to be used for ValueSet.expansion.contains.display.", 0, 1, this.displayLanguage));
        children.add(new Property("limitedExpansion", "boolean", "If the value set being expanded is incomplete (because it is too big to expand), return a limited expansion (a subset) with an indicator that expansion is incomplete, using the extension [http://hl7.org/fhir/StructureDefinition/valueset-toocostly](extension-valueset-toocostly.html).", 0, 1, this.limitedExpansion));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this expansion profile when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this expansion profile is (or will be) published. The URL SHOULD include the major version of the expansion profile. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this expansion profile when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, 1, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the expansion profile when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the expansion profile author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the expansion profile. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this expansion profile. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A boolean value to indicate that this expansion profile is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the expansion profile was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the expansion profile changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the expansion profile.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the expansion profile from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate expansion profile instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the expansion profile is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 807748292: {
                return new Property("fixedVersion", "", "Fix use of a particular code system to a particular version.", 0, Integer.MAX_VALUE, this.fixedVersion);
            }
            case 2125282457: {
                return new Property("excludedSystem", "", "Code system, or a particular version of a code system to be excluded from value set expansions.", 0, 1, this.excludedSystem);
            }
            case 461507620: {
                return new Property("includeDesignations", "boolean", "Controls whether concept designations are to be included or excluded in value set expansions.", 0, 1, this.includeDesignations);
            }
            case -900931593: {
                return new Property("designation", "", "A set of criteria that provide the constraints imposed on the value set expansion by including or excluding designations.", 0, 1, this.designation);
            }
            case 127972379: {
                return new Property("includeDefinition", "boolean", "Controls whether the value set definition is included or excluded in value set expansions.", 0, 1, this.includeDefinition);
            }
            case 2043813842: {
                return new Property("activeOnly", "boolean", "Controls whether inactive concepts are included or excluded in value set expansions.", 0, 1, this.activeOnly);
            }
            case 424992625: {
                return new Property("excludeNested", "boolean", "Controls whether or not the value set expansion nests codes or not (i.e. ValueSet.expansion.contains.contains).", 0, 1, this.excludeNested);
            }
            case 667582980: {
                return new Property("excludeNotForUI", "boolean", "Controls whether or not the value set expansion includes codes which cannot be displayed in user interfaces.", 0, 1, this.excludeNotForUI);
            }
            case 563335154: {
                return new Property("excludePostCoordinated", "boolean", "Controls whether or not the value set expansion includes post coordinated codes.", 0, 1, this.excludePostCoordinated);
            }
            case 1486237242: {
                return new Property("displayLanguage", "code", "Specifies the language to be used for description in the expansions i.e. the language to be used for ValueSet.expansion.contains.display.", 0, 1, this.displayLanguage);
            }
            case 597771333: {
                return new Property("limitedExpansion", "boolean", "If the value set being expanded is incomplete (because it is too big to expand), return a limited expansion (a subset) with an indicator that expansion is incomplete, using the extension [http://hl7.org/fhir/StructureDefinition/valueset-toocostly](extension-valueset-toocostly.html).", 0, 1, this.limitedExpansion);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 807748292: {
                return this.fixedVersion == null ? new Base[]{} : this.fixedVersion.toArray(new Base[this.fixedVersion.size()]);
            }
            case 2125282457: {
                Base[] baseArray;
                if (this.excludedSystem == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.excludedSystem;
                }
                return baseArray;
            }
            case 461507620: {
                Base[] baseArray;
                if (this.includeDesignations == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.includeDesignations;
                }
                return baseArray;
            }
            case -900931593: {
                Base[] baseArray;
                if (this.designation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.designation;
                }
                return baseArray;
            }
            case 127972379: {
                Base[] baseArray;
                if (this.includeDefinition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.includeDefinition;
                }
                return baseArray;
            }
            case 2043813842: {
                Base[] baseArray;
                if (this.activeOnly == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.activeOnly;
                }
                return baseArray;
            }
            case 424992625: {
                Base[] baseArray;
                if (this.excludeNested == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.excludeNested;
                }
                return baseArray;
            }
            case 667582980: {
                Base[] baseArray;
                if (this.excludeNotForUI == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.excludeNotForUI;
                }
                return baseArray;
            }
            case 563335154: {
                Base[] baseArray;
                if (this.excludePostCoordinated == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.excludePostCoordinated;
                }
                return baseArray;
            }
            case 1486237242: {
                Base[] baseArray;
                if (this.displayLanguage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.displayLanguage;
                }
                return baseArray;
            }
            case 597771333: {
                Base[] baseArray;
                if (this.limitedExpansion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.limitedExpansion;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 807748292: {
                this.getFixedVersion().add((ExpansionProfileFixedVersionComponent)((Object)value));
                return value;
            }
            case 2125282457: {
                this.excludedSystem = (ExpansionProfileExcludedSystemComponent)((Object)value);
                return value;
            }
            case 461507620: {
                this.includeDesignations = this.castToBoolean(value);
                return value;
            }
            case -900931593: {
                this.designation = (ExpansionProfileDesignationComponent)((Object)value);
                return value;
            }
            case 127972379: {
                this.includeDefinition = this.castToBoolean(value);
                return value;
            }
            case 2043813842: {
                this.activeOnly = this.castToBoolean(value);
                return value;
            }
            case 424992625: {
                this.excludeNested = this.castToBoolean(value);
                return value;
            }
            case 667582980: {
                this.excludeNotForUI = this.castToBoolean(value);
                return value;
            }
            case 563335154: {
                this.excludePostCoordinated = this.castToBoolean(value);
                return value;
            }
            case 1486237242: {
                this.displayLanguage = this.castToCode(value);
                return value;
            }
            case 597771333: {
                this.limitedExpansion = this.castToBoolean(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("fixedVersion")) {
            this.getFixedVersion().add((ExpansionProfileFixedVersionComponent)((Object)value));
        } else if (name.equals("excludedSystem")) {
            this.excludedSystem = (ExpansionProfileExcludedSystemComponent)((Object)value);
        } else if (name.equals("includeDesignations")) {
            this.includeDesignations = this.castToBoolean(value);
        } else if (name.equals("designation")) {
            this.designation = (ExpansionProfileDesignationComponent)((Object)value);
        } else if (name.equals("includeDefinition")) {
            this.includeDefinition = this.castToBoolean(value);
        } else if (name.equals("activeOnly")) {
            this.activeOnly = this.castToBoolean(value);
        } else if (name.equals("excludeNested")) {
            this.excludeNested = this.castToBoolean(value);
        } else if (name.equals("excludeNotForUI")) {
            this.excludeNotForUI = this.castToBoolean(value);
        } else if (name.equals("excludePostCoordinated")) {
            this.excludePostCoordinated = this.castToBoolean(value);
        } else if (name.equals("displayLanguage")) {
            this.displayLanguage = this.castToCode(value);
        } else if (name.equals("limitedExpansion")) {
            this.limitedExpansion = this.castToBoolean(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 807748292: {
                return this.addFixedVersion();
            }
            case 2125282457: {
                return this.getExcludedSystem();
            }
            case 461507620: {
                return this.getIncludeDesignationsElement();
            }
            case -900931593: {
                return this.getDesignation();
            }
            case 127972379: {
                return this.getIncludeDefinitionElement();
            }
            case 2043813842: {
                return this.getActiveOnlyElement();
            }
            case 424992625: {
                return this.getExcludeNestedElement();
            }
            case 667582980: {
                return this.getExcludeNotForUIElement();
            }
            case 563335154: {
                return this.getExcludePostCoordinatedElement();
            }
            case 1486237242: {
                return this.getDisplayLanguageElement();
            }
            case 597771333: {
                return this.getLimitedExpansionElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 807748292: {
                return new String[0];
            }
            case 2125282457: {
                return new String[0];
            }
            case 461507620: {
                return new String[]{"boolean"};
            }
            case -900931593: {
                return new String[0];
            }
            case 127972379: {
                return new String[]{"boolean"};
            }
            case 2043813842: {
                return new String[]{"boolean"};
            }
            case 424992625: {
                return new String[]{"boolean"};
            }
            case 667582980: {
                return new String[]{"boolean"};
            }
            case 563335154: {
                return new String[]{"boolean"};
            }
            case 1486237242: {
                return new String[]{"code"};
            }
            case 597771333: {
                return new String[]{"boolean"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("fixedVersion")) {
            return this.addFixedVersion();
        }
        if (name.equals("excludedSystem")) {
            this.excludedSystem = new ExpansionProfileExcludedSystemComponent();
            return this.excludedSystem;
        }
        if (name.equals("includeDesignations")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.includeDesignations");
        }
        if (name.equals("designation")) {
            this.designation = new ExpansionProfileDesignationComponent();
            return this.designation;
        }
        if (name.equals("includeDefinition")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.includeDefinition");
        }
        if (name.equals("activeOnly")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.activeOnly");
        }
        if (name.equals("excludeNested")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.excludeNested");
        }
        if (name.equals("excludeNotForUI")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.excludeNotForUI");
        }
        if (name.equals("excludePostCoordinated")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.excludePostCoordinated");
        }
        if (name.equals("displayLanguage")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.displayLanguage");
        }
        if (name.equals("limitedExpansion")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.limitedExpansion");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ExpansionProfile";
    }

    @Override
    public ExpansionProfile copy() {
        ExpansionProfile dst = new ExpansionProfile();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        if (this.fixedVersion != null) {
            dst.fixedVersion = new ArrayList<ExpansionProfileFixedVersionComponent>();
            for (ExpansionProfileFixedVersionComponent expansionProfileFixedVersionComponent : this.fixedVersion) {
                dst.fixedVersion.add(expansionProfileFixedVersionComponent.copy());
            }
        }
        dst.excludedSystem = this.excludedSystem == null ? null : this.excludedSystem.copy();
        dst.includeDesignations = this.includeDesignations == null ? null : this.includeDesignations.copy();
        dst.designation = this.designation == null ? null : this.designation.copy();
        dst.includeDefinition = this.includeDefinition == null ? null : this.includeDefinition.copy();
        dst.activeOnly = this.activeOnly == null ? null : this.activeOnly.copy();
        dst.excludeNested = this.excludeNested == null ? null : this.excludeNested.copy();
        dst.excludeNotForUI = this.excludeNotForUI == null ? null : this.excludeNotForUI.copy();
        dst.excludePostCoordinated = this.excludePostCoordinated == null ? null : this.excludePostCoordinated.copy();
        dst.displayLanguage = this.displayLanguage == null ? null : this.displayLanguage.copy();
        dst.limitedExpansion = this.limitedExpansion == null ? null : this.limitedExpansion.copy();
        return dst;
    }

    protected ExpansionProfile typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ExpansionProfile)) {
            return false;
        }
        ExpansionProfile o = (ExpansionProfile)other_;
        return ExpansionProfile.compareDeep(this.identifier, o.identifier, true) && ExpansionProfile.compareDeep(this.fixedVersion, o.fixedVersion, true) && ExpansionProfile.compareDeep(this.excludedSystem, o.excludedSystem, true) && ExpansionProfile.compareDeep(this.includeDesignations, o.includeDesignations, true) && ExpansionProfile.compareDeep(this.designation, o.designation, true) && ExpansionProfile.compareDeep(this.includeDefinition, o.includeDefinition, true) && ExpansionProfile.compareDeep(this.activeOnly, o.activeOnly, true) && ExpansionProfile.compareDeep(this.excludeNested, o.excludeNested, true) && ExpansionProfile.compareDeep(this.excludeNotForUI, o.excludeNotForUI, true) && ExpansionProfile.compareDeep(this.excludePostCoordinated, o.excludePostCoordinated, true) && ExpansionProfile.compareDeep(this.displayLanguage, o.displayLanguage, true) && ExpansionProfile.compareDeep(this.limitedExpansion, o.limitedExpansion, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ExpansionProfile)) {
            return false;
        }
        ExpansionProfile o = (ExpansionProfile)other_;
        return ExpansionProfile.compareValues(this.includeDesignations, o.includeDesignations, true) && ExpansionProfile.compareValues(this.includeDefinition, o.includeDefinition, true) && ExpansionProfile.compareValues(this.activeOnly, o.activeOnly, true) && ExpansionProfile.compareValues(this.excludeNested, o.excludeNested, true) && ExpansionProfile.compareValues(this.excludeNotForUI, o.excludeNotForUI, true) && ExpansionProfile.compareValues(this.excludePostCoordinated, o.excludePostCoordinated, true) && ExpansionProfile.compareValues(this.displayLanguage, o.displayLanguage, true) && ExpansionProfile.compareValues(this.limitedExpansion, o.limitedExpansion, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.fixedVersion, this.excludedSystem, this.includeDesignations, this.designation, this.includeDefinition, this.activeOnly, this.excludeNested, this.excludeNotForUI, this.excludePostCoordinated, this.displayLanguage, this.limitedExpansion});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ExpansionProfile;
    }

    @Block
    public static class DesignationExcludeDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human language of the designation to be excluded", formalDefinition="The language this designation is defined for.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeType language;
        @Child(name="use", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What kind of Designation to exclude", formalDefinition="Which kinds of designation to exclude from the expansion.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/designation-use")
        protected Coding use;
        private static final long serialVersionUID = 242239292L;

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DesignationExcludeDesignationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public DesignationExcludeDesignationComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public DesignationExcludeDesignationComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public Coding getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DesignationExcludeDesignationComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Coding();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public DesignationExcludeDesignationComponent setUse(Coding value) {
            this.use = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("language", "code", "The language this designation is defined for.", 0, 1, this.language));
            children.add(new Property("use", "Coding", "Which kinds of designation to exclude from the expansion.", 0, 1, this.use));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1613589672: {
                    return new Property("language", "code", "The language this designation is defined for.", 0, 1, this.language);
                }
                case 116103: {
                    return new Property("use", "Coding", "Which kinds of designation to exclude from the expansion.", 0, 1, this.use);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = this.castToCode(value);
                    return value;
                }
                case 116103: {
                    this.use = this.castToCoding(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = this.castToCode(value);
            } else if (name.equals("use")) {
                this.use = this.castToCoding(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case 116103: {
                    return this.getUse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return new String[]{"code"};
                }
                case 116103: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.language");
            }
            if (name.equals("use")) {
                this.use = new Coding();
                return this.use;
            }
            return super.addChild(name);
        }

        @Override
        public DesignationExcludeDesignationComponent copy() {
            DesignationExcludeDesignationComponent dst = new DesignationExcludeDesignationComponent();
            this.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.use = this.use == null ? null : this.use.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DesignationExcludeDesignationComponent)) {
                return false;
            }
            DesignationExcludeDesignationComponent o = (DesignationExcludeDesignationComponent)other_;
            return DesignationExcludeDesignationComponent.compareDeep(this.language, o.language, true) && DesignationExcludeDesignationComponent.compareDeep(this.use, o.use, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DesignationExcludeDesignationComponent)) {
                return false;
            }
            DesignationExcludeDesignationComponent o = (DesignationExcludeDesignationComponent)other_;
            return DesignationExcludeDesignationComponent.compareValues(this.language, o.language, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.language, this.use});
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation.exclude.designation";
        }
    }

    @Block
    public static class DesignationExcludeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="designation", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The designation to be excluded", formalDefinition="A data group for each designation to be excluded.")
        protected List<DesignationExcludeDesignationComponent> designation;
        private static final long serialVersionUID = 1045849752L;

        public List<DesignationExcludeDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationExcludeDesignationComponent>();
            }
            return this.designation;
        }

        public DesignationExcludeComponent setDesignation(List<DesignationExcludeDesignationComponent> theDesignation) {
            this.designation = theDesignation;
            return this;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (DesignationExcludeDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DesignationExcludeDesignationComponent addDesignation() {
            DesignationExcludeDesignationComponent t = new DesignationExcludeDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationExcludeDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public DesignationExcludeComponent addDesignation(DesignationExcludeDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationExcludeDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        public DesignationExcludeDesignationComponent getDesignationFirstRep() {
            if (this.getDesignation().isEmpty()) {
                this.addDesignation();
            }
            return this.getDesignation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("designation", "", "A data group for each designation to be excluded.", 0, Integer.MAX_VALUE, this.designation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -900931593: {
                    return new Property("designation", "", "A data group for each designation to be excluded.", 0, Integer.MAX_VALUE, this.designation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    this.getDesignation().add((DesignationExcludeDesignationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("designation")) {
                return super.setProperty(name, value);
            }
            this.getDesignation().add((DesignationExcludeDesignationComponent)value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return this.addDesignation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            return super.addChild(name);
        }

        @Override
        public DesignationExcludeComponent copy() {
            DesignationExcludeComponent dst = new DesignationExcludeComponent();
            this.copyValues(dst);
            if (this.designation != null) {
                dst.designation = new ArrayList<DesignationExcludeDesignationComponent>();
                for (DesignationExcludeDesignationComponent i : this.designation) {
                    dst.designation.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DesignationExcludeComponent)) {
                return false;
            }
            DesignationExcludeComponent o = (DesignationExcludeComponent)other_;
            return DesignationExcludeComponent.compareDeep(this.designation, o.designation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DesignationExcludeComponent)) {
                return false;
            }
            DesignationExcludeComponent o = (DesignationExcludeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.designation);
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation.exclude";
        }
    }

    @Block
    public static class DesignationIncludeDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human language of the designation to be included", formalDefinition="The language this designation is defined for.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeType language;
        @Child(name="use", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What kind of Designation to include", formalDefinition="Which kinds of designation to include in the expansion.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/designation-use")
        protected Coding use;
        private static final long serialVersionUID = 242239292L;

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DesignationIncludeDesignationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public DesignationIncludeDesignationComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public DesignationIncludeDesignationComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public Coding getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DesignationIncludeDesignationComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Coding();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public DesignationIncludeDesignationComponent setUse(Coding value) {
            this.use = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("language", "code", "The language this designation is defined for.", 0, 1, this.language));
            children.add(new Property("use", "Coding", "Which kinds of designation to include in the expansion.", 0, 1, this.use));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1613589672: {
                    return new Property("language", "code", "The language this designation is defined for.", 0, 1, this.language);
                }
                case 116103: {
                    return new Property("use", "Coding", "Which kinds of designation to include in the expansion.", 0, 1, this.use);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = this.castToCode(value);
                    return value;
                }
                case 116103: {
                    this.use = this.castToCoding(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = this.castToCode(value);
            } else if (name.equals("use")) {
                this.use = this.castToCoding(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case 116103: {
                    return this.getUse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return new String[]{"code"};
                }
                case 116103: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.language");
            }
            if (name.equals("use")) {
                this.use = new Coding();
                return this.use;
            }
            return super.addChild(name);
        }

        @Override
        public DesignationIncludeDesignationComponent copy() {
            DesignationIncludeDesignationComponent dst = new DesignationIncludeDesignationComponent();
            this.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.use = this.use == null ? null : this.use.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DesignationIncludeDesignationComponent)) {
                return false;
            }
            DesignationIncludeDesignationComponent o = (DesignationIncludeDesignationComponent)other_;
            return DesignationIncludeDesignationComponent.compareDeep(this.language, o.language, true) && DesignationIncludeDesignationComponent.compareDeep(this.use, o.use, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DesignationIncludeDesignationComponent)) {
                return false;
            }
            DesignationIncludeDesignationComponent o = (DesignationIncludeDesignationComponent)other_;
            return DesignationIncludeDesignationComponent.compareValues(this.language, o.language, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.language, this.use});
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation.include.designation";
        }
    }

    @Block
    public static class DesignationIncludeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="designation", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The designation to be included", formalDefinition="A data group for each designation to be included.")
        protected List<DesignationIncludeDesignationComponent> designation;
        private static final long serialVersionUID = -1989669274L;

        public List<DesignationIncludeDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationIncludeDesignationComponent>();
            }
            return this.designation;
        }

        public DesignationIncludeComponent setDesignation(List<DesignationIncludeDesignationComponent> theDesignation) {
            this.designation = theDesignation;
            return this;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (DesignationIncludeDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DesignationIncludeDesignationComponent addDesignation() {
            DesignationIncludeDesignationComponent t = new DesignationIncludeDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationIncludeDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public DesignationIncludeComponent addDesignation(DesignationIncludeDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<DesignationIncludeDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        public DesignationIncludeDesignationComponent getDesignationFirstRep() {
            if (this.getDesignation().isEmpty()) {
                this.addDesignation();
            }
            return this.getDesignation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("designation", "", "A data group for each designation to be included.", 0, Integer.MAX_VALUE, this.designation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -900931593: {
                    return new Property("designation", "", "A data group for each designation to be included.", 0, Integer.MAX_VALUE, this.designation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    this.getDesignation().add((DesignationIncludeDesignationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("designation")) {
                return super.setProperty(name, value);
            }
            this.getDesignation().add((DesignationIncludeDesignationComponent)value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return this.addDesignation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -900931593: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            return super.addChild(name);
        }

        @Override
        public DesignationIncludeComponent copy() {
            DesignationIncludeComponent dst = new DesignationIncludeComponent();
            this.copyValues(dst);
            if (this.designation != null) {
                dst.designation = new ArrayList<DesignationIncludeDesignationComponent>();
                for (DesignationIncludeDesignationComponent i : this.designation) {
                    dst.designation.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DesignationIncludeComponent)) {
                return false;
            }
            DesignationIncludeComponent o = (DesignationIncludeComponent)other_;
            return DesignationIncludeComponent.compareDeep(this.designation, o.designation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DesignationIncludeComponent)) {
                return false;
            }
            DesignationIncludeComponent o = (DesignationIncludeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.designation);
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation.include";
        }
    }

    @Block
    public static class ExpansionProfileDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="include", type={}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Designations to be included", formalDefinition="Designations to be included.")
        protected DesignationIncludeComponent include;
        @Child(name="exclude", type={}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Designations to be excluded", formalDefinition="Designations to be excluded.")
        protected DesignationExcludeComponent exclude;
        private static final long serialVersionUID = -2080476436L;

        public DesignationIncludeComponent getInclude() {
            if (this.include == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileDesignationComponent.include");
                }
                if (Configuration.doAutoCreate()) {
                    this.include = new DesignationIncludeComponent();
                }
            }
            return this.include;
        }

        public boolean hasInclude() {
            return this.include != null && !this.include.isEmpty();
        }

        public ExpansionProfileDesignationComponent setInclude(DesignationIncludeComponent value) {
            this.include = value;
            return this;
        }

        public DesignationExcludeComponent getExclude() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileDesignationComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new DesignationExcludeComponent();
                }
            }
            return this.exclude;
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public ExpansionProfileDesignationComponent setExclude(DesignationExcludeComponent value) {
            this.exclude = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("include", "", "Designations to be included.", 0, 1, this.include));
            children.add(new Property("exclude", "", "Designations to be excluded.", 0, 1, this.exclude));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1942574248: {
                    return new Property("include", "", "Designations to be included.", 0, 1, this.include);
                }
                case -1321148966: {
                    return new Property("exclude", "", "Designations to be excluded.", 0, 1, this.exclude);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    Base[] baseArray;
                    if (this.include == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.include;
                    }
                    return baseArray;
                }
                case -1321148966: {
                    Base[] baseArray;
                    if (this.exclude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.exclude;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    this.include = (DesignationIncludeComponent)value;
                    return value;
                }
                case -1321148966: {
                    this.exclude = (DesignationExcludeComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("include")) {
                this.include = (DesignationIncludeComponent)value;
            } else if (name.equals("exclude")) {
                this.exclude = (DesignationExcludeComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    return this.getInclude();
                }
                case -1321148966: {
                    return this.getExclude();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1942574248: {
                    return new String[0];
                }
                case -1321148966: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("include")) {
                this.include = new DesignationIncludeComponent();
                return this.include;
            }
            if (name.equals("exclude")) {
                this.exclude = new DesignationExcludeComponent();
                return this.exclude;
            }
            return super.addChild(name);
        }

        @Override
        public ExpansionProfileDesignationComponent copy() {
            ExpansionProfileDesignationComponent dst = new ExpansionProfileDesignationComponent();
            this.copyValues(dst);
            dst.include = this.include == null ? null : this.include.copy();
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExpansionProfileDesignationComponent)) {
                return false;
            }
            ExpansionProfileDesignationComponent o = (ExpansionProfileDesignationComponent)other_;
            return ExpansionProfileDesignationComponent.compareDeep(this.include, o.include, true) && ExpansionProfileDesignationComponent.compareDeep(this.exclude, o.exclude, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExpansionProfileDesignationComponent)) {
                return false;
            }
            ExpansionProfileDesignationComponent o = (ExpansionProfileDesignationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.include, this.exclude});
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.designation";
        }
    }

    @Block
    public static class ExpansionProfileExcludedSystemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specific code system to be excluded", formalDefinition="An absolute URI which is the code system to be excluded.")
        protected UriType system;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific version of the code system referred to", formalDefinition="The version of the code system from which codes in the expansion should be excluded.")
        protected StringType version;
        private static final long serialVersionUID = 1145288774L;

        public ExpansionProfileExcludedSystemComponent() {
        }

        public ExpansionProfileExcludedSystemComponent(UriType system) {
            this.system = system;
        }

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileExcludedSystemComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public ExpansionProfileExcludedSystemComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public ExpansionProfileExcludedSystemComponent setSystem(String value) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileExcludedSystemComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ExpansionProfileExcludedSystemComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ExpansionProfileExcludedSystemComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("system", "uri", "An absolute URI which is the code system to be excluded.", 0, 1, this.system));
            children.add(new Property(ExpansionProfile.SP_VERSION, "string", "The version of the code system from which codes in the expansion should be excluded.", 0, 1, this.version));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -887328209: {
                    return new Property("system", "uri", "An absolute URI which is the code system to be excluded.", 0, 1, this.system);
                }
                case 351608024: {
                    return new Property(ExpansionProfile.SP_VERSION, "string", "The version of the code system from which codes in the expansion should be excluded.", 0, 1, this.version);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.system;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    this.system = this.castToUri(value);
                    return value;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = this.castToUri(value);
            } else if (name.equals(ExpansionProfile.SP_VERSION)) {
                this.version = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return this.getSystemElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return new String[]{"uri"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.system");
            }
            if (name.equals(ExpansionProfile.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.version");
            }
            return super.addChild(name);
        }

        @Override
        public ExpansionProfileExcludedSystemComponent copy() {
            ExpansionProfileExcludedSystemComponent dst = new ExpansionProfileExcludedSystemComponent();
            this.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            dst.version = this.version == null ? null : this.version.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExpansionProfileExcludedSystemComponent)) {
                return false;
            }
            ExpansionProfileExcludedSystemComponent o = (ExpansionProfileExcludedSystemComponent)other_;
            return ExpansionProfileExcludedSystemComponent.compareDeep(this.system, o.system, true) && ExpansionProfileExcludedSystemComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExpansionProfileExcludedSystemComponent)) {
                return false;
            }
            ExpansionProfileExcludedSystemComponent o = (ExpansionProfileExcludedSystemComponent)other_;
            return ExpansionProfileExcludedSystemComponent.compareValues(this.system, o.system, true) && ExpansionProfileExcludedSystemComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.system, this.version});
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.excludedSystem";
        }
    }

    @Block
    public static class ExpansionProfileFixedVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="System to have its version fixed", formalDefinition="The specific system for which to fix the version.")
        protected UriType system;
        @Child(name="version", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific version of the code system referred to", formalDefinition="The version of the code system from which codes in the expansion should be included.")
        protected StringType version;
        @Child(name="mode", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="default | check | override", formalDefinition="How to manage the intersection between a fixed version in a value set, and this fixed version of the system in the expansion profile.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/system-version-processing-mode")
        protected Enumeration<SystemVersionProcessingMode> mode;
        private static final long serialVersionUID = 1818466753L;

        public ExpansionProfileFixedVersionComponent() {
        }

        public ExpansionProfileFixedVersionComponent(UriType system, StringType version, Enumeration<SystemVersionProcessingMode> mode) {
            this.system = system;
            this.version = version;
            this.mode = mode;
        }

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileFixedVersionComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public ExpansionProfileFixedVersionComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public ExpansionProfileFixedVersionComponent setSystem(String value) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileFixedVersionComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ExpansionProfileFixedVersionComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ExpansionProfileFixedVersionComponent setVersion(String value) {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
            return this;
        }

        public Enumeration<SystemVersionProcessingMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExpansionProfileFixedVersionComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<SystemVersionProcessingMode>(new SystemVersionProcessingModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public ExpansionProfileFixedVersionComponent setModeElement(Enumeration<SystemVersionProcessingMode> value) {
            this.mode = value;
            return this;
        }

        public SystemVersionProcessingMode getMode() {
            return this.mode == null ? null : (SystemVersionProcessingMode)((Object)this.mode.getValue());
        }

        public ExpansionProfileFixedVersionComponent setMode(SystemVersionProcessingMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<SystemVersionProcessingMode>(new SystemVersionProcessingModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("system", "uri", "The specific system for which to fix the version.", 0, 1, this.system));
            children.add(new Property(ExpansionProfile.SP_VERSION, "string", "The version of the code system from which codes in the expansion should be included.", 0, 1, this.version));
            children.add(new Property("mode", "code", "How to manage the intersection between a fixed version in a value set, and this fixed version of the system in the expansion profile.", 0, 1, this.mode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -887328209: {
                    return new Property("system", "uri", "The specific system for which to fix the version.", 0, 1, this.system);
                }
                case 351608024: {
                    return new Property(ExpansionProfile.SP_VERSION, "string", "The version of the code system from which codes in the expansion should be included.", 0, 1, this.version);
                }
                case 0x3339A3: {
                    return new Property("mode", "code", "How to manage the intersection between a fixed version in a value set, and this fixed version of the system in the expansion profile.", 0, 1, this.mode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.system;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.mode;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    this.system = this.castToUri(value);
                    return value;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    return value;
                }
                case 0x3339A3: {
                    value = new SystemVersionProcessingModeEnumFactory().fromType(this.castToCode(value));
                    this.mode = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = this.castToUri(value);
            } else if (name.equals(ExpansionProfile.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals("mode")) {
                value = new SystemVersionProcessingModeEnumFactory().fromType(this.castToCode(value));
                this.mode = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return this.getSystemElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return new String[]{"uri"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 0x3339A3: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.system");
            }
            if (name.equals(ExpansionProfile.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.version");
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExpansionProfile.mode");
            }
            return super.addChild(name);
        }

        @Override
        public ExpansionProfileFixedVersionComponent copy() {
            ExpansionProfileFixedVersionComponent dst = new ExpansionProfileFixedVersionComponent();
            this.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExpansionProfileFixedVersionComponent)) {
                return false;
            }
            ExpansionProfileFixedVersionComponent o = (ExpansionProfileFixedVersionComponent)other_;
            return ExpansionProfileFixedVersionComponent.compareDeep(this.system, o.system, true) && ExpansionProfileFixedVersionComponent.compareDeep(this.version, o.version, true) && ExpansionProfileFixedVersionComponent.compareDeep(this.mode, o.mode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExpansionProfileFixedVersionComponent)) {
                return false;
            }
            ExpansionProfileFixedVersionComponent o = (ExpansionProfileFixedVersionComponent)other_;
            return ExpansionProfileFixedVersionComponent.compareValues(this.system, o.system, true) && ExpansionProfileFixedVersionComponent.compareValues(this.version, o.version, true) && ExpansionProfileFixedVersionComponent.compareValues(this.mode, o.mode, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.system, this.version, this.mode});
        }

        @Override
        public String fhirType() {
            return "ExpansionProfile.fixedVersion";
        }
    }

    public static class SystemVersionProcessingModeEnumFactory
    implements EnumFactory<SystemVersionProcessingMode> {
        @Override
        public SystemVersionProcessingMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("default".equals(codeString)) {
                return SystemVersionProcessingMode.DEFAULT;
            }
            if ("check".equals(codeString)) {
                return SystemVersionProcessingMode.CHECK;
            }
            if ("override".equals(codeString)) {
                return SystemVersionProcessingMode.OVERRIDE;
            }
            throw new IllegalArgumentException("Unknown SystemVersionProcessingMode code '" + codeString + "'");
        }

        public Enumeration<SystemVersionProcessingMode> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SystemVersionProcessingMode>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("default".equals(codeString)) {
                return new Enumeration<SystemVersionProcessingMode>(this, SystemVersionProcessingMode.DEFAULT);
            }
            if ("check".equals(codeString)) {
                return new Enumeration<SystemVersionProcessingMode>(this, SystemVersionProcessingMode.CHECK);
            }
            if ("override".equals(codeString)) {
                return new Enumeration<SystemVersionProcessingMode>(this, SystemVersionProcessingMode.OVERRIDE);
            }
            throw new FHIRException("Unknown SystemVersionProcessingMode code '" + codeString + "'");
        }

        @Override
        public String toCode(SystemVersionProcessingMode code) {
            if (code == SystemVersionProcessingMode.NULL) {
                return null;
            }
            if (code == SystemVersionProcessingMode.DEFAULT) {
                return "default";
            }
            if (code == SystemVersionProcessingMode.CHECK) {
                return "check";
            }
            if (code == SystemVersionProcessingMode.OVERRIDE) {
                return "override";
            }
            return "?";
        }

        @Override
        public String toSystem(SystemVersionProcessingMode code) {
            return code.getSystem();
        }
    }

    public static enum SystemVersionProcessingMode {
        DEFAULT,
        CHECK,
        OVERRIDE,
        NULL;


        public static SystemVersionProcessingMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("default".equals(codeString)) {
                return DEFAULT;
            }
            if ("check".equals(codeString)) {
                return CHECK;
            }
            if ("override".equals(codeString)) {
                return OVERRIDE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SystemVersionProcessingMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DEFAULT: {
                    return "default";
                }
                case CHECK: {
                    return "check";
                }
                case OVERRIDE: {
                    return "override";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DEFAULT: {
                    return "http://hl7.org/fhir/system-version-processing-mode";
                }
                case CHECK: {
                    return "http://hl7.org/fhir/system-version-processing-mode";
                }
                case OVERRIDE: {
                    return "http://hl7.org/fhir/system-version-processing-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DEFAULT: {
                    return "Use this version of the code system if a value set doesn't specify a version";
                }
                case CHECK: {
                    return "Use this version of the code system. If a value set specifies a different version, the expansion operation should fail";
                }
                case OVERRIDE: {
                    return "Use this version of the code system irrespective of which version is specified by a value set. Note that this has obvious safety issues, in that it may result in a value set expansion giving a different list of codes that is both wrong and unsafe, and implementers should only use this capability reluctantly. It primarily exists to deal with situations where specifications have fallen into decay as time passes. If a  version is override, the version used SHALL explicitly be represented in the expansion parameters";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DEFAULT: {
                    return "Default Version";
                }
                case CHECK: {
                    return "Check ValueSet Version";
                }
                case OVERRIDE: {
                    return "Override ValueSet Version";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

