/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ActionSelectionBehavior;

public class ActionSelectionBehaviorEnumFactory
implements EnumFactory<ActionSelectionBehavior> {
    @Override
    public ActionSelectionBehavior fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("any".equals(codeString)) {
            return ActionSelectionBehavior.ANY;
        }
        if ("all".equals(codeString)) {
            return ActionSelectionBehavior.ALL;
        }
        if ("all-or-none".equals(codeString)) {
            return ActionSelectionBehavior.ALLORNONE;
        }
        if ("exactly-one".equals(codeString)) {
            return ActionSelectionBehavior.EXACTLYONE;
        }
        if ("at-most-one".equals(codeString)) {
            return ActionSelectionBehavior.ATMOSTONE;
        }
        if ("one-or-more".equals(codeString)) {
            return ActionSelectionBehavior.ONEORMORE;
        }
        throw new IllegalArgumentException("Unknown ActionSelectionBehavior code '" + codeString + "'");
    }

    @Override
    public String toCode(ActionSelectionBehavior code) {
        if (code == ActionSelectionBehavior.NULL) {
            return null;
        }
        if (code == ActionSelectionBehavior.ANY) {
            return "any";
        }
        if (code == ActionSelectionBehavior.ALL) {
            return "all";
        }
        if (code == ActionSelectionBehavior.ALLORNONE) {
            return "all-or-none";
        }
        if (code == ActionSelectionBehavior.EXACTLYONE) {
            return "exactly-one";
        }
        if (code == ActionSelectionBehavior.ATMOSTONE) {
            return "at-most-one";
        }
        if (code == ActionSelectionBehavior.ONEORMORE) {
            return "one-or-more";
        }
        return "?";
    }

    @Override
    public String toSystem(ActionSelectionBehavior code) {
        return code.getSystem();
    }
}

