/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.EventStatus;

public class EventStatusEnumFactory
implements EnumFactory<EventStatus> {
    @Override
    public EventStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("preparation".equals(codeString)) {
            return EventStatus.PREPARATION;
        }
        if ("in-progress".equals(codeString)) {
            return EventStatus.INPROGRESS;
        }
        if ("suspended".equals(codeString)) {
            return EventStatus.SUSPENDED;
        }
        if ("aborted".equals(codeString)) {
            return EventStatus.ABORTED;
        }
        if ("completed".equals(codeString)) {
            return EventStatus.COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return EventStatus.ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return EventStatus.UNKNOWN;
        }
        throw new IllegalArgumentException("Unknown EventStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(EventStatus code) {
        if (code == EventStatus.NULL) {
            return null;
        }
        if (code == EventStatus.PREPARATION) {
            return "preparation";
        }
        if (code == EventStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == EventStatus.SUSPENDED) {
            return "suspended";
        }
        if (code == EventStatus.ABORTED) {
            return "aborted";
        }
        if (code == EventStatus.COMPLETED) {
            return "completed";
        }
        if (code == EventStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        if (code == EventStatus.UNKNOWN) {
            return "unknown";
        }
        return "?";
    }

    @Override
    public String toSystem(EventStatus code) {
        return code.getSystem();
    }
}

