/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.IdentifierType;

public class IdentifierTypeEnumFactory
implements EnumFactory<IdentifierType> {
    @Override
    public IdentifierType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("UDI".equals(codeString)) {
            return IdentifierType.UDI;
        }
        if ("SNO".equals(codeString)) {
            return IdentifierType.SNO;
        }
        if ("SB".equals(codeString)) {
            return IdentifierType.SB;
        }
        if ("PLAC".equals(codeString)) {
            return IdentifierType.PLAC;
        }
        if ("FILL".equals(codeString)) {
            return IdentifierType.FILL;
        }
        throw new IllegalArgumentException("Unknown IdentifierType code '" + codeString + "'");
    }

    @Override
    public String toCode(IdentifierType code) {
        if (code == IdentifierType.NULL) {
            return null;
        }
        if (code == IdentifierType.UDI) {
            return "UDI";
        }
        if (code == IdentifierType.SNO) {
            return "SNO";
        }
        if (code == IdentifierType.SB) {
            return "SB";
        }
        if (code == IdentifierType.PLAC) {
            return "PLAC";
        }
        if (code == IdentifierType.FILL) {
            return "FILL";
        }
        return "?";
    }

    @Override
    public String toSystem(IdentifierType code) {
        return code.getSystem();
    }
}

