/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MeasurePopulation {
    INITIALPOPULATION,
    NUMERATOR,
    NUMERATOREXCLUSION,
    DENOMINATOR,
    DENOMINATOREXCLUSION,
    DENOMINATOREXCEPTION,
    MEASUREPOPULATION,
    MEASUREPOPULATIONEXCLUSION,
    MEASUREOBSERVATION,
    NULL;


    public static MeasurePopulation fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("initial-population".equals(codeString)) {
            return INITIALPOPULATION;
        }
        if ("numerator".equals(codeString)) {
            return NUMERATOR;
        }
        if ("numerator-exclusion".equals(codeString)) {
            return NUMERATOREXCLUSION;
        }
        if ("denominator".equals(codeString)) {
            return DENOMINATOR;
        }
        if ("denominator-exclusion".equals(codeString)) {
            return DENOMINATOREXCLUSION;
        }
        if ("denominator-exception".equals(codeString)) {
            return DENOMINATOREXCEPTION;
        }
        if ("measure-population".equals(codeString)) {
            return MEASUREPOPULATION;
        }
        if ("measure-population-exclusion".equals(codeString)) {
            return MEASUREPOPULATIONEXCLUSION;
        }
        if ("measure-observation".equals(codeString)) {
            return MEASUREOBSERVATION;
        }
        throw new FHIRException("Unknown MeasurePopulation code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INITIALPOPULATION: {
                return "initial-population";
            }
            case NUMERATOR: {
                return "numerator";
            }
            case NUMERATOREXCLUSION: {
                return "numerator-exclusion";
            }
            case DENOMINATOR: {
                return "denominator";
            }
            case DENOMINATOREXCLUSION: {
                return "denominator-exclusion";
            }
            case DENOMINATOREXCEPTION: {
                return "denominator-exception";
            }
            case MEASUREPOPULATION: {
                return "measure-population";
            }
            case MEASUREPOPULATIONEXCLUSION: {
                return "measure-population-exclusion";
            }
            case MEASUREOBSERVATION: {
                return "measure-observation";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/measure-population";
    }

    public String getDefinition() {
        switch (this) {
            case INITIALPOPULATION: {
                return "The initial population refers to all patients or events to be evaluated by a quality measure involving patients who share a common set of specified characterstics. All patients or events counted (for example, as numerator, as denominator) are drawn from the initial population";
            }
            case NUMERATOR: {
                return "The upper portion of a fraction used to calculate a rate, proportion, or ratio. Also called the measure focus, it is the target process, condition, event, or outcome. Numerator criteria are the processes or outcomes expected for each patient, or event defined in the denominator. A numerator statement describes the clinical action that satisfies the conditions of the measure";
            }
            case NUMERATOREXCLUSION: {
                return "Numerator exclusion criteria define patients or events to be removed from the numerator. Numerator exclusions are used in proportion and ratio measures to help narrow the numerator (for inverted measures)";
            }
            case DENOMINATOR: {
                return "The lower portion of a fraction used to calculate a rate, proportion, or ratio. The denominator can be the same as the initial population, or a subset of the initial population to further constrain the population for the purpose of the measure";
            }
            case DENOMINATOREXCLUSION: {
                return "Denominator exclusion criteria define patients or events that should be removed from the denominator before determining if numerator criteria are met. Denominator exclusions are used in proportion and ratio measures to help narrow the denominator. For example, patients with bilateral lower extremity amputations would be listed as a denominator exclusion for a measure requiring foot exams";
            }
            case DENOMINATOREXCEPTION: {
                return "Denominator exceptions are conditions that should remove a patient or event from the denominator of a measure only if the numerator criteria are not met. Denominator exception allows for adjustment of the calculated score for those providers with higher risk populations. Denominator exception criteria are only used in proportion measures";
            }
            case MEASUREPOPULATION: {
                return "Measure population criteria define the patients or events for which the individual observation for the measure should be taken. Measure populations are used for continuous variable measures rather than numerator and denominator criteria";
            }
            case MEASUREPOPULATIONEXCLUSION: {
                return "Measure population criteria define the patients or events that should be removed from the measure population before determining the outcome of one or more continuous variables defined for the measure observation. Measure population exclusion criteria are used within continuous variable measures to help narrow the measure population";
            }
            case MEASUREOBSERVATION: {
                return "Defines the individual observation to be performed for each patient or event in the measure population. Measure observations for each case in the population are aggregated to determine the overall measure score for the population";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INITIALPOPULATION: {
                return "Initial Population";
            }
            case NUMERATOR: {
                return "Numerator";
            }
            case NUMERATOREXCLUSION: {
                return "Numerator Exclusion";
            }
            case DENOMINATOR: {
                return "Denominator";
            }
            case DENOMINATOREXCLUSION: {
                return "Denominator Exclusion";
            }
            case DENOMINATOREXCEPTION: {
                return "Denominator Exception";
            }
            case MEASUREPOPULATION: {
                return "Measure Population";
            }
            case MEASUREPOPULATIONEXCLUSION: {
                return "Measure Population Exclusion";
            }
            case MEASUREOBSERVATION: {
                return "Measure Observation";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

