/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.terminologies;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.Factory;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.CodeSystemUtilities;
import org.hl7.fhir.dstu3.terminologies.ValueSetCheckerSimple;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.utilities.Utilities;

@Deprecated
public class ValueSetExpanderSimple
implements ValueSetExpander {
    private List<ValueSet.ValueSetExpansionContainsComponent> codes = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
    private List<ValueSet.ValueSetExpansionContainsComponent> roots = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
    private Map<String, ValueSet.ValueSetExpansionContainsComponent> map = new HashMap<String, ValueSet.ValueSetExpansionContainsComponent>();
    private IWorkerContext context;
    private boolean canBeHierarchy = true;
    private Set<String> excludeKeys = new HashSet<String>();
    private Set<String> excludeSystems = new HashSet<String>();
    private ValueSetExpanderFactory factory;
    private ValueSet focus;
    private int maxExpansionSize = 500;
    private int total;

    public ValueSetExpanderSimple(IWorkerContext context, ValueSetExpanderFactory factory) {
        this.context = context;
        this.factory = factory;
    }

    public void setMaxExpansionSize(int theMaxExpansionSize) {
        this.maxExpansionSize = theMaxExpansionSize;
    }

    private ValueSet.ValueSetExpansionContainsComponent addCode(String system, String code, String display, ValueSet.ValueSetExpansionContainsComponent parent, List<CodeSystem.ConceptDefinitionDesignationComponent> designations, ExpansionProfile profile, boolean isAbstract, boolean inactive, List<ValueSet> filters) {
        CodeSystem.ConceptDefinitionDesignationComponent t;
        if (filters != null && !filters.isEmpty() && !this.filterContainsCode(filters, system, code)) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(system);
        n.setCode(code);
        if (isAbstract) {
            n.setAbstract(true);
        }
        if (inactive) {
            n.setInactive(true);
        }
        if (profile.getIncludeDesignations() && designations != null) {
            for (CodeSystem.ConceptDefinitionDesignationComponent t2 : designations) {
                ToolingExtensions.addLanguageTranslation(n, t2.getLanguage(), t2.getValue());
            }
        }
        CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent = t = profile.hasLanguage() ? this.getMatchingLang(designations, profile.getLanguage()) : null;
        if (t == null) {
            n.setDisplay(display);
        } else {
            n.setDisplay(t.getValue());
        }
        String s = this.key(n);
        if (this.map.containsKey(s) || this.excludeKeys.contains(s)) {
            this.canBeHierarchy = false;
        } else {
            this.codes.add(n);
            this.map.put(s, n);
            ++this.total;
        }
        if (this.canBeHierarchy && parent != null) {
            parent.getContains().add(n);
        } else {
            this.roots.add(n);
        }
        return n;
    }

    private boolean filterContainsCode(List<ValueSet> filters, String system, String code) {
        for (ValueSet vse : filters) {
            if (!this.expansionContainsCode(vse.getExpansion().getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean expansionContainsCode(List<ValueSet.ValueSetExpansionContainsComponent> contains, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (system.equals(cc.getSystem()) && code.equals(cc.getCode())) {
                return true;
            }
            if (!this.expansionContainsCode(cc.getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private CodeSystem.ConceptDefinitionDesignationComponent getMatchingLang(List<CodeSystem.ConceptDefinitionDesignationComponent> list, String lang) {
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!t.getLanguage().equals(lang)) continue;
            return t;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!t.getLanguage().startsWith(lang)) continue;
            return t;
        }
        return null;
    }

    private void addCodeAndDescendents(CodeSystem cs, String system, CodeSystem.ConceptDefinitionComponent def, ValueSet.ValueSetExpansionContainsComponent parent, ExpansionProfile profile, List<ValueSet> filters) throws FHIRException {
        if (!CodeSystemUtilities.isDeprecated(cs, def)) {
            ValueSet.ValueSetExpansionContainsComponent np = null;
            boolean abs = CodeSystemUtilities.isNotSelectable(cs, def);
            boolean inc = CodeSystemUtilities.isInactive(cs, def);
            if (this.canBeHierarchy || !abs) {
                np = this.addCode(system, def.getCode(), def.getDisplay(), parent, def.getDesignation(), profile, abs, inc, filters);
            }
            for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
                this.addCodeAndDescendents(cs, system, c, np, profile, filters);
            }
        } else {
            for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
                this.addCodeAndDescendents(cs, system, c, null, profile, filters);
            }
        }
    }

    private void addCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params, ExpansionProfile profile, List<ValueSet> filters) throws ValueSetExpander.ETooCostly {
        if (expand.getContains().size() > this.maxExpansionSize) {
            throw new ValueSetExpander.ETooCostly("Too many codes to display (>" + Integer.toString(expand.getContains().size()) + ")");
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : expand.getParameter()) {
            if (this.existsInParams(params, p.getName(), p.getValue())) continue;
            params.add(p);
        }
        this.copyImportContains(expand.getContains(), null, profile, filters);
    }

    private void excludeCode(String theSystem, String theCode) {
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(theSystem);
        n.setCode(theCode);
        String s = this.key(n);
        this.excludeKeys.add(s);
    }

    private void excludeCodes(ValueSet.ConceptSetComponent exc, List<ValueSet.ValueSetExpansionParameterComponent> params) throws TerminologyServiceException {
        if (exc.hasSystem() && exc.getConcept().size() == 0 && exc.getFilter().size() == 0) {
            this.excludeSystems.add(exc.getSystem());
        }
        if (exc.hasValueSet()) {
            throw new Error("Processing Value set references in exclude is not yet done");
        }
        CodeSystem cs = this.context.fetchCodeSystem(exc.getSystem());
        if ((cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) && this.context.supportsSystem(exc.getSystem())) {
            this.excludeCodes(this.context.expandVS(exc, false), params);
            return;
        }
        for (ValueSet.ConceptReferenceComponent c : exc.getConcept()) {
            this.excludeCode(exc.getSystem(), c.getCode());
        }
        if (exc.getFilter().size() > 0) {
            throw new NotImplementedException("not done yet");
        }
    }

    private void excludeCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params) {
        for (ValueSet.ValueSetExpansionContainsComponent c : expand.getContains()) {
            this.excludeCode(c.getSystem(), c.getCode());
        }
    }

    private boolean existsInParams(List<ValueSet.ValueSetExpansionParameterComponent> params, String name, Type value) {
        for (ValueSet.ValueSetExpansionParameterComponent p : params) {
            if (!p.getName().equals(name) || !PrimitiveType.compareDeep(p.getValue(), value, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet source, ExpansionProfile profile) {
        if (profile == null) {
            profile = this.makeDefaultExpansion();
        }
        try {
            this.focus = source.copy();
            this.focus.setExpansion(new ValueSet.ValueSetExpansionComponent());
            this.focus.getExpansion().setTimestampElement(DateTimeType.now());
            this.focus.getExpansion().setIdentifier(Factory.createUUID());
            if (!profile.getUrl().startsWith("urn:uuid:")) {
                this.focus.getExpansion().addParameter().setName("profile").setValue(new UriType(profile.getUrl()));
            }
            if (source.hasCompose()) {
                this.handleCompose(source.getCompose(), this.focus.getExpansion().getParameter(), profile);
            }
            if (this.canBeHierarchy) {
                for (ValueSet.ValueSetExpansionContainsComponent c : this.roots) {
                    this.focus.getExpansion().getContains().add(c);
                }
            } else {
                for (ValueSet.ValueSetExpansionContainsComponent c : this.codes) {
                    if (!this.map.containsKey(this.key(c)) || c.getAbstract()) continue;
                    this.focus.getExpansion().getContains().add(c);
                    c.getContains().clear();
                }
            }
            if (this.total > 0) {
                this.focus.getExpansion().setTotal(this.total);
            }
            return new ValueSetExpander.ValueSetExpansionOutcome(this.focus);
        }
        catch (NoTerminologyServiceException e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(new ValueSetCheckerSimple(source, this.factory, this.context), e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(new ValueSetCheckerSimple(source, this.factory, this.context), e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
        }
    }

    private ExpansionProfile makeDefaultExpansion() {
        ExpansionProfile res = new ExpansionProfile();
        res.setUrl("urn:uuid:" + UUID.randomUUID().toString().toLowerCase());
        res.setExcludeNested(true);
        res.setIncludeDesignations(false);
        return res;
    }

    private String getCodeDisplay(CodeSystem cs, String code) throws TerminologyServiceException {
        CodeSystem.ConceptDefinitionComponent def = this.getConceptForCode(cs.getConcept(), code);
        if (def == null) {
            throw new TerminologyServiceException("Unable to find code '" + code + "' in code system " + cs.getUrl());
        }
        return def.getDisplay();
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> clist, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : clist) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private void handleCompose(ValueSet.ValueSetComposeComponent compose, List<ValueSet.ValueSetExpansionParameterComponent> params, ExpansionProfile profile) throws ValueSetExpander.ETooCostly, FileNotFoundException, IOException, FHIRException {
        for (ValueSet.ConceptSetComponent inc : compose.getExclude()) {
            this.excludeCodes(inc, params);
        }
        this.canBeHierarchy = !profile.getExcludeNested() && this.excludeKeys.isEmpty() && this.excludeSystems.isEmpty();
        boolean first = true;
        for (ValueSet.ConceptSetComponent inc : compose.getInclude()) {
            if (first) {
                first = false;
            } else {
                this.canBeHierarchy = false;
            }
            this.includeCodes(inc, params, profile);
        }
    }

    private ValueSet importValueSet(String value, List<ValueSet.ValueSetExpansionParameterComponent> params, ExpansionProfile profile) throws ValueSetExpander.ETooCostly, TerminologyServiceException, FileNotFoundException, IOException, FHIRFormatError {
        if (value == null) {
            throw new TerminologyServiceException("unable to find value set with no identity");
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, value);
        if (vs == null) {
            throw new TerminologyServiceException("Unable to find imported value set " + value);
        }
        ValueSetExpander.ValueSetExpansionOutcome vso = this.factory.getExpander().expand(vs, profile);
        if (vso.getError() != null) {
            throw new TerminologyServiceException("Unable to expand imported value set: " + vso.getError());
        }
        if (vso.getService() != null) {
            throw new TerminologyServiceException("Unable to expand imported value set " + value);
        }
        if (vs.hasVersion() && !this.existsInParams(params, "version", new UriType(vs.getUrl() + "|" + vs.getVersion()))) {
            params.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(vs.getUrl() + "|" + vs.getVersion())));
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(params, p.getName(), p.getValue())) continue;
            params.add(p);
        }
        this.canBeHierarchy = false;
        return vso.getValueset();
    }

    private void copyImportContains(List<ValueSet.ValueSetExpansionContainsComponent> list, ValueSet.ValueSetExpansionContainsComponent parent, ExpansionProfile profile, List<ValueSet> filter) {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            ValueSet.ValueSetExpansionContainsComponent np = this.addCode(c.getSystem(), c.getCode(), c.getDisplay(), parent, null, profile, c.getAbstract(), c.getInactive(), filter);
            this.copyImportContains(c.getContains(), np, profile, filter);
        }
    }

    private void includeCodes(ValueSet.ConceptSetComponent inc, List<ValueSet.ValueSetExpansionParameterComponent> params, ExpansionProfile profile) throws ValueSetExpander.ETooCostly, FileNotFoundException, IOException, FHIRException {
        ArrayList<ValueSet> imports = new ArrayList<ValueSet>();
        for (UriType uriType : inc.getValueSet()) {
            imports.add(this.importValueSet((String)uriType.getValue(), params, profile));
        }
        if (!inc.hasSystem()) {
            if (imports.isEmpty()) {
                return;
            }
            ValueSet base = (ValueSet)imports.get(0);
            imports.remove(0);
            this.copyImportContains(base.getExpansion().getContains(), null, profile, imports);
        } else {
            CodeSystem cs = this.context.fetchCodeSystem(inc.getSystem());
            if ((cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) && this.context.supportsSystem(inc.getSystem())) {
                this.addCodes(this.context.expandVS(inc, this.canBeHierarchy), params, profile, imports);
                return;
            }
            if (cs == null) {
                if (this.context.isNoTerminologyServer()) {
                    throw new NoTerminologyServiceException("unable to find code system " + inc.getSystem().toString());
                }
                throw new TerminologyServiceException("unable to find code system " + inc.getSystem().toString());
            }
            if (cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
                throw new TerminologyServiceException("Code system " + inc.getSystem().toString() + " is incomplete");
            }
            if (cs.hasVersion() && !this.existsInParams(params, "version", new UriType(cs.getUrl() + "|" + cs.getVersion()))) {
                params.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(cs.getUrl() + "|" + cs.getVersion())));
            }
            if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
                for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                    this.addCodeAndDescendents(cs, inc.getSystem(), def, null, profile, imports);
                }
            }
            if (!inc.getConcept().isEmpty()) {
                this.canBeHierarchy = false;
                for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                    this.addCode(inc.getSystem(), c.getCode(), Utilities.noString((String)c.getDisplay()) ? this.getCodeDisplay(cs, c.getCode()) : c.getDisplay(), null, this.convertDesignations(c.getDesignation()), profile, false, CodeSystemUtilities.isInactive(cs, c.getCode()), imports);
                }
            }
            if (inc.getFilter().size() > 1) {
                this.canBeHierarchy = false;
                throw new TerminologyServiceException("Multiple filters not handled yet");
            }
            if (inc.getFilter().size() == 1) {
                CodeSystem.ConceptDefinitionComponent def;
                ValueSet.ConceptSetFilterComponent conceptSetFilterComponent = inc.getFilter().get(0);
                if ("concept".equals(conceptSetFilterComponent.getProperty()) && conceptSetFilterComponent.getOp() == ValueSet.FilterOperator.ISA) {
                    def = this.getConceptForCode(cs.getConcept(), conceptSetFilterComponent.getValue());
                    if (def == null) {
                        throw new TerminologyServiceException("Code '" + conceptSetFilterComponent.getValue() + "' not found in system '" + inc.getSystem() + "'");
                    }
                    this.addCodeAndDescendents(cs, inc.getSystem(), def, null, profile, imports);
                } else if ("concept".equals(conceptSetFilterComponent.getProperty()) && conceptSetFilterComponent.getOp() == ValueSet.FilterOperator.DESCENDENTOF) {
                    def = this.getConceptForCode(cs.getConcept(), conceptSetFilterComponent.getValue());
                    if (def == null) {
                        throw new TerminologyServiceException("Code '" + conceptSetFilterComponent.getValue() + "' not found in system '" + inc.getSystem() + "'");
                    }
                    for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
                        this.addCodeAndDescendents(cs, inc.getSystem(), c, null, profile, imports);
                    }
                } else if ("display".equals(conceptSetFilterComponent.getProperty()) && conceptSetFilterComponent.getOp() == ValueSet.FilterOperator.EQUAL) {
                    this.canBeHierarchy = false;
                    def = this.getConceptForCode(cs.getConcept(), conceptSetFilterComponent.getValue());
                    if (def != null && StringUtils.isNotBlank((CharSequence)def.getDisplay()) && StringUtils.isNotBlank((CharSequence)conceptSetFilterComponent.getValue()) && def.getDisplay().contains(conceptSetFilterComponent.getValue())) {
                        this.addCode(inc.getSystem(), def.getCode(), def.getDisplay(), null, def.getDesignation(), profile, CodeSystemUtilities.isNotSelectable(cs, def), CodeSystemUtilities.isInactive(cs, def), imports);
                    }
                } else {
                    throw new NotImplementedException("Search by property[" + conceptSetFilterComponent.getProperty() + "] and op[" + conceptSetFilterComponent.getOp() + "] is not supported yet");
                }
            }
        }
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> convertDesignations(List<ValueSet.ConceptReferenceDesignationComponent> list) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> res = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        for (ValueSet.ConceptReferenceDesignationComponent t : list) {
            CodeSystem.ConceptDefinitionDesignationComponent c = new CodeSystem.ConceptDefinitionDesignationComponent();
            c.setLanguage(t.getLanguage());
            c.setUse(t.getUse());
            c.setValue(t.getValue());
        }
        return res;
    }

    private String key(String uri, String code) {
        return "{" + uri + "}" + code;
    }

    private String key(ValueSet.ValueSetExpansionContainsComponent c) {
        return this.key(c.getSystem(), c.getCode());
    }
}

