/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

@Deprecated
public class R3TEchnicalCorrectionProcessor {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        new R3TEchnicalCorrectionProcessor().execute(args[0], args[1]);
    }

    private void execute(String src, String packageRoot) throws FileNotFoundException, IOException {
        System.out.println("Loading resources from " + src);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        HashMap<String, Resource> definitions = new HashMap<String, Resource>();
        for (File f : ManagedFileAccess.file((String)src).listFiles()) {
            if (f.getName().endsWith(".xml") && !f.getName().endsWith("warnings.xml") && !f.getName().endsWith(".diff.xml")) {
                try {
                    Resource r = new XmlParser().parse(ManagedFileAccess.inStream((File)f));
                    if (f.getName().contains("canonical")) {
                        resources.add(r);
                    }
                    if (Utilities.existsInList((String)f.getName(), (String[])new String[]{"conceptmaps.xml", "dataelements.xml", "extension-definitions.xml", "profiles-others.xml", "profiles-resources.xml", "profiles-types.xml", "search-parameters.xml", "v2-tables.xml", "v3-codesystems.xml", "valuesets.xml"})) {
                        definitions.put(f.getName(), r);
                    }
                    r.setUserData("path", f.getName().substring(0, f.getName().indexOf(".")));
                }
                catch (Exception e) {
                    System.out.println("Unable to load " + f.getName() + ": " + e.getMessage());
                }
            }
            if (f.getName().endsWith(".json") && !f.getName().endsWith("schema.json") && f.getName().endsWith(".diff.json")) continue;
        }
        System.out.println(Integer.toString(resources.size()) + " resources");
        System.out.println(Integer.toString(definitions.size()) + " resources");
        this.produceExamplesXml(resources, src);
        this.produceDefinitionsXml(definitions, src);
        this.produceExamplesJson(resources, src);
        this.produceDefinitionsJson(definitions, src);
        for (Resource r : definitions.values()) {
            if (!(r instanceof Bundle)) continue;
            Bundle bnd = (Bundle)r;
            for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
                resources.add(be.getResource());
            }
        }
        this.extractToPackageMaster(resources, packageRoot);
        System.out.println("Done");
    }

    private void produceDefinitionsXml(Map<String, Resource> definitions, String dest) throws IOException {
        for (String n : definitions.keySet()) {
            File f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{dest, "definitions.xml", n}));
            new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((File)f), definitions.get(n));
        }
    }

    private void produceDefinitionsJson(Map<String, Resource> definitions, String dest) throws IOException {
        for (String n : definitions.keySet()) {
            File f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{dest, "definitions.json", FileUtilities.changeFileExt((String)n, (String)".json")}));
            new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((File)f), definitions.get(n));
        }
    }

    private void produceExamplesJson(List<Resource> resources, String dest) throws FileNotFoundException, IOException {
        for (Resource r : resources) {
            String n = r.fhirType().toLowerCase() + "-" + r.getUserString("path");
            if (!r.getId().equals(r.getUserString("path"))) {
                n = n + "(" + r.getId() + ")";
            }
            File f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{dest, "examples-json", n + ".json"}));
            new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((File)f), r);
        }
    }

    private void produceExamplesXml(List<Resource> resources, String dest) throws FileNotFoundException, IOException {
        for (Resource r : resources) {
            String n = r.fhirType().toLowerCase() + "-" + r.getUserString("path");
            if (!r.getId().equals(r.getUserString("path"))) {
                n = n + "(" + r.getId() + ")";
            }
            File f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{dest, "examples", n + ".xml"}));
            new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((File)f), r);
        }
    }

    private void extractToPackageMaster(List<Resource> list, String root) throws IOException, FHIRFormatError {
        System.out.println("Updating Packages Master");
        String corePath = Utilities.path((String[])new String[]{root, "hl7.fhir.r3.core", "package"});
        String examplesPath = Utilities.path((String[])new String[]{root, "hl7.fhir.r3.examples", "package"});
        String elementsPath = Utilities.path((String[])new String[]{root, "hl7.fhir.r3.elements", "package"});
        int coreTotal = ManagedFileAccess.file((String)corePath).list().length - 1;
        int examplesTotal = ManagedFileAccess.file((String)examplesPath).list().length - 1;
        int elementsTotal = ManagedFileAccess.file((String)elementsPath).list().length - 1;
        int coreCount = 0;
        int examplesCount = 0;
        int elementsCount = 0;
        for (Resource r : list) {
            String n = r.fhirType() + "-" + r.getId() + ".json";
            FileOutputStream dst = null;
            if (n.startsWith("DataElement-")) {
                ++elementsCount;
                dst = ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{elementsPath, n}));
                new JsonParser().setOutputStyle(IParser.OutputStyle.NORMAL).compose(dst, r);
                continue;
            }
            dst = ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{examplesPath, n}));
            new JsonParser().setOutputStyle(IParser.OutputStyle.NORMAL).compose(dst, r);
            ++examplesCount;
            if (!this.isCoreResource(r.fhirType())) continue;
            ++coreCount;
            DomainResource dr = (DomainResource)r;
            dr.setText(null);
            new JsonParser().setOutputStyle(IParser.OutputStyle.NORMAL).compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{corePath, n})), r);
        }
        System.out.println("  Core @ " + corePath + ": Replaced " + coreCount + " of " + coreTotal);
        System.out.println("  Examples @ " + examplesPath + ": Replaced " + examplesCount + " of " + examplesTotal);
        System.out.println("  Elements @ " + elementsPath + ": Replaced " + elementsCount + " of " + elementsTotal);
    }

    private boolean isCoreResource(String rt) {
        return Utilities.existsInList((String)rt, (String[])new String[]{"CapabilityStatement", "CodeSystem", "CompartmentDefinition", "ConceptMap", "NamingSystem", "OperationDefinition", "SearchParameter", "StructureDefinition", "StructureMap", "ValueSet"});
    }
}

